unit uSCGCellParam;

interface

uses
  StrCGrid, Rubies;  

var
   cSCGCellParam: Tvalue;
   cSCGCellParams: Tvalue;

function ap_iSCGCellParam(real: TSCGCellParam; owner: Tvalue): Tvalue;
function ap_iSCGCellParams(real: TSCGCellParams; owner: Tvalue): Tvalue;
function ap_cCellParams: Tvalue;
procedure Init_SCGCellParam;

implementation

uses  SysUtils, StdCtrls, uDefUtils, Pythia, SCGHandle;


procedure SCGCellParam_setup(obj: Tvalue; real: TSCGCellParam);
begin
end;

function SCGCellParam_alloc(This: Tvalue; real: TSCGCellParam): Tvalue;
begin
   result := TmpAlloc(This, real);
   SCGCellParam_setup(result, real);
end;

function ap_iSCGCellParam(real: TSCGCellParam; owner: Tvalue): Tvalue;
begin
   result := SCGCellParam_alloc(cSCGCellParam, real);
   ap_owner(result, owner);
end;

function ap_iSCGCellParam_v(var AControl; owner: Tvalue): Tvalue;
begin
   result := ap_iSCGCellParam(TSCGCellParam(AControl), owner);
end;

function SCGCellParam_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellParam;
begin
   real := TSCGCellParam.Create(nil);
   result := ObjAlloc(This, real);
   SCGCellParam_setup(result, real);
   ap_obj_call_init(result, argc, argv);
end;
   
function ap_cCellParams: Tvalue;
begin
  result := cSCGCellParams;
end;

procedure SCGCellParams_setup(obj: Tvalue; real: TSCGCellParams);
begin
//   AssignPropMethod(real, [PhiGetHandle, SCGGetHandle]);
end;

function SCGCellParams_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [PhiGetHandle, SCGGetHandle]);
  result := Qnil;
end;

function SCGCellParams_alloc(This: Tvalue; real: TSCGCellParams): Tvalue;
begin
   result := TmpAlloc(This, real);
   SCGCellParams_setup(result, real);
end;

function ap_iSCGCellParams(real: TSCGCellParams; owner: Tvalue): Tvalue;
begin 
   result := SCGCellParams_alloc(cSCGCellParams, real);
   ap_owner(result, owner);
end;

function ap_iSCGCellParams_v(var AControl; owner: Tvalue): Tvalue;
begin 
   result := ap_iSCGCellParams(TSCGCellParams(AControl), owner);
end;

function SCGCellParams_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellParams;
begin
   real := TSCGCellParams.Create(nil);
   result := ObjAlloc(This, real);
   SCGCellParams_setup(result, real);
   ap_obj_call_init(result, argc, argv);
end;
   
function SCGCellParams_add(This: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellParams;
begin
   real := ap_data_get_struct(This);
   result := ap_iSCGCellParam(real.Add, This);
end;

function SCGCellParams_item_by_name(This, v: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellParams;
begin
   real := ap_data_get_struct(This);
   result := ap_iSCGCellParam(real.ItemByName(dl_String(v)), This);
end;

function SCGCellParams_item_by_pos(This, x, y: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellParams;
begin
   real := ap_data_get_struct(This);
   try
      result := ap_iSCGCellParam(real.ItemByPos(FIX2INT(x), FIX2INT(y)), This);
   except
      on ERangeError do
        result := Qnil;
   end;
end;

function SCGCellParams_get_items(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellParams;
   args: array of Tvalue;
begin
   if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);

   SetLength(args, argc);
   args := argv;
   real := ap_data_get_struct(This);
   result := ap_iSCGCellParam(real.Items[FIX2INT(args[0])], This);
end;
   
function SCGCellParams_set_items(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellParams;
   args: array of Tvalue;
begin
   if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
   SetLength(args, argc);
   args := argv;
   real := ap_data_get_struct(This);
   real.Items[FIX2INT(args[0])] := ap_data_get_struct(args[1]);
   result := args[1];
end;

function SCGCellParams_get_param(This, x: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellParams;
begin
   real := ap_data_get_struct(This);
   result := ap_iSCGCellParam(real.Items[FIX2INT(x)], This);
end;
   
function SCGCellParams_set_param(This, x, obj: Tvalue): Tvalue; cdecl;
var
   real: TSCGCellParams;
   font: TSCGCellParam;
begin
   real := ap_data_get_struct(This);
   ap_data_get_object(obj, TSCGCellParam, font);
   real.Items[FIX2INT(x)] := font;
   result := obj;
end;

procedure Init_SCGCellParam;
begin
   cSCGCellParam := DefinePersistentClass(ap_mPhi, TSCGCellParam, ap_cPersistent, ap_iSCGCellParam_v);
   DefineSingletonMethod(cSCGCellParam, 'new', SCGCellParam_new);
   // property Tag: integer

   cSCGCellParams := DefinePersistentClass(ap_mPhi, TSCGCellParams, ap_cPersistent, ap_iSCGCellParams_v);
   rb_define_method(cSCGCellParams, 'event_handle', @SCGCellParams_event_handle, 1);
   DefineSingletonMethod(cSCGCellParams, 'new', SCGCellParams_new);
   rb_define_method(cSCGCellParams, 'add', @SCGCellParams_add, 0);
   rb_define_method(cSCGCellParams, 'item_by_name', @SCGCellParams_item_by_name, 1);
   rb_define_method(cSCGCellParams, 'item_by_pos', @SCGCellParams_item_by_pos, 2);
   // Set ̕ɖ肠肩D
   DefineIndexer(cSCGCellParams, 'items', @SCGCellParams_get_items, @SCGCellParams_set_items);
//   rb_define_method(cSCGCellParams, 'get_param', @SCGCellParams_get_param, 1);
//   rb_define_method(cSCGCellParams, 'set_param', @SCGCellParams_set_param, 2);
end;

end.


