unit uDataSource;

interface

uses DB, Rubies;

var
  cDataSource: Tvalue;

function ap_cDataSource: Tvalue;
function ap_iDataSource(real: TDataSource; owner: Tvalue): Tvalue;
procedure Init_DataSource;

implementation

uses uDefUtils, Pythia, uRDB;

function ap_cDataSource: Tvalue;
begin
  result := cDataSource;
end;

procedure DataSource_setup(obj: Tvalue; real: TDataSource);
begin
//    AssignPropMethod(real, [handle]);
end;

function DataSource_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [handle]);
  result := Qnil;
end;

function DataSource_alloc(This: Tvalue; real: TDataSource): Tvalue;
begin
  result := ChildAlloc(This, real);
  DataSource_setup(result, real);
end;

function ap_iDataSource(real: TDataSource; owner: Tvalue): Tvalue;
begin
  result := DataSource_alloc(cDataSource, real);
  ap_owner(result, owner);
end;

function ap_iDataSource_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iDataSource(TDataSource(obj), owner)
end;

function DataSource_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TDataSource;
begin
  real := TDataSource.Create(nil);
  result := CompoAlloc(This, real);
  DataSource_setup(This, real);
end;

function DataSource_initialize(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TDataSource;
  args: array of Tvalue;
  DataSet: TDataSet;
begin
  real := ap_data_get_struct(This);
  if argc > 0 then
  begin
    SetLength(args, argc);
    args := argv;
    ap_data_get_object(args[0], TDataSet, DataSet);
    rb_iv_set(This, '@data_set', args[0]);
    real.DataSet := DataSet;
  end;
  rb_call_super(0, nil);
  result := This;
end;

function DataSource_set_data_set(This, v: Tvalue): Tvalue; cdecl;
var
  real: TDataSource;
  DataSet: TDataSet;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TDataSet, DataSet);
  rb_iv_set(This, '@data_set', v);
  real.DataSet := DataSet;
  result := v;
end;

function DataSource_get_data_set(This: Tvalue): Tvalue; cdecl;
begin
  result := rb_iv_get(This, '@data_set');
end;

procedure Init_DataSource;
begin
  cDataSource := DefinePersistentClass(mRDB, TDataSource, ap_cComponent, ap_iDataSource_v);
  rb_define_method(cDataSource, 'event_handle', @DataSource_event_handle, 1);
  rb_define_alloc_func(cDataSource, @DataSource_allocate);
  rb_define_private_method(cDataSource, 'initialize', @DataSource_initialize, -1);
  DefineAttrSet(cDataSource, 'data_set', DataSource_set_data_set);
  DefineAttrGet(cDataSource, 'data_set', DataSource_get_data_set);
end;

end.
