unit uDBRadioGroup;

interface

uses
  DB,
{$IFDEF VCL}
  DBCtrls,
{$ELSE}
  QDBCtrls,
{$ENDIF}
  Rubies;

type
  TPhi_DBRadioGroup = class(TDBRadioGroup)
//  published
//    property Text;
  end;

var
  cDBRadioGroup: Tvalue;

function ap_iDBRadioGroup(real: TPhi_DBRadioGroup; owner: Tvalue): Tvalue;
procedure Init_DBRadioGroup;

implementation

uses uDefUtils, Pythia, uRDB;

procedure DBRadioGroup_setup(obj: Tvalue; real: TPhi_DBRadioGroup);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle, PhiGetHandle]);
end;

function DBRadioGroup_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function DBRadioGroup_alloc(This: Tvalue; real: TPhi_DBRadioGroup): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBRadioGroup_setup(result, real);
end;

function ap_iDBRadioGroup(real: TPhi_DBRadioGroup; owner: Tvalue): Tvalue;
begin
  result := DBRadioGroup_alloc(cDBRadioGroup, real);
  ap_owner(result, owner);
end;

function ap_iDBRadioGroup_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDBRadioGroup(TPhi_DBRadioGroup(AControl), owner)
end;

function DBRadioGroup_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBRadioGroup;
begin
  real := TPhi_DBRadioGroup.Create(nil);
  result := CompoAlloc(This, real);
  DBRadioGroup_setup(result, real);
end;

function DBRadioGroup_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBRadioGroup;
  DataSource: TDataSource;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TDataSource, DataSource);
  real.DataSource := DataSource;
  result := v;
end;

function DBRadioGroup_set_data_field(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBRadioGroup;
begin
  real := ap_data_get_struct(This);
  real.DataField := dl_String(v);
  result := v;
end;

procedure Init_DBRadioGroup;
begin
  cDBRadioGroup := DefinePersistentClass(mRDB, TPhi_DBRadioGroup, ap_cRadioGroup, ap_iDBRadioGroup_v);
  rb_define_method(cDBRadioGroup, 'event_handle', @DBRadioGroup_event_handle, 1);
  rb_define_alloc_func(cDBRadioGroup, @DBRadioGroup_allocate);
  DefineAttrSet(cDBRadioGroup, 'data_source', DBRadioGroup_set_data_source);
  DefineAttrSet(cDBRadioGroup, 'data_field', DBRadioGroup_set_data_field);
end;

end.
