unit uDBLookupListBox;

interface

uses
  DB,
{$IFDEF VCL}
  DBCtrls,
{$ELSE}
  QDBCtrls,
{$ENDIF}
  Rubies;

type
  TPhi_DBLookupListBox = class(TDBLookupListBox)
//  published
//    property Text;
  end;

var
  cDBLookupListBox: Tvalue;

function ap_iDBLookupListBox(real: TPhi_DBLookupListBox; owner: Tvalue): Tvalue;
procedure Init_DBLookupListBox;

implementation

uses uDefUtils, Pythia, uRDB;

procedure DBLookupListBox_setup(obj: Tvalue; real: TPhi_DBLookupListBox);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle, PhiGetHandle]);
end;

function DBLookupListBox_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function DBLookupListBox_alloc(This: Tvalue; real: TPhi_DBLookupListBox): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBLookupListBox_setup(result, real);
end;

function ap_iDBLookupListBox(real: TPhi_DBLookupListBox; owner: Tvalue): Tvalue;
begin
  result := DBLookupListBox_alloc(cDBLookupListBox, real);
  ap_owner(result, owner);
end;

function ap_iDBLookupListBox_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDBLookupListBox(TPhi_DBLookupListBox(AControl), owner)
end;

function DBLookupListBox_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBLookupListBox;
begin
  real := TPhi_DBLookupListBox.Create(nil);
  result := CompoAlloc(This, real);
  DBLookupListBox_setup(result, real);
end;

function DBLookupListBox_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBLookupListBox;
  DataSource: TDataSource;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TDataSource, DataSource);
  real.DataSource := DataSource;
  result := v;
end;

function DBLookupListBox_set_data_field(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBLookupListBox;
begin
  real := ap_data_get_struct(This);
  real.DataField := dl_String(v);
  result := v;
end;

procedure Init_DBLookupListBox;
begin
  cDBLookupListBox := DefinePersistentClass(mRDB, TPhi_DBLookupListBox, ap_cWinControl, ap_iDBLookupListBox_v);
  rb_define_method(cDBLookupListBox, 'event_handle', @DBLookupListBox_event_handle, 1);
  rb_define_alloc_func(cDBLookupListBox, DBLookupListBox_allocate);
  DefineAttrSet(cDBLookupListBox, 'data_source', DBLookupListBox_set_data_source);
  DefineAttrSet(cDBLookupListBox, 'data_field', DBLookupListBox_set_data_field);
end;

end.
