unit uDBCtrlGrid;

interface

uses Rubies, DB, DBCGrids;

var
  cDBCtrlGrid: Tvalue;

function ap_iDBCtrlGrid(real: TDBCtrlGrid; owner: Tvalue): Tvalue;
procedure Init_DBCtrlGrid;

implementation

uses SysUtils, uDefUtils, Pythia, uRDB;

type
  TMyDBCtrlGrid = class(TDBCtrlGrid);

procedure DBCtrlGrid_setup(obj: Tvalue; real: TDBCtrlGrid);
begin
  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle, PhiGetHandle]);
end;

function DBCtrlGrid_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function DBCtrlGrid_alloc(This: Tvalue; real: TDBCtrlGrid): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBCtrlGrid_setup(result, real);
end;

function ap_iDBCtrlGrid(real: TDBCtrlGrid; owner: Tvalue): Tvalue;
begin
  result := DBCtrlGrid_alloc(cDBCtrlGrid, real);
  ap_owner(result, owner);
end;

function ap_iDBCtrlGrid_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDBCtrlGrid(TDBCtrlGrid(AControl), owner)
end;

function DBCtrlGrid_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TDBCtrlGrid;
begin
  real := TDBCtrlGrid.Create(nil);
  result := CompoAlloc(This, real);
  DBCtrlGrid_setup(result, real);
end;

procedure Init_DBCtrlGrid;
begin
  cDBCtrlGrid := DefinePersistentClass(mRDB, TDBCtrlGrid, ap_cCustomGrid, ap_iDBCtrlGrid_v);
  rb_define_method(cDBCtrlGrid, 'event_handle', @DBCtrlGrid_event_handle, 1);
  rb_define_alloc_func(cDBCtrlGrid, @DBCtrlGrid_allocate);
end;

end.
