unit uDBComboBox;

interface

uses
  DB,
{$IFDEF VCL}
  DBCtrls,
{$ELSE}
  QDBCtrls,
{$ENDIF}
  Rubies;

type
  TPhi_DBComboBox = class(TDBComboBox)
//  published
//    property Text;
  end;

var
  cDBComboBox: Tvalue;

function ap_iDBComboBox(real: TPhi_DBComboBox; owner: Tvalue): Tvalue;
procedure Init_DBComboBox;

implementation

uses uDefUtils, Pythia, uRDB;

procedure DBComboBox_setup(obj: Tvalue; real: TPhi_DBComboBox);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle, PhiGetHandle]);
end;

function DBComboBox_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function DBComboBox_alloc(This: Tvalue; real: TPhi_DBComboBox): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBComboBox_setup(result, real);
end;

function ap_iDBComboBox(real: TPhi_DBComboBox; owner: Tvalue): Tvalue;
begin
  result := DBComboBox_alloc(cDBComboBox, real);
  ap_owner(result, owner);
end;

function ap_iDBComboBox_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDBComboBox(TPhi_DBComboBox(AControl), owner)
end;

function DBComboBox_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBComboBox;
begin
  real := TPhi_DBComboBox.Create(nil);
  result := CompoAlloc(This, real);
  DBComboBox_setup(result, real);
end;

function DBComboBox_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBComboBox;
  DataSource: TDataSource;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TDataSource, DataSource);
  real.DataSource := DataSource;
  result := v;
end;

function DBComboBox_set_data_field(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBComboBox;
begin
  real := ap_data_get_struct(This);
  real.DataField := dl_String(v);
  result := v;
end;

procedure Init_DBComboBox;
begin
  cDBComboBox := DefinePersistentClass(mRDB, TPhi_DBComboBox, ap_cWinControl, ap_iDBComboBox_v);
  rb_define_method(cDBComboBox, 'event_handle', @DBComboBox_event_handle, 1);
  rb_define_alloc_func(cDBComboBox, @DBComboBox_allocate);
  DefineAttrSet(cDBComboBox, 'data_source', DBComboBox_set_data_source);
  DefineAttrSet(cDBComboBox, 'data_field', DBComboBox_set_data_field);
end;

end.
