unit uSession;

interface

uses Rubies, DBTables;

var
  cSession: Tvalue;
  vSession: Tvalue;

function ap_cSession: Tvalue;
function ap_vSession: Tvalue;
function ap_iSession(real: TSession; owner: Tvalue): Tvalue;
procedure Init_Session;

implementation

uses Classes, uDefUtils, Pythia, uDatabase, uRDBExt;

function dl_Session(This: Tvalue): TSession;
begin
  result := ap_data_get_struct(This);
end;

function ap_cSession: Tvalue;
begin
  result := cSession;
end;

function ap_vSession: Tvalue;
begin
  result := vSession;
end;

procedure Session_free(real: TSession); cdecl;
begin
  if real = nil then exit;
  if real.Active then real.Close;
  ChildFree(real);
end;

// ChildAlloc modified
function Session_alloc0(This: Tvalue; real: TSession): Tvalue;
begin
  if real = nil then begin result := Qnil; exit; end;
  result := rb_data_object_alloc(This, real, nil, @Session_free);
  rb_iv_set(result, '@events', rb_hash_new);
  real.tag := result;
end;

function Session_alloc(This: Tvalue; real: TSession): Tvalue;
begin
  result := TmpAlloc(This, real);
end;

function ap_iSession(real: TSession; owner: Tvalue): Tvalue;
begin
  result := Session_alloc(cSession, real);
  ap_owner(result, owner);
end;

function ap_iSession_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iSession(TSession(obj), owner)
end;

function Session_get_databases(This: Tvalue): Tvalue; cdecl;
var
  real: TSession;
  I: Integer;
  Database: TDatabase;
  v: Tvalue;
begin
  real := ap_data_get_struct(This);
  result := rb_ary_new;
  for I := 0 to real.DatabaseCount-1 do
  begin
    Database := real.Databases[I];
    v := Database.Tag;
    if v = 0 then v := ap_iDatabase(Database, This);
    rb_ary_push(result, v);
  end;
end;

function Session_get_database_count(This: Tvalue): Tvalue; cdecl;
var
  real: TSession;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.DatabaseCount);
end;

function Session_add_alias(This, name, driver, strings: Tvalue): Tvalue; cdecl;
begin
  result := This;
  dl_Session(This).AddAlias(dl_String(name), dl_String(driver), dl_Strings(strings));
end;

function Session_add_standard_alias(This, name, path, driver: Tvalue): Tvalue; cdecl;
var
  real: TSession;
begin
  real := ap_data_get_struct(This);
  try
    real.AddStandardAlias(dl_String(name), dl_String(path), dl_String(driver));
  except
    on E: EDBEngineError do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function Session_modify_alias(This, name, strings: Tvalue): Tvalue; cdecl;
begin
  result := This;
  dl_Session(This).ModifyAlias(dl_String(name), dl_Strings(strings));
end;

function Session_save_config_file(This: Tvalue): Tvalue; cdecl;
var
  real: TSession;
begin
  real := ap_data_get_struct(This);
  real.SaveConfigFile;
  result := This;
end;

function Session_get_config_mode(This: Tvalue): Tvalue; cdecl;
var
  real: TSession;
  mode: TConfigMode;
  v: Tvalue;
begin
  real := ap_data_get_struct(This);
  mode := real.ConfigMode;
  v := rb_ary_new;
  if cfmVirtual    in mode then rb_ary_push(v, INT2FIX(Ord(cfmVirtual   )));
  if cfmPersistent in mode then rb_ary_push(v, INT2FIX(Ord(cfmPersistent)));
  if cfmSession    in mode then rb_ary_push(v, INT2FIX(Ord(cfmSession   )));
  result := v;
end;

function Session_set_config_mode(This, v: Tvalue): Tvalue; cdecl;
var
  len: Integer;
  ptr: Pvalue;
  mode: TConfigMode;
  n: Integer;
  real: TSession;
begin
  Check_Type(v, T_ARRAY);
  len := ap_ary_len(v);
  ptr := ap_ary_ptr(v);
  mode := [];
  while len > 0 do
  begin
    n := FIX2INT(ptr^);
    if (n < Ord(Low(TConfigModes))) or (Ord(High(TConfigModes)) < n) then
      ap_raise(ap_eIndexError, sOut_of_range);
    Include(mode, TConfigModes(FIX2INT(ptr^)));
    Dec(len);
    Inc(ptr);
  end;
  real := ap_data_get_struct(This);
  real.ConfigMode := mode;
  result := v;
end;

function Session_get_alias_names(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_StringList_new;
  dl_Session(This).GetAliasNames(dl_Strings(result));
end;

function Session_get_alias_params(This, name: Tvalue): Tvalue; cdecl;
begin
  result := ap_StringList_new;
  dl_Session(This).GetAliasParams(dl_String(name), dl_Strings(result));
end;

function Session_get_driver_names(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_StringList_new;
  dl_Session(This).GetDriverNames(dl_Strings(result));
end;

function Session_get_alias_driver_name(This, name: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Session(This).GetAliasDriverName(dl_String(name)));
end;

function Session_get_database_names(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_StringList_new;
  dl_Session(This).GetDatabaseNames(dl_Strings(result));
end;

function Session_get_table_names(This, database_name, patterns, extensions, system_tables: Tvalue): Tvalue; cdecl;
begin
  result := ap_StringList_new;
  dl_Session(This).GetTableNames(
    dl_String(database_name),
    dl_String(patterns),
    dl_Boolean(extensions),
    dl_Boolean(system_tables),
    dl_Strings(result)
  );
end;

function Session_add_password(This, v: Tvalue): Tvalue; cdecl;
begin
  result := This;
  dl_Session(This).AddPassword(dl_String(v));
end;

(**** str_my_class made by ap_src_maker ****)
type
TPhi_Session = class(TSession)
end;
(**** made by ap_src_maker ****)
(**** str_method made by ap_src_maker ****)

function Session_loaded(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
begin
  real := ap_data_get_struct(This);
  real.Loaded;
  result := This;
end;

function Session_modify_config_params(This, Path, Node, List : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
  dlv_Path : string;
  dlv_Node : string;
  dlv_List : TStrings;
begin
  real := ap_data_get_struct(This);
  dlv_Path := dl_String(Path);
  dlv_Node := dl_String(Node);
  dlv_List := ap_data_get_struct(List);
  real.ModifyConfigParams( dlv_Path, dlv_Node, dlv_List );
  result := This;
end;

function Session_get_bde_owns_login_cb_db(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.BDEOwnsLoginCbDb);  
end;

function Session_set_bde_owns_login_cb_db(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
begin
  real := ap_data_get_struct(This);
  real.BDEOwnsLoginCbDb := dl_Boolean(v);
  result := v;
end;

function Session_add_driver(This, Name, List : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
  dlv_Name : string;
  dlv_List : TStrings;
begin
  real := ap_data_get_struct(This);
  dlv_Name := dl_String(Name);
  dlv_List := ap_data_get_struct(List);
  real.AddDriver( dlv_Name, dlv_List );
  result := This;
end;

function Session_close(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
begin
  real := ap_data_get_struct(This);
  real.Close;
  result := This;
end;

function Session_close_database(This, Database : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
  dlv_Database : TDatabase;
begin
  real := ap_data_get_struct(This);
  dlv_Database := ap_data_get_struct(Database);
  real.CloseDatabase( dlv_Database );
  result := This;
end;

function Session_delete_alias(This, Name : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
  dlv_Name : string;
begin
  real := ap_data_get_struct(This);
  dlv_Name := dl_String(Name);
  real.DeleteAlias( dlv_Name );
  result := This;
end;

function Session_delete_driver(This, Name : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
  dlv_Name : string;
begin
  real := ap_data_get_struct(This);
  dlv_Name := dl_String(Name);
  real.DeleteDriver( dlv_Name );
  result := This;
end;

function Session_drop_connections(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
begin
  real := ap_data_get_struct(This);
  real.DropConnections;
  result := This;
end;

function Session_find_database(This, DatabaseName : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
  dlv_DatabaseName : string;
begin
  real := ap_data_get_struct(This);
  dlv_DatabaseName := dl_String(DatabaseName);
  result := ap_iDatabase(real.FindDatabase( dlv_DatabaseName ),This);
end;

function Session_get_config_params(This, Path, Section, List : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
  dlv_Path : string;
  dlv_Section : string;
  dlv_List : TStrings;
begin
  real := ap_data_get_struct(This);
  dlv_Path := dl_String(Path);
  dlv_Section := dl_String(Section);
  dlv_List := ap_data_get_struct(List);
  real.GetConfigParams( dlv_Path, dlv_Section, dlv_List );
  result := This;
end;

function Session_get_driver_params(This, DriverName, List : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
  dlv_DriverName : string;
  dlv_List : TStrings;
begin
  real := ap_data_get_struct(This);
  dlv_DriverName := dl_String(DriverName);
  dlv_List := ap_data_get_struct(List);
  real.GetDriverParams( dlv_DriverName, dlv_List );
  result := This;
end;

function Session_get_field_names(This, DatabaseName, TableName, List : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
  dlv_DatabaseName : string;
  dlv_TableName : string;
  dlv_List : TStrings;
begin
  real := ap_data_get_struct(This);
  dlv_DatabaseName := dl_String(DatabaseName);
  dlv_TableName := dl_String(TableName);
  dlv_List := ap_data_get_struct(List);
  real.GetFieldNames( dlv_DatabaseName, dlv_TableName, dlv_List );
  result := This;
end;

function Session_get_password(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.GetPassword);
end;

function Session_get_stored_proc_names(This, DatabaseName, List : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
  dlv_DatabaseName : string;
  dlv_List : TStrings;
begin
  real := ap_data_get_struct(This);
  dlv_DatabaseName := dl_String(DatabaseName);
  dlv_List := ap_data_get_struct(List);
  real.GetStoredProcNames( dlv_DatabaseName, dlv_List );
  result := This;
end;

function Session_is_alias(This, Name : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
  dlv_Name : string;
begin
  real := ap_data_get_struct(This);
  dlv_Name := dl_String(Name);
  result := ap_Bool(real.IsAlias( dlv_Name ));
end;

function Session_modify_driver(This, Name, List : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
  dlv_Name : string;
  dlv_List : TStrings;
begin
  real := ap_data_get_struct(This);
  dlv_Name := dl_String(Name);
  dlv_List := ap_data_get_struct(List);
  real.ModifyDriver( dlv_Name, dlv_List );
  result := This;
end;

function Session_open(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
begin
  real := ap_data_get_struct(This);
  real.Open;
  result := This;
end;

function Session_open_database(This, DatabaseName : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
  dlv_DatabaseName : string;
begin
  real := ap_data_get_struct(This);
  dlv_DatabaseName := dl_String(DatabaseName);
  result := ap_iDatabase(real.OpenDatabase( dlv_DatabaseName ),This);
end;

function Session_remove_all_passwords(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
begin
  real := ap_data_get_struct(This);
  real.RemoveAllPasswords;
  result := This;
end;

function Session_remove_password(This, Password : Tvalue): Tvalue; cdecl;
var
  real: TPhi_Session;
  dlv_Password : string;
begin
  real := ap_data_get_struct(This);
  dlv_Password := dl_String(Password);
  real.RemovePassword( dlv_Password );
  result := This;
end;

(**** made by ap_src_maker ****)

procedure Regist_Session;
var
  real: TSession;
  obj: Tvalue;
begin
  real := Session;
  obj := Session_alloc0(cSession, real);
  vSession := obj;
  rb_define_const(ap_mRDB, 'SESSION', obj);
end;

procedure Init_Session;
begin
  DefineConstSetType(ap_mRDB, TypeInfo(TConfigModes));

  cSession := DefinePersistentClass(ap_mRDB, TSession, ap_cPersistent, ap_iSession_v);

  DefineAttrGet(cSession, 'databases', Session_get_databases);
  DefineAttrGet(cSession, 'database_count', Session_get_database_count);

  rb_define_method(cSession, 'add_alias', @Session_add_alias, 3);
  rb_define_method(cSession, 'add_standard_alias', @Session_add_standard_alias, 3);
  rb_define_method(cSession, 'modify_alias', @Session_modify_alias, 2);
  rb_define_method(cSession, 'save_config_file', @Session_save_config_file, 0);

  DefineAttrGet(cSession, 'config_mode', Session_get_config_mode);
  DefineAttrSet(cSession, 'config_mode', Session_set_config_mode);

  rb_define_method(cSession, 'alias_names', @Session_get_alias_names, 0);
  rb_define_method(cSession, 'alias_params', @Session_get_alias_params, 1);
  rb_define_method(cSession, 'driver_names', @Session_get_driver_names, 0);
  rb_define_method(cSession, 'alias_driver_name', @Session_get_alias_driver_name, 1);
  rb_define_method(cSession, 'database_names', @Session_get_database_names, 0);
  rb_define_method(cSession, 'table_names', @Session_get_table_names, 4);
  rb_define_method(cSession, 'add_password', @Session_add_password, 1);
(**** str_init made by ap_src_maker ****)
  rb_define_method(cSession, 'loaded', @Session_loaded, 0);
  rb_define_method(cSession, 'modify_config_params', @Session_modify_config_params, 3);
  DefineAttrGet(cSession, 'bde_owns_login_cb_db', Session_get_bde_owns_login_cb_db);
  DefineAttrGet(cSession, 'bde_owns_login_cb_db?', Session_get_bde_owns_login_cb_db);
  DefineAttrSet(cSession, 'bde_owns_login_cb_db', Session_set_bde_owns_login_cb_db);
  rb_define_method(cSession, 'add_driver', @Session_add_driver, 2);
  rb_define_method(cSession, 'close', @Session_close, 0);
  rb_define_method(cSession, 'close_database', @Session_close_database, 1);
  rb_define_method(cSession, 'delete_alias', @Session_delete_alias, 1);
  rb_define_method(cSession, 'delete_driver', @Session_delete_driver, 1);
  rb_define_method(cSession, 'drop_connections', @Session_drop_connections, 0);
  rb_define_method(cSession, 'find_database', @Session_find_database, 1);
  rb_define_method(cSession, 'get_config_params', @Session_get_config_params, 3);
  rb_define_method(cSession, 'get_driver_params', @Session_get_driver_params, 2);
  rb_define_method(cSession, 'get_field_names', @Session_get_field_names, 3);
  rb_define_method(cSession, 'get_password', @Session_get_password, 0);
  rb_define_method(cSession, 'get_stored_proc_names', @Session_get_stored_proc_names, 2);
  rb_define_method(cSession, 'is_alias', @Session_is_alias, 1);
  rb_define_method(cSession, 'modify_driver', @Session_modify_driver, 2);
  rb_define_method(cSession, 'open', @Session_open, 0);
  rb_define_method(cSession, 'open_database', @Session_open_database, 1);
  rb_define_method(cSession, 'remove_all_passwords', @Session_remove_all_passwords, 0);
  rb_define_method(cSession, 'remove_password', @Session_remove_password, 1);
(**** made by ap_src_maker ****)

  Regist_Session;
end;

end.
