unit uADODataSet;

interface

uses Rubies, ADODB;

var
  cADODataSet: Tvalue;

function dl_ADODataSet(v: Tvalue): TADODataSet;
function ap_cADODataSet: Tvalue;
function ap_iADODataSet(real: TADODataSet; owner: Tvalue): Tvalue;
procedure Init_ADODataSet;

implementation

uses
  SysUtils, Classes,
{$IFDEF VCL}
  Graphics,
{$ELSE}
  QGraphics,
{$ENDIF}
  TypInfo, DB,
  uDefUtils, Pythia,
  uRDBExt{, RDBHandle, uDataSet, uField, uIndexDef}, uProperty;

function dl_ExecuteOptions(v:Tvalue):TExecuteOptions;
var
  a: Integer;
  b: TExecuteOptions absolute a;
begin
  a := dl_Set(v);
  result := b;
end;

function ap_ExecuteOptions(v:TExecuteOptions):Tvalue;
begin
  result := ap_Set(v);
end;

function dl_RecordStatusSet(v:Tvalue):TRecordStatusSet;
var
  a: Integer;
  b: TRecordStatusSet absolute a;
begin
  a := dl_Set(v);
  result := b;
end;

function ap_RecordStatusSet(v:TRecordStatusSet):Tvalue;
begin
  result := ap_Set(v);
end;

function dl_ObjectStates(v:Tvalue):TObjectStates;
var
  a: Integer;
  b: TObjectStates absolute a;
begin
  a := dl_Set(v);
  result := b;
end;

function ap_ObjectStates(v:TObjectStates):Tvalue;
begin
  result := ap_Set(v);
end;

function dl_ADODataSet(v: Tvalue): TADODataSet;
begin
  ap_data_get_object(v, TADODataSet, Result);
end;

function ap_cADODataSet: Tvalue;
begin
  result := cADODataSet;
end;

procedure ADODataSet_setup(obj: Tvalue; real: TADODataSet);
begin
  DataSet_setup(obj, real);
end;

function ADODataSet_alloc(This: Tvalue; real: TADODataSet): Tvalue;
begin
  result := ChildAlloc(This, real);
  ADODataSet_setup(result, real);
end;

function ap_iADODataSet(real: TADODataSet; owner: Tvalue): Tvalue;
begin
  result := ADODataSet_alloc(cADODataSet, real);
  ap_owner(result, owner);
end;

function ap_iADODataSet_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iADODataSet(TADODataSet(obj), owner);
end;

function ADODataSet_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
begin
  real := TADODataSet.Create(nil);
  result := DataSet_alloc(This, real);
  DataSet_setup(result, real);

  ap_obj_call_init(result, argc, argv);
end;

function ADODataSet_clone(This, v: Tvalue): Tvalue; cdecl;
var
  real: TCustomADODataSet;
begin
  real := ap_data_get_struct(This);
  real.Clone(dl_ADODataSet(v));
  result := This;
end;

function ADODataSet_supports(This, v: Tvalue): Tvalue; cdecl;
var
  real: TCustomADODataSet;
  CursorOptionsInt: Integer;
  CursorOptions: TCursorOptions absolute CursorOptionsInt;
begin
  real := ap_data_get_struct(This);
//  real.Supports(TCursorOptions(dl_Set(v)));
//  SetOrdProp(real, 'Supports', dl_Set(v));
  CursorOptionsInt := dl_Set(v);
  result := ap_bool(real.Supports(CursorOptions));
end;

function ADODataSet_get_properties(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
   real: TCustomADODataSet;
   args: array of Tvalue;
begin
   if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
   SetLength(args, argc);
   args := argv;
   real := ap_data_get_struct(This);
   result := ap_iProperty(real.Properties[dl_Variant(args[0])], This);
end;

(**** str2 made by ap_src_maker ****)

function ADODataSet_bookmark_valid(This, Bookmark : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
  dl_Bookmark : TBookmark;
begin
  real := ap_data_get_struct(This);
  dl_Bookmark := ap_data_get_struct(Bookmark);
  result := ap_Bool(real.BookmarkValid( dl_Bookmark ));
end;

function ADODataSet_cancel_batch(This, AffectRecords : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
  dl_AffectRecords : TAffectRecords;
begin
  real := ap_data_get_struct(This);
  dl_AffectRecords := TAffectRecords(dl_Integer(AffectRecords));
  real.CancelBatch( dl_AffectRecords );
  result := This;
end;

function ADODataSet_cancel_updates(This : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
begin
  real := ap_data_get_struct(This);
  real.CancelUpdates;
  result := This;
end;

function ADODataSet_compare_bookmarks(This, Bookmark1, Bookmark2 : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
  dl_Bookmark1 : TBookmark;
  dl_Bookmark2 : TBookmark;
begin
  real := ap_data_get_struct(This);
  dl_Bookmark1 := ap_data_get_struct(Bookmark1);
  dl_Bookmark2 := ap_data_get_struct(Bookmark2);
  result := ap_Integer(real.CompareBookmarks( dl_Bookmark1, dl_Bookmark2 ));
end;

function ADODataSet_create_blob_stream(This, Field, Mode : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
  dl_Field : TField;
  dl_Mode : TBlobStreamMode;
begin
  real := ap_data_get_struct(This);
  dl_Field := ap_data_get_struct(Field);
  dl_Mode := TBlobStreamMode(dl_Integer(Mode));
  result := ap_iStream(real.CreateBlobStream( dl_Field, dl_Mode ),This);
end;

function ADODataSet_delete_records(This, AffectRecords : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
  dl_AffectRecords : TAffectRecords;
begin
  real := ap_data_get_struct(This);
  dl_AffectRecords := TAffectRecords(dl_Integer(AffectRecords));
  real.DeleteRecords( dl_AffectRecords );
  result := This;
end;

function ADODataSet_get_blob_field_data(This, FieldNo, Buffer : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
  dl_FieldNo : Integer;
  dl_Buffer : TBlobByteData;
begin
  real := ap_data_get_struct(This);
  dl_FieldNo := dl_Integer(FieldNo);
  dl_Buffer := ap_data_get_struct(Buffer);
  result := ap_Integer(real.GetBlobFieldData( dl_FieldNo, dl_Buffer ));
end;

function ADODataSet_get_detail_link_fields(This, MasterFields, DetailFields : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
  dl_MasterFields : TList;
  dl_DetailFields : TList;
begin
  real := ap_data_get_struct(This);
  dl_MasterFields := ap_data_get_struct(MasterFields);
  dl_DetailFields := ap_data_get_struct(DetailFields);
  real.GetDetailLinkFields( dl_MasterFields, dl_DetailFields );
  result := This;
end;

function ADODataSet_is_sequenced(This : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.IsSequenced);
end;

function ADODataSet_load_from_file(This, FileName : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
  dl_FileName : WideString;
begin
  real := ap_data_get_struct(This);
  dl_FileName := dl_String(FileName);
  real.LoadFromFile( dl_FileName );
  result := This;
end;

function ADODataSet_lookup(This, KeyFields, KeyValues, ResultFields : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
  dl_KeyFields : string;
  dl_KeyValues : Variant;
  dl_ResultFields : string;
begin
  real := ap_data_get_struct(This);
  dl_KeyFields := dl_String(KeyFields);
  dl_KeyValues := dl_Variant(KeyValues);
  dl_ResultFields := dl_String(ResultFields);
  result := ap_Variant(real.Lookup( dl_KeyFields, dl_KeyValues, dl_ResultFields ));
end;

function ADODataSet_requery(This, Options : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
  dl_Options : TExecuteOptions;
begin
  real := ap_data_get_struct(This);
  dl_Options := dl_ExecuteOptions(Options);
  real.Requery( dl_Options );
  result := This;
end;

function ADODataSet_save_to_file(This, FileName, Format : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
  dl_FileName : WideString;
  dl_Format : TPersistFormat;
begin
  real := ap_data_get_struct(This);
  dl_FileName := dl_String(FileName);
  dl_Format := TPersistFormat(dl_Integer(Format));
  real.SaveToFile( dl_FileName, dl_Format );
  result := This;
end;

function ADODataSet_seek(This, KeyValues, SeekOption : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
  dl_KeyValues : Variant;
  dl_SeekOption : TSeekOption;
begin
  real := ap_data_get_struct(This);
  dl_KeyValues := dl_Variant(KeyValues);
  dl_SeekOption := TSeekOption(dl_Integer(SeekOption));
  result := ap_Bool(real.Seek( dl_KeyValues, dl_SeekOption ));
end;

function ADODataSet_update_batch(This, AffectRecords : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
  dl_AffectRecords : TAffectRecords;
begin
  real := ap_data_get_struct(This);
  dl_AffectRecords := TAffectRecords(dl_Integer(AffectRecords));
  real.UpdateBatch( dl_AffectRecords );
  result := This;
end;

function ADODataSet_get_designer_data(This: Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.DesignerData);  
end;

function ADODataSet_set_designer_data(This, v: Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
begin
  real := ap_data_get_struct(This);
  real.DesignerData := dl_String(v);
  result := v;
end;

function ADODataSet_get_index_field_count(This: Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.IndexFieldCount);  
end;

function ADODataSet_set_index_fields(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
  dl_Index : Integer;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dl_Index := dl_Integer(argv[0]);
  real.IndexFields[dl_Index] := ap_data_get_struct(argv[1]);
  result := argv[1];
end;

function ADODataSet_get_index_fields(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
  dl_Index : Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dl_Index := dl_Integer(argv[0]);
  result := ap_iField(real.IndexFields[dl_Index],This);
end;

function ADODataSet_get_filter_group(This: Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(ord(real.FilterGroup));  
end;

function ADODataSet_set_filter_group(This, v: Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
begin
  real := ap_data_get_struct(This);
  real.FilterGroup := TFilterGroup(dl_Integer(v));
  result := v;
end;

function ADODataSet_get_recordset_state(This: Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_ObjectStates(real.RecordsetState);  
end;

function ADODataSet_get_record_status(This: Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_RecordStatusSet(real.RecordStatus);  
end;

function ADODataSet_create_data_set(This : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
begin
  real := ap_data_get_struct(This);
  real.CreateDataSet;
  result := This;
end;

function ADODataSet_get_index_names(This, List : Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
  dl_List : TStrings;
begin
  real := ap_data_get_struct(This);
  dl_List := ap_data_get_struct(List);
  real.GetIndexNames( dl_List );
  result := This;
end;

function ADODataSet_get_index_defs(This: Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_iIndexDefs(real.IndexDefs,This);  
end;

function ADODataSet_set_index_defs(This, v: Tvalue): Tvalue; cdecl;
var
  real: TADODataSet;
begin
  real := ap_data_get_struct(This);
  real.IndexDefs := ap_data_get_struct(v);
  result := v;
end;
(**** made by ap_src_maker ****)

procedure Init_ADODataSet;
begin
  DefineConstSetType(ap_mRDB, TypeInfo(TADOLockType));
  DefineConstSetType(ap_mRDB, TypeInfo(TCommandType));
  DefineConstSetType(ap_mRDB, TypeInfo(TCursorLocation));
  DefineConstSetType(ap_mRDB, TypeInfo(TCursorType));
  DefineConstSetType(ap_mRDB, TypeInfo(TCursorOption));
  cADODataSet := DefinePersistentClass(ap_mRDB, TADODataSet, ap_cDataSet, ap_iADODataSet_v);
  DefineSingletonMethod(cADODataSet, 'new', ADODataSet_new);
  rb_define_method(cADODataSet, 'clone', @ADODataSet_clone, 1);
  rb_define_method(cADODataSet, 'supports', @ADODataSet_supports, 1);
  DefineIndexer(cADODataSet, 'properties', @ADODataSet_get_properties, nil);

(**** str3 made by ap_src_maker ****)
  rb_define_method(cADODataSet, 'bookmark_valid', @ADODataSet_bookmark_valid, 1);
  rb_define_method(cADODataSet, 'cancel_batch', @ADODataSet_cancel_batch, 1);
  rb_define_method(cADODataSet, 'cancel_updates', @ADODataSet_cancel_updates, 0);
  rb_define_method(cADODataSet, 'compare_bookmarks', @ADODataSet_compare_bookmarks, 2);
  rb_define_method(cADODataSet, 'create_blob_stream', @ADODataSet_create_blob_stream, 2);
  rb_define_method(cADODataSet, 'delete_records', @ADODataSet_delete_records, 1);
  rb_define_method(cADODataSet, 'get_blob_field_data', @ADODataSet_get_blob_field_data, 2);
  rb_define_method(cADODataSet, 'get_detail_link_fields', @ADODataSet_get_detail_link_fields, 2);
  rb_define_method(cADODataSet, 'is_sequenced', @ADODataSet_is_sequenced, 0);
  rb_define_method(cADODataSet, 'load_from_file', @ADODataSet_load_from_file, 1);
  rb_define_method(cADODataSet, 'lookup', @ADODataSet_lookup, 3);
  rb_define_method(cADODataSet, 'requery', @ADODataSet_requery, 1);
  rb_define_method(cADODataSet, 'save_to_file', @ADODataSet_save_to_file, 2);
  rb_define_method(cADODataSet, 'seek', @ADODataSet_seek, 2);
  rb_define_method(cADODataSet, 'update_batch', @ADODataSet_update_batch, 1);
  DefineAttrGet(cADODataSet, 'designer_data', ADODataSet_get_designer_data);
  DefineAttrSet(cADODataSet, 'designer_data', ADODataSet_set_designer_data);
  DefineAttrGet(cADODataSet, 'index_field_count', ADODataSet_get_index_field_count);
  DefineIndexer(cADODataSet, 'index_fields', @ADODataSet_get_index_fields, @ADODataSet_set_index_fields);
  DefineAttrGet(cADODataSet, 'filter_group', ADODataSet_get_filter_group);
  DefineAttrSet(cADODataSet, 'filter_group', ADODataSet_set_filter_group);
  DefineAttrGet(cADODataSet, 'recordset_state', ADODataSet_get_recordset_state);
  DefineAttrGet(cADODataSet, 'record_status', ADODataSet_get_record_status);
  rb_define_method(cADODataSet, 'create_data_set', @ADODataSet_create_data_set, 0);
  rb_define_method(cADODataSet, 'get_index_names', @ADODataSet_get_index_names, 1);
  DefineAttrGet(cADODataSet, 'index_defs', ADODataSet_get_index_defs);
  DefineAttrSet(cADODataSet, 'index_defs', ADODataSet_set_index_defs);
(**** made by ap_src_maker ****)
end;

end.
