unit PGridHandle;

interface

uses Classes, Rubies, HPropGrid, Windows, Controls, Graphics;

type
   TPGridHandle = class(TObject)
   published
      
      procedure PropGridSelectRowOnSelectRow(Sender: TObject; Index: integer; SectionName: string);

      procedure PropGridItemNeedValueOnNeedValue(Sender: TPropGridItem; Name: string; var Value: string;
                                        var Canceled: boolean);
      procedure PropGridItemValueChangeOnValueChange(Sender: TPropGridItem; Name: string;
                                          BeforeValue, AfterValue: string);
      procedure PropGridItemValueChangingOnValueChanging(Sender: TPropGridItem; Name: string;
                                            var Value: string; var Update: boolean);
      procedure PropGridItemDrawCellOnDrawCell(Sender: TPropGridItem; Name: string; Value: string;
                                       ACanvas: TCanvas; Rect: TRect);
      procedure PropGridItemDrawItemOnDrawItem(Sender: TPropGridItem; Name: string;
                                            ItemIndex: integer; ItemValue: string;
                                            ACanvas: TCanvas; Rect: TRect; Selected: boolean);
      procedure PropGridPopupCloseOnPopupClose(Sender: TObject; ActiveTo: TControl; Key: Word);

   end;

function PGridGetHandle: TPGridHandle;

implementation

uses Pythia;

var
  Handle: TPGridHandle;

function PGridGetHandle: TPGridHandle;
begin
  result := Handle;
end;

procedure TPGridHandle.PropGridSelectRowOnSelectRow(Sender: TObject; Index: integer; SectionName: string);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_select_row'));
  rb_ary_push(data, recv);

  rb_ary_push(data, INT2FIX(Index));
  rb_ary_push(data, ap_String(SectionName));
  
  PhiCallProtect(data);
end;

procedure TPGridHandle.PropGridItemNeedValueOnNeedValue(Sender: TPropGridItem; Name: string;
                                               var Value: string;
                                               var Canceled: boolean);
var
  recv, data, ret, ary, val: Tvalue;
begin
  recv := Tvalue(Sender.Data);
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_need_value'));
  rb_ary_push(data, recv);

  ary := rb_ary_new;
  rb_ary_push(ary, ap_String(Value));
  rb_ary_push(ary, ap_Bool(Canceled));

  rb_ary_push(data, ary);
  rb_ary_push(data, ap_String(Name));

  ret := PhiCallProtect(data);

  if RTYPE(ret) <> T_ARRAY then Exit;
  val := rb_ary_shift(ret);
  Value := dl_String(val);
  val := rb_ary_shift(ret);
  Canceled := RTEST(val);
end;

procedure TPGridHandle.PropGridItemValueChangeOnValueChange(Sender: TPropGridItem; Name: string;
                                                 BeforeValue, AfterValue: string);
var
  recv, data: Tvalue;
begin
  recv := Tvalue(Sender.Data);
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_value_change'));
  rb_ary_push(data, recv);
  rb_ary_push(data, ap_String(Name));
  rb_ary_push(data, ap_String(BeforeValue));
  rb_ary_push(data, ap_String(AfterValue));

  PhiCallProtect(data);
end;

procedure TPGridHandle.PropGridItemValueChangingOnValueChanging(Sender: TPropGridItem; Name: string;
                                                   var Value: string; var Update: boolean);
var
  recv, data, ary, ret, val: Tvalue;
begin
  recv := Tvalue(Sender.Data);
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_value_changing'));
  rb_ary_push(data, recv);

  ary := rb_ary_new;
  rb_ary_push(ary, ap_String(Value));
  rb_ary_push(ary, ap_Bool(Update));

  rb_ary_push(data, ary);
  rb_ary_push(data, ap_String(Name));

  ret := PhiCallProtect(data);

  if RTYPE(ret) <> T_ARRAY then Exit;
  val := rb_ary_shift(ret);
  Value := dl_String(val);
  val := rb_ary_shift(ret);
  Update := RTEST(val);
end;

procedure TPGridHandle.PropGridItemDrawCellOnDrawCell(Sender: TPropGridItem; Name: string; Value: string;
                                              ACanvas: TCanvas; Rect: TRect);
var
  recv, data: Tvalue;
begin
  recv := Tvalue(Sender.Data);
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_draw_cell'));
  rb_ary_push(data, recv);

  rb_ary_push(data, ap_String(Name));
  rb_ary_push(data, ap_String(Value));
  rb_ary_push(data, ap_iCanvas(ACanvas, recv));
  rb_ary_push(data, ap_iRect(Rect, recv));
  PhiCallProtect(data);
end;

procedure TPGridHandle.PropGridItemDrawItemOnDrawItem(Sender: TPropGridItem; Name: string;
                                                   ItemIndex: integer; ItemValue: string;
                                                   ACanvas: TCanvas; Rect: TRect; Selected: boolean);
var
  recv, data: Tvalue;
begin
  recv := Tvalue(Sender.Data);
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_draw_item'));
  rb_ary_push(data, recv);

  rb_ary_push(data, ap_String(Name));
  rb_ary_push(data, INT2FIX(ItemIndex));
  rb_ary_push(data, ap_String(ItemValue));
  rb_ary_push(data, ap_iCanvas(ACanvas, recv));
  rb_ary_push(data, ap_iRect(Rect, recv));
  rb_ary_push(data, ap_Bool(Selected));
  PhiCallProtect(data);
end;

procedure TPGridHandle.PropGridPopupCloseOnPopupClose(Sender: TObject; ActiveTo: TControl; Key: Word);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  if recv = 0 then Exit;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_popup_close'));
  rb_ary_push(data, recv);

  rb_ary_push(data, ChildAlloc(ap_cControl, ActiveTo));
  rb_ary_push(data, INT2FIX(Integer(Key)));
  PhiCallProtect(data);
end;

initialization
  Handle := TPGridHandle.Create;
finalization
  Handle.Free;
end.
