unit uDelphiFountain;

interface

uses
  Rubies, DelphiFountain;

var
  cDelphiFountain: Tvalue;

function ap_iDelphiFountain(real: TDelphiFountain; owner: Tvalue): Tvalue;
procedure Init_DelphiFountain;

implementation

uses
  Pythia, heFountain, uEditor, uFountain, uFountainColor;

procedure DelphiFountain_setup(obj: Tvalue; real: TDelphiFountain);
begin
  Fountain_setup(obj, real);
  rb_iv_set(obj, '@ank', ap_iFountainColor(real.Ank, obj));
  rb_iv_set(obj, '@asm_block', ap_iFountainColor(real.AsmBlock, obj));
  rb_iv_set(obj, '@comment', ap_iFountainColor(real.Comment, obj));
  rb_iv_set(obj, '@dbcs', ap_iFountainColor(real.DBCS, obj));
  rb_iv_set(obj, '@int', ap_iFountainColor(real.Int, obj));
  rb_iv_set(obj, '@str', ap_iFountainColor(real.Str, obj));
  rb_iv_set(obj, '@symbol', ap_iFountainColor(real.Symbol, obj));
end;

function DelphiFountain_alloc(This: Tvalue; real: TDelphiFountain): Tvalue;
begin
  result := TmpAlloc(This, real);
  DelphiFountain_setup(result, real);
end;

function ap_iDelphiFountain(real: TDelphiFountain; owner: Tvalue): Tvalue;
begin
  result := DelphiFountain_alloc(cDelphiFountain, real);
  ap_owner(result, owner);
end;

function ap_iDelphiFountain_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDelphiFountain(TDelphiFountain(AControl), owner)
end;

function DelphiFountain_new(This: Tvalue): Tvalue; cdecl;
var
  real: TDelphiFountain;
begin
  real := TDelphiFountain.Create(nil);
  result := CompoAlloc(This, real);
  DelphiFountain_setup(result, real);
  ap_obj_call_init(result, 0, nil);
end;

procedure Init_DelphiFountain;
begin
  cDelphiFountain := DefinePersistentClass(ap_mPhi, TDelphiFountain, cFountain, ap_iDelphiFountain_v);
  DefineProp(cDelphiFountain, TDelphiFountain);
  rb_define_singleton_method(cDelphiFountain, 'new', @DelphiFountain_new, 0);
end;

end.
