program Apollo;

(*
modified
  [ap-list:0665] by KUMAGAI Hidetake
*)

{$I heverdef.inc}

uses
{$IFDEF DELPHI9}
  UxTheme,
{$ENDIF}
  SysUtils,
  Classes,
  FileCtrl,
  Forms,
  Rubies,
{$IFDEF PHIEMBED}
  PhiMainUnit, uError,
{$ELSE}
  Pythia,
{$ENDIF}
  Console in 'Console.pas' {FormConsole},
  Browser in 'Browser.pas' {FormBrowser},
  Resource in 'Resource.pas';

{$R *.res}

procedure FormShow;
begin
  FormConsole.Show;
  FormBrowser.Show;
end;

function ExecCustom: Boolean;
var
  script, apollo_path: string;
begin
  InExecCustom := True;

  apollo_path := ExtractFileDir(ParamStr(0));
  script := apollo_path + '\custom.rb';
  script := StringReplace(script, '\', '/', [rfReplaceAll]);
  PhiLoadProtect(PChar(script), FormBrowser.ThreadDone);

  result := (PhiErrorLine = -1);
  if not result then
  begin
    FormShow;
    FormBrowser.JumpError;
  end;

  InExecCustom := False;
end;

	//
	//	usage:
	//
	//  rest := CmdLine;
	//  WriteLn( 'Command Line :');
	//  WriteLn( '['+rest+']');
	//  WriteLn( '--- SplitParam ---');
	//  while true do begin
	//    s := SplitParam( rest );
	//    if s = '' then break;
	//    WriteLn( '['+s+'] ['+rest+']');
	//  end;
	//
function SplitParam( var rest:string ):string;
var
  delimitter:char;
  p:integer;
begin
  rest := TrimLeft(rest);
  if rest = '' then begin
    result := '';
    rest   := '';
    exit;
  end;
  delimitter := ' ';
  if rest[1] = '''' then delimitter := '''';
  if rest[1] = '"'  then delimitter := '"';
  p := pos(delimitter,copy(rest,2,maxint))+1;
  if p = 1 then begin
    result := trim(rest);
    rest   := '';
  end else begin
    result := trim(copy(rest,1,p));
    rest   := copy(rest,p+1,MaxInt);
  end;
end;

var
//  i: Integer;
  S: string;
  opt_q: Boolean = False;
  script, params: string;
  rest:string;
begin
  Application.Initialize;
  Application.Title := 'Apollo';
  Application.CreateForm(TFormBrowser, FormBrowser);
{$IFDEF DELPHI9}
  SetThemeAppProperties(STAP_ALLOW_NONCLIENT);
{$ENDIF}
  Application.CreateForm(TFormConsole, FormConsole);

  script := '';
  params := '';

  rest := CmdLine;
  SplitParam(rest);
  S := SplitParam(rest);
  while S <> '' do begin
    if S[1] = '-' then begin
      if Length(S) <> 1 then begin
        case S[2] of
        'q': opt_q := True;
        'Q': begin opt_q := True; FormConsole.ShowOnOutput := True; end;
        'K': if Length(S) >= 3 then rb_set_kcode(@S[3]);
        else
          params := params +' '+ S;
        end;
      end;
    end else
    if script = '' then begin
      //script := AnsiDequotedStr(S);
      script := S;
      params := S;
    end else begin
      params := params +' '+ S;
    end;
    S := SplitParam(rest)
  end;
  
  //for i := 1 to ParamCount do
  //begin
  //  S := ParamStr(i);
  //  if S[1] = '-' then
  //  begin
  //    if Length(S) = 1 then Continue;
  //    case S[2] of
  //    'q': opt_q := True;
  //    'K': if Length(S) >= 3 then rb_set_kcode(@S[3]);
  //    else
  //      params := params +' '+ S;
  //    end;
  //  end
  //  else
  //    if params = '' then
  //    begin
  //      script := S;
  //      params := S;
  //    end else
  //      params := params +' '+ S;
  //end;
  
  if params = '' then
    params := FormBrowser.EditPath.Text
  else
    FormBrowser.EditPath.Text := params
  ;
  //opt_q := true; { debug }
  if ExecCustom then
    //if opt_q and FileExists(script) then begin
    if opt_q and FileExists(AnsiDequotedStr(script,'"')) then begin //++
      Application.ShowMainForm := False;
      FormBrowser.LoadScript;
      FormBrowser.EditPath.Text := params;
      FormBrowser.Perform(APM_QUICK_RUN, 0, 0);
    end else begin
      FormShow;
      FormBrowser.LoadScript;
    end;
  Application.Run;
end.
