require 'phi'
require 'dialogs'

def ok_msg(msg)
  Phi::message_dlg(msg, Phi::MT_INFORMATION, [Phi::MB_OK], 0)  
end

form = Phi::Form.new(:form1, 'formł')
form.height = 95
button = Phi::Button.new(form, :button1, '{^')
label = Phi::Label.new(form, :label1, '')
button.align = Phi::AL_TOP
label.align = Phi::AL_CLIENT
label.color = Phi::CL_WHITE

Phi::new_menu(form, :menu1, [
  menu_file = Phi::new_item('t@C(&F)', '', :menu_file1).add(
  Phi::new_sub_menu('Tu', :menu_sub1, [
        Phi::new_item("`FbN1", '', :menu_check1, true),
        Phi::new_line,
        Phi::new_item("WI1", '', :menu_radio1, false),
        Phi::new_item("WI2", '', :menu_radio2, false),
      ]),
    Phi::new_line,
    Phi::new_item("(&C)", '', :menu_close1)
  ),
  menu_edit = Phi::new_item('ҏW(&E)', '', :menu_edit1).add(
    Phi::new_item('؂(&T)', 'Ctrl+X', :menu_cut1),
    Phi::new_item('Rs[(&C)', 'Ctrl+C', :menu_copy1),
    Phi::new_item('\(&P)', 'Ctrl+V', :menu_paste1)
  ),
  menu_help = Phi::new_item('wv(&H)', 'Ctrl+H', :menu_help1).add(
    Phi::new_item('̃\tgɂ(&A)', '', :menu_about1, false, false)
  )
  ])
form.menu_attr_flatten
form.menu_radio1.radio_item = true
form.menu_radio2.radio_item = true
form.menu_radio1.group_index = 0
form.menu_radio2.group_index = 0  
form.menu_radio1.checked = true

  
# event
form.menu_radio1.on_click = proc do
  unless form.menu_radio1.checked?
    form.menu_radio1.checked = true
  end
end

form.menu_radio2.on_click = proc do
  unless form.menu_radio2.checked?
    form.menu_radio2.checked = true
  end
end

form.menu_check1.on_click = proc do
  if form.menu_check1.checked?
    form.menu_check1.checked = false
  else
    form.menu_check1.checked = true
  end
end

form.menu_close1.on_click = proc do
  exit  
end

form.menu_copy1.on_click = proc do
  ok_msg('Rs[')  
end

button.on_click = proc do
  if form.menu_check1.checked?
    if form.menu_radio1.checked?
      label.caption = '`FbN1ƃWI1`FbNĂ܂B'
    elsif form.menu_radio2.checked?
      label.caption = '`FbN1ƃWI2`FbNĂ܂B'
    else
      ok_msg('BUG')
    end
  else
    label.caption = '`FbN1`FbNĂ܂B'
  end
end
  
form.show
Phi.mainloop
