require 'phi'
require 'drb'
require 'mandel'

class MandelCalc
  include DRbUndumped
  def mandel(x,height,s_re,s_im,dx,dy,max_depth)
    re = s_re + (dx * x)
    (0 ... height).map{|y|
      im = s_im - (dy * y)
      depth = Mandel.mandel(re,im,max_depth)
      if depth >= max_depth
        0
      else
        0x00ffffff * depth / max_depth
      end
    }
  end
  def gc
    GC.start
  end
end

host_port = ARGV.shift || 'localhost:3000'
mc = MandelCalc.new
DRb.start_service("druby://#{host_port}", mc)
puts 'URI: ' + DRb.uri
DRb.thread.join
