#!/usr/bin/env ruby

# $B$3$N$^$^$@$H:G8e$G2~9T$7$J$$$HBLL\(B
# $B2?$bF~$l$:$K%j%?!<%s$rF~NO$9$k$H$*$+$7$/$J$k(B

require 'gtk'
require 'irb-wrapper'

include Gtk

def editor_debug 
  window = Window.new
  window.set_default_size(200, 200)
  vbox = VBox.new
  window.add(vbox)
  @editor = Editor.new
  vbox.pack_start(@editor, true, true, 3)
  hbox = HBox.new
  vbox.pack_start(hbox, true, true, 3)
  btn1 = Button.new("Button 1")
  btn2 = Button.new("Button 2")
  btn3 = Button.new("Button 3")
  hbox.pack_start(btn1, true, true, 3)
  hbox.pack_start(btn2, true, true, 3)
  hbox.pack_start(btn3, true, true, 3)
  window.show_all

  def window.destroy 
    exit
  end
  
  btn1.signal_connect('clicked') do |btn|
    @editor.buffer_write("hogehoge")
  end

  btn2.signal_connect('clicked') do
    p @editor.buffer_gets
  end

  btn3.signal_connect('clicked') do
    p $i
  end
  
  Gtk::main
end




class Editor < Text

  def initialize
    super
    @can_gets = false
    @length_when_get_last = 0
    set_editable(true)

    # $B%f!<%6!<$NF~NO$K2~9T$,$"$k$H!"(B
    # buffer_gets$B$,CM$rJV$;$k$h$&$K(B
    # @can_gets$B$K(Btrue$B$rF~$l$k!#(B
    signal_connect('key_press_event') do |edit, event|
      if event.keyval == Gdk::GDK_Return # Return 
	#p get_length
	@can_gets = true
      end
    end

    #signal_connect('destory'){ exit }
  end

  
  # $B:G8e$K(Bbuffer_gets$B$7$F$+$i(B
  # buffer_write$B$^$G$N4V$K(B
  # $B%f!<%6!<$+$i$N%P%C%U%!$X$NF~NO$,$J$$$3$H$rA0Ds$K$7$F$$$k(B
  def buffer_write(str)
=begin
    STDOUT.print "buffet_write string: "
    STDOUT.p str
    STDOUT.print "buffet_write string type: "
    STDOUT.p str.type
=end
    begin 
      insert(nil, nil, nil, str)
      
      # IRB$BB&$+$i$NF~NO$O(Bbuffer_gets$B$G<h$l$J$$$h$&$K$9$k(B
      @length_when_get_last = get_length
      return true
    rescue
      return false
    end
  end

  alias buffer_putc buffer_write


  
  # $B$H$j$"$($:(Brs$B$OL5;k(B
  # EOF$B$OB8:_$7$J$$$N$G!"(Bnil$B$OJV$5$J$$(B
  def buffer_gets(rs = $/)
    while true
      # Retun $B$,F~NO$5$l$k$^$G%k!<%W(B
      if @can_gets 
	break
      end

      # $B:FIA2h(B
      while (Gtk.events_pending)
	Gtk.main_iteration
      end
      sleep 0.03
    end

    str = get_chars(@length_when_get_last, get_length)
    @length_when_get_last = get_length
    @can_gets = false
    str
  end

end




class  IRBWindow < Window

  def initialize
    super
    set_modal(true)
    set_default_size(300, 250)
    @editor = Editor.new

    scroll_window = Gtk::ScrolledWindow.new
    scroll_window.add(@editor)
    add(scroll_window)
  end

  def editor
    @editor
  end
end


class MainWindow 
  
  def initialize(w)
    @window = Window.new(Gtk::WINDOW_TOPLEVEL)
    @button = Button.new('IRB')
    @window.add(@button)
    @window.show_all
    @window.set_default_size(100,100)
      
    def @window.destroy
      exit
    end

    @button.signal_connect('clicked') do
      w.show_all
      IRB.start_on_gui
    end
    
  end

end


#
# Main
#

if ARGV[0] == '-e'
  editor_debug
end
  

w = IRBWindow.new

# STDOUT STDIN SDTERR$B$r:9$7BX$($k(B
$> = GUIWrapper::GuiConsole.new(w.editor)
include GUIWrapper::GuiIoEmulate
$stdout = $>
$stdin = $>
$stderr = $>


window = MainWindow.new(w)
Gtk::main
  


