#! ruby -Ks
# by KUMAGAI Hidetake (ggb03124@nifty.ne.jp)
# modified by YOSHIDA Kazuhiro (moriq@moriq.com)
#
#-- $(apollo)/lib/rdb/dbx.rb
#-- dbx.pi
#

require 'phi'
require 'rdb/rdb'
require 'rdb/dbx.so'

unless $NO_PHI_EXTENSION
module RDB

class SQLDataSet # < DataSet
  include DataSet_ex
  include CommandTextDataSet # table_name sql_text

  alias connection  sql_connection  # ** 2003-02-24()
  alias connection= sql_connection=
end

class SQLTable # < DataSet
  include DataSet_ex

  alias connection  sql_connection  # ** 2003-02-24()
  alias connection= sql_connection=
end

# C:/PROGRA~1/Apollo/src/ext/rdb/uSQLQuery.pas
class SQLQuery # < DataSet
  include DataSet_ex
  include DotSqlDataSet

  alias connection  sql_connection  # ** 2003-02-24()
  alias connection= sql_connection=
end

class SQLClientDataSet # < ClientDataSet
  include DataSet_ex
  include CommandTextDataSet

  alias connection  db_connection
  alias connection= db_connection=
end if defined? SQLClientDataSet

class SQLClientQuery < ClientDataSet
  attr:provider
  attr:dataset

  def initialize
    super
    @dataset  = SQLQuery.new
    @provider = DataSetProvider.new
    @provider.data_set = @dataset
  end

  def sql_text
    @dataset.sql_text
  end
  def sql_text=(v)
    @dataset.sql_text=v
  end

  def table_name # for SQLQuery
    @table_name
  end
  def table_name=(v) # for SQLQuery
    @dataset.sql.text="select * from #{v}"
    @table_name = v
  end

  def active_ex=(v)
    self.set_provider( @provider ) # Ȃ initialize ł͕sB
    self.active = v
  rescue
    sql = @dataset.sql_text
    params = @dataset.sql_params.values
    RDB.add_sql_to_error_message( sql, params )
    raise
  end

  def active_ex
    self.active
  end

  def sql_params
    @dataset.sql_params
  end

  def sql_params=(v)
    @dataset.sql_params = v
  end

  def connection
    @dataset.connection
  end
  def connection=(v)
    @dataset.connection = v
  end

  def method_missing( name , *args )
    @dataset.send( name , *args )
  rescue NoMethodError
    puts "--- #{self.class.inspect} --"     , self.class.instance_methods.sort
    puts "--- #{@dataset.class.inspect} --" , @dataset.class.instance_methods.sort
    raise
  end

end

######## class SQLConnection ########

# class SQLClientQuery < ClientDataSet ; end

class SQLConnection
  STD_TABLE_CLASS = SQLClientQuery
  STD_QUERY_CLASS = SQLClientQuery
  include Connection_ex

  #
  #	SQLConnection#internal_query does NOT return SQLClientDataSet, but SQLQuery object.
  #	though SQLConnection#new_query returns SQLClientDataSet object.
  #	DBGrid cannot display SQLQuery object.
  #

  def execute_ex( sql,params=nil)
    if params
      execute( sql,params )
    else
      execute_direct( sql )
    end
  rescue
    RDB.add_sql_to_error_message( sql, params )
    raise
  end

  # [ap-dev:0752]
  def new_query(sql=nil,params=nil)
    ret = SQLClientQuery.new
    ret.sql_connection = self
    if sql
      ret.open(sql,params)
    end
    return ret
  rescue
    RDB.add_sql_to_error_message( sql , params )
    raise
  end
  alias query new_query  # 2003-07-03()

  def new_table(name=nil)
    ret = STD_TABLE_CLASS.new
    ret.connection = self
    if name
      ret.table_name = name
      ret.open
    end
    return ret
  end
  alias table new_table  # 2003-07-03()

  def table_exist?(table_name)
    nm = table_name.upcase
    table_names(false).each{ |table|
      return true if table.upcase == nm
    }
    return false
  end

end

end # of module RDB
end # of if $NO_PHI_EXTENSION
