#! ruby -Ks
#-- DataSet_descending.rb
#-- DataSet_descending.pi

require "phi"
require "rdb"

module RDB
class DataSet
  def descending_field_names=(v)
    @descending_names ||= {}
    index_name = @descending_names[v] ||= "desc_#{v.id}"
    self.add_index(index_name,v,[RDB::IX_DESCENDING]);
    self.index_name = index_name
  end
end
end

if __FILE__ == $0
  require "dir_to_dataset"
  require "DBGrid_on_mouse_wheel"
  include Phi
  include RDB
  dataset = dir_to_dataset __FILE__
  form = Form.new
  grid = DBGrid.new form
  grid.extend DBGrid_on_mouse_wheel
  grid.data_source = DataSource.new dataset
  dataset.descending_field_names = "time;name"
  form.show
  mainloop
end
