unit uDefUtils;

interface

uses Rubies;

procedure DefineSingletonMethod(klass: Tvalue; name: PChar; func1: TFunc1);
procedure DefineMethod(klass: Tvalue; name: PChar; func1: TFunc1);
procedure DefineAttrGet(klass: Tvalue; name: PChar; attr0: TAttr0);
procedure DefineAttrSet(klass: Tvalue; name: PChar; attr1: TAttr1);
procedure DefineModuleFunction(module: Tvalue; name: PChar; func1: TFunc1);
procedure DefineModuleAttrGet(module: Tvalue; name: PChar; attr0: TAttr0);
procedure DefineModuleAttrSet(module: Tvalue; name: PChar; attr1: TAttr1);
procedure ap_define_const(klass: Tvalue; const name: String; v: Tvalue);
procedure ap_data_get_object(v: Tvalue; AClass: TClass; var ret);

implementation

uses SysUtils, uStrUtils;

procedure DefineSingletonMethod(klass: Tvalue; name: PChar; func1: TFunc1);
begin
  rb_define_singleton_method(klass, name, @func1, -1);
end;

procedure DefineMethod(klass: Tvalue; name: PChar; func1: TFunc1);
begin
  rb_define_method(klass, name, @func1, -1);
end;

procedure DefineAttrGet(klass: Tvalue; name: PChar; attr0: TAttr0);
begin
  rb_define_method(klass, name, @attr0, 0);
end;

procedure DefineAttrSet(klass: Tvalue; name: PChar; attr1: TAttr1);
begin
  rb_define_method(klass, PChar(joinEq(name)), @attr1, 1);
end;

procedure DefineModuleFunction(module: Tvalue; name: PChar; func1: TFunc1);
begin
  rb_define_module_function(module, name, @func1, -1);
end;

procedure DefineModuleAttrGet(module: Tvalue; name: PChar; attr0: TAttr0);
begin
  rb_define_module_function(module, name, @attr0, 0);
end;

procedure DefineModuleAttrSet(module: Tvalue; name: PChar; attr1: TAttr1);
begin
  rb_define_module_function(module, PChar(joinEq(name)), @attr1, 1);
end;

procedure ap_define_const(klass: Tvalue; const name: String; v: Tvalue);
begin
  rb_define_const(klass, PChar(UpperCase1(name)), v);
end;

procedure ap_data_get_object(v: Tvalue; AClass: TClass; var Ret);
var
  Obj: TObject absolute Ret;
begin
  if v = Qnil then
    TObject(ret) := nil
  else
  begin
    Obj := ap_data_get_struct(v);
    if not (Obj is AClass) then
      ap_raise(ap_eArgError,
        Format('%s %s (expected %s)', [
           sWrong_arg_type,
           chopHead(Obj.ClassName),
           chopHead(AClass.ClassName)
        ]));
//    TObject(Ret) := Obj;
  end;
end;

end.
