unit uUpDown;

interface

uses Rubies, ComCtrls;

var
  cUpDown: Tvalue;

function ap_cUpDown: Tvalue;
function ap_iUpDown(real: TUpDown; owner: Tvalue): Tvalue;
procedure Init_UpDown;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

function ap_cUpDown: Tvalue;
begin
  result := cUpDown;
end;

procedure UpDown_setup(obj: Tvalue; real: TUpDown);
begin
//    AssignPropMethod(real, [Handle]);
end;

function UpDown_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function UpDown_alloc(This: Tvalue; real: TUpDown): Tvalue;
begin
  result := ChildAlloc(This, real);
  UpDown_setup(result, real);
end;

function ap_iUpDown(real: TUpDown; owner: Tvalue): Tvalue;
begin
  result := UpDown_alloc(cUpDown, real);
  ap_owner(result, owner);
end;

function ap_iUpDown_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iUpDown(TUpDown(AControl), owner);
end;

function UpDown_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TUpDown;
begin
  real := TUpDown.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  UpDown_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

procedure Init_UpDown;
begin
  cUpDown := OutputPersistentClass(mPhi, TUpDown, cWinControl, ap_iUpDown_v);
  rb_define_method(cUpDown, 'event_handle', @UpDown_event_handle, 1);
  DefineSingletonMethod(cUpDown, 'new', UpDown_new);
end;

end.
