unit uTrackBar;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  Rubies;

var
  cTrackBar: Tvalue;

function ap_cTrackBar: Tvalue;
function ap_iTrackBar(real: TTrackBar; owner: Tvalue): Tvalue;
procedure Init_TrackBar;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

function ap_cTrackBar: Tvalue;
begin
  result := cTrackBar;
end;

procedure TrackBar_setup(obj: Tvalue; real: TTrackBar);
begin
//    AssignPropMethod(real, [Handle]);
end;

function TrackBar_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function TrackBar_alloc(This: Tvalue; real: TTrackBar): Tvalue;
begin
  result := ChildAlloc(This, real);
  TrackBar_setup(result, real);
end;

function ap_iTrackBar(real: TTrackBar; owner: Tvalue): Tvalue;
begin
  result := TrackBar_alloc(cTrackBar, real);
  ap_owner(result, owner);
end;

function ap_iTrackBar_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iTrackBar(TTrackBar(AControl), owner);
end;

function TrackBar_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TTrackBar;
begin
  real := TTrackBar.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  TrackBar_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

procedure Init_TrackBar;
begin
  cTrackBar := OutputPersistentClass(mPhi, TTrackBar, cWinControl, ap_iTrackBar_v);
  rb_define_method(cTrackBar, 'event_handle', @TrackBar_event_handle, 1);
  DefineSingletonMethod(cTrackBar, 'new', TrackBar_new);
end;

end.
