unit uPanel;

interface

uses
{$IFDEF VCL}
  ExtCtrls,
{$ELSE}
  QExtCtrls,
{$ENDIF}
  Rubies;

var
  cPanel: Tvalue;

function ap_cPanel: Tvalue;
function ap_iPanel(real: TPanel; owner: Tvalue): Tvalue;
procedure Init_Panel;

implementation

uses
  Classes,
{$IFDEF VCL}
  Controls,
{$ELSE}
  QControls,
{$ENDIF}
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uFont,
  uPersistent, uComponent, uControl;

function ap_cPanel: Tvalue;
begin
  result := cPanel;
end;

procedure Panel_setup(obj: Tvalue; real: TPanel);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
  ap_set_child_attr_module(obj);
//    AssignPropMethod(real, [Handle]);
end;

function Panel_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function Panel_alloc(This: Tvalue; real: TPanel): Tvalue;
begin
  result := ChildAlloc(This, real);
  Panel_setup(result, real);
end;

function ap_iPanel(real: TPanel; owner: Tvalue): Tvalue;
begin
  result := Panel_alloc(cPanel, real);
  ap_owner(result, owner);
end;

function ap_iPanel_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iPanel(TPanel(AControl), owner);
end;

function Panel_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TPanel;
begin
  real := TPanel.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  Panel_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

procedure Init_Panel;
begin
  OutputConstSetType(mPhi, TypeInfo(TBevelCut));
  cPanel := OutputPersistentClass(mPhi, TPanel, cWinControl, ap_iPanel_v);
  rb_define_method(cPanel, 'event_handle', @Panel_event_handle, 1);
  DefineSingletonMethod(cPanel, 'new', Panel_new);
end;

end.
