unit uHeaderControl;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  ExtCtrls,
  Rubies;

var
  cHeaderControl: Tvalue;

function ap_cHeaderControl: Tvalue;
function ap_iHeaderControl(real: THeaderControl; owner: Tvalue): Tvalue;
procedure Init_HeaderControl;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uConv,
  uIndexer,
  Graphics,
  uPersistent, uComponent, uControl;

function ap_cHeaderControl: Tvalue;
begin
  result := cHeaderControl;
end;

procedure HeaderControl_setup(obj: Tvalue; real: THeaderControl);
begin
//    AssignPropMethod(real, [Handle]);
end;

function HeaderControl_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function HeaderControl_alloc(This: Tvalue; real: THeaderControl): Tvalue;
begin
  result := ChildAlloc(This, real);
  HeaderControl_setup(result, real);
end;

function ap_iHeaderControl(real: THeaderControl; owner: Tvalue): Tvalue;
begin
  result := HeaderControl_alloc(cHeaderControl, real);
  ap_owner(result, owner);
end;

function ap_iHeaderControl_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iHeaderControl(THeaderControl(AControl), owner);
end;

function HeaderControl_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: THeaderControl;
begin
  real := THeaderControl.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  HeaderControl_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

procedure Init_HeaderControl;
begin
  cHeaderControl := OutputPersistentClass(mPhi, THeaderControl, cWinControl, ap_iHeaderControl_v);
  rb_define_method(cHeaderControl, 'event_handle', @HeaderControl_event_handle, 1);
  DefineSingletonMethod(cHeaderControl, 'new', HeaderControl_new);

end;

end.
