unit uColorBox;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  ExtCtrls,
  Rubies;

var
  cColorBox: Tvalue;

function ap_cColorBox: Tvalue;
function ap_iColorBox(real: TColorBox; owner: Tvalue): Tvalue;
procedure Init_ColorBox;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uConv,
  uIndexer,
  Graphics,
  uPersistent, uComponent, uControl;

function ap_cColorBox: Tvalue;
begin
  result := cColorBox;
end;

procedure ColorBox_setup(obj: Tvalue; real: TColorBox);
begin
//    AssignPropMethod(real, [Handle]);
end;

function ColorBox_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ColorBox_alloc(This: Tvalue; real: TColorBox): Tvalue;
begin
  result := ChildAlloc(This, real);
  ColorBox_setup(result, real);
end;

function ap_iColorBox(real: TColorBox; owner: Tvalue): Tvalue;
begin
  result := ColorBox_alloc(cColorBox, real);
  ap_owner(result, owner);
end;

function ap_iColorBox_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iColorBox(TColorBox(AControl), owner);
end;

function ColorBox_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TColorBox;
begin
  real := TColorBox.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  ColorBox_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

(**** str_my_class made by ap_src_maker ****)
type
TPhi_ColorBox = class(TColorBox)
end;
(**** made by ap_src_maker ****)
(**** str_method made by ap_src_maker ****)

function ColorBox_get_colors(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ColorBox;
  dlv_Index : Integer;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  result := ap_Integer(ord(real.Colors[dlv_Index]));
end;

function ColorBox_get_color_names(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ColorBox;
  dlv_Index : Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  result := ap_String(real.ColorNames[dlv_Index]);
end;

function ColorBox_get_selected(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ColorBox;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(ord(real.Selected));  
end;

function ColorBox_set_selected(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ColorBox;
begin
  real := ap_data_get_struct(This);
  real.Selected := TColor(dl_Integer(v));
  result := v;
end;

function ColorBox_get_default_color_color(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ColorBox;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(ord(real.DefaultColorColor));  
end;

function ColorBox_set_default_color_color(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ColorBox;
begin
  real := ap_data_get_struct(This);
  real.DefaultColorColor := TColor(dl_Integer(v));
  result := v;
end;

function ColorBox_get_none_color_color(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ColorBox;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(ord(real.NoneColorColor));  
end;

function ColorBox_set_none_color_color(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ColorBox;
begin
  real := ap_data_get_struct(This);
  real.NoneColorColor := TColor(dl_Integer(v));
  result := v;
end;

//  TColorBoxStyles = (cbStandardColors, // first sixteen RGBI colors
//                     cbExtendedColors, // four additional reserved colors
//                     cbSystemColors,   // system managed/defined colors
//                     cbIncludeNone,    // include clNone color, must be used with cbSystemColors
//                     cbIncludeDefault, // include clDefault color, must be used with cbSystemColors
//                     cbCustomColor,    // first color is customizable
//                     cbPrettyNames);   // instead of 'clColorNames' you get 'Color Names'
//  TColorBoxStyle = set of TColorBoxStyles;
//
//
//function ColorBox_get_style(This: Tvalue): Tvalue; cdecl;
//var
//  real: TPhi_ColorBox;
//begin
//  real := ap_data_get_struct(This);
//  result := ap_Integer(ord(real.Style));  
//end;
//
//function ColorBox_set_style(This, v: Tvalue): Tvalue; cdecl;
//var
//  real: TPhi_ColorBox;
//begin
//  real := ap_data_get_struct(This);
//  real.Style := TColorBoxStyle(dl_Integer(v));
//  result := v;
//end;


(**** made by ap_src_maker ****)

procedure Init_ColorBox;
begin
  cColorBox := OutputPersistentClass(mPhi, TColorBox, cWinControl, ap_iColorBox_v);
  rb_define_method(cColorBox, 'event_handle', @ColorBox_event_handle, 1);
  DefineSingletonMethod(cColorBox, 'new', ColorBox_new);

(**** str_init made by ap_src_maker ****)
  DefineIndexer(cColorBox, 'colors', @ColorBox_get_colors, nil);
  DefineIndexer(cColorBox, 'color_names', @ColorBox_get_color_names, nil);
  DefineAttrGet(cColorBox, 'selected', ColorBox_get_selected);
  DefineAttrSet(cColorBox, 'selected', ColorBox_set_selected);
  DefineAttrGet(cColorBox, 'default_color_color', ColorBox_get_default_color_color);
  DefineAttrSet(cColorBox, 'default_color_color', ColorBox_set_default_color_color);
  DefineAttrGet(cColorBox, 'none_color_color', ColorBox_get_none_color_color);
  DefineAttrSet(cColorBox, 'none_color_color', ColorBox_set_none_color_color);
//  DefineAttrGet(cColorBox, 'style', ColorBox_get_style);
//  DefineAttrSet(cColorBox, 'style', ColorBox_set_style);
(**** made by ap_src_maker ****)

end;

end.
