require "test/unit"
require "phi"
class TCListItems < Test::Unit::TestCase
  def test_new
    assert_raise(NoMethodError) { Phi::ListItems.new }
  end
  def test_ancestors
    assert_equal Phi::Persistent, Phi::ListItems.superclass
  end
  def self.new_items
    form = Phi::Form.new :form
    lv = Phi::ListView.new form, :lv
    lv.items
  end
  def test_count
    items = self.class.new_items
    assert_equal 0, items.count
  end
  def test_delete
    items = self.class.new_items
    item = items.add
    assert_equal 0, item.index
    assert_equal 1, items.count
    assert_respond_to items, :delete
    assert_equal items, items.delete(0)
    assert_equal 0, items.count
    assert_raise(Phi::DelphiError) { item.index }
  end
end
class TCListItem < Test::Unit::TestCase
  def test_item_new
    assert_raise(NoMethodError) { Phi::ListItem.new }
  end
  def test_item_ancestors
    assert_equal Phi::Persistent, Phi::ListItem.superclass
  end
  def self.new_item
    items = TCListItems.new_items
    items.add
  end
  def test_top
    item = self.class.new_item
    assert_respond_to item, :top
    assert_equal 2, item.top
  end
  def test_left
    item = self.class.new_item
    assert_respond_to item, :left
    assert_equal 23, item.left
  end
  def test_selected
    item = self.class.new_item
    assert_respond_to item, :selected
    assert_respond_to item, :selected?
    assert_respond_to item, :selected=
    assert ! item.selected?
  end
  def test_checked
    item = self.class.new_item
    assert_respond_to item, :checked
    assert_respond_to item, :checked?
    assert_respond_to item, :checked=
    item.owner.owner.checkboxes = true
    assert ! item.checked?
  end
  def test_image_index
    item = self.class.new_item
    assert_respond_to item, :image_index
    assert_respond_to item, :image_index=
    assert_equal 0, item.image_index
  end
  def test_state_index
    item = self.class.new_item
    assert_respond_to item, :state_index
    assert_respond_to item, :state_index=
    assert_equal 0, item.image_index
  end
  # VCL only
  def test_overlay_index
    item = self.class.new_item
    assert_respond_to item, :overlay_index
    assert_respond_to item, :overlay_index=
    assert_equal -1, item.overlay_index
  end
  def test_sub_item_images
    item = self.class.new_item
    assert_respond_to item, :sub_item_images
    assert_instance_of Phi::Indexer, item.sub_item_images
    assert_raise(IndexError) { item.sub_item_images[0] }
    assert_raise(IndexError) { item.sub_item_images[0]=0 }
  end
  def test_cancel_edit
    item = self.class.new_item
    assert_respond_to item, :cancel_edit
    assert item, item.cancel_edit
  end
  def test_edit_caption
    item = self.class.new_item
    assert_respond_to item, :edit_caption
    # C:/usr/lib/ruby/1.8/test/unit/autorunner.rb:20: in `edit_caption': /\EBhEɂ̓tH[JXݒł܂ (EInvalidOperation)
    form = item.owner.owner.parent
    form.show
    assert item.edit_caption
  end
  def test_display_rect
    item = self.class.new_item
    assert_respond_to item, :display_rect
    rect = item.display_rect(Phi::DR_BOUNDS)
    assert_instance_of Phi::Rect, rect
    assert_equal [0, 0, 46, 20], rect.to_a 
  end
  # function GetPositionproperty PositionƓ 
  def test_get_position
    item = self.class.new_item
    assert_respond_to item, :position
    point = item.position
    assert_instance_of Phi::Point, point
    assert_equal [23, 2], point.to_a
  end
  # procedure SetPositionproperty PositionƓ 
  def test_set_position
    item = self.class.new_item
    assert_respond_to item, :position=
    point = Phi::Point.new(46, 4)
    assert_equal point, item.position=(point)
    new_point = item.position
    assert_equal point.to_a, new_point.to_a
  end
  def test_make_visible
    item = self.class.new_item
    assert_respond_to item, :make_visible
    assert item, item.make_visible(true)
  end
  def test_handle
    item = self.class.new_item
    assert_respond_to item, :handle
  end
  # VCL only
  def test_indent
    item = self.class.new_item
    assert_respond_to item, :indent
    assert_respond_to item, :indent=
    assert_equal 0, item.indent
  end
  # VCL only
  def test_cut
    item = self.class.new_item
    assert_respond_to item, :cut
    assert_respond_to item, :cut?
    assert_respond_to item, :cut=
    assert ! item.cut
    assert ! item.cut?
    item.cut = true
    assert item.cut
    assert item.cut?
  end
  # VCL only
  def test_deleting
    item = self.class.new_item
    assert_respond_to item, :deleting
    assert_respond_to item, :deleting?
    assert ! item.deleting
    assert ! item.deleting?
  end
  # VCL only
  def test_drop_target
    item = self.class.new_item
    assert_respond_to item, :drop_target
    assert_respond_to item, :drop_target?
    assert_respond_to item, :drop_target=
    assert ! item.drop_target
    assert ! item.drop_target?
    item.drop_target = true
    assert item.drop_target
    assert item.drop_target?
  end
  def test_focused
    item = self.class.new_item
    assert_respond_to item, :focused
    assert_respond_to item, :focused?
    assert_respond_to item, :focused=
    assert ! item.focused
    assert ! item.focused?
    item.focused = true
    assert item.focused
    assert item.focused?
  end
  def test_delete
    item = self.class.new_item
    assert_equal 0, item.index
    assert_equal 1, item.owner.count
    assert_respond_to item, :delete
    assert_equal item, item.delete
    assert_equal 0, item.owner.count
    assert_raise(Phi::DelphiError) { item.index }
  end
  def test_assign
    item = self.class.new_item
    assert_respond_to item, :assign
    assert_raise(ArgumentError) { item.assign }
    assert item, item.assign(item)

    assert_equal item, item.delete
    item2 = self.class.new_item
    assert_raise(Phi::DelphiError) { item.assign(item2) }
    assert_raise(Phi::DelphiError) { item2.assign(item) }
  end
end
