unit uRequest;

interface

uses Classes, HTTPApp, Rubies;

function ap_cRequest: Tvalue;
function ap_iRequest(real: TWebRequest; owner: Tvalue): Tvalue;
procedure Init_Request;

implementation

uses
  SysUtils, uDefUtils, Pythia, uWeb, WebHandle, TypInfo;

function ap_cRequest: Tvalue;
begin
  result := cRequest;
end;

procedure Request_setup(obj: Tvalue; real: TWebRequest);
begin
  rb_iv_set(obj, '@content_fields', ap_iStrings(real.ContentFields, obj));
  rb_iv_set(obj, '@cookie_fields', ap_iStrings(real.CookieFields, obj));
  rb_iv_set(obj, '@query_fields', ap_iStrings(real.QueryFields, obj));
end;

function Request_alloc(This: Tvalue; real: TWebRequest): Tvalue;
begin
  result := TmpAlloc(This, real);
  Request_setup(result, real);
end;

function ap_iRequest(real: TWebRequest; owner: Tvalue): Tvalue;
begin
  result := Request_alloc(cRequest, real);
  ap_owner(result, owner);
end;

function ap_iRequest_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iRequest(TWebRequest(AControl), owner)
end;

function dl_Request(This: Tvalue): TWebRequest;
begin
  result := ap_data_get_struct(This);
end;

function Request_aref(This, name: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).GetFieldByName(dl_String(name)));
end;

function Request_get_method_type(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Fixnum(Ord(dl_Request(This).MethodType));
end;

function Request_get_method(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).Method);
end;

function Request_get_protocol_version(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).ProtocolVersion);
end;

function Request_get_url(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).URL);
end;

function Request_get_query(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).Query);
end;

function Request_get_path_info(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).PathInfo);
end;

function Request_get_path_translated(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).PathTranslated);
end;

function Request_get_authorization(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).Authorization);
end;

function Request_get_cache_control(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).CacheControl);
end;

function Request_get_cookie(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).Cookie);
end;

function Request_get_date(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_DateTime(dl_Request(This).Date);
end;

function Request_get_accept(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).Accept);
end;

function Request_get_from(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).From);
end;

function Request_get_host(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).Host);
end;

function Request_get_if_modified_since(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_DateTime(dl_Request(This).IfModifiedSince);
end;

function Request_get_referer(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).Referer);
end;

function Request_get_user_agent(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).UserAgent);
end;

function Request_get_content_encoding(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).ContentEncoding);
end;

function Request_get_content_type(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).ContentType);
end;

function Request_get_content_length(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Fixnum(dl_Request(This).ContentLength);
end;

function Request_get_content_version(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).ContentVersion);
end;

function Request_get_content(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).Content);
end;

function Request_get_connection(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).Connection);
end;

function Request_get_derived_from(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).DerivedFrom);
end;

function Request_get_expires(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_DateTime(dl_Request(This).Expires);
end;

function Request_get_title(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).Title);
end;

function Request_get_remote_addr(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).RemoteAddr);
end;

function Request_get_remote_host(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).RemoteHost);
end;

function Request_get_script_name(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).ScriptName);
end;

function Request_get_server_port(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Fixnum(dl_Request(This).ServerPort);
end;

function Request_get_internal_path_info(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).InternalPathInfo);
end;

function Request_get_internal_script_name(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).InternalScriptName);
end;
(*
function Request_get_files(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Request(This).Files);
end;
*)
procedure Init_Request;
begin
  DefineConstSetType(mWeb, TypeInfo(TMethodType));
  cRequest := rb_define_class_under(mWeb, 'Request', ap_cObject);
//  DefineProp(cRequest, TWebRequest);
  rb_define_attr(cRequest, 'content_fields', 1, 0);
  rb_define_attr(cRequest, 'cookie_fields', 1, 0);
  rb_define_attr(cRequest, 'query_fields', 1, 0);
  rb_define_method(cRequest, '[]', @Request_aref, 1);
  DefineAttrGet(cRequest, 'method_type', Request_get_method_type);
  DefineAttrGet(cRequest, 'method', Request_get_method);
  DefineAttrGet(cRequest, 'protocol_version', Request_get_protocol_version);
  DefineAttrGet(cRequest, 'url', Request_get_url);
  DefineAttrGet(cRequest, 'query', Request_get_query);
  DefineAttrGet(cRequest, 'path_info', Request_get_path_info);
  DefineAttrGet(cRequest, 'path_translated', Request_get_path_translated);
  DefineAttrGet(cRequest, 'authorization', Request_get_authorization);
  DefineAttrGet(cRequest, 'cache_control', Request_get_cache_control);
  DefineAttrGet(cRequest, 'cookie', Request_get_cookie);
  DefineAttrGet(cRequest, 'date', Request_get_date);
  DefineAttrGet(cRequest, 'accept', Request_get_accept);
  DefineAttrGet(cRequest, 'from', Request_get_from);
  DefineAttrGet(cRequest, 'host', Request_get_host);
  DefineAttrGet(cRequest, 'if_modified_since', Request_get_if_modified_since);
  DefineAttrGet(cRequest, 'referer', Request_get_referer);
  DefineAttrGet(cRequest, 'user_agent', Request_get_user_agent);
  DefineAttrGet(cRequest, 'content_encoding', Request_get_content_encoding);
  DefineAttrGet(cRequest, 'content_type', Request_get_content_type);
  DefineAttrGet(cRequest, 'content_length', Request_get_content_length);
  DefineAttrGet(cRequest, 'content_version', Request_get_content_version);
  DefineAttrGet(cRequest, 'content', Request_get_content);
  DefineAttrGet(cRequest, 'connection', Request_get_connection);
  DefineAttrGet(cRequest, 'derived_from', Request_get_derived_from);
  DefineAttrGet(cRequest, 'expires', Request_get_expires);
  DefineAttrGet(cRequest, 'title', Request_get_title);
  DefineAttrGet(cRequest, 'remote_addr', Request_get_remote_addr);
  DefineAttrGet(cRequest, 'remote_host', Request_get_remote_host);
  DefineAttrGet(cRequest, 'script_name', Request_get_script_name);
  DefineAttrGet(cRequest, 'server_port', Request_get_server_port);
  DefineAttrGet(cRequest, 'internal_path_info', Request_get_internal_path_info);
  DefineAttrGet(cRequest, 'internal_script_name', Request_get_internal_script_name);
//  DefineAttrGet(cRequest, 'files', Request_get_files);
end;

end.

