unit uCookie;

interface

uses
  Rubies, HTTPApp;

var
  cCookie: Tvalue;

function ap_iCookie(real: TCookie; owner: Tvalue): Tvalue;
procedure Init_Cookie;

implementation

uses
  uDefUtils, Pythia, uWeb;

procedure Cookie_setup(obj: Tvalue; real: TCookie);
begin
//  rb_iv_set(obj, '@expires', ap_DateTime(real.Expires));
end;

function Cookie_alloc(This: Tvalue; real: TCookie): Tvalue;
begin
  result := TmpAlloc(This, real);
  Cookie_setup(result, real);
end;

function ap_iCookie(real: TCookie; owner: Tvalue): Tvalue;
begin
  result := Cookie_alloc(cCookie, real);
  ap_owner(result, owner);
end;

function ap_iCookie_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iCookie(TCookie(obj), owner);
end;

function dl_Cookie(This: Tvalue): TCookie;
begin
  result := ap_data_get_struct(This);
end;

function Cookie_get_name(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Cookie(This).Name);
end;

function Cookie_set_name(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Cookie(This).Name := dl_String(v);
  result := v;
end;

function Cookie_get_value(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Cookie(This).Value);
end;

function Cookie_set_value(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Cookie(This).Value := dl_String(v);
  result := v;
end;

function Cookie_get_domain(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Cookie(This).Domain);
end;

function Cookie_set_domain(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Cookie(This).Domain := dl_String(v);
  result := v;
end;

function Cookie_get_path(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Cookie(This).Path);
end;

function Cookie_set_path(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Cookie(This).Path := dl_String(v);
  result := v;
end;

function Cookie_get_expires(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_DateTime(dl_Cookie(This).Expires);
end;

function Cookie_set_expires(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Cookie(This).Expires := dl_DateTime(v);
  result := v;
end;

function Cookie_get_secure(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(dl_Cookie(This).Secure);
end;

function Cookie_set_secure(This, v: Tvalue): Tvalue; cdecl;
begin
  dl_Cookie(This).Secure := dl_Boolean(v);
  result := v;
end;

function Cookie_get_header_value(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Cookie(This).HeaderValue);
end;

procedure Init_Cookie;
begin
  cCookie := DefinePersistentClass(mWeb, TCookie, ap_cCollectionItem, ap_iCookie_v);
//  DefineProp(cCookie, TCookie);
  DefineAttrGet(cCookie, 'name', Cookie_get_name);
  DefineAttrSet(cCookie, 'name', Cookie_set_name);
  DefineAttrGet(cCookie, 'value', Cookie_get_value);
  DefineAttrSet(cCookie, 'value', Cookie_set_value);
  DefineAttrGet(cCookie, 'domain', Cookie_get_domain);
  DefineAttrSet(cCookie, 'domain', Cookie_set_domain);
  DefineAttrGet(cCookie, 'path', Cookie_get_path);
  DefineAttrSet(cCookie, 'path', Cookie_set_path);
  DefineAttrGet(cCookie, 'expires', Cookie_get_expires);
  DefineAttrSet(cCookie, 'expires', Cookie_set_expires);
  DefineAttrGet(cCookie, 'secure', Cookie_get_secure);
  DefineAttrSet(cCookie, 'secure', Cookie_set_secure);
  DefineAttrGet(cCookie, 'header_value', Cookie_get_header_value);
end;

end.
