unit uDBMemo;

interface

uses
  DB,
{$IFDEF VCL}
  DBCtrls,
{$ELSE}
  QDBCtrls,
{$ENDIF}
  Rubies;

var
  cDBMemo: Tvalue;

procedure Init_DBMemo;

implementation

uses uDefUtils, Pythia, uRDB, udataSource;

procedure DBMemo_setup(obj: Tvalue; real: TDBMemo);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
{$IFDEF VCL}
  rb_iv_set(obj, '@lines', ap_iStrings(real.Lines, obj));
{$ENDIF}
//    AssignPropMethod(real, [PhiGetHandle]);
end;

function DBMemo_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [PhiGetHandle]);
  result := Qnil;
end;

function DBMemo_alloc(This: Tvalue; real: TDBMemo): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBMemo_setup(result, real);
end;

function ap_iDBMemo(real: TDBMemo; owner: Tvalue): Tvalue;
begin
  result := DBMemo_alloc(cDBMemo, real);
  ap_owner(result, owner);
end;

function ap_iDBMemo_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDBMemo(TDBMemo(AControl), owner)
end;

function DBMemo_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TDBMemo;
begin
  real := TDBMemo.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  DBMemo_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function DBMemo_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TDBMemo;
  DataSource: TDataSource;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TDataSource, DataSource);
  real.DataSource := DataSource;
  result := v;
end;

function DBMemo_set_data_field(This, v: Tvalue): Tvalue; cdecl;
var
  real: TDBMemo;
begin
  real := ap_data_get_struct(This);
  real.DataField := dl_String(v);
  result := v;
end;

procedure Init_DBMemo;
begin
  cDBMemo := DefinePersistentClass(mRDB, TDBMemo, ap_cMemo, ap_iDBMemo_v);
  rb_define_method(cDBMemo, 'event_handle', @DBMemo_event_handle, 1);
  DefineSingletonMethod(cDBMemo, 'new', DBMemo_new);
  DefineAttrSet(cDBMemo, 'data_source', DBMemo_set_data_source);
  DefineAttrSet(cDBMemo, 'data_field', DBMemo_set_data_field);
end;

end.
