unit uDBLookupComboBox;

interface

uses
  DB,
{$IFDEF VCL}
  DBCtrls,
{$ELSE}
  QDBCtrls,
{$ENDIF}
  Rubies;

type
  TPhi_DBLookupComboBox = class(TDBLookupComboBox)
//  published
//    property Text;
  end;

var
  cDBLookupComboBox: Tvalue;

function ap_iDBLookupComboBox(real: TPhi_DBLookupComboBox; owner: Tvalue): Tvalue;
procedure Init_DBLookupComboBox;

implementation

uses uDefUtils, Pythia, uRDB;

procedure DBLookupComboBox_setup(obj: Tvalue; real: TPhi_DBLookupComboBox);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle, PhiGetHandle]);
end;

function DBLookupComboBox_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function DBLookupComboBox_alloc(This: Tvalue; real: TPhi_DBLookupComboBox): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBLookupComboBox_setup(result, real);
end;

function ap_iDBLookupComboBox(real: TPhi_DBLookupComboBox; owner: Tvalue): Tvalue;
begin
  result := DBLookupComboBox_alloc(cDBLookupComboBox, real);
  ap_owner(result, owner);
end;

function ap_iDBLookupComboBox_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDBLookupComboBox(TPhi_DBLookupComboBox(AControl), owner)
end;

function DBLookupComboBox_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBLookupComboBox;
begin
  real := TPhi_DBLookupComboBox.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  DBLookupComboBox_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function DBLookupComboBox_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBLookupComboBox;
  DataSource: TDataSource;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TDataSource, DataSource);
  real.DataSource := DataSource;
  result := v;
end;

function DBLookupComboBox_set_data_field(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBLookupComboBox;
begin
  real := ap_data_get_struct(This);
  real.DataField := dl_String(v);
  result := v;
end;

procedure Init_DBLookupComboBox;
begin
  cDBLookupComboBox := DefinePersistentClass(mRDB, TPhi_DBLookupComboBox, ap_cEdit, ap_iDBLookupComboBox_v);
  rb_define_method(cDBLookupComboBox, 'event_handle', @DBLookupComboBox_event_handle, 1);
  DefineSingletonMethod(cDBLookupComboBox, 'new', DBLookupComboBox_new);
  DefineAttrSet(cDBLookupComboBox, 'data_source', DBLookupComboBox_set_data_source);
  DefineAttrSet(cDBLookupComboBox, 'data_field', DBLookupComboBox_set_data_field);
end;

end.
