unit uSQLStoredProc;

interface

uses Rubies, SqlExpr;

var
  cSQLStoredProc: Tvalue;

function ap_cSQLStoredProc: Tvalue;
function ap_iSQLStoredProc(real: TSQLStoredProc; owner: Tvalue): Tvalue;
procedure Init_SQLStoredProc;

implementation

uses uDefUtils, Pythia, uRDBExt{, uDataSet, uParam};

function ap_cSQLStoredProc: Tvalue;
begin
  result := cSQLStoredProc;
end;

procedure SQLStoredProc_setup(obj: Tvalue; real: TSQLStoredProc);
begin
  DataSet_setup(obj, real);
end;

function SQLStoredProc_alloc(This: Tvalue; real: TSQLStoredProc): Tvalue;
begin
  result := ChildAlloc(This, real);
  SQLStoredProc_setup(result, real);
end;

function ap_iSQLStoredProc(real: TSQLStoredProc; owner: Tvalue): Tvalue;
begin
  result := SQLStoredProc_alloc(cSQLStoredProc, real);
  ap_owner(result, owner);
end;

function ap_iSQLStoredProc_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iSQLStoredProc(TSQLStoredProc(obj), owner);
end;

function SQLStoredProc_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TSQLStoredProc;
begin
  real := TSQLStoredProc.Create(nil);
  result := DataSet_alloc(This, real);
  SQLStoredProc_setup(result, real);

  rb_obj_call_init(result, argc, argv);
end;

function SQLStoredProc_exec_proc(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLStoredProc;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.ExecProc);
end;

function SQLStoredProc_get_params(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLStoredProc;
begin
  real := ap_data_get_struct(This);
  result := ap_iParams(real.Params, This);
end;

procedure Init_SQLStoredProc;
begin
  cSQLStoredProc := DefinePersistentClass(ap_mRDB, TSQLStoredProc, ap_cPersistent, nil);
  DefineSingletonMethod(cSQLStoredProc, 'new', SQLStoredProc_new);
  rb_define_method(cSQLStoredProc, 'exec_proc', @SQLStoredProc_exec_proc, 0);
  DefineAttrGet(cSQLStoredProc, 'params', SQLStoredProc_get_params);
end;

end.
