unit uADOTable;

interface

uses ADODB, Rubies;

var
  cADOTable: Tvalue;

function ap_cADOTable: Tvalue;
function ap_iADOTable(real: TADOTable; owner: Tvalue): Tvalue;
procedure Init_ADOTable;

implementation

uses SysUtils, uDefUtils, Pythia, uRDBExt{, uDataSet, uFieldDef, uIndexDef}, uADODataSet;

function ap_cADOTable: Tvalue;
begin
  result := cADOTable;
end;

procedure ADOTable_setup(obj: Tvalue; real: TADOTable);
begin
  DataSet_setup(obj, real);
  rb_iv_set(obj, '@index_defs', ap_iIndexDefs(real.IndexDefs, obj));
end;

function ADOTable_alloc(This: Tvalue; real: TADOTable): Tvalue;
begin
  result := ChildAlloc(This, real);
  ADOTable_setup(result, real);
end;

function ap_iADOTable(real: TADOTable; owner: Tvalue): Tvalue;
begin
  result := ADOTable_alloc(cADOTable, real);
  ap_owner(result, owner);
end;

function ap_iADOTable_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iADOTable(TADOTable(obj), owner);
end;

function ADOTable_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TADOTable;
begin
  real := TADOTable.Create(nil);
  result := DataSet_alloc(This, real);
  ADOTable_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_ADOTable;
begin
  cADOTable := DefinePersistentClass(ap_mRDB, TADOTable, cADODataSet, ap_iADOTable_v);
  DefineSingletonMethod(cADOTable, 'new', ADOTable_new);
end;

end.
