unit uPropGridItems;

interface

uses
  Rubies, HPropGrid;

function ap_cPropGridItems: Tvalue;
function ap_iPropGridItems(real: TPropGridItems; owner: Tvalue): Tvalue;
procedure Init_PropGridItems;

implementation

uses
  SysUtils, Pythia, uDefUtils, uPropGridItem;

var
  cPropGridItems: Tvalue;

function ap_cPropGridItems: Tvalue;
begin
  result := cPropGridItems;
end;

procedure PropGridItems_setup(obj: Tvalue; real: TPropGridItems);
begin
  Collection_setup(obj, real);
end;

function PropGridItems_alloc(This: Tvalue; real: TPropGridItems): Tvalue;
begin
  result := TmpAlloc(This, real);
  PropGridItems_setup(result, real);
end;

function ap_iPropGridItems(real: TPropGridItems; owner: Tvalue): Tvalue;
begin
  result := PropGridItems_alloc(cPropGridItems, real);
  ap_owner(result, owner);
end;

function ap_iPropGridItems_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iPropGridItems(TPropGridItems(AControl), owner);
end;

function PropGridItems_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TPropGridItems;
begin
  real := TPropGridItems.Create(nil);
  result := ObjAlloc(This, real);
  PropGridItems_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_PropGridItems;
begin
  cPropGridItems := DefinePersistentClass(ap_mPhi, TPropGridItems, ap_cCollection, ap_iPropGridItems_v);
  SetCollectionItemClass(cPropGridItems, 'TPropGridItem');
  DefineSingletonMethod(cPropGridItems, 'new', @PropGridItems_new);
end;

end.
