unit uEditorEx;

interface

uses Classes, Controls, Rubies, HEditor, EditorEx;

var
  cEditorEx: Tvalue;
  cEditorExMarks: Tvalue;

function ap_cEditorEx: Tvalue;
function ap_iEditorEx(real: TEditorEx; owner: Tvalue): Tvalue;
procedure Init_EditorEx_module;

implementation

uses uDefUtils, Pythia, uNotifyPersistent, uEditorMark, uEditor;

procedure EditorExMarks_setup(obj: Tvalue; real: TEditorExMarks);
begin
  EditorMarks_setup(obj, TEditorMarks(real));
  rb_iv_set(obj, '@db_space_mark' , ap_iEditorMark(real.DBSpaceMark, obj));
  rb_iv_set(obj, '@space_mark'   , ap_iEditorMark(real.SpaceMark, obj));
  rb_iv_set(obj, '@tab_mark'     , ap_iEditorMark(real.TabMark, obj));
  rb_iv_set(obj, '@find_mark'    , ap_iEditorMark(real.FindMark, obj));
end;

function EditorExMarks_alloc(This: Tvalue; real: TEditorExMarks): Tvalue;
begin
  result := TmpAlloc(This, real);
  EditorExMarks_setup(result, real);
end;

function ap_cEditorEx: Tvalue;
begin
  result := cEditorEx;
end;

procedure EditorEx_setup(This: Tvalue; real: TEditorEx);
begin
  Editor_setup(This, real);
  rb_iv_set(This, '@ex_marks', EditorExMarks_alloc(cEditorExMarks, real.ExMarks));
end;

function EditorEx_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [EditorGetHandle, PhiGetHandle]);
  result := Qnil;
end;

function EditorEx_alloc(This: Tvalue; real: TEditorEx): Tvalue;
begin
  result := ChildAlloc(This, real);
  EditorEx_setup(result, real);
end;

function ap_iEditorEx(real: TEditorEx; owner: Tvalue): Tvalue;
begin
  result := EditorEx_alloc(cEditorEx, real);
  ap_owner(result, owner);
end;

function ap_iEditorEx_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iEditorEx(TEditorEx(AControl), owner)
end;

function EditorEx_new(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TEditorEx;
begin
  real := TEditorEx.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  EditorEx_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function EditorEx_find(This: Tvalue): Tvalue; cdecl;
var
  real: TEditorEx;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.Find);
end;

function EditorEx_find_next(This: Tvalue): Tvalue; cdecl;
var
  real: TEditorEx;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.FindNext);
end;

function EditorEx_find_prev(This: Tvalue): Tvalue; cdecl;
var
  real: TEditorEx;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.FindPrev);
end;

function EditorEx_replace(This, ReplaceStr, ToCRLF: Tvalue): Tvalue; cdecl;
var
  real: TEditorEx;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.Replace(dl_String(ReplaceStr), dl_Boolean(ToCRLF)));
end;

function EditorEx_replace_all(This, ReplaceStr, ToCRLF: Tvalue): Tvalue; cdecl;
var
  real: TEditorEx;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.ReplaceAll(dl_String(ReplaceStr), dl_Boolean(ToCRLF)));
end;

function EditorEx_line_string(This, row: Tvalue): Tvalue; cdecl;
var
  real: TEditorEx;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.LineString(dl_Integer(row)));
end;

procedure Init_EditorEx_module;
begin
  cEditorEx := rb_define_class_under(ap_mPhi, 'EditorEx', ap_cEditor);
  DefineProp(cEditorEx, TEditorEx);

  DefineConstSetType(cEditorEx, TypeInfo(TExSearchOption));

  rb_define_method(cEditorEx, 'event_handle', @EditorEx_event_handle, 1);
  DefineSingletonMethod(cEditorEx, 'new', EditorEx_new);

  rb_define_method(cEditorEx, 'find'        , @EditorEx_find, 0);
  rb_define_method(cEditorEx, 'find_next'   , @EditorEx_find_next, 0);
  rb_define_method(cEditorEx, 'find_prev'   , @EditorEx_find_prev, 0);
  rb_define_method(cEditorEx, 'replace'     , @EditorEx_replace, 2);
  rb_define_method(cEditorEx, 'replace_all' , @EditorEx_replace_all, 2);
  rb_define_method(cEditorEx, 'line_string' , @EditorEx_line_string, 1);

  cEditorExMarks := rb_define_class_under(cEditorEx, 'Marks', ap_cNotifyPersistent);
  DefineProp(cEditorExMarks, TEditorExMarks);
end;

end.
