unit Rubies;

interface

uses
{$IFDEF LINUX}
  Libc,
{$ENDIF}
{$IFDEF MSWINDOWS}
  Windows,
{$ENDIF}
  SysUtils, st;

resourcestring
  sWrong_num_of_args = 'wrong # of arguments';
  sWrong_arg_type = 'wrong argument type';
  sToo_few_args = 'too few arguments';
  sToo_many_args = 'too many arguments';
  sOut_of_range = 'out of range';

{$IFDEF MSWINDOWS}
const
  NL = #13#10;

{$I ruby\type.pas}

{$I ruby\funcint.pas}
{$I ruby\wrapint.pas}
{$I ruby\macroint.pas}
{$ENDIF}

{$IFDEF LINUX}
const
  NL = #10;

{$I ruby/type.pas}

{$I ruby/funcint.pas}
{$I ruby/wrapint.pas}
{$I ruby/macroint.pas}
{$ENDIF}

var
{$IFDEF LINUX}
  RubyDLLHandle: Pointer;
{$ENDIF}
{$IFDEF MSWINDOWS}
  RubyDLLModule: HMODULE = 0;
{$ENDIF}
  rb_cObject: Tvalue;

implementation

uses uStrUtils;

{$IFDEF MSWINDOWS}
{$I ruby\funcimp.pas}
{$I ruby\wrapimp.pas}
{$I ruby\macroimp.pas}
{$ENDIF}

{$IFDEF LINUX}
{$I ruby/funcimp.pas}
{$I ruby/wrapimp.pas}
{$I ruby/macroimp.pas}
{$ENDIF}

initialization
finalization
{$IFDEF LINUX}
  if RubyDLLHandle <> nil then
    dlclose(RubyDLLHandle);
{$ENDIF}
{$IFDEF MSWINDOWS}
  if RubyDLLModule <> 0 then
    FreeLibrary(RubyDLLModule);
{$ENDIF}
end.
