#!ruby

# cf:
# Delphi4 vO~OoCu p.314
# 7.4.2. C[Wr[A

require 'phi'
require 'dialogs'
require 'jpeg'

form = Phi::Form.new
form.caption = 'Image Viewer'

i = Phi::Image.new form, :image
i.align = Phi::AL_CLIENT

Phi.new_menu form, :menu, [
  Phi.new_item('&File', '', :mi_file).add(
    Phi.new_item('&Open', 'Ctrl+O', :mi_open),
    Phi.new_item('E&xit', '', :mi_exit)
  ),
  Phi.new_item('&Options', '', :mi_opt).add(
    Phi.new_item('&Stretch', '', :mi_stretch),
    Phi.new_item('&Center', '', :mi_center)
  ),
  Phi.new_item('&Help', '', :mi_help)
]
form.menu_attr_flatten

form.mi_open.on_click = proc do
  dlg = Phi::OpenDialog.new
  dlg.filter = 'Bitmap(*.bmp)|*.bmp|Icon(*.ico)|*.ico|Metafile(*.wmf)|*.wmf|Jpeg(*.jpg)|*.jpg'
  if dlg.execute
    form.image.picture.load dlg.file_name
    form.caption = 'Image Viewer - ' + dlg.file_name
  end
end

form.mi_stretch.on_click = proc do
  form.mi_stretch.checked = form.image.stretch = ! form.image.stretch
end

form.mi_center.on_click = proc do
  form.mi_center.checked = form.image.center = ! form.image.center
end

form.show
Phi.mainloop
