#! ruby

require 'phi'
include Phi
require 'rdb'
include RDB

form = Form.new

table = Table.new
table.database_name = 'DBDEMOS'
table.table_name = 'biolife.db'
table.active = true

def table.before_insert
  Phi.abort
end

data_source = DataSource.new table

grid = DBCtrlGrid.new(form, :grid)
edit = DBEdit.new(grid, :edit)
edit.data_field= 'common_name'

grid.align = Phi::AL_CLIENT
grid.data_source = data_source
grid.font.style = [Phi::FS_BOLD]

edit.data_source = data_source
grid.row_count = 1

nav = DBNavigator.new(form, :nav)
nav.align = Phi::AL_TOP
nav.data_source = data_source

form.show

Phi.mainloop
