# ap-list:2700

require 'phi' ; include  Phi 
require "Win32API"

def find_window( class_name,caption )
  Win32API.new('user32', 'FindWindow', "PP", "N").Call(class_name, caption)
end

MY_CAPTION   = ARGV.shift || "Please run 'copy_data.rb'."
RECV_CAPTION = ARGV.shift || "test2"

@receiver_handle = 0

form = Form.new :form_test1 , MY_CAPTION
button = Button.new form, :button, "find #{RECV_CAPTION}"
memo   = Memo.new   form, :memo,   "click to send data to #{RECV_CAPTION}"

if /.*(\d)$/ =~ MY_CAPTION 
  form.left = SCREEN.width / 10 * (( $1.to_i - 1 ) * 4 + 1 ) 
end
button.align = AL_TOP
memo.align = Phi::AL_CLIENT

button.on_click = proc{
  @receiver_handle = find_window( nil , RECV_CAPTION )
  button.caption = "handle of #{RECV_CAPTION} = #{@receiver_handle}"
}

memo.on_click = proc do
  if @receiver_handle != 0
    form.copy_data(@receiver_handle, "send from #{MY_CAPTION}\n on #{Time.now.to_s}")
    memo.lines.text = "send data to #{@receiver_handle}"
  else
    memo.lines.text = "Please push button to get receiver's handle."
  end
end

form.on_copy_data = proc do |sender, handle, data|
  memo.lines.text = "received :\n sender's handle = #{handle};\n data = #{data}\n"
end

form.show
Phi.mainloop
