require 'phi'
require 'editor'

class RBEditor < Phi::Editor

  RESERVE_WORD = [
    'BEGIN', 'END',
    'module', 'class', 'def', 
    'alias', 'and', 
    'begin', 'break', 
    'case', 'defined', 'do',
    'else', 'elsif', 'end', 'ensure',
    'false', 'for', 
    'if', 'in', 
    'next', 'nil', 'not',
    'or', 
    'redo', 'rescue', 'retry', 'return',
    'self', 'super',
    'then', 'true',
    'undef', 'unless', 'until',
    'when', 'while',
    'yield'
  ]

  def initialize(form, com_name)
    super(form, com_name)
    set_rbeditor_config
  end
  
  def set_rbeditor_config
    self.cursor = Phi::CR_IBEAM
    #self.font.height = -12
    #self.tab_space_count = 2
    
    self.caret.auto_cursor = true
    self.caret.auto_indent = false
    self.caret.free_caret = false
    self.caret.next_line = false
    
    self.marks.eof_mark.visible = true
    self.marks.ret_mark.visible = true
    
    # leftbar
    self.leftbar.bk_color = Phi::CL_BTN_FACE
    self.leftbar.color = Phi::CL_WINDOW_TEXT
    self.leftbar.column = 4
    self.leftbar.edge = true
    self.leftbar.left_margin = 4
    self.leftbar.right_margin = 2
    self.leftbar.show_number = true
    self.leftbar.show_number_mode = Phi::Editor::NM_LINE
    self.leftbar.visible = true
    self.leftbar.zero_base = true
    self.leftbar.zero_lead = true
    
    self.margin.left = 4
    
    # scroll bar
    self.caret.lock_scroll = false
    self.scroll_bars = Phi::SS_BOTH
    
    # word wrap
    self.wrap_option.wrap_byte = 60
    self.word_wrap = true
    self.wrap_option.follow_punctuation = true
    self.wrap_option.follow_str = 'ABCDEHIJKRSTUX[jnpvx!),.:;?]}'
    self.wrap_option.leading = true
    self.wrap_option.lead_str = 'imouw([{'
    self.wrap_option.punctuation_str = 'ABCD,.'
    self.wrap_option.word_break = true
    #self.wrap_option.follow_ret_mark = false

    # color
    self.view.colors.reserve.color = Phi::CL_PURPLE
    RESERVE_WORD.each do |word|
      self.reserve_word_list.add(word)
    end
    self.view.colors.comment.color = Phi::CL_RED
    self.view.commenter = '#'

    # bracket
    
    # RD͍s̐擪=beginłƂ납n܂A
    # s̐擪=endłƂŏIB
    # Ӗł̎͂(
    # ruby-mode.el݂AǂƂ悤
    item1 = self.view.brackets.add
    item1.item_color.color = self.view.colors.comment.color
    item1.left_bracket = '=begin'
    item1.right_bracket = '=end'

    # Quotationł͓ɓ̕włȂ
    str_color = 0x005555d0
    item2 = self.view.brackets.add
    item2.item_color.color = str_color
    item2.left_bracket = "'"
    item2.right_bracket = "'"
    item3 = self.view.brackets.add
    item3.item_color.color = str_color
    item3.left_bracket = '"'
    item3.right_bracket = '"'

    # K\
    item4 = self.view.brackets.add
    item4.item_color.color = Phi::CL_GREEN
    item4.left_bracket = '/'
    item4.right_bracket = '/'

    # c͐擪啶̏ꍇƂ
    # ̓p[T[pĂȂƂ邵Ȃ
  end
  
end
