#!/usr/local/bin/ruby
# by KUMAGAI Hidetake (ggb03124@nifty.ne.jp)
# modified by YOSHIDA Kazuhiro (moriq@moriq.com)

module RGUI
  module PanelLayout
    include RGUI

    def layout
      stop_align do
        fix_height = 0
        status_bar = controls.find{|i| i.is_a? Phi::StatusBar }
        fix_height+= status_bar.height if status_bar

        @children = [] unless @children
        @children.each do |c|
          if defined? self.adjusted_client_rect
            c.left   = self.adjusted_client_rect.left
            c.top    = self.adjusted_client_rect.top
            c.width  = self.adjusted_client_rect.right - c.left
            c.height = self.adjusted_client_rect.bottom - c.top - fix_height
          else
            c.left = 0
            c.top = 0
            c.width  = self.width
            c.height = self.height-fix_height
          end
          c.layout if defined? c.layout
        end
      end
    end
  end

  class Panel < Phi::Panel
    include PanelLayout
  end

  class TabSheet < Phi::TabSheet
    include PanelLayout
  end

  class GroupBox < Phi::GroupBox
    include PanelLayout
  end

  class Panel < Phi::Panel
    include PanelLayout
  end

  class TabSheet < Phi::TabSheet
    include PanelLayout
  end
end
