#!/usr/local/bin/ruby
# by YOSHIDA Kazuhiro (moriq@moriq.com)
# modified by KUMAGAI Hidetake (ggb03124@nifty.ne.jp)

module RGUI
  class Hbox < Widget
    include RGUI

    attr_accessor :space, :left, :top, :width, :height

    def space=(v)
      @space = v if v >= 0
    end

    def initialize(homo=false,space=0,fill=true,vdir=:n,hdir=:w)
      super
      @homo = homo
      @space = space
      @fill = fill
      @vdir = vdir
      @hdir = hdir
    end

    def layout
      return if @children.empty?
      homonize if @homo
      w = max 0, @width - @space
      len = 0 ; @children.each do |c| len+= c.base_width end
      len = max 1, len
      if @fill
        @children.each do |c|
          c.width  = max 0, c.base_width*w/len - @space
          c.height = @height
        end
        top = @top
        space = @space
      else
        sum_width = 0
        max_height = 0
        @children.each do |c|
          sum_width += c.width
          max_height = [max_height , c.height].max
        end
        top = [(@height - max_height)/2 , 0].max + @top
        space = (@width - sum_width)/(@children.size + 1)
      end
      left = (w % @children.size) / 2 + space
      left = @width - left if @hdir == :e
      @children.each do |c|
        case @hdir
        when :w ; c.left = @left+left         ; left+= space + c.width
        when :e ; c.left = @left+left-c.width ; left-= space + c.width
        end
        case @vdir
        when :n ; c.top = top
        when :s ; c.top = top+@height-c.height
        end
        c.layout if defined? c.layout
      end
    end

  end
end
