require 'phi'

include Phi

class ValueEditDialog
  attr_accessor :clicked
  attr_reader :edit_controls

  def initialize(form_title = 'Dialog')
    @parent_form = Form.new :value_edit_dialog
    @parent_form.caption = form_title
    @clicked = nil
    @ui_ary = Array.new
    @edit_controls = Hash.new

    @btn_close = Button.new @parent_form, :cls_set, 'I'
    btn_close_on_click = proc do
      if @clicked.instance_of?(Proc)
        @clicked.call
      end
      @parent_form.close
    end
    @btn_close.on_click = btn_close_on_click
  end

  def add_ui(label_name, value_id, ui_type, list_ary = nil)
    label = Label.new @parent_form
    label.caption = (label_name)
    label.left = 5
    case ui_type
    when 'text'
      tedit = Edit.new @parent_form
      tedit.text = ''
    when 'list'
      tedit = ComboBox.new @parent_form
      tedit.style = 2
      list_ary.each {|item_text|
        tedit.items.add(item_text)
      }
      tedit.items.add("ڂ̒ǉ...")
      def tedit.on_select
        last_idx = self.items.count - 1
        if self.item_index == last_idx
          add_listitem_dialog = ValueEditDialog.new("ڂ̒ǉ...")
          add_listitem_dialog.add_ui('ږ', 'item_value', 'text')

          add_listitem_dialog_clicked = proc do
            added_text = add_listitem_dialog.edit_controls['item_value'].text
            if !added_text.nil? and added_text != ''
              items.insert(items.count - 1, added_text)
              self.item_index = items.count - 2
            end
          end

          add_listitem_dialog.clicked = add_listitem_dialog_clicked
          add_listitem_dialog.show_dialog(true)
        end
      end

      if list_ary.nil?
        tedit.item_index = -1
      elsif list_ary.length == 0
        tedit.item_index = -1
      else
        tedit.item_index = 0
      end
    end
    @ui_ary.push [label, tedit]
    @edit_controls[value_id] = tedit
  end

  def show_dialog(modal = false)
    tmp_length = 0
    tmp_edit_length = 0
    tmp_height = 5

    @ui_ary.each {|ui_pair|
      label = ui_pair[0]
      tedit = ui_pair[1]

      tedit.top = tmp_height
      label.top = tmp_height
      tmp_length = (label.width > tmp_length ? label.width : tmp_length)
      tmp_edit_length = (tedit.width > tmp_edit_length ? tedit.width : tmp_edit_length)
      tmp_height = tedit.top + tedit.height + 10
    }
    @ui_ary.each {|ui_pair|
      tedit = ui_pair[1]
      tedit.left = tmp_length + 10
    }

    @btn_close.left = tmp_length + tmp_edit_length - @btn_close.width
    @btn_close.top = tmp_height + 5

    @parent_form.width = tmp_length + tmp_edit_length + 20
    @parent_form.height = @btn_close.top + @btn_close.height + 30
    @parent_form.left = Phi::SCREEN.width / 2 - @parent_form.width / 2
    @parent_form.top = Phi::SCREEN.height / 2 - @parent_form.height / 2
    if !modal
      @parent_form.show
    else
      @parent_form.show_modal
    end
  end
end

dialog = ValueEditDialog.new('test')
dialog.add_ui('eLXg̒lP', 'text_value1', 'text')
dialog.add_ui('eLXg̒lQ', 'text_value2', 'text')
dialog.add_ui('XgɂȂl', 'listed_value', 'list', ['ڂP', 'ڂQ'])
dialog.show_dialog

Phi.mainloop
