AccentTable = {
	"!@"	=>	"&iexcl;",		# 1-09-03	逆感嘆符
	"\\?@"	=>	"&iquest;",		# 1-09-22	逆疑問符
	"A`"	=>	"&Agrave;",		# 1-09-23	グレーブアクセント付きA
	"A'"	=>	"&Aacute;",		# 1-09-24	アキュートアクセント付きA
	"A\\^"	=>	"&Acirc;",		# 1-09-25	サーカムフレックスアクセント付き
	"A~"	=>	"&Atilde;",		# 1-09-26	チルド付きA
	"A:"	=>	"&Auml;",		# 1-09-27	ダイエレシス付きA
	"A&"	=>	"&Aring;",		# 1-09-28	上リング付きA
	"AE&"	=>	"&AElig;",		# 1-09-29	リガチャAE
	"C,"	=>	"&AElig;",		# 1-09-30	セディラ付きC
	"E`"	=>	"&Egrave;",		# 1-09-31	グレーブアクセント付きE
	"E'"	=>	"&Eacute;",		# 1-09-32	アキュートアクセント付きE
	"E\\^"	=>	"&Ecirc;",		# 1-09-33	サーカムフレックスアクセント付きE
	"E:"	=>	"&Euml;",		# 1-09-34	ダイエレシス付きE
	"I`"	=>	"&Igrave;",		# 1-09-35	グレーブアクセント付きI
	"I'"	=>	"&Iacute;",		# 1-09-36	アキュートアクセント付きI
	"I\\^"	=>	"&Icirc;",		# 1-09-37	サーカムフレックスアクセント付きI
	"I:"	=>	"&Iuml;",		# 1-09-38	ダイエレシス付きI
	"N~"	=>	"&Ntilde;",		# 1-09-40	チルド付きN
	"O`"	=>	"&Ograve;",		# 1-09-41	グレーブアクセント付きO
	"O'"	=>	"&Oacute;",		# 1-09-42	アキュートアクセント付きO
	"O\\^"	=>	"&Ocirc;",		# 1-09-43	サーカムフレックスアクセント付きO
	"O~"	=>	"&Otilde;",		# 1-09-44	チルド付きO
	"O:"	=>	"&Ouml;",		# 1-09-45	ダイエレシス付きO
	"O/"	=>	"&Oslash;",		# 1-09-46	ストローク付きO
	"U`"	=>	"&Ugrave;",		# 1-09-47	グレーブアクセント付きU
	"U'"	=>	"&Uacute;",		# 1-09-48	アキュートアクセント付きU
	"U\\^"	=>	"&Ucirc;",		# 1-09-49	サーカムフレックスアクセント付きU
	"U:"	=>	"&Uuml;",		# 1-09-50	ダイエレシス付きU
	"Y'"	=>	"&Yacute;",		# 1-09-51	アキュートアクセント付きY
	"s&"	=>	"&szlig;",		# 1-09-53	ドイツ語エスツェット
	"a`"	=>	"&agrave;",		# 1-09-54	グレーブアクセント付きA小文字
	"a'"	=>	"&aacute;",		# 1-09-55	アキュートアクセント付きA小文字
	"a\\^"	=>	"&acirc;",		# 1-09-56	サーカムフレックスアクセント付きA小文字
	"a~"	=>	"&atilde;",		# 1-09-57	チルド付きA小文字
	"a:"	=>	"&auml;",		# 1-09-58	ダイエレシス付きA小文字
	"a&"	=>	"&aring;",		# 1-09-59	上リング付きA小文字
	"ae&"	=>	"&aelig;",		# 1-09-60	リガチャAE小文字
	"c,"	=>	"&ccedil;",		# 1-09-61	セディラ付きC小文字
	"e`"	=>	"&egrave;",		# 1-09-62	グレーブアクセント付きE小文字
	"e'"	=>	"&eacute;",		# 1-09-63	アキュートアクセント付きE小文字
	"e\\^"	=>	"&ecirc;",		# 1-09-64	サーカムフレックスアクセント付きE小文字
	"e:"	=>	"&euml;",		# 1-09-65	ダイエレシス付きE小文字
	"i`"	=>	"&igrave;",		# 1-09-66	グレーブアクセント付きI小文字
	"i'"	=>	"&iacute;",		# 1-09-67	アキュートアクセント付きI小文字
	"i\\^"	=>	"&icirc;",		# 1-09-68	サーカムフレックスアクセント付きI小文字
	"i:"	=>	"&iuml;",		# 1-09-69	ダイエレシス付きI小文字
	"n~"	=>	"&ntilde;",		# 1-09-71	チルド付きN小文字
	"o`"	=>	"&ograve;",		# 1-09-72	グレーブアクセント付きO小文字
	"o'"	=>	"&oacute;",		# 1-09-73	アキュートアクセント付きO小文字
	"o\\^"	=>	"&ocirc;",		# 1-09-74	サーカムフレックスアクセント付きO小文字
	"o~"	=>	"&otilde;",		# 1-09-75	チルド付きO小文字
	"o:"	=>	"&ouml;",		# 1-09-76	ダイエレシス付きO小文字
	"o/"	=>	"&oslash;",		# 1-09-77	ストローク付きO小文字
	"u`"	=>	"&ugrave;",		# 1-09-78	グレーブアクセント付きU小文字
	"u'"	=>	"&uacute;",		# 1-09-79	アキュートアクセント付きU小文字
	"u\\^"	=>	"&ucirc;",		# 1-09-80	サーカムフレックスアクセント付きU小文字
	"u:"	=>	"&uuml;",		# 1-09-81	ダイエレシス付きU小文字
	"y'"	=>	"&yacute;",		# 1-09-82	アキュートアクセント付きY小文字
	"y:"	=>	"&yuml;",		# 1-09-84	ダイエレシス付きY小文字
	"OE&"	=>	"&OElig;",		# 1-11-11	リガチャOE大文字
	"oe&"	=>	"&oelig;"		# 1-11-10	リガチャOE小文字
=begin
	U_	1-09-87	マクロン付きU
	u_	1-09-92	マクロン付きU小文字
	A_	1-09-85	マクロン付きA
	a_	1-09-90	マクロン付きA小文字
	E_	1-09-88	マクロン付きE
	e_	1-09-93	マクロン付きE小文字
	I_	1-09-86	マクロン付きI
	i_	1-09-91	マクロン付きI小文字
	O_	1-09-89	マクロン付きO
	o_	1-09-94	マクロン付きO小文字
=end
}

Accents = Regexp.new('(' + AccentTable.keys.join('|') + ')')

AccentImgTable = {
	"!@"	=>	"1-09-03",		 # &iexcl;	逆感嘆符
	"\\?@"	=>	"1-09-22",		 # &iquest;	逆疑問符
	"A`"	=>	"1-09-23",		 # &Agrave;	グレーブアクセント付きA
	"A'"	=>	"1-09-24",		 # &Aacute;	アキュートアクセント付きA
	"A\\^"	=>	"1-09-25",		 # &Acirc;	サーカムフレックスアクセント付き
	"A~"	=>	"1-09-26",		 # &Atilde;	チルド付きA
	"A:"	=>	"1-09-27",		 # &Auml;	ダイエレシス付きA
	"A&"	=>	"1-09-28",		 # &Aring;	上リング付きA
	"AE&"	=>	"1-09-29",		 # &AElig;	リガチャAE
	"C,"	=>	"1-09-30",		 # &AElig;	セディラ付きC
	"E`"	=>	"1-09-31",		 # &Egrave;	グレーブアクセント付きE
	"E'"	=>	"1-09-32",		 # &Eacute;	アキュートアクセント付きE
	"E\\^"	=>	"1-09-33",		 # &Ecirc;	サーカムフレックスアクセント付きE
	"E:"	=>	"1-09-34",		 # &Euml;	ダイエレシス付きE
	"I`"	=>	"1-09-35",		 # &Igrave;	グレーブアクセント付きI
	"I'"	=>	"1-09-36",		 # &Iacute;	アキュートアクセント付きI
	"I\\^"	=>	"1-09-37",		 # &Icirc;	サーカムフレックスアクセント付きI
	"I:"	=>	"1-09-38",		 # &Iuml;	ダイエレシス付きI
	"N~"	=>	"1-09-40",		 # &Ntilde;	チルド付きN
	"O`"	=>	"1-09-41",		 # &Ograve;	グレーブアクセント付きO
	"O'"	=>	"1-09-42",		 # &Oacute;	アキュートアクセント付きO
	"O\\^"	=>	"1-09-43",		 # &Ocirc;	サーカムフレックスアクセント付きO
	"O~"	=>	"1-09-44",		 # &Otilde;	チルド付きO
	"O:"	=>	"1-09-45",		 # &Ouml;	ダイエレシス付きO
	"O/"	=>	"1-09-46",		 # &Oslash;	ストローク付きO
	"U`"	=>	"1-09-47",		 # &Ugrave;	グレーブアクセント付きU
	"U'"	=>	"1-09-48",		 # &Uacute;	アキュートアクセント付きU
	"U\\^"	=>	"1-09-49",		 # &Ucirc;	サーカムフレックスアクセント付きU
	"U:"	=>	"1-09-50",		 # &Uuml;	ダイエレシス付きU
	"Y'"	=>	"1-09-51",		 # &Yacute;	アキュートアクセント付きY
	"s&"	=>	"1-09-53",		 # &szlig;	ドイツ語エスツェット
	"a`"	=>	"1-09-54",		 # &agrave;	グレーブアクセント付きA小文字
	"a'"	=>	"1-09-55",		 # &aacute;	アキュートアクセント付きA小文字
	"a\\^"	=>	"1-09-56",		 # &acirc;	サーカムフレックスアクセント付きA小文字
	"a~"	=>	"1-09-57",		 # &atilde;	チルド付きA小文字
	"a:"	=>	"1-09-58",		 # &auml;	ダイエレシス付きA小文字
	"a&"	=>	"1-09-59",		 # &aring;	上リング付きA小文字
	"ae&"	=>	"1-09-60",		 # &aelig;	リガチャAE小文字
	"c,"	=>	"1-09-61",		 # &ccedil;	セディラ付きC小文字
	"e`"	=>	"1-09-62",		 # &egrave;	グレーブアクセント付きE小文字
	"e'"	=>	"1-09-63",		 # &eacute;	アキュートアクセント付きE小文字
	"e\\^"	=>	"1-09-64",		 # &ecirc;	サーカムフレックスアクセント付きE小文字
	"e:"	=>	"1-09-65",		 # &euml;	ダイエレシス付きE小文字
	"i`"	=>	"1-09-66",		 # &igrave;	グレーブアクセント付きI小文字
	"i'"	=>	"1-09-67",		 # &iacute;	アキュートアクセント付きI小文字
	"i\\^"	=>	"1-09-68",		 # &icirc;	サーカムフレックスアクセント付きI小文字
	"i:"	=>	"1-09-69",		 # &iuml;	ダイエレシス付きI小文字
	"n~"	=>	"1-09-71",		 # &ntilde;	チルド付きN小文字
	"o`"	=>	"1-09-72",		 # &ograve;	グレーブアクセント付きO小文字
	"o'"	=>	"1-09-73",		 # &oacute;	アキュートアクセント付きO小文字
	"o\\^"	=>	"1-09-74",		 # &ocirc;	サーカムフレックスアクセント付きO小文字
	"o~"	=>	"1-09-75",		 # &otilde;	チルド付きO小文字
	"o:"	=>	"1-09-76",		 # &ouml;	ダイエレシス付きO小文字
	"o/"	=>	"1-09-77",		 # &oslash;	ストローク付きO小文字
	"u`"	=>	"1-09-78",		 # &ugrave;	グレーブアクセント付きU小文字
	"u'"	=>	"1-09-79",		 # &uacute;	アキュートアクセント付きU小文字
	"u\\^"	=>	"1-09-80",		 # &ucirc;	サーカムフレックスアクセント付きU小文字
	"u:"	=>	"1-09-81",		 # &uuml;	ダイエレシス付きU小文字
	"y'"	=>	"1-09-82",		 # &yacute;	アキュートアクセント付きY小文字
	"y:"	=>	"1-09-84",		 # &yuml;	ダイエレシス付きY小文字
	"OE&"	=>	"1-11-11",		 # &OElig;	リガチャOE大文字
	"oe&"	=>	"1-11-10",		 # &oelig;	リガチャOE小文字
	"U_"	=>	"1-09-87",		 # マクロン付きU
	"u_"	=>	"1-09-92",		 # マクロン付きU小文字
	"A_"	=>	"1-09-85",		 # マクロン付きA
	"a_"	=>	"1-09-90",		 # マクロン付きA小文字
	"E_"	=>	"1-09-88",		 # マクロン付きE
	"e_"	=>	"1-09-93",		 # マクロン付きE小文字
	"I_"	=>	"1-09-86",		 # マクロン付きI
	"i_"	=>	"1-09-91",		 # マクロン付きI小文字
	"O_"	=>	"1-09-89",		 # マクロン付きO
	"o_"	=>	"1-09-94"		 # マクロン付きO小文字
}


Ku2Unc = {
	"1-1-1" => "\xe3\x80\x80",
	"1-1-2" => "\xe3\x80\x81",
	"1-1-3" => "\xe3\x80\x82",
	"1-1-4" => "\xef\xbc\x8c",
	"1-1-5" => "\xef\xbc\x8e",
	"1-1-6" => "\xe3\x83\xbb",
	"1-1-7" => "\xef\xbc\x9a",
	"1-1-8" => "\xef\xbc\x9b",
	"1-1-9" => "\xef\xbc\x9f",
	"1-1-10" => "\xef\xbc\x81",
	"1-1-11" => "\xe3\x82\x9b",
	"1-1-12" => "\xe3\x82\x9c",
	"1-1-13" => "\xc2\xb4",
	"1-1-14" => "\xef\xbd\x80",
	"1-1-15" => "\xc2\xa8",
	"1-1-16" => "\xef\xbc\xbe",
	"1-1-17" => "\xe2\x80\xbe",
	"1-1-18" => "\xef\xbc\xbf",
	"1-1-19" => "\xe3\x83\xbd",
	"1-1-20" => "\xe3\x83\xbe",
	"1-1-21" => "\xe3\x82\x9d",
	"1-1-22" => "\xe3\x82\x9e",
	"1-1-23" => "\xe3\x80\x83",
	"1-1-24" => "\xe4\xbb\x9d",
	"1-1-25" => "\xe3\x80\x85",
	"1-1-26" => "\xe3\x80\x86",
	"1-1-27" => "\xe3\x80\x87",
	"1-1-28" => "\xe3\x83\xbc",
	"1-1-29" => "\xe2\x80\x94",
	"1-1-30" => "\xe2\x80\x90",
	"1-1-31" => "\xef\xbc\x8f",
	"1-1-32" => "\xef\xbc\xbc",
	"1-1-33" => "\xe3\x80\x9c",
	"1-1-34" => "\xe2\x80\x96",
	"1-1-35" => "\xef\xbd\x9c",
	"1-1-36" => "\xe2\x80\xa6",
	"1-1-37" => "\xe2\x80\xa5",
	"1-1-38" => "\xe2\x80\x98",
	"1-1-39" => "\xe2\x80\x99",
	"1-1-40" => "\xe2\x80\x9c",
	"1-1-41" => "\xe2\x80\x9d",
	"1-1-42" => "\xef\xbc\x88",
	"1-1-43" => "\xef\xbc\x89",
	"1-1-44" => "\xe3\x80\x94",
	"1-1-45" => "\xe3\x80\x95",
	"1-1-46" => "\xef\xbc\xbb",
	"1-1-47" => "\xef\xbc\xbd",
	"1-1-48" => "\xef\xbd\x9b",
	"1-1-49" => "\xef\xbd\x9d",
	"1-1-50" => "\xe3\x80\x88",
	"1-1-51" => "\xe3\x80\x89",
	"1-1-52" => "\xe3\x80\x8a",
	"1-1-53" => "\xe3\x80\x8b",
	"1-1-54" => "\xe3\x80\x8c",
	"1-1-55" => "\xe3\x80\x8d",
	"1-1-56" => "\xe3\x80\x8e",
	"1-1-57" => "\xe3\x80\x8f",
	"1-1-58" => "\xe3\x80\x90",
	"1-1-59" => "\xe3\x80\x91",
	"1-1-60" => "\xef\xbc\x8b",
	"1-1-61" => "\xe2\x88\x92",
	"1-1-62" => "\xc2\xb1",
	"1-1-63" => "\xc3\x97",
	"1-1-64" => "\xc3\xb7",
	"1-1-65" => "\xef\xbc\x9d",
	"1-1-66" => "\xe2\x89\xa0",
	"1-1-67" => "\xef\xbc\x9c",
	"1-1-68" => "\xef\xbc\x9e",
	"1-1-69" => "\xe2\x89\xa6",
	"1-1-70" => "\xe2\x89\xa7",
	"1-1-71" => "\xe2\x88\x9e",
	"1-1-72" => "\xe2\x88\xb4",
	"1-1-73" => "\xe2\x99\x82",
	"1-1-74" => "\xe2\x99\x80",
	"1-1-75" => "\xc2\xb0",
	"1-1-76" => "\xe2\x80\xb2",
	"1-1-77" => "\xe2\x80\xb3",
	"1-1-78" => "\xe2\x84\x83",
	"1-1-79" => "\xc2\xa5",
	"1-1-80" => "\xef\xbc\x84",
	"1-1-81" => "\xc2\xa2",
	"1-1-82" => "\xc2\xa3",
	"1-1-83" => "\xef\xbc\x85",
	"1-1-84" => "\xef\xbc\x83",
	"1-1-85" => "\xef\xbc\x86",
	"1-1-86" => "\xef\xbc\x8a",
	"1-1-87" => "\xef\xbc\xa0",
	"1-1-88" => "\xc2\xa7",
	"1-1-89" => "\xe2\x98\x86",
	"1-1-90" => "\xe2\x98\x85",
	"1-1-91" => "\xe2\x97\x8b",
	"1-1-92" => "\xe2\x97\x8f",
	"1-1-93" => "\xe2\x97\x8e",
	"1-1-94" => "\xe2\x97\x87",
	"1-2-1" => "\xe2\x97\x86",
	"1-2-2" => "\xe2\x96\xa1",
	"1-2-3" => "\xe2\x96\xa0",
	"1-2-4" => "\xe2\x96\xb3",
	"1-2-5" => "\xe2\x96\xb2",
	"1-2-6" => "\xe2\x96\xbd",
	"1-2-7" => "\xe2\x96\xbc",
	"1-2-8" => "\xe2\x80\xbb",
	"1-2-9" => "\xe3\x80\x92",
	"1-2-10" => "\xe2\x86\x92",
	"1-2-11" => "\xe2\x86\x90",
	"1-2-12" => "\xe2\x86\x91",
	"1-2-13" => "\xe2\x86\x93",
	"1-2-14" => "\xe3\x80\x93",
	"1-2-15" => "\xef\xbc\x87",
	"1-2-16" => "\xef\xbc\x82",
	"1-2-17" => "\xef\xbc\x8d",
	"1-2-18" => "\xef\xbc\x9e",
	"1-2-19" => "\xe3\x80\xb3",
	"1-2-20" => "\xe3\x80\xb4",
	"1-2-21" => "\xe3\x80\xb5",
	"1-2-22" => "\xe3\x80\xbb",
	"1-2-23" => "\xe3\x80\xbc",	
	"1-2-24" => "\xe3\x83\xbf",	
	"1-2-25" => "\xe3\x82\x9f",	
	"1-2-26" => "\xe2\x88\x88",
	"1-2-27" => "\xe2\x88\x8b",
	"1-2-28" => "\xe2\x8a\x86",
	"1-2-29" => "\xe2\x8a\x87",
	"1-2-30" => "\xe2\x8a\x82",
	"1-2-31" => "\xe2\x8a\x83",
	"1-2-32" => "\xe2\x88\xaa",
	"1-2-33" => "\xe2\x88\xa9",
	"1-2-34" => "\xe2\x8a\x84",
	"1-2-35" => "\xe2\x8a\x85",
	"1-2-36" => "\xe2\x8a\x8a",
	"1-2-37" => "\xe2\x8a\x8b",
	"1-2-38" => "\xe2\x88\x89",
	"1-2-39" => "\xe2\x88\x85",
	"1-2-40" => "\xe2\x8c\x85",
	"1-2-41" => "\xe2\x8c\x86",
	"1-2-42" => "\xe2\x88\xa7",
	"1-2-43" => "\xe2\x88\xa8",
	"1-2-44" => "\xc2\xac",
	"1-2-45" => "\xe2\x87\x92",
	"1-2-46" => "\xe2\x87\x94",
	"1-2-47" => "\xe2\x88\x80",
	"1-2-48" => "\xe2\x88\x83",
	"1-2-49" => "\xe2\x8a\x95",
	"1-2-50" => "\xe2\x8a\x96",
	"1-2-51" => "\xe2\x8a\x97",
	"1-2-52" => "\xe2\x88\xa5",
	"1-2-53" => "\xe2\x88\xa6",
	"1-2-54" => "\xef\xbd\x9f",	
	"1-2-55" => "\xef\xbd\xa0",	
	"1-2-56" => "\xe3\x80\x98",
	"1-2-57" => "\xe3\x80\x99",
	"1-2-58" => "\xe3\x80\x96",
	"1-2-59" => "\xe3\x80\x97",
	"1-2-60" => "\xe2\x88\xa0",
	"1-2-61" => "\xe2\x8a\xa5",
	"1-2-62" => "\xe2\x8c\x92",
	"1-2-63" => "\xe2\x88\x82",
	"1-2-64" => "\xe2\x88\x87",
	"1-2-65" => "\xe2\x89\xa1",
	"1-2-66" => "\xe2\x89\x92",
	"1-2-67" => "\xe2\x89\xaa",
	"1-2-68" => "\xe2\x89\xab",
	"1-2-69" => "\xe2\x88\x9a",
	"1-2-70" => "\xe2\x88\xbd",
	"1-2-71" => "\xe2\x88\x9d",
	"1-2-72" => "\xe2\x88\xb5",
	"1-2-73" => "\xe2\x88\xab",
	"1-2-74" => "\xe2\x88\xac",
	"1-2-75" => "\xe2\x89\xa2",
	"1-2-76" => "\xe2\x89\x83",
	"1-2-77" => "\xe2\x89\x85",
	"1-2-78" => "\xe2\x89\x88",
	"1-2-79" => "\xe2\x89\xb6",
	"1-2-80" => "\xe2\x89\xb7",
	"1-2-81" => "\xe2\x86\x94",
	"1-2-82" => "\xe2\x84\xab",
	"1-2-83" => "\xe2\x80\xb0",
	"1-2-84" => "\xe2\x99\xaf",
	"1-2-85" => "\xe2\x99\xad",
	"1-2-86" => "\xe2\x99\xaa",
	"1-2-87" => "\xe2\x80\xa0",
	"1-2-88" => "\xe2\x80\xa1",
	"1-2-89" => "\xc2\xb6",
	"1-2-90" => "\xe2\x99\xae",
	"1-2-91" => "\xe2\x99\xab",
	"1-2-92" => "\xe2\x99\xac",
	"1-2-93" => "\xe2\x99\xa9",
	"1-2-94" => "\xe2\x97\xaf",
	"1-3-1" => "\xe2\x96\xb7",
	"1-3-2" => "\xe2\x96\xb6",
	"1-3-3" => "\xe2\x97\x81",
	"1-3-4" => "\xe2\x97\x80",
	"1-3-5" => "\xe2\x86\x97",
	"1-3-6" => "\xe2\x86\x98",
	"1-3-7" => "\xe2\x86\x96",
	"1-3-8" => "\xe2\x86\x99",
	"1-3-9" => "\xe2\x87\x84",
	"1-3-10" => "\xe2\x87\xa8",
	"1-3-11" => "\xe2\x87\xa6",
	"1-3-12" => "\xe2\x87\xa7",
	"1-3-13" => "\xe2\x87\xa9",
	"1-3-14" => "\xe2\xa4\xb4",	
	"1-3-15" => "\xe2\xa4\xb5",	
	"1-3-16" => "\xef\xbc\x90",
	"1-3-17" => "\xef\xbc\x91",
	"1-3-18" => "\xef\xbc\x92",
	"1-3-19" => "\xef\xbc\x93",
	"1-3-20" => "\xef\xbc\x94",
	"1-3-21" => "\xef\xbc\x95",
	"1-3-22" => "\xef\xbc\x96",
	"1-3-23" => "\xef\xbc\x97",
	"1-3-24" => "\xef\xbc\x98",
	"1-3-25" => "\xef\xbc\x99",
	"1-3-26" => "\xe2\xa6\xbf",	
	"1-3-27" => "\xe2\x97\x89",
	"1-3-28" => "\xe3\x80\xbd",	
	"1-3-29" => "\xef\xb9\x86",	
	"1-3-30" => "\xef\xb9\x85",	
	"1-3-31" => "\xe2\x97\xa6",
	"1-3-32" => "\xe2\x80\xa2",
	"1-3-33" => "\xef\xbc\xa1",
	"1-3-34" => "\xef\xbc\xa2",
	"1-3-35" => "\xef\xbc\xa3",
	"1-3-36" => "\xef\xbc\xa4",
	"1-3-37" => "\xef\xbc\xa5",
	"1-3-38" => "\xef\xbc\xa6",
	"1-3-39" => "\xef\xbc\xa7",
	"1-3-40" => "\xef\xbc\xa8",
	"1-3-41" => "\xef\xbc\xa9",
	"1-3-42" => "\xef\xbc\xaa",
	"1-3-43" => "\xef\xbc\xab",
	"1-3-44" => "\xef\xbc\xac",
	"1-3-45" => "\xef\xbc\xad",
	"1-3-46" => "\xef\xbc\xae",
	"1-3-47" => "\xef\xbc\xaf",
	"1-3-48" => "\xef\xbc\xb0",
	"1-3-49" => "\xef\xbc\xb1",
	"1-3-50" => "\xef\xbc\xb2",
	"1-3-51" => "\xef\xbc\xb3",
	"1-3-52" => "\xef\xbc\xb4",
	"1-3-53" => "\xef\xbc\xb5",
	"1-3-54" => "\xef\xbc\xb6",
	"1-3-55" => "\xef\xbc\xb7",
	"1-3-56" => "\xef\xbc\xb8",
	"1-3-57" => "\xef\xbc\xb9",
	"1-3-58" => "\xef\xbc\xba",
	"1-3-59" => "\xe2\x88\x93",
	"1-3-60" => "\xe2\x84\xb5",
	"1-3-61" => "\xe2\x84\x8f",
	"1-3-62" => "\xe3\x8f\x8b",
	"1-3-63" => "\xe2\x84\x93",
	"1-3-64" => "\xe2\x84\xa7",
	"1-3-65" => "\xef\xbd\x81",
	"1-3-66" => "\xef\xbd\x82",
	"1-3-67" => "\xef\xbd\x83",
	"1-3-68" => "\xef\xbd\x84",
	"1-3-69" => "\xef\xbd\x85",
	"1-3-70" => "\xef\xbd\x86",
	"1-3-71" => "\xef\xbd\x87",
	"1-3-72" => "\xef\xbd\x88",
	"1-3-73" => "\xef\xbd\x89",
	"1-3-74" => "\xef\xbd\x8a",
	"1-3-75" => "\xef\xbd\x8b",
	"1-3-76" => "\xef\xbd\x8c",
	"1-3-77" => "\xef\xbd\x8d",
	"1-3-78" => "\xef\xbd\x8e",
	"1-3-79" => "\xef\xbd\x8f",
	"1-3-80" => "\xef\xbd\x90",
	"1-3-81" => "\xef\xbd\x91",
	"1-3-82" => "\xef\xbd\x92",
	"1-3-83" => "\xef\xbd\x93",
	"1-3-84" => "\xef\xbd\x94",
	"1-3-85" => "\xef\xbd\x95",
	"1-3-86" => "\xef\xbd\x96",
	"1-3-87" => "\xef\xbd\x97",
	"1-3-88" => "\xef\xbd\x98",
	"1-3-89" => "\xef\xbd\x99",
	"1-3-90" => "\xef\xbd\x9a",
	"1-3-91" => "\xe3\x82\xa0",	
	"1-3-92" => "\xe2\x80\x93",
	"1-3-93" => "\xe2\xa7\xba",	
	"1-3-94" => "\xe2\xa7\xbb",	
	"1-4-1" => "\xe3\x81\x81",
	"1-4-2" => "\xe3\x81\x82",
	"1-4-3" => "\xe3\x81\x83",
	"1-4-4" => "\xe3\x81\x84",
	"1-4-5" => "\xe3\x81\x85",
	"1-4-6" => "\xe3\x81\x86",
	"1-4-7" => "\xe3\x81\x87",
	"1-4-8" => "\xe3\x81\x88",
	"1-4-9" => "\xe3\x81\x89",
	"1-4-10" => "\xe3\x81\x8a",
	"1-4-11" => "\xe3\x81\x8b",
	"1-4-12" => "\xe3\x81\x8c",
	"1-4-13" => "\xe3\x81\x8d",
	"1-4-14" => "\xe3\x81\x8e",
	"1-4-15" => "\xe3\x81\x8f",
	"1-4-16" => "\xe3\x81\x90",
	"1-4-17" => "\xe3\x81\x91",
	"1-4-18" => "\xe3\x81\x92",
	"1-4-19" => "\xe3\x81\x93",
	"1-4-20" => "\xe3\x81\x94",
	"1-4-21" => "\xe3\x81\x95",
	"1-4-22" => "\xe3\x81\x96",
	"1-4-23" => "\xe3\x81\x97",
	"1-4-24" => "\xe3\x81\x98",
	"1-4-25" => "\xe3\x81\x99",
	"1-4-26" => "\xe3\x81\x9a",
	"1-4-27" => "\xe3\x81\x9b",
	"1-4-28" => "\xe3\x81\x9c",
	"1-4-29" => "\xe3\x81\x9d",
	"1-4-30" => "\xe3\x81\x9e",
	"1-4-31" => "\xe3\x81\x9f",
	"1-4-32" => "\xe3\x81\xa0",
	"1-4-33" => "\xe3\x81\xa1",
	"1-4-34" => "\xe3\x81\xa2",
	"1-4-35" => "\xe3\x81\xa3",
	"1-4-36" => "\xe3\x81\xa4",
	"1-4-37" => "\xe3\x81\xa5",
	"1-4-38" => "\xe3\x81\xa6",
	"1-4-39" => "\xe3\x81\xa7",
	"1-4-40" => "\xe3\x81\xa8",
	"1-4-41" => "\xe3\x81\xa9",
	"1-4-42" => "\xe3\x81\xaa",
	"1-4-43" => "\xe3\x81\xab",
	"1-4-44" => "\xe3\x81\xac",
	"1-4-45" => "\xe3\x81\xad",
	"1-4-46" => "\xe3\x81\xae",
	"1-4-47" => "\xe3\x81\xaf",
	"1-4-48" => "\xe3\x81\xb0",
	"1-4-49" => "\xe3\x81\xb1",
	"1-4-50" => "\xe3\x81\xb2",
	"1-4-51" => "\xe3\x81\xb3",
	"1-4-52" => "\xe3\x81\xb4",
	"1-4-53" => "\xe3\x81\xb5",
	"1-4-54" => "\xe3\x81\xb6",
	"1-4-55" => "\xe3\x81\xb7",
	"1-4-56" => "\xe3\x81\xb8",
	"1-4-57" => "\xe3\x81\xb9",
	"1-4-58" => "\xe3\x81\xba",
	"1-4-59" => "\xe3\x81\xbb",
	"1-4-60" => "\xe3\x81\xbc",
	"1-4-61" => "\xe3\x81\xbd",
	"1-4-62" => "\xe3\x81\xbe",
	"1-4-63" => "\xe3\x81\xbf",
	"1-4-64" => "\xe3\x82\x80",
	"1-4-65" => "\xe3\x82\x81",
	"1-4-66" => "\xe3\x82\x82",
	"1-4-67" => "\xe3\x82\x83",
	"1-4-68" => "\xe3\x82\x84",
	"1-4-69" => "\xe3\x82\x85",
	"1-4-70" => "\xe3\x82\x86",
	"1-4-71" => "\xe3\x82\x87",
	"1-4-72" => "\xe3\x82\x88",
	"1-4-73" => "\xe3\x82\x89",
	"1-4-74" => "\xe3\x82\x8a",
	"1-4-75" => "\xe3\x82\x8b",
	"1-4-76" => "\xe3\x82\x8c",
	"1-4-77" => "\xe3\x82\x8d",
	"1-4-78" => "\xe3\x82\x8e",
	"1-4-79" => "\xe3\x82\x8f",
	"1-4-80" => "\xe3\x82\x90",
	"1-4-81" => "\xe3\x82\x91",
	"1-4-82" => "\xe3\x82\x92",
	"1-4-83" => "\xe3\x82\x93",
	"1-4-84" => "\xe3\x82\x94",
	"1-4-85" => "\xe3\x82\x95",	
	"1-4-86" => "\xe3\x82\x96",	
	"1-4-87" => "\xe3\x81\x8b\xe3\x82\x9a",	
	"1-4-88" => "\xe3\x81\x8d\xe3\x82\x9a",	
	"1-4-89" => "\xe3\x81\x8f\xe3\x82\x9a",	
	"1-4-90" => "\xe3\x81\x91\xe3\x82\x9a",	
	"1-4-91" => "\xe3\x81\x93\xe3\x82\x9a",	
	"1-4-92" => "\xef\xbf\xbf",
	"1-4-93" => "\xef\xbf\xbf",
	"1-4-94" => "\xef\xbf\xbf",
	"1-5-1" => "\xe3\x82\xa1",
	"1-5-2" => "\xe3\x82\xa2",
	"1-5-3" => "\xe3\x82\xa3",
	"1-5-4" => "\xe3\x82\xa4",
	"1-5-5" => "\xe3\x82\xa5",
	"1-5-6" => "\xe3\x82\xa6",
	"1-5-7" => "\xe3\x82\xa7",
	"1-5-8" => "\xe3\x82\xa8",
	"1-5-9" => "\xe3\x82\xa9",
	"1-5-10" => "\xe3\x82\xaa",
	"1-5-11" => "\xe3\x82\xab",
	"1-5-12" => "\xe3\x82\xac",
	"1-5-13" => "\xe3\x82\xad",
	"1-5-14" => "\xe3\x82\xae",
	"1-5-15" => "\xe3\x82\xaf",
	"1-5-16" => "\xe3\x82\xb0",
	"1-5-17" => "\xe3\x82\xb1",
	"1-5-18" => "\xe3\x82\xb2",
	"1-5-19" => "\xe3\x82\xb3",
	"1-5-20" => "\xe3\x82\xb4",
	"1-5-21" => "\xe3\x82\xb5",
	"1-5-22" => "\xe3\x82\xb6",
	"1-5-23" => "\xe3\x82\xb7",
	"1-5-24" => "\xe3\x82\xb8",
	"1-5-25" => "\xe3\x82\xb9",
	"1-5-26" => "\xe3\x82\xba",
	"1-5-27" => "\xe3\x82\xbb",
	"1-5-28" => "\xe3\x82\xbc",
	"1-5-29" => "\xe3\x82\xbd",
	"1-5-30" => "\xe3\x82\xbe",
	"1-5-31" => "\xe3\x82\xbf",
	"1-5-32" => "\xe3\x83\x80",
	"1-5-33" => "\xe3\x83\x81",
	"1-5-34" => "\xe3\x83\x82",
	"1-5-35" => "\xe3\x83\x83",
	"1-5-36" => "\xe3\x83\x84",
	"1-5-37" => "\xe3\x83\x85",
	"1-5-38" => "\xe3\x83\x86",
	"1-5-39" => "\xe3\x83\x87",
	"1-5-40" => "\xe3\x83\x88",
	"1-5-41" => "\xe3\x83\x89",
	"1-5-42" => "\xe3\x83\x8a",
	"1-5-43" => "\xe3\x83\x8b",
	"1-5-44" => "\xe3\x83\x8c",
	"1-5-45" => "\xe3\x83\x8d",
	"1-5-46" => "\xe3\x83\x8e",
	"1-5-47" => "\xe3\x83\x8f",
	"1-5-48" => "\xe3\x83\x90",
	"1-5-49" => "\xe3\x83\x91",
	"1-5-50" => "\xe3\x83\x92",
	"1-5-51" => "\xe3\x83\x93",
	"1-5-52" => "\xe3\x83\x94",
	"1-5-53" => "\xe3\x83\x95",
	"1-5-54" => "\xe3\x83\x96",
	"1-5-55" => "\xe3\x83\x97",
	"1-5-56" => "\xe3\x83\x98",
	"1-5-57" => "\xe3\x83\x99",
	"1-5-58" => "\xe3\x83\x9a",
	"1-5-59" => "\xe3\x83\x9b",
	"1-5-60" => "\xe3\x83\x9c",
	"1-5-61" => "\xe3\x83\x9d",
	"1-5-62" => "\xe3\x83\x9e",
	"1-5-63" => "\xe3\x83\x9f",
	"1-5-64" => "\xe3\x83\xa0",
	"1-5-65" => "\xe3\x83\xa1",
	"1-5-66" => "\xe3\x83\xa2",
	"1-5-67" => "\xe3\x83\xa3",
	"1-5-68" => "\xe3\x83\xa4",
	"1-5-69" => "\xe3\x83\xa5",
	"1-5-70" => "\xe3\x83\xa6",
	"1-5-71" => "\xe3\x83\xa7",
	"1-5-72" => "\xe3\x83\xa8",
	"1-5-73" => "\xe3\x83\xa9",
	"1-5-74" => "\xe3\x83\xaa",
	"1-5-75" => "\xe3\x83\xab",
	"1-5-76" => "\xe3\x83\xac",
	"1-5-77" => "\xe3\x83\xad",
	"1-5-78" => "\xe3\x83\xae",
	"1-5-79" => "\xe3\x83\xaf",
	"1-5-80" => "\xe3\x83\xb0",
	"1-5-81" => "\xe3\x83\xb1",
	"1-5-82" => "\xe3\x83\xb2",
	"1-5-83" => "\xe3\x83\xb3",
	"1-5-84" => "\xe3\x83\xb4",
	"1-5-85" => "\xe3\x83\xb5",
	"1-5-86" => "\xe3\x83\xb6",
	"1-5-87" => "\xe3\x82\xab\xe3\x82\x9a",	
	"1-5-88" => "\xe3\x82\xad\xe3\x82\x9a",	
	"1-5-89" => "\xe3\x82\xaf\xe3\x82\x9a",	
	"1-5-90" => "\xe3\x82\xb1\xe3\x82\x9a",	
	"1-5-91" => "\xe3\x82\xb3\xe3\x82\x9a",	
	"1-5-92" => "\xe3\x82\xbb\xe3\x82\x9a",	
	"1-5-93" => "\xe3\x83\x84\xe3\x82\x9a",	
	"1-5-94" => "\xe3\x83\x88\xe3\x82\x9a",	
	"1-6-1" => "\xce\x91",
	"1-6-2" => "\xce\x92",
	"1-6-3" => "\xce\x93",
	"1-6-4" => "\xce\x94",
	"1-6-5" => "\xce\x95",
	"1-6-6" => "\xce\x96",
	"1-6-7" => "\xce\x97",
	"1-6-8" => "\xce\x98",
	"1-6-9" => "\xce\x99",
	"1-6-10" => "\xce\x9a",
	"1-6-11" => "\xce\x9b",
	"1-6-12" => "\xce\x9c",
	"1-6-13" => "\xce\x9d",
	"1-6-14" => "\xce\x9e",
	"1-6-15" => "\xce\x9f",
	"1-6-16" => "\xce\xa0",
	"1-6-17" => "\xce\xa1",
	"1-6-18" => "\xce\xa3",
	"1-6-19" => "\xce\xa4",
	"1-6-20" => "\xce\xa5",
	"1-6-21" => "\xce\xa6",
	"1-6-22" => "\xce\xa7",
	"1-6-23" => "\xce\xa8",
	"1-6-24" => "\xce\xa9",
	"1-6-25" => "\xe2\x99\xa4",
	"1-6-26" => "\xe2\x99\xa0",
	"1-6-27" => "\xe2\x99\xa2",
	"1-6-28" => "\xe2\x99\xa6",
	"1-6-29" => "\xe2\x99\xa1",
	"1-6-30" => "\xe2\x99\xa5",
	"1-6-31" => "\xe2\x99\xa7",
	"1-6-32" => "\xe2\x99\xa3",
	"1-6-33" => "\xce\xb1",
	"1-6-34" => "\xce\xb2",
	"1-6-35" => "\xce\xb3",
	"1-6-36" => "\xce\xb4",
	"1-6-37" => "\xce\xb5",
	"1-6-38" => "\xce\xb6",
	"1-6-39" => "\xce\xb7",
	"1-6-40" => "\xce\xb8",
	"1-6-41" => "\xce\xb9",
	"1-6-42" => "\xce\xba",
	"1-6-43" => "\xce\xbb",
	"1-6-44" => "\xce\xbc",
	"1-6-45" => "\xce\xbd",
	"1-6-46" => "\xce\xbe",
	"1-6-47" => "\xce\xbf",
	"1-6-48" => "\xcf\x80",
	"1-6-49" => "\xcf\x81",
	"1-6-50" => "\xcf\x83",
	"1-6-51" => "\xcf\x84",
	"1-6-52" => "\xcf\x85",
	"1-6-53" => "\xcf\x86",
	"1-6-54" => "\xcf\x87",
	"1-6-55" => "\xcf\x88",
	"1-6-56" => "\xcf\x89",
	"1-6-57" => "\xcf\x82",
	"1-6-58" => "\xe2\x93\xb5",	
	"1-6-59" => "\xe2\x93\xb6",	
	"1-6-60" => "\xe2\x93\xb7",	
	"1-6-61" => "\xe2\x93\xb8",	
	"1-6-62" => "\xe2\x93\xb9",	
	"1-6-63" => "\xe2\x93\xba",	
	"1-6-64" => "\xe2\x93\xbb",	
	"1-6-65" => "\xe2\x93\xbc",	
	"1-6-66" => "\xe2\x93\xbd",	
	"1-6-67" => "\xe2\x93\xbe",	
	"1-6-68" => "\xe2\x98\x96",	
	"1-6-69" => "\xe2\x98\x97",	
	"1-6-70" => "\xe3\x80\xa0",
	"1-6-71" => "\xe2\x98\x8e",
	"1-6-72" => "\xe2\x98\x80",
	"1-6-73" => "\xe2\x98\x81",
	"1-6-74" => "\xe2\x98\x82",
	"1-6-75" => "\xe2\x98\x83",
	"1-6-76" => "\xe2\x99\xa8",
	"1-6-77" => "\xe2\x96\xb1",
	"1-6-78" => "\xe3\x87\xb0",	
	"1-6-79" => "\xe3\x87\xb1",	
	"1-6-80" => "\xe3\x87\xb2",	
	"1-6-81" => "\xe3\x87\xb3",	
	"1-6-82" => "\xe3\x87\xb4",	
	"1-6-83" => "\xe3\x87\xb5",	
	"1-6-84" => "\xe3\x87\xb6",	
	"1-6-85" => "\xe3\x87\xb7",	
	"1-6-86" => "\xe3\x87\xb8",	
	"1-6-87" => "\xe3\x87\xb9",	
	"1-6-88" => "\xe3\x87\xb7\xe3\x82\x9a",	
	"1-6-89" => "\xe3\x87\xba",	
	"1-6-90" => "\xe3\x87\xbb",	
	"1-6-91" => "\xe3\x87\xbc",	
	"1-6-92" => "\xe3\x87\xbd",	
	"1-6-93" => "\xe3\x87\xbe",	
	"1-6-94" => "\xe3\x87\xbf",	
	"1-7-1" => "\xd0\x90",
	"1-7-2" => "\xd0\x91",
	"1-7-3" => "\xd0\x92",
	"1-7-4" => "\xd0\x93",
	"1-7-5" => "\xd0\x94",
	"1-7-6" => "\xd0\x95",
	"1-7-7" => "\xd0\x81",
	"1-7-8" => "\xd0\x96",
	"1-7-9" => "\xd0\x97",
	"1-7-10" => "\xd0\x98",
	"1-7-11" => "\xd0\x99",
	"1-7-12" => "\xd0\x9a",
	"1-7-13" => "\xd0\x9b",
	"1-7-14" => "\xd0\x9c",
	"1-7-15" => "\xd0\x9d",
	"1-7-16" => "\xd0\x9e",
	"1-7-17" => "\xd0\x9f",
	"1-7-18" => "\xd0\xa0",
	"1-7-19" => "\xd0\xa1",
	"1-7-20" => "\xd0\xa2",
	"1-7-21" => "\xd0\xa3",
	"1-7-22" => "\xd0\xa4",
	"1-7-23" => "\xd0\xa5",
	"1-7-24" => "\xd0\xa6",
	"1-7-25" => "\xd0\xa7",
	"1-7-26" => "\xd0\xa8",
	"1-7-27" => "\xd0\xa9",
	"1-7-28" => "\xd0\xaa",
	"1-7-29" => "\xd0\xab",
	"1-7-30" => "\xd0\xac",
	"1-7-31" => "\xd0\xad",
	"1-7-32" => "\xd0\xae",
	"1-7-33" => "\xd0\xaf",
	"1-7-34" => "\xe2\x8e\xbe",	
	"1-7-35" => "\xe2\x8e\xbf",	
	"1-7-36" => "\xe2\x8f\x80",	
	"1-7-37" => "\xe2\x8f\x81",	
	"1-7-38" => "\xe2\x8f\x82",	
	"1-7-39" => "\xe2\x8f\x83",	
	"1-7-40" => "\xe2\x8f\x84",	
	"1-7-41" => "\xe2\x8f\x85",	
	"1-7-42" => "\xe2\x8f\x86",	
	"1-7-43" => "\xe2\x8f\x87",	
	"1-7-44" => "\xe2\x8f\x88",	
	"1-7-45" => "\xe2\x8f\x89",	
	"1-7-46" => "\xe2\x8f\x8a",	
	"1-7-47" => "\xe2\x8f\x8b",	
	"1-7-48" => "\xe2\x8f\x8c",	
	"1-7-49" => "\xd0\xb0",
	"1-7-50" => "\xd0\xb1",
	"1-7-51" => "\xd0\xb2",
	"1-7-52" => "\xd0\xb3",
	"1-7-53" => "\xd0\xb4",
	"1-7-54" => "\xd0\xb5",
	"1-7-55" => "\xd1\x91",
	"1-7-56" => "\xd0\xb6",
	"1-7-57" => "\xd0\xb7",
	"1-7-58" => "\xd0\xb8",
	"1-7-59" => "\xd0\xb9",
	"1-7-60" => "\xd0\xba",
	"1-7-61" => "\xd0\xbb",
	"1-7-62" => "\xd0\xbc",
	"1-7-63" => "\xd0\xbd",
	"1-7-64" => "\xd0\xbe",
	"1-7-65" => "\xd0\xbf",
	"1-7-66" => "\xd1\x80",
	"1-7-67" => "\xd1\x81",
	"1-7-68" => "\xd1\x82",
	"1-7-69" => "\xd1\x83",
	"1-7-70" => "\xd1\x84",
	"1-7-71" => "\xd1\x85",
	"1-7-72" => "\xd1\x86",
	"1-7-73" => "\xd1\x87",
	"1-7-74" => "\xd1\x88",
	"1-7-75" => "\xd1\x89",
	"1-7-76" => "\xd1\x8a",
	"1-7-77" => "\xd1\x8b",
	"1-7-78" => "\xd1\x8c",
	"1-7-79" => "\xd1\x8d",
	"1-7-80" => "\xd1\x8e",
	"1-7-81" => "\xd1\x8f",
	"1-7-82" => "\xe3\x83\xb7",
	"1-7-83" => "\xe3\x83\xb8",
	"1-7-84" => "\xe3\x83\xb9",
	"1-7-85" => "\xe3\x83\xba",
	"1-7-86" => "\xe2\x8b\x9a",
	"1-7-87" => "\xe2\x8b\x9b",
	"1-7-88" => "\xe2\x85\x93",
	"1-7-89" => "\xe2\x85\x94",
	"1-7-90" => "\xe2\x85\x95",
	"1-7-91" => "\xe2\x9c\x93",
	"1-7-92" => "\xe2\x8c\x98",
	"1-7-93" => "\xe2\x90\xa3",
	"1-7-94" => "\xe2\x8f\x8e",	
	"1-8-1" => "\xe2\x94\x80",
	"1-8-2" => "\xe2\x94\x82",
	"1-8-3" => "\xe2\x94\x8c",
	"1-8-4" => "\xe2\x94\x90",
	"1-8-5" => "\xe2\x94\x98",
	"1-8-6" => "\xe2\x94\x94",
	"1-8-7" => "\xe2\x94\x9c",
	"1-8-8" => "\xe2\x94\xac",
	"1-8-9" => "\xe2\x94\xa4",
	"1-8-10" => "\xe2\x94\xb4",
	"1-8-11" => "\xe2\x94\xbc",
	"1-8-12" => "\xe2\x94\x81",
	"1-8-13" => "\xe2\x94\x83",
	"1-8-14" => "\xe2\x94\x8f",
	"1-8-15" => "\xe2\x94\x93",
	"1-8-16" => "\xe2\x94\x9b",
	"1-8-17" => "\xe2\x94\x97",
	"1-8-18" => "\xe2\x94\xa3",
	"1-8-19" => "\xe2\x94\xb3",
	"1-8-20" => "\xe2\x94\xab",
	"1-8-21" => "\xe2\x94\xbb",
	"1-8-22" => "\xe2\x95\x8b",
	"1-8-23" => "\xe2\x94\xa0",
	"1-8-24" => "\xe2\x94\xaf",
	"1-8-25" => "\xe2\x94\xa8",
	"1-8-26" => "\xe2\x94\xb7",
	"1-8-27" => "\xe2\x94\xbf",
	"1-8-28" => "\xe2\x94\x9d",
	"1-8-29" => "\xe2\x94\xb0",
	"1-8-30" => "\xe2\x94\xa5",
	"1-8-31" => "\xe2\x94\xb8",
	"1-8-32" => "\xe2\x95\x82",
	"1-8-33" => "\xe3\x89\x91",	
	"1-8-34" => "\xe3\x89\x92",	
	"1-8-35" => "\xe3\x89\x93",	
	"1-8-36" => "\xe3\x89\x94",	
	"1-8-37" => "\xe3\x89\x95",	
	"1-8-38" => "\xe3\x89\x96",	
	"1-8-39" => "\xe3\x89\x97",	
	"1-8-40" => "\xe3\x89\x98",	
	"1-8-41" => "\xe3\x89\x99",	
	"1-8-42" => "\xe3\x89\x9a",	
	"1-8-43" => "\xe3\x89\x9b",	
	"1-8-44" => "\xe3\x89\x9c",	
	"1-8-45" => "\xe3\x89\x9d",	
	"1-8-46" => "\xe3\x89\x9e",	
	"1-8-47" => "\xe3\x89\x9f",	
	"1-8-48" => "\xe3\x8a\xb1",	
	"1-8-49" => "\xe3\x8a\xb2",	
	"1-8-50" => "\xe3\x8a\xb3",	
	"1-8-51" => "\xe3\x8a\xb4",	
	"1-8-52" => "\xe3\x8a\xb5",	
	"1-8-53" => "\xe3\x8a\xb6",	
	"1-8-54" => "\xe3\x8a\xb7",	
	"1-8-55" => "\xe3\x8a\xb8",	
	"1-8-56" => "\xe3\x8a\xb9",	
	"1-8-57" => "\xe3\x8a\xba",	
	"1-8-58" => "\xe3\x8a\xbb",	
	"1-8-59" => "\xe3\x8a\xbc",	
	"1-8-60" => "\xe3\x8a\xbd",	
	"1-8-61" => "\xe3\x8a\xbe",	
	"1-8-62" => "\xe3\x8a\xbf",	
	"1-8-63" => "\xef\xbf\xbf",
	"1-8-64" => "\xef\xbf\xbf",
	"1-8-65" => "\xef\xbf\xbf",
	"1-8-66" => "\xef\xbf\xbf",
	"1-8-67" => "\xef\xbf\xbf",
	"1-8-68" => "\xef\xbf\xbf",
	"1-8-69" => "\xef\xbf\xbf",
	"1-8-70" => "\xef\xbf\xbf",
	"1-8-71" => "\xe2\x97\x90",
	"1-8-72" => "\xe2\x97\x91",
	"1-8-73" => "\xe2\x97\x92",
	"1-8-74" => "\xe2\x97\x93",
	"1-8-75" => "\xe2\x80\xbc",
	"1-8-76" => "\xe2\x81\x87",	
	"1-8-77" => "\xe2\x81\x88",
	"1-8-78" => "\xe2\x81\x89",
	"1-8-79" => "\xc7\x8d",
	"1-8-80" => "\xc7\x8e",
	"1-8-81" => "\xc7\x90",
	"1-8-82" => "\xe1\xb8\xbe",
	"1-8-83" => "\xe1\xb8\xbf",
	"1-8-84" => "\xc7\xb8",
	"1-8-85" => "\xc7\xb9",
	"1-8-86" => "\xc7\x91",
	"1-8-87" => "\xc7\x92",
	"1-8-88" => "\xc7\x94",
	"1-8-89" => "\xc7\x96",
	"1-8-90" => "\xc7\x98",
	"1-8-91" => "\xc7\x9a",
	"1-8-92" => "\xc7\x9c",
	"1-8-93" => "\xef\xbf\xbf",
	"1-8-94" => "\xef\xbf\xbf",
	"1-9-1" => "\xe2\x82\xac",
	"1-9-2" => "\xc2\xa0",
	"1-9-3" => "\xc2\xa1",
	"1-9-4" => "\xc2\xa4",
	"1-9-5" => "\xc2\xa6",
	"1-9-6" => "\xc2\xa9",
	"1-9-7" => "\xc2\xaa",
	"1-9-8" => "\xc2\xab",
	"1-9-9" => "\xc2\xad",
	"1-9-10" => "\xc2\xae",
	"1-9-11" => "\xc2\xaf",
	"1-9-12" => "\xc2\xb2",
	"1-9-13" => "\xc2\xb3",
	"1-9-14" => "\xc2\xb7",
	"1-9-15" => "\xc2\xb8",
	"1-9-16" => "\xc2\xb9",
	"1-9-17" => "\xc2\xba",
	"1-9-18" => "\xc2\xbb",
	"1-9-19" => "\xc2\xbc",
	"1-9-20" => "\xc2\xbd",
	"1-9-21" => "\xc2\xbe",
	"1-9-22" => "\xc2\xbf",
	"1-9-23" => "\xc3\x80",
	"1-9-24" => "\xc3\x81",
	"1-9-25" => "\xc3\x82",
	"1-9-26" => "\xc3\x83",
	"1-9-27" => "\xc3\x84",
	"1-9-28" => "\xc3\x85",
	"1-9-29" => "\xc3\x86",
	"1-9-30" => "\xc3\x87",
	"1-9-31" => "\xc3\x88",
	"1-9-32" => "\xc3\x89",
	"1-9-33" => "\xc3\x8a",
	"1-9-34" => "\xc3\x8b",
	"1-9-35" => "\xc3\x8c",
	"1-9-36" => "\xc3\x8d",
	"1-9-37" => "\xc3\x8e",
	"1-9-38" => "\xc3\x8f",
	"1-9-39" => "\xc3\x90",
	"1-9-40" => "\xc3\x91",
	"1-9-41" => "\xc3\x92",
	"1-9-42" => "\xc3\x93",
	"1-9-43" => "\xc3\x94",
	"1-9-44" => "\xc3\x95",
	"1-9-45" => "\xc3\x96",
	"1-9-46" => "\xc3\x98",
	"1-9-47" => "\xc3\x99",
	"1-9-48" => "\xc3\x9a",
	"1-9-49" => "\xc3\x9b",
	"1-9-50" => "\xc3\x9c",
	"1-9-51" => "\xc3\x9d",
	"1-9-52" => "\xc3\x9e",
	"1-9-53" => "\xc3\x9f",
	"1-9-54" => "\xc3\xa0",
	"1-9-55" => "\xc3\xa1",
	"1-9-56" => "\xc3\xa2",
	"1-9-57" => "\xc3\xa3",
	"1-9-58" => "\xc3\xa4",
	"1-9-59" => "\xc3\xa5",
	"1-9-60" => "\xc3\xa6",
	"1-9-61" => "\xc3\xa7",
	"1-9-62" => "\xc3\xa8",
	"1-9-63" => "\xc3\xa9",
	"1-9-64" => "\xc3\xaa",
	"1-9-65" => "\xc3\xab",
	"1-9-66" => "\xc3\xac",
	"1-9-67" => "\xc3\xad",
	"1-9-68" => "\xc3\xae",
	"1-9-69" => "\xc3\xaf",
	"1-9-70" => "\xc3\xb0",
	"1-9-71" => "\xc3\xb1",
	"1-9-72" => "\xc3\xb2",
	"1-9-73" => "\xc3\xb3",
	"1-9-74" => "\xc3\xb4",
	"1-9-75" => "\xc3\xb5",
	"1-9-76" => "\xc3\xb6",
	"1-9-77" => "\xc3\xb8",
	"1-9-78" => "\xc3\xb9",
	"1-9-79" => "\xc3\xba",
	"1-9-80" => "\xc3\xbb",
	"1-9-81" => "\xc3\xbc",
	"1-9-82" => "\xc3\xbd",
	"1-9-83" => "\xc3\xbe",
	"1-9-84" => "\xc3\xbf",
	"1-9-85" => "\xc4\x80",
	"1-9-86" => "\xc4\xaa",
	"1-9-87" => "\xc5\xaa",
	"1-9-88" => "\xc4\x92",
	"1-9-89" => "\xc5\x8c",
	"1-9-90" => "\xc4\x81",
	"1-9-91" => "\xc4\xab",
	"1-9-92" => "\xc5\xab",
	"1-9-93" => "\xc4\x93",
	"1-9-94" => "\xc5\x8d",
	"1-10-1" => "\xc4\x84",
	"1-10-2" => "\xcb\x98",
	"1-10-3" => "\xc5\x81",
	"1-10-4" => "\xc4\xbd",
	"1-10-5" => "\xc5\x9a",
	"1-10-6" => "\xc5\xa0",
	"1-10-7" => "\xc5\x9e",
	"1-10-8" => "\xc5\xa4",
	"1-10-9" => "\xc5\xb9",
	"1-10-10" => "\xc5\xbd",
	"1-10-11" => "\xc5\xbb",
	"1-10-12" => "\xc4\x85",
	"1-10-13" => "\xcb\x9b",
	"1-10-14" => "\xc5\x82",
	"1-10-15" => "\xc4\xbe",
	"1-10-16" => "\xc5\x9b",
	"1-10-17" => "\xcb\x87",
	"1-10-18" => "\xc5\xa1",
	"1-10-19" => "\xc5\x9f",
	"1-10-20" => "\xc5\xa5",
	"1-10-21" => "\xc5\xba",
	"1-10-22" => "\xcb\x9d",
	"1-10-23" => "\xc5\xbe",
	"1-10-24" => "\xc5\xbc",
	"1-10-25" => "\xc5\x94",
	"1-10-26" => "\xc4\x82",
	"1-10-27" => "\xc4\xb9",
	"1-10-28" => "\xc4\x86",
	"1-10-29" => "\xc4\x8c",
	"1-10-30" => "\xc4\x98",
	"1-10-31" => "\xc4\x9a",
	"1-10-32" => "\xc4\x8e",
	"1-10-33" => "\xc5\x83",
	"1-10-34" => "\xc5\x87",
	"1-10-35" => "\xc5\x90",
	"1-10-36" => "\xc5\x98",
	"1-10-37" => "\xc5\xae",
	"1-10-38" => "\xc5\xb0",
	"1-10-39" => "\xc5\xa2",
	"1-10-40" => "\xc5\x95",
	"1-10-41" => "\xc4\x83",
	"1-10-42" => "\xc4\xba",
	"1-10-43" => "\xc4\x87",
	"1-10-44" => "\xc4\x8d",
	"1-10-45" => "\xc4\x99",
	"1-10-46" => "\xc4\x9b",
	"1-10-47" => "\xc4\x8f",
	"1-10-48" => "\xc4\x91",
	"1-10-49" => "\xc5\x84",
	"1-10-50" => "\xc5\x88",
	"1-10-51" => "\xc5\x91",
	"1-10-52" => "\xc5\x99",
	"1-10-53" => "\xc5\xaf",
	"1-10-54" => "\xc5\xb1",
	"1-10-55" => "\xc5\xa3",
	"1-10-56" => "\xcb\x99",
	"1-10-57" => "\xc4\x88",
	"1-10-58" => "\xc4\x9c",
	"1-10-59" => "\xc4\xa4",
	"1-10-60" => "\xc4\xb4",
	"1-10-61" => "\xc5\x9c",
	"1-10-62" => "\xc5\xac",
	"1-10-63" => "\xc4\x89",
	"1-10-64" => "\xc4\x9d",
	"1-10-65" => "\xc4\xa5",
	"1-10-66" => "\xc4\xb5",
	"1-10-67" => "\xc5\x9d",
	"1-10-68" => "\xc5\xad",
	"1-10-69" => "\xc9\xb1",
	"1-10-70" => "\xca\x8b",
	"1-10-71" => "\xc9\xbe",
	"1-10-72" => "\xca\x83",
	"1-10-73" => "\xca\x92",
	"1-10-74" => "\xc9\xac",
	"1-10-75" => "\xc9\xae",
	"1-10-76" => "\xc9\xb9",
	"1-10-77" => "\xca\x88",
	"1-10-78" => "\xc9\x96",
	"1-10-79" => "\xc9\xb3",
	"1-10-80" => "\xc9\xbd",
	"1-10-81" => "\xca\x82",
	"1-10-82" => "\xca\x90",
	"1-10-83" => "\xc9\xbb",
	"1-10-84" => "\xc9\xad",
	"1-10-85" => "\xc9\x9f",
	"1-10-86" => "\xc9\xb2",
	"1-10-87" => "\xca\x9d",
	"1-10-88" => "\xca\x8e",
	"1-10-89" => "\xc9\xa1",
	"1-10-90" => "\xc5\x8b",
	"1-10-91" => "\xc9\xb0",
	"1-10-92" => "\xca\x81",
	"1-10-93" => "\xc4\xa7",
	"1-10-94" => "\xca\x95",
	"1-11-1" => "\xca\x94",
	"1-11-2" => "\xc9\xa6",
	"1-11-3" => "\xca\x98",
	"1-11-4" => "\xc7\x82",
	"1-11-5" => "\xc9\x93",
	"1-11-6" => "\xc9\x97",
	"1-11-7" => "\xca\x84",
	"1-11-8" => "\xc9\xa0",
	"1-11-9" => "\xc6\x93",
	"1-11-10" => "\xc5\x93",
	"1-11-11" => "\xc5\x92",
	"1-11-12" => "\xc9\xa8",
	"1-11-13" => "\xca\x89",
	"1-11-14" => "\xc9\x98",
	"1-11-15" => "\xc9\xb5",
	"1-11-16" => "\xc9\x99",
	"1-11-17" => "\xc9\x9c",
	"1-11-18" => "\xc9\x9e",
	"1-11-19" => "\xc9\x90",
	"1-11-20" => "\xc9\xaf",
	"1-11-21" => "\xca\x8a",
	"1-11-22" => "\xc9\xa4",
	"1-11-23" => "\xca\x8c",
	"1-11-24" => "\xc9\x94",
	"1-11-25" => "\xc9\x91",
	"1-11-26" => "\xc9\x92",
	"1-11-27" => "\xca\x8d",
	"1-11-28" => "\xc9\xa5",
	"1-11-29" => "\xca\xa2",
	"1-11-30" => "\xca\xa1",
	"1-11-31" => "\xc9\x95",
	"1-11-32" => "\xca\x91",
	"1-11-33" => "\xc9\xba",
	"1-11-34" => "\xc9\xa7",
	"1-11-35" => "\xc9\x9a",
	"1-11-36" => "\xc3\xa6\xcc\x80",	
	"1-11-37" => "\xc7\xbd",
	"1-11-38" => "\xe1\xbd\xb0",
	"1-11-39" => "\xe1\xbd\xb1",
	"1-11-40" => "\xc9\x94\xcc\x80",	
	"1-11-41" => "\xc9\x94\xcc\x81",	
	"1-11-42" => "\xca\x8c\xcc\x80",	
	"1-11-43" => "\xca\x8c\xcc\x81",	
	"1-11-44" => "\xc9\x99\xcc\x80",	
	"1-11-45" => "\xc9\x99\xcc\x81",	
	"1-11-46" => "\xc9\x9a\xcc\x80",	
	"1-11-47" => "\xc9\x9a\xcc\x81",	
	"1-11-48" => "\xe1\xbd\xb2",
	"1-11-49" => "\xe1\xbd\xb3",
	"1-11-50" => "\xcd\xa1",
	"1-11-51" => "\xcb\x88",
	"1-11-52" => "\xcb\x8c",
	"1-11-53" => "\xcb\x90",
	"1-11-54" => "\xcb\x91",
	"1-11-55" => "\xcc\x86",
	"1-11-56" => "\xe2\x80\xbf",
	"1-11-57" => "\xcc\x8b",
	"1-11-58" => "\xcc\x81",
	"1-11-59" => "\xcc\x84",
	"1-11-60" => "\xcc\x80",
	"1-11-61" => "\xcc\x8f",
	"1-11-62" => "\xcc\x8c",
	"1-11-63" => "\xcc\x82",
	"1-11-64" => "\xcb\xa5",
	"1-11-65" => "\xcb\xa6",
	"1-11-66" => "\xcb\xa7",
	"1-11-67" => "\xcb\xa8",
	"1-11-68" => "\xcb\xa9",
	"1-11-69" => "\xcb\xa9\xcb\xa5",	
	"1-11-70" => "\xcb\xa5\xcb\xa9",	
	"1-11-71" => "\xcc\xa5",
	"1-11-72" => "\xcc\xac",
	"1-11-73" => "\xcc\xb9",
	"1-11-74" => "\xcc\x9c",
	"1-11-75" => "\xcc\x9f",
	"1-11-76" => "\xcc\xa0",
	"1-11-77" => "\xcc\x88",
	"1-11-78" => "\xcc\xbd",
	"1-11-79" => "\xcc\xa9",
	"1-11-80" => "\xcc\xaf",
	"1-11-81" => "\xcb\x9e",
	"1-11-82" => "\xcc\xa4",
	"1-11-83" => "\xcc\xb0",
	"1-11-84" => "\xcc\xbc",
	"1-11-85" => "\xcc\xb4",
	"1-11-86" => "\xcc\x9d",
	"1-11-87" => "\xcc\x9e",
	"1-11-88" => "\xcc\x98",
	"1-11-89" => "\xcc\x99",
	"1-11-90" => "\xcc\xaa",
	"1-11-91" => "\xcc\xba",
	"1-11-92" => "\xcc\xbb",
	"1-11-93" => "\xcc\x83",
	"1-11-94" => "\xcc\x9a",
	"1-12-1" => "\xe2\x9d\xb6",
	"1-12-2" => "\xe2\x9d\xb7",
	"1-12-3" => "\xe2\x9d\xb8",
	"1-12-4" => "\xe2\x9d\xb9",
	"1-12-5" => "\xe2\x9d\xba",
	"1-12-6" => "\xe2\x9d\xbb",
	"1-12-7" => "\xe2\x9d\xbc",
	"1-12-8" => "\xe2\x9d\xbd",
	"1-12-9" => "\xe2\x9d\xbe",
	"1-12-10" => "\xe2\x9d\xbf",
	"1-12-11" => "\xe2\x93\xab",	
	"1-12-12" => "\xe2\x93\xac",	
	"1-12-13" => "\xe2\x93\xad",	
	"1-12-14" => "\xe2\x93\xae",	
	"1-12-15" => "\xe2\x93\xaf",	
	"1-12-16" => "\xe2\x93\xb0",	
	"1-12-17" => "\xe2\x93\xb1",	
	"1-12-18" => "\xe2\x93\xb2",	
	"1-12-19" => "\xe2\x93\xb3",	
	"1-12-20" => "\xe2\x93\xb4",	
	"1-12-21" => "\xe2\x85\xb0",
	"1-12-22" => "\xe2\x85\xb1",
	"1-12-23" => "\xe2\x85\xb2",
	"1-12-24" => "\xe2\x85\xb3",
	"1-12-25" => "\xe2\x85\xb4",
	"1-12-26" => "\xe2\x85\xb5",
	"1-12-27" => "\xe2\x85\xb6",
	"1-12-28" => "\xe2\x85\xb7",
	"1-12-29" => "\xe2\x85\xb8",
	"1-12-30" => "\xe2\x85\xb9",
	"1-12-31" => "\xe2\x85\xba",
	"1-12-32" => "\xe2\x85\xbb",
	"1-12-33" => "\xe2\x93\x90",
	"1-12-34" => "\xe2\x93\x91",
	"1-12-35" => "\xe2\x93\x92",
	"1-12-36" => "\xe2\x93\x93",
	"1-12-37" => "\xe2\x93\x94",
	"1-12-38" => "\xe2\x93\x95",
	"1-12-39" => "\xe2\x93\x96",
	"1-12-40" => "\xe2\x93\x97",
	"1-12-41" => "\xe2\x93\x98",
	"1-12-42" => "\xe2\x93\x99",
	"1-12-43" => "\xe2\x93\x9a",
	"1-12-44" => "\xe2\x93\x9b",
	"1-12-45" => "\xe2\x93\x9c",
	"1-12-46" => "\xe2\x93\x9d",
	"1-12-47" => "\xe2\x93\x9e",
	"1-12-48" => "\xe2\x93\x9f",
	"1-12-49" => "\xe2\x93\xa0",
	"1-12-50" => "\xe2\x93\xa1",
	"1-12-51" => "\xe2\x93\xa2",
	"1-12-52" => "\xe2\x93\xa3",
	"1-12-53" => "\xe2\x93\xa4",
	"1-12-54" => "\xe2\x93\xa5",
	"1-12-55" => "\xe2\x93\xa6",
	"1-12-56" => "\xe2\x93\xa7",
	"1-12-57" => "\xe2\x93\xa8",
	"1-12-58" => "\xe2\x93\xa9",
	"1-12-59" => "\xe3\x8b\x90",
	"1-12-60" => "\xe3\x8b\x91",
	"1-12-61" => "\xe3\x8b\x92",
	"1-12-62" => "\xe3\x8b\x93",
	"1-12-63" => "\xe3\x8b\x94",
	"1-12-64" => "\xe3\x8b\x95",
	"1-12-65" => "\xe3\x8b\x96",
	"1-12-66" => "\xe3\x8b\x97",
	"1-12-67" => "\xe3\x8b\x98",
	"1-12-68" => "\xe3\x8b\x99",
	"1-12-69" => "\xe3\x8b\x9a",
	"1-12-70" => "\xe3\x8b\x9b",
	"1-12-71" => "\xe3\x8b\x9c",
	"1-12-72" => "\xe3\x8b\x9d",
	"1-12-73" => "\xe3\x8b\x9e",
	"1-12-74" => "\xe3\x8b\x9f",
	"1-12-75" => "\xe3\x8b\xa0",
	"1-12-76" => "\xe3\x8b\xa1",
	"1-12-77" => "\xe3\x8b\xa2",
	"1-12-78" => "\xe3\x8b\xa3",
	"1-12-79" => "\xe3\x8b\xba",
	"1-12-80" => "\xe3\x8b\xa9",
	"1-12-81" => "\xe3\x8b\xa5",
	"1-12-82" => "\xe3\x8b\xad",
	"1-12-83" => "\xe3\x8b\xac",
	"1-12-84" => "\xef\xbf\xbf",
	"1-12-85" => "\xef\xbf\xbf",
	"1-12-86" => "\xef\xbf\xbf",
	"1-12-87" => "\xef\xbf\xbf",
	"1-12-88" => "\xef\xbf\xbf",
	"1-12-89" => "\xef\xbf\xbf",
	"1-12-90" => "\xef\xbf\xbf",
	"1-12-91" => "\xef\xbf\xbf",
	"1-12-92" => "\xef\xbf\xbf",
	"1-12-93" => "\xe2\x81\x91",	
	"1-12-94" => "\xe2\x81\x82",
	"1-13-1" => "\xe2\x91\xa0",
	"1-13-2" => "\xe2\x91\xa1",
	"1-13-3" => "\xe2\x91\xa2",
	"1-13-4" => "\xe2\x91\xa3",
	"1-13-5" => "\xe2\x91\xa4",
	"1-13-6" => "\xe2\x91\xa5",
	"1-13-7" => "\xe2\x91\xa6",
	"1-13-8" => "\xe2\x91\xa7",
	"1-13-9" => "\xe2\x91\xa8",
	"1-13-10" => "\xe2\x91\xa9",
	"1-13-11" => "\xe2\x91\xaa",
	"1-13-12" => "\xe2\x91\xab",
	"1-13-13" => "\xe2\x91\xac",
	"1-13-14" => "\xe2\x91\xad",
	"1-13-15" => "\xe2\x91\xae",
	"1-13-16" => "\xe2\x91\xaf",
	"1-13-17" => "\xe2\x91\xb0",
	"1-13-18" => "\xe2\x91\xb1",
	"1-13-19" => "\xe2\x91\xb2",
	"1-13-20" => "\xe2\x91\xb3",
	"1-13-21" => "\xe2\x85\xa0",
	"1-13-22" => "\xe2\x85\xa1",
	"1-13-23" => "\xe2\x85\xa2",
	"1-13-24" => "\xe2\x85\xa3",
	"1-13-25" => "\xe2\x85\xa4",
	"1-13-26" => "\xe2\x85\xa5",
	"1-13-27" => "\xe2\x85\xa6",
	"1-13-28" => "\xe2\x85\xa7",
	"1-13-29" => "\xe2\x85\xa8",
	"1-13-30" => "\xe2\x85\xa9",
	"1-13-31" => "\xe2\x85\xaa",
	"1-13-32" => "\xe3\x8d\x89",
	"1-13-33" => "\xe3\x8c\x94",
	"1-13-34" => "\xe3\x8c\xa2",
	"1-13-35" => "\xe3\x8d\x8d",
	"1-13-36" => "\xe3\x8c\x98",
	"1-13-37" => "\xe3\x8c\xa7",
	"1-13-38" => "\xe3\x8c\x83",
	"1-13-39" => "\xe3\x8c\xb6",
	"1-13-40" => "\xe3\x8d\x91",
	"1-13-41" => "\xe3\x8d\x97",
	"1-13-42" => "\xe3\x8c\x8d",
	"1-13-43" => "\xe3\x8c\xa6",
	"1-13-44" => "\xe3\x8c\xa3",
	"1-13-45" => "\xe3\x8c\xab",
	"1-13-46" => "\xe3\x8d\x8a",
	"1-13-47" => "\xe3\x8c\xbb",
	"1-13-48" => "\xe3\x8e\x9c",
	"1-13-49" => "\xe3\x8e\x9d",
	"1-13-50" => "\xe3\x8e\x9e",
	"1-13-51" => "\xe3\x8e\x8e",
	"1-13-52" => "\xe3\x8e\x8f",
	"1-13-53" => "\xe3\x8f\x84",
	"1-13-54" => "\xe3\x8e\xa1",
	"1-13-55" => "\xe2\x85\xab",
	"1-13-56" => "\xef\xbf\xbf",
	"1-13-57" => "\xef\xbf\xbf",
	"1-13-58" => "\xef\xbf\xbf",
	"1-13-59" => "\xef\xbf\xbf",
	"1-13-60" => "\xef\xbf\xbf",
	"1-13-61" => "\xef\xbf\xbf",
	"1-13-62" => "\xef\xbf\xbf",
	"1-13-63" => "\xe3\x8d\xbb",
	"1-13-64" => "\xe3\x80\x9d",
	"1-13-65" => "\xe3\x80\x9f",
	"1-13-66" => "\xe2\x84\x96",
	"1-13-67" => "\xe3\x8f\x8d",
	"1-13-68" => "\xe2\x84\xa1",
	"1-13-69" => "\xe3\x8a\xa4",
	"1-13-70" => "\xe3\x8a\xa5",
	"1-13-71" => "\xe3\x8a\xa6",
	"1-13-72" => "\xe3\x8a\xa7",
	"1-13-73" => "\xe3\x8a\xa8",
	"1-13-74" => "\xe3\x88\xb1",
	"1-13-75" => "\xe3\x88\xb2",
	"1-13-76" => "\xe3\x88\xb9",
	"1-13-77" => "\xe3\x8d\xbe",
	"1-13-78" => "\xe3\x8d\xbd",
	"1-13-79" => "\xe3\x8d\xbc",
	"1-13-80" => "\xef\xbf\xbf",
	"1-13-81" => "\xef\xbf\xbf",
	"1-13-82" => "\xef\xbf\xbf",
	"1-13-83" => "\xe2\x88\xae",
	"1-13-84" => "\xef\xbf\xbf",
	"1-13-85" => "\xef\xbf\xbf",
	"1-13-86" => "\xef\xbf\xbf",
	"1-13-87" => "\xef\xbf\xbf",
	"1-13-88" => "\xe2\x88\x9f",
	"1-13-89" => "\xe2\x8a\xbf",
	"1-13-90" => "\xef\xbf\xbf",
	"1-13-91" => "\xef\xbf\xbf",
	"1-13-92" => "\xef\xbf\xbf",
	"1-13-93" => "\xe2\x9d\x96",
	"1-13-94" => "\xe2\x98\x9e",
	"1-14-1" => "\xe4\xbf\xb1",		# 07/07/01 fix
	"1-14-2" => "\xf0\xa0\x80\x8b",	
	"1-14-3" => "\xe3\x90\x82",
	"1-14-4" => "\xe4\xb8\xa8",
	"1-14-5" => "\xe4\xb8\xaf",
	"1-14-6" => "\xe4\xb8\xb0",
	"1-14-7" => "\xe4\xba\x8d",
	"1-14-8" => "\xe4\xbb\xa1",
	"1-14-9" => "\xe4\xbb\xbd",
	"1-14-10" => "\xe4\xbb\xbf",
	"1-14-11" => "\xe4\xbc\x83",
	"1-14-12" => "\xe4\xbc\x8b",
	"1-14-13" => "\xe4\xbd\xa0",
	"1-14-14" => "\xe4\xbd\x88",
	"1-14-15" => "\xe4\xbd\x89",
	"1-14-16" => "\xe4\xbd\x96",
	"1-14-17" => "\xe4\xbd\x9f",
	"1-14-18" => "\xe4\xbd\xaa",
	"1-14-19" => "\xe4\xbd\xac",
	"1-14-20" => "\xe4\xbd\xbe",
	"1-14-21" => "\xe4\xbe\x8a",
	"1-14-22" => "\xe4\xbe\x94",
	"1-14-23" => "\xe4\xbe\x97",
	"1-14-24" => "\xe4\xbe\xae",	
	"1-14-25" => "\xe4\xbf\x89",
	"1-14-26" => "\xe4\xbf\xa0",
	"1-14-27" => "\xe5\x80\x81",
	"1-14-28" => "\xe5\x80\x82",
	"1-14-29" => "\xe5\x80\x8e",
	"1-14-30" => "\xe5\x80\x98",
	"1-14-31" => "\xe5\x80\xa7",
	"1-14-32" => "\xe5\x80\xae",
	"1-14-33" => "\xe5\x81\x80",
	"1-14-34" => "\xe5\x80\xbb",
	"1-14-35" => "\xe5\x81\x81",
	"1-14-36" => "\xe5\x82\x94",
	"1-14-37" => "\xe5\x83\x8c",
	"1-14-38" => "\xe5\x83\xb2",
	"1-14-39" => "\xe5\x83\x90",
	"1-14-40" => "\xe5\x83\xa6",
	"1-14-41" => "\xe5\x83\xa7",	
	"1-14-42" => "\xe5\x84\x86",
	"1-14-43" => "\xe5\x84\x83",
	"1-14-44" => "\xe5\x84\x8b",
	"1-14-45" => "\xe5\x84\x9e",
	"1-14-46" => "\xe5\x84\xb5",
	"1-14-47" => "\xe5\x85\x8a",
	"1-14-48" => "\xe5\x85\x8d",	
	"1-14-49" => "\xe5\x85\x95",
	"1-14-50" => "\xe5\x85\x97",
	"1-14-51" => "\xe3\x92\xb5",
	"1-14-52" => "\xe5\x86\x9d",
	"1-14-53" => "\xe5\x87\x83",
	"1-14-54" => "\xe5\x87\x8a",
	"1-14-55" => "\xe5\x87\x9e",
	"1-14-56" => "\xe5\x87\xa2",
	"1-14-57" => "\xe5\x87\xae",
	"1-14-58" => "\xe5\x88\x81",
	"1-14-59" => "\xe3\x93\x9b",
	"1-14-60" => "\xe5\x88\x93",
	"1-14-61" => "\xe5\x88\x95",
	"1-14-62" => "\xe5\x89\x89",
	"1-14-63" => "\xe5\x89\x97",
	"1-14-64" => "\xe5\x89\xa1",
	"1-14-65" => "\xe5\x8a\x93",
	"1-14-66" => "\xe5\x8b\x88",
	"1-14-67" => "\xe5\x8b\x89",	
	"1-14-68" => "\xe5\x8b\x8c",
	"1-14-69" => "\xe5\x8b\x90",
	"1-14-70" => "\xe5\x8b\x96",
	"1-14-71" => "\xe5\x8b\x9b",
	"1-14-72" => "\xe5\x8b\xa4",	
	"1-14-73" => "\xe5\x8b\xb0",
	"1-14-74" => "\xe5\x8b\xbb",
	"1-14-75" => "\xe5\x8c\x80",
	"1-14-76" => "\xe5\x8c\x87",
	"1-14-77" => "\xe5\x8c\x9c",
	"1-14-78" => "\xe5\x8d\x91",	
	"1-14-79" => "\xe5\x8d\xa1",
	"1-14-80" => "\xe5\x8d\xa3",
	"1-14-81" => "\xe5\x8d\xbd",
	"1-14-82" => "\xe5\x8e\x93",
	"1-14-83" => "\xe5\x8e\x9d",
	"1-14-84" => "\xe5\x8e\xb2",
	"1-14-85" => "\xe5\x90\x92",
	"1-14-86" => "\xe5\x90\xa7",
	"1-14-87" => "\xe5\x91\x8d",
	"1-14-88" => "\xe5\x92\x9c",
	"1-14-89" => "\xe5\x91\xab",
	"1-14-90" => "\xe5\x91\xb4",
	"1-14-91" => "\xe5\x91\xbf",
	"1-14-92" => "\xe5\x92\x88",
	"1-14-93" => "\xe5\x92\x96",
	"1-14-94" => "\xe5\x92\xa1",
	"1-15-1" => "\xe5\x92\xa9",
	"1-15-2" => "\xe5\x93\x86",
	"1-15-3" => "\xe5\x93\xbf",
	"1-15-4" => "\xe5\x94\x8e",
	"1-15-5" => "\xe5\x94\xab",
	"1-15-6" => "\xe5\x94\xb5",
	"1-15-7" => "\xe5\x95\x90",
	"1-15-8" => "\xe5\x95\x9e",
	"1-15-9" => "\xe5\x96\x81",
	"1-15-10" => "\xe5\x96\x86",
	"1-15-11" => "\xe5\x96\x8e",
	"1-15-12" => "\xe5\x96\x9d",	
	"1-15-13" => "\xe5\x96\xad",
	"1-15-14" => "\xe5\x97\x8e",
	"1-15-15" => "\xe5\x98\x86",	
	"1-15-16" => "\xe5\x98\x88",
	"1-15-17" => "\xe5\x98\x8e",
	"1-15-18" => "\xe5\x98\xbb",
	"1-15-19" => "\xe5\x99\x89",
	"1-15-20" => "\xe5\x99\xb6",
	"1-15-21" => "\xe5\x99\xa6",
	"1-15-22" => "\xe5\x99\xa8",	
	"1-15-23" => "\xe5\x99\xaf",
	"1-15-24" => "\xe5\x99\xb1",
	"1-15-25" => "\xe5\x99\xb2",
	"1-15-26" => "\xe5\x9a\x99",
	"1-15-27" => "\xe5\x9a\x9e",
	"1-15-28" => "\xe5\x9a\xa9",
	"1-15-29" => "\xe5\x9a\xac",
	"1-15-30" => "\xe5\x9a\xb3",
	"1-15-31" => "\xe5\x9b\x89",
	"1-15-32" => "\xe5\x9b\x8a",
	"1-15-33" => "\xe5\x9c\x8a",
	"1-15-34" => "\xf0\xa1\x88\xbd",	
	"1-15-35" => "\xe5\x9c\xa1",
	"1-15-36" => "\xe5\x9c\xaf",
	"1-15-37" => "\xe5\x9c\xb3",
	"1-15-38" => "\xe5\x9c\xb4",
	"1-15-39" => "\xe5\x9d\xb0",
	"1-15-40" => "\xe5\x9d\xb7",
	"1-15-41" => "\xe5\x9d\xbc",
	"1-15-42" => "\xe5\x9e\x9c",
	"1-15-43" => "\xef\xa8\x8f",
	"1-15-44" => "\xf0\xa1\x8c\x9b",	
	"1-15-45" => "\xe5\x9e\xb8",
	"1-15-46" => "\xe5\x9f\x87",
	"1-15-47" => "\xe5\x9f\x88",
	"1-15-48" => "\xe5\x9f\x8f",
	"1-15-49" => "\xe5\x9f\xa4",
	"1-15-50" => "\xe5\x9f\xad",
	"1-15-51" => "\xe5\x9f\xb5",
	"1-15-52" => "\xe5\x9f\xb6",
	"1-15-53" => "\xe5\x9f\xbf",
	"1-15-54" => "\xe5\xa0\x89",
	"1-15-55" => "\xef\xa8\x90",
	"1-15-56" => "\xe5\xa1\xa1",
	"1-15-57" => "\xe5\xa1\xa4",
	"1-15-58" => "\xe5\xa1\x80",	
	"1-15-59" => "\xe5\xa1\xbc",
	"1-15-60" => "\xe5\xa2\x89",
	"1-15-61" => "\xe5\xa2\x9e",
	"1-15-62" => "\xe5\xa2\xa8",	
	"1-15-63" => "\xe5\xa2\xa9",
	"1-15-64" => "\xf0\xa1\x91\xae",	
	"1-15-65" => "\xe5\xa3\x92",
	"1-15-66" => "\xe5\xa3\x8e",
	"1-15-67" => "\xe5\xa3\x94",
	"1-15-68" => "\xe5\xa3\x9a",
	"1-15-69" => "\xe5\xa3\xa0",
	"1-15-70" => "\xe5\xa3\xa9",
	"1-15-71" => "\xe5\xa4\x8c",
	"1-15-72" => "\xe8\x99\x81",
	"1-15-73" => "\xe5\xa5\x9d",
	"1-15-74" => "\xe5\xa5\xad",
	"1-15-75" => "\xe5\xa6\x8b",
	"1-15-76" => "\xe5\xa6\x92",
	"1-15-77" => "\xe5\xa6\xa4",
	"1-15-78" => "\xe5\xa7\x83",
	"1-15-79" => "\xe5\xa7\x92",
	"1-15-80" => "\xe5\xa7\x9d",
	"1-15-81" => "\xe5\xa8\x93",
	"1-15-82" => "\xe5\xa8\xa3",
	"1-15-83" => "\xe5\xa9\xa7",
	"1-15-84" => "\xe5\xa9\xad",
	"1-15-85" => "\xe5\xa9\xb7",
	"1-15-86" => "\xe5\xa9\xbe",
	"1-15-87" => "\xe5\xaa\x84",
	"1-15-88" => "\xe5\xaa\x9e",
	"1-15-89" => "\xe5\xaa\xa7",
	"1-15-90" => "\xe5\xab\x84",
	"1-15-91" => "\xf0\xa1\xa2\xbd",	# 07/07/01 fix
	"1-15-92" => "\xe5\xac\x99",
	"1-15-93" => "\xe5\xac\xa5",
	"1-15-94" => "\xe5\x89\x9d",		
	"1-16-1" => "\xe4\xba\x9c",
	"1-16-2" => "\xe5\x94\x96",
	"1-16-3" => "\xe5\xa8\x83",
	"1-16-4" => "\xe9\x98\xbf",
	"1-16-5" => "\xe5\x93\x80",
	"1-16-6" => "\xe6\x84\x9b",
	"1-16-7" => "\xe6\x8c\xa8",
	"1-16-8" => "\xe5\xa7\xb6",
	"1-16-9" => "\xe9\x80\xa2",
	"1-16-10" => "\xe8\x91\xb5",
	"1-16-11" => "\xe8\x8c\x9c",
	"1-16-12" => "\xe7\xa9\x90",
	"1-16-13" => "\xe6\x82\xaa",
	"1-16-14" => "\xe6\x8f\xa1",
	"1-16-15" => "\xe6\xb8\xa5",
	"1-16-16" => "\xe6\x97\xad",
	"1-16-17" => "\xe8\x91\xa6",
	"1-16-18" => "\xe8\x8a\xa6",
	"1-16-19" => "\xe9\xaf\xb5",
	"1-16-20" => "\xe6\xa2\x93",
	"1-16-21" => "\xe5\x9c\xa7",
	"1-16-22" => "\xe6\x96\xa1",
	"1-16-23" => "\xe6\x89\xb1",
	"1-16-24" => "\xe5\xae\x9b",
	"1-16-25" => "\xe5\xa7\x90",
	"1-16-26" => "\xe8\x99\xbb",
	"1-16-27" => "\xe9\xa3\xb4",
	"1-16-28" => "\xe7\xb5\xa2",
	"1-16-29" => "\xe7\xb6\xbe",
	"1-16-30" => "\xe9\xae\x8e",
	"1-16-31" => "\xe6\x88\x96",
	"1-16-32" => "\xe7\xb2\x9f",
	"1-16-33" => "\xe8\xa2\xb7",
	"1-16-34" => "\xe5\xae\x89",
	"1-16-35" => "\xe5\xba\xb5",
	"1-16-36" => "\xe6\x8c\x89",
	"1-16-37" => "\xe6\x9a\x97",
	"1-16-38" => "\xe6\xa1\x88",
	"1-16-39" => "\xe9\x97\x87",
	"1-16-40" => "\xe9\x9e\x8d",
	"1-16-41" => "\xe6\x9d\x8f",
	"1-16-42" => "\xe4\xbb\xa5",
	"1-16-43" => "\xe4\xbc\x8a",
	"1-16-44" => "\xe4\xbd\x8d",
	"1-16-45" => "\xe4\xbe\x9d",
	"1-16-46" => "\xe5\x81\x89",
	"1-16-47" => "\xe5\x9b\xb2",
	"1-16-48" => "\xe5\xa4\xb7",
	"1-16-49" => "\xe5\xa7\x94",
	"1-16-50" => "\xe5\xa8\x81",
	"1-16-51" => "\xe5\xb0\x89",
	"1-16-52" => "\xe6\x83\x9f",
	"1-16-53" => "\xe6\x84\x8f",
	"1-16-54" => "\xe6\x85\xb0",
	"1-16-55" => "\xe6\x98\x93",
	"1-16-56" => "\xe6\xa4\x85",
	"1-16-57" => "\xe7\x82\xba",
	"1-16-58" => "\xe7\x95\x8f",
	"1-16-59" => "\xe7\x95\xb0",
	"1-16-60" => "\xe7\xa7\xbb",
	"1-16-61" => "\xe7\xb6\xad",
	"1-16-62" => "\xe7\xb7\xaf",
	"1-16-63" => "\xe8\x83\x83",
	"1-16-64" => "\xe8\x90\x8e",
	"1-16-65" => "\xe8\xa1\xa3",
	"1-16-66" => "\xe8\xac\x82",
	"1-16-67" => "\xe9\x81\x95",
	"1-16-68" => "\xe9\x81\xba",
	"1-16-69" => "\xe5\x8c\xbb",
	"1-16-70" => "\xe4\xba\x95",
	"1-16-71" => "\xe4\xba\xa5",
	"1-16-72" => "\xe5\x9f\x9f",
	"1-16-73" => "\xe8\x82\xb2",
	"1-16-74" => "\xe9\x83\x81",
	"1-16-75" => "\xe7\xa3\xaf",
	"1-16-76" => "\xe4\xb8\x80",
	"1-16-77" => "\xe5\xa3\xb1",
	"1-16-78" => "\xe6\xba\xa2",
	"1-16-79" => "\xe9\x80\xb8",
	"1-16-80" => "\xe7\xa8\xb2",
	"1-16-81" => "\xe8\x8c\xa8",
	"1-16-82" => "\xe8\x8a\x8b",
	"1-16-83" => "\xe9\xb0\xaf",
	"1-16-84" => "\xe5\x85\x81",
	"1-16-85" => "\xe5\x8d\xb0",
	"1-16-86" => "\xe5\x92\xbd",
	"1-16-87" => "\xe5\x93\xa1",
	"1-16-88" => "\xe5\x9b\xa0",
	"1-16-89" => "\xe5\xa7\xbb",
	"1-16-90" => "\xe5\xbc\x95",
	"1-16-91" => "\xe9\xa3\xb2",
	"1-16-92" => "\xe6\xb7\xab",
	"1-16-93" => "\xe8\x83\xa4",
	"1-16-94" => "\xe8\x94\xad",
	"1-17-1" => "\xe9\x99\xa2",
	"1-17-2" => "\xe9\x99\xb0",
	"1-17-3" => "\xe9\x9a\xa0",
	"1-17-4" => "\xe9\x9f\xbb",
	"1-17-5" => "\xe5\x90\x8b",
	"1-17-6" => "\xe5\x8f\xb3",
	"1-17-7" => "\xe5\xae\x87",
	"1-17-8" => "\xe7\x83\x8f",
	"1-17-9" => "\xe7\xbe\xbd",
	"1-17-10" => "\xe8\xbf\x82",
	"1-17-11" => "\xe9\x9b\xa8",
	"1-17-12" => "\xe5\x8d\xaf",
	"1-17-13" => "\xe9\xb5\x9c",
	"1-17-14" => "\xe7\xaa\xba",
	"1-17-15" => "\xe4\xb8\x91",
	"1-17-16" => "\xe7\xa2\x93",
	"1-17-17" => "\xe8\x87\xbc",
	"1-17-18" => "\xe6\xb8\xa6",
	"1-17-19" => "\xe5\x98\x98",
	"1-17-20" => "\xe5\x94\x84",
	"1-17-21" => "\xe6\xac\x9d",
	"1-17-22" => "\xe8\x94\x9a",
	"1-17-23" => "\xe9\xb0\xbb",
	"1-17-24" => "\xe5\xa7\xa5",
	"1-17-25" => "\xe5\x8e\xa9",
	"1-17-26" => "\xe6\xb5\xa6",
	"1-17-27" => "\xe7\x93\x9c",
	"1-17-28" => "\xe9\x96\x8f",
	"1-17-29" => "\xe5\x99\x82",
	"1-17-30" => "\xe4\xba\x91",
	"1-17-31" => "\xe9\x81\x8b",
	"1-17-32" => "\xe9\x9b\xb2",
	"1-17-33" => "\xe8\x8d\x8f",
	"1-17-34" => "\xe9\xa4\x8c",
	"1-17-35" => "\xe5\x8f\xa1",
	"1-17-36" => "\xe5\x96\xb6",
	"1-17-37" => "\xe5\xac\xb0",
	"1-17-38" => "\xe5\xbd\xb1",
	"1-17-39" => "\xe6\x98\xa0",
	"1-17-40" => "\xe6\x9b\xb3",
	"1-17-41" => "\xe6\xa0\x84",
	"1-17-42" => "\xe6\xb0\xb8",
	"1-17-43" => "\xe6\xb3\xb3",
	"1-17-44" => "\xe6\xb4\xa9",
	"1-17-45" => "\xe7\x91\x9b",
	"1-17-46" => "\xe7\x9b\x88",
	"1-17-47" => "\xe7\xa9\x8e",
	"1-17-48" => "\xe9\xa0\xb4",
	"1-17-49" => "\xe8\x8b\xb1",
	"1-17-50" => "\xe8\xa1\x9b",
	"1-17-51" => "\xe8\xa9\xa0",
	"1-17-52" => "\xe9\x8b\xad",
	"1-17-53" => "\xe6\xb6\xb2",
	"1-17-54" => "\xe7\x96\xab",
	"1-17-55" => "\xe7\x9b\x8a",
	"1-17-56" => "\xe9\xa7\x85",
	"1-17-57" => "\xe6\x82\xa6",
	"1-17-58" => "\xe8\xac\x81",
	"1-17-59" => "\xe8\xb6\x8a",
	"1-17-60" => "\xe9\x96\xb2",
	"1-17-61" => "\xe6\xa6\x8e",
	"1-17-62" => "\xe5\x8e\xad",
	"1-17-63" => "\xe5\x86\x86",
	"1-17-64" => "\xe5\x9c\x92",
	"1-17-65" => "\xe5\xa0\xb0",
	"1-17-66" => "\xe5\xa5\x84",
	"1-17-67" => "\xe5\xae\xb4",
	"1-17-68" => "\xe5\xbb\xb6",
	"1-17-69" => "\xe6\x80\xa8",
	"1-17-70" => "\xe6\x8e\xa9",
	"1-17-71" => "\xe6\x8f\xb4",
	"1-17-72" => "\xe6\xb2\xbf",
	"1-17-73" => "\xe6\xbc\x94",
	"1-17-74" => "\xe7\x82\x8e",
	"1-17-75" => "\xe7\x84\x94",
	"1-17-76" => "\xe7\x85\x99",
	"1-17-77" => "\xe7\x87\x95",
	"1-17-78" => "\xe7\x8c\xbf",
	"1-17-79" => "\xe7\xb8\x81",
	"1-17-80" => "\xe8\x89\xb6",
	"1-17-81" => "\xe8\x8b\x91",
	"1-17-82" => "\xe8\x96\x97",
	"1-17-83" => "\xe9\x81\xa0",
	"1-17-84" => "\xe9\x89\x9b",
	"1-17-85" => "\xe9\xb4\x9b",
	"1-17-86" => "\xe5\xa1\xa9",
	"1-17-87" => "\xe6\x96\xbc",
	"1-17-88" => "\xe6\xb1\x9a",
	"1-17-89" => "\xe7\x94\xa5",
	"1-17-90" => "\xe5\x87\xb9",
	"1-17-91" => "\xe5\xa4\xae",
	"1-17-92" => "\xe5\xa5\xa5",
	"1-17-93" => "\xe5\xbe\x80",
	"1-17-94" => "\xe5\xbf\x9c",
	"1-18-1" => "\xe6\x8a\xbc",
	"1-18-2" => "\xe6\x97\xba",
	"1-18-3" => "\xe6\xa8\xaa",
	"1-18-4" => "\xe6\xac\xa7",
	"1-18-5" => "\xe6\xae\xb4",
	"1-18-6" => "\xe7\x8e\x8b",
	"1-18-7" => "\xe7\xbf\x81",
	"1-18-8" => "\xe8\xa5\x96",
	"1-18-9" => "\xe9\xb4\xac",
	"1-18-10" => "\xe9\xb4\x8e",
	"1-18-11" => "\xe9\xbb\x84",
	"1-18-12" => "\xe5\xb2\xa1",
	"1-18-13" => "\xe6\xb2\x96",
	"1-18-14" => "\xe8\x8d\xbb",
	"1-18-15" => "\xe5\x84\x84",
	"1-18-16" => "\xe5\xb1\x8b",
	"1-18-17" => "\xe6\x86\xb6",
	"1-18-18" => "\xe8\x87\x86",
	"1-18-19" => "\xe6\xa1\xb6",
	"1-18-20" => "\xe7\x89\xa1",
	"1-18-21" => "\xe4\xb9\x99",
	"1-18-22" => "\xe4\xbf\xba",
	"1-18-23" => "\xe5\x8d\xb8",
	"1-18-24" => "\xe6\x81\xa9",
	"1-18-25" => "\xe6\xb8\xa9",
	"1-18-26" => "\xe7\xa9\x8f",
	"1-18-27" => "\xe9\x9f\xb3",
	"1-18-28" => "\xe4\xb8\x8b",
	"1-18-29" => "\xe5\x8c\x96",
	"1-18-30" => "\xe4\xbb\xae",
	"1-18-31" => "\xe4\xbd\x95",
	"1-18-32" => "\xe4\xbc\xbd",
	"1-18-33" => "\xe4\xbe\xa1",
	"1-18-34" => "\xe4\xbd\xb3",
	"1-18-35" => "\xe5\x8a\xa0",
	"1-18-36" => "\xe5\x8f\xaf",
	"1-18-37" => "\xe5\x98\x89",
	"1-18-38" => "\xe5\xa4\x8f",
	"1-18-39" => "\xe5\xab\x81",
	"1-18-40" => "\xe5\xae\xb6",
	"1-18-41" => "\xe5\xaf\xa1",
	"1-18-42" => "\xe7\xa7\x91",
	"1-18-43" => "\xe6\x9a\x87",
	"1-18-44" => "\xe6\x9e\x9c",
	"1-18-45" => "\xe6\x9e\xb6",
	"1-18-46" => "\xe6\xad\x8c",
	"1-18-47" => "\xe6\xb2\xb3",
	"1-18-48" => "\xe7\x81\xab",
	"1-18-49" => "\xe7\x8f\x82",
	"1-18-50" => "\xe7\xa6\x8d",
	"1-18-51" => "\xe7\xa6\xbe",
	"1-18-52" => "\xe7\xa8\xbc",
	"1-18-53" => "\xe7\xae\x87",
	"1-18-54" => "\xe8\x8a\xb1",
	"1-18-55" => "\xe8\x8b\x9b",
	"1-18-56" => "\xe8\x8c\x84",
	"1-18-57" => "\xe8\x8d\xb7",
	"1-18-58" => "\xe8\x8f\xaf",
	"1-18-59" => "\xe8\x8f\x93",
	"1-18-60" => "\xe8\x9d\xa6",
	"1-18-61" => "\xe8\xaa\xb2",
	"1-18-62" => "\xe5\x98\xa9",
	"1-18-63" => "\xe8\xb2\xa8",
	"1-18-64" => "\xe8\xbf\xa6",
	"1-18-65" => "\xe9\x81\x8e",
	"1-18-66" => "\xe9\x9c\x9e",
	"1-18-67" => "\xe8\x9a\x8a",
	"1-18-68" => "\xe4\xbf\x84",
	"1-18-69" => "\xe5\xb3\xa8",
	"1-18-70" => "\xe6\x88\x91",
	"1-18-71" => "\xe7\x89\x99",
	"1-18-72" => "\xe7\x94\xbb",
	"1-18-73" => "\xe8\x87\xa5",
	"1-18-74" => "\xe8\x8a\xbd",
	"1-18-75" => "\xe8\x9b\xbe",
	"1-18-76" => "\xe8\xb3\x80",
	"1-18-77" => "\xe9\x9b\x85",
	"1-18-78" => "\xe9\xa4\x93",
	"1-18-79" => "\xe9\xa7\x95",
	"1-18-80" => "\xe4\xbb\x8b",
	"1-18-81" => "\xe4\xbc\x9a",
	"1-18-82" => "\xe8\xa7\xa3",
	"1-18-83" => "\xe5\x9b\x9e",
	"1-18-84" => "\xe5\xa1\x8a",
	"1-18-85" => "\xe5\xa3\x8a",
	"1-18-86" => "\xe5\xbb\xbb",
	"1-18-87" => "\xe5\xbf\xab",
	"1-18-88" => "\xe6\x80\xaa",
	"1-18-89" => "\xe6\x82\x94",
	"1-18-90" => "\xe6\x81\xa2",
	"1-18-91" => "\xe6\x87\x90",
	"1-18-92" => "\xe6\x88\x92",
	"1-18-93" => "\xe6\x8b\x90",
	"1-18-94" => "\xe6\x94\xb9",
	"1-19-1" => "\xe9\xad\x81",
	"1-19-2" => "\xe6\x99\xa6",
	"1-19-3" => "\xe6\xa2\xb0",
	"1-19-4" => "\xe6\xb5\xb7",
	"1-19-5" => "\xe7\x81\xb0",
	"1-19-6" => "\xe7\x95\x8c",
	"1-19-7" => "\xe7\x9a\x86",
	"1-19-8" => "\xe7\xb5\xb5",
	"1-19-9" => "\xe8\x8a\xa5",
	"1-19-10" => "\xe8\x9f\xb9",
	"1-19-11" => "\xe9\x96\x8b",
	"1-19-12" => "\xe9\x9a\x8e",
	"1-19-13" => "\xe8\xb2\x9d",
	"1-19-14" => "\xe5\x87\xb1",
	"1-19-15" => "\xe5\x8a\xbe",
	"1-19-16" => "\xe5\xa4\x96",
	"1-19-17" => "\xe5\x92\xb3",
	"1-19-18" => "\xe5\xae\xb3",
	"1-19-19" => "\xe5\xb4\x96",
	"1-19-20" => "\xe6\x85\xa8",
	"1-19-21" => "\xe6\xa6\x82",
	"1-19-22" => "\xe6\xb6\xaf",
	"1-19-23" => "\xe7\xa2\x8d",
	"1-19-24" => "\xe8\x93\x8b",
	"1-19-25" => "\xe8\xa1\x97",
	"1-19-26" => "\xe8\xa9\xb2",
	"1-19-27" => "\xe9\x8e\xa7",
	"1-19-28" => "\xe9\xaa\xb8",
	"1-19-29" => "\xe6\xb5\xac",
	"1-19-30" => "\xe9\xa6\xa8",
	"1-19-31" => "\xe8\x9b\x99",
	"1-19-32" => "\xe5\x9e\xa3",
	"1-19-33" => "\xe6\x9f\xbf",
	"1-19-34" => "\xe8\x9b\x8e",
	"1-19-35" => "\xe9\x88\x8e",
	"1-19-36" => "\xe5\x8a\x83",
	"1-19-37" => "\xe5\x9a\x87",
	"1-19-38" => "\xe5\x90\x84",
	"1-19-39" => "\xe5\xbb\x93",
	"1-19-40" => "\xe6\x8b\xa1",
	"1-19-41" => "\xe6\x92\xb9",
	"1-19-42" => "\xe6\xa0\xbc",
	"1-19-43" => "\xe6\xa0\xb8",
	"1-19-44" => "\xe6\xae\xbb",
	"1-19-45" => "\xe7\x8d\xb2",
	"1-19-46" => "\xe7\xa2\xba",
	"1-19-47" => "\xe7\xa9\xab",
	"1-19-48" => "\xe8\xa6\x9a",
	"1-19-49" => "\xe8\xa7\x92",
	"1-19-50" => "\xe8\xb5\xab",
	"1-19-51" => "\xe8\xbc\x83",
	"1-19-52" => "\xe9\x83\xad",
	"1-19-53" => "\xe9\x96\xa3",
	"1-19-54" => "\xe9\x9a\x94",
	"1-19-55" => "\xe9\x9d\xa9",
	"1-19-56" => "\xe5\xad\xa6",
	"1-19-57" => "\xe5\xb2\xb3",
	"1-19-58" => "\xe6\xa5\xbd",
	"1-19-59" => "\xe9\xa1\x8d",
	"1-19-60" => "\xe9\xa1\x8e",
	"1-19-61" => "\xe6\x8e\x9b",
	"1-19-62" => "\xe7\xac\xa0",
	"1-19-63" => "\xe6\xa8\xab",
	"1-19-64" => "\xe6\xa9\xbf",
	"1-19-65" => "\xe6\xa2\xb6",
	"1-19-66" => "\xe9\xb0\x8d",
	"1-19-67" => "\xe6\xbd\x9f",
	"1-19-68" => "\xe5\x89\xb2",
	"1-19-69" => "\xe5\x96\x9d",
	"1-19-70" => "\xe6\x81\xb0",
	"1-19-71" => "\xe6\x8b\xac",
	"1-19-72" => "\xe6\xb4\xbb",
	"1-19-73" => "\xe6\xb8\x87",
	"1-19-74" => "\xe6\xbb\x91",
	"1-19-75" => "\xe8\x91\x9b",
	"1-19-76" => "\xe8\xa4\x90",
	"1-19-77" => "\xe8\xbd\x84",
	"1-19-78" => "\xe4\xb8\x94",
	"1-19-79" => "\xe9\xb0\xb9",
	"1-19-80" => "\xe5\x8f\xb6",
	"1-19-81" => "\xe6\xa4\x9b",
	"1-19-82" => "\xe6\xa8\xba",
	"1-19-83" => "\xe9\x9e\x84",
	"1-19-84" => "\xe6\xa0\xaa",
	"1-19-85" => "\xe5\x85\x9c",
	"1-19-86" => "\xe7\xab\x83",
	"1-19-87" => "\xe8\x92\xb2",
	"1-19-88" => "\xe9\x87\x9c",
	"1-19-89" => "\xe9\x8e\x8c",
	"1-19-90" => "\xe5\x99\x9b",
	"1-19-91" => "\xe9\xb4\xa8",
	"1-19-92" => "\xe6\xa0\xa2",
	"1-19-93" => "\xe8\x8c\x85",
	"1-19-94" => "\xe8\x90\xb1",
	"1-20-1" => "\xe7\xb2\xa5",
	"1-20-2" => "\xe5\x88\x88",
	"1-20-3" => "\xe8\x8b\x85",
	"1-20-4" => "\xe7\x93\xa6",
	"1-20-5" => "\xe4\xb9\xbe",
	"1-20-6" => "\xe4\xbe\x83",
	"1-20-7" => "\xe5\x86\xa0",
	"1-20-8" => "\xe5\xaf\x92",
	"1-20-9" => "\xe5\x88\x8a",
	"1-20-10" => "\xe5\x8b\x98",
	"1-20-11" => "\xe5\x8b\xa7",
	"1-20-12" => "\xe5\xb7\xbb",
	"1-20-13" => "\xe5\x96\x9a",
	"1-20-14" => "\xe5\xa0\xaa",
	"1-20-15" => "\xe5\xa7\xa6",
	"1-20-16" => "\xe5\xae\x8c",
	"1-20-17" => "\xe5\xae\x98",
	"1-20-18" => "\xe5\xaf\x9b",
	"1-20-19" => "\xe5\xb9\xb2",
	"1-20-20" => "\xe5\xb9\xb9",
	"1-20-21" => "\xe6\x82\xa3",
	"1-20-22" => "\xe6\x84\x9f",
	"1-20-23" => "\xe6\x85\xa3",
	"1-20-24" => "\xe6\x86\xbe",
	"1-20-25" => "\xe6\x8f\x9b",
	"1-20-26" => "\xe6\x95\xa2",
	"1-20-27" => "\xe6\x9f\x91",
	"1-20-28" => "\xe6\xa1\x93",
	"1-20-29" => "\xe6\xa3\xba",
	"1-20-30" => "\xe6\xac\xbe",
	"1-20-31" => "\xe6\xad\x93",
	"1-20-32" => "\xe6\xb1\x97",
	"1-20-33" => "\xe6\xbc\xa2",
	"1-20-34" => "\xe6\xbe\x97",
	"1-20-35" => "\xe6\xbd\x85",
	"1-20-36" => "\xe7\x92\xb0",
	"1-20-37" => "\xe7\x94\x98",
	"1-20-38" => "\xe7\x9b\xa3",
	"1-20-39" => "\xe7\x9c\x8b",
	"1-20-40" => "\xe7\xab\xbf",
	"1-20-41" => "\xe7\xae\xa1",
	"1-20-42" => "\xe7\xb0\xa1",
	"1-20-43" => "\xe7\xb7\xa9",
	"1-20-44" => "\xe7\xbc\xb6",
	"1-20-45" => "\xe7\xbf\xb0",
	"1-20-46" => "\xe8\x82\x9d",
	"1-20-47" => "\xe8\x89\xa6",
	"1-20-48" => "\xe8\x8e\x9e",
	"1-20-49" => "\xe8\xa6\xb3",
	"1-20-50" => "\xe8\xab\x8c",
	"1-20-51" => "\xe8\xb2\xab",
	"1-20-52" => "\xe9\x82\x84",
	"1-20-53" => "\xe9\x91\x91",
	"1-20-54" => "\xe9\x96\x93",
	"1-20-55" => "\xe9\x96\x91",
	"1-20-56" => "\xe9\x96\xa2",
	"1-20-57" => "\xe9\x99\xa5",
	"1-20-58" => "\xe9\x9f\x93",
	"1-20-59" => "\xe9\xa4\xa8",
	"1-20-60" => "\xe8\x88\x98",
	"1-20-61" => "\xe4\xb8\xb8",
	"1-20-62" => "\xe5\x90\xab",
	"1-20-63" => "\xe5\xb2\xb8",
	"1-20-64" => "\xe5\xb7\x8c",
	"1-20-65" => "\xe7\x8e\xa9",
	"1-20-66" => "\xe7\x99\x8c",
	"1-20-67" => "\xe7\x9c\xbc",
	"1-20-68" => "\xe5\xb2\xa9",
	"1-20-69" => "\xe7\xbf\xab",
	"1-20-70" => "\xe8\xb4\x8b",
	"1-20-71" => "\xe9\x9b\x81",
	"1-20-72" => "\xe9\xa0\x91",
	"1-20-73" => "\xe9\xa1\x94",
	"1-20-74" => "\xe9\xa1\x98",
	"1-20-75" => "\xe4\xbc\x81",
	"1-20-76" => "\xe4\xbc\x8e",
	"1-20-77" => "\xe5\x8d\xb1",
	"1-20-78" => "\xe5\x96\x9c",
	"1-20-79" => "\xe5\x99\xa8",
	"1-20-80" => "\xe5\x9f\xba",
	"1-20-81" => "\xe5\xa5\x87",
	"1-20-82" => "\xe5\xac\x89",
	"1-20-83" => "\xe5\xaf\x84",
	"1-20-84" => "\xe5\xb2\x90",
	"1-20-85" => "\xe5\xb8\x8c",
	"1-20-86" => "\xe5\xb9\xbe",
	"1-20-87" => "\xe5\xbf\x8c",
	"1-20-88" => "\xe6\x8f\xae",
	"1-20-89" => "\xe6\x9c\xba",
	"1-20-90" => "\xe6\x97\x97",
	"1-20-91" => "\xe6\x97\xa2",
	"1-20-92" => "\xe6\x9c\x9f",
	"1-20-93" => "\xe6\xa3\x8b",
	"1-20-94" => "\xe6\xa3\x84",
	"1-21-1" => "\xe6\xa9\x9f",
	"1-21-2" => "\xe5\xb8\xb0",
	"1-21-3" => "\xe6\xaf\x85",
	"1-21-4" => "\xe6\xb0\x97",
	"1-21-5" => "\xe6\xb1\xbd",
	"1-21-6" => "\xe7\x95\xbf",
	"1-21-7" => "\xe7\xa5\x88",
	"1-21-8" => "\xe5\xad\xa3",
	"1-21-9" => "\xe7\xa8\x80",
	"1-21-10" => "\xe7\xb4\x80",
	"1-21-11" => "\xe5\xbe\xbd",
	"1-21-12" => "\xe8\xa6\x8f",
	"1-21-13" => "\xe8\xa8\x98",
	"1-21-14" => "\xe8\xb2\xb4",
	"1-21-15" => "\xe8\xb5\xb7",
	"1-21-16" => "\xe8\xbb\x8c",
	"1-21-17" => "\xe8\xbc\x9d",
	"1-21-18" => "\xe9\xa3\xa2",
	"1-21-19" => "\xe9\xa8\x8e",
	"1-21-20" => "\xe9\xac\xbc",
	"1-21-21" => "\xe4\xba\x80",
	"1-21-22" => "\xe5\x81\xbd",
	"1-21-23" => "\xe5\x84\x80",
	"1-21-24" => "\xe5\xa6\x93",
	"1-21-25" => "\xe5\xae\x9c",
	"1-21-26" => "\xe6\x88\xaf",
	"1-21-27" => "\xe6\x8a\x80",
	"1-21-28" => "\xe6\x93\xac",
	"1-21-29" => "\xe6\xac\xba",
	"1-21-30" => "\xe7\x8a\xa0",
	"1-21-31" => "\xe7\x96\x91",
	"1-21-32" => "\xe7\xa5\x87",
	"1-21-33" => "\xe7\xbe\xa9",
	"1-21-34" => "\xe8\x9f\xbb",
	"1-21-35" => "\xe8\xaa\xbc",
	"1-21-36" => "\xe8\xad\xb0",
	"1-21-37" => "\xe6\x8e\xac",
	"1-21-38" => "\xe8\x8f\x8a",
	"1-21-39" => "\xe9\x9e\xa0",
	"1-21-40" => "\xe5\x90\x89",
	"1-21-41" => "\xe5\x90\x83",
	"1-21-42" => "\xe5\x96\xab",
	"1-21-43" => "\xe6\xa1\x94",
	"1-21-44" => "\xe6\xa9\x98",
	"1-21-45" => "\xe8\xa9\xb0",
	"1-21-46" => "\xe7\xa0\xa7",
	"1-21-47" => "\xe6\x9d\xb5",
	"1-21-48" => "\xe9\xbb\x8d",
	"1-21-49" => "\xe5\x8d\xb4",
	"1-21-50" => "\xe5\xae\xa2",
	"1-21-51" => "\xe8\x84\x9a",
	"1-21-52" => "\xe8\x99\x90",
	"1-21-53" => "\xe9\x80\x86",
	"1-21-54" => "\xe4\xb8\x98",
	"1-21-55" => "\xe4\xb9\x85",
	"1-21-56" => "\xe4\xbb\x87",
	"1-21-57" => "\xe4\xbc\x91",
	"1-21-58" => "\xe5\x8f\x8a",
	"1-21-59" => "\xe5\x90\xb8",
	"1-21-60" => "\xe5\xae\xae",
	"1-21-61" => "\xe5\xbc\x93",
	"1-21-62" => "\xe6\x80\xa5",
	"1-21-63" => "\xe6\x95\x91",
	"1-21-64" => "\xe6\x9c\xbd",
	"1-21-65" => "\xe6\xb1\x82",
	"1-21-66" => "\xe6\xb1\xb2",
	"1-21-67" => "\xe6\xb3\xa3",
	"1-21-68" => "\xe7\x81\xb8",
	"1-21-69" => "\xe7\x90\x83",
	"1-21-70" => "\xe7\xa9\xb6",
	"1-21-71" => "\xe7\xaa\xae",
	"1-21-72" => "\xe7\xac\x88",
	"1-21-73" => "\xe7\xb4\x9a",
	"1-21-74" => "\xe7\xb3\xbe",
	"1-21-75" => "\xe7\xb5\xa6",
	"1-21-76" => "\xe6\x97\xa7",
	"1-21-77" => "\xe7\x89\x9b",
	"1-21-78" => "\xe5\x8e\xbb",
	"1-21-79" => "\xe5\xb1\x85",
	"1-21-80" => "\xe5\xb7\xa8",
	"1-21-81" => "\xe6\x8b\x92",
	"1-21-82" => "\xe6\x8b\xa0",
	"1-21-83" => "\xe6\x8c\x99",
	"1-21-84" => "\xe6\xb8\xa0",
	"1-21-85" => "\xe8\x99\x9a",
	"1-21-86" => "\xe8\xa8\xb1",
	"1-21-87" => "\xe8\xb7\x9d",
	"1-21-88" => "\xe9\x8b\xb8",
	"1-21-89" => "\xe6\xbc\x81",
	"1-21-90" => "\xe7\xa6\xa6",
	"1-21-91" => "\xe9\xad\x9a",
	"1-21-92" => "\xe4\xba\xa8",
	"1-21-93" => "\xe4\xba\xab",
	"1-21-94" => "\xe4\xba\xac",
	"1-22-1" => "\xe4\xbe\x9b",
	"1-22-2" => "\xe4\xbe\xa0",
	"1-22-3" => "\xe5\x83\x91",
	"1-22-4" => "\xe5\x85\x87",
	"1-22-5" => "\xe7\xab\xb6",
	"1-22-6" => "\xe5\x85\xb1",
	"1-22-7" => "\xe5\x87\xb6",
	"1-22-8" => "\xe5\x8d\x94",
	"1-22-9" => "\xe5\x8c\xa1",
	"1-22-10" => "\xe5\x8d\xbf",
	"1-22-11" => "\xe5\x8f\xab",
	"1-22-12" => "\xe5\x96\xac",
	"1-22-13" => "\xe5\xa2\x83",
	"1-22-14" => "\xe5\xb3\xa1",
	"1-22-15" => "\xe5\xbc\xb7",
	"1-22-16" => "\xe5\xbd\x8a",
	"1-22-17" => "\xe6\x80\xaf",
	"1-22-18" => "\xe6\x81\x90",
	"1-22-19" => "\xe6\x81\xad",
	"1-22-20" => "\xe6\x8c\x9f",
	"1-22-21" => "\xe6\x95\x99",
	"1-22-22" => "\xe6\xa9\x8b",
	"1-22-23" => "\xe6\xb3\x81",
	"1-22-24" => "\xe7\x8b\x82",
	"1-22-25" => "\xe7\x8b\xad",
	"1-22-26" => "\xe7\x9f\xaf",
	"1-22-27" => "\xe8\x83\xb8",
	"1-22-28" => "\xe8\x84\x85",
	"1-22-29" => "\xe8\x88\x88",
	"1-22-30" => "\xe8\x95\x8e",
	"1-22-31" => "\xe9\x83\xb7",
	"1-22-32" => "\xe9\x8f\xa1",
	"1-22-33" => "\xe9\x9f\xbf",
	"1-22-34" => "\xe9\xa5\x97",
	"1-22-35" => "\xe9\xa9\x9a",
	"1-22-36" => "\xe4\xbb\xb0",
	"1-22-37" => "\xe5\x87\x9d",
	"1-22-38" => "\xe5\xb0\xad",
	"1-22-39" => "\xe6\x9a\x81",
	"1-22-40" => "\xe6\xa5\xad",
	"1-22-41" => "\xe5\xb1\x80",
	"1-22-42" => "\xe6\x9b\xb2",
	"1-22-43" => "\xe6\xa5\xb5",
	"1-22-44" => "\xe7\x8e\x89",
	"1-22-45" => "\xe6\xa1\x90",
	"1-22-46" => "\xe7\xb2\x81",
	"1-22-47" => "\xe5\x83\x85",
	"1-22-48" => "\xe5\x8b\xa4",
	"1-22-49" => "\xe5\x9d\x87",
	"1-22-50" => "\xe5\xb7\xbe",
	"1-22-51" => "\xe9\x8c\xa6",
	"1-22-52" => "\xe6\x96\xa4",
	"1-22-53" => "\xe6\xac\xa3",
	"1-22-54" => "\xe6\xac\xbd",
	"1-22-55" => "\xe7\x90\xb4",
	"1-22-56" => "\xe7\xa6\x81",
	"1-22-57" => "\xe7\xa6\xbd",
	"1-22-58" => "\xe7\xad\x8b",
	"1-22-59" => "\xe7\xb7\x8a",
	"1-22-60" => "\xe8\x8a\xb9",
	"1-22-61" => "\xe8\x8f\x8c",
	"1-22-62" => "\xe8\xa1\xbf",
	"1-22-63" => "\xe8\xa5\x9f",
	"1-22-64" => "\xe8\xac\xb9",
	"1-22-65" => "\xe8\xbf\x91",
	"1-22-66" => "\xe9\x87\x91",
	"1-22-67" => "\xe5\x90\x9f",
	"1-22-68" => "\xe9\x8a\x80",
	"1-22-69" => "\xe4\xb9\x9d",
	"1-22-70" => "\xe5\x80\xb6",
	"1-22-71" => "\xe5\x8f\xa5",
	"1-22-72" => "\xe5\x8c\xba",
	"1-22-73" => "\xe7\x8b\x97",
	"1-22-74" => "\xe7\x8e\x96",
	"1-22-75" => "\xe7\x9f\xa9",
	"1-22-76" => "\xe8\x8b\xa6",
	"1-22-77" => "\xe8\xba\xaf",
	"1-22-78" => "\xe9\xa7\x86",
	"1-22-79" => "\xe9\xa7\x88",
	"1-22-80" => "\xe9\xa7\x92",
	"1-22-81" => "\xe5\x85\xb7",
	"1-22-82" => "\xe6\x84\x9a",
	"1-22-83" => "\xe8\x99\x9e",
	"1-22-84" => "\xe5\x96\xb0",
	"1-22-85" => "\xe7\xa9\xba",
	"1-22-86" => "\xe5\x81\xb6",
	"1-22-87" => "\xe5\xaf\x93",
	"1-22-88" => "\xe9\x81\x87",
	"1-22-89" => "\xe9\x9a\x85",
	"1-22-90" => "\xe4\xb8\xb2",
	"1-22-91" => "\xe6\xab\x9b",
	"1-22-92" => "\xe9\x87\xa7",
	"1-22-93" => "\xe5\xb1\x91",
	"1-22-94" => "\xe5\xb1\x88",
	"1-23-1" => "\xe6\x8e\x98",
	"1-23-2" => "\xe7\xaa\x9f",
	"1-23-3" => "\xe6\xb2\x93",
	"1-23-4" => "\xe9\x9d\xb4",
	"1-23-5" => "\xe8\xbd\xa1",
	"1-23-6" => "\xe7\xaa\xaa",
	"1-23-7" => "\xe7\x86\x8a",
	"1-23-8" => "\xe9\x9a\x88",
	"1-23-9" => "\xe7\xb2\x82",
	"1-23-10" => "\xe6\xa0\x97",
	"1-23-11" => "\xe7\xb9\xb0",
	"1-23-12" => "\xe6\xa1\x91",
	"1-23-13" => "\xe9\x8d\xac",
	"1-23-14" => "\xe5\x8b\xb2",
	"1-23-15" => "\xe5\x90\x9b",
	"1-23-16" => "\xe8\x96\xab",
	"1-23-17" => "\xe8\xa8\x93",
	"1-23-18" => "\xe7\xbe\xa4",
	"1-23-19" => "\xe8\xbb\x8d",
	"1-23-20" => "\xe9\x83\xa1",
	"1-23-21" => "\xe5\x8d\xa6",
	"1-23-22" => "\xe8\xa2\x88",
	"1-23-23" => "\xe7\xa5\x81",
	"1-23-24" => "\xe4\xbf\x82",
	"1-23-25" => "\xe5\x82\xbe",
	"1-23-26" => "\xe5\x88\x91",
	"1-23-27" => "\xe5\x85\x84",
	"1-23-28" => "\xe5\x95\x93",
	"1-23-29" => "\xe5\x9c\xad",
	"1-23-30" => "\xe7\x8f\xaa",
	"1-23-31" => "\xe5\x9e\x8b",
	"1-23-32" => "\xe5\xa5\x91",
	"1-23-33" => "\xe5\xbd\xa2",
	"1-23-34" => "\xe5\xbe\x84",
	"1-23-35" => "\xe6\x81\xb5",
	"1-23-36" => "\xe6\x85\xb6",
	"1-23-37" => "\xe6\x85\xa7",
	"1-23-38" => "\xe6\x86\xa9",
	"1-23-39" => "\xe6\x8e\xb2",
	"1-23-40" => "\xe6\x90\xba",
	"1-23-41" => "\xe6\x95\xac",
	"1-23-42" => "\xe6\x99\xaf",
	"1-23-43" => "\xe6\xa1\x82",
	"1-23-44" => "\xe6\xb8\x93",
	"1-23-45" => "\xe7\x95\xa6",
	"1-23-46" => "\xe7\xa8\xbd",
	"1-23-47" => "\xe7\xb3\xbb",
	"1-23-48" => "\xe7\xb5\x8c",
	"1-23-49" => "\xe7\xb6\x99",
	"1-23-50" => "\xe7\xb9\x8b",
	"1-23-51" => "\xe7\xbd\xab",
	"1-23-52" => "\xe8\x8c\x8e",
	"1-23-53" => "\xe8\x8d\x8a",
	"1-23-54" => "\xe8\x9b\x8d",
	"1-23-55" => "\xe8\xa8\x88",
	"1-23-56" => "\xe8\xa9\xa3",
	"1-23-57" => "\xe8\xad\xa6",
	"1-23-58" => "\xe8\xbb\xbd",
	"1-23-59" => "\xe9\xa0\x9a",
	"1-23-60" => "\xe9\xb6\x8f",
	"1-23-61" => "\xe8\x8a\xb8",
	"1-23-62" => "\xe8\xbf\x8e",
	"1-23-63" => "\xe9\xaf\xa8",
	"1-23-64" => "\xe5\x8a\x87",
	"1-23-65" => "\xe6\x88\x9f",
	"1-23-66" => "\xe6\x92\x83",
	"1-23-67" => "\xe6\xbf\x80",
	"1-23-68" => "\xe9\x9a\x99",
	"1-23-69" => "\xe6\xa1\x81",
	"1-23-70" => "\xe5\x82\x91",
	"1-23-71" => "\xe6\xac\xa0",
	"1-23-72" => "\xe6\xb1\xba",
	"1-23-73" => "\xe6\xbd\x94",
	"1-23-74" => "\xe7\xa9\xb4",
	"1-23-75" => "\xe7\xb5\x90",
	"1-23-76" => "\xe8\xa1\x80",
	"1-23-77" => "\xe8\xa8\xa3",
	"1-23-78" => "\xe6\x9c\x88",
	"1-23-79" => "\xe4\xbb\xb6",
	"1-23-80" => "\xe5\x80\xb9",
	"1-23-81" => "\xe5\x80\xa6",
	"1-23-82" => "\xe5\x81\xa5",
	"1-23-83" => "\xe5\x85\xbc",
	"1-23-84" => "\xe5\x88\xb8",
	"1-23-85" => "\xe5\x89\xa3",
	"1-23-86" => "\xe5\x96\xa7",
	"1-23-87" => "\xe5\x9c\x8f",
	"1-23-88" => "\xe5\xa0\x85",
	"1-23-89" => "\xe5\xab\x8c",
	"1-23-90" => "\xe5\xbb\xba",
	"1-23-91" => "\xe6\x86\xb2",
	"1-23-92" => "\xe6\x87\xb8",
	"1-23-93" => "\xe6\x8b\xb3",
	"1-23-94" => "\xe6\x8d\xb2",
	"1-24-1" => "\xe6\xa4\x9c",
	"1-24-2" => "\xe6\xa8\xa9",
	"1-24-3" => "\xe7\x89\xbd",
	"1-24-4" => "\xe7\x8a\xac",
	"1-24-5" => "\xe7\x8c\xae",
	"1-24-6" => "\xe7\xa0\x94",
	"1-24-7" => "\xe7\xa1\xaf",
	"1-24-8" => "\xe7\xb5\xb9",
	"1-24-9" => "\xe7\x9c\x8c",
	"1-24-10" => "\xe8\x82\xa9",
	"1-24-11" => "\xe8\xa6\x8b",
	"1-24-12" => "\xe8\xac\x99",
	"1-24-13" => "\xe8\xb3\xa2",
	"1-24-14" => "\xe8\xbb\x92",
	"1-24-15" => "\xe9\x81\xa3",
	"1-24-16" => "\xe9\x8d\xb5",
	"1-24-17" => "\xe9\x99\xba",
	"1-24-18" => "\xe9\xa1\x95",
	"1-24-19" => "\xe9\xa8\x93",
	"1-24-20" => "\xe9\xb9\xb8",
	"1-24-21" => "\xe5\x85\x83",
	"1-24-22" => "\xe5\x8e\x9f",
	"1-24-23" => "\xe5\x8e\xb3",
	"1-24-24" => "\xe5\xb9\xbb",
	"1-24-25" => "\xe5\xbc\xa6",
	"1-24-26" => "\xe6\xb8\x9b",
	"1-24-27" => "\xe6\xba\x90",
	"1-24-28" => "\xe7\x8e\x84",
	"1-24-29" => "\xe7\x8f\xbe",
	"1-24-30" => "\xe7\xb5\x83",
	"1-24-31" => "\xe8\x88\xb7",
	"1-24-32" => "\xe8\xa8\x80",
	"1-24-33" => "\xe8\xab\xba",
	"1-24-34" => "\xe9\x99\x90",
	"1-24-35" => "\xe4\xb9\x8e",
	"1-24-36" => "\xe5\x80\x8b",
	"1-24-37" => "\xe5\x8f\xa4",
	"1-24-38" => "\xe5\x91\xbc",
	"1-24-39" => "\xe5\x9b\xba",
	"1-24-40" => "\xe5\xa7\x91",
	"1-24-41" => "\xe5\xad\xa4",
	"1-24-42" => "\xe5\xb7\xb1",
	"1-24-43" => "\xe5\xba\xab",
	"1-24-44" => "\xe5\xbc\xa7",
	"1-24-45" => "\xe6\x88\xb8",
	"1-24-46" => "\xe6\x95\x85",
	"1-24-47" => "\xe6\x9e\xaf",
	"1-24-48" => "\xe6\xb9\x96",
	"1-24-49" => "\xe7\x8b\x90",
	"1-24-50" => "\xe7\xb3\x8a",
	"1-24-51" => "\xe8\xa2\xb4",
	"1-24-52" => "\xe8\x82\xa1",
	"1-24-53" => "\xe8\x83\xa1",
	"1-24-54" => "\xe8\x8f\xb0",
	"1-24-55" => "\xe8\x99\x8e",
	"1-24-56" => "\xe8\xaa\x87",
	"1-24-57" => "\xe8\xb7\xa8",
	"1-24-58" => "\xe9\x88\xb7",
	"1-24-59" => "\xe9\x9b\x87",
	"1-24-60" => "\xe9\xa1\xa7",
	"1-24-61" => "\xe9\xbc\x93",
	"1-24-62" => "\xe4\xba\x94",
	"1-24-63" => "\xe4\xba\x92",
	"1-24-64" => "\xe4\xbc\x8d",
	"1-24-65" => "\xe5\x8d\x88",
	"1-24-66" => "\xe5\x91\x89",
	"1-24-67" => "\xe5\x90\xbe",
	"1-24-68" => "\xe5\xa8\xaf",
	"1-24-69" => "\xe5\xbe\x8c",
	"1-24-70" => "\xe5\xbe\xa1",
	"1-24-71" => "\xe6\x82\x9f",
	"1-24-72" => "\xe6\xa2\xa7",
	"1-24-73" => "\xe6\xaa\x8e",
	"1-24-74" => "\xe7\x91\x9a",
	"1-24-75" => "\xe7\xa2\x81",
	"1-24-76" => "\xe8\xaa\x9e",
	"1-24-77" => "\xe8\xaa\xa4",
	"1-24-78" => "\xe8\xad\xb7",
	"1-24-79" => "\xe9\x86\x90",
	"1-24-80" => "\xe4\xb9\x9e",
	"1-24-81" => "\xe9\xaf\x89",
	"1-24-82" => "\xe4\xba\xa4",
	"1-24-83" => "\xe4\xbd\xbc",
	"1-24-84" => "\xe4\xbe\xaf",
	"1-24-85" => "\xe5\x80\x99",
	"1-24-86" => "\xe5\x80\x96",
	"1-24-87" => "\xe5\x85\x89",
	"1-24-88" => "\xe5\x85\xac",
	"1-24-89" => "\xe5\x8a\x9f",
	"1-24-90" => "\xe5\x8a\xb9",
	"1-24-91" => "\xe5\x8b\xbe",
	"1-24-92" => "\xe5\x8e\x9a",
	"1-24-93" => "\xe5\x8f\xa3",
	"1-24-94" => "\xe5\x90\x91",
	"1-25-1" => "\xe5\x90\x8e",
	"1-25-2" => "\xe5\x96\x89",
	"1-25-3" => "\xe5\x9d\x91",
	"1-25-4" => "\xe5\x9e\xa2",
	"1-25-5" => "\xe5\xa5\xbd",
	"1-25-6" => "\xe5\xad\x94",
	"1-25-7" => "\xe5\xad\x9d",
	"1-25-8" => "\xe5\xae\x8f",
	"1-25-9" => "\xe5\xb7\xa5",
	"1-25-10" => "\xe5\xb7\xa7",
	"1-25-11" => "\xe5\xb7\xb7",
	"1-25-12" => "\xe5\xb9\xb8",
	"1-25-13" => "\xe5\xba\x83",
	"1-25-14" => "\xe5\xba\x9a",
	"1-25-15" => "\xe5\xba\xb7",
	"1-25-16" => "\xe5\xbc\x98",
	"1-25-17" => "\xe6\x81\x92",
	"1-25-18" => "\xe6\x85\x8c",
	"1-25-19" => "\xe6\x8a\x97",
	"1-25-20" => "\xe6\x8b\x98",
	"1-25-21" => "\xe6\x8e\xa7",
	"1-25-22" => "\xe6\x94\xbb",
	"1-25-23" => "\xe6\x98\x82",
	"1-25-24" => "\xe6\x99\x83",
	"1-25-25" => "\xe6\x9b\xb4",
	"1-25-26" => "\xe6\x9d\xad",
	"1-25-27" => "\xe6\xa0\xa1",
	"1-25-28" => "\xe6\xa2\x97",
	"1-25-29" => "\xe6\xa7\x8b",
	"1-25-30" => "\xe6\xb1\x9f",
	"1-25-31" => "\xe6\xb4\xaa",
	"1-25-32" => "\xe6\xb5\xa9",
	"1-25-33" => "\xe6\xb8\xaf",
	"1-25-34" => "\xe6\xba\x9d",
	"1-25-35" => "\xe7\x94\xb2",
	"1-25-36" => "\xe7\x9a\x87",
	"1-25-37" => "\xe7\xa1\xac",
	"1-25-38" => "\xe7\xa8\xbf",
	"1-25-39" => "\xe7\xb3\xa0",
	"1-25-40" => "\xe7\xb4\x85",
	"1-25-41" => "\xe7\xb4\x98",
	"1-25-42" => "\xe7\xb5\x9e",
	"1-25-43" => "\xe7\xb6\xb1",
	"1-25-44" => "\xe8\x80\x95",
	"1-25-45" => "\xe8\x80\x83",
	"1-25-46" => "\xe8\x82\xaf",
	"1-25-47" => "\xe8\x82\xb1",
	"1-25-48" => "\xe8\x85\x94",
	"1-25-49" => "\xe8\x86\x8f",
	"1-25-50" => "\xe8\x88\xaa",
	"1-25-51" => "\xe8\x8d\x92",
	"1-25-52" => "\xe8\xa1\x8c",
	"1-25-53" => "\xe8\xa1\xa1",
	"1-25-54" => "\xe8\xac\x9b",
	"1-25-55" => "\xe8\xb2\xa2",
	"1-25-56" => "\xe8\xb3\xbc",
	"1-25-57" => "\xe9\x83\x8a",
	"1-25-58" => "\xe9\x85\xb5",
	"1-25-59" => "\xe9\x89\xb1",
	"1-25-60" => "\xe7\xa0\xbf",
	"1-25-61" => "\xe9\x8b\xbc",
	"1-25-62" => "\xe9\x96\xa4",
	"1-25-63" => "\xe9\x99\x8d",
	"1-25-64" => "\xe9\xa0\x85",
	"1-25-65" => "\xe9\xa6\x99",
	"1-25-66" => "\xe9\xab\x98",
	"1-25-67" => "\xe9\xb4\xbb",
	"1-25-68" => "\xe5\x89\x9b",
	"1-25-69" => "\xe5\x8a\xab",
	"1-25-70" => "\xe5\x8f\xb7",
	"1-25-71" => "\xe5\x90\x88",
	"1-25-72" => "\xe5\xa3\x95",
	"1-25-73" => "\xe6\x8b\xb7",
	"1-25-74" => "\xe6\xbf\xa0",
	"1-25-75" => "\xe8\xb1\xaa",
	"1-25-76" => "\xe8\xbd\x9f",
	"1-25-77" => "\xe9\xba\xb9",
	"1-25-78" => "\xe5\x85\x8b",
	"1-25-79" => "\xe5\x88\xbb",
	"1-25-80" => "\xe5\x91\x8a",
	"1-25-81" => "\xe5\x9b\xbd",
	"1-25-82" => "\xe7\xa9\x80",
	"1-25-83" => "\xe9\x85\xb7",
	"1-25-84" => "\xe9\xb5\xa0",
	"1-25-85" => "\xe9\xbb\x92",
	"1-25-86" => "\xe7\x8d\x84",
	"1-25-87" => "\xe6\xbc\x89",
	"1-25-88" => "\xe8\x85\xb0",
	"1-25-89" => "\xe7\x94\x91",
	"1-25-90" => "\xe5\xbf\xbd",
	"1-25-91" => "\xe6\x83\x9a",
	"1-25-92" => "\xe9\xaa\xa8",
	"1-25-93" => "\xe7\x8b\x9b",
	"1-25-94" => "\xe8\xbe\xbc",
	"1-26-1" => "\xe6\xad\xa4",
	"1-26-2" => "\xe9\xa0\x83",
	"1-26-3" => "\xe4\xbb\x8a",
	"1-26-4" => "\xe5\x9b\xb0",
	"1-26-5" => "\xe5\x9d\xa4",
	"1-26-6" => "\xe5\xa2\xbe",
	"1-26-7" => "\xe5\xa9\x9a",
	"1-26-8" => "\xe6\x81\xa8",
	"1-26-9" => "\xe6\x87\x87",
	"1-26-10" => "\xe6\x98\x8f",
	"1-26-11" => "\xe6\x98\x86",
	"1-26-12" => "\xe6\xa0\xb9",
	"1-26-13" => "\xe6\xa2\xb1",
	"1-26-14" => "\xe6\xb7\xb7",
	"1-26-15" => "\xe7\x97\x95",
	"1-26-16" => "\xe7\xb4\xba",
	"1-26-17" => "\xe8\x89\xae",
	"1-26-18" => "\xe9\xad\x82",
	"1-26-19" => "\xe4\xba\x9b",
	"1-26-20" => "\xe4\xbd\x90",
	"1-26-21" => "\xe5\x8f\x89",
	"1-26-22" => "\xe5\x94\x86",
	"1-26-23" => "\xe5\xb5\xaf",
	"1-26-24" => "\xe5\xb7\xa6",
	"1-26-25" => "\xe5\xb7\xae",
	"1-26-26" => "\xe6\x9f\xbb",
	"1-26-27" => "\xe6\xb2\x99",
	"1-26-28" => "\xe7\x91\xb3",
	"1-26-29" => "\xe7\xa0\x82",
	"1-26-30" => "\xe8\xa9\x90",
	"1-26-31" => "\xe9\x8e\x96",
	"1-26-32" => "\xe8\xa3\x9f",
	"1-26-33" => "\xe5\x9d\x90",
	"1-26-34" => "\xe5\xba\xa7",
	"1-26-35" => "\xe6\x8c\xab",
	"1-26-36" => "\xe5\x82\xb5",
	"1-26-37" => "\xe5\x82\xac",
	"1-26-38" => "\xe5\x86\x8d",
	"1-26-39" => "\xe6\x9c\x80",
	"1-26-40" => "\xe5\x93\x89",
	"1-26-41" => "\xe5\xa1\x9e",
	"1-26-42" => "\xe5\xa6\xbb",
	"1-26-43" => "\xe5\xae\xb0",
	"1-26-44" => "\xe5\xbd\xa9",
	"1-26-45" => "\xe6\x89\x8d",
	"1-26-46" => "\xe6\x8e\xa1",
	"1-26-47" => "\xe6\xa0\xbd",
	"1-26-48" => "\xe6\xad\xb3",
	"1-26-49" => "\xe6\xb8\x88",
	"1-26-50" => "\xe7\x81\xbd",
	"1-26-51" => "\xe9\x87\x87",
	"1-26-52" => "\xe7\x8a\x80",
	"1-26-53" => "\xe7\xa0\x95",
	"1-26-54" => "\xe7\xa0\xa6",
	"1-26-55" => "\xe7\xa5\xad",
	"1-26-56" => "\xe6\x96\x8e",
	"1-26-57" => "\xe7\xb4\xb0",
	"1-26-58" => "\xe8\x8f\x9c",
	"1-26-59" => "\xe8\xa3\x81",
	"1-26-60" => "\xe8\xbc\x89",
	"1-26-61" => "\xe9\x9a\x9b",
	"1-26-62" => "\xe5\x89\xa4",
	"1-26-63" => "\xe5\x9c\xa8",
	"1-26-64" => "\xe6\x9d\x90",
	"1-26-65" => "\xe7\xbd\xaa",
	"1-26-66" => "\xe8\xb2\xa1",
	"1-26-67" => "\xe5\x86\xb4",
	"1-26-68" => "\xe5\x9d\x82",
	"1-26-69" => "\xe9\x98\xaa",
	"1-26-70" => "\xe5\xa0\xba",
	"1-26-71" => "\xe6\xa6\x8a",
	"1-26-72" => "\xe8\x82\xb4",
	"1-26-73" => "\xe5\x92\xb2",
	"1-26-74" => "\xe5\xb4\x8e",
	"1-26-75" => "\xe5\x9f\xbc",
	"1-26-76" => "\xe7\xa2\x95",
	"1-26-77" => "\xe9\xb7\xba",
	"1-26-78" => "\xe4\xbd\x9c",
	"1-26-79" => "\xe5\x89\x8a",
	"1-26-80" => "\xe5\x92\x8b",
	"1-26-81" => "\xe6\x90\xbe",
	"1-26-82" => "\xe6\x98\xa8",
	"1-26-83" => "\xe6\x9c\x94",
	"1-26-84" => "\xe6\x9f\xb5",
	"1-26-85" => "\xe7\xaa\x84",
	"1-26-86" => "\xe7\xad\x96",
	"1-26-87" => "\xe7\xb4\xa2",
	"1-26-88" => "\xe9\x8c\xaf",
	"1-26-89" => "\xe6\xa1\x9c",
	"1-26-90" => "\xe9\xae\xad",
	"1-26-91" => "\xe7\xac\xb9",
	"1-26-92" => "\xe5\x8c\x99",
	"1-26-93" => "\xe5\x86\x8a",
	"1-26-94" => "\xe5\x88\xb7",
	"1-27-1" => "\xe5\xaf\x9f",
	"1-27-2" => "\xe6\x8b\xb6",
	"1-27-3" => "\xe6\x92\xae",
	"1-27-4" => "\xe6\x93\xa6",
	"1-27-5" => "\xe6\x9c\xad",
	"1-27-6" => "\xe6\xae\xba",
	"1-27-7" => "\xe8\x96\xa9",
	"1-27-8" => "\xe9\x9b\x91",
	"1-27-9" => "\xe7\x9a\x90",
	"1-27-10" => "\xe9\xaf\x96",
	"1-27-11" => "\xe6\x8d\x8c",
	"1-27-12" => "\xe9\x8c\x86",
	"1-27-13" => "\xe9\xae\xab",
	"1-27-14" => "\xe7\x9a\xbf",
	"1-27-15" => "\xe6\x99\x92",
	"1-27-16" => "\xe4\xb8\x89",
	"1-27-17" => "\xe5\x82\x98",
	"1-27-18" => "\xe5\x8f\x82",
	"1-27-19" => "\xe5\xb1\xb1",
	"1-27-20" => "\xe6\x83\xa8",
	"1-27-21" => "\xe6\x92\x92",
	"1-27-22" => "\xe6\x95\xa3",
	"1-27-23" => "\xe6\xa1\x9f",
	"1-27-24" => "\xe7\x87\xa6",
	"1-27-25" => "\xe7\x8f\x8a",
	"1-27-26" => "\xe7\x94\xa3",
	"1-27-27" => "\xe7\xae\x97",
	"1-27-28" => "\xe7\xba\x82",
	"1-27-29" => "\xe8\x9a\x95",
	"1-27-30" => "\xe8\xae\x83",
	"1-27-31" => "\xe8\xb3\x9b",
	"1-27-32" => "\xe9\x85\xb8",
	"1-27-33" => "\xe9\xa4\x90",
	"1-27-34" => "\xe6\x96\xac",
	"1-27-35" => "\xe6\x9a\xab",
	"1-27-36" => "\xe6\xae\x8b",
	"1-27-37" => "\xe4\xbb\x95",
	"1-27-38" => "\xe4\xbb\x94",
	"1-27-39" => "\xe4\xbc\xba",
	"1-27-40" => "\xe4\xbd\xbf",
	"1-27-41" => "\xe5\x88\xba",
	"1-27-42" => "\xe5\x8f\xb8",
	"1-27-43" => "\xe5\x8f\xb2",
	"1-27-44" => "\xe5\x97\xa3",
	"1-27-45" => "\xe5\x9b\x9b",
	"1-27-46" => "\xe5\xa3\xab",
	"1-27-47" => "\xe5\xa7\x8b",
	"1-27-48" => "\xe5\xa7\x89",
	"1-27-49" => "\xe5\xa7\xbf",
	"1-27-50" => "\xe5\xad\x90",
	"1-27-51" => "\xe5\xb1\x8d",
	"1-27-52" => "\xe5\xb8\x82",
	"1-27-53" => "\xe5\xb8\xab",
	"1-27-54" => "\xe5\xbf\x97",
	"1-27-55" => "\xe6\x80\x9d",
	"1-27-56" => "\xe6\x8c\x87",
	"1-27-57" => "\xe6\x94\xaf",
	"1-27-58" => "\xe5\xad\x9c",
	"1-27-59" => "\xe6\x96\xaf",
	"1-27-60" => "\xe6\x96\xbd",
	"1-27-61" => "\xe6\x97\xa8",
	"1-27-62" => "\xe6\x9e\x9d",
	"1-27-63" => "\xe6\xad\xa2",
	"1-27-64" => "\xe6\xad\xbb",
	"1-27-65" => "\xe6\xb0\x8f",
	"1-27-66" => "\xe7\x8d\x85",
	"1-27-67" => "\xe7\xa5\x89",
	"1-27-68" => "\xe7\xa7\x81",
	"1-27-69" => "\xe7\xb3\xb8",
	"1-27-70" => "\xe7\xb4\x99",
	"1-27-71" => "\xe7\xb4\xab",
	"1-27-72" => "\xe8\x82\xa2",
	"1-27-73" => "\xe8\x84\x82",
	"1-27-74" => "\xe8\x87\xb3",
	"1-27-75" => "\xe8\xa6\x96",
	"1-27-76" => "\xe8\xa9\x9e",
	"1-27-77" => "\xe8\xa9\xa9",
	"1-27-78" => "\xe8\xa9\xa6",
	"1-27-79" => "\xe8\xaa\x8c",
	"1-27-80" => "\xe8\xab\xae",
	"1-27-81" => "\xe8\xb3\x87",
	"1-27-82" => "\xe8\xb3\x9c",
	"1-27-83" => "\xe9\x9b\x8c",
	"1-27-84" => "\xe9\xa3\xbc",
	"1-27-85" => "\xe6\xad\xaf",
	"1-27-86" => "\xe4\xba\x8b",
	"1-27-87" => "\xe4\xbc\xbc",
	"1-27-88" => "\xe4\xbe\x8d",
	"1-27-89" => "\xe5\x85\x90",
	"1-27-90" => "\xe5\xad\x97",
	"1-27-91" => "\xe5\xaf\xba",
	"1-27-92" => "\xe6\x85\x88",
	"1-27-93" => "\xe6\x8c\x81",
	"1-27-94" => "\xe6\x99\x82",
	"1-28-1" => "\xe6\xac\xa1",
	"1-28-2" => "\xe6\xbb\x8b",
	"1-28-3" => "\xe6\xb2\xbb",
	"1-28-4" => "\xe7\x88\xbe",
	"1-28-5" => "\xe7\x92\xbd",
	"1-28-6" => "\xe7\x97\x94",
	"1-28-7" => "\xe7\xa3\x81",
	"1-28-8" => "\xe7\xa4\xba",
	"1-28-9" => "\xe8\x80\x8c",
	"1-28-10" => "\xe8\x80\xb3",
	"1-28-11" => "\xe8\x87\xaa",
	"1-28-12" => "\xe8\x92\x94",
	"1-28-13" => "\xe8\xbe\x9e",
	"1-28-14" => "\xe6\xb1\x90",
	"1-28-15" => "\xe9\xb9\xbf",
	"1-28-16" => "\xe5\xbc\x8f",
	"1-28-17" => "\xe8\xad\x98",
	"1-28-18" => "\xe9\xb4\xab",
	"1-28-19" => "\xe7\xab\xba",
	"1-28-20" => "\xe8\xbb\xb8",
	"1-28-21" => "\xe5\xae\x8d",
	"1-28-22" => "\xe9\x9b\xab",
	"1-28-23" => "\xe4\xb8\x83",
	"1-28-24" => "\xe5\x8f\xb1",
	"1-28-25" => "\xe5\x9f\xb7",
	"1-28-26" => "\xe5\xa4\xb1",
	"1-28-27" => "\xe5\xab\x89",
	"1-28-28" => "\xe5\xae\xa4",
	"1-28-29" => "\xe6\x82\x89",
	"1-28-30" => "\xe6\xb9\xbf",
	"1-28-31" => "\xe6\xbc\x86",
	"1-28-32" => "\xe7\x96\xbe",
	"1-28-33" => "\xe8\xb3\xaa",
	"1-28-34" => "\xe5\xae\x9f",
	"1-28-35" => "\xe8\x94\x80",
	"1-28-36" => "\xe7\xaf\xa0",
	"1-28-37" => "\xe5\x81\xb2",
	"1-28-38" => "\xe6\x9f\xb4",
	"1-28-39" => "\xe8\x8a\x9d",
	"1-28-40" => "\xe5\xb1\xa1",
	"1-28-41" => "\xe8\x95\x8a",
	"1-28-42" => "\xe7\xb8\x9e",
	"1-28-43" => "\xe8\x88\x8e",
	"1-28-44" => "\xe5\x86\x99",
	"1-28-45" => "\xe5\xb0\x84",
	"1-28-46" => "\xe6\x8d\xa8",
	"1-28-47" => "\xe8\xb5\xa6",
	"1-28-48" => "\xe6\x96\x9c",
	"1-28-49" => "\xe7\x85\xae",
	"1-28-50" => "\xe7\xa4\xbe",
	"1-28-51" => "\xe7\xb4\x97",
	"1-28-52" => "\xe8\x80\x85",
	"1-28-53" => "\xe8\xac\x9d",
	"1-28-54" => "\xe8\xbb\x8a",
	"1-28-55" => "\xe9\x81\xae",
	"1-28-56" => "\xe8\x9b\x87",
	"1-28-57" => "\xe9\x82\xaa",
	"1-28-58" => "\xe5\x80\x9f",
	"1-28-59" => "\xe5\x8b\xba",
	"1-28-60" => "\xe5\xb0\xba",
	"1-28-61" => "\xe6\x9d\x93",
	"1-28-62" => "\xe7\x81\xbc",
	"1-28-63" => "\xe7\x88\xb5",
	"1-28-64" => "\xe9\x85\x8c",
	"1-28-65" => "\xe9\x87\x88",
	"1-28-66" => "\xe9\x8c\xab",
	"1-28-67" => "\xe8\x8b\xa5",
	"1-28-68" => "\xe5\xaf\x82",
	"1-28-69" => "\xe5\xbc\xb1",
	"1-28-70" => "\xe6\x83\xb9",
	"1-28-71" => "\xe4\xb8\xbb",
	"1-28-72" => "\xe5\x8f\x96",
	"1-28-73" => "\xe5\xae\x88",
	"1-28-74" => "\xe6\x89\x8b",
	"1-28-75" => "\xe6\x9c\xb1",
	"1-28-76" => "\xe6\xae\x8a",
	"1-28-77" => "\xe7\x8b\xa9",
	"1-28-78" => "\xe7\x8f\xa0",
	"1-28-79" => "\xe7\xa8\xae",
	"1-28-80" => "\xe8\x85\xab",
	"1-28-81" => "\xe8\xb6\xa3",
	"1-28-82" => "\xe9\x85\x92",
	"1-28-83" => "\xe9\xa6\x96",
	"1-28-84" => "\xe5\x84\x92",
	"1-28-85" => "\xe5\x8f\x97",
	"1-28-86" => "\xe5\x91\xaa",
	"1-28-87" => "\xe5\xaf\xbf",
	"1-28-88" => "\xe6\x8e\x88",
	"1-28-89" => "\xe6\xa8\xb9",
	"1-28-90" => "\xe7\xb6\xac",
	"1-28-91" => "\xe9\x9c\x80",
	"1-28-92" => "\xe5\x9b\x9a",
	"1-28-93" => "\xe5\x8f\x8e",
	"1-28-94" => "\xe5\x91\xa8",
	"1-29-1" => "\xe5\xae\x97",
	"1-29-2" => "\xe5\xb0\xb1",
	"1-29-3" => "\xe5\xb7\x9e",
	"1-29-4" => "\xe4\xbf\xae",
	"1-29-5" => "\xe6\x84\x81",
	"1-29-6" => "\xe6\x8b\xbe",
	"1-29-7" => "\xe6\xb4\xb2",
	"1-29-8" => "\xe7\xa7\x80",
	"1-29-9" => "\xe7\xa7\x8b",
	"1-29-10" => "\xe7\xb5\x82",
	"1-29-11" => "\xe7\xb9\x8d",
	"1-29-12" => "\xe7\xbf\x92",
	"1-29-13" => "\xe8\x87\xad",
	"1-29-14" => "\xe8\x88\x9f",
	"1-29-15" => "\xe8\x92\x90",
	"1-29-16" => "\xe8\xa1\x86",
	"1-29-17" => "\xe8\xa5\xb2",
	"1-29-18" => "\xe8\xae\x90",
	"1-29-19" => "\xe8\xb9\xb4",
	"1-29-20" => "\xe8\xbc\xaf",
	"1-29-21" => "\xe9\x80\xb1",
	"1-29-22" => "\xe9\x85\x8b",
	"1-29-23" => "\xe9\x85\xac",
	"1-29-24" => "\xe9\x9b\x86",
	"1-29-25" => "\xe9\x86\x9c",
	"1-29-26" => "\xe4\xbb\x80",
	"1-29-27" => "\xe4\xbd\x8f",
	"1-29-28" => "\xe5\x85\x85",
	"1-29-29" => "\xe5\x8d\x81",
	"1-29-30" => "\xe5\xbe\x93",
	"1-29-31" => "\xe6\x88\x8e",
	"1-29-32" => "\xe6\x9f\x94",
	"1-29-33" => "\xe6\xb1\x81",
	"1-29-34" => "\xe6\xb8\x8b",
	"1-29-35" => "\xe7\x8d\xa3",
	"1-29-36" => "\xe7\xb8\xa6",
	"1-29-37" => "\xe9\x87\x8d",
	"1-29-38" => "\xe9\x8a\x83",
	"1-29-39" => "\xe5\x8f\x94",
	"1-29-40" => "\xe5\xa4\x99",
	"1-29-41" => "\xe5\xae\xbf",
	"1-29-42" => "\xe6\xb7\x91",
	"1-29-43" => "\xe7\xa5\x9d",
	"1-29-44" => "\xe7\xb8\xae",
	"1-29-45" => "\xe7\xb2\x9b",
	"1-29-46" => "\xe5\xa1\xbe",
	"1-29-47" => "\xe7\x86\x9f",
	"1-29-48" => "\xe5\x87\xba",
	"1-29-49" => "\xe8\xa1\x93",
	"1-29-50" => "\xe8\xbf\xb0",
	"1-29-51" => "\xe4\xbf\x8a",
	"1-29-52" => "\xe5\xb3\xbb",
	"1-29-53" => "\xe6\x98\xa5",
	"1-29-54" => "\xe7\x9e\xac",
	"1-29-55" => "\xe7\xab\xa3",
	"1-29-56" => "\xe8\x88\x9c",
	"1-29-57" => "\xe9\xa7\xbf",
	"1-29-58" => "\xe5\x87\x86",
	"1-29-59" => "\xe5\xbe\xaa",
	"1-29-60" => "\xe6\x97\xac",
	"1-29-61" => "\xe6\xa5\xaf",
	"1-29-62" => "\xe6\xae\x89",
	"1-29-63" => "\xe6\xb7\xb3",
	"1-29-64" => "\xe6\xba\x96",
	"1-29-65" => "\xe6\xbd\xa4",
	"1-29-66" => "\xe7\x9b\xbe",
	"1-29-67" => "\xe7\xb4\x94",
	"1-29-68" => "\xe5\xb7\xa1",
	"1-29-69" => "\xe9\x81\xb5",
	"1-29-70" => "\xe9\x86\x87",
	"1-29-71" => "\xe9\xa0\x86",
	"1-29-72" => "\xe5\x87\xa6",
	"1-29-73" => "\xe5\x88\x9d",
	"1-29-74" => "\xe6\x89\x80",
	"1-29-75" => "\xe6\x9a\x91",
	"1-29-76" => "\xe6\x9b\x99",
	"1-29-77" => "\xe6\xb8\x9a",
	"1-29-78" => "\xe5\xba\xb6",
	"1-29-79" => "\xe7\xb7\x92",
	"1-29-80" => "\xe7\xbd\xb2",
	"1-29-81" => "\xe6\x9b\xb8",
	"1-29-82" => "\xe8\x96\xaf",
	"1-29-83" => "\xe8\x97\xb7",
	"1-29-84" => "\xe8\xab\xb8",
	"1-29-85" => "\xe5\x8a\xa9",
	"1-29-86" => "\xe5\x8f\x99",
	"1-29-87" => "\xe5\xa5\xb3",
	"1-29-88" => "\xe5\xba\x8f",
	"1-29-89" => "\xe5\xbe\x90",
	"1-29-90" => "\xe6\x81\x95",
	"1-29-91" => "\xe9\x8b\xa4",
	"1-29-92" => "\xe9\x99\xa4",
	"1-29-93" => "\xe5\x82\xb7",
	"1-29-94" => "\xe5\x84\x9f",
	"1-30-1" => "\xe5\x8b\x9d",
	"1-30-2" => "\xe5\x8c\xa0",
	"1-30-3" => "\xe5\x8d\x87",
	"1-30-4" => "\xe5\x8f\xac",
	"1-30-5" => "\xe5\x93\xa8",
	"1-30-6" => "\xe5\x95\x86",
	"1-30-7" => "\xe5\x94\xb1",
	"1-30-8" => "\xe5\x98\x97",
	"1-30-9" => "\xe5\xa5\xa8",
	"1-30-10" => "\xe5\xa6\xbe",
	"1-30-11" => "\xe5\xa8\xbc",
	"1-30-12" => "\xe5\xae\xb5",
	"1-30-13" => "\xe5\xb0\x86",
	"1-30-14" => "\xe5\xb0\x8f",
	"1-30-15" => "\xe5\xb0\x91",
	"1-30-16" => "\xe5\xb0\x9a",
	"1-30-17" => "\xe5\xba\x84",
	"1-30-18" => "\xe5\xba\x8a",
	"1-30-19" => "\xe5\xbb\xa0",
	"1-30-20" => "\xe5\xbd\xb0",
	"1-30-21" => "\xe6\x89\xbf",
	"1-30-22" => "\xe6\x8a\x84",
	"1-30-23" => "\xe6\x8b\x9b",
	"1-30-24" => "\xe6\x8e\x8c",
	"1-30-25" => "\xe6\x8d\xb7",
	"1-30-26" => "\xe6\x98\x87",
	"1-30-27" => "\xe6\x98\x8c",
	"1-30-28" => "\xe6\x98\xad",
	"1-30-29" => "\xe6\x99\xb6",
	"1-30-30" => "\xe6\x9d\xbe",
	"1-30-31" => "\xe6\xa2\xa2",
	"1-30-32" => "\xe6\xa8\x9f",
	"1-30-33" => "\xe6\xa8\xb5",
	"1-30-34" => "\xe6\xb2\xbc",
	"1-30-35" => "\xe6\xb6\x88",
	"1-30-36" => "\xe6\xb8\x89",
	"1-30-37" => "\xe6\xb9\x98",
	"1-30-38" => "\xe7\x84\xbc",
	"1-30-39" => "\xe7\x84\xa6",
	"1-30-40" => "\xe7\x85\xa7",
	"1-30-41" => "\xe7\x97\x87",
	"1-30-42" => "\xe7\x9c\x81",
	"1-30-43" => "\xe7\xa1\x9d",
	"1-30-44" => "\xe7\xa4\x81",
	"1-30-45" => "\xe7\xa5\xa5",
	"1-30-46" => "\xe7\xa7\xb0",
	"1-30-47" => "\xe7\xab\xa0",
	"1-30-48" => "\xe7\xac\x91",
	"1-30-49" => "\xe7\xb2\xa7",
	"1-30-50" => "\xe7\xb4\xb9",
	"1-30-51" => "\xe8\x82\x96",
	"1-30-52" => "\xe8\x8f\x96",
	"1-30-53" => "\xe8\x92\x8b",
	"1-30-54" => "\xe8\x95\x89",
	"1-30-55" => "\xe8\xa1\x9d",
	"1-30-56" => "\xe8\xa3\xb3",
	"1-30-57" => "\xe8\xa8\x9f",
	"1-30-58" => "\xe8\xa8\xbc",
	"1-30-59" => "\xe8\xa9\x94",
	"1-30-60" => "\xe8\xa9\xb3",
	"1-30-61" => "\xe8\xb1\xa1",
	"1-30-62" => "\xe8\xb3\x9e",
	"1-30-63" => "\xe9\x86\xa4",
	"1-30-64" => "\xe9\x89\xa6",
	"1-30-65" => "\xe9\x8d\xbe",
	"1-30-66" => "\xe9\x90\x98",
	"1-30-67" => "\xe9\x9a\x9c",
	"1-30-68" => "\xe9\x9e\x98",
	"1-30-69" => "\xe4\xb8\x8a",
	"1-30-70" => "\xe4\xb8\x88",
	"1-30-71" => "\xe4\xb8\x9e",
	"1-30-72" => "\xe4\xb9\x97",
	"1-30-73" => "\xe5\x86\x97",
	"1-30-74" => "\xe5\x89\xb0",
	"1-30-75" => "\xe5\x9f\x8e",
	"1-30-76" => "\xe5\xa0\xb4",
	"1-30-77" => "\xe5\xa3\x8c",
	"1-30-78" => "\xe5\xac\xa2",
	"1-30-79" => "\xe5\xb8\xb8",
	"1-30-80" => "\xe6\x83\x85",
	"1-30-81" => "\xe6\x93\xbe",
	"1-30-82" => "\xe6\x9d\xa1",
	"1-30-83" => "\xe6\x9d\x96",
	"1-30-84" => "\xe6\xb5\x84",
	"1-30-85" => "\xe7\x8a\xb6",
	"1-30-86" => "\xe7\x95\xb3",
	"1-30-87" => "\xe7\xa9\xa3",
	"1-30-88" => "\xe8\x92\xb8",
	"1-30-89" => "\xe8\xad\xb2",
	"1-30-90" => "\xe9\x86\xb8",
	"1-30-91" => "\xe9\x8c\xa0",
	"1-30-92" => "\xe5\x98\xb1",
	"1-30-93" => "\xe5\x9f\xb4",
	"1-30-94" => "\xe9\xa3\xbe",
	"1-31-1" => "\xe6\x8b\xad",
	"1-31-2" => "\xe6\xa4\x8d",
	"1-31-3" => "\xe6\xae\x96",
	"1-31-4" => "\xe7\x87\xad",
	"1-31-5" => "\xe7\xb9\x94",
	"1-31-6" => "\xe8\x81\xb7",
	"1-31-7" => "\xe8\x89\xb2",
	"1-31-8" => "\xe8\xa7\xa6",
	"1-31-9" => "\xe9\xa3\x9f",
	"1-31-10" => "\xe8\x9d\x95",
	"1-31-11" => "\xe8\xbe\xb1",
	"1-31-12" => "\xe5\xb0\xbb",
	"1-31-13" => "\xe4\xbc\xb8",
	"1-31-14" => "\xe4\xbf\xa1",
	"1-31-15" => "\xe4\xbe\xb5",
	"1-31-16" => "\xe5\x94\x87",
	"1-31-17" => "\xe5\xa8\xa0",
	"1-31-18" => "\xe5\xaf\x9d",
	"1-31-19" => "\xe5\xaf\xa9",
	"1-31-20" => "\xe5\xbf\x83",
	"1-31-21" => "\xe6\x85\x8e",
	"1-31-22" => "\xe6\x8c\xaf",
	"1-31-23" => "\xe6\x96\xb0",
	"1-31-24" => "\xe6\x99\x8b",
	"1-31-25" => "\xe6\xa3\xae",
	"1-31-26" => "\xe6\xa6\x9b",
	"1-31-27" => "\xe6\xb5\xb8",
	"1-31-28" => "\xe6\xb7\xb1",
	"1-31-29" => "\xe7\x94\xb3",
	"1-31-30" => "\xe7\x96\xb9",
	"1-31-31" => "\xe7\x9c\x9f",
	"1-31-32" => "\xe7\xa5\x9e",
	"1-31-33" => "\xe7\xa7\xa6",
	"1-31-34" => "\xe7\xb4\xb3",
	"1-31-35" => "\xe8\x87\xa3",
	"1-31-36" => "\xe8\x8a\xaf",
	"1-31-37" => "\xe8\x96\xaa",
	"1-31-38" => "\xe8\xa6\xaa",
	"1-31-39" => "\xe8\xa8\xba",
	"1-31-40" => "\xe8\xba\xab",
	"1-31-41" => "\xe8\xbe\x9b",
	"1-31-42" => "\xe9\x80\xb2",
	"1-31-43" => "\xe9\x87\x9d",
	"1-31-44" => "\xe9\x9c\x87",
	"1-31-45" => "\xe4\xba\xba",
	"1-31-46" => "\xe4\xbb\x81",
	"1-31-47" => "\xe5\x88\x83",
	"1-31-48" => "\xe5\xa1\xb5",
	"1-31-49" => "\xe5\xa3\xac",
	"1-31-50" => "\xe5\xb0\x8b",
	"1-31-51" => "\xe7\x94\x9a",
	"1-31-52" => "\xe5\xb0\xbd",
	"1-31-53" => "\xe8\x85\x8e",
	"1-31-54" => "\xe8\xa8\x8a",
	"1-31-55" => "\xe8\xbf\x85",
	"1-31-56" => "\xe9\x99\xa3",
	"1-31-57" => "\xe9\x9d\xad",
	"1-31-58" => "\xe7\xac\xa5",
	"1-31-59" => "\xe8\xab\x8f",
	"1-31-60" => "\xe9\xa0\x88",
	"1-31-61" => "\xe9\x85\xa2",
	"1-31-62" => "\xe5\x9b\xb3",
	"1-31-63" => "\xe5\x8e\xa8",
	"1-31-64" => "\xe9\x80\x97",
	"1-31-65" => "\xe5\x90\xb9",
	"1-31-66" => "\xe5\x9e\x82",
	"1-31-67" => "\xe5\xb8\xa5",
	"1-31-68" => "\xe6\x8e\xa8",
	"1-31-69" => "\xe6\xb0\xb4",
	"1-31-70" => "\xe7\x82\x8a",
	"1-31-71" => "\xe7\x9d\xa1",
	"1-31-72" => "\xe7\xb2\x8b",
	"1-31-73" => "\xe7\xbf\xa0",
	"1-31-74" => "\xe8\xa1\xb0",
	"1-31-75" => "\xe9\x81\x82",
	"1-31-76" => "\xe9\x85\x94",
	"1-31-77" => "\xe9\x8c\x90",
	"1-31-78" => "\xe9\x8c\x98",
	"1-31-79" => "\xe9\x9a\x8f",
	"1-31-80" => "\xe7\x91\x9e",
	"1-31-81" => "\xe9\xab\x84",
	"1-31-82" => "\xe5\xb4\x87",
	"1-31-83" => "\xe5\xb5\xa9",
	"1-31-84" => "\xe6\x95\xb0",
	"1-31-85" => "\xe6\x9e\xa2",
	"1-31-86" => "\xe8\xb6\xa8",
	"1-31-87" => "\xe9\x9b\x9b",
	"1-31-88" => "\xe6\x8d\xae",
	"1-31-89" => "\xe6\x9d\x89",
	"1-31-90" => "\xe6\xa4\x99",
	"1-31-91" => "\xe8\x8f\x85",
	"1-31-92" => "\xe9\xa0\x97",
	"1-31-93" => "\xe9\x9b\x80",
	"1-31-94" => "\xe8\xa3\xbe",
	"1-32-1" => "\xe6\xbe\x84",
	"1-32-2" => "\xe6\x91\xba",
	"1-32-3" => "\xe5\xaf\xb8",
	"1-32-4" => "\xe4\xb8\x96",
	"1-32-5" => "\xe7\x80\xac",
	"1-32-6" => "\xe7\x95\x9d",
	"1-32-7" => "\xe6\x98\xaf",
	"1-32-8" => "\xe5\x87\x84",
	"1-32-9" => "\xe5\x88\xb6",
	"1-32-10" => "\xe5\x8b\xa2",
	"1-32-11" => "\xe5\xa7\x93",
	"1-32-12" => "\xe5\xbe\x81",
	"1-32-13" => "\xe6\x80\xa7",
	"1-32-14" => "\xe6\x88\x90",
	"1-32-15" => "\xe6\x94\xbf",
	"1-32-16" => "\xe6\x95\xb4",
	"1-32-17" => "\xe6\x98\x9f",
	"1-32-18" => "\xe6\x99\xb4",
	"1-32-19" => "\xe6\xa3\xb2",
	"1-32-20" => "\xe6\xa0\x96",
	"1-32-21" => "\xe6\xad\xa3",
	"1-32-22" => "\xe6\xb8\x85",
	"1-32-23" => "\xe7\x89\xb2",
	"1-32-24" => "\xe7\x94\x9f",
	"1-32-25" => "\xe7\x9b\x9b",
	"1-32-26" => "\xe7\xb2\xbe",
	"1-32-27" => "\xe8\x81\x96",
	"1-32-28" => "\xe5\xa3\xb0",
	"1-32-29" => "\xe8\xa3\xbd",
	"1-32-30" => "\xe8\xa5\xbf",
	"1-32-31" => "\xe8\xaa\xa0",
	"1-32-32" => "\xe8\xaa\x93",
	"1-32-33" => "\xe8\xab\x8b",
	"1-32-34" => "\xe9\x80\x9d",
	"1-32-35" => "\xe9\x86\x92",
	"1-32-36" => "\xe9\x9d\x92",
	"1-32-37" => "\xe9\x9d\x99",
	"1-32-38" => "\xe6\x96\x89",
	"1-32-39" => "\xe7\xa8\x8e",
	"1-32-40" => "\xe8\x84\x86",
	"1-32-41" => "\xe9\x9a\xbb",
	"1-32-42" => "\xe5\xb8\xad",
	"1-32-43" => "\xe6\x83\x9c",
	"1-32-44" => "\xe6\x88\x9a",
	"1-32-45" => "\xe6\x96\xa5",
	"1-32-46" => "\xe6\x98\x94",
	"1-32-47" => "\xe6\x9e\x90",
	"1-32-48" => "\xe7\x9f\xb3",
	"1-32-49" => "\xe7\xa9\x8d",
	"1-32-50" => "\xe7\xb1\x8d",
	"1-32-51" => "\xe7\xb8\xbe",
	"1-32-52" => "\xe8\x84\x8a",
	"1-32-53" => "\xe8\xb2\xac",
	"1-32-54" => "\xe8\xb5\xa4",
	"1-32-55" => "\xe8\xb7\xa1",
	"1-32-56" => "\xe8\xb9\x9f",
	"1-32-57" => "\xe7\xa2\xa9",
	"1-32-58" => "\xe5\x88\x87",
	"1-32-59" => "\xe6\x8b\x99",
	"1-32-60" => "\xe6\x8e\xa5",
	"1-32-61" => "\xe6\x91\x82",
	"1-32-62" => "\xe6\x8a\x98",
	"1-32-63" => "\xe8\xa8\xad",
	"1-32-64" => "\xe7\xaa\x83",
	"1-32-65" => "\xe7\xaf\x80",
	"1-32-66" => "\xe8\xaa\xac",
	"1-32-67" => "\xe9\x9b\xaa",
	"1-32-68" => "\xe7\xb5\xb6",
	"1-32-69" => "\xe8\x88\x8c",
	"1-32-70" => "\xe8\x9d\x89",
	"1-32-71" => "\xe4\xbb\x99",
	"1-32-72" => "\xe5\x85\x88",
	"1-32-73" => "\xe5\x8d\x83",
	"1-32-74" => "\xe5\x8d\xa0",
	"1-32-75" => "\xe5\xae\xa3",
	"1-32-76" => "\xe5\xb0\x82",
	"1-32-77" => "\xe5\xb0\x96",
	"1-32-78" => "\xe5\xb7\x9d",
	"1-32-79" => "\xe6\x88\xa6",
	"1-32-80" => "\xe6\x89\x87",
	"1-32-81" => "\xe6\x92\xb0",
	"1-32-82" => "\xe6\xa0\x93",
	"1-32-83" => "\xe6\xa0\xb4",
	"1-32-84" => "\xe6\xb3\x89",
	"1-32-85" => "\xe6\xb5\x85",
	"1-32-86" => "\xe6\xb4\x97",
	"1-32-87" => "\xe6\x9f\x93",
	"1-32-88" => "\xe6\xbd\x9c",
	"1-32-89" => "\xe7\x85\x8e",
	"1-32-90" => "\xe7\x85\xbd",
	"1-32-91" => "\xe6\x97\x8b",
	"1-32-92" => "\xe7\xa9\xbf",
	"1-32-93" => "\xe7\xae\xad",
	"1-32-94" => "\xe7\xb7\x9a",
	"1-33-1" => "\xe7\xb9\x8a",
	"1-33-2" => "\xe7\xbe\xa8",
	"1-33-3" => "\xe8\x85\xba",
	"1-33-4" => "\xe8\x88\x9b",
	"1-33-5" => "\xe8\x88\xb9",
	"1-33-6" => "\xe8\x96\xa6",
	"1-33-7" => "\xe8\xa9\xae",
	"1-33-8" => "\xe8\xb3\x8e",
	"1-33-9" => "\xe8\xb7\xb5",
	"1-33-10" => "\xe9\x81\xb8",
	"1-33-11" => "\xe9\x81\xb7",
	"1-33-12" => "\xe9\x8a\xad",
	"1-33-13" => "\xe9\x8a\x91",
	"1-33-14" => "\xe9\x96\x83",
	"1-33-15" => "\xe9\xae\xae",
	"1-33-16" => "\xe5\x89\x8d",
	"1-33-17" => "\xe5\x96\x84",
	"1-33-18" => "\xe6\xbc\xb8",
	"1-33-19" => "\xe7\x84\xb6",
	"1-33-20" => "\xe5\x85\xa8",
	"1-33-21" => "\xe7\xa6\x85",
	"1-33-22" => "\xe7\xb9\x95",
	"1-33-23" => "\xe8\x86\xb3",
	"1-33-24" => "\xe7\xb3\x8e",
	"1-33-25" => "\xe5\x99\x8c",
	"1-33-26" => "\xe5\xa1\x91",
	"1-33-27" => "\xe5\xb2\xa8",
	"1-33-28" => "\xe6\x8e\xaa",
	"1-33-29" => "\xe6\x9b\xbe",
	"1-33-30" => "\xe6\x9b\xbd",
	"1-33-31" => "\xe6\xa5\x9a",
	"1-33-32" => "\xe7\x8b\x99",
	"1-33-33" => "\xe7\x96\x8f",
	"1-33-34" => "\xe7\x96\x8e",
	"1-33-35" => "\xe7\xa4\x8e",
	"1-33-36" => "\xe7\xa5\x96",
	"1-33-37" => "\xe7\xa7\x9f",
	"1-33-38" => "\xe7\xb2\x97",
	"1-33-39" => "\xe7\xb4\xa0",
	"1-33-40" => "\xe7\xb5\x84",
	"1-33-41" => "\xe8\x98\x87",
	"1-33-42" => "\xe8\xa8\xb4",
	"1-33-43" => "\xe9\x98\xbb",
	"1-33-44" => "\xe9\x81\xa1",
	"1-33-45" => "\xe9\xbc\xa0",
	"1-33-46" => "\xe5\x83\xa7",
	"1-33-47" => "\xe5\x89\xb5",
	"1-33-48" => "\xe5\x8f\x8c",
	"1-33-49" => "\xe5\x8f\xa2",
	"1-33-50" => "\xe5\x80\x89",
	"1-33-51" => "\xe5\x96\xaa",
	"1-33-52" => "\xe5\xa3\xae",
	"1-33-53" => "\xe5\xa5\x8f",
	"1-33-54" => "\xe7\x88\xbd",
	"1-33-55" => "\xe5\xae\x8b",
	"1-33-56" => "\xe5\xb1\xa4",
	"1-33-57" => "\xe5\x8c\x9d",
	"1-33-58" => "\xe6\x83\xa3",
	"1-33-59" => "\xe6\x83\xb3",
	"1-33-60" => "\xe6\x8d\x9c",
	"1-33-61" => "\xe6\x8e\x83",
	"1-33-62" => "\xe6\x8c\xbf",
	"1-33-63" => "\xe6\x8e\xbb",
	"1-33-64" => "\xe6\x93\x8d",
	"1-33-65" => "\xe6\x97\xa9",
	"1-33-66" => "\xe6\x9b\xb9",
	"1-33-67" => "\xe5\xb7\xa3",
	"1-33-68" => "\xe6\xa7\x8d",
	"1-33-69" => "\xe6\xa7\xbd",
	"1-33-70" => "\xe6\xbc\x95",
	"1-33-71" => "\xe7\x87\xa5",
	"1-33-72" => "\xe4\xba\x89",
	"1-33-73" => "\xe7\x97\xa9",
	"1-33-74" => "\xe7\x9b\xb8",
	"1-33-75" => "\xe7\xaa\x93",
	"1-33-76" => "\xe7\xb3\x9f",
	"1-33-77" => "\xe7\xb7\x8f",
	"1-33-78" => "\xe7\xb6\x9c",
	"1-33-79" => "\xe8\x81\xa1",
	"1-33-80" => "\xe8\x8d\x89",
	"1-33-81" => "\xe8\x8d\x98",
	"1-33-82" => "\xe8\x91\xac",
	"1-33-83" => "\xe8\x92\xbc",
	"1-33-84" => "\xe8\x97\xbb",
	"1-33-85" => "\xe8\xa3\x85",
	"1-33-86" => "\xe8\xb5\xb0",
	"1-33-87" => "\xe9\x80\x81",
	"1-33-88" => "\xe9\x81\xad",
	"1-33-89" => "\xe9\x8e\x97",
	"1-33-90" => "\xe9\x9c\x9c",
	"1-33-91" => "\xe9\xa8\x92",
	"1-33-92" => "\xe5\x83\x8f",
	"1-33-93" => "\xe5\xa2\x97",
	"1-33-94" => "\xe6\x86\x8e",
	"1-34-1" => "\xe8\x87\x93",
	"1-34-2" => "\xe8\x94\xb5",
	"1-34-3" => "\xe8\xb4\x88",
	"1-34-4" => "\xe9\x80\xa0",
	"1-34-5" => "\xe4\xbf\x83",
	"1-34-6" => "\xe5\x81\xb4",
	"1-34-7" => "\xe5\x89\x87",
	"1-34-8" => "\xe5\x8d\xb3",
	"1-34-9" => "\xe6\x81\xaf",
	"1-34-10" => "\xe6\x8d\x89",
	"1-34-11" => "\xe6\x9d\x9f",
	"1-34-12" => "\xe6\xb8\xac",
	"1-34-13" => "\xe8\xb6\xb3",
	"1-34-14" => "\xe9\x80\x9f",
	"1-34-15" => "\xe4\xbf\x97",
	"1-34-16" => "\xe5\xb1\x9e",
	"1-34-17" => "\xe8\xb3\x8a",
	"1-34-18" => "\xe6\x97\x8f",
	"1-34-19" => "\xe7\xb6\x9a",
	"1-34-20" => "\xe5\x8d\x92",
	"1-34-21" => "\xe8\xa2\x96",
	"1-34-22" => "\xe5\x85\xb6",
	"1-34-23" => "\xe6\x8f\x83",
	"1-34-24" => "\xe5\xad\x98",
	"1-34-25" => "\xe5\xad\xab",
	"1-34-26" => "\xe5\xb0\x8a",
	"1-34-27" => "\xe6\x90\x8d",
	"1-34-28" => "\xe6\x9d\x91",
	"1-34-29" => "\xe9\x81\x9c",
	"1-34-30" => "\xe4\xbb\x96",
	"1-34-31" => "\xe5\xa4\x9a",
	"1-34-32" => "\xe5\xa4\xaa",
	"1-34-33" => "\xe6\xb1\xb0",
	"1-34-34" => "\xe8\xa9\x91",
	"1-34-35" => "\xe5\x94\xbe",
	"1-34-36" => "\xe5\xa0\x95",
	"1-34-37" => "\xe5\xa6\xa5",
	"1-34-38" => "\xe6\x83\xb0",
	"1-34-39" => "\xe6\x89\x93",
	"1-34-40" => "\xe6\x9f\x81",
	"1-34-41" => "\xe8\x88\xb5",
	"1-34-42" => "\xe6\xa5\x95",
	"1-34-43" => "\xe9\x99\x80",
	"1-34-44" => "\xe9\xa7\x84",
	"1-34-45" => "\xe9\xa8\xa8",
	"1-34-46" => "\xe4\xbd\x93",
	"1-34-47" => "\xe5\xa0\x86",
	"1-34-48" => "\xe5\xaf\xbe",
	"1-34-49" => "\xe8\x80\x90",
	"1-34-50" => "\xe5\xb2\xb1",
	"1-34-51" => "\xe5\xb8\xaf",
	"1-34-52" => "\xe5\xbe\x85",
	"1-34-53" => "\xe6\x80\xa0",
	"1-34-54" => "\xe6\x85\x8b",
	"1-34-55" => "\xe6\x88\xb4",
	"1-34-56" => "\xe6\x9b\xbf",
	"1-34-57" => "\xe6\xb3\xb0",
	"1-34-58" => "\xe6\xbb\x9e",
	"1-34-59" => "\xe8\x83\x8e",
	"1-34-60" => "\xe8\x85\xbf",
	"1-34-61" => "\xe8\x8b\x94",
	"1-34-62" => "\xe8\xa2\x8b",
	"1-34-63" => "\xe8\xb2\xb8",
	"1-34-64" => "\xe9\x80\x80",
	"1-34-65" => "\xe9\x80\xae",
	"1-34-66" => "\xe9\x9a\x8a",
	"1-34-67" => "\xe9\xbb\x9b",
	"1-34-68" => "\xe9\xaf\x9b",
	"1-34-69" => "\xe4\xbb\xa3",
	"1-34-70" => "\xe5\x8f\xb0",
	"1-34-71" => "\xe5\xa4\xa7",
	"1-34-72" => "\xe7\xac\xac",
	"1-34-73" => "\xe9\x86\x8d",
	"1-34-74" => "\xe9\xa1\x8c",
	"1-34-75" => "\xe9\xb7\xb9",
	"1-34-76" => "\xe6\xbb\x9d",
	"1-34-77" => "\xe7\x80\xa7",
	"1-34-78" => "\xe5\x8d\x93",
	"1-34-79" => "\xe5\x95\x84",
	"1-34-80" => "\xe5\xae\x85",
	"1-34-81" => "\xe6\x89\x98",
	"1-34-82" => "\xe6\x8a\x9e",
	"1-34-83" => "\xe6\x8b\x93",
	"1-34-84" => "\xe6\xb2\xa2",
	"1-34-85" => "\xe6\xbf\xaf",
	"1-34-86" => "\xe7\x90\xa2",
	"1-34-87" => "\xe8\xa8\x97",
	"1-34-88" => "\xe9\x90\xb8",
	"1-34-89" => "\xe6\xbf\x81",
	"1-34-90" => "\xe8\xab\xbe",
	"1-34-91" => "\xe8\x8c\xb8",
	"1-34-92" => "\xe5\x87\xa7",
	"1-34-93" => "\xe8\x9b\xb8",
	"1-34-94" => "\xe5\x8f\xaa",
	"1-35-1" => "\xe5\x8f\xa9",
	"1-35-2" => "\xe4\xbd\x86",
	"1-35-3" => "\xe9\x81\x94",
	"1-35-4" => "\xe8\xbe\xb0",
	"1-35-5" => "\xe5\xa5\xaa",
	"1-35-6" => "\xe8\x84\xb1",
	"1-35-7" => "\xe5\xb7\xbd",
	"1-35-8" => "\xe7\xab\xaa",
	"1-35-9" => "\xe8\xbe\xbf",
	"1-35-10" => "\xe6\xa3\x9a",
	"1-35-11" => "\xe8\xb0\xb7",
	"1-35-12" => "\xe7\x8b\xb8",
	"1-35-13" => "\xe9\xb1\x88",
	"1-35-14" => "\xe6\xa8\xbd",
	"1-35-15" => "\xe8\xaa\xb0",
	"1-35-16" => "\xe4\xb8\xb9",
	"1-35-17" => "\xe5\x8d\x98",
	"1-35-18" => "\xe5\x98\x86",
	"1-35-19" => "\xe5\x9d\xa6",
	"1-35-20" => "\xe6\x8b\x85",
	"1-35-21" => "\xe6\x8e\xa2",
	"1-35-22" => "\xe6\x97\xa6",
	"1-35-23" => "\xe6\xad\x8e",
	"1-35-24" => "\xe6\xb7\xa1",
	"1-35-25" => "\xe6\xb9\x9b",
	"1-35-26" => "\xe7\x82\xad",
	"1-35-27" => "\xe7\x9f\xad",
	"1-35-28" => "\xe7\xab\xaf",
	"1-35-29" => "\xe7\xae\xaa",
	"1-35-30" => "\xe7\xb6\xbb",
	"1-35-31" => "\xe8\x80\xbd",
	"1-35-32" => "\xe8\x83\x86",
	"1-35-33" => "\xe8\x9b\x8b",
	"1-35-34" => "\xe8\xaa\x95",
	"1-35-35" => "\xe9\x8d\x9b",
	"1-35-36" => "\xe5\x9b\xa3",
	"1-35-37" => "\xe5\xa3\x87",
	"1-35-38" => "\xe5\xbc\xbe",
	"1-35-39" => "\xe6\x96\xad",
	"1-35-40" => "\xe6\x9a\x96",
	"1-35-41" => "\xe6\xaa\x80",
	"1-35-42" => "\xe6\xae\xb5",
	"1-35-43" => "\xe7\x94\xb7",
	"1-35-44" => "\xe8\xab\x87",
	"1-35-45" => "\xe5\x80\xa4",
	"1-35-46" => "\xe7\x9f\xa5",
	"1-35-47" => "\xe5\x9c\xb0",
	"1-35-48" => "\xe5\xbc\x9b",
	"1-35-49" => "\xe6\x81\xa5",
	"1-35-50" => "\xe6\x99\xba",
	"1-35-51" => "\xe6\xb1\xa0",
	"1-35-52" => "\xe7\x97\xb4",
	"1-35-53" => "\xe7\xa8\x9a",
	"1-35-54" => "\xe7\xbd\xae",
	"1-35-55" => "\xe8\x87\xb4",
	"1-35-56" => "\xe8\x9c\x98",
	"1-35-57" => "\xe9\x81\x85",
	"1-35-58" => "\xe9\xa6\xb3",
	"1-35-59" => "\xe7\xaf\x89",
	"1-35-60" => "\xe7\x95\x9c",
	"1-35-61" => "\xe7\xab\xb9",
	"1-35-62" => "\xe7\xad\x91",
	"1-35-63" => "\xe8\x93\x84",
	"1-35-64" => "\xe9\x80\x90",
	"1-35-65" => "\xe7\xa7\xa9",
	"1-35-66" => "\xe7\xaa\x92",
	"1-35-67" => "\xe8\x8c\xb6",
	"1-35-68" => "\xe5\xab\xa1",
	"1-35-69" => "\xe7\x9d\x80",
	"1-35-70" => "\xe4\xb8\xad",
	"1-35-71" => "\xe4\xbb\xb2",
	"1-35-72" => "\xe5\xae\x99",
	"1-35-73" => "\xe5\xbf\xa0",
	"1-35-74" => "\xe6\x8a\xbd",
	"1-35-75" => "\xe6\x98\xbc",
	"1-35-76" => "\xe6\x9f\xb1",
	"1-35-77" => "\xe6\xb3\xa8",
	"1-35-78" => "\xe8\x99\xab",
	"1-35-79" => "\xe8\xa1\xb7",
	"1-35-80" => "\xe8\xa8\xbb",
	"1-35-81" => "\xe9\x85\x8e",
	"1-35-82" => "\xe9\x8b\xb3",
	"1-35-83" => "\xe9\xa7\x90",
	"1-35-84" => "\xe6\xa8\x97",
	"1-35-85" => "\xe7\x80\xa6",
	"1-35-86" => "\xe7\x8c\xaa",
	"1-35-87" => "\xe8\x8b\xa7",
	"1-35-88" => "\xe8\x91\x97",
	"1-35-89" => "\xe8\xb2\xaf",
	"1-35-90" => "\xe4\xb8\x81",
	"1-35-91" => "\xe5\x85\x86",
	"1-35-92" => "\xe5\x87\x8b",
	"1-35-93" => "\xe5\x96\x8b",
	"1-35-94" => "\xe5\xaf\xb5",
	"1-36-1" => "\xe5\xb8\x96",
	"1-36-2" => "\xe5\xb8\xb3",
	"1-36-3" => "\xe5\xba\x81",
	"1-36-4" => "\xe5\xbc\x94",
	"1-36-5" => "\xe5\xbc\xb5",
	"1-36-6" => "\xe5\xbd\xab",
	"1-36-7" => "\xe5\xbe\xb4",
	"1-36-8" => "\xe6\x87\xb2",
	"1-36-9" => "\xe6\x8c\x91",
	"1-36-10" => "\xe6\x9a\xa2",
	"1-36-11" => "\xe6\x9c\x9d",
	"1-36-12" => "\xe6\xbd\xae",
	"1-36-13" => "\xe7\x89\x92",
	"1-36-14" => "\xe7\x94\xba",
	"1-36-15" => "\xe7\x9c\xba",
	"1-36-16" => "\xe8\x81\xb4",
	"1-36-17" => "\xe8\x84\xb9",
	"1-36-18" => "\xe8\x85\xb8",
	"1-36-19" => "\xe8\x9d\xb6",
	"1-36-20" => "\xe8\xaa\xbf",
	"1-36-21" => "\xe8\xab\x9c",
	"1-36-22" => "\xe8\xb6\x85",
	"1-36-23" => "\xe8\xb7\xb3",
	"1-36-24" => "\xe9\x8a\x9a",
	"1-36-25" => "\xe9\x95\xb7",
	"1-36-26" => "\xe9\xa0\x82",
	"1-36-27" => "\xe9\xb3\xa5",
	"1-36-28" => "\xe5\x8b\x85",
	"1-36-29" => "\xe6\x8d\x97",
	"1-36-30" => "\xe7\x9b\xb4",
	"1-36-31" => "\xe6\x9c\x95",
	"1-36-32" => "\xe6\xb2\x88",
	"1-36-33" => "\xe7\x8f\x8d",
	"1-36-34" => "\xe8\xb3\x83",
	"1-36-35" => "\xe9\x8e\xae",
	"1-36-36" => "\xe9\x99\xb3",
	"1-36-37" => "\xe6\xb4\xa5",
	"1-36-38" => "\xe5\xa2\x9c",
	"1-36-39" => "\xe6\xa4\x8e",
	"1-36-40" => "\xe6\xa7\x8c",
	"1-36-41" => "\xe8\xbf\xbd",
	"1-36-42" => "\xe9\x8e\x9a",
	"1-36-43" => "\xe7\x97\x9b",
	"1-36-44" => "\xe9\x80\x9a",
	"1-36-45" => "\xe5\xa1\x9a",
	"1-36-46" => "\xe6\xa0\x82",
	"1-36-47" => "\xe6\x8e\xb4",
	"1-36-48" => "\xe6\xa7\xbb",
	"1-36-49" => "\xe4\xbd\x83",
	"1-36-50" => "\xe6\xbc\xac",
	"1-36-51" => "\xe6\x9f\x98",
	"1-36-52" => "\xe8\xbe\xbb",
	"1-36-53" => "\xe8\x94\xa6",
	"1-36-54" => "\xe7\xb6\xb4",
	"1-36-55" => "\xe9\x8d\x94",
	"1-36-56" => "\xe6\xa4\xbf",
	"1-36-57" => "\xe6\xbd\xb0",
	"1-36-58" => "\xe5\x9d\xaa",
	"1-36-59" => "\xe5\xa3\xb7",
	"1-36-60" => "\xe5\xac\xac",
	"1-36-61" => "\xe7\xb4\xac",
	"1-36-62" => "\xe7\x88\xaa",
	"1-36-63" => "\xe5\x90\x8a",
	"1-36-64" => "\xe9\x87\xa3",
	"1-36-65" => "\xe9\xb6\xb4",
	"1-36-66" => "\xe4\xba\xad",
	"1-36-67" => "\xe4\xbd\x8e",
	"1-36-68" => "\xe5\x81\x9c",
	"1-36-69" => "\xe5\x81\xb5",
	"1-36-70" => "\xe5\x89\x83",
	"1-36-71" => "\xe8\xb2\x9e",
	"1-36-72" => "\xe5\x91\x88",
	"1-36-73" => "\xe5\xa0\xa4",
	"1-36-74" => "\xe5\xae\x9a",
	"1-36-75" => "\xe5\xb8\x9d",
	"1-36-76" => "\xe5\xba\x95",
	"1-36-77" => "\xe5\xba\xad",
	"1-36-78" => "\xe5\xbb\xb7",
	"1-36-79" => "\xe5\xbc\x9f",
	"1-36-80" => "\xe6\x82\x8c",
	"1-36-81" => "\xe6\x8a\xb5",
	"1-36-82" => "\xe6\x8c\xba",
	"1-36-83" => "\xe6\x8f\x90",
	"1-36-84" => "\xe6\xa2\xaf",
	"1-36-85" => "\xe6\xb1\x80",
	"1-36-86" => "\xe7\xa2\x87",
	"1-36-87" => "\xe7\xa6\x8e",
	"1-36-88" => "\xe7\xa8\x8b",
	"1-36-89" => "\xe7\xb7\xa0",
	"1-36-90" => "\xe8\x89\x87",
	"1-36-91" => "\xe8\xa8\x82",
	"1-36-92" => "\xe8\xab\xa6",
	"1-36-93" => "\xe8\xb9\x84",
	"1-36-94" => "\xe9\x80\x93",
	"1-37-1" => "\xe9\x82\xb8",
	"1-37-2" => "\xe9\x84\xad",
	"1-37-3" => "\xe9\x87\x98",
	"1-37-4" => "\xe9\xbc\x8e",
	"1-37-5" => "\xe6\xb3\xa5",
	"1-37-6" => "\xe6\x91\x98",
	"1-37-7" => "\xe6\x93\xa2",
	"1-37-8" => "\xe6\x95\xb5",
	"1-37-9" => "\xe6\xbb\xb4",
	"1-37-10" => "\xe7\x9a\x84",
	"1-37-11" => "\xe7\xac\x9b",
	"1-37-12" => "\xe9\x81\xa9",
	"1-37-13" => "\xe9\x8f\x91",
	"1-37-14" => "\xe6\xba\xba",
	"1-37-15" => "\xe5\x93\xb2",
	"1-37-16" => "\xe5\xbe\xb9",
	"1-37-17" => "\xe6\x92\xa4",
	"1-37-18" => "\xe8\xbd\x8d",
	"1-37-19" => "\xe8\xbf\xad",
	"1-37-20" => "\xe9\x89\x84",
	"1-37-21" => "\xe5\x85\xb8",
	"1-37-22" => "\xe5\xa1\xab",
	"1-37-23" => "\xe5\xa4\xa9",
	"1-37-24" => "\xe5\xb1\x95",
	"1-37-25" => "\xe5\xba\x97",
	"1-37-26" => "\xe6\xb7\xbb",
	"1-37-27" => "\xe7\xba\x8f",
	"1-37-28" => "\xe7\x94\x9c",
	"1-37-29" => "\xe8\xb2\xbc",
	"1-37-30" => "\xe8\xbb\xa2",
	"1-37-31" => "\xe9\xa1\x9b",
	"1-37-32" => "\xe7\x82\xb9",
	"1-37-33" => "\xe4\xbc\x9d",
	"1-37-34" => "\xe6\xae\xbf",
	"1-37-35" => "\xe6\xbe\xb1",
	"1-37-36" => "\xe7\x94\xb0",
	"1-37-37" => "\xe9\x9b\xbb",
	"1-37-38" => "\xe5\x85\x8e",
	"1-37-39" => "\xe5\x90\x90",
	"1-37-40" => "\xe5\xa0\xb5",
	"1-37-41" => "\xe5\xa1\x97",
	"1-37-42" => "\xe5\xa6\xac",
	"1-37-43" => "\xe5\xb1\xa0",
	"1-37-44" => "\xe5\xbe\x92",
	"1-37-45" => "\xe6\x96\x97",
	"1-37-46" => "\xe6\x9d\x9c",
	"1-37-47" => "\xe6\xb8\xa1",
	"1-37-48" => "\xe7\x99\xbb",
	"1-37-49" => "\xe8\x8f\x9f",
	"1-37-50" => "\xe8\xb3\xad",
	"1-37-51" => "\xe9\x80\x94",
	"1-37-52" => "\xe9\x83\xbd",
	"1-37-53" => "\xe9\x8d\x8d",
	"1-37-54" => "\xe7\xa0\xa5",
	"1-37-55" => "\xe7\xa0\xba",
	"1-37-56" => "\xe5\x8a\xaa",
	"1-37-57" => "\xe5\xba\xa6",
	"1-37-58" => "\xe5\x9c\x9f",
	"1-37-59" => "\xe5\xa5\xb4",
	"1-37-60" => "\xe6\x80\x92",
	"1-37-61" => "\xe5\x80\x92",
	"1-37-62" => "\xe5\x85\x9a",
	"1-37-63" => "\xe5\x86\xac",
	"1-37-64" => "\xe5\x87\x8d",
	"1-37-65" => "\xe5\x88\x80",
	"1-37-66" => "\xe5\x94\x90",
	"1-37-67" => "\xe5\xa1\x94",
	"1-37-68" => "\xe5\xa1\x98",
	"1-37-69" => "\xe5\xa5\x97",
	"1-37-70" => "\xe5\xae\x95",
	"1-37-71" => "\xe5\xb3\xb6",
	"1-37-72" => "\xe5\xb6\x8b",
	"1-37-73" => "\xe6\x82\xbc",
	"1-37-74" => "\xe6\x8a\x95",
	"1-37-75" => "\xe6\x90\xad",
	"1-37-76" => "\xe6\x9d\xb1",
	"1-37-77" => "\xe6\xa1\x83",
	"1-37-78" => "\xe6\xa2\xbc",
	"1-37-79" => "\xe6\xa3\x9f",
	"1-37-80" => "\xe7\x9b\x97",
	"1-37-81" => "\xe6\xb7\x98",
	"1-37-82" => "\xe6\xb9\xaf",
	"1-37-83" => "\xe6\xb6\x9b",
	"1-37-84" => "\xe7\x81\xaf",
	"1-37-85" => "\xe7\x87\x88",
	"1-37-86" => "\xe5\xbd\x93",
	"1-37-87" => "\xe7\x97\x98",
	"1-37-88" => "\xe7\xa5\xb7",
	"1-37-89" => "\xe7\xad\x89",
	"1-37-90" => "\xe7\xad\x94",
	"1-37-91" => "\xe7\xad\x92",
	"1-37-92" => "\xe7\xb3\x96",
	"1-37-93" => "\xe7\xb5\xb1",
	"1-37-94" => "\xe5\x88\xb0",
	"1-38-1" => "\xe8\x91\xa3",
	"1-38-2" => "\xe8\x95\xa9",
	"1-38-3" => "\xe8\x97\xa4",
	"1-38-4" => "\xe8\xa8\x8e",
	"1-38-5" => "\xe8\xac\x84",
	"1-38-6" => "\xe8\xb1\x86",
	"1-38-7" => "\xe8\xb8\x8f",
	"1-38-8" => "\xe9\x80\x83",
	"1-38-9" => "\xe9\x80\x8f",
	"1-38-10" => "\xe9\x90\x99",
	"1-38-11" => "\xe9\x99\xb6",
	"1-38-12" => "\xe9\xa0\xad",
	"1-38-13" => "\xe9\xa8\xb0",
	"1-38-14" => "\xe9\x97\x98",
	"1-38-15" => "\xe5\x83\x8d",
	"1-38-16" => "\xe5\x8b\x95",
	"1-38-17" => "\xe5\x90\x8c",
	"1-38-18" => "\xe5\xa0\x82",
	"1-38-19" => "\xe5\xb0\x8e",
	"1-38-20" => "\xe6\x86\xa7",
	"1-38-21" => "\xe6\x92\x9e",
	"1-38-22" => "\xe6\xb4\x9e",
	"1-38-23" => "\xe7\x9e\xb3",
	"1-38-24" => "\xe7\xab\xa5",
	"1-38-25" => "\xe8\x83\xb4",
	"1-38-26" => "\xe8\x90\x84",
	"1-38-27" => "\xe9\x81\x93",
	"1-38-28" => "\xe9\x8a\x85",
	"1-38-29" => "\xe5\xb3\xa0",
	"1-38-30" => "\xe9\xb4\x87",
	"1-38-31" => "\xe5\x8c\xbf",
	"1-38-32" => "\xe5\xbe\x97",
	"1-38-33" => "\xe5\xbe\xb3",
	"1-38-34" => "\xe6\xb6\x9c",
	"1-38-35" => "\xe7\x89\xb9",
	"1-38-36" => "\xe7\x9d\xa3",
	"1-38-37" => "\xe7\xa6\xbf",
	"1-38-38" => "\xe7\xaf\xa4",
	"1-38-39" => "\xe6\xaf\x92",
	"1-38-40" => "\xe7\x8b\xac",
	"1-38-41" => "\xe8\xaa\xad",
	"1-38-42" => "\xe6\xa0\x83",
	"1-38-43" => "\xe6\xa9\xa1",
	"1-38-44" => "\xe5\x87\xb8",
	"1-38-45" => "\xe7\xaa\x81",
	"1-38-46" => "\xe6\xa4\xb4",
	"1-38-47" => "\xe5\xb1\x8a",
	"1-38-48" => "\xe9\xb3\xb6",
	"1-38-49" => "\xe8\x8b\xab",
	"1-38-50" => "\xe5\xaf\x85",
	"1-38-51" => "\xe9\x85\x89",
	"1-38-52" => "\xe7\x80\x9e",
	"1-38-53" => "\xe5\x99\xb8",
	"1-38-54" => "\xe5\xb1\xaf",
	"1-38-55" => "\xe6\x83\x87",
	"1-38-56" => "\xe6\x95\xa6",
	"1-38-57" => "\xe6\xb2\x8c",
	"1-38-58" => "\xe8\xb1\x9a",
	"1-38-59" => "\xe9\x81\x81",
	"1-38-60" => "\xe9\xa0\x93",
	"1-38-61" => "\xe5\x91\x91",
	"1-38-62" => "\xe6\x9b\x87",
	"1-38-63" => "\xe9\x88\x8d",
	"1-38-64" => "\xe5\xa5\x88",
	"1-38-65" => "\xe9\x82\xa3",
	"1-38-66" => "\xe5\x86\x85",
	"1-38-67" => "\xe4\xb9\x8d",
	"1-38-68" => "\xe5\x87\xaa",
	"1-38-69" => "\xe8\x96\x99",
	"1-38-70" => "\xe8\xac\x8e",
	"1-38-71" => "\xe7\x81\x98",
	"1-38-72" => "\xe6\x8d\xba",
	"1-38-73" => "\xe9\x8d\x8b",
	"1-38-74" => "\xe6\xa5\xa2",
	"1-38-75" => "\xe9\xa6\xb4",
	"1-38-76" => "\xe7\xb8\x84",
	"1-38-77" => "\xe7\x95\xb7",
	"1-38-78" => "\xe5\x8d\x97",
	"1-38-79" => "\xe6\xa5\xa0",
	"1-38-80" => "\xe8\xbb\x9f",
	"1-38-81" => "\xe9\x9b\xa3",
	"1-38-82" => "\xe6\xb1\x9d",
	"1-38-83" => "\xe4\xba\x8c",
	"1-38-84" => "\xe5\xb0\xbc",
	"1-38-85" => "\xe5\xbc\x90",
	"1-38-86" => "\xe8\xbf\xa9",
	"1-38-87" => "\xe5\x8c\x82",
	"1-38-88" => "\xe8\xb3\x91",
	"1-38-89" => "\xe8\x82\x89",
	"1-38-90" => "\xe8\x99\xb9",
	"1-38-91" => "\xe5\xbb\xbf",
	"1-38-92" => "\xe6\x97\xa5",
	"1-38-93" => "\xe4\xb9\xb3",
	"1-38-94" => "\xe5\x85\xa5",
	"1-39-1" => "\xe5\xa6\x82",
	"1-39-2" => "\xe5\xb0\xbf",
	"1-39-3" => "\xe9\x9f\xae",
	"1-39-4" => "\xe4\xbb\xbb",
	"1-39-5" => "\xe5\xa6\x8a",
	"1-39-6" => "\xe5\xbf\x8d",
	"1-39-7" => "\xe8\xaa\x8d",
	"1-39-8" => "\xe6\xbf\xa1",
	"1-39-9" => "\xe7\xa6\xb0",
	"1-39-10" => "\xe7\xa5\xa2",
	"1-39-11" => "\xe5\xaf\xa7",
	"1-39-12" => "\xe8\x91\xb1",
	"1-39-13" => "\xe7\x8c\xab",
	"1-39-14" => "\xe7\x86\xb1",
	"1-39-15" => "\xe5\xb9\xb4",
	"1-39-16" => "\xe5\xbf\xb5",
	"1-39-17" => "\xe6\x8d\xbb",
	"1-39-18" => "\xe6\x92\x9a",
	"1-39-19" => "\xe7\x87\x83",
	"1-39-20" => "\xe7\xb2\x98",
	"1-39-21" => "\xe4\xb9\x83",
	"1-39-22" => "\xe5\xbb\xbc",
	"1-39-23" => "\xe4\xb9\x8b",
	"1-39-24" => "\xe5\x9f\x9c",
	"1-39-25" => "\xe5\x9a\xa2",
	"1-39-26" => "\xe6\x82\xa9",
	"1-39-27" => "\xe6\xbf\x83",
	"1-39-28" => "\xe7\xb4\x8d",
	"1-39-29" => "\xe8\x83\xbd",
	"1-39-30" => "\xe8\x84\xb3",
	"1-39-31" => "\xe8\x86\xbf",
	"1-39-32" => "\xe8\xbe\xb2",
	"1-39-33" => "\xe8\xa6\x97",
	"1-39-34" => "\xe8\x9a\xa4",
	"1-39-35" => "\xe5\xb7\xb4",
	"1-39-36" => "\xe6\x8a\x8a",
	"1-39-37" => "\xe6\x92\xad",
	"1-39-38" => "\xe8\xa6\x87",
	"1-39-39" => "\xe6\x9d\xb7",
	"1-39-40" => "\xe6\xb3\xa2",
	"1-39-41" => "\xe6\xb4\xbe",
	"1-39-42" => "\xe7\x90\xb6",
	"1-39-43" => "\xe7\xa0\xb4",
	"1-39-44" => "\xe5\xa9\x86",
	"1-39-45" => "\xe7\xbd\xb5",
	"1-39-46" => "\xe8\x8a\xad",
	"1-39-47" => "\xe9\xa6\xac",
	"1-39-48" => "\xe4\xbf\xb3",
	"1-39-49" => "\xe5\xbb\x83",
	"1-39-50" => "\xe6\x8b\x9d",
	"1-39-51" => "\xe6\x8e\x92",
	"1-39-52" => "\xe6\x95\x97",
	"1-39-53" => "\xe6\x9d\xaf",
	"1-39-54" => "\xe7\x9b\x83",
	"1-39-55" => "\xe7\x89\x8c",
	"1-39-56" => "\xe8\x83\x8c",
	"1-39-57" => "\xe8\x82\xba",
	"1-39-58" => "\xe8\xbc\xa9",
	"1-39-59" => "\xe9\x85\x8d",
	"1-39-60" => "\xe5\x80\x8d",
	"1-39-61" => "\xe5\x9f\xb9",
	"1-39-62" => "\xe5\xaa\x92",
	"1-39-63" => "\xe6\xa2\x85",
	"1-39-64" => "\xe6\xa5\xb3",
	"1-39-65" => "\xe7\x85\xa4",
	"1-39-66" => "\xe7\x8b\xbd",
	"1-39-67" => "\xe8\xb2\xb7",
	"1-39-68" => "\xe5\xa3\xb2",
	"1-39-69" => "\xe8\xb3\xa0",
	"1-39-70" => "\xe9\x99\xaa",
	"1-39-71" => "\xe9\x80\x99",
	"1-39-72" => "\xe8\x9d\xbf",
	"1-39-73" => "\xe7\xa7\xa4",
	"1-39-74" => "\xe7\x9f\xa7",
	"1-39-75" => "\xe8\x90\xa9",
	"1-39-76" => "\xe4\xbc\xaf",
	"1-39-77" => "\xe5\x89\xa5",
	"1-39-78" => "\xe5\x8d\x9a",
	"1-39-79" => "\xe6\x8b\x8d",
	"1-39-80" => "\xe6\x9f\x8f",
	"1-39-81" => "\xe6\xb3\x8a",
	"1-39-82" => "\xe7\x99\xbd",
	"1-39-83" => "\xe7\xae\x94",
	"1-39-84" => "\xe7\xb2\x95",
	"1-39-85" => "\xe8\x88\xb6",
	"1-39-86" => "\xe8\x96\x84",
	"1-39-87" => "\xe8\xbf\xab",
	"1-39-88" => "\xe6\x9b\x9d",
	"1-39-89" => "\xe6\xbc\xa0",
	"1-39-90" => "\xe7\x88\x86",
	"1-39-91" => "\xe7\xb8\x9b",
	"1-39-92" => "\xe8\x8e\xab",
	"1-39-93" => "\xe9\xa7\x81",
	"1-39-94" => "\xe9\xba\xa6",
	"1-40-1" => "\xe5\x87\xbd",
	"1-40-2" => "\xe7\xae\xb1",
	"1-40-3" => "\xe7\xa1\xb2",
	"1-40-4" => "\xe7\xae\xb8",
	"1-40-5" => "\xe8\x82\x87",
	"1-40-6" => "\xe7\xad\x88",
	"1-40-7" => "\xe6\xab\xa8",
	"1-40-8" => "\xe5\xb9\xa1",
	"1-40-9" => "\xe8\x82\x8c",
	"1-40-10" => "\xe7\x95\x91",
	"1-40-11" => "\xe7\x95\xa0",
	"1-40-12" => "\xe5\x85\xab",
	"1-40-13" => "\xe9\x89\xa2",
	"1-40-14" => "\xe6\xba\x8c",
	"1-40-15" => "\xe7\x99\xba",
	"1-40-16" => "\xe9\x86\x97",
	"1-40-17" => "\xe9\xab\xaa",
	"1-40-18" => "\xe4\xbc\x90",
	"1-40-19" => "\xe7\xbd\xb0",
	"1-40-20" => "\xe6\x8a\x9c",
	"1-40-21" => "\xe7\xad\x8f",
	"1-40-22" => "\xe9\x96\xa5",
	"1-40-23" => "\xe9\xb3\xa9",
	"1-40-24" => "\xe5\x99\xba",
	"1-40-25" => "\xe5\xa1\x99",
	"1-40-26" => "\xe8\x9b\xa4",
	"1-40-27" => "\xe9\x9a\xbc",
	"1-40-28" => "\xe4\xbc\xb4",
	"1-40-29" => "\xe5\x88\xa4",
	"1-40-30" => "\xe5\x8d\x8a",
	"1-40-31" => "\xe5\x8f\x8d",
	"1-40-32" => "\xe5\x8f\x9b",
	"1-40-33" => "\xe5\xb8\x86",
	"1-40-34" => "\xe6\x90\xac",
	"1-40-35" => "\xe6\x96\x91",
	"1-40-36" => "\xe6\x9d\xbf",
	"1-40-37" => "\xe6\xb0\xbe",
	"1-40-38" => "\xe6\xb1\x8e",
	"1-40-39" => "\xe7\x89\x88",
	"1-40-40" => "\xe7\x8a\xaf",
	"1-40-41" => "\xe7\x8f\xad",
	"1-40-42" => "\xe7\x95\x94",
	"1-40-43" => "\xe7\xb9\x81",
	"1-40-44" => "\xe8\x88\xac",
	"1-40-45" => "\xe8\x97\xa9",
	"1-40-46" => "\xe8\xb2\xa9",
	"1-40-47" => "\xe7\xaf\x84",
	"1-40-48" => "\xe9\x87\x86",
	"1-40-49" => "\xe7\x85\xa9",
	"1-40-50" => "\xe9\xa0\x92",
	"1-40-51" => "\xe9\xa3\xaf",
	"1-40-52" => "\xe6\x8c\xbd",
	"1-40-53" => "\xe6\x99\xa9",
	"1-40-54" => "\xe7\x95\xaa",
	"1-40-55" => "\xe7\x9b\xa4",
	"1-40-56" => "\xe7\xa3\x90",
	"1-40-57" => "\xe8\x95\x83",
	"1-40-58" => "\xe8\x9b\xae",
	"1-40-59" => "\xe5\x8c\xaa",
	"1-40-60" => "\xe5\x8d\x91",
	"1-40-61" => "\xe5\x90\xa6",
	"1-40-62" => "\xe5\xa6\x83",
	"1-40-63" => "\xe5\xba\x87",
	"1-40-64" => "\xe5\xbd\xbc",
	"1-40-65" => "\xe6\x82\xb2",
	"1-40-66" => "\xe6\x89\x89",
	"1-40-67" => "\xe6\x89\xb9",
	"1-40-68" => "\xe6\x8a\xab",
	"1-40-69" => "\xe6\x96\x90",
	"1-40-70" => "\xe6\xaf\x94",
	"1-40-71" => "\xe6\xb3\x8c",
	"1-40-72" => "\xe7\x96\xb2",
	"1-40-73" => "\xe7\x9a\xae",
	"1-40-74" => "\xe7\xa2\x91",
	"1-40-75" => "\xe7\xa7\x98",
	"1-40-76" => "\xe7\xb7\x8b",
	"1-40-77" => "\xe7\xbd\xb7",
	"1-40-78" => "\xe8\x82\xa5",
	"1-40-79" => "\xe8\xa2\xab",
	"1-40-80" => "\xe8\xaa\xb9",
	"1-40-81" => "\xe8\xb2\xbb",
	"1-40-82" => "\xe9\x81\xbf",
	"1-40-83" => "\xe9\x9d\x9e",
	"1-40-84" => "\xe9\xa3\x9b",
	"1-40-85" => "\xe6\xa8\x8b",
	"1-40-86" => "\xe7\xb0\xb8",
	"1-40-87" => "\xe5\x82\x99",
	"1-40-88" => "\xe5\xb0\xbe",
	"1-40-89" => "\xe5\xbe\xae",
	"1-40-90" => "\xe6\x9e\x87",
	"1-40-91" => "\xe6\xaf\x98",
	"1-40-92" => "\xe7\x90\xb5",
	"1-40-93" => "\xe7\x9c\x89",
	"1-40-94" => "\xe7\xbe\x8e",
	"1-41-1" => "\xe9\xbc\xbb",
	"1-41-2" => "\xe6\x9f\x8a",
	"1-41-3" => "\xe7\xa8\x97",
	"1-41-4" => "\xe5\x8c\xb9",
	"1-41-5" => "\xe7\x96\x8b",
	"1-41-6" => "\xe9\xab\xad",
	"1-41-7" => "\xe5\xbd\xa6",
	"1-41-8" => "\xe8\x86\x9d",
	"1-41-9" => "\xe8\x8f\xb1",
	"1-41-10" => "\xe8\x82\x98",
	"1-41-11" => "\xe5\xbc\xbc",
	"1-41-12" => "\xe5\xbf\x85",
	"1-41-13" => "\xe7\x95\xa2",
	"1-41-14" => "\xe7\xad\x86",
	"1-41-15" => "\xe9\x80\xbc",
	"1-41-16" => "\xe6\xa1\xa7",
	"1-41-17" => "\xe5\xa7\xab",
	"1-41-18" => "\xe5\xaa\x9b",
	"1-41-19" => "\xe7\xb4\x90",
	"1-41-20" => "\xe7\x99\xbe",
	"1-41-21" => "\xe8\xac\xac",
	"1-41-22" => "\xe4\xbf\xb5",
	"1-41-23" => "\xe5\xbd\xaa",
	"1-41-24" => "\xe6\xa8\x99",
	"1-41-25" => "\xe6\xb0\xb7",
	"1-41-26" => "\xe6\xbc\x82",
	"1-41-27" => "\xe7\x93\xa2",
	"1-41-28" => "\xe7\xa5\xa8",
	"1-41-29" => "\xe8\xa1\xa8",
	"1-41-30" => "\xe8\xa9\x95",
	"1-41-31" => "\xe8\xb1\xb9",
	"1-41-32" => "\xe5\xbb\x9f",
	"1-41-33" => "\xe6\x8f\x8f",
	"1-41-34" => "\xe7\x97\x85",
	"1-41-35" => "\xe7\xa7\x92",
	"1-41-36" => "\xe8\x8b\x97",
	"1-41-37" => "\xe9\x8c\xa8",
	"1-41-38" => "\xe9\x8b\xb2",
	"1-41-39" => "\xe8\x92\x9c",
	"1-41-40" => "\xe8\x9b\xad",
	"1-41-41" => "\xe9\xb0\xad",
	"1-41-42" => "\xe5\x93\x81",
	"1-41-43" => "\xe5\xbd\xac",
	"1-41-44" => "\xe6\x96\x8c",
	"1-41-45" => "\xe6\xb5\x9c",
	"1-41-46" => "\xe7\x80\x95",
	"1-41-47" => "\xe8\xb2\xa7",
	"1-41-48" => "\xe8\xb3\x93",
	"1-41-49" => "\xe9\xa0\xbb",
	"1-41-50" => "\xe6\x95\x8f",
	"1-41-51" => "\xe7\x93\xb6",
	"1-41-52" => "\xe4\xb8\x8d",
	"1-41-53" => "\xe4\xbb\x98",
	"1-41-54" => "\xe5\x9f\xa0",
	"1-41-55" => "\xe5\xa4\xab",
	"1-41-56" => "\xe5\xa9\xa6",
	"1-41-57" => "\xe5\xaf\x8c",
	"1-41-58" => "\xe5\x86\xa8",
	"1-41-59" => "\xe5\xb8\x83",
	"1-41-60" => "\xe5\xba\x9c",
	"1-41-61" => "\xe6\x80\x96",
	"1-41-62" => "\xe6\x89\xb6",
	"1-41-63" => "\xe6\x95\xb7",
	"1-41-64" => "\xe6\x96\xa7",
	"1-41-65" => "\xe6\x99\xae",
	"1-41-66" => "\xe6\xb5\xae",
	"1-41-67" => "\xe7\x88\xb6",
	"1-41-68" => "\xe7\xac\xa6",
	"1-41-69" => "\xe8\x85\x90",
	"1-41-70" => "\xe8\x86\x9a",
	"1-41-71" => "\xe8\x8a\x99",
	"1-41-72" => "\xe8\xad\x9c",
	"1-41-73" => "\xe8\xb2\xa0",
	"1-41-74" => "\xe8\xb3\xa6",
	"1-41-75" => "\xe8\xb5\xb4",
	"1-41-76" => "\xe9\x98\x9c",
	"1-41-77" => "\xe9\x99\x84",
	"1-41-78" => "\xe4\xbe\xae",
	"1-41-79" => "\xe6\x92\xab",
	"1-41-80" => "\xe6\xad\xa6",
	"1-41-81" => "\xe8\x88\x9e",
	"1-41-82" => "\xe8\x91\xa1",
	"1-41-83" => "\xe8\x95\xaa",
	"1-41-84" => "\xe9\x83\xa8",
	"1-41-85" => "\xe5\xb0\x81",
	"1-41-86" => "\xe6\xa5\x93",
	"1-41-87" => "\xe9\xa2\xa8",
	"1-41-88" => "\xe8\x91\xba",
	"1-41-89" => "\xe8\x95\x97",
	"1-41-90" => "\xe4\xbc\x8f",
	"1-41-91" => "\xe5\x89\xaf",
	"1-41-92" => "\xe5\xbe\xa9",
	"1-41-93" => "\xe5\xb9\x85",
	"1-41-94" => "\xe6\x9c\x8d",
	"1-42-1" => "\xe7\xa6\x8f",
	"1-42-2" => "\xe8\x85\xb9",
	"1-42-3" => "\xe8\xa4\x87",
	"1-42-4" => "\xe8\xa6\x86",
	"1-42-5" => "\xe6\xb7\xb5",
	"1-42-6" => "\xe5\xbc\x97",
	"1-42-7" => "\xe6\x89\x95",
	"1-42-8" => "\xe6\xb2\xb8",
	"1-42-9" => "\xe4\xbb\x8f",
	"1-42-10" => "\xe7\x89\xa9",
	"1-42-11" => "\xe9\xae\x92",
	"1-42-12" => "\xe5\x88\x86",
	"1-42-13" => "\xe5\x90\xbb",
	"1-42-14" => "\xe5\x99\xb4",
	"1-42-15" => "\xe5\xa2\xb3",
	"1-42-16" => "\xe6\x86\xa4",
	"1-42-17" => "\xe6\x89\xae",
	"1-42-18" => "\xe7\x84\x9a",
	"1-42-19" => "\xe5\xa5\xae",
	"1-42-20" => "\xe7\xb2\x89",
	"1-42-21" => "\xe7\xb3\x9e",
	"1-42-22" => "\xe7\xb4\x9b",
	"1-42-23" => "\xe9\x9b\xb0",
	"1-42-24" => "\xe6\x96\x87",
	"1-42-25" => "\xe8\x81\x9e",
	"1-42-26" => "\xe4\xb8\x99",
	"1-42-27" => "\xe4\xbd\xb5",
	"1-42-28" => "\xe5\x85\xb5",
	"1-42-29" => "\xe5\xa1\x80",
	"1-42-30" => "\xe5\xb9\xa3",
	"1-42-31" => "\xe5\xb9\xb3",
	"1-42-32" => "\xe5\xbc\x8a",
	"1-42-33" => "\xe6\x9f\x84",
	"1-42-34" => "\xe4\xb8\xa6",
	"1-42-35" => "\xe8\x94\xbd",
	"1-42-36" => "\xe9\x96\x89",
	"1-42-37" => "\xe9\x99\x9b",
	"1-42-38" => "\xe7\xb1\xb3",
	"1-42-39" => "\xe9\xa0\x81",
	"1-42-40" => "\xe5\x83\xbb",
	"1-42-41" => "\xe5\xa3\x81",
	"1-42-42" => "\xe7\x99\x96",
	"1-42-43" => "\xe7\xa2\xa7",
	"1-42-44" => "\xe5\x88\xa5",
	"1-42-45" => "\xe7\x9e\xa5",
	"1-42-46" => "\xe8\x94\x91",
	"1-42-47" => "\xe7\xae\x86",
	"1-42-48" => "\xe5\x81\x8f",
	"1-42-49" => "\xe5\xa4\x89",
	"1-42-50" => "\xe7\x89\x87",
	"1-42-51" => "\xe7\xaf\x87",
	"1-42-52" => "\xe7\xb7\xa8",
	"1-42-53" => "\xe8\xbe\xba",
	"1-42-54" => "\xe8\xbf\x94",
	"1-42-55" => "\xe9\x81\x8d",
	"1-42-56" => "\xe4\xbe\xbf",
	"1-42-57" => "\xe5\x8b\x89",
	"1-42-58" => "\xe5\xa8\xa9",
	"1-42-59" => "\xe5\xbc\x81",
	"1-42-60" => "\xe9\x9e\xad",
	"1-42-61" => "\xe4\xbf\x9d",
	"1-42-62" => "\xe8\x88\x97",
	"1-42-63" => "\xe9\x8b\xaa",
	"1-42-64" => "\xe5\x9c\x83",
	"1-42-65" => "\xe6\x8d\x95",
	"1-42-66" => "\xe6\xad\xa9",
	"1-42-67" => "\xe7\x94\xab",
	"1-42-68" => "\xe8\xa3\x9c",
	"1-42-69" => "\xe8\xbc\x94",
	"1-42-70" => "\xe7\xa9\x82",
	"1-42-71" => "\xe5\x8b\x9f",
	"1-42-72" => "\xe5\xa2\x93",
	"1-42-73" => "\xe6\x85\x95",
	"1-42-74" => "\xe6\x88\x8a",
	"1-42-75" => "\xe6\x9a\xae",
	"1-42-76" => "\xe6\xaf\x8d",
	"1-42-77" => "\xe7\xb0\xbf",
	"1-42-78" => "\xe8\x8f\xa9",
	"1-42-79" => "\xe5\x80\xa3",
	"1-42-80" => "\xe4\xbf\xb8",
	"1-42-81" => "\xe5\x8c\x85",
	"1-42-82" => "\xe5\x91\x86",
	"1-42-83" => "\xe5\xa0\xb1",
	"1-42-84" => "\xe5\xa5\x89",
	"1-42-85" => "\xe5\xae\x9d",
	"1-42-86" => "\xe5\xb3\xb0",
	"1-42-87" => "\xe5\xb3\xaf",
	"1-42-88" => "\xe5\xb4\xa9",
	"1-42-89" => "\xe5\xba\x96",
	"1-42-90" => "\xe6\x8a\xb1",
	"1-42-91" => "\xe6\x8d\xa7",
	"1-42-92" => "\xe6\x94\xbe",
	"1-42-93" => "\xe6\x96\xb9",
	"1-42-94" => "\xe6\x9c\x8b",
	"1-43-1" => "\xe6\xb3\x95",
	"1-43-2" => "\xe6\xb3\xa1",
	"1-43-3" => "\xe7\x83\xb9",
	"1-43-4" => "\xe7\xa0\xb2",
	"1-43-5" => "\xe7\xb8\xab",
	"1-43-6" => "\xe8\x83\x9e",
	"1-43-7" => "\xe8\x8a\xb3",
	"1-43-8" => "\xe8\x90\x8c",
	"1-43-9" => "\xe8\x93\xac",
	"1-43-10" => "\xe8\x9c\x82",
	"1-43-11" => "\xe8\xa4\x92",
	"1-43-12" => "\xe8\xa8\xaa",
	"1-43-13" => "\xe8\xb1\x8a",
	"1-43-14" => "\xe9\x82\xa6",
	"1-43-15" => "\xe9\x8b\x92",
	"1-43-16" => "\xe9\xa3\xbd",
	"1-43-17" => "\xe9\xb3\xb3",
	"1-43-18" => "\xe9\xb5\xac",
	"1-43-19" => "\xe4\xb9\x8f",
	"1-43-20" => "\xe4\xba\xa1",
	"1-43-21" => "\xe5\x82\x8d",
	"1-43-22" => "\xe5\x89\x96",
	"1-43-23" => "\xe5\x9d\x8a",
	"1-43-24" => "\xe5\xa6\xa8",
	"1-43-25" => "\xe5\xb8\xbd",
	"1-43-26" => "\xe5\xbf\x98",
	"1-43-27" => "\xe5\xbf\x99",
	"1-43-28" => "\xe6\x88\xbf",
	"1-43-29" => "\xe6\x9a\xb4",
	"1-43-30" => "\xe6\x9c\x9b",
	"1-43-31" => "\xe6\x9f\x90",
	"1-43-32" => "\xe6\xa3\x92",
	"1-43-33" => "\xe5\x86\x92",
	"1-43-34" => "\xe7\xb4\xa1",
	"1-43-35" => "\xe8\x82\xaa",
	"1-43-36" => "\xe8\x86\xa8",
	"1-43-37" => "\xe8\xac\x80",
	"1-43-38" => "\xe8\xb2\x8c",
	"1-43-39" => "\xe8\xb2\xbf",
	"1-43-40" => "\xe9\x89\xbe",
	"1-43-41" => "\xe9\x98\xb2",
	"1-43-42" => "\xe5\x90\xa0",
	"1-43-43" => "\xe9\xa0\xac",
	"1-43-44" => "\xe5\x8c\x97",
	"1-43-45" => "\xe5\x83\x95",
	"1-43-46" => "\xe5\x8d\x9c",
	"1-43-47" => "\xe5\xa2\xa8",
	"1-43-48" => "\xe6\x92\xb2",
	"1-43-49" => "\xe6\x9c\xb4",
	"1-43-50" => "\xe7\x89\xa7",
	"1-43-51" => "\xe7\x9d\xa6",
	"1-43-52" => "\xe7\xa9\x86",
	"1-43-53" => "\xe9\x87\xa6",
	"1-43-54" => "\xe5\x8b\x83",
	"1-43-55" => "\xe6\xb2\xa1",
	"1-43-56" => "\xe6\xae\x86",
	"1-43-57" => "\xe5\xa0\x80",
	"1-43-58" => "\xe5\xb9\x8c",
	"1-43-59" => "\xe5\xa5\x94",
	"1-43-60" => "\xe6\x9c\xac",
	"1-43-61" => "\xe7\xbf\xbb",
	"1-43-62" => "\xe5\x87\xa1",
	"1-43-63" => "\xe7\x9b\x86",
	"1-43-64" => "\xe6\x91\xa9",
	"1-43-65" => "\xe7\xa3\xa8",
	"1-43-66" => "\xe9\xad\x94",
	"1-43-67" => "\xe9\xba\xbb",
	"1-43-68" => "\xe5\x9f\x8b",
	"1-43-69" => "\xe5\xa6\xb9",
	"1-43-70" => "\xe6\x98\xa7",
	"1-43-71" => "\xe6\x9e\x9a",
	"1-43-72" => "\xe6\xaf\x8e",
	"1-43-73" => "\xe5\x93\xa9",
	"1-43-74" => "\xe6\xa7\x99",
	"1-43-75" => "\xe5\xb9\x95",
	"1-43-76" => "\xe8\x86\x9c",
	"1-43-77" => "\xe6\x9e\x95",
	"1-43-78" => "\xe9\xae\xaa",
	"1-43-79" => "\xe6\x9f\xbe",
	"1-43-80" => "\xe9\xb1\x92",
	"1-43-81" => "\xe6\xa1\x9d",
	"1-43-82" => "\xe4\xba\xa6",
	"1-43-83" => "\xe4\xbf\xa3",
	"1-43-84" => "\xe5\x8f\x88",
	"1-43-85" => "\xe6\x8a\xb9",
	"1-43-86" => "\xe6\x9c\xab",
	"1-43-87" => "\xe6\xb2\xab",
	"1-43-88" => "\xe8\xbf\x84",
	"1-43-89" => "\xe4\xbe\xad",
	"1-43-90" => "\xe7\xb9\xad",
	"1-43-91" => "\xe9\xba\xbf",
	"1-43-92" => "\xe4\xb8\x87",
	"1-43-93" => "\xe6\x85\xa2",
	"1-43-94" => "\xe6\xba\x80",
	"1-44-1" => "\xe6\xbc\xab",
	"1-44-2" => "\xe8\x94\x93",
	"1-44-3" => "\xe5\x91\xb3",
	"1-44-4" => "\xe6\x9c\xaa",
	"1-44-5" => "\xe9\xad\x85",
	"1-44-6" => "\xe5\xb7\xb3",
	"1-44-7" => "\xe7\xae\x95",
	"1-44-8" => "\xe5\xb2\xac",
	"1-44-9" => "\xe5\xaf\x86",
	"1-44-10" => "\xe8\x9c\x9c",
	"1-44-11" => "\xe6\xb9\x8a",
	"1-44-12" => "\xe8\x93\x91",
	"1-44-13" => "\xe7\xa8\x94",
	"1-44-14" => "\xe8\x84\x88",
	"1-44-15" => "\xe5\xa6\x99",
	"1-44-16" => "\xe7\xb2\x8d",
	"1-44-17" => "\xe6\xb0\x91",
	"1-44-18" => "\xe7\x9c\xa0",
	"1-44-19" => "\xe5\x8b\x99",
	"1-44-20" => "\xe5\xa4\xa2",
	"1-44-21" => "\xe7\x84\xa1",
	"1-44-22" => "\xe7\x89\x9f",
	"1-44-23" => "\xe7\x9f\x9b",
	"1-44-24" => "\xe9\x9c\xa7",
	"1-44-25" => "\xe9\xb5\xa1",
	"1-44-26" => "\xe6\xa4\x8b",
	"1-44-27" => "\xe5\xa9\xbf",
	"1-44-28" => "\xe5\xa8\x98",
	"1-44-29" => "\xe5\x86\xa5",
	"1-44-30" => "\xe5\x90\x8d",
	"1-44-31" => "\xe5\x91\xbd",
	"1-44-32" => "\xe6\x98\x8e",
	"1-44-33" => "\xe7\x9b\x9f",
	"1-44-34" => "\xe8\xbf\xb7",
	"1-44-35" => "\xe9\x8a\x98",
	"1-44-36" => "\xe9\xb3\xb4",
	"1-44-37" => "\xe5\xa7\xaa",
	"1-44-38" => "\xe7\x89\x9d",
	"1-44-39" => "\xe6\xbb\x85",
	"1-44-40" => "\xe5\x85\x8d",
	"1-44-41" => "\xe6\xa3\x89",
	"1-44-42" => "\xe7\xb6\xbf",
	"1-44-43" => "\xe7\xb7\xac",
	"1-44-44" => "\xe9\x9d\xa2",
	"1-44-45" => "\xe9\xba\xba",
	"1-44-46" => "\xe6\x91\xb8",
	"1-44-47" => "\xe6\xa8\xa1",
	"1-44-48" => "\xe8\x8c\x82",
	"1-44-49" => "\xe5\xa6\x84",
	"1-44-50" => "\xe5\xad\x9f",
	"1-44-51" => "\xe6\xaf\x9b",
	"1-44-52" => "\xe7\x8c\x9b",
	"1-44-53" => "\xe7\x9b\xb2",
	"1-44-54" => "\xe7\xb6\xb2",
	"1-44-55" => "\xe8\x80\x97",
	"1-44-56" => "\xe8\x92\x99",
	"1-44-57" => "\xe5\x84\xb2",
	"1-44-58" => "\xe6\x9c\xa8",
	"1-44-59" => "\xe9\xbb\x99",
	"1-44-60" => "\xe7\x9b\xae",
	"1-44-61" => "\xe6\x9d\xa2",
	"1-44-62" => "\xe5\x8b\xbf",
	"1-44-63" => "\xe9\xa4\x85",
	"1-44-64" => "\xe5\xb0\xa4",
	"1-44-65" => "\xe6\x88\xbb",
	"1-44-66" => "\xe7\xb1\xbe",
	"1-44-67" => "\xe8\xb2\xb0",
	"1-44-68" => "\xe5\x95\x8f",
	"1-44-69" => "\xe6\x82\xb6",
	"1-44-70" => "\xe7\xb4\x8b",
	"1-44-71" => "\xe9\x96\x80",
	"1-44-72" => "\xe5\x8c\x81",
	"1-44-73" => "\xe4\xb9\x9f",
	"1-44-74" => "\xe5\x86\xb6",
	"1-44-75" => "\xe5\xa4\x9c",
	"1-44-76" => "\xe7\x88\xba",
	"1-44-77" => "\xe8\x80\xb6",
	"1-44-78" => "\xe9\x87\x8e",
	"1-44-79" => "\xe5\xbc\xa5",
	"1-44-80" => "\xe7\x9f\xa2",
	"1-44-81" => "\xe5\x8e\x84",
	"1-44-82" => "\xe5\xbd\xb9",
	"1-44-83" => "\xe7\xb4\x84",
	"1-44-84" => "\xe8\x96\xac",
	"1-44-85" => "\xe8\xa8\xb3",
	"1-44-86" => "\xe8\xba\x8d",
	"1-44-87" => "\xe9\x9d\x96",
	"1-44-88" => "\xe6\x9f\xb3",
	"1-44-89" => "\xe8\x96\xae",
	"1-44-90" => "\xe9\x91\x93",
	"1-44-91" => "\xe6\x84\x89",
	"1-44-92" => "\xe6\x84\x88",
	"1-44-93" => "\xe6\xb2\xb9",
	"1-44-94" => "\xe7\x99\x92",
	"1-45-1" => "\xe8\xab\xad",
	"1-45-2" => "\xe8\xbc\xb8",
	"1-45-3" => "\xe5\x94\xaf",
	"1-45-4" => "\xe4\xbd\x91",
	"1-45-5" => "\xe5\x84\xaa",
	"1-45-6" => "\xe5\x8b\x87",
	"1-45-7" => "\xe5\x8f\x8b",
	"1-45-8" => "\xe5\xae\xa5",
	"1-45-9" => "\xe5\xb9\xbd",
	"1-45-10" => "\xe6\x82\xa0",
	"1-45-11" => "\xe6\x86\x82",
	"1-45-12" => "\xe6\x8f\x96",
	"1-45-13" => "\xe6\x9c\x89",
	"1-45-14" => "\xe6\x9f\x9a",
	"1-45-15" => "\xe6\xb9\xa7",
	"1-45-16" => "\xe6\xb6\x8c",
	"1-45-17" => "\xe7\x8c\xb6",
	"1-45-18" => "\xe7\x8c\xb7",
	"1-45-19" => "\xe7\x94\xb1",
	"1-45-20" => "\xe7\xa5\x90",
	"1-45-21" => "\xe8\xa3\x95",
	"1-45-22" => "\xe8\xaa\x98",
	"1-45-23" => "\xe9\x81\x8a",
	"1-45-24" => "\xe9\x82\x91",
	"1-45-25" => "\xe9\x83\xb5",
	"1-45-26" => "\xe9\x9b\x84",
	"1-45-27" => "\xe8\x9e\x8d",
	"1-45-28" => "\xe5\xa4\x95",
	"1-45-29" => "\xe4\xba\x88",
	"1-45-30" => "\xe4\xbd\x99",
	"1-45-31" => "\xe4\xb8\x8e",
	"1-45-32" => "\xe8\xaa\x89",
	"1-45-33" => "\xe8\xbc\xbf",
	"1-45-34" => "\xe9\xa0\x90",
	"1-45-35" => "\xe5\x82\xad",
	"1-45-36" => "\xe5\xb9\xbc",
	"1-45-37" => "\xe5\xa6\x96",
	"1-45-38" => "\xe5\xae\xb9",
	"1-45-39" => "\xe5\xba\xb8",
	"1-45-40" => "\xe6\x8f\x9a",
	"1-45-41" => "\xe6\x8f\xba",
	"1-45-42" => "\xe6\x93\x81",
	"1-45-43" => "\xe6\x9b\x9c",
	"1-45-44" => "\xe6\xa5\x8a",
	"1-45-45" => "\xe6\xa7\x98",
	"1-45-46" => "\xe6\xb4\x8b",
	"1-45-47" => "\xe6\xba\xb6",
	"1-45-48" => "\xe7\x86\x94",
	"1-45-49" => "\xe7\x94\xa8",
	"1-45-50" => "\xe7\xaa\xaf",
	"1-45-51" => "\xe7\xbe\x8a",
	"1-45-52" => "\xe8\x80\x80",
	"1-45-53" => "\xe8\x91\x89",
	"1-45-54" => "\xe8\x93\x89",
	"1-45-55" => "\xe8\xa6\x81",
	"1-45-56" => "\xe8\xac\xa1",
	"1-45-57" => "\xe8\xb8\x8a",
	"1-45-58" => "\xe9\x81\xa5",
	"1-45-59" => "\xe9\x99\xbd",
	"1-45-60" => "\xe9\xa4\x8a",
	"1-45-61" => "\xe6\x85\xbe",
	"1-45-62" => "\xe6\x8a\x91",
	"1-45-63" => "\xe6\xac\xb2",
	"1-45-64" => "\xe6\xb2\x83",
	"1-45-65" => "\xe6\xb5\xb4",
	"1-45-66" => "\xe7\xbf\x8c",
	"1-45-67" => "\xe7\xbf\xbc",
	"1-45-68" => "\xe6\xb7\x80",
	"1-45-69" => "\xe7\xbe\x85",
	"1-45-70" => "\xe8\x9e\xba",
	"1-45-71" => "\xe8\xa3\xb8",
	"1-45-72" => "\xe6\x9d\xa5",
	"1-45-73" => "\xe8\x8e\xb1",
	"1-45-74" => "\xe9\xa0\xbc",
	"1-45-75" => "\xe9\x9b\xb7",
	"1-45-76" => "\xe6\xb4\x9b",
	"1-45-77" => "\xe7\xb5\xa1",
	"1-45-78" => "\xe8\x90\xbd",
	"1-45-79" => "\xe9\x85\xaa",
	"1-45-80" => "\xe4\xb9\xb1",
	"1-45-81" => "\xe5\x8d\xb5",
	"1-45-82" => "\xe5\xb5\x90",
	"1-45-83" => "\xe6\xac\x84",
	"1-45-84" => "\xe6\xbf\xab",
	"1-45-85" => "\xe8\x97\x8d",
	"1-45-86" => "\xe8\x98\xad",
	"1-45-87" => "\xe8\xa6\xa7",
	"1-45-88" => "\xe5\x88\xa9",
	"1-45-89" => "\xe5\x90\x8f",
	"1-45-90" => "\xe5\xb1\xa5",
	"1-45-91" => "\xe6\x9d\x8e",
	"1-45-92" => "\xe6\xa2\xa8",
	"1-45-93" => "\xe7\x90\x86",
	"1-45-94" => "\xe7\x92\x83",
	"1-46-1" => "\xe7\x97\xa2",
	"1-46-2" => "\xe8\xa3\x8f",
	"1-46-3" => "\xe8\xa3\xa1",
	"1-46-4" => "\xe9\x87\x8c",
	"1-46-5" => "\xe9\x9b\xa2",
	"1-46-6" => "\xe9\x99\xb8",
	"1-46-7" => "\xe5\xbe\x8b",
	"1-46-8" => "\xe7\x8e\x87",
	"1-46-9" => "\xe7\xab\x8b",
	"1-46-10" => "\xe8\x91\x8e",
	"1-46-11" => "\xe6\x8e\xa0",
	"1-46-12" => "\xe7\x95\xa5",
	"1-46-13" => "\xe5\x8a\x89",
	"1-46-14" => "\xe6\xb5\x81",
	"1-46-15" => "\xe6\xba\x9c",
	"1-46-16" => "\xe7\x90\x89",
	"1-46-17" => "\xe7\x95\x99",
	"1-46-18" => "\xe7\xa1\xab",
	"1-46-19" => "\xe7\xb2\x92",
	"1-46-20" => "\xe9\x9a\x86",
	"1-46-21" => "\xe7\xab\x9c",
	"1-46-22" => "\xe9\xbe\x8d",
	"1-46-23" => "\xe4\xbe\xb6",
	"1-46-24" => "\xe6\x85\xae",
	"1-46-25" => "\xe6\x97\x85",
	"1-46-26" => "\xe8\x99\x9c",
	"1-46-27" => "\xe4\xba\x86",
	"1-46-28" => "\xe4\xba\xae",
	"1-46-29" => "\xe5\x83\x9a",
	"1-46-30" => "\xe4\xb8\xa1",
	"1-46-31" => "\xe5\x87\x8c",
	"1-46-32" => "\xe5\xaf\xae",
	"1-46-33" => "\xe6\x96\x99",
	"1-46-34" => "\xe6\xa2\x81",
	"1-46-35" => "\xe6\xb6\xbc",
	"1-46-36" => "\xe7\x8c\x9f",
	"1-46-37" => "\xe7\x99\x82",
	"1-46-38" => "\xe7\x9e\xad",
	"1-46-39" => "\xe7\xa8\x9c",
	"1-46-40" => "\xe7\xb3\xa7",
	"1-46-41" => "\xe8\x89\xaf",
	"1-46-42" => "\xe8\xab\x92",
	"1-46-43" => "\xe9\x81\xbc",
	"1-46-44" => "\xe9\x87\x8f",
	"1-46-45" => "\xe9\x99\xb5",
	"1-46-46" => "\xe9\xa0\x98",
	"1-46-47" => "\xe5\x8a\x9b",
	"1-46-48" => "\xe7\xb7\x91",
	"1-46-49" => "\xe5\x80\xab",
	"1-46-50" => "\xe5\x8e\x98",
	"1-46-51" => "\xe6\x9e\x97",
	"1-46-52" => "\xe6\xb7\x8b",
	"1-46-53" => "\xe7\x87\x90",
	"1-46-54" => "\xe7\x90\xb3",
	"1-46-55" => "\xe8\x87\xa8",
	"1-46-56" => "\xe8\xbc\xaa",
	"1-46-57" => "\xe9\x9a\xa3",
	"1-46-58" => "\xe9\xb1\x97",
	"1-46-59" => "\xe9\xba\x9f",
	"1-46-60" => "\xe7\x91\xa0",
	"1-46-61" => "\xe5\xa1\x81",
	"1-46-62" => "\xe6\xb6\x99",
	"1-46-63" => "\xe7\xb4\xaf",
	"1-46-64" => "\xe9\xa1\x9e",
	"1-46-65" => "\xe4\xbb\xa4",
	"1-46-66" => "\xe4\xbc\xb6",
	"1-46-67" => "\xe4\xbe\x8b",
	"1-46-68" => "\xe5\x86\xb7",
	"1-46-69" => "\xe5\x8a\xb1",
	"1-46-70" => "\xe5\xb6\xba",
	"1-46-71" => "\xe6\x80\x9c",
	"1-46-72" => "\xe7\x8e\xb2",
	"1-46-73" => "\xe7\xa4\xbc",
	"1-46-74" => "\xe8\x8b\x93",
	"1-46-75" => "\xe9\x88\xb4",
	"1-46-76" => "\xe9\x9a\xb7",
	"1-46-77" => "\xe9\x9b\xb6",
	"1-46-78" => "\xe9\x9c\x8a",
	"1-46-79" => "\xe9\xba\x97",
	"1-46-80" => "\xe9\xbd\xa2",
	"1-46-81" => "\xe6\x9a\xa6",
	"1-46-82" => "\xe6\xad\xb4",
	"1-46-83" => "\xe5\x88\x97",
	"1-46-84" => "\xe5\x8a\xa3",
	"1-46-85" => "\xe7\x83\x88",
	"1-46-86" => "\xe8\xa3\x82",
	"1-46-87" => "\xe5\xbb\x89",
	"1-46-88" => "\xe6\x81\x8b",
	"1-46-89" => "\xe6\x86\x90",
	"1-46-90" => "\xe6\xbc\xa3",
	"1-46-91" => "\xe7\x85\x89",
	"1-46-92" => "\xe7\xb0\xbe",
	"1-46-93" => "\xe7\xb7\xb4",
	"1-46-94" => "\xe8\x81\xaf",
	"1-47-1" => "\xe8\x93\xae",
	"1-47-2" => "\xe9\x80\xa3",
	"1-47-3" => "\xe9\x8c\xac",
	"1-47-4" => "\xe5\x91\x82",
	"1-47-5" => "\xe9\xad\xaf",
	"1-47-6" => "\xe6\xab\x93",
	"1-47-7" => "\xe7\x82\x89",
	"1-47-8" => "\xe8\xb3\x82",
	"1-47-9" => "\xe8\xb7\xaf",
	"1-47-10" => "\xe9\x9c\xb2",
	"1-47-11" => "\xe5\x8a\xb4",
	"1-47-12" => "\xe5\xa9\x81",
	"1-47-13" => "\xe5\xbb\x8a",
	"1-47-14" => "\xe5\xbc\x84",
	"1-47-15" => "\xe6\x9c\x97",
	"1-47-16" => "\xe6\xa5\xbc",
	"1-47-17" => "\xe6\xa6\x94",
	"1-47-18" => "\xe6\xb5\xaa",
	"1-47-19" => "\xe6\xbc\x8f",
	"1-47-20" => "\xe7\x89\xa2",
	"1-47-21" => "\xe7\x8b\xbc",
	"1-47-22" => "\xe7\xaf\xad",
	"1-47-23" => "\xe8\x80\x81",
	"1-47-24" => "\xe8\x81\xbe",
	"1-47-25" => "\xe8\x9d\x8b",
	"1-47-26" => "\xe9\x83\x8e",
	"1-47-27" => "\xe5\x85\xad",
	"1-47-28" => "\xe9\xba\x93",
	"1-47-29" => "\xe7\xa6\x84",
	"1-47-30" => "\xe8\x82\x8b",
	"1-47-31" => "\xe9\x8c\xb2",
	"1-47-32" => "\xe8\xab\x96",
	"1-47-33" => "\xe5\x80\xad",
	"1-47-34" => "\xe5\x92\x8c",
	"1-47-35" => "\xe8\xa9\xb1",
	"1-47-36" => "\xe6\xad\xaa",
	"1-47-37" => "\xe8\xb3\x84",
	"1-47-38" => "\xe8\x84\x87",
	"1-47-39" => "\xe6\x83\x91",
	"1-47-40" => "\xe6\x9e\xa0",
	"1-47-41" => "\xe9\xb7\xb2",
	"1-47-42" => "\xe4\xba\x99",
	"1-47-43" => "\xe4\xba\x98",
	"1-47-44" => "\xe9\xb0\x90",
	"1-47-45" => "\xe8\xa9\xab",
	"1-47-46" => "\xe8\x97\x81",
	"1-47-47" => "\xe8\x95\xa8",
	"1-47-48" => "\xe6\xa4\x80",
	"1-47-49" => "\xe6\xb9\xbe",
	"1-47-50" => "\xe7\xa2\x97",
	"1-47-51" => "\xe8\x85\x95",
	"1-47-52" => "\xf0\xa0\xae\x9f",	# 07/07/01 fix
	"1-47-53" => "\xe5\xad\x81",
	"1-47-54" => "\xe5\xad\x96",
	"1-47-55" => "\xe5\xad\xbd",
	"1-47-56" => "\xe5\xae\x93",
	"1-47-57" => "\xe5\xaf\x98",
	"1-47-58" => "\xe5\xaf\xac",
	"1-47-59" => "\xe5\xb0\x92",
	"1-47-60" => "\xe5\xb0\x9e",
	"1-47-61" => "\xe5\xb0\xa3",
	"1-47-62" => "\xe5\xb0\xab",
	"1-47-63" => "\xe3\x9e\x8d",
	"1-47-64" => "\xe5\xb1\xa2",
	"1-47-65" => "\xe5\xb1\xa4",	
	"1-47-66" => "\xe5\xb1\xae",	
	"1-47-67" => "\xf0\xa1\x9a\xb4",	
	"1-47-68" => "\xe5\xb1\xba",
	"1-47-69" => "\xe5\xb2\x8f",
	"1-47-70" => "\xe5\xb2\x9f",
	"1-47-71" => "\xe5\xb2\xa3",
	"1-47-72" => "\xe5\xb2\xaa",
	"1-47-73" => "\xe5\xb2\xba",
	"1-47-74" => "\xe5\xb3\x8b",
	"1-47-75" => "\xe5\xb3\x90",
	"1-47-76" => "\xe5\xb3\x92",
	"1-47-77" => "\xe5\xb3\xb4",
	"1-47-78" => "\xf0\xa1\xb8\xb4",	
	"1-47-79" => "\xe3\x9f\xa2",
	"1-47-80" => "\xe5\xb4\x8d",
	"1-47-81" => "\xe5\xb4\xa7",
	"1-47-82" => "\xef\xa8\x91",
	"1-47-83" => "\xe5\xb5\x86",
	"1-47-84" => "\xe5\xb5\x87",
	"1-47-85" => "\xe5\xb5\x93",
	"1-47-86" => "\xe5\xb5\x8a",
	"1-47-87" => "\xe5\xb5\xad",
	"1-47-88" => "\xe5\xb6\x81",
	"1-47-89" => "\xe5\xb6\xa0",
	"1-47-90" => "\xe5\xb6\xa4",
	"1-47-91" => "\xe5\xb6\xa7",
	"1-47-92" => "\xe5\xb6\xb8",
	"1-47-93" => "\xe5\xb7\x8b",
	"1-47-94" => "\xe5\x90\x9e",	# 07/07/01 fix
	"1-48-1" => "\xe5\xbc\x8c",
	"1-48-2" => "\xe4\xb8\x90",
	"1-48-3" => "\xe4\xb8\x95",
	"1-48-4" => "\xe4\xb8\xaa",
	"1-48-5" => "\xe4\xb8\xb1",
	"1-48-6" => "\xe4\xb8\xb6",
	"1-48-7" => "\xe4\xb8\xbc",
	"1-48-8" => "\xe4\xb8\xbf",
	"1-48-9" => "\xe4\xb9\x82",
	"1-48-10" => "\xe4\xb9\x96",
	"1-48-11" => "\xe4\xb9\x98",
	"1-48-12" => "\xe4\xba\x82",
	"1-48-13" => "\xe4\xba\x85",
	"1-48-14" => "\xe8\xb1\xab",
	"1-48-15" => "\xe4\xba\x8a",
	"1-48-16" => "\xe8\x88\x92",
	"1-48-17" => "\xe5\xbc\x8d",
	"1-48-18" => "\xe4\xba\x8e",
	"1-48-19" => "\xe4\xba\x9e",
	"1-48-20" => "\xe4\xba\x9f",
	"1-48-21" => "\xe4\xba\xa0",
	"1-48-22" => "\xe4\xba\xa2",
	"1-48-23" => "\xe4\xba\xb0",
	"1-48-24" => "\xe4\xba\xb3",
	"1-48-25" => "\xe4\xba\xb6",
	"1-48-26" => "\xe4\xbb\x8e",
	"1-48-27" => "\xe4\xbb\x8d",
	"1-48-28" => "\xe4\xbb\x84",
	"1-48-29" => "\xe4\xbb\x86",
	"1-48-30" => "\xe4\xbb\x82",
	"1-48-31" => "\xe4\xbb\x97",
	"1-48-32" => "\xe4\xbb\x9e",
	"1-48-33" => "\xe4\xbb\xad",
	"1-48-34" => "\xe4\xbb\x9f",
	"1-48-35" => "\xe4\xbb\xb7",
	"1-48-36" => "\xe4\xbc\x89",
	"1-48-37" => "\xe4\xbd\x9a",
	"1-48-38" => "\xe4\xbc\xb0",
	"1-48-39" => "\xe4\xbd\x9b",
	"1-48-40" => "\xe4\xbd\x9d",
	"1-48-41" => "\xe4\xbd\x97",
	"1-48-42" => "\xe4\xbd\x87",
	"1-48-43" => "\xe4\xbd\xb6",
	"1-48-44" => "\xe4\xbe\x88",
	"1-48-45" => "\xe4\xbe\x8f",
	"1-48-46" => "\xe4\xbe\x98",
	"1-48-47" => "\xe4\xbd\xbb",
	"1-48-48" => "\xe4\xbd\xa9",
	"1-48-49" => "\xe4\xbd\xb0",
	"1-48-50" => "\xe4\xbe\x91",
	"1-48-51" => "\xe4\xbd\xaf",
	"1-48-52" => "\xe4\xbe\x86",
	"1-48-53" => "\xe4\xbe\x96",
	"1-48-54" => "\xe5\x84\x98",
	"1-48-55" => "\xe4\xbf\x94",
	"1-48-56" => "\xe4\xbf\x9f",
	"1-48-57" => "\xe4\xbf\x8e",
	"1-48-58" => "\xe4\xbf\x98",
	"1-48-59" => "\xe4\xbf\x9b",
	"1-48-60" => "\xe4\xbf\x91",
	"1-48-61" => "\xe4\xbf\x9a",
	"1-48-62" => "\xe4\xbf\x90",
	"1-48-63" => "\xe4\xbf\xa4",
	"1-48-64" => "\xe4\xbf\xa5",
	"1-48-65" => "\xe5\x80\x9a",
	"1-48-66" => "\xe5\x80\xa8",
	"1-48-67" => "\xe5\x80\x94",
	"1-48-68" => "\xe5\x80\xaa",
	"1-48-69" => "\xe5\x80\xa5",
	"1-48-70" => "\xe5\x80\x85",
	"1-48-71" => "\xe4\xbc\x9c",
	"1-48-72" => "\xe4\xbf\xb6",
	"1-48-73" => "\xe5\x80\xa1",
	"1-48-74" => "\xe5\x80\xa9",
	"1-48-75" => "\xe5\x80\xac",
	"1-48-76" => "\xe4\xbf\xbe",
	"1-48-77" => "\xe4\xbf\xaf",
	"1-48-78" => "\xe5\x80\x91",
	"1-48-79" => "\xe5\x80\x86",
	"1-48-80" => "\xe5\x81\x83",
	"1-48-81" => "\xe5\x81\x87",
	"1-48-82" => "\xe6\x9c\x83",
	"1-48-83" => "\xe5\x81\x95",
	"1-48-84" => "\xe5\x81\x90",
	"1-48-85" => "\xe5\x81\x88",
	"1-48-86" => "\xe5\x81\x9a",
	"1-48-87" => "\xe5\x81\x96",
	"1-48-88" => "\xe5\x81\xac",
	"1-48-89" => "\xe5\x81\xb8",
	"1-48-90" => "\xe5\x82\x80",
	"1-48-91" => "\xe5\x82\x9a",
	"1-48-92" => "\xe5\x82\x85",
	"1-48-93" => "\xe5\x82\xb4",
	"1-48-94" => "\xe5\x82\xb2",
	"1-49-1" => "\xe5\x83\x89",
	"1-49-2" => "\xe5\x83\x8a",
	"1-49-3" => "\xe5\x82\xb3",
	"1-49-4" => "\xe5\x83\x82",
	"1-49-5" => "\xe5\x83\x96",
	"1-49-6" => "\xe5\x83\x9e",
	"1-49-7" => "\xe5\x83\xa5",
	"1-49-8" => "\xe5\x83\xad",
	"1-49-9" => "\xe5\x83\xa3",
	"1-49-10" => "\xe5\x83\xae",
	"1-49-11" => "\xe5\x83\xb9",
	"1-49-12" => "\xe5\x83\xb5",
	"1-49-13" => "\xe5\x84\x89",
	"1-49-14" => "\xe5\x84\x81",
	"1-49-15" => "\xe5\x84\x82",
	"1-49-16" => "\xe5\x84\x96",
	"1-49-17" => "\xe5\x84\x95",
	"1-49-18" => "\xe5\x84\x94",
	"1-49-19" => "\xe5\x84\x9a",
	"1-49-20" => "\xe5\x84\xa1",
	"1-49-21" => "\xe5\x84\xba",
	"1-49-22" => "\xe5\x84\xb7",
	"1-49-23" => "\xe5\x84\xbc",
	"1-49-24" => "\xe5\x84\xbb",
	"1-49-25" => "\xe5\x84\xbf",
	"1-49-26" => "\xe5\x85\x80",
	"1-49-27" => "\xe5\x85\x92",
	"1-49-28" => "\xe5\x85\x8c",
	"1-49-29" => "\xe5\x85\x94",
	"1-49-30" => "\xe5\x85\xa2",
	"1-49-31" => "\xe7\xab\xb8",
	"1-49-32" => "\xe5\x85\xa9",
	"1-49-33" => "\xe5\x85\xaa",
	"1-49-34" => "\xe5\x85\xae",
	"1-49-35" => "\xe5\x86\x80",
	"1-49-36" => "\xe5\x86\x82",
	"1-49-37" => "\xe5\x9b\x98",
	"1-49-38" => "\xe5\x86\x8c",
	"1-49-39" => "\xe5\x86\x89",
	"1-49-40" => "\xe5\x86\x8f",
	"1-49-41" => "\xe5\x86\x91",
	"1-49-42" => "\xe5\x86\x93",
	"1-49-43" => "\xe5\x86\x95",
	"1-49-44" => "\xe5\x86\x96",
	"1-49-45" => "\xe5\x86\xa4",
	"1-49-46" => "\xe5\x86\xa6",
	"1-49-47" => "\xe5\x86\xa2",
	"1-49-48" => "\xe5\x86\xa9",
	"1-49-49" => "\xe5\x86\xaa",
	"1-49-50" => "\xe5\x86\xab",
	"1-49-51" => "\xe5\x86\xb3",
	"1-49-52" => "\xe5\x86\xb1",
	"1-49-53" => "\xe5\x86\xb2",
	"1-49-54" => "\xe5\x86\xb0",
	"1-49-55" => "\xe5\x86\xb5",
	"1-49-56" => "\xe5\x86\xbd",
	"1-49-57" => "\xe5\x87\x85",
	"1-49-58" => "\xe5\x87\x89",
	"1-49-59" => "\xe5\x87\x9b",
	"1-49-60" => "\xe5\x87\xa0",
	"1-49-61" => "\xe8\x99\x95",
	"1-49-62" => "\xe5\x87\xa9",
	"1-49-63" => "\xe5\x87\xad",
	"1-49-64" => "\xe5\x87\xb0",
	"1-49-65" => "\xe5\x87\xb5",
	"1-49-66" => "\xe5\x87\xbe",
	"1-49-67" => "\xe5\x88\x84",
	"1-49-68" => "\xe5\x88\x8b",
	"1-49-69" => "\xe5\x88\x94",
	"1-49-70" => "\xe5\x88\x8e",
	"1-49-71" => "\xe5\x88\xa7",
	"1-49-72" => "\xe5\x88\xaa",
	"1-49-73" => "\xe5\x88\xae",
	"1-49-74" => "\xe5\x88\xb3",
	"1-49-75" => "\xe5\x88\xb9",
	"1-49-76" => "\xe5\x89\x8f",
	"1-49-77" => "\xe5\x89\x84",
	"1-49-78" => "\xe5\x89\x8b",
	"1-49-79" => "\xe5\x89\x8c",
	"1-49-80" => "\xe5\x89\x9e",
	"1-49-81" => "\xe5\x89\x94",
	"1-49-82" => "\xe5\x89\xaa",
	"1-49-83" => "\xe5\x89\xb4",
	"1-49-84" => "\xe5\x89\xa9",
	"1-49-85" => "\xe5\x89\xb3",
	"1-49-86" => "\xe5\x89\xbf",
	"1-49-87" => "\xe5\x89\xbd",
	"1-49-88" => "\xe5\x8a\x8d",
	"1-49-89" => "\xe5\x8a\x94",
	"1-49-90" => "\xe5\x8a\x92",
	"1-49-91" => "\xe5\x89\xb1",
	"1-49-92" => "\xe5\x8a\x88",
	"1-49-93" => "\xe5\x8a\x91",
	"1-49-94" => "\xe8\xbe\xa8",
	"1-50-1" => "\xe8\xbe\xa7",
	"1-50-2" => "\xe5\x8a\xac",
	"1-50-3" => "\xe5\x8a\xad",
	"1-50-4" => "\xe5\x8a\xbc",
	"1-50-5" => "\xe5\x8a\xb5",
	"1-50-6" => "\xe5\x8b\x81",
	"1-50-7" => "\xe5\x8b\x8d",
	"1-50-8" => "\xe5\x8b\x97",
	"1-50-9" => "\xe5\x8b\x9e",
	"1-50-10" => "\xe5\x8b\xa3",
	"1-50-11" => "\xe5\x8b\xa6",
	"1-50-12" => "\xe9\xa3\xad",
	"1-50-13" => "\xe5\x8b\xa0",
	"1-50-14" => "\xe5\x8b\xb3",
	"1-50-15" => "\xe5\x8b\xb5",
	"1-50-16" => "\xe5\x8b\xb8",
	"1-50-17" => "\xe5\x8b\xb9",
	"1-50-18" => "\xe5\x8c\x86",
	"1-50-19" => "\xe5\x8c\x88",
	"1-50-20" => "\xe7\x94\xb8",
	"1-50-21" => "\xe5\x8c\x8d",
	"1-50-22" => "\xe5\x8c\x90",
	"1-50-23" => "\xe5\x8c\x8f",
	"1-50-24" => "\xe5\x8c\x95",
	"1-50-25" => "\xe5\x8c\x9a",
	"1-50-26" => "\xe5\x8c\xa3",
	"1-50-27" => "\xe5\x8c\xaf",
	"1-50-28" => "\xe5\x8c\xb1",
	"1-50-29" => "\xe5\x8c\xb3",
	"1-50-30" => "\xe5\x8c\xb8",
	"1-50-31" => "\xe5\x8d\x80",
	"1-50-32" => "\xe5\x8d\x86",
	"1-50-33" => "\xe5\x8d\x85",
	"1-50-34" => "\xe4\xb8\x97",
	"1-50-35" => "\xe5\x8d\x89",
	"1-50-36" => "\xe5\x8d\x8d",
	"1-50-37" => "\xe5\x87\x96",
	"1-50-38" => "\xe5\x8d\x9e",
	"1-50-39" => "\xe5\x8d\xa9",
	"1-50-40" => "\xe5\x8d\xae",
	"1-50-41" => "\xe5\xa4\x98",
	"1-50-42" => "\xe5\x8d\xbb",
	"1-50-43" => "\xe5\x8d\xb7",
	"1-50-44" => "\xe5\x8e\x82",
	"1-50-45" => "\xe5\x8e\x96",
	"1-50-46" => "\xe5\x8e\xa0",
	"1-50-47" => "\xe5\x8e\xa6",
	"1-50-48" => "\xe5\x8e\xa5",
	"1-50-49" => "\xe5\x8e\xae",
	"1-50-50" => "\xe5\x8e\xb0",
	"1-50-51" => "\xe5\x8e\xb6",
	"1-50-52" => "\xe5\x8f\x83",
	"1-50-53" => "\xe7\xb0\x92",
	"1-50-54" => "\xe9\x9b\x99",
	"1-50-55" => "\xe5\x8f\x9f",
	"1-50-56" => "\xe6\x9b\xbc",
	"1-50-57" => "\xe7\x87\xae",
	"1-50-58" => "\xe5\x8f\xae",
	"1-50-59" => "\xe5\x8f\xa8",
	"1-50-60" => "\xe5\x8f\xad",
	"1-50-61" => "\xe5\x8f\xba",
	"1-50-62" => "\xe5\x90\x81",
	"1-50-63" => "\xe5\x90\xbd",
	"1-50-64" => "\xe5\x91\x80",
	"1-50-65" => "\xe5\x90\xac",
	"1-50-66" => "\xe5\x90\xad",
	"1-50-67" => "\xe5\x90\xbc",
	"1-50-68" => "\xe5\x90\xae",
	"1-50-69" => "\xe5\x90\xb6",
	"1-50-70" => "\xe5\x90\xa9",
	"1-50-71" => "\xe5\x90\x9d",
	"1-50-72" => "\xe5\x91\x8e",
	"1-50-73" => "\xe5\x92\x8f",
	"1-50-74" => "\xe5\x91\xb5",
	"1-50-75" => "\xe5\x92\x8e",
	"1-50-76" => "\xe5\x91\x9f",
	"1-50-77" => "\xe5\x91\xb1",
	"1-50-78" => "\xe5\x91\xb7",
	"1-50-79" => "\xe5\x91\xb0",
	"1-50-80" => "\xe5\x92\x92",
	"1-50-81" => "\xe5\x91\xbb",
	"1-50-82" => "\xe5\x92\x80",
	"1-50-83" => "\xe5\x91\xb6",
	"1-50-84" => "\xe5\x92\x84",
	"1-50-85" => "\xe5\x92\x90",
	"1-50-86" => "\xe5\x92\x86",
	"1-50-87" => "\xe5\x93\x87",
	"1-50-88" => "\xe5\x92\xa2",
	"1-50-89" => "\xe5\x92\xb8",
	"1-50-90" => "\xe5\x92\xa5",
	"1-50-91" => "\xe5\x92\xac",
	"1-50-92" => "\xe5\x93\x84",
	"1-50-93" => "\xe5\x93\x88",
	"1-50-94" => "\xe5\x92\xa8",
	"1-51-1" => "\xe5\x92\xab",
	"1-51-2" => "\xe5\x93\x82",
	"1-51-3" => "\xe5\x92\xa4",
	"1-51-4" => "\xe5\x92\xbe",
	"1-51-5" => "\xe5\x92\xbc",
	"1-51-6" => "\xe5\x93\x98",
	"1-51-7" => "\xe5\x93\xa5",
	"1-51-8" => "\xe5\x93\xa6",
	"1-51-9" => "\xe5\x94\x8f",
	"1-51-10" => "\xe5\x94\x94",
	"1-51-11" => "\xe5\x93\xbd",
	"1-51-12" => "\xe5\x93\xae",
	"1-51-13" => "\xe5\x93\xad",
	"1-51-14" => "\xe5\x93\xba",
	"1-51-15" => "\xe5\x93\xa2",
	"1-51-16" => "\xe5\x94\xb9",
	"1-51-17" => "\xe5\x95\x80",
	"1-51-18" => "\xe5\x95\xa3",
	"1-51-19" => "\xe5\x95\x8c",
	"1-51-20" => "\xe5\x94\xae",
	"1-51-21" => "\xe5\x95\x9c",
	"1-51-22" => "\xe5\x95\x85",
	"1-51-23" => "\xe5\x95\x96",
	"1-51-24" => "\xe5\x95\x97",
	"1-51-25" => "\xe5\x94\xb8",
	"1-51-26" => "\xe5\x94\xb3",
	"1-51-27" => "\xe5\x95\x9d",
	"1-51-28" => "\xe5\x96\x99",
	"1-51-29" => "\xe5\x96\x80",
	"1-51-30" => "\xe5\x92\xaf",
	"1-51-31" => "\xe5\x96\x8a",
	"1-51-32" => "\xe5\x96\x9f",
	"1-51-33" => "\xe5\x95\xbb",
	"1-51-34" => "\xe5\x95\xbe",
	"1-51-35" => "\xe5\x96\x98",
	"1-51-36" => "\xe5\x96\x9e",
	"1-51-37" => "\xe5\x96\xae",
	"1-51-38" => "\xe5\x95\xbc",
	"1-51-39" => "\xe5\x96\x83",
	"1-51-40" => "\xe5\x96\xa9",
	"1-51-41" => "\xe5\x96\x87",
	"1-51-42" => "\xe5\x96\xa8",
	"1-51-43" => "\xe5\x97\x9a",
	"1-51-44" => "\xe5\x97\x85",
	"1-51-45" => "\xe5\x97\x9f",
	"1-51-46" => "\xe5\x97\x84",
	"1-51-47" => "\xe5\x97\x9c",
	"1-51-48" => "\xe5\x97\xa4",
	"1-51-49" => "\xe5\x97\x94",
	"1-51-50" => "\xe5\x98\x94",
	"1-51-51" => "\xe5\x97\xb7",
	"1-51-52" => "\xe5\x98\x96",
	"1-51-53" => "\xe5\x97\xbe",
	"1-51-54" => "\xe5\x97\xbd",
	"1-51-55" => "\xe5\x98\x9b",
	"1-51-56" => "\xe5\x97\xb9",
	"1-51-57" => "\xe5\x99\x8e",
	"1-51-58" => "\xe5\x99\x90",
	"1-51-59" => "\xe7\x87\x9f",
	"1-51-60" => "\xe5\x98\xb4",
	"1-51-61" => "\xe5\x98\xb6",
	"1-51-62" => "\xe5\x98\xb2",
	"1-51-63" => "\xe5\x98\xb8",
	"1-51-64" => "\xe5\x99\xab",
	"1-51-65" => "\xe5\x99\xa4",
	"1-51-66" => "\xe5\x98\xaf",
	"1-51-67" => "\xe5\x99\xac",
	"1-51-68" => "\xe5\x99\xaa",
	"1-51-69" => "\xe5\x9a\x86",
	"1-51-70" => "\xe5\x9a\x80",
	"1-51-71" => "\xe5\x9a\x8a",
	"1-51-72" => "\xe5\x9a\xa0",
	"1-51-73" => "\xe5\x9a\x94",
	"1-51-74" => "\xe5\x9a\x8f",
	"1-51-75" => "\xe5\x9a\xa5",
	"1-51-76" => "\xe5\x9a\xae",
	"1-51-77" => "\xe5\x9a\xb6",
	"1-51-78" => "\xe5\x9a\xb4",
	"1-51-79" => "\xe5\x9b\x82",
	"1-51-80" => "\xe5\x9a\xbc",
	"1-51-81" => "\xe5\x9b\x81",
	"1-51-82" => "\xe5\x9b\x83",
	"1-51-83" => "\xe5\x9b\x80",
	"1-51-84" => "\xe5\x9b\x88",
	"1-51-85" => "\xe5\x9b\x8e",
	"1-51-86" => "\xe5\x9b\x91",
	"1-51-87" => "\xe5\x9b\x93",
	"1-51-88" => "\xe5\x9b\x97",
	"1-51-89" => "\xe5\x9b\xae",
	"1-51-90" => "\xe5\x9b\xb9",
	"1-51-91" => "\xe5\x9c\x80",
	"1-51-92" => "\xe5\x9b\xbf",
	"1-51-93" => "\xe5\x9c\x84",
	"1-51-94" => "\xe5\x9c\x89",
	"1-52-1" => "\xe5\x9c\x88",
	"1-52-2" => "\xe5\x9c\x8b",
	"1-52-3" => "\xe5\x9c\x8d",
	"1-52-4" => "\xe5\x9c\x93",
	"1-52-5" => "\xe5\x9c\x98",
	"1-52-6" => "\xe5\x9c\x96",
	"1-52-7" => "\xe5\x97\x87",
	"1-52-8" => "\xe5\x9c\x9c",
	"1-52-9" => "\xe5\x9c\xa6",
	"1-52-10" => "\xe5\x9c\xb7",
	"1-52-11" => "\xe5\x9c\xb8",
	"1-52-12" => "\xe5\x9d\x8e",
	"1-52-13" => "\xe5\x9c\xbb",
	"1-52-14" => "\xe5\x9d\x80",
	"1-52-15" => "\xe5\x9d\x8f",
	"1-52-16" => "\xe5\x9d\xa9",
	"1-52-17" => "\xe5\x9f\x80",
	"1-52-18" => "\xe5\x9e\x88",
	"1-52-19" => "\xe5\x9d\xa1",
	"1-52-20" => "\xe5\x9d\xbf",
	"1-52-21" => "\xe5\x9e\x89",
	"1-52-22" => "\xe5\x9e\x93",
	"1-52-23" => "\xe5\x9e\xa0",
	"1-52-24" => "\xe5\x9e\xb3",
	"1-52-25" => "\xe5\x9e\xa4",
	"1-52-26" => "\xe5\x9e\xaa",
	"1-52-27" => "\xe5\x9e\xb0",
	"1-52-28" => "\xe5\x9f\x83",
	"1-52-29" => "\xe5\x9f\x86",
	"1-52-30" => "\xe5\x9f\x94",
	"1-52-31" => "\xe5\x9f\x92",
	"1-52-32" => "\xe5\x9f\x93",
	"1-52-33" => "\xe5\xa0\x8a",
	"1-52-34" => "\xe5\x9f\x96",
	"1-52-35" => "\xe5\x9f\xa3",
	"1-52-36" => "\xe5\xa0\x8b",
	"1-52-37" => "\xe5\xa0\x99",
	"1-52-38" => "\xe5\xa0\x9d",
	"1-52-39" => "\xe5\xa1\xb2",
	"1-52-40" => "\xe5\xa0\xa1",
	"1-52-41" => "\xe5\xa1\xa2",
	"1-52-42" => "\xe5\xa1\x8b",
	"1-52-43" => "\xe5\xa1\xb0",
	"1-52-44" => "\xe6\xaf\x80",
	"1-52-45" => "\xe5\xa1\x92",
	"1-52-46" => "\xe5\xa0\xbd",
	"1-52-47" => "\xe5\xa1\xb9",
	"1-52-48" => "\xe5\xa2\x85",
	"1-52-49" => "\xe5\xa2\xb9",
	"1-52-50" => "\xe5\xa2\x9f",
	"1-52-51" => "\xe5\xa2\xab",
	"1-52-52" => "\xe5\xa2\xba",
	"1-52-53" => "\xe5\xa3\x9e",
	"1-52-54" => "\xe5\xa2\xbb",
	"1-52-55" => "\xe5\xa2\xb8",
	"1-52-56" => "\xe5\xa2\xae",
	"1-52-57" => "\xe5\xa3\x85",
	"1-52-58" => "\xe5\xa3\x93",
	"1-52-59" => "\xe5\xa3\x91",
	"1-52-60" => "\xe5\xa3\x97",
	"1-52-61" => "\xe5\xa3\x99",
	"1-52-62" => "\xe5\xa3\x98",
	"1-52-63" => "\xe5\xa3\xa5",
	"1-52-64" => "\xe5\xa3\x9c",
	"1-52-65" => "\xe5\xa3\xa4",
	"1-52-66" => "\xe5\xa3\x9f",
	"1-52-67" => "\xe5\xa3\xaf",
	"1-52-68" => "\xe5\xa3\xba",
	"1-52-69" => "\xe5\xa3\xb9",
	"1-52-70" => "\xe5\xa3\xbb",
	"1-52-71" => "\xe5\xa3\xbc",
	"1-52-72" => "\xe5\xa3\xbd",
	"1-52-73" => "\xe5\xa4\x82",
	"1-52-74" => "\xe5\xa4\x8a",
	"1-52-75" => "\xe5\xa4\x90",
	"1-52-76" => "\xe5\xa4\x9b",
	"1-52-77" => "\xe6\xa2\xa6",
	"1-52-78" => "\xe5\xa4\xa5",
	"1-52-79" => "\xe5\xa4\xac",
	"1-52-80" => "\xe5\xa4\xad",
	"1-52-81" => "\xe5\xa4\xb2",
	"1-52-82" => "\xe5\xa4\xb8",
	"1-52-83" => "\xe5\xa4\xbe",
	"1-52-84" => "\xe7\xab\x92",
	"1-52-85" => "\xe5\xa5\x95",
	"1-52-86" => "\xe5\xa5\x90",
	"1-52-87" => "\xe5\xa5\x8e",
	"1-52-88" => "\xe5\xa5\x9a",
	"1-52-89" => "\xe5\xa5\x98",
	"1-52-90" => "\xe5\xa5\xa2",
	"1-52-91" => "\xe5\xa5\xa0",
	"1-52-92" => "\xe5\xa5\xa7",
	"1-52-93" => "\xe5\xa5\xac",
	"1-52-94" => "\xe5\xa5\xa9",
	"1-53-1" => "\xe5\xa5\xb8",
	"1-53-2" => "\xe5\xa6\x81",
	"1-53-3" => "\xe5\xa6\x9d",
	"1-53-4" => "\xe4\xbd\x9e",
	"1-53-5" => "\xe4\xbe\xab",
	"1-53-6" => "\xe5\xa6\xa3",
	"1-53-7" => "\xe5\xa6\xb2",
	"1-53-8" => "\xe5\xa7\x86",
	"1-53-9" => "\xe5\xa7\xa8",
	"1-53-10" => "\xe5\xa7\x9c",
	"1-53-11" => "\xe5\xa6\x8d",
	"1-53-12" => "\xe5\xa7\x99",
	"1-53-13" => "\xe5\xa7\x9a",
	"1-53-14" => "\xe5\xa8\xa5",
	"1-53-15" => "\xe5\xa8\x9f",
	"1-53-16" => "\xe5\xa8\x91",
	"1-53-17" => "\xe5\xa8\x9c",
	"1-53-18" => "\xe5\xa8\x89",
	"1-53-19" => "\xe5\xa8\x9a",
	"1-53-20" => "\xe5\xa9\x80",
	"1-53-21" => "\xe5\xa9\xac",
	"1-53-22" => "\xe5\xa9\x89",
	"1-53-23" => "\xe5\xa8\xb5",
	"1-53-24" => "\xe5\xa8\xb6",
	"1-53-25" => "\xe5\xa9\xa2",
	"1-53-26" => "\xe5\xa9\xaa",
	"1-53-27" => "\xe5\xaa\x9a",
	"1-53-28" => "\xe5\xaa\xbc",
	"1-53-29" => "\xe5\xaa\xbe",
	"1-53-30" => "\xe5\xab\x8b",
	"1-53-31" => "\xe5\xab\x82",
	"1-53-32" => "\xe5\xaa\xbd",
	"1-53-33" => "\xe5\xab\xa3",
	"1-53-34" => "\xe5\xab\x97",
	"1-53-35" => "\xe5\xab\xa6",
	"1-53-36" => "\xe5\xab\xa9",
	"1-53-37" => "\xe5\xab\x96",
	"1-53-38" => "\xe5\xab\xba",
	"1-53-39" => "\xe5\xab\xbb",
	"1-53-40" => "\xe5\xac\x8c",
	"1-53-41" => "\xe5\xac\x8b",
	"1-53-42" => "\xe5\xac\x96",
	"1-53-43" => "\xe5\xac\xb2",
	"1-53-44" => "\xe5\xab\x90",
	"1-53-45" => "\xe5\xac\xaa",
	"1-53-46" => "\xe5\xac\xb6",
	"1-53-47" => "\xe5\xac\xbe",
	"1-53-48" => "\xe5\xad\x83",
	"1-53-49" => "\xe5\xad\x85",
	"1-53-50" => "\xe5\xad\x80",
	"1-53-51" => "\xe5\xad\x91",
	"1-53-52" => "\xe5\xad\x95",
	"1-53-53" => "\xe5\xad\x9a",
	"1-53-54" => "\xe5\xad\x9b",
	"1-53-55" => "\xe5\xad\xa5",
	"1-53-56" => "\xe5\xad\xa9",
	"1-53-57" => "\xe5\xad\xb0",
	"1-53-58" => "\xe5\xad\xb3",
	"1-53-59" => "\xe5\xad\xb5",
	"1-53-60" => "\xe5\xad\xb8",
	"1-53-61" => "\xe6\x96\x88",
	"1-53-62" => "\xe5\xad\xba",
	"1-53-63" => "\xe5\xae\x80",
	"1-53-64" => "\xe5\xae\x83",
	"1-53-65" => "\xe5\xae\xa6",
	"1-53-66" => "\xe5\xae\xb8",
	"1-53-67" => "\xe5\xaf\x83",
	"1-53-68" => "\xe5\xaf\x87",
	"1-53-69" => "\xe5\xaf\x89",
	"1-53-70" => "\xe5\xaf\x94",
	"1-53-71" => "\xe5\xaf\x90",
	"1-53-72" => "\xe5\xaf\xa4",
	"1-53-73" => "\xe5\xaf\xa6",
	"1-53-74" => "\xe5\xaf\xa2",
	"1-53-75" => "\xe5\xaf\x9e",
	"1-53-76" => "\xe5\xaf\xa5",
	"1-53-77" => "\xe5\xaf\xab",
	"1-53-78" => "\xe5\xaf\xb0",
	"1-53-79" => "\xe5\xaf\xb6",
	"1-53-80" => "\xe5\xaf\xb3",
	"1-53-81" => "\xe5\xb0\x85",
	"1-53-82" => "\xe5\xb0\x87",
	"1-53-83" => "\xe5\xb0\x88",
	"1-53-84" => "\xe5\xb0\x8d",
	"1-53-85" => "\xe5\xb0\x93",
	"1-53-86" => "\xe5\xb0\xa0",
	"1-53-87" => "\xe5\xb0\xa2",
	"1-53-88" => "\xe5\xb0\xa8",
	"1-53-89" => "\xe5\xb0\xb8",
	"1-53-90" => "\xe5\xb0\xb9",
	"1-53-91" => "\xe5\xb1\x81",
	"1-53-92" => "\xe5\xb1\x86",
	"1-53-93" => "\xe5\xb1\x8e",
	"1-53-94" => "\xe5\xb1\x93",
	"1-54-1" => "\xe5\xb1\x90",
	"1-54-2" => "\xe5\xb1\x8f",
	"1-54-3" => "\xe5\xad\xb1",
	"1-54-4" => "\xe5\xb1\xac",
	"1-54-5" => "\xe5\xb1\xae",
	"1-54-6" => "\xe4\xb9\xa2",
	"1-54-7" => "\xe5\xb1\xb6",
	"1-54-8" => "\xe5\xb1\xb9",
	"1-54-9" => "\xe5\xb2\x8c",
	"1-54-10" => "\xe5\xb2\x91",
	"1-54-11" => "\xe5\xb2\x94",
	"1-54-12" => "\xe5\xa6\x9b",
	"1-54-13" => "\xe5\xb2\xab",
	"1-54-14" => "\xe5\xb2\xbb",
	"1-54-15" => "\xe5\xb2\xb6",
	"1-54-16" => "\xe5\xb2\xbc",
	"1-54-17" => "\xe5\xb2\xb7",
	"1-54-18" => "\xe5\xb3\x85",
	"1-54-19" => "\xe5\xb2\xbe",
	"1-54-20" => "\xe5\xb3\x87",
	"1-54-21" => "\xe5\xb3\x99",
	"1-54-22" => "\xe5\xb3\xa9",
	"1-54-23" => "\xe5\xb3\xbd",
	"1-54-24" => "\xe5\xb3\xba",
	"1-54-25" => "\xe5\xb3\xad",
	"1-54-26" => "\xe5\xb6\x8c",
	"1-54-27" => "\xe5\xb3\xaa",
	"1-54-28" => "\xe5\xb4\x8b",
	"1-54-29" => "\xe5\xb4\x95",
	"1-54-30" => "\xe5\xb4\x97",
	"1-54-31" => "\xe5\xb5\x9c",
	"1-54-32" => "\xe5\xb4\x9f",
	"1-54-33" => "\xe5\xb4\x9b",
	"1-54-34" => "\xe5\xb4\x91",
	"1-54-35" => "\xe5\xb4\x94",
	"1-54-36" => "\xe5\xb4\xa2",
	"1-54-37" => "\xe5\xb4\x9a",
	"1-54-38" => "\xe5\xb4\x99",
	"1-54-39" => "\xe5\xb4\x98",
	"1-54-40" => "\xe5\xb5\x8c",
	"1-54-41" => "\xe5\xb5\x92",
	"1-54-42" => "\xe5\xb5\x8e",
	"1-54-43" => "\xe5\xb5\x8b",
	"1-54-44" => "\xe5\xb5\xac",
	"1-54-45" => "\xe5\xb5\xb3",
	"1-54-46" => "\xe5\xb5\xb6",
	"1-54-47" => "\xe5\xb6\x87",
	"1-54-48" => "\xe5\xb6\x84",
	"1-54-49" => "\xe5\xb6\x82",
	"1-54-50" => "\xe5\xb6\xa2",
	"1-54-51" => "\xe5\xb6\x9d",
	"1-54-52" => "\xe5\xb6\xac",
	"1-54-53" => "\xe5\xb6\xae",
	"1-54-54" => "\xe5\xb6\xbd",
	"1-54-55" => "\xe5\xb6\x90",
	"1-54-56" => "\xe5\xb6\xb7",
	"1-54-57" => "\xe5\xb6\xbc",
	"1-54-58" => "\xe5\xb7\x89",
	"1-54-59" => "\xe5\xb7\x8d",
	"1-54-60" => "\xe5\xb7\x93",
	"1-54-61" => "\xe5\xb7\x92",
	"1-54-62" => "\xe5\xb7\x96",
	"1-54-63" => "\xe5\xb7\x9b",
	"1-54-64" => "\xe5\xb7\xab",
	"1-54-65" => "\xe5\xb7\xb2",
	"1-54-66" => "\xe5\xb7\xb5",
	"1-54-67" => "\xe5\xb8\x8b",
	"1-54-68" => "\xe5\xb8\x9a",
	"1-54-69" => "\xe5\xb8\x99",
	"1-54-70" => "\xe5\xb8\x91",
	"1-54-71" => "\xe5\xb8\x9b",
	"1-54-72" => "\xe5\xb8\xb6",
	"1-54-73" => "\xe5\xb8\xb7",
	"1-54-74" => "\xe5\xb9\x84",
	"1-54-75" => "\xe5\xb9\x83",
	"1-54-76" => "\xe5\xb9\x80",
	"1-54-77" => "\xe5\xb9\x8e",
	"1-54-78" => "\xe5\xb9\x97",
	"1-54-79" => "\xe5\xb9\x94",
	"1-54-80" => "\xe5\xb9\x9f",
	"1-54-81" => "\xe5\xb9\xa2",
	"1-54-82" => "\xe5\xb9\xa4",
	"1-54-83" => "\xe5\xb9\x87",
	"1-54-84" => "\xe5\xb9\xb5",
	"1-54-85" => "\xe5\xb9\xb6",
	"1-54-86" => "\xe5\xb9\xba",
	"1-54-87" => "\xe9\xba\xbc",
	"1-54-88" => "\xe5\xb9\xbf",
	"1-54-89" => "\xe5\xba\xa0",
	"1-54-90" => "\xe5\xbb\x81",
	"1-54-91" => "\xe5\xbb\x82",
	"1-54-92" => "\xe5\xbb\x88",
	"1-54-93" => "\xe5\xbb\x90",
	"1-54-94" => "\xe5\xbb\x8f",
	"1-55-1" => "\xe5\xbb\x96",
	"1-55-2" => "\xe5\xbb\xa3",
	"1-55-3" => "\xe5\xbb\x9d",
	"1-55-4" => "\xe5\xbb\x9a",
	"1-55-5" => "\xe5\xbb\x9b",
	"1-55-6" => "\xe5\xbb\xa2",
	"1-55-7" => "\xe5\xbb\xa1",
	"1-55-8" => "\xe5\xbb\xa8",
	"1-55-9" => "\xe5\xbb\xa9",
	"1-55-10" => "\xe5\xbb\xac",
	"1-55-11" => "\xe5\xbb\xb1",
	"1-55-12" => "\xe5\xbb\xb3",
	"1-55-13" => "\xe5\xbb\xb0",
	"1-55-14" => "\xe5\xbb\xb4",
	"1-55-15" => "\xe5\xbb\xb8",
	"1-55-16" => "\xe5\xbb\xbe",
	"1-55-17" => "\xe5\xbc\x83",
	"1-55-18" => "\xe5\xbc\x89",
	"1-55-19" => "\xe5\xbd\x9d",
	"1-55-20" => "\xe5\xbd\x9c",
	"1-55-21" => "\xe5\xbc\x8b",
	"1-55-22" => "\xe5\xbc\x91",
	"1-55-23" => "\xe5\xbc\x96",
	"1-55-24" => "\xe5\xbc\xa9",
	"1-55-25" => "\xe5\xbc\xad",
	"1-55-26" => "\xe5\xbc\xb8",
	"1-55-27" => "\xe5\xbd\x81",
	"1-55-28" => "\xe5\xbd\x88",
	"1-55-29" => "\xe5\xbd\x8c",
	"1-55-30" => "\xe5\xbd\x8e",
	"1-55-31" => "\xe5\xbc\xaf",
	"1-55-32" => "\xe5\xbd\x91",
	"1-55-33" => "\xe5\xbd\x96",
	"1-55-34" => "\xe5\xbd\x97",
	"1-55-35" => "\xe5\xbd\x99",
	"1-55-36" => "\xe5\xbd\xa1",
	"1-55-37" => "\xe5\xbd\xad",
	"1-55-38" => "\xe5\xbd\xb3",
	"1-55-39" => "\xe5\xbd\xb7",
	"1-55-40" => "\xe5\xbe\x83",
	"1-55-41" => "\xe5\xbe\x82",
	"1-55-42" => "\xe5\xbd\xbf",
	"1-55-43" => "\xe5\xbe\x8a",
	"1-55-44" => "\xe5\xbe\x88",
	"1-55-45" => "\xe5\xbe\x91",
	"1-55-46" => "\xe5\xbe\x87",
	"1-55-47" => "\xe5\xbe\x9e",
	"1-55-48" => "\xe5\xbe\x99",
	"1-55-49" => "\xe5\xbe\x98",
	"1-55-50" => "\xe5\xbe\xa0",
	"1-55-51" => "\xe5\xbe\xa8",
	"1-55-52" => "\xe5\xbe\xad",
	"1-55-53" => "\xe5\xbe\xbc",
	"1-55-54" => "\xe5\xbf\x96",
	"1-55-55" => "\xe5\xbf\xbb",
	"1-55-56" => "\xe5\xbf\xa4",
	"1-55-57" => "\xe5\xbf\xb8",
	"1-55-58" => "\xe5\xbf\xb1",
	"1-55-59" => "\xe5\xbf\x9d",
	"1-55-60" => "\xe6\x82\xb3",
	"1-55-61" => "\xe5\xbf\xbf",
	"1-55-62" => "\xe6\x80\xa1",
	"1-55-63" => "\xe6\x81\xa0",
	"1-55-64" => "\xe6\x80\x99",
	"1-55-65" => "\xe6\x80\x90",
	"1-55-66" => "\xe6\x80\xa9",
	"1-55-67" => "\xe6\x80\x8e",
	"1-55-68" => "\xe6\x80\xb1",
	"1-55-69" => "\xe6\x80\x9b",
	"1-55-70" => "\xe6\x80\x95",
	"1-55-71" => "\xe6\x80\xab",
	"1-55-72" => "\xe6\x80\xa6",
	"1-55-73" => "\xe6\x80\x8f",
	"1-55-74" => "\xe6\x80\xba",
	"1-55-75" => "\xe6\x81\x9a",
	"1-55-76" => "\xe6\x81\x81",
	"1-55-77" => "\xe6\x81\xaa",
	"1-55-78" => "\xe6\x81\xb7",
	"1-55-79" => "\xe6\x81\x9f",
	"1-55-80" => "\xe6\x81\x8a",
	"1-55-81" => "\xe6\x81\x86",
	"1-55-82" => "\xe6\x81\x8d",
	"1-55-83" => "\xe6\x81\xa3",
	"1-55-84" => "\xe6\x81\x83",
	"1-55-85" => "\xe6\x81\xa4",
	"1-55-86" => "\xe6\x81\x82",
	"1-55-87" => "\xe6\x81\xac",
	"1-55-88" => "\xe6\x81\xab",
	"1-55-89" => "\xe6\x81\x99",
	"1-55-90" => "\xe6\x82\x81",
	"1-55-91" => "\xe6\x82\x8d",
	"1-55-92" => "\xe6\x83\xa7",
	"1-55-93" => "\xe6\x82\x83",
	"1-55-94" => "\xe6\x82\x9a",
	"1-56-1" => "\xe6\x82\x84",
	"1-56-2" => "\xe6\x82\x9b",
	"1-56-3" => "\xe6\x82\x96",
	"1-56-4" => "\xe6\x82\x97",
	"1-56-5" => "\xe6\x82\x92",
	"1-56-6" => "\xe6\x82\xa7",
	"1-56-7" => "\xe6\x82\x8b",
	"1-56-8" => "\xe6\x83\xa1",
	"1-56-9" => "\xe6\x82\xb8",
	"1-56-10" => "\xe6\x83\xa0",
	"1-56-11" => "\xe6\x83\x93",
	"1-56-12" => "\xe6\x82\xb4",
	"1-56-13" => "\xe5\xbf\xb0",
	"1-56-14" => "\xe6\x82\xbd",
	"1-56-15" => "\xe6\x83\x86",
	"1-56-16" => "\xe6\x82\xb5",
	"1-56-17" => "\xe6\x83\x98",
	"1-56-18" => "\xe6\x85\x8d",
	"1-56-19" => "\xe6\x84\x95",
	"1-56-20" => "\xe6\x84\x86",
	"1-56-21" => "\xe6\x83\xb6",
	"1-56-22" => "\xe6\x83\xb7",
	"1-56-23" => "\xe6\x84\x80",
	"1-56-24" => "\xe6\x83\xb4",
	"1-56-25" => "\xe6\x83\xba",
	"1-56-26" => "\xe6\x84\x83",
	"1-56-27" => "\xe6\x84\xa1",
	"1-56-28" => "\xe6\x83\xbb",
	"1-56-29" => "\xe6\x83\xb1",
	"1-56-30" => "\xe6\x84\x8d",
	"1-56-31" => "\xe6\x84\x8e",
	"1-56-32" => "\xe6\x85\x87",
	"1-56-33" => "\xe6\x84\xbe",
	"1-56-34" => "\xe6\x84\xa8",
	"1-56-35" => "\xe6\x84\xa7",
	"1-56-36" => "\xe6\x85\x8a",
	"1-56-37" => "\xe6\x84\xbf",
	"1-56-38" => "\xe6\x84\xbc",
	"1-56-39" => "\xe6\x84\xac",
	"1-56-40" => "\xe6\x84\xb4",
	"1-56-41" => "\xe6\x84\xbd",
	"1-56-42" => "\xe6\x85\x82",
	"1-56-43" => "\xe6\x85\x84",
	"1-56-44" => "\xe6\x85\xb3",
	"1-56-45" => "\xe6\x85\xb7",
	"1-56-46" => "\xe6\x85\x98",
	"1-56-47" => "\xe6\x85\x99",
	"1-56-48" => "\xe6\x85\x9a",
	"1-56-49" => "\xe6\x85\xab",
	"1-56-50" => "\xe6\x85\xb4",
	"1-56-51" => "\xe6\x85\xaf",
	"1-56-52" => "\xe6\x85\xa5",
	"1-56-53" => "\xe6\x85\xb1",
	"1-56-54" => "\xe6\x85\x9f",
	"1-56-55" => "\xe6\x85\x9d",
	"1-56-56" => "\xe6\x85\x93",
	"1-56-57" => "\xe6\x85\xb5",
	"1-56-58" => "\xe6\x86\x99",
	"1-56-59" => "\xe6\x86\x96",
	"1-56-60" => "\xe6\x86\x87",
	"1-56-61" => "\xe6\x86\xac",
	"1-56-62" => "\xe6\x86\x94",
	"1-56-63" => "\xe6\x86\x9a",
	"1-56-64" => "\xe6\x86\x8a",
	"1-56-65" => "\xe6\x86\x91",
	"1-56-66" => "\xe6\x86\xab",
	"1-56-67" => "\xe6\x86\xae",
	"1-56-68" => "\xe6\x87\x8c",
	"1-56-69" => "\xe6\x87\x8a",
	"1-56-70" => "\xe6\x87\x89",
	"1-56-71" => "\xe6\x87\xb7",
	"1-56-72" => "\xe6\x87\x88",
	"1-56-73" => "\xe6\x87\x83",
	"1-56-74" => "\xe6\x87\x86",
	"1-56-75" => "\xe6\x86\xba",
	"1-56-76" => "\xe6\x87\x8b",
	"1-56-77" => "\xe7\xbd\xb9",
	"1-56-78" => "\xe6\x87\x8d",
	"1-56-79" => "\xe6\x87\xa6",
	"1-56-80" => "\xe6\x87\xa3",
	"1-56-81" => "\xe6\x87\xb6",
	"1-56-82" => "\xe6\x87\xba",
	"1-56-83" => "\xe6\x87\xb4",
	"1-56-84" => "\xe6\x87\xbf",
	"1-56-85" => "\xe6\x87\xbd",
	"1-56-86" => "\xe6\x87\xbc",
	"1-56-87" => "\xe6\x87\xbe",
	"1-56-88" => "\xe6\x88\x80",
	"1-56-89" => "\xe6\x88\x88",
	"1-56-90" => "\xe6\x88\x89",
	"1-56-91" => "\xe6\x88\x8d",
	"1-56-92" => "\xe6\x88\x8c",
	"1-56-93" => "\xe6\x88\x94",
	"1-56-94" => "\xe6\x88\x9b",
	"1-57-1" => "\xe6\x88\x9e",
	"1-57-2" => "\xe6\x88\xa1",
	"1-57-3" => "\xe6\x88\xaa",
	"1-57-4" => "\xe6\x88\xae",
	"1-57-5" => "\xe6\x88\xb0",
	"1-57-6" => "\xe6\x88\xb2",
	"1-57-7" => "\xe6\x88\xb3",
	"1-57-8" => "\xe6\x89\x81",
	"1-57-9" => "\xe6\x89\x8e",
	"1-57-10" => "\xe6\x89\x9e",
	"1-57-11" => "\xe6\x89\xa3",
	"1-57-12" => "\xe6\x89\x9b",
	"1-57-13" => "\xe6\x89\xa0",
	"1-57-14" => "\xe6\x89\xa8",
	"1-57-15" => "\xe6\x89\xbc",
	"1-57-16" => "\xe6\x8a\x82",
	"1-57-17" => "\xe6\x8a\x89",
	"1-57-18" => "\xe6\x89\xbe",
	"1-57-19" => "\xe6\x8a\x92",
	"1-57-20" => "\xe6\x8a\x93",
	"1-57-21" => "\xe6\x8a\x96",
	"1-57-22" => "\xe6\x8b\x94",
	"1-57-23" => "\xe6\x8a\x83",
	"1-57-24" => "\xe6\x8a\x94",
	"1-57-25" => "\xe6\x8b\x97",
	"1-57-26" => "\xe6\x8b\x91",
	"1-57-27" => "\xe6\x8a\xbb",
	"1-57-28" => "\xe6\x8b\x8f",
	"1-57-29" => "\xe6\x8b\xbf",
	"1-57-30" => "\xe6\x8b\x86",
	"1-57-31" => "\xe6\x93\x94",
	"1-57-32" => "\xe6\x8b\x88",
	"1-57-33" => "\xe6\x8b\x9c",
	"1-57-34" => "\xe6\x8b\x8c",
	"1-57-35" => "\xe6\x8b\x8a",
	"1-57-36" => "\xe6\x8b\x82",
	"1-57-37" => "\xe6\x8b\x87",
	"1-57-38" => "\xe6\x8a\x9b",
	"1-57-39" => "\xe6\x8b\x89",
	"1-57-40" => "\xe6\x8c\x8c",
	"1-57-41" => "\xe6\x8b\xae",
	"1-57-42" => "\xe6\x8b\xb1",
	"1-57-43" => "\xe6\x8c\xa7",
	"1-57-44" => "\xe6\x8c\x82",
	"1-57-45" => "\xe6\x8c\x88",
	"1-57-46" => "\xe6\x8b\xaf",
	"1-57-47" => "\xe6\x8b\xb5",
	"1-57-48" => "\xe6\x8d\x90",
	"1-57-49" => "\xe6\x8c\xbe",
	"1-57-50" => "\xe6\x8d\x8d",
	"1-57-51" => "\xe6\x90\x9c",
	"1-57-52" => "\xe6\x8d\x8f",
	"1-57-53" => "\xe6\x8e\x96",
	"1-57-54" => "\xe6\x8e\x8e",
	"1-57-55" => "\xe6\x8e\x80",
	"1-57-56" => "\xe6\x8e\xab",
	"1-57-57" => "\xe6\x8d\xb6",
	"1-57-58" => "\xe6\x8e\xa3",
	"1-57-59" => "\xe6\x8e\x8f",
	"1-57-60" => "\xe6\x8e\x89",
	"1-57-61" => "\xe6\x8e\x9f",
	"1-57-62" => "\xe6\x8e\xb5",
	"1-57-63" => "\xe6\x8d\xab",
	"1-57-64" => "\xe6\x8d\xa9",
	"1-57-65" => "\xe6\x8e\xbe",
	"1-57-66" => "\xe6\x8f\xa9",
	"1-57-67" => "\xe6\x8f\x80",
	"1-57-68" => "\xe6\x8f\x86",
	"1-57-69" => "\xe6\x8f\xa3",
	"1-57-70" => "\xe6\x8f\x89",
	"1-57-71" => "\xe6\x8f\x92",
	"1-57-72" => "\xe6\x8f\xb6",
	"1-57-73" => "\xe6\x8f\x84",
	"1-57-74" => "\xe6\x90\x96",
	"1-57-75" => "\xe6\x90\xb4",
	"1-57-76" => "\xe6\x90\x86",
	"1-57-77" => "\xe6\x90\x93",
	"1-57-78" => "\xe6\x90\xa6",
	"1-57-79" => "\xe6\x90\xb6",
	"1-57-80" => "\xe6\x94\x9d",
	"1-57-81" => "\xe6\x90\x97",
	"1-57-82" => "\xe6\x90\xa8",
	"1-57-83" => "\xe6\x90\x8f",
	"1-57-84" => "\xe6\x91\xa7",
	"1-57-85" => "\xe6\x91\xaf",
	"1-57-86" => "\xe6\x91\xb6",
	"1-57-87" => "\xe6\x91\x8e",
	"1-57-88" => "\xe6\x94\xaa",
	"1-57-89" => "\xe6\x92\x95",
	"1-57-90" => "\xe6\x92\x93",
	"1-57-91" => "\xe6\x92\xa5",
	"1-57-92" => "\xe6\x92\xa9",
	"1-57-93" => "\xe6\x92\x88",
	"1-57-94" => "\xe6\x92\xbc",
	"1-58-1" => "\xe6\x93\x9a",
	"1-58-2" => "\xe6\x93\x92",
	"1-58-3" => "\xe6\x93\x85",
	"1-58-4" => "\xe6\x93\x87",
	"1-58-5" => "\xe6\x92\xbb",
	"1-58-6" => "\xe6\x93\x98",
	"1-58-7" => "\xe6\x93\x82",
	"1-58-8" => "\xe6\x93\xb1",
	"1-58-9" => "\xe6\x93\xa7",
	"1-58-10" => "\xe8\x88\x89",
	"1-58-11" => "\xe6\x93\xa0",
	"1-58-12" => "\xe6\x93\xa1",
	"1-58-13" => "\xe6\x8a\xac",
	"1-58-14" => "\xe6\x93\xa3",
	"1-58-15" => "\xe6\x93\xaf",
	"1-58-16" => "\xe6\x94\xac",
	"1-58-17" => "\xe6\x93\xb6",
	"1-58-18" => "\xe6\x93\xb4",
	"1-58-19" => "\xe6\x93\xb2",
	"1-58-20" => "\xe6\x93\xba",
	"1-58-21" => "\xe6\x94\x80",
	"1-58-22" => "\xe6\x93\xbd",
	"1-58-23" => "\xe6\x94\x98",
	"1-58-24" => "\xe6\x94\x9c",
	"1-58-25" => "\xe6\x94\x85",
	"1-58-26" => "\xe6\x94\xa4",
	"1-58-27" => "\xe6\x94\xa3",
	"1-58-28" => "\xe6\x94\xab",
	"1-58-29" => "\xe6\x94\xb4",
	"1-58-30" => "\xe6\x94\xb5",
	"1-58-31" => "\xe6\x94\xb7",
	"1-58-32" => "\xe6\x94\xb6",
	"1-58-33" => "\xe6\x94\xb8",
	"1-58-34" => "\xe7\x95\x8b",
	"1-58-35" => "\xe6\x95\x88",
	"1-58-36" => "\xe6\x95\x96",
	"1-58-37" => "\xe6\x95\x95",
	"1-58-38" => "\xe6\x95\x8d",
	"1-58-39" => "\xe6\x95\x98",
	"1-58-40" => "\xe6\x95\x9e",
	"1-58-41" => "\xe6\x95\x9d",
	"1-58-42" => "\xe6\x95\xb2",
	"1-58-43" => "\xe6\x95\xb8",
	"1-58-44" => "\xe6\x96\x82",
	"1-58-45" => "\xe6\x96\x83",
	"1-58-46" => "\xe8\xae\x8a",
	"1-58-47" => "\xe6\x96\x9b",
	"1-58-48" => "\xe6\x96\x9f",
	"1-58-49" => "\xe6\x96\xab",
	"1-58-50" => "\xe6\x96\xb7",
	"1-58-51" => "\xe6\x97\x83",
	"1-58-52" => "\xe6\x97\x86",
	"1-58-53" => "\xe6\x97\x81",
	"1-58-54" => "\xe6\x97\x84",
	"1-58-55" => "\xe6\x97\x8c",
	"1-58-56" => "\xe6\x97\x92",
	"1-58-57" => "\xe6\x97\x9b",
	"1-58-58" => "\xe6\x97\x99",
	"1-58-59" => "\xe6\x97\xa0",
	"1-58-60" => "\xe6\x97\xa1",
	"1-58-61" => "\xe6\x97\xb1",
	"1-58-62" => "\xe6\x9d\xb2",
	"1-58-63" => "\xe6\x98\x8a",
	"1-58-64" => "\xe6\x98\x83",
	"1-58-65" => "\xe6\x97\xbb",
	"1-58-66" => "\xe6\x9d\xb3",
	"1-58-67" => "\xe6\x98\xb5",
	"1-58-68" => "\xe6\x98\xb6",
	"1-58-69" => "\xe6\x98\xb4",
	"1-58-70" => "\xe6\x98\x9c",
	"1-58-71" => "\xe6\x99\x8f",
	"1-58-72" => "\xe6\x99\x84",
	"1-58-73" => "\xe6\x99\x89",
	"1-58-74" => "\xe6\x99\x81",
	"1-58-75" => "\xe6\x99\x9e",
	"1-58-76" => "\xe6\x99\x9d",
	"1-58-77" => "\xe6\x99\xa4",
	"1-58-78" => "\xe6\x99\xa7",
	"1-58-79" => "\xe6\x99\xa8",
	"1-58-80" => "\xe6\x99\x9f",
	"1-58-81" => "\xe6\x99\xa2",
	"1-58-82" => "\xe6\x99\xb0",
	"1-58-83" => "\xe6\x9a\x83",
	"1-58-84" => "\xe6\x9a\x88",
	"1-58-85" => "\xe6\x9a\x8e",
	"1-58-86" => "\xe6\x9a\x89",
	"1-58-87" => "\xe6\x9a\x84",
	"1-58-88" => "\xe6\x9a\x98",
	"1-58-89" => "\xe6\x9a\x9d",
	"1-58-90" => "\xe6\x9b\x81",
	"1-58-91" => "\xe6\x9a\xb9",
	"1-58-92" => "\xe6\x9b\x89",
	"1-58-93" => "\xe6\x9a\xbe",
	"1-58-94" => "\xe6\x9a\xbc",
	"1-59-1" => "\xe6\x9b\x84",
	"1-59-2" => "\xe6\x9a\xb8",
	"1-59-3" => "\xe6\x9b\x96",
	"1-59-4" => "\xe6\x9b\x9a",
	"1-59-5" => "\xe6\x9b\xa0",
	"1-59-6" => "\xe6\x98\xbf",
	"1-59-7" => "\xe6\x9b\xa6",
	"1-59-8" => "\xe6\x9b\xa9",
	"1-59-9" => "\xe6\x9b\xb0",
	"1-59-10" => "\xe6\x9b\xb5",
	"1-59-11" => "\xe6\x9b\xb7",
	"1-59-12" => "\xe6\x9c\x8f",
	"1-59-13" => "\xe6\x9c\x96",
	"1-59-14" => "\xe6\x9c\x9e",
	"1-59-15" => "\xe6\x9c\xa6",
	"1-59-16" => "\xe6\x9c\xa7",
	"1-59-17" => "\xe9\x9c\xb8",
	"1-59-18" => "\xe6\x9c\xae",
	"1-59-19" => "\xe6\x9c\xbf",
	"1-59-20" => "\xe6\x9c\xb6",
	"1-59-21" => "\xe6\x9d\x81",
	"1-59-22" => "\xe6\x9c\xb8",
	"1-59-23" => "\xe6\x9c\xb7",
	"1-59-24" => "\xe6\x9d\x86",
	"1-59-25" => "\xe6\x9d\x9e",
	"1-59-26" => "\xe6\x9d\xa0",
	"1-59-27" => "\xe6\x9d\x99",
	"1-59-28" => "\xe6\x9d\xa3",
	"1-59-29" => "\xe6\x9d\xa4",
	"1-59-30" => "\xe6\x9e\x89",
	"1-59-31" => "\xe6\x9d\xb0",
	"1-59-32" => "\xe6\x9e\xa9",
	"1-59-33" => "\xe6\x9d\xbc",
	"1-59-34" => "\xe6\x9d\xaa",
	"1-59-35" => "\xe6\x9e\x8c",
	"1-59-36" => "\xe6\x9e\x8b",
	"1-59-37" => "\xe6\x9e\xa6",
	"1-59-38" => "\xe6\x9e\xa1",
	"1-59-39" => "\xe6\x9e\x85",
	"1-59-40" => "\xe6\x9e\xb7",
	"1-59-41" => "\xe6\x9f\xaf",
	"1-59-42" => "\xe6\x9e\xb4",
	"1-59-43" => "\xe6\x9f\xac",
	"1-59-44" => "\xe6\x9e\xb3",
	"1-59-45" => "\xe6\x9f\xa9",
	"1-59-46" => "\xe6\x9e\xb8",
	"1-59-47" => "\xe6\x9f\xa4",
	"1-59-48" => "\xe6\x9f\x9e",
	"1-59-49" => "\xe6\x9f\x9d",
	"1-59-50" => "\xe6\x9f\xa2",
	"1-59-51" => "\xe6\x9f\xae",
	"1-59-52" => "\xe6\x9e\xb9",
	"1-59-53" => "\xe6\x9f\x8e",
	"1-59-54" => "\xe6\x9f\x86",
	"1-59-55" => "\xe6\x9f\xa7",
	"1-59-56" => "\xe6\xaa\x9c",
	"1-59-57" => "\xe6\xa0\x9e",
	"1-59-58" => "\xe6\xa1\x86",
	"1-59-59" => "\xe6\xa0\xa9",
	"1-59-60" => "\xe6\xa1\x80",
	"1-59-61" => "\xe6\xa1\x8d",
	"1-59-62" => "\xe6\xa0\xb2",
	"1-59-63" => "\xe6\xa1\x8e",
	"1-59-64" => "\xe6\xa2\xb3",
	"1-59-65" => "\xe6\xa0\xab",
	"1-59-66" => "\xe6\xa1\x99",
	"1-59-67" => "\xe6\xa1\xa3",
	"1-59-68" => "\xe6\xa1\xb7",
	"1-59-69" => "\xe6\xa1\xbf",
	"1-59-70" => "\xe6\xa2\x9f",
	"1-59-71" => "\xe6\xa2\x8f",
	"1-59-72" => "\xe6\xa2\xad",
	"1-59-73" => "\xe6\xa2\x94",
	"1-59-74" => "\xe6\xa2\x9d",
	"1-59-75" => "\xe6\xa2\x9b",
	"1-59-76" => "\xe6\xa2\x83",
	"1-59-77" => "\xe6\xaa\xae",
	"1-59-78" => "\xe6\xa2\xb9",
	"1-59-79" => "\xe6\xa1\xb4",
	"1-59-80" => "\xe6\xa2\xb5",
	"1-59-81" => "\xe6\xa2\xa0",
	"1-59-82" => "\xe6\xa2\xba",
	"1-59-83" => "\xe6\xa4\x8f",
	"1-59-84" => "\xe6\xa2\x8d",
	"1-59-85" => "\xe6\xa1\xbe",
	"1-59-86" => "\xe6\xa4\x81",
	"1-59-87" => "\xe6\xa3\x8a",
	"1-59-88" => "\xe6\xa4\x88",
	"1-59-89" => "\xe6\xa3\x98",
	"1-59-90" => "\xe6\xa4\xa2",
	"1-59-91" => "\xe6\xa4\xa6",
	"1-59-92" => "\xe6\xa3\xa1",
	"1-59-93" => "\xe6\xa4\x8c",
	"1-59-94" => "\xe6\xa3\x8d",
	"1-60-1" => "\xe6\xa3\x94",
	"1-60-2" => "\xe6\xa3\xa7",
	"1-60-3" => "\xe6\xa3\x95",
	"1-60-4" => "\xe6\xa4\xb6",
	"1-60-5" => "\xe6\xa4\x92",
	"1-60-6" => "\xe6\xa4\x84",
	"1-60-7" => "\xe6\xa3\x97",
	"1-60-8" => "\xe6\xa3\xa3",
	"1-60-9" => "\xe6\xa4\xa5",
	"1-60-10" => "\xe6\xa3\xb9",
	"1-60-11" => "\xe6\xa3\xa0",
	"1-60-12" => "\xe6\xa3\xaf",
	"1-60-13" => "\xe6\xa4\xa8",
	"1-60-14" => "\xe6\xa4\xaa",
	"1-60-15" => "\xe6\xa4\x9a",
	"1-60-16" => "\xe6\xa4\xa3",
	"1-60-17" => "\xe6\xa4\xa1",
	"1-60-18" => "\xe6\xa3\x86",
	"1-60-19" => "\xe6\xa5\xb9",
	"1-60-20" => "\xe6\xa5\xb7",
	"1-60-21" => "\xe6\xa5\x9c",
	"1-60-22" => "\xe6\xa5\xb8",
	"1-60-23" => "\xe6\xa5\xab",
	"1-60-24" => "\xe6\xa5\x94",
	"1-60-25" => "\xe6\xa5\xbe",
	"1-60-26" => "\xe6\xa5\xae",
	"1-60-27" => "\xe6\xa4\xb9",
	"1-60-28" => "\xe6\xa5\xb4",
	"1-60-29" => "\xe6\xa4\xbd",
	"1-60-30" => "\xe6\xa5\x99",
	"1-60-31" => "\xe6\xa4\xb0",
	"1-60-32" => "\xe6\xa5\xa1",
	"1-60-33" => "\xe6\xa5\x9e",
	"1-60-34" => "\xe6\xa5\x9d",
	"1-60-35" => "\xe6\xa6\x81",
	"1-60-36" => "\xe6\xa5\xaa",
	"1-60-37" => "\xe6\xa6\xb2",
	"1-60-38" => "\xe6\xa6\xae",
	"1-60-39" => "\xe6\xa7\x90",
	"1-60-40" => "\xe6\xa6\xbf",
	"1-60-41" => "\xe6\xa7\x81",
	"1-60-42" => "\xe6\xa7\x93",
	"1-60-43" => "\xe6\xa6\xbe",
	"1-60-44" => "\xe6\xa7\x8e",
	"1-60-45" => "\xe5\xaf\xa8",
	"1-60-46" => "\xe6\xa7\x8a",
	"1-60-47" => "\xe6\xa7\x9d",
	"1-60-48" => "\xe6\xa6\xbb",
	"1-60-49" => "\xe6\xa7\x83",
	"1-60-50" => "\xe6\xa6\xa7",
	"1-60-51" => "\xe6\xa8\xae",
	"1-60-52" => "\xe6\xa6\x91",
	"1-60-53" => "\xe6\xa6\xa0",
	"1-60-54" => "\xe6\xa6\x9c",
	"1-60-55" => "\xe6\xa6\x95",
	"1-60-56" => "\xe6\xa6\xb4",
	"1-60-57" => "\xe6\xa7\x9e",
	"1-60-58" => "\xe6\xa7\xa8",
	"1-60-59" => "\xe6\xa8\x82",
	"1-60-60" => "\xe6\xa8\x9b",
	"1-60-61" => "\xe6\xa7\xbf",
	"1-60-62" => "\xe6\xac\x8a",
	"1-60-63" => "\xe6\xa7\xb9",
	"1-60-64" => "\xe6\xa7\xb2",
	"1-60-65" => "\xe6\xa7\xa7",
	"1-60-66" => "\xe6\xa8\x85",
	"1-60-67" => "\xe6\xa6\xb1",
	"1-60-68" => "\xe6\xa8\x9e",
	"1-60-69" => "\xe6\xa7\xad",
	"1-60-70" => "\xe6\xa8\x94",
	"1-60-71" => "\xe6\xa7\xab",
	"1-60-72" => "\xe6\xa8\x8a",
	"1-60-73" => "\xe6\xa8\x92",
	"1-60-74" => "\xe6\xab\x81",
	"1-60-75" => "\xe6\xa8\xa3",
	"1-60-76" => "\xe6\xa8\x93",
	"1-60-77" => "\xe6\xa9\x84",
	"1-60-78" => "\xe6\xa8\x8c",
	"1-60-79" => "\xe6\xa9\xb2",
	"1-60-80" => "\xe6\xa8\xb6",
	"1-60-81" => "\xe6\xa9\xb8",
	"1-60-82" => "\xe6\xa9\x87",
	"1-60-83" => "\xe6\xa9\xa2",
	"1-60-84" => "\xe6\xa9\x99",
	"1-60-85" => "\xe6\xa9\xa6",
	"1-60-86" => "\xe6\xa9\x88",
	"1-60-87" => "\xe6\xa8\xb8",
	"1-60-88" => "\xe6\xa8\xa2",
	"1-60-89" => "\xe6\xaa\x90",
	"1-60-90" => "\xe6\xaa\x8d",
	"1-60-91" => "\xe6\xaa\xa0",
	"1-60-92" => "\xe6\xaa\x84",
	"1-60-93" => "\xe6\xaa\xa2",
	"1-60-94" => "\xe6\xaa\xa3",
	"1-61-1" => "\xe6\xaa\x97",
	"1-61-2" => "\xe8\x98\x97",
	"1-61-3" => "\xe6\xaa\xbb",
	"1-61-4" => "\xe6\xab\x83",
	"1-61-5" => "\xe6\xab\x82",
	"1-61-6" => "\xe6\xaa\xb8",
	"1-61-7" => "\xe6\xaa\xb3",
	"1-61-8" => "\xe6\xaa\xac",
	"1-61-9" => "\xe6\xab\x9e",
	"1-61-10" => "\xe6\xab\x91",
	"1-61-11" => "\xe6\xab\x9f",
	"1-61-12" => "\xe6\xaa\xaa",
	"1-61-13" => "\xe6\xab\x9a",
	"1-61-14" => "\xe6\xab\xaa",
	"1-61-15" => "\xe6\xab\xbb",
	"1-61-16" => "\xe6\xac\x85",
	"1-61-17" => "\xe8\x98\x96",
	"1-61-18" => "\xe6\xab\xba",
	"1-61-19" => "\xe6\xac\x92",
	"1-61-20" => "\xe6\xac\x96",
	"1-61-21" => "\xe9\xac\xb1",
	"1-61-22" => "\xe6\xac\x9f",
	"1-61-23" => "\xe6\xac\xb8",
	"1-61-24" => "\xe6\xac\xb7",
	"1-61-25" => "\xe7\x9b\x9c",
	"1-61-26" => "\xe6\xac\xb9",
	"1-61-27" => "\xe9\xa3\xae",
	"1-61-28" => "\xe6\xad\x87",
	"1-61-29" => "\xe6\xad\x83",
	"1-61-30" => "\xe6\xad\x89",
	"1-61-31" => "\xe6\xad\x90",
	"1-61-32" => "\xe6\xad\x99",
	"1-61-33" => "\xe6\xad\x94",
	"1-61-34" => "\xe6\xad\x9b",
	"1-61-35" => "\xe6\xad\x9f",
	"1-61-36" => "\xe6\xad\xa1",
	"1-61-37" => "\xe6\xad\xb8",
	"1-61-38" => "\xe6\xad\xb9",
	"1-61-39" => "\xe6\xad\xbf",
	"1-61-40" => "\xe6\xae\x80",
	"1-61-41" => "\xe6\xae\x84",
	"1-61-42" => "\xe6\xae\x83",
	"1-61-43" => "\xe6\xae\x8d",
	"1-61-44" => "\xe6\xae\x98",
	"1-61-45" => "\xe6\xae\x95",
	"1-61-46" => "\xe6\xae\x9e",
	"1-61-47" => "\xe6\xae\xa4",
	"1-61-48" => "\xe6\xae\xaa",
	"1-61-49" => "\xe6\xae\xab",
	"1-61-50" => "\xe6\xae\xaf",
	"1-61-51" => "\xe6\xae\xb2",
	"1-61-52" => "\xe6\xae\xb1",
	"1-61-53" => "\xe6\xae\xb3",
	"1-61-54" => "\xe6\xae\xb7",
	"1-61-55" => "\xe6\xae\xbc",
	"1-61-56" => "\xe6\xaf\x86",
	"1-61-57" => "\xe6\xaf\x8b",
	"1-61-58" => "\xe6\xaf\x93",
	"1-61-59" => "\xe6\xaf\x9f",
	"1-61-60" => "\xe6\xaf\xac",
	"1-61-61" => "\xe6\xaf\xab",
	"1-61-62" => "\xe6\xaf\xb3",
	"1-61-63" => "\xe6\xaf\xaf",
	"1-61-64" => "\xe9\xba\xbe",
	"1-61-65" => "\xe6\xb0\x88",
	"1-61-66" => "\xe6\xb0\x93",
	"1-61-67" => "\xe6\xb0\x94",
	"1-61-68" => "\xe6\xb0\x9b",
	"1-61-69" => "\xe6\xb0\xa4",
	"1-61-70" => "\xe6\xb0\xa3",
	"1-61-71" => "\xe6\xb1\x9e",
	"1-61-72" => "\xe6\xb1\x95",
	"1-61-73" => "\xe6\xb1\xa2",
	"1-61-74" => "\xe6\xb1\xaa",
	"1-61-75" => "\xe6\xb2\x82",
	"1-61-76" => "\xe6\xb2\x8d",
	"1-61-77" => "\xe6\xb2\x9a",
	"1-61-78" => "\xe6\xb2\x81",
	"1-61-79" => "\xe6\xb2\x9b",
	"1-61-80" => "\xe6\xb1\xbe",
	"1-61-81" => "\xe6\xb1\xa8",
	"1-61-82" => "\xe6\xb1\xb3",
	"1-61-83" => "\xe6\xb2\x92",
	"1-61-84" => "\xe6\xb2\x90",
	"1-61-85" => "\xe6\xb3\x84",
	"1-61-86" => "\xe6\xb3\xb1",
	"1-61-87" => "\xe6\xb3\x93",
	"1-61-88" => "\xe6\xb2\xbd",
	"1-61-89" => "\xe6\xb3\x97",
	"1-61-90" => "\xe6\xb3\x85",
	"1-61-91" => "\xe6\xb3\x9d",
	"1-61-92" => "\xe6\xb2\xae",
	"1-61-93" => "\xe6\xb2\xb1",
	"1-61-94" => "\xe6\xb2\xbe",
	"1-62-1" => "\xe6\xb2\xba",
	"1-62-2" => "\xe6\xb3\x9b",
	"1-62-3" => "\xe6\xb3\xaf",
	"1-62-4" => "\xe6\xb3\x99",
	"1-62-5" => "\xe6\xb3\xaa",
	"1-62-6" => "\xe6\xb4\x9f",
	"1-62-7" => "\xe8\xa1\x8d",
	"1-62-8" => "\xe6\xb4\xb6",
	"1-62-9" => "\xe6\xb4\xab",
	"1-62-10" => "\xe6\xb4\xbd",
	"1-62-11" => "\xe6\xb4\xb8",
	"1-62-12" => "\xe6\xb4\x99",
	"1-62-13" => "\xe6\xb4\xb5",
	"1-62-14" => "\xe6\xb4\xb3",
	"1-62-15" => "\xe6\xb4\x92",
	"1-62-16" => "\xe6\xb4\x8c",
	"1-62-17" => "\xe6\xb5\xa3",
	"1-62-18" => "\xe6\xb6\x93",
	"1-62-19" => "\xe6\xb5\xa4",
	"1-62-20" => "\xe6\xb5\x9a",
	"1-62-21" => "\xe6\xb5\xb9",
	"1-62-22" => "\xe6\xb5\x99",
	"1-62-23" => "\xe6\xb6\x8e",
	"1-62-24" => "\xe6\xb6\x95",
	"1-62-25" => "\xe6\xbf\xa4",
	"1-62-26" => "\xe6\xb6\x85",
	"1-62-27" => "\xe6\xb7\xb9",
	"1-62-28" => "\xe6\xb8\x95",
	"1-62-29" => "\xe6\xb8\x8a",
	"1-62-30" => "\xe6\xb6\xb5",
	"1-62-31" => "\xe6\xb7\x87",
	"1-62-32" => "\xe6\xb7\xa6",
	"1-62-33" => "\xe6\xb6\xb8",
	"1-62-34" => "\xe6\xb7\x86",
	"1-62-35" => "\xe6\xb7\xac",
	"1-62-36" => "\xe6\xb7\x9e",
	"1-62-37" => "\xe6\xb7\x8c",
	"1-62-38" => "\xe6\xb7\xa8",
	"1-62-39" => "\xe6\xb7\x92",
	"1-62-40" => "\xe6\xb7\x85",
	"1-62-41" => "\xe6\xb7\xba",
	"1-62-42" => "\xe6\xb7\x99",
	"1-62-43" => "\xe6\xb7\xa4",
	"1-62-44" => "\xe6\xb7\x95",
	"1-62-45" => "\xe6\xb7\xaa",
	"1-62-46" => "\xe6\xb7\xae",
	"1-62-47" => "\xe6\xb8\xad",
	"1-62-48" => "\xe6\xb9\xae",
	"1-62-49" => "\xe6\xb8\xae",
	"1-62-50" => "\xe6\xb8\x99",
	"1-62-51" => "\xe6\xb9\xb2",
	"1-62-52" => "\xe6\xb9\x9f",
	"1-62-53" => "\xe6\xb8\xbe",
	"1-62-54" => "\xe6\xb8\xa3",
	"1-62-55" => "\xe6\xb9\xab",
	"1-62-56" => "\xe6\xb8\xab",
	"1-62-57" => "\xe6\xb9\xb6",
	"1-62-58" => "\xe6\xb9\x8d",
	"1-62-59" => "\xe6\xb8\x9f",
	"1-62-60" => "\xe6\xb9\x83",
	"1-62-61" => "\xe6\xb8\xba",
	"1-62-62" => "\xe6\xb9\x8e",
	"1-62-63" => "\xe6\xb8\xa4",
	"1-62-64" => "\xe6\xbb\xbf",
	"1-62-65" => "\xe6\xb8\x9d",
	"1-62-66" => "\xe6\xb8\xb8",
	"1-62-67" => "\xe6\xba\x82",
	"1-62-68" => "\xe6\xba\xaa",
	"1-62-69" => "\xe6\xba\x98",
	"1-62-70" => "\xe6\xbb\x89",
	"1-62-71" => "\xe6\xba\xb7",
	"1-62-72" => "\xe6\xbb\x93",
	"1-62-73" => "\xe6\xba\xbd",
	"1-62-74" => "\xe6\xba\xaf",
	"1-62-75" => "\xe6\xbb\x84",
	"1-62-76" => "\xe6\xba\xb2",
	"1-62-77" => "\xe6\xbb\x94",
	"1-62-78" => "\xe6\xbb\x95",
	"1-62-79" => "\xe6\xba\x8f",
	"1-62-80" => "\xe6\xba\xa5",
	"1-62-81" => "\xe6\xbb\x82",
	"1-62-82" => "\xe6\xba\x9f",
	"1-62-83" => "\xe6\xbd\x81",
	"1-62-84" => "\xe6\xbc\x91",
	"1-62-85" => "\xe7\x81\x8c",
	"1-62-86" => "\xe6\xbb\xac",
	"1-62-87" => "\xe6\xbb\xb8",
	"1-62-88" => "\xe6\xbb\xbe",
	"1-62-89" => "\xe6\xbc\xbf",
	"1-62-90" => "\xe6\xbb\xb2",
	"1-62-91" => "\xe6\xbc\xb1",
	"1-62-92" => "\xe6\xbb\xaf",
	"1-62-93" => "\xe6\xbc\xb2",
	"1-62-94" => "\xe6\xbb\x8c",
	"1-63-1" => "\xe6\xbc\xbe",
	"1-63-2" => "\xe6\xbc\x93",
	"1-63-3" => "\xe6\xbb\xb7",
	"1-63-4" => "\xe6\xbe\x86",
	"1-63-5" => "\xe6\xbd\xba",
	"1-63-6" => "\xe6\xbd\xb8",
	"1-63-7" => "\xe6\xbe\x81",
	"1-63-8" => "\xe6\xbe\x80",
	"1-63-9" => "\xe6\xbd\xaf",
	"1-63-10" => "\xe6\xbd\x9b",
	"1-63-11" => "\xe6\xbf\xb3",
	"1-63-12" => "\xe6\xbd\xad",
	"1-63-13" => "\xe6\xbe\x82",
	"1-63-14" => "\xe6\xbd\xbc",
	"1-63-15" => "\xe6\xbd\x98",
	"1-63-16" => "\xe6\xbe\x8e",
	"1-63-17" => "\xe6\xbe\x91",
	"1-63-18" => "\xe6\xbf\x82",
	"1-63-19" => "\xe6\xbd\xa6",
	"1-63-20" => "\xe6\xbe\xb3",
	"1-63-21" => "\xe6\xbe\xa3",
	"1-63-22" => "\xe6\xbe\xa1",
	"1-63-23" => "\xe6\xbe\xa4",
	"1-63-24" => "\xe6\xbe\xb9",
	"1-63-25" => "\xe6\xbf\x86",
	"1-63-26" => "\xe6\xbe\xaa",
	"1-63-27" => "\xe6\xbf\x9f",
	"1-63-28" => "\xe6\xbf\x95",
	"1-63-29" => "\xe6\xbf\xac",
	"1-63-30" => "\xe6\xbf\x94",
	"1-63-31" => "\xe6\xbf\x98",
	"1-63-32" => "\xe6\xbf\xb1",
	"1-63-33" => "\xe6\xbf\xae",
	"1-63-34" => "\xe6\xbf\x9b",
	"1-63-35" => "\xe7\x80\x89",
	"1-63-36" => "\xe7\x80\x8b",
	"1-63-37" => "\xe6\xbf\xba",
	"1-63-38" => "\xe7\x80\x91",
	"1-63-39" => "\xe7\x80\x81",
	"1-63-40" => "\xe7\x80\x8f",
	"1-63-41" => "\xe6\xbf\xbe",
	"1-63-42" => "\xe7\x80\x9b",
	"1-63-43" => "\xe7\x80\x9a",
	"1-63-44" => "\xe6\xbd\xb4",
	"1-63-45" => "\xe7\x80\x9d",
	"1-63-46" => "\xe7\x80\x98",
	"1-63-47" => "\xe7\x80\x9f",
	"1-63-48" => "\xe7\x80\xb0",
	"1-63-49" => "\xe7\x80\xbe",
	"1-63-50" => "\xe7\x80\xb2",
	"1-63-51" => "\xe7\x81\x91",
	"1-63-52" => "\xe7\x81\xa3",
	"1-63-53" => "\xe7\x82\x99",
	"1-63-54" => "\xe7\x82\x92",
	"1-63-55" => "\xe7\x82\xaf",
	"1-63-56" => "\xe7\x83\xb1",
	"1-63-57" => "\xe7\x82\xac",
	"1-63-58" => "\xe7\x82\xb8",
	"1-63-59" => "\xe7\x82\xb3",
	"1-63-60" => "\xe7\x82\xae",
	"1-63-61" => "\xe7\x83\x9f",
	"1-63-62" => "\xe7\x83\x8b",
	"1-63-63" => "\xe7\x83\x9d",
	"1-63-64" => "\xe7\x83\x99",
	"1-63-65" => "\xe7\x84\x89",
	"1-63-66" => "\xe7\x83\xbd",
	"1-63-67" => "\xe7\x84\x9c",
	"1-63-68" => "\xe7\x84\x99",
	"1-63-69" => "\xe7\x85\xa5",
	"1-63-70" => "\xe7\x85\x95",
	"1-63-71" => "\xe7\x86\x88",
	"1-63-72" => "\xe7\x85\xa6",
	"1-63-73" => "\xe7\x85\xa2",
	"1-63-74" => "\xe7\x85\x8c",
	"1-63-75" => "\xe7\x85\x96",
	"1-63-76" => "\xe7\x85\xac",
	"1-63-77" => "\xe7\x86\x8f",
	"1-63-78" => "\xe7\x87\xbb",
	"1-63-79" => "\xe7\x86\x84",
	"1-63-80" => "\xe7\x86\x95",
	"1-63-81" => "\xe7\x86\xa8",
	"1-63-82" => "\xe7\x86\xac",
	"1-63-83" => "\xe7\x87\x97",
	"1-63-84" => "\xe7\x86\xb9",
	"1-63-85" => "\xe7\x86\xbe",
	"1-63-86" => "\xe7\x87\x92",
	"1-63-87" => "\xe7\x87\x89",
	"1-63-88" => "\xe7\x87\x94",
	"1-63-89" => "\xe7\x87\x8e",
	"1-63-90" => "\xe7\x87\xa0",
	"1-63-91" => "\xe7\x87\xac",
	"1-63-92" => "\xe7\x87\xa7",
	"1-63-93" => "\xe7\x87\xb5",
	"1-63-94" => "\xe7\x87\xbc",
	"1-64-1" => "\xe7\x87\xb9",
	"1-64-2" => "\xe7\x87\xbf",
	"1-64-3" => "\xe7\x88\x8d",
	"1-64-4" => "\xe7\x88\x90",
	"1-64-5" => "\xe7\x88\x9b",
	"1-64-6" => "\xe7\x88\xa8",
	"1-64-7" => "\xe7\x88\xad",
	"1-64-8" => "\xe7\x88\xac",
	"1-64-9" => "\xe7\x88\xb0",
	"1-64-10" => "\xe7\x88\xb2",
	"1-64-11" => "\xe7\x88\xbb",
	"1-64-12" => "\xe7\x88\xbc",
	"1-64-13" => "\xe7\x88\xbf",
	"1-64-14" => "\xe7\x89\x80",
	"1-64-15" => "\xe7\x89\x86",
	"1-64-16" => "\xe7\x89\x8b",
	"1-64-17" => "\xe7\x89\x98",
	"1-64-18" => "\xe7\x89\xb4",
	"1-64-19" => "\xe7\x89\xbe",
	"1-64-20" => "\xe7\x8a\x82",
	"1-64-21" => "\xe7\x8a\x81",
	"1-64-22" => "\xe7\x8a\x87",
	"1-64-23" => "\xe7\x8a\x92",
	"1-64-24" => "\xe7\x8a\x96",
	"1-64-25" => "\xe7\x8a\xa2",
	"1-64-26" => "\xe7\x8a\xa7",
	"1-64-27" => "\xe7\x8a\xb9",
	"1-64-28" => "\xe7\x8a\xb2",
	"1-64-29" => "\xe7\x8b\x83",
	"1-64-30" => "\xe7\x8b\x86",
	"1-64-31" => "\xe7\x8b\x84",
	"1-64-32" => "\xe7\x8b\x8e",
	"1-64-33" => "\xe7\x8b\x92",
	"1-64-34" => "\xe7\x8b\xa2",
	"1-64-35" => "\xe7\x8b\xa0",
	"1-64-36" => "\xe7\x8b\xa1",
	"1-64-37" => "\xe7\x8b\xb9",
	"1-64-38" => "\xe7\x8b\xb7",
	"1-64-39" => "\xe5\x80\x8f",
	"1-64-40" => "\xe7\x8c\x97",
	"1-64-41" => "\xe7\x8c\x8a",
	"1-64-42" => "\xe7\x8c\x9c",
	"1-64-43" => "\xe7\x8c\x96",
	"1-64-44" => "\xe7\x8c\x9d",
	"1-64-45" => "\xe7\x8c\xb4",
	"1-64-46" => "\xe7\x8c\xaf",
	"1-64-47" => "\xe7\x8c\xa9",
	"1-64-48" => "\xe7\x8c\xa5",
	"1-64-49" => "\xe7\x8c\xbe",
	"1-64-50" => "\xe7\x8d\x8e",
	"1-64-51" => "\xe7\x8d\x8f",
	"1-64-52" => "\xe9\xbb\x98",
	"1-64-53" => "\xe7\x8d\x97",
	"1-64-54" => "\xe7\x8d\xaa",
	"1-64-55" => "\xe7\x8d\xa8",
	"1-64-56" => "\xe7\x8d\xb0",
	"1-64-57" => "\xe7\x8d\xb8",
	"1-64-58" => "\xe7\x8d\xb5",
	"1-64-59" => "\xe7\x8d\xbb",
	"1-64-60" => "\xe7\x8d\xba",
	"1-64-61" => "\xe7\x8f\x88",
	"1-64-62" => "\xe7\x8e\xb3",
	"1-64-63" => "\xe7\x8f\x8e",
	"1-64-64" => "\xe7\x8e\xbb",
	"1-64-65" => "\xe7\x8f\x80",
	"1-64-66" => "\xe7\x8f\xa5",
	"1-64-67" => "\xe7\x8f\xae",
	"1-64-68" => "\xe7\x8f\x9e",
	"1-64-69" => "\xe7\x92\xa2",
	"1-64-70" => "\xe7\x90\x85",
	"1-64-71" => "\xe7\x91\xaf",
	"1-64-72" => "\xe7\x90\xa5",
	"1-64-73" => "\xe7\x8f\xb8",
	"1-64-74" => "\xe7\x90\xb2",
	"1-64-75" => "\xe7\x90\xba",
	"1-64-76" => "\xe7\x91\x95",
	"1-64-77" => "\xe7\x90\xbf",
	"1-64-78" => "\xe7\x91\x9f",
	"1-64-79" => "\xe7\x91\x99",
	"1-64-80" => "\xe7\x91\x81",
	"1-64-81" => "\xe7\x91\x9c",
	"1-64-82" => "\xe7\x91\xa9",
	"1-64-83" => "\xe7\x91\xb0",
	"1-64-84" => "\xe7\x91\xa3",
	"1-64-85" => "\xe7\x91\xaa",
	"1-64-86" => "\xe7\x91\xb6",
	"1-64-87" => "\xe7\x91\xbe",
	"1-64-88" => "\xe7\x92\x8b",
	"1-64-89" => "\xe7\x92\x9e",
	"1-64-90" => "\xe7\x92\xa7",
	"1-64-91" => "\xe7\x93\x8a",
	"1-64-92" => "\xe7\x93\x8f",
	"1-64-93" => "\xe7\x93\x94",
	"1-64-94" => "\xe7\x8f\xb1",
	"1-65-1" => "\xe7\x93\xa0",
	"1-65-2" => "\xe7\x93\xa3",
	"1-65-3" => "\xe7\x93\xa7",
	"1-65-4" => "\xe7\x93\xa9",
	"1-65-5" => "\xe7\x93\xae",
	"1-65-6" => "\xe7\x93\xb2",
	"1-65-7" => "\xe7\x93\xb0",
	"1-65-8" => "\xe7\x93\xb1",
	"1-65-9" => "\xe7\x93\xb8",
	"1-65-10" => "\xe7\x93\xb7",
	"1-65-11" => "\xe7\x94\x84",
	"1-65-12" => "\xe7\x94\x83",
	"1-65-13" => "\xe7\x94\x85",
	"1-65-14" => "\xe7\x94\x8c",
	"1-65-15" => "\xe7\x94\x8e",
	"1-65-16" => "\xe7\x94\x8d",
	"1-65-17" => "\xe7\x94\x95",
	"1-65-18" => "\xe7\x94\x93",
	"1-65-19" => "\xe7\x94\x9e",
	"1-65-20" => "\xe7\x94\xa6",
	"1-65-21" => "\xe7\x94\xac",
	"1-65-22" => "\xe7\x94\xbc",
	"1-65-23" => "\xe7\x95\x84",
	"1-65-24" => "\xe7\x95\x8d",
	"1-65-25" => "\xe7\x95\x8a",
	"1-65-26" => "\xe7\x95\x89",
	"1-65-27" => "\xe7\x95\x9b",
	"1-65-28" => "\xe7\x95\x86",
	"1-65-29" => "\xe7\x95\x9a",
	"1-65-30" => "\xe7\x95\xa9",
	"1-65-31" => "\xe7\x95\xa4",
	"1-65-32" => "\xe7\x95\xa7",
	"1-65-33" => "\xe7\x95\xab",
	"1-65-34" => "\xe7\x95\xad",
	"1-65-35" => "\xe7\x95\xb8",
	"1-65-36" => "\xe7\x95\xb6",
	"1-65-37" => "\xe7\x96\x86",
	"1-65-38" => "\xe7\x96\x87",
	"1-65-39" => "\xe7\x95\xb4",
	"1-65-40" => "\xe7\x96\x8a",
	"1-65-41" => "\xe7\x96\x89",
	"1-65-42" => "\xe7\x96\x82",
	"1-65-43" => "\xe7\x96\x94",
	"1-65-44" => "\xe7\x96\x9a",
	"1-65-45" => "\xe7\x96\x9d",
	"1-65-46" => "\xe7\x96\xa5",
	"1-65-47" => "\xe7\x96\xa3",
	"1-65-48" => "\xe7\x97\x82",
	"1-65-49" => "\xe7\x96\xb3",
	"1-65-50" => "\xe7\x97\x83",
	"1-65-51" => "\xe7\x96\xb5",
	"1-65-52" => "\xe7\x96\xbd",
	"1-65-53" => "\xe7\x96\xb8",
	"1-65-54" => "\xe7\x96\xbc",
	"1-65-55" => "\xe7\x96\xb1",
	"1-65-56" => "\xe7\x97\x8d",
	"1-65-57" => "\xe7\x97\x8a",
	"1-65-58" => "\xe7\x97\x92",
	"1-65-59" => "\xe7\x97\x99",
	"1-65-60" => "\xe7\x97\xa3",
	"1-65-61" => "\xe7\x97\x9e",
	"1-65-62" => "\xe7\x97\xbe",
	"1-65-63" => "\xe7\x97\xbf",
	"1-65-64" => "\xe7\x97\xbc",
	"1-65-65" => "\xe7\x98\x81",
	"1-65-66" => "\xe7\x97\xb0",
	"1-65-67" => "\xe7\x97\xba",
	"1-65-68" => "\xe7\x97\xb2",
	"1-65-69" => "\xe7\x97\xb3",
	"1-65-70" => "\xe7\x98\x8b",
	"1-65-71" => "\xe7\x98\x8d",
	"1-65-72" => "\xe7\x98\x89",
	"1-65-73" => "\xe7\x98\x9f",
	"1-65-74" => "\xe7\x98\xa7",
	"1-65-75" => "\xe7\x98\xa0",
	"1-65-76" => "\xe7\x98\xa1",
	"1-65-77" => "\xe7\x98\xa2",
	"1-65-78" => "\xe7\x98\xa4",
	"1-65-79" => "\xe7\x98\xb4",
	"1-65-80" => "\xe7\x98\xb0",
	"1-65-81" => "\xe7\x98\xbb",
	"1-65-82" => "\xe7\x99\x87",
	"1-65-83" => "\xe7\x99\x88",
	"1-65-84" => "\xe7\x99\x86",
	"1-65-85" => "\xe7\x99\x9c",
	"1-65-86" => "\xe7\x99\x98",
	"1-65-87" => "\xe7\x99\xa1",
	"1-65-88" => "\xe7\x99\xa2",
	"1-65-89" => "\xe7\x99\xa8",
	"1-65-90" => "\xe7\x99\xa9",
	"1-65-91" => "\xe7\x99\xaa",
	"1-65-92" => "\xe7\x99\xa7",
	"1-65-93" => "\xe7\x99\xac",
	"1-65-94" => "\xe7\x99\xb0",
	"1-66-1" => "\xe7\x99\xb2",
	"1-66-2" => "\xe7\x99\xb6",
	"1-66-3" => "\xe7\x99\xb8",
	"1-66-4" => "\xe7\x99\xbc",
	"1-66-5" => "\xe7\x9a\x80",
	"1-66-6" => "\xe7\x9a\x83",
	"1-66-7" => "\xe7\x9a\x88",
	"1-66-8" => "\xe7\x9a\x8b",
	"1-66-9" => "\xe7\x9a\x8e",
	"1-66-10" => "\xe7\x9a\x96",
	"1-66-11" => "\xe7\x9a\x93",
	"1-66-12" => "\xe7\x9a\x99",
	"1-66-13" => "\xe7\x9a\x9a",
	"1-66-14" => "\xe7\x9a\xb0",
	"1-66-15" => "\xe7\x9a\xb4",
	"1-66-16" => "\xe7\x9a\xb8",
	"1-66-17" => "\xe7\x9a\xb9",
	"1-66-18" => "\xe7\x9a\xba",
	"1-66-19" => "\xe7\x9b\x82",
	"1-66-20" => "\xe7\x9b\x8d",
	"1-66-21" => "\xe7\x9b\x96",
	"1-66-22" => "\xe7\x9b\x92",
	"1-66-23" => "\xe7\x9b\x9e",
	"1-66-24" => "\xe7\x9b\xa1",
	"1-66-25" => "\xe7\x9b\xa5",
	"1-66-26" => "\xe7\x9b\xa7",
	"1-66-27" => "\xe7\x9b\xaa",
	"1-66-28" => "\xe8\x98\xaf",
	"1-66-29" => "\xe7\x9b\xbb",
	"1-66-30" => "\xe7\x9c\x88",
	"1-66-31" => "\xe7\x9c\x87",
	"1-66-32" => "\xe7\x9c\x84",
	"1-66-33" => "\xe7\x9c\xa9",
	"1-66-34" => "\xe7\x9c\xa4",
	"1-66-35" => "\xe7\x9c\x9e",
	"1-66-36" => "\xe7\x9c\xa5",
	"1-66-37" => "\xe7\x9c\xa6",
	"1-66-38" => "\xe7\x9c\x9b",
	"1-66-39" => "\xe7\x9c\xb7",
	"1-66-40" => "\xe7\x9c\xb8",
	"1-66-41" => "\xe7\x9d\x87",
	"1-66-42" => "\xe7\x9d\x9a",
	"1-66-43" => "\xe7\x9d\xa8",
	"1-66-44" => "\xe7\x9d\xab",
	"1-66-45" => "\xe7\x9d\x9b",
	"1-66-46" => "\xe7\x9d\xa5",
	"1-66-47" => "\xe7\x9d\xbf",
	"1-66-48" => "\xe7\x9d\xbe",
	"1-66-49" => "\xe7\x9d\xb9",
	"1-66-50" => "\xe7\x9e\x8e",
	"1-66-51" => "\xe7\x9e\x8b",
	"1-66-52" => "\xe7\x9e\x91",
	"1-66-53" => "\xe7\x9e\xa0",
	"1-66-54" => "\xe7\x9e\x9e",
	"1-66-55" => "\xe7\x9e\xb0",
	"1-66-56" => "\xe7\x9e\xb6",
	"1-66-57" => "\xe7\x9e\xb9",
	"1-66-58" => "\xe7\x9e\xbf",
	"1-66-59" => "\xe7\x9e\xbc",
	"1-66-60" => "\xe7\x9e\xbd",
	"1-66-61" => "\xe7\x9e\xbb",
	"1-66-62" => "\xe7\x9f\x87",
	"1-66-63" => "\xe7\x9f\x8d",
	"1-66-64" => "\xe7\x9f\x97",
	"1-66-65" => "\xe7\x9f\x9a",
	"1-66-66" => "\xe7\x9f\x9c",
	"1-66-67" => "\xe7\x9f\xa3",
	"1-66-68" => "\xe7\x9f\xae",
	"1-66-69" => "\xe7\x9f\xbc",
	"1-66-70" => "\xe7\xa0\x8c",
	"1-66-71" => "\xe7\xa0\x92",
	"1-66-72" => "\xe7\xa4\xa6",
	"1-66-73" => "\xe7\xa0\xa0",
	"1-66-74" => "\xe7\xa4\xaa",
	"1-66-75" => "\xe7\xa1\x85",
	"1-66-76" => "\xe7\xa2\x8e",
	"1-66-77" => "\xe7\xa1\xb4",
	"1-66-78" => "\xe7\xa2\x86",
	"1-66-79" => "\xe7\xa1\xbc",
	"1-66-80" => "\xe7\xa2\x9a",
	"1-66-81" => "\xe7\xa2\x8c",
	"1-66-82" => "\xe7\xa2\xa3",
	"1-66-83" => "\xe7\xa2\xb5",
	"1-66-84" => "\xe7\xa2\xaa",
	"1-66-85" => "\xe7\xa2\xaf",
	"1-66-86" => "\xe7\xa3\x91",
	"1-66-87" => "\xe7\xa3\x86",
	"1-66-88" => "\xe7\xa3\x8b",
	"1-66-89" => "\xe7\xa3\x94",
	"1-66-90" => "\xe7\xa2\xbe",
	"1-66-91" => "\xe7\xa2\xbc",
	"1-66-92" => "\xe7\xa3\x85",
	"1-66-93" => "\xe7\xa3\x8a",
	"1-66-94" => "\xe7\xa3\xac",
	"1-67-1" => "\xe7\xa3\xa7",
	"1-67-2" => "\xe7\xa3\x9a",
	"1-67-3" => "\xe7\xa3\xbd",
	"1-67-4" => "\xe7\xa3\xb4",
	"1-67-5" => "\xe7\xa4\x87",
	"1-67-6" => "\xe7\xa4\x92",
	"1-67-7" => "\xe7\xa4\x91",
	"1-67-8" => "\xe7\xa4\x99",
	"1-67-9" => "\xe7\xa4\xac",
	"1-67-10" => "\xe7\xa4\xab",
	"1-67-11" => "\xe7\xa5\x80",
	"1-67-12" => "\xe7\xa5\xa0",
	"1-67-13" => "\xe7\xa5\x97",
	"1-67-14" => "\xe7\xa5\x9f",
	"1-67-15" => "\xe7\xa5\x9a",
	"1-67-16" => "\xe7\xa5\x95",
	"1-67-17" => "\xe7\xa5\x93",
	"1-67-18" => "\xe7\xa5\xba",
	"1-67-19" => "\xe7\xa5\xbf",
	"1-67-20" => "\xe7\xa6\x8a",
	"1-67-21" => "\xe7\xa6\x9d",
	"1-67-22" => "\xe7\xa6\xa7",
	"1-67-23" => "\xe9\xbd\x8b",
	"1-67-24" => "\xe7\xa6\xaa",
	"1-67-25" => "\xe7\xa6\xae",
	"1-67-26" => "\xe7\xa6\xb3",
	"1-67-27" => "\xe7\xa6\xb9",
	"1-67-28" => "\xe7\xa6\xba",
	"1-67-29" => "\xe7\xa7\x89",
	"1-67-30" => "\xe7\xa7\x95",
	"1-67-31" => "\xe7\xa7\xa7",
	"1-67-32" => "\xe7\xa7\xac",
	"1-67-33" => "\xe7\xa7\xa1",
	"1-67-34" => "\xe7\xa7\xa3",
	"1-67-35" => "\xe7\xa8\x88",
	"1-67-36" => "\xe7\xa8\x8d",
	"1-67-37" => "\xe7\xa8\x98",
	"1-67-38" => "\xe7\xa8\x99",
	"1-67-39" => "\xe7\xa8\xa0",
	"1-67-40" => "\xe7\xa8\x9f",
	"1-67-41" => "\xe7\xa6\x80",
	"1-67-42" => "\xe7\xa8\xb1",
	"1-67-43" => "\xe7\xa8\xbb",
	"1-67-44" => "\xe7\xa8\xbe",
	"1-67-45" => "\xe7\xa8\xb7",
	"1-67-46" => "\xe7\xa9\x83",
	"1-67-47" => "\xe7\xa9\x97",
	"1-67-48" => "\xe7\xa9\x89",
	"1-67-49" => "\xe7\xa9\xa1",
	"1-67-50" => "\xe7\xa9\xa2",
	"1-67-51" => "\xe7\xa9\xa9",
	"1-67-52" => "\xe9\xbe\x9d",
	"1-67-53" => "\xe7\xa9\xb0",
	"1-67-54" => "\xe7\xa9\xb9",
	"1-67-55" => "\xe7\xa9\xbd",
	"1-67-56" => "\xe7\xaa\x88",
	"1-67-57" => "\xe7\xaa\x97",
	"1-67-58" => "\xe7\xaa\x95",
	"1-67-59" => "\xe7\xaa\x98",
	"1-67-60" => "\xe7\xaa\x96",
	"1-67-61" => "\xe7\xaa\xa9",
	"1-67-62" => "\xe7\xab\x88",
	"1-67-63" => "\xe7\xaa\xb0",
	"1-67-64" => "\xe7\xaa\xb6",
	"1-67-65" => "\xe7\xab\x85",
	"1-67-66" => "\xe7\xab\x84",
	"1-67-67" => "\xe7\xaa\xbf",
	"1-67-68" => "\xe9\x82\x83",
	"1-67-69" => "\xe7\xab\x87",
	"1-67-70" => "\xe7\xab\x8a",
	"1-67-71" => "\xe7\xab\x8d",
	"1-67-72" => "\xe7\xab\x8f",
	"1-67-73" => "\xe7\xab\x95",
	"1-67-74" => "\xe7\xab\x93",
	"1-67-75" => "\xe7\xab\x99",
	"1-67-76" => "\xe7\xab\x9a",
	"1-67-77" => "\xe7\xab\x9d",
	"1-67-78" => "\xe7\xab\xa1",
	"1-67-79" => "\xe7\xab\xa2",
	"1-67-80" => "\xe7\xab\xa6",
	"1-67-81" => "\xe7\xab\xad",
	"1-67-82" => "\xe7\xab\xb0",
	"1-67-83" => "\xe7\xac\x82",
	"1-67-84" => "\xe7\xac\x8f",
	"1-67-85" => "\xe7\xac\x8a",
	"1-67-86" => "\xe7\xac\x86",
	"1-67-87" => "\xe7\xac\xb3",
	"1-67-88" => "\xe7\xac\x98",
	"1-67-89" => "\xe7\xac\x99",
	"1-67-90" => "\xe7\xac\x9e",
	"1-67-91" => "\xe7\xac\xb5",
	"1-67-92" => "\xe7\xac\xa8",
	"1-67-93" => "\xe7\xac\xb6",
	"1-67-94" => "\xe7\xad\x90",
	"1-68-1" => "\xe7\xad\xba",
	"1-68-2" => "\xe7\xac\x84",
	"1-68-3" => "\xe7\xad\x8d",
	"1-68-4" => "\xe7\xac\x8b",
	"1-68-5" => "\xe7\xad\x8c",
	"1-68-6" => "\xe7\xad\x85",
	"1-68-7" => "\xe7\xad\xb5",
	"1-68-8" => "\xe7\xad\xa5",
	"1-68-9" => "\xe7\xad\xb4",
	"1-68-10" => "\xe7\xad\xa7",
	"1-68-11" => "\xe7\xad\xb0",
	"1-68-12" => "\xe7\xad\xb1",
	"1-68-13" => "\xe7\xad\xac",
	"1-68-14" => "\xe7\xad\xae",
	"1-68-15" => "\xe7\xae\x9d",
	"1-68-16" => "\xe7\xae\x98",
	"1-68-17" => "\xe7\xae\x9f",
	"1-68-18" => "\xe7\xae\x8d",
	"1-68-19" => "\xe7\xae\x9c",
	"1-68-20" => "\xe7\xae\x9a",
	"1-68-21" => "\xe7\xae\x8b",
	"1-68-22" => "\xe7\xae\x92",
	"1-68-23" => "\xe7\xae\x8f",
	"1-68-24" => "\xe7\xad\x9d",
	"1-68-25" => "\xe7\xae\x99",
	"1-68-26" => "\xe7\xaf\x8b",
	"1-68-27" => "\xe7\xaf\x81",
	"1-68-28" => "\xe7\xaf\x8c",
	"1-68-29" => "\xe7\xaf\x8f",
	"1-68-30" => "\xe7\xae\xb4",
	"1-68-31" => "\xe7\xaf\x86",
	"1-68-32" => "\xe7\xaf\x9d",
	"1-68-33" => "\xe7\xaf\xa9",
	"1-68-34" => "\xe7\xb0\x91",
	"1-68-35" => "\xe7\xb0\x94",
	"1-68-36" => "\xe7\xaf\xa6",
	"1-68-37" => "\xe7\xaf\xa5",
	"1-68-38" => "\xe7\xb1\xa0",
	"1-68-39" => "\xe7\xb0\x80",
	"1-68-40" => "\xe7\xb0\x87",
	"1-68-41" => "\xe7\xb0\x93",
	"1-68-42" => "\xe7\xaf\xb3",
	"1-68-43" => "\xe7\xaf\xb7",
	"1-68-44" => "\xe7\xb0\x97",
	"1-68-45" => "\xe7\xb0\x8d",
	"1-68-46" => "\xe7\xaf\xb6",
	"1-68-47" => "\xe7\xb0\xa3",
	"1-68-48" => "\xe7\xb0\xa7",
	"1-68-49" => "\xe7\xb0\xaa",
	"1-68-50" => "\xe7\xb0\x9f",
	"1-68-51" => "\xe7\xb0\xb7",
	"1-68-52" => "\xe7\xb0\xab",
	"1-68-53" => "\xe7\xb0\xbd",
	"1-68-54" => "\xe7\xb1\x8c",
	"1-68-55" => "\xe7\xb1\x83",
	"1-68-56" => "\xe7\xb1\x94",
	"1-68-57" => "\xe7\xb1\x8f",
	"1-68-58" => "\xe7\xb1\x80",
	"1-68-59" => "\xe7\xb1\x90",
	"1-68-60" => "\xe7\xb1\x98",
	"1-68-61" => "\xe7\xb1\x9f",
	"1-68-62" => "\xe7\xb1\xa4",
	"1-68-63" => "\xe7\xb1\x96",
	"1-68-64" => "\xe7\xb1\xa5",
	"1-68-65" => "\xe7\xb1\xac",
	"1-68-66" => "\xe7\xb1\xb5",
	"1-68-67" => "\xe7\xb2\x83",
	"1-68-68" => "\xe7\xb2\x90",
	"1-68-69" => "\xe7\xb2\xa4",
	"1-68-70" => "\xe7\xb2\xad",
	"1-68-71" => "\xe7\xb2\xa2",
	"1-68-72" => "\xe7\xb2\xab",
	"1-68-73" => "\xe7\xb2\xa1",
	"1-68-74" => "\xe7\xb2\xa8",
	"1-68-75" => "\xe7\xb2\xb3",
	"1-68-76" => "\xe7\xb2\xb2",
	"1-68-77" => "\xe7\xb2\xb1",
	"1-68-78" => "\xe7\xb2\xae",
	"1-68-79" => "\xe7\xb2\xb9",
	"1-68-80" => "\xe7\xb2\xbd",
	"1-68-81" => "\xe7\xb3\x80",
	"1-68-82" => "\xe7\xb3\x85",
	"1-68-83" => "\xe7\xb3\x82",
	"1-68-84" => "\xe7\xb3\x98",
	"1-68-85" => "\xe7\xb3\x92",
	"1-68-86" => "\xe7\xb3\x9c",
	"1-68-87" => "\xe7\xb3\xa2",
	"1-68-88" => "\xe9\xac\xbb",
	"1-68-89" => "\xe7\xb3\xaf",
	"1-68-90" => "\xe7\xb3\xb2",
	"1-68-91" => "\xe7\xb3\xb4",
	"1-68-92" => "\xe7\xb3\xb6",
	"1-68-93" => "\xe7\xb3\xba",
	"1-68-94" => "\xe7\xb4\x86",
	"1-69-1" => "\xe7\xb4\x82",
	"1-69-2" => "\xe7\xb4\x9c",
	"1-69-3" => "\xe7\xb4\x95",
	"1-69-4" => "\xe7\xb4\x8a",
	"1-69-5" => "\xe7\xb5\x85",
	"1-69-6" => "\xe7\xb5\x8b",
	"1-69-7" => "\xe7\xb4\xae",
	"1-69-8" => "\xe7\xb4\xb2",
	"1-69-9" => "\xe7\xb4\xbf",
	"1-69-10" => "\xe7\xb4\xb5",
	"1-69-11" => "\xe7\xb5\x86",
	"1-69-12" => "\xe7\xb5\xb3",
	"1-69-13" => "\xe7\xb5\x96",
	"1-69-14" => "\xe7\xb5\x8e",
	"1-69-15" => "\xe7\xb5\xb2",
	"1-69-16" => "\xe7\xb5\xa8",
	"1-69-17" => "\xe7\xb5\xae",
	"1-69-18" => "\xe7\xb5\x8f",
	"1-69-19" => "\xe7\xb5\xa3",
	"1-69-20" => "\xe7\xb6\x93",
	"1-69-21" => "\xe7\xb6\x89",
	"1-69-22" => "\xe7\xb5\x9b",
	"1-69-23" => "\xe7\xb6\x8f",
	"1-69-24" => "\xe7\xb5\xbd",
	"1-69-25" => "\xe7\xb6\x9b",
	"1-69-26" => "\xe7\xb6\xba",
	"1-69-27" => "\xe7\xb6\xae",
	"1-69-28" => "\xe7\xb6\xa3",
	"1-69-29" => "\xe7\xb6\xb5",
	"1-69-30" => "\xe7\xb7\x87",
	"1-69-31" => "\xe7\xb6\xbd",
	"1-69-32" => "\xe7\xb6\xab",
	"1-69-33" => "\xe7\xb8\xbd",
	"1-69-34" => "\xe7\xb6\xa2",
	"1-69-35" => "\xe7\xb6\xaf",
	"1-69-36" => "\xe7\xb7\x9c",
	"1-69-37" => "\xe7\xb6\xb8",
	"1-69-38" => "\xe7\xb6\x9f",
	"1-69-39" => "\xe7\xb6\xb0",
	"1-69-40" => "\xe7\xb7\x98",
	"1-69-41" => "\xe7\xb7\x9d",
	"1-69-42" => "\xe7\xb7\xa4",
	"1-69-43" => "\xe7\xb7\x9e",
	"1-69-44" => "\xe7\xb7\xbb",
	"1-69-45" => "\xe7\xb7\xb2",
	"1-69-46" => "\xe7\xb7\xa1",
	"1-69-47" => "\xe7\xb8\x85",
	"1-69-48" => "\xe7\xb8\x8a",
	"1-69-49" => "\xe7\xb8\xa3",
	"1-69-50" => "\xe7\xb8\xa1",
	"1-69-51" => "\xe7\xb8\x92",
	"1-69-52" => "\xe7\xb8\xb1",
	"1-69-53" => "\xe7\xb8\x9f",
	"1-69-54" => "\xe7\xb8\x89",
	"1-69-55" => "\xe7\xb8\x8b",
	"1-69-56" => "\xe7\xb8\xa2",
	"1-69-57" => "\xe7\xb9\x86",
	"1-69-58" => "\xe7\xb9\xa6",
	"1-69-59" => "\xe7\xb8\xbb",
	"1-69-60" => "\xe7\xb8\xb5",
	"1-69-61" => "\xe7\xb8\xb9",
	"1-69-62" => "\xe7\xb9\x83",
	"1-69-63" => "\xe7\xb8\xb7",
	"1-69-64" => "\xe7\xb8\xb2",
	"1-69-65" => "\xe7\xb8\xba",
	"1-69-66" => "\xe7\xb9\xa7",
	"1-69-67" => "\xe7\xb9\x9d",
	"1-69-68" => "\xe7\xb9\x96",
	"1-69-69" => "\xe7\xb9\x9e",
	"1-69-70" => "\xe7\xb9\x99",
	"1-69-71" => "\xe7\xb9\x9a",
	"1-69-72" => "\xe7\xb9\xb9",
	"1-69-73" => "\xe7\xb9\xaa",
	"1-69-74" => "\xe7\xb9\xa9",
	"1-69-75" => "\xe7\xb9\xbc",
	"1-69-76" => "\xe7\xb9\xbb",
	"1-69-77" => "\xe7\xba\x83",
	"1-69-78" => "\xe7\xb7\x95",
	"1-69-79" => "\xe7\xb9\xbd",
	"1-69-80" => "\xe8\xbe\xae",
	"1-69-81" => "\xe7\xb9\xbf",
	"1-69-82" => "\xe7\xba\x88",
	"1-69-83" => "\xe7\xba\x89",
	"1-69-84" => "\xe7\xba\x8c",
	"1-69-85" => "\xe7\xba\x92",
	"1-69-86" => "\xe7\xba\x90",
	"1-69-87" => "\xe7\xba\x93",
	"1-69-88" => "\xe7\xba\x94",
	"1-69-89" => "\xe7\xba\x96",
	"1-69-90" => "\xe7\xba\x8e",
	"1-69-91" => "\xe7\xba\x9b",
	"1-69-92" => "\xe7\xba\x9c",
	"1-69-93" => "\xe7\xbc\xb8",
	"1-69-94" => "\xe7\xbc\xba",
	"1-70-1" => "\xe7\xbd\x85",
	"1-70-2" => "\xe7\xbd\x8c",
	"1-70-3" => "\xe7\xbd\x8d",
	"1-70-4" => "\xe7\xbd\x8e",
	"1-70-5" => "\xe7\xbd\x90",
	"1-70-6" => "\xe7\xbd\x91",
	"1-70-7" => "\xe7\xbd\x95",
	"1-70-8" => "\xe7\xbd\x94",
	"1-70-9" => "\xe7\xbd\x98",
	"1-70-10" => "\xe7\xbd\x9f",
	"1-70-11" => "\xe7\xbd\xa0",
	"1-70-12" => "\xe7\xbd\xa8",
	"1-70-13" => "\xe7\xbd\xa9",
	"1-70-14" => "\xe7\xbd\xa7",
	"1-70-15" => "\xe7\xbd\xb8",
	"1-70-16" => "\xe7\xbe\x82",
	"1-70-17" => "\xe7\xbe\x86",
	"1-70-18" => "\xe7\xbe\x83",
	"1-70-19" => "\xe7\xbe\x88",
	"1-70-20" => "\xe7\xbe\x87",
	"1-70-21" => "\xe7\xbe\x8c",
	"1-70-22" => "\xe7\xbe\x94",
	"1-70-23" => "\xe7\xbe\x9e",
	"1-70-24" => "\xe7\xbe\x9d",
	"1-70-25" => "\xe7\xbe\x9a",
	"1-70-26" => "\xe7\xbe\xa3",
	"1-70-27" => "\xe7\xbe\xaf",
	"1-70-28" => "\xe7\xbe\xb2",
	"1-70-29" => "\xe7\xbe\xb9",
	"1-70-30" => "\xe7\xbe\xae",
	"1-70-31" => "\xe7\xbe\xb6",
	"1-70-32" => "\xe7\xbe\xb8",
	"1-70-33" => "\xe8\xad\xb1",
	"1-70-34" => "\xe7\xbf\x85",
	"1-70-35" => "\xe7\xbf\x86",
	"1-70-36" => "\xe7\xbf\x8a",
	"1-70-37" => "\xe7\xbf\x95",
	"1-70-38" => "\xe7\xbf\x94",
	"1-70-39" => "\xe7\xbf\xa1",
	"1-70-40" => "\xe7\xbf\xa6",
	"1-70-41" => "\xe7\xbf\xa9",
	"1-70-42" => "\xe7\xbf\xb3",
	"1-70-43" => "\xe7\xbf\xb9",
	"1-70-44" => "\xe9\xa3\x9c",
	"1-70-45" => "\xe8\x80\x86",
	"1-70-46" => "\xe8\x80\x84",
	"1-70-47" => "\xe8\x80\x8b",
	"1-70-48" => "\xe8\x80\x92",
	"1-70-49" => "\xe8\x80\x98",
	"1-70-50" => "\xe8\x80\x99",
	"1-70-51" => "\xe8\x80\x9c",
	"1-70-52" => "\xe8\x80\xa1",
	"1-70-53" => "\xe8\x80\xa8",
	"1-70-54" => "\xe8\x80\xbf",
	"1-70-55" => "\xe8\x80\xbb",
	"1-70-56" => "\xe8\x81\x8a",
	"1-70-57" => "\xe8\x81\x86",
	"1-70-58" => "\xe8\x81\x92",
	"1-70-59" => "\xe8\x81\x98",
	"1-70-60" => "\xe8\x81\x9a",
	"1-70-61" => "\xe8\x81\x9f",
	"1-70-62" => "\xe8\x81\xa2",
	"1-70-63" => "\xe8\x81\xa8",
	"1-70-64" => "\xe8\x81\xb3",
	"1-70-65" => "\xe8\x81\xb2",
	"1-70-66" => "\xe8\x81\xb0",
	"1-70-67" => "\xe8\x81\xb6",
	"1-70-68" => "\xe8\x81\xb9",
	"1-70-69" => "\xe8\x81\xbd",
	"1-70-70" => "\xe8\x81\xbf",
	"1-70-71" => "\xe8\x82\x84",
	"1-70-72" => "\xe8\x82\x86",
	"1-70-73" => "\xe8\x82\x85",
	"1-70-74" => "\xe8\x82\x9b",
	"1-70-75" => "\xe8\x82\x93",
	"1-70-76" => "\xe8\x82\x9a",
	"1-70-77" => "\xe8\x82\xad",
	"1-70-78" => "\xe5\x86\x90",
	"1-70-79" => "\xe8\x82\xac",
	"1-70-80" => "\xe8\x83\x9b",
	"1-70-81" => "\xe8\x83\xa5",
	"1-70-82" => "\xe8\x83\x99",
	"1-70-83" => "\xe8\x83\x9d",
	"1-70-84" => "\xe8\x83\x84",
	"1-70-85" => "\xe8\x83\x9a",
	"1-70-86" => "\xe8\x83\x96",
	"1-70-87" => "\xe8\x84\x89",
	"1-70-88" => "\xe8\x83\xaf",
	"1-70-89" => "\xe8\x83\xb1",
	"1-70-90" => "\xe8\x84\x9b",
	"1-70-91" => "\xe8\x84\xa9",
	"1-70-92" => "\xe8\x84\xa3",
	"1-70-93" => "\xe8\x84\xaf",
	"1-70-94" => "\xe8\x85\x8b",
	"1-71-1" => "\xe9\x9a\x8b",
	"1-71-2" => "\xe8\x85\x86",
	"1-71-3" => "\xe8\x84\xbe",
	"1-71-4" => "\xe8\x85\x93",
	"1-71-5" => "\xe8\x85\x91",
	"1-71-6" => "\xe8\x83\xbc",
	"1-71-7" => "\xe8\x85\xb1",
	"1-71-8" => "\xe8\x85\xae",
	"1-71-9" => "\xe8\x85\xa5",
	"1-71-10" => "\xe8\x85\xa6",
	"1-71-11" => "\xe8\x85\xb4",
	"1-71-12" => "\xe8\x86\x83",
	"1-71-13" => "\xe8\x86\x88",
	"1-71-14" => "\xe8\x86\x8a",
	"1-71-15" => "\xe8\x86\x80",
	"1-71-16" => "\xe8\x86\x82",
	"1-71-17" => "\xe8\x86\xa0",
	"1-71-18" => "\xe8\x86\x95",
	"1-71-19" => "\xe8\x86\xa4",
	"1-71-20" => "\xe8\x86\xa3",
	"1-71-21" => "\xe8\x85\x9f",
	"1-71-22" => "\xe8\x86\x93",
	"1-71-23" => "\xe8\x86\xa9",
	"1-71-24" => "\xe8\x86\xb0",
	"1-71-25" => "\xe8\x86\xb5",
	"1-71-26" => "\xe8\x86\xbe",
	"1-71-27" => "\xe8\x86\xb8",
	"1-71-28" => "\xe8\x86\xbd",
	"1-71-29" => "\xe8\x87\x80",
	"1-71-30" => "\xe8\x87\x82",
	"1-71-31" => "\xe8\x86\xba",
	"1-71-32" => "\xe8\x87\x89",
	"1-71-33" => "\xe8\x87\x8d",
	"1-71-34" => "\xe8\x87\x91",
	"1-71-35" => "\xe8\x87\x99",
	"1-71-36" => "\xe8\x87\x98",
	"1-71-37" => "\xe8\x87\x88",
	"1-71-38" => "\xe8\x87\x9a",
	"1-71-39" => "\xe8\x87\x9f",
	"1-71-40" => "\xe8\x87\xa0",
	"1-71-41" => "\xe8\x87\xa7",
	"1-71-42" => "\xe8\x87\xba",
	"1-71-43" => "\xe8\x87\xbb",
	"1-71-44" => "\xe8\x87\xbe",
	"1-71-45" => "\xe8\x88\x81",
	"1-71-46" => "\xe8\x88\x82",
	"1-71-47" => "\xe8\x88\x85",
	"1-71-48" => "\xe8\x88\x87",
	"1-71-49" => "\xe8\x88\x8a",
	"1-71-50" => "\xe8\x88\x8d",
	"1-71-51" => "\xe8\x88\x90",
	"1-71-52" => "\xe8\x88\x96",
	"1-71-53" => "\xe8\x88\xa9",
	"1-71-54" => "\xe8\x88\xab",
	"1-71-55" => "\xe8\x88\xb8",
	"1-71-56" => "\xe8\x88\xb3",
	"1-71-57" => "\xe8\x89\x80",
	"1-71-58" => "\xe8\x89\x99",
	"1-71-59" => "\xe8\x89\x98",
	"1-71-60" => "\xe8\x89\x9d",
	"1-71-61" => "\xe8\x89\x9a",
	"1-71-62" => "\xe8\x89\x9f",
	"1-71-63" => "\xe8\x89\xa4",
	"1-71-64" => "\xe8\x89\xa2",
	"1-71-65" => "\xe8\x89\xa8",
	"1-71-66" => "\xe8\x89\xaa",
	"1-71-67" => "\xe8\x89\xab",
	"1-71-68" => "\xe8\x88\xae",
	"1-71-69" => "\xe8\x89\xb1",
	"1-71-70" => "\xe8\x89\xb7",
	"1-71-71" => "\xe8\x89\xb8",
	"1-71-72" => "\xe8\x89\xbe",
	"1-71-73" => "\xe8\x8a\x8d",
	"1-71-74" => "\xe8\x8a\x92",
	"1-71-75" => "\xe8\x8a\xab",
	"1-71-76" => "\xe8\x8a\x9f",
	"1-71-77" => "\xe8\x8a\xbb",
	"1-71-78" => "\xe8\x8a\xac",
	"1-71-79" => "\xe8\x8b\xa1",
	"1-71-80" => "\xe8\x8b\xa3",
	"1-71-81" => "\xe8\x8b\x9f",
	"1-71-82" => "\xe8\x8b\x92",
	"1-71-83" => "\xe8\x8b\xb4",
	"1-71-84" => "\xe8\x8b\xb3",
	"1-71-85" => "\xe8\x8b\xba",
	"1-71-86" => "\xe8\x8e\x93",
	"1-71-87" => "\xe8\x8c\x83",
	"1-71-88" => "\xe8\x8b\xbb",
	"1-71-89" => "\xe8\x8b\xb9",
	"1-71-90" => "\xe8\x8b\x9e",
	"1-71-91" => "\xe8\x8c\x86",
	"1-71-92" => "\xe8\x8b\x9c",
	"1-71-93" => "\xe8\x8c\x89",
	"1-71-94" => "\xe8\x8b\x99",
	"1-72-1" => "\xe8\x8c\xb5",
	"1-72-2" => "\xe8\x8c\xb4",
	"1-72-3" => "\xe8\x8c\x96",
	"1-72-4" => "\xe8\x8c\xb2",
	"1-72-5" => "\xe8\x8c\xb1",
	"1-72-6" => "\xe8\x8d\x80",
	"1-72-7" => "\xe8\x8c\xb9",
	"1-72-8" => "\xe8\x8d\x90",
	"1-72-9" => "\xe8\x8d\x85",
	"1-72-10" => "\xe8\x8c\xaf",
	"1-72-11" => "\xe8\x8c\xab",
	"1-72-12" => "\xe8\x8c\x97",
	"1-72-13" => "\xe8\x8c\x98",
	"1-72-14" => "\xe8\x8e\x85",
	"1-72-15" => "\xe8\x8e\x9a",
	"1-72-16" => "\xe8\x8e\xaa",
	"1-72-17" => "\xe8\x8e\x9f",
	"1-72-18" => "\xe8\x8e\xa2",
	"1-72-19" => "\xe8\x8e\x96",
	"1-72-20" => "\xe8\x8c\xa3",
	"1-72-21" => "\xe8\x8e\x8e",
	"1-72-22" => "\xe8\x8e\x87",
	"1-72-23" => "\xe8\x8e\x8a",
	"1-72-24" => "\xe8\x8d\xbc",
	"1-72-25" => "\xe8\x8e\xb5",
	"1-72-26" => "\xe8\x8d\xb3",
	"1-72-27" => "\xe8\x8d\xb5",
	"1-72-28" => "\xe8\x8e\xa0",
	"1-72-29" => "\xe8\x8e\x89",
	"1-72-30" => "\xe8\x8e\xa8",
	"1-72-31" => "\xe8\x8f\xb4",
	"1-72-32" => "\xe8\x90\x93",
	"1-72-33" => "\xe8\x8f\xab",
	"1-72-34" => "\xe8\x8f\x8e",
	"1-72-35" => "\xe8\x8f\xbd",
	"1-72-36" => "\xe8\x90\x83",
	"1-72-37" => "\xe8\x8f\x98",
	"1-72-38" => "\xe8\x90\x8b",
	"1-72-39" => "\xe8\x8f\x81",
	"1-72-40" => "\xe8\x8f\xb7",
	"1-72-41" => "\xe8\x90\x87",
	"1-72-42" => "\xe8\x8f\xa0",
	"1-72-43" => "\xe8\x8f\xb2",
	"1-72-44" => "\xe8\x90\x8d",
	"1-72-45" => "\xe8\x90\xa2",
	"1-72-46" => "\xe8\x90\xa0",
	"1-72-47" => "\xe8\x8e\xbd",
	"1-72-48" => "\xe8\x90\xb8",
	"1-72-49" => "\xe8\x94\x86",
	"1-72-50" => "\xe8\x8f\xbb",
	"1-72-51" => "\xe8\x91\xad",
	"1-72-52" => "\xe8\x90\xaa",
	"1-72-53" => "\xe8\x90\xbc",
	"1-72-54" => "\xe8\x95\x9a",
	"1-72-55" => "\xe8\x92\x84",
	"1-72-56" => "\xe8\x91\xb7",
	"1-72-57" => "\xe8\x91\xab",
	"1-72-58" => "\xe8\x92\xad",
	"1-72-59" => "\xe8\x91\xae",
	"1-72-60" => "\xe8\x92\x82",
	"1-72-61" => "\xe8\x91\xa9",
	"1-72-62" => "\xe8\x91\x86",
	"1-72-63" => "\xe8\x90\xac",
	"1-72-64" => "\xe8\x91\xaf",
	"1-72-65" => "\xe8\x91\xb9",
	"1-72-66" => "\xe8\x90\xb5",
	"1-72-67" => "\xe8\x93\x8a",
	"1-72-68" => "\xe8\x91\xa2",
	"1-72-69" => "\xe8\x92\xb9",
	"1-72-70" => "\xe8\x92\xbf",
	"1-72-71" => "\xe8\x92\x9f",
	"1-72-72" => "\xe8\x93\x99",
	"1-72-73" => "\xe8\x93\x8d",
	"1-72-74" => "\xe8\x92\xbb",
	"1-72-75" => "\xe8\x93\x9a",
	"1-72-76" => "\xe8\x93\x90",
	"1-72-77" => "\xe8\x93\x81",
	"1-72-78" => "\xe8\x93\x86",
	"1-72-79" => "\xe8\x93\x96",
	"1-72-80" => "\xe8\x92\xa1",
	"1-72-81" => "\xe8\x94\xa1",
	"1-72-82" => "\xe8\x93\xbf",
	"1-72-83" => "\xe8\x93\xb4",
	"1-72-84" => "\xe8\x94\x97",
	"1-72-85" => "\xe8\x94\x98",
	"1-72-86" => "\xe8\x94\xac",
	"1-72-87" => "\xe8\x94\x9f",
	"1-72-88" => "\xe8\x94\x95",
	"1-72-89" => "\xe8\x94\x94",
	"1-72-90" => "\xe8\x93\xbc",
	"1-72-91" => "\xe8\x95\x80",
	"1-72-92" => "\xe8\x95\xa3",
	"1-72-93" => "\xe8\x95\x98",
	"1-72-94" => "\xe8\x95\x88",
	"1-73-1" => "\xe8\x95\x81",
	"1-73-2" => "\xe8\x98\x82",
	"1-73-3" => "\xe8\x95\x8b",
	"1-73-4" => "\xe8\x95\x95",
	"1-73-5" => "\xe8\x96\x80",
	"1-73-6" => "\xe8\x96\xa4",
	"1-73-7" => "\xe8\x96\x88",
	"1-73-8" => "\xe8\x96\x91",
	"1-73-9" => "\xe8\x96\x8a",
	"1-73-10" => "\xe8\x96\xa8",
	"1-73-11" => "\xe8\x95\xad",
	"1-73-12" => "\xe8\x96\x94",
	"1-73-13" => "\xe8\x96\x9b",
	"1-73-14" => "\xe8\x97\xaa",
	"1-73-15" => "\xe8\x96\x87",
	"1-73-16" => "\xe8\x96\x9c",
	"1-73-17" => "\xe8\x95\xb7",
	"1-73-18" => "\xe8\x95\xbe",
	"1-73-19" => "\xe8\x96\x90",
	"1-73-20" => "\xe8\x97\x89",
	"1-73-21" => "\xe8\x96\xba",
	"1-73-22" => "\xe8\x97\x8f",
	"1-73-23" => "\xe8\x96\xb9",
	"1-73-24" => "\xe8\x97\x90",
	"1-73-25" => "\xe8\x97\x95",
	"1-73-26" => "\xe8\x97\x9d",
	"1-73-27" => "\xe8\x97\xa5",
	"1-73-28" => "\xe8\x97\x9c",
	"1-73-29" => "\xe8\x97\xb9",
	"1-73-30" => "\xe8\x98\x8a",
	"1-73-31" => "\xe8\x98\x93",
	"1-73-32" => "\xe8\x98\x8b",
	"1-73-33" => "\xe8\x97\xbe",
	"1-73-34" => "\xe8\x97\xba",
	"1-73-35" => "\xe8\x98\x86",
	"1-73-36" => "\xe8\x98\xa2",
	"1-73-37" => "\xe8\x98\x9a",
	"1-73-38" => "\xe8\x98\xb0",
	"1-73-39" => "\xe8\x98\xbf",
	"1-73-40" => "\xe8\x99\x8d",
	"1-73-41" => "\xe4\xb9\x95",
	"1-73-42" => "\xe8\x99\x94",
	"1-73-43" => "\xe8\x99\x9f",
	"1-73-44" => "\xe8\x99\xa7",
	"1-73-45" => "\xe8\x99\xb1",
	"1-73-46" => "\xe8\x9a\x93",
	"1-73-47" => "\xe8\x9a\xa3",
	"1-73-48" => "\xe8\x9a\xa9",
	"1-73-49" => "\xe8\x9a\xaa",
	"1-73-50" => "\xe8\x9a\x8b",
	"1-73-51" => "\xe8\x9a\x8c",
	"1-73-52" => "\xe8\x9a\xb6",
	"1-73-53" => "\xe8\x9a\xaf",
	"1-73-54" => "\xe8\x9b\x84",
	"1-73-55" => "\xe8\x9b\x86",
	"1-73-56" => "\xe8\x9a\xb0",
	"1-73-57" => "\xe8\x9b\x89",
	"1-73-58" => "\xe8\xa0\xa3",
	"1-73-59" => "\xe8\x9a\xab",
	"1-73-60" => "\xe8\x9b\x94",
	"1-73-61" => "\xe8\x9b\x9e",
	"1-73-62" => "\xe8\x9b\xa9",
	"1-73-63" => "\xe8\x9b\xac",
	"1-73-64" => "\xe8\x9b\x9f",
	"1-73-65" => "\xe8\x9b\x9b",
	"1-73-66" => "\xe8\x9b\xaf",
	"1-73-67" => "\xe8\x9c\x92",
	"1-73-68" => "\xe8\x9c\x86",
	"1-73-69" => "\xe8\x9c\x88",
	"1-73-70" => "\xe8\x9c\x80",
	"1-73-71" => "\xe8\x9c\x83",
	"1-73-72" => "\xe8\x9b\xbb",
	"1-73-73" => "\xe8\x9c\x91",
	"1-73-74" => "\xe8\x9c\x89",
	"1-73-75" => "\xe8\x9c\x8d",
	"1-73-76" => "\xe8\x9b\xb9",
	"1-73-77" => "\xe8\x9c\x8a",
	"1-73-78" => "\xe8\x9c\xb4",
	"1-73-79" => "\xe8\x9c\xbf",
	"1-73-80" => "\xe8\x9c\xb7",
	"1-73-81" => "\xe8\x9c\xbb",
	"1-73-82" => "\xe8\x9c\xa5",
	"1-73-83" => "\xe8\x9c\xa9",
	"1-73-84" => "\xe8\x9c\x9a",
	"1-73-85" => "\xe8\x9d\xa0",
	"1-73-86" => "\xe8\x9d\x9f",
	"1-73-87" => "\xe8\x9d\xb8",
	"1-73-88" => "\xe8\x9d\x8c",
	"1-73-89" => "\xe8\x9d\x8e",
	"1-73-90" => "\xe8\x9d\xb4",
	"1-73-91" => "\xe8\x9d\x97",
	"1-73-92" => "\xe8\x9d\xa8",
	"1-73-93" => "\xe8\x9d\xae",
	"1-73-94" => "\xe8\x9d\x99",
	"1-74-1" => "\xe8\x9d\x93",
	"1-74-2" => "\xe8\x9d\xa3",
	"1-74-3" => "\xe8\x9d\xaa",
	"1-74-4" => "\xe8\xa0\x85",
	"1-74-5" => "\xe8\x9e\xa2",
	"1-74-6" => "\xe8\x9e\x9f",
	"1-74-7" => "\xe8\x9e\x82",
	"1-74-8" => "\xe8\x9e\xaf",
	"1-74-9" => "\xe8\x9f\x8b",
	"1-74-10" => "\xe8\x9e\xbd",
	"1-74-11" => "\xe8\x9f\x80",
	"1-74-12" => "\xe8\x9f\x90",
	"1-74-13" => "\xe9\x9b\x96",
	"1-74-14" => "\xe8\x9e\xab",
	"1-74-15" => "\xe8\x9f\x84",
	"1-74-16" => "\xe8\x9e\xb3",
	"1-74-17" => "\xe8\x9f\x87",
	"1-74-18" => "\xe8\x9f\x86",
	"1-74-19" => "\xe8\x9e\xbb",
	"1-74-20" => "\xe8\x9f\xaf",
	"1-74-21" => "\xe8\x9f\xb2",
	"1-74-22" => "\xe8\x9f\xa0",
	"1-74-23" => "\xe8\xa0\x8f",
	"1-74-24" => "\xe8\xa0\x8d",
	"1-74-25" => "\xe8\x9f\xbe",
	"1-74-26" => "\xe8\x9f\xb6",
	"1-74-27" => "\xe8\x9f\xb7",
	"1-74-28" => "\xe8\xa0\x8e",
	"1-74-29" => "\xe8\x9f\x92",
	"1-74-30" => "\xe8\xa0\x91",
	"1-74-31" => "\xe8\xa0\x96",
	"1-74-32" => "\xe8\xa0\x95",
	"1-74-33" => "\xe8\xa0\xa2",
	"1-74-34" => "\xe8\xa0\xa1",
	"1-74-35" => "\xe8\xa0\xb1",
	"1-74-36" => "\xe8\xa0\xb6",
	"1-74-37" => "\xe8\xa0\xb9",
	"1-74-38" => "\xe8\xa0\xa7",
	"1-74-39" => "\xe8\xa0\xbb",
	"1-74-40" => "\xe8\xa1\x84",
	"1-74-41" => "\xe8\xa1\x82",
	"1-74-42" => "\xe8\xa1\x92",
	"1-74-43" => "\xe8\xa1\x99",
	"1-74-44" => "\xe8\xa1\x9e",
	"1-74-45" => "\xe8\xa1\xa2",
	"1-74-46" => "\xe8\xa1\xab",
	"1-74-47" => "\xe8\xa2\x81",
	"1-74-48" => "\xe8\xa1\xbe",
	"1-74-49" => "\xe8\xa2\x9e",
	"1-74-50" => "\xe8\xa1\xb5",
	"1-74-51" => "\xe8\xa1\xbd",
	"1-74-52" => "\xe8\xa2\xb5",
	"1-74-53" => "\xe8\xa1\xb2",
	"1-74-54" => "\xe8\xa2\x82",
	"1-74-55" => "\xe8\xa2\x97",
	"1-74-56" => "\xe8\xa2\x92",
	"1-74-57" => "\xe8\xa2\xae",
	"1-74-58" => "\xe8\xa2\x99",
	"1-74-59" => "\xe8\xa2\xa2",
	"1-74-60" => "\xe8\xa2\x8d",
	"1-74-61" => "\xe8\xa2\xa4",
	"1-74-62" => "\xe8\xa2\xb0",
	"1-74-63" => "\xe8\xa2\xbf",
	"1-74-64" => "\xe8\xa2\xb1",
	"1-74-65" => "\xe8\xa3\x83",
	"1-74-66" => "\xe8\xa3\x84",
	"1-74-67" => "\xe8\xa3\x94",
	"1-74-68" => "\xe8\xa3\x98",
	"1-74-69" => "\xe8\xa3\x99",
	"1-74-70" => "\xe8\xa3\x9d",
	"1-74-71" => "\xe8\xa3\xb9",
	"1-74-72" => "\xe8\xa4\x82",
	"1-74-73" => "\xe8\xa3\xbc",
	"1-74-74" => "\xe8\xa3\xb4",
	"1-74-75" => "\xe8\xa3\xa8",
	"1-74-76" => "\xe8\xa3\xb2",
	"1-74-77" => "\xe8\xa4\x84",
	"1-74-78" => "\xe8\xa4\x8c",
	"1-74-79" => "\xe8\xa4\x8a",
	"1-74-80" => "\xe8\xa4\x93",
	"1-74-81" => "\xe8\xa5\x83",
	"1-74-82" => "\xe8\xa4\x9e",
	"1-74-83" => "\xe8\xa4\xa5",
	"1-74-84" => "\xe8\xa4\xaa",
	"1-74-85" => "\xe8\xa4\xab",
	"1-74-86" => "\xe8\xa5\x81",
	"1-74-87" => "\xe8\xa5\x84",
	"1-74-88" => "\xe8\xa4\xbb",
	"1-74-89" => "\xe8\xa4\xb6",
	"1-74-90" => "\xe8\xa4\xb8",
	"1-74-91" => "\xe8\xa5\x8c",
	"1-74-92" => "\xe8\xa4\x9d",
	"1-74-93" => "\xe8\xa5\xa0",
	"1-74-94" => "\xe8\xa5\x9e",
	"1-75-1" => "\xe8\xa5\xa6",
	"1-75-2" => "\xe8\xa5\xa4",
	"1-75-3" => "\xe8\xa5\xad",
	"1-75-4" => "\xe8\xa5\xaa",
	"1-75-5" => "\xe8\xa5\xaf",
	"1-75-6" => "\xe8\xa5\xb4",
	"1-75-7" => "\xe8\xa5\xb7",
	"1-75-8" => "\xe8\xa5\xbe",
	"1-75-9" => "\xe8\xa6\x83",
	"1-75-10" => "\xe8\xa6\x88",
	"1-75-11" => "\xe8\xa6\x8a",
	"1-75-12" => "\xe8\xa6\x93",
	"1-75-13" => "\xe8\xa6\x98",
	"1-75-14" => "\xe8\xa6\xa1",
	"1-75-15" => "\xe8\xa6\xa9",
	"1-75-16" => "\xe8\xa6\xa6",
	"1-75-17" => "\xe8\xa6\xac",
	"1-75-18" => "\xe8\xa6\xaf",
	"1-75-19" => "\xe8\xa6\xb2",
	"1-75-20" => "\xe8\xa6\xba",
	"1-75-21" => "\xe8\xa6\xbd",
	"1-75-22" => "\xe8\xa6\xbf",
	"1-75-23" => "\xe8\xa7\x80",
	"1-75-24" => "\xe8\xa7\x9a",
	"1-75-25" => "\xe8\xa7\x9c",
	"1-75-26" => "\xe8\xa7\x9d",
	"1-75-27" => "\xe8\xa7\xa7",
	"1-75-28" => "\xe8\xa7\xb4",
	"1-75-29" => "\xe8\xa7\xb8",
	"1-75-30" => "\xe8\xa8\x83",
	"1-75-31" => "\xe8\xa8\x96",
	"1-75-32" => "\xe8\xa8\x90",
	"1-75-33" => "\xe8\xa8\x8c",
	"1-75-34" => "\xe8\xa8\x9b",
	"1-75-35" => "\xe8\xa8\x9d",
	"1-75-36" => "\xe8\xa8\xa5",
	"1-75-37" => "\xe8\xa8\xb6",
	"1-75-38" => "\xe8\xa9\x81",
	"1-75-39" => "\xe8\xa9\x9b",
	"1-75-40" => "\xe8\xa9\x92",
	"1-75-41" => "\xe8\xa9\x86",
	"1-75-42" => "\xe8\xa9\x88",
	"1-75-43" => "\xe8\xa9\xbc",
	"1-75-44" => "\xe8\xa9\xad",
	"1-75-45" => "\xe8\xa9\xac",
	"1-75-46" => "\xe8\xa9\xa2",
	"1-75-47" => "\xe8\xaa\x85",
	"1-75-48" => "\xe8\xaa\x82",
	"1-75-49" => "\xe8\xaa\x84",
	"1-75-50" => "\xe8\xaa\xa8",
	"1-75-51" => "\xe8\xaa\xa1",
	"1-75-52" => "\xe8\xaa\x91",
	"1-75-53" => "\xe8\xaa\xa5",
	"1-75-54" => "\xe8\xaa\xa6",
	"1-75-55" => "\xe8\xaa\x9a",
	"1-75-56" => "\xe8\xaa\xa3",
	"1-75-57" => "\xe8\xab\x84",
	"1-75-58" => "\xe8\xab\x8d",
	"1-75-59" => "\xe8\xab\x82",
	"1-75-60" => "\xe8\xab\x9a",
	"1-75-61" => "\xe8\xab\xab",
	"1-75-62" => "\xe8\xab\xb3",
	"1-75-63" => "\xe8\xab\xa7",
	"1-75-64" => "\xe8\xab\xa4",
	"1-75-65" => "\xe8\xab\xb1",
	"1-75-66" => "\xe8\xac\x94",
	"1-75-67" => "\xe8\xab\xa0",
	"1-75-68" => "\xe8\xab\xa2",
	"1-75-69" => "\xe8\xab\xb7",
	"1-75-70" => "\xe8\xab\x9e",
	"1-75-71" => "\xe8\xab\x9b",
	"1-75-72" => "\xe8\xac\x8c",
	"1-75-73" => "\xe8\xac\x87",
	"1-75-74" => "\xe8\xac\x9a",
	"1-75-75" => "\xe8\xab\xa1",
	"1-75-76" => "\xe8\xac\x96",
	"1-75-77" => "\xe8\xac\x90",
	"1-75-78" => "\xe8\xac\x97",
	"1-75-79" => "\xe8\xac\xa0",
	"1-75-80" => "\xe8\xac\xb3",
	"1-75-81" => "\xe9\x9e\xab",
	"1-75-82" => "\xe8\xac\xa6",
	"1-75-83" => "\xe8\xac\xab",
	"1-75-84" => "\xe8\xac\xbe",
	"1-75-85" => "\xe8\xac\xa8",
	"1-75-86" => "\xe8\xad\x81",
	"1-75-87" => "\xe8\xad\x8c",
	"1-75-88" => "\xe8\xad\x8f",
	"1-75-89" => "\xe8\xad\x8e",
	"1-75-90" => "\xe8\xad\x89",
	"1-75-91" => "\xe8\xad\x96",
	"1-75-92" => "\xe8\xad\x9b",
	"1-75-93" => "\xe8\xad\x9a",
	"1-75-94" => "\xe8\xad\xab",
	"1-76-1" => "\xe8\xad\x9f",
	"1-76-2" => "\xe8\xad\xac",
	"1-76-3" => "\xe8\xad\xaf",
	"1-76-4" => "\xe8\xad\xb4",
	"1-76-5" => "\xe8\xad\xbd",
	"1-76-6" => "\xe8\xae\x80",
	"1-76-7" => "\xe8\xae\x8c",
	"1-76-8" => "\xe8\xae\x8e",
	"1-76-9" => "\xe8\xae\x92",
	"1-76-10" => "\xe8\xae\x93",
	"1-76-11" => "\xe8\xae\x96",
	"1-76-12" => "\xe8\xae\x99",
	"1-76-13" => "\xe8\xae\x9a",
	"1-76-14" => "\xe8\xb0\xba",
	"1-76-15" => "\xe8\xb1\x81",
	"1-76-16" => "\xe8\xb0\xbf",
	"1-76-17" => "\xe8\xb1\x88",
	"1-76-18" => "\xe8\xb1\x8c",
	"1-76-19" => "\xe8\xb1\x8e",
	"1-76-20" => "\xe8\xb1\x90",
	"1-76-21" => "\xe8\xb1\x95",
	"1-76-22" => "\xe8\xb1\xa2",
	"1-76-23" => "\xe8\xb1\xac",
	"1-76-24" => "\xe8\xb1\xb8",
	"1-76-25" => "\xe8\xb1\xba",
	"1-76-26" => "\xe8\xb2\x82",
	"1-76-27" => "\xe8\xb2\x89",
	"1-76-28" => "\xe8\xb2\x85",
	"1-76-29" => "\xe8\xb2\x8a",
	"1-76-30" => "\xe8\xb2\x8d",
	"1-76-31" => "\xe8\xb2\x8e",
	"1-76-32" => "\xe8\xb2\x94",
	"1-76-33" => "\xe8\xb1\xbc",
	"1-76-34" => "\xe8\xb2\x98",
	"1-76-35" => "\xe6\x88\x9d",
	"1-76-36" => "\xe8\xb2\xad",
	"1-76-37" => "\xe8\xb2\xaa",
	"1-76-38" => "\xe8\xb2\xbd",
	"1-76-39" => "\xe8\xb2\xb2",
	"1-76-40" => "\xe8\xb2\xb3",
	"1-76-41" => "\xe8\xb2\xae",
	"1-76-42" => "\xe8\xb2\xb6",
	"1-76-43" => "\xe8\xb3\x88",
	"1-76-44" => "\xe8\xb3\x81",
	"1-76-45" => "\xe8\xb3\xa4",
	"1-76-46" => "\xe8\xb3\xa3",
	"1-76-47" => "\xe8\xb3\x9a",
	"1-76-48" => "\xe8\xb3\xbd",
	"1-76-49" => "\xe8\xb3\xba",
	"1-76-50" => "\xe8\xb3\xbb",
	"1-76-51" => "\xe8\xb4\x84",
	"1-76-52" => "\xe8\xb4\x85",
	"1-76-53" => "\xe8\xb4\x8a",
	"1-76-54" => "\xe8\xb4\x87",
	"1-76-55" => "\xe8\xb4\x8f",
	"1-76-56" => "\xe8\xb4\x8d",
	"1-76-57" => "\xe8\xb4\x90",
	"1-76-58" => "\xe9\xbd\x8e",
	"1-76-59" => "\xe8\xb4\x93",
	"1-76-60" => "\xe8\xb3\x8d",
	"1-76-61" => "\xe8\xb4\x94",
	"1-76-62" => "\xe8\xb4\x96",
	"1-76-63" => "\xe8\xb5\xa7",
	"1-76-64" => "\xe8\xb5\xad",
	"1-76-65" => "\xe8\xb5\xb1",
	"1-76-66" => "\xe8\xb5\xb3",
	"1-76-67" => "\xe8\xb6\x81",
	"1-76-68" => "\xe8\xb6\x99",
	"1-76-69" => "\xe8\xb7\x82",
	"1-76-70" => "\xe8\xb6\xbe",
	"1-76-71" => "\xe8\xb6\xba",
	"1-76-72" => "\xe8\xb7\x8f",
	"1-76-73" => "\xe8\xb7\x9a",
	"1-76-74" => "\xe8\xb7\x96",
	"1-76-75" => "\xe8\xb7\x8c",
	"1-76-76" => "\xe8\xb7\x9b",
	"1-76-77" => "\xe8\xb7\x8b",
	"1-76-78" => "\xe8\xb7\xaa",
	"1-76-79" => "\xe8\xb7\xab",
	"1-76-80" => "\xe8\xb7\x9f",
	"1-76-81" => "\xe8\xb7\xa3",
	"1-76-82" => "\xe8\xb7\xbc",
	"1-76-83" => "\xe8\xb8\x88",
	"1-76-84" => "\xe8\xb8\x89",
	"1-76-85" => "\xe8\xb7\xbf",
	"1-76-86" => "\xe8\xb8\x9d",
	"1-76-87" => "\xe8\xb8\x9e",
	"1-76-88" => "\xe8\xb8\x90",
	"1-76-89" => "\xe8\xb8\x9f",
	"1-76-90" => "\xe8\xb9\x82",
	"1-76-91" => "\xe8\xb8\xb5",
	"1-76-92" => "\xe8\xb8\xb0",
	"1-76-93" => "\xe8\xb8\xb4",
	"1-76-94" => "\xe8\xb9\x8a",
	"1-77-1" => "\xe8\xb9\x87",
	"1-77-2" => "\xe8\xb9\x89",
	"1-77-3" => "\xe8\xb9\x8c",
	"1-77-4" => "\xe8\xb9\x90",
	"1-77-5" => "\xe8\xb9\x88",
	"1-77-6" => "\xe8\xb9\x99",
	"1-77-7" => "\xe8\xb9\xa4",
	"1-77-8" => "\xe8\xb9\xa0",
	"1-77-9" => "\xe8\xb8\xaa",
	"1-77-10" => "\xe8\xb9\xa3",
	"1-77-11" => "\xe8\xb9\x95",
	"1-77-12" => "\xe8\xb9\xb6",
	"1-77-13" => "\xe8\xb9\xb2",
	"1-77-14" => "\xe8\xb9\xbc",
	"1-77-15" => "\xe8\xba\x81",
	"1-77-16" => "\xe8\xba\x87",
	"1-77-17" => "\xe8\xba\x85",
	"1-77-18" => "\xe8\xba\x84",
	"1-77-19" => "\xe8\xba\x8b",
	"1-77-20" => "\xe8\xba\x8a",
	"1-77-21" => "\xe8\xba\x93",
	"1-77-22" => "\xe8\xba\x91",
	"1-77-23" => "\xe8\xba\x94",
	"1-77-24" => "\xe8\xba\x99",
	"1-77-25" => "\xe8\xba\xaa",
	"1-77-26" => "\xe8\xba\xa1",
	"1-77-27" => "\xe8\xba\xac",
	"1-77-28" => "\xe8\xba\xb0",
	"1-77-29" => "\xe8\xbb\x86",
	"1-77-30" => "\xe8\xba\xb1",
	"1-77-31" => "\xe8\xba\xbe",
	"1-77-32" => "\xe8\xbb\x85",
	"1-77-33" => "\xe8\xbb\x88",
	"1-77-34" => "\xe8\xbb\x8b",
	"1-77-35" => "\xe8\xbb\x9b",
	"1-77-36" => "\xe8\xbb\xa3",
	"1-77-37" => "\xe8\xbb\xbc",
	"1-77-38" => "\xe8\xbb\xbb",
	"1-77-39" => "\xe8\xbb\xab",
	"1-77-40" => "\xe8\xbb\xbe",
	"1-77-41" => "\xe8\xbc\x8a",
	"1-77-42" => "\xe8\xbc\x85",
	"1-77-43" => "\xe8\xbc\x95",
	"1-77-44" => "\xe8\xbc\x92",
	"1-77-45" => "\xe8\xbc\x99",
	"1-77-46" => "\xe8\xbc\x93",
	"1-77-47" => "\xe8\xbc\x9c",
	"1-77-48" => "\xe8\xbc\x9f",
	"1-77-49" => "\xe8\xbc\x9b",
	"1-77-50" => "\xe8\xbc\x8c",
	"1-77-51" => "\xe8\xbc\xa6",
	"1-77-52" => "\xe8\xbc\xb3",
	"1-77-53" => "\xe8\xbc\xbb",
	"1-77-54" => "\xe8\xbc\xb9",
	"1-77-55" => "\xe8\xbd\x85",
	"1-77-56" => "\xe8\xbd\x82",
	"1-77-57" => "\xe8\xbc\xbe",
	"1-77-58" => "\xe8\xbd\x8c",
	"1-77-59" => "\xe8\xbd\x89",
	"1-77-60" => "\xe8\xbd\x86",
	"1-77-61" => "\xe8\xbd\x8e",
	"1-77-62" => "\xe8\xbd\x97",
	"1-77-63" => "\xe8\xbd\x9c",
	"1-77-64" => "\xe8\xbd\xa2",
	"1-77-65" => "\xe8\xbd\xa3",
	"1-77-66" => "\xe8\xbd\xa4",
	"1-77-67" => "\xe8\xbe\x9c",
	"1-77-68" => "\xe8\xbe\x9f",
	"1-77-69" => "\xe8\xbe\xa3",
	"1-77-70" => "\xe8\xbe\xad",
	"1-77-71" => "\xe8\xbe\xaf",
	"1-77-72" => "\xe8\xbe\xb7",
	"1-77-73" => "\xe8\xbf\x9a",
	"1-77-74" => "\xe8\xbf\xa5",
	"1-77-75" => "\xe8\xbf\xa2",
	"1-77-76" => "\xe8\xbf\xaa",
	"1-77-77" => "\xe8\xbf\xaf",
	"1-77-78" => "\xe9\x82\x87",
	"1-77-79" => "\xe8\xbf\xb4",
	"1-77-80" => "\xe9\x80\x85",
	"1-77-81" => "\xe8\xbf\xb9",
	"1-77-82" => "\xe8\xbf\xba",
	"1-77-83" => "\xe9\x80\x91",
	"1-77-84" => "\xe9\x80\x95",
	"1-77-85" => "\xe9\x80\xa1",
	"1-77-86" => "\xe9\x80\x8d",
	"1-77-87" => "\xe9\x80\x9e",
	"1-77-88" => "\xe9\x80\x96",
	"1-77-89" => "\xe9\x80\x8b",
	"1-77-90" => "\xe9\x80\xa7",
	"1-77-91" => "\xe9\x80\xb6",
	"1-77-92" => "\xe9\x80\xb5",
	"1-77-93" => "\xe9\x80\xb9",
	"1-77-94" => "\xe8\xbf\xb8",
	"1-78-1" => "\xe9\x81\x8f",
	"1-78-2" => "\xe9\x81\x90",
	"1-78-3" => "\xe9\x81\x91",
	"1-78-4" => "\xe9\x81\x92",
	"1-78-5" => "\xe9\x80\x8e",
	"1-78-6" => "\xe9\x81\x89",
	"1-78-7" => "\xe9\x80\xbe",
	"1-78-8" => "\xe9\x81\x96",
	"1-78-9" => "\xe9\x81\x98",
	"1-78-10" => "\xe9\x81\x9e",
	"1-78-11" => "\xe9\x81\xa8",
	"1-78-12" => "\xe9\x81\xaf",
	"1-78-13" => "\xe9\x81\xb6",
	"1-78-14" => "\xe9\x9a\xa8",
	"1-78-15" => "\xe9\x81\xb2",
	"1-78-16" => "\xe9\x82\x82",
	"1-78-17" => "\xe9\x81\xbd",
	"1-78-18" => "\xe9\x82\x81",
	"1-78-19" => "\xe9\x82\x80",
	"1-78-20" => "\xe9\x82\x8a",
	"1-78-21" => "\xe9\x82\x89",
	"1-78-22" => "\xe9\x82\x8f",
	"1-78-23" => "\xe9\x82\xa8",
	"1-78-24" => "\xe9\x82\xaf",
	"1-78-25" => "\xe9\x82\xb1",
	"1-78-26" => "\xe9\x82\xb5",
	"1-78-27" => "\xe9\x83\xa2",
	"1-78-28" => "\xe9\x83\xa4",
	"1-78-29" => "\xe6\x89\x88",
	"1-78-30" => "\xe9\x83\x9b",
	"1-78-31" => "\xe9\x84\x82",
	"1-78-32" => "\xe9\x84\x92",
	"1-78-33" => "\xe9\x84\x99",
	"1-78-34" => "\xe9\x84\xb2",
	"1-78-35" => "\xe9\x84\xb0",
	"1-78-36" => "\xe9\x85\x8a",
	"1-78-37" => "\xe9\x85\x96",
	"1-78-38" => "\xe9\x85\x98",
	"1-78-39" => "\xe9\x85\xa3",
	"1-78-40" => "\xe9\x85\xa5",
	"1-78-41" => "\xe9\x85\xa9",
	"1-78-42" => "\xe9\x85\xb3",
	"1-78-43" => "\xe9\x85\xb2",
	"1-78-44" => "\xe9\x86\x8b",
	"1-78-45" => "\xe9\x86\x89",
	"1-78-46" => "\xe9\x86\x82",
	"1-78-47" => "\xe9\x86\xa2",
	"1-78-48" => "\xe9\x86\xab",
	"1-78-49" => "\xe9\x86\xaf",
	"1-78-50" => "\xe9\x86\xaa",
	"1-78-51" => "\xe9\x86\xb5",
	"1-78-52" => "\xe9\x86\xb4",
	"1-78-53" => "\xe9\x86\xba",
	"1-78-54" => "\xe9\x87\x80",
	"1-78-55" => "\xe9\x87\x81",
	"1-78-56" => "\xe9\x87\x89",
	"1-78-57" => "\xe9\x87\x8b",
	"1-78-58" => "\xe9\x87\x90",
	"1-78-59" => "\xe9\x87\x96",
	"1-78-60" => "\xe9\x87\x9f",
	"1-78-61" => "\xe9\x87\xa1",
	"1-78-62" => "\xe9\x87\x9b",
	"1-78-63" => "\xe9\x87\xbc",
	"1-78-64" => "\xe9\x87\xb5",
	"1-78-65" => "\xe9\x87\xb6",
	"1-78-66" => "\xe9\x88\x9e",
	"1-78-67" => "\xe9\x87\xbf",
	"1-78-68" => "\xe9\x88\x94",
	"1-78-69" => "\xe9\x88\xac",
	"1-78-70" => "\xe9\x88\x95",
	"1-78-71" => "\xe9\x88\x91",
	"1-78-72" => "\xe9\x89\x9e",
	"1-78-73" => "\xe9\x89\x97",
	"1-78-74" => "\xe9\x89\x85",
	"1-78-75" => "\xe9\x89\x89",
	"1-78-76" => "\xe9\x89\xa4",
	"1-78-77" => "\xe9\x89\x88",
	"1-78-78" => "\xe9\x8a\x95",
	"1-78-79" => "\xe9\x88\xbf",
	"1-78-80" => "\xe9\x89\x8b",
	"1-78-81" => "\xe9\x89\x90",
	"1-78-82" => "\xe9\x8a\x9c",
	"1-78-83" => "\xe9\x8a\x96",
	"1-78-84" => "\xe9\x8a\x93",
	"1-78-85" => "\xe9\x8a\x9b",
	"1-78-86" => "\xe9\x89\x9a",
	"1-78-87" => "\xe9\x8b\x8f",
	"1-78-88" => "\xe9\x8a\xb9",
	"1-78-89" => "\xe9\x8a\xb7",
	"1-78-90" => "\xe9\x8b\xa9",
	"1-78-91" => "\xe9\x8c\x8f",
	"1-78-92" => "\xe9\x8b\xba",
	"1-78-93" => "\xe9\x8d\x84",
	"1-78-94" => "\xe9\x8c\xae",
	"1-79-1" => "\xe9\x8c\x99",
	"1-79-2" => "\xe9\x8c\xa2",
	"1-79-3" => "\xe9\x8c\x9a",
	"1-79-4" => "\xe9\x8c\xa3",
	"1-79-5" => "\xe9\x8c\xba",
	"1-79-6" => "\xe9\x8c\xb5",
	"1-79-7" => "\xe9\x8c\xbb",
	"1-79-8" => "\xe9\x8d\x9c",
	"1-79-9" => "\xe9\x8d\xa0",
	"1-79-10" => "\xe9\x8d\xbc",
	"1-79-11" => "\xe9\x8d\xae",
	"1-79-12" => "\xe9\x8d\x96",
	"1-79-13" => "\xe9\x8e\xb0",
	"1-79-14" => "\xe9\x8e\xac",
	"1-79-15" => "\xe9\x8e\xad",
	"1-79-16" => "\xe9\x8e\x94",
	"1-79-17" => "\xe9\x8e\xb9",
	"1-79-18" => "\xe9\x8f\x96",
	"1-79-19" => "\xe9\x8f\x97",
	"1-79-20" => "\xe9\x8f\xa8",
	"1-79-21" => "\xe9\x8f\xa5",
	"1-79-22" => "\xe9\x8f\x98",
	"1-79-23" => "\xe9\x8f\x83",
	"1-79-24" => "\xe9\x8f\x9d",
	"1-79-25" => "\xe9\x8f\x90",
	"1-79-26" => "\xe9\x8f\x88",
	"1-79-27" => "\xe9\x8f\xa4",
	"1-79-28" => "\xe9\x90\x9a",
	"1-79-29" => "\xe9\x90\x94",
	"1-79-30" => "\xe9\x90\x93",
	"1-79-31" => "\xe9\x90\x83",
	"1-79-32" => "\xe9\x90\x87",
	"1-79-33" => "\xe9\x90\x90",
	"1-79-34" => "\xe9\x90\xb6",
	"1-79-35" => "\xe9\x90\xab",
	"1-79-36" => "\xe9\x90\xb5",
	"1-79-37" => "\xe9\x90\xa1",
	"1-79-38" => "\xe9\x90\xba",
	"1-79-39" => "\xe9\x91\x81",
	"1-79-40" => "\xe9\x91\x92",
	"1-79-41" => "\xe9\x91\x84",
	"1-79-42" => "\xe9\x91\x9b",
	"1-79-43" => "\xe9\x91\xa0",
	"1-79-44" => "\xe9\x91\xa2",
	"1-79-45" => "\xe9\x91\x9e",
	"1-79-46" => "\xe9\x91\xaa",
	"1-79-47" => "\xe9\x88\xa9",
	"1-79-48" => "\xe9\x91\xb0",
	"1-79-49" => "\xe9\x91\xb5",
	"1-79-50" => "\xe9\x91\xb7",
	"1-79-51" => "\xe9\x91\xbd",
	"1-79-52" => "\xe9\x91\x9a",
	"1-79-53" => "\xe9\x91\xbc",
	"1-79-54" => "\xe9\x91\xbe",
	"1-79-55" => "\xe9\x92\x81",
	"1-79-56" => "\xe9\x91\xbf",
	"1-79-57" => "\xe9\x96\x82",
	"1-79-58" => "\xe9\x96\x87",
	"1-79-59" => "\xe9\x96\x8a",
	"1-79-60" => "\xe9\x96\x94",
	"1-79-61" => "\xe9\x96\x96",
	"1-79-62" => "\xe9\x96\x98",
	"1-79-63" => "\xe9\x96\x99",
	"1-79-64" => "\xe9\x96\xa0",
	"1-79-65" => "\xe9\x96\xa8",
	"1-79-66" => "\xe9\x96\xa7",
	"1-79-67" => "\xe9\x96\xad",
	"1-79-68" => "\xe9\x96\xbc",
	"1-79-69" => "\xe9\x96\xbb",
	"1-79-70" => "\xe9\x96\xb9",
	"1-79-71" => "\xe9\x96\xbe",
	"1-79-72" => "\xe9\x97\x8a",
	"1-79-73" => "\xe6\xbf\xb6",
	"1-79-74" => "\xe9\x97\x83",
	"1-79-75" => "\xe9\x97\x8d",
	"1-79-76" => "\xe9\x97\x8c",
	"1-79-77" => "\xe9\x97\x95",
	"1-79-78" => "\xe9\x97\x94",
	"1-79-79" => "\xe9\x97\x96",
	"1-79-80" => "\xe9\x97\x9c",
	"1-79-81" => "\xe9\x97\xa1",
	"1-79-82" => "\xe9\x97\xa5",
	"1-79-83" => "\xe9\x97\xa2",
	"1-79-84" => "\xe9\x98\xa1",
	"1-79-85" => "\xe9\x98\xa8",
	"1-79-86" => "\xe9\x98\xae",
	"1-79-87" => "\xe9\x98\xaf",
	"1-79-88" => "\xe9\x99\x82",
	"1-79-89" => "\xe9\x99\x8c",
	"1-79-90" => "\xe9\x99\x8f",
	"1-79-91" => "\xe9\x99\x8b",
	"1-79-92" => "\xe9\x99\xb7",
	"1-79-93" => "\xe9\x99\x9c",
	"1-79-94" => "\xe9\x99\x9e",
	"1-80-1" => "\xe9\x99\x9d",
	"1-80-2" => "\xe9\x99\x9f",
	"1-80-3" => "\xe9\x99\xa6",
	"1-80-4" => "\xe9\x99\xb2",
	"1-80-5" => "\xe9\x99\xac",
	"1-80-6" => "\xe9\x9a\x8d",
	"1-80-7" => "\xe9\x9a\x98",
	"1-80-8" => "\xe9\x9a\x95",
	"1-80-9" => "\xe9\x9a\x97",
	"1-80-10" => "\xe9\x9a\xaa",
	"1-80-11" => "\xe9\x9a\xa7",
	"1-80-12" => "\xe9\x9a\xb1",
	"1-80-13" => "\xe9\x9a\xb2",
	"1-80-14" => "\xe9\x9a\xb0",
	"1-80-15" => "\xe9\x9a\xb4",
	"1-80-16" => "\xe9\x9a\xb6",
	"1-80-17" => "\xe9\x9a\xb8",
	"1-80-18" => "\xe9\x9a\xb9",
	"1-80-19" => "\xe9\x9b\x8e",
	"1-80-20" => "\xe9\x9b\x8b",
	"1-80-21" => "\xe9\x9b\x89",
	"1-80-22" => "\xe9\x9b\x8d",
	"1-80-23" => "\xe8\xa5\x8d",
	"1-80-24" => "\xe9\x9b\x9c",
	"1-80-25" => "\xe9\x9c\x8d",
	"1-80-26" => "\xe9\x9b\x95",
	"1-80-27" => "\xe9\x9b\xb9",
	"1-80-28" => "\xe9\x9c\x84",
	"1-80-29" => "\xe9\x9c\x86",
	"1-80-30" => "\xe9\x9c\x88",
	"1-80-31" => "\xe9\x9c\x93",
	"1-80-32" => "\xe9\x9c\x8e",
	"1-80-33" => "\xe9\x9c\x91",
	"1-80-34" => "\xe9\x9c\x8f",
	"1-80-35" => "\xe9\x9c\x96",
	"1-80-36" => "\xe9\x9c\x99",
	"1-80-37" => "\xe9\x9c\xa4",
	"1-80-38" => "\xe9\x9c\xaa",
	"1-80-39" => "\xe9\x9c\xb0",
	"1-80-40" => "\xe9\x9c\xb9",
	"1-80-41" => "\xe9\x9c\xbd",
	"1-80-42" => "\xe9\x9c\xbe",
	"1-80-43" => "\xe9\x9d\x84",
	"1-80-44" => "\xe9\x9d\x86",
	"1-80-45" => "\xe9\x9d\x88",
	"1-80-46" => "\xe9\x9d\x82",
	"1-80-47" => "\xe9\x9d\x89",
	"1-80-48" => "\xe9\x9d\x9c",
	"1-80-49" => "\xe9\x9d\xa0",
	"1-80-50" => "\xe9\x9d\xa4",
	"1-80-51" => "\xe9\x9d\xa6",
	"1-80-52" => "\xe9\x9d\xa8",
	"1-80-53" => "\xe5\x8b\x92",
	"1-80-54" => "\xe9\x9d\xab",
	"1-80-55" => "\xe9\x9d\xb1",
	"1-80-56" => "\xe9\x9d\xb9",
	"1-80-57" => "\xe9\x9e\x85",
	"1-80-58" => "\xe9\x9d\xbc",
	"1-80-59" => "\xe9\x9e\x81",
	"1-80-60" => "\xe9\x9d\xba",
	"1-80-61" => "\xe9\x9e\x86",
	"1-80-62" => "\xe9\x9e\x8b",
	"1-80-63" => "\xe9\x9e\x8f",
	"1-80-64" => "\xe9\x9e\x90",
	"1-80-65" => "\xe9\x9e\x9c",
	"1-80-66" => "\xe9\x9e\xa8",
	"1-80-67" => "\xe9\x9e\xa6",
	"1-80-68" => "\xe9\x9e\xa3",
	"1-80-69" => "\xe9\x9e\xb3",
	"1-80-70" => "\xe9\x9e\xb4",
	"1-80-71" => "\xe9\x9f\x83",
	"1-80-72" => "\xe9\x9f\x86",
	"1-80-73" => "\xe9\x9f\x88",
	"1-80-74" => "\xe9\x9f\x8b",
	"1-80-75" => "\xe9\x9f\x9c",
	"1-80-76" => "\xe9\x9f\xad",
	"1-80-77" => "\xe9\xbd\x8f",
	"1-80-78" => "\xe9\x9f\xb2",
	"1-80-79" => "\xe7\xab\x9f",
	"1-80-80" => "\xe9\x9f\xb6",
	"1-80-81" => "\xe9\x9f\xb5",
	"1-80-82" => "\xe9\xa0\x8f",
	"1-80-83" => "\xe9\xa0\x8c",
	"1-80-84" => "\xe9\xa0\xb8",
	"1-80-85" => "\xe9\xa0\xa4",
	"1-80-86" => "\xe9\xa0\xa1",
	"1-80-87" => "\xe9\xa0\xb7",
	"1-80-88" => "\xe9\xa0\xbd",
	"1-80-89" => "\xe9\xa1\x86",
	"1-80-90" => "\xe9\xa1\x8f",
	"1-80-91" => "\xe9\xa1\x8b",
	"1-80-92" => "\xe9\xa1\xab",
	"1-80-93" => "\xe9\xa1\xaf",
	"1-80-94" => "\xe9\xa1\xb0",
	"1-81-1" => "\xe9\xa1\xb1",
	"1-81-2" => "\xe9\xa1\xb4",
	"1-81-3" => "\xe9\xa1\xb3",
	"1-81-4" => "\xe9\xa2\xaa",
	"1-81-5" => "\xe9\xa2\xaf",
	"1-81-6" => "\xe9\xa2\xb1",
	"1-81-7" => "\xe9\xa2\xb6",
	"1-81-8" => "\xe9\xa3\x84",
	"1-81-9" => "\xe9\xa3\x83",
	"1-81-10" => "\xe9\xa3\x86",
	"1-81-11" => "\xe9\xa3\xa9",
	"1-81-12" => "\xe9\xa3\xab",
	"1-81-13" => "\xe9\xa4\x83",
	"1-81-14" => "\xe9\xa4\x89",
	"1-81-15" => "\xe9\xa4\x92",
	"1-81-16" => "\xe9\xa4\x94",
	"1-81-17" => "\xe9\xa4\x98",
	"1-81-18" => "\xe9\xa4\xa1",
	"1-81-19" => "\xe9\xa4\x9d",
	"1-81-20" => "\xe9\xa4\x9e",
	"1-81-21" => "\xe9\xa4\xa4",
	"1-81-22" => "\xe9\xa4\xa0",
	"1-81-23" => "\xe9\xa4\xac",
	"1-81-24" => "\xe9\xa4\xae",
	"1-81-25" => "\xe9\xa4\xbd",
	"1-81-26" => "\xe9\xa4\xbe",
	"1-81-27" => "\xe9\xa5\x82",
	"1-81-28" => "\xe9\xa5\x89",
	"1-81-29" => "\xe9\xa5\x85",
	"1-81-30" => "\xe9\xa5\x90",
	"1-81-31" => "\xe9\xa5\x8b",
	"1-81-32" => "\xe9\xa5\x91",
	"1-81-33" => "\xe9\xa5\x92",
	"1-81-34" => "\xe9\xa5\x8c",
	"1-81-35" => "\xe9\xa5\x95",
	"1-81-36" => "\xe9\xa6\x97",
	"1-81-37" => "\xe9\xa6\x98",
	"1-81-38" => "\xe9\xa6\xa5",
	"1-81-39" => "\xe9\xa6\xad",
	"1-81-40" => "\xe9\xa6\xae",
	"1-81-41" => "\xe9\xa6\xbc",
	"1-81-42" => "\xe9\xa7\x9f",
	"1-81-43" => "\xe9\xa7\x9b",
	"1-81-44" => "\xe9\xa7\x9d",
	"1-81-45" => "\xe9\xa7\x98",
	"1-81-46" => "\xe9\xa7\x91",
	"1-81-47" => "\xe9\xa7\xad",
	"1-81-48" => "\xe9\xa7\xae",
	"1-81-49" => "\xe9\xa7\xb1",
	"1-81-50" => "\xe9\xa7\xb2",
	"1-81-51" => "\xe9\xa7\xbb",
	"1-81-52" => "\xe9\xa7\xb8",
	"1-81-53" => "\xe9\xa8\x81",
	"1-81-54" => "\xe9\xa8\x8f",
	"1-81-55" => "\xe9\xa8\x85",
	"1-81-56" => "\xe9\xa7\xa2",
	"1-81-57" => "\xe9\xa8\x99",
	"1-81-58" => "\xe9\xa8\xab",
	"1-81-59" => "\xe9\xa8\xb7",
	"1-81-60" => "\xe9\xa9\x85",
	"1-81-61" => "\xe9\xa9\x82",
	"1-81-62" => "\xe9\xa9\x80",
	"1-81-63" => "\xe9\xa9\x83",
	"1-81-64" => "\xe9\xa8\xbe",
	"1-81-65" => "\xe9\xa9\x95",
	"1-81-66" => "\xe9\xa9\x8d",
	"1-81-67" => "\xe9\xa9\x9b",
	"1-81-68" => "\xe9\xa9\x97",
	"1-81-69" => "\xe9\xa9\x9f",
	"1-81-70" => "\xe9\xa9\xa2",
	"1-81-71" => "\xe9\xa9\xa5",
	"1-81-72" => "\xe9\xa9\xa4",
	"1-81-73" => "\xe9\xa9\xa9",
	"1-81-74" => "\xe9\xa9\xab",
	"1-81-75" => "\xe9\xa9\xaa",
	"1-81-76" => "\xe9\xaa\xad",
	"1-81-77" => "\xe9\xaa\xb0",
	"1-81-78" => "\xe9\xaa\xbc",
	"1-81-79" => "\xe9\xab\x80",
	"1-81-80" => "\xe9\xab\x8f",
	"1-81-81" => "\xe9\xab\x91",
	"1-81-82" => "\xe9\xab\x93",
	"1-81-83" => "\xe9\xab\x94",
	"1-81-84" => "\xe9\xab\x9e",
	"1-81-85" => "\xe9\xab\x9f",
	"1-81-86" => "\xe9\xab\xa2",
	"1-81-87" => "\xe9\xab\xa3",
	"1-81-88" => "\xe9\xab\xa6",
	"1-81-89" => "\xe9\xab\xaf",
	"1-81-90" => "\xe9\xab\xab",
	"1-81-91" => "\xe9\xab\xae",
	"1-81-92" => "\xe9\xab\xb4",
	"1-81-93" => "\xe9\xab\xb1",
	"1-81-94" => "\xe9\xab\xb7",
	"1-82-1" => "\xe9\xab\xbb",
	"1-82-2" => "\xe9\xac\x86",
	"1-82-3" => "\xe9\xac\x98",
	"1-82-4" => "\xe9\xac\x9a",
	"1-82-5" => "\xe9\xac\x9f",
	"1-82-6" => "\xe9\xac\xa2",
	"1-82-7" => "\xe9\xac\xa3",
	"1-82-8" => "\xe9\xac\xa5",
	"1-82-9" => "\xe9\xac\xa7",
	"1-82-10" => "\xe9\xac\xa8",
	"1-82-11" => "\xe9\xac\xa9",
	"1-82-12" => "\xe9\xac\xaa",
	"1-82-13" => "\xe9\xac\xae",
	"1-82-14" => "\xe9\xac\xaf",
	"1-82-15" => "\xe9\xac\xb2",
	"1-82-16" => "\xe9\xad\x84",
	"1-82-17" => "\xe9\xad\x83",
	"1-82-18" => "\xe9\xad\x8f",
	"1-82-19" => "\xe9\xad\x8d",
	"1-82-20" => "\xe9\xad\x8e",
	"1-82-21" => "\xe9\xad\x91",
	"1-82-22" => "\xe9\xad\x98",
	"1-82-23" => "\xe9\xad\xb4",
	"1-82-24" => "\xe9\xae\x93",
	"1-82-25" => "\xe9\xae\x83",
	"1-82-26" => "\xe9\xae\x91",
	"1-82-27" => "\xe9\xae\x96",
	"1-82-28" => "\xe9\xae\x97",
	"1-82-29" => "\xe9\xae\x9f",
	"1-82-30" => "\xe9\xae\xa0",
	"1-82-31" => "\xe9\xae\xa8",
	"1-82-32" => "\xe9\xae\xb4",
	"1-82-33" => "\xe9\xaf\x80",
	"1-82-34" => "\xe9\xaf\x8a",
	"1-82-35" => "\xe9\xae\xb9",
	"1-82-36" => "\xe9\xaf\x86",
	"1-82-37" => "\xe9\xaf\x8f",
	"1-82-38" => "\xe9\xaf\x91",
	"1-82-39" => "\xe9\xaf\x92",
	"1-82-40" => "\xe9\xaf\xa3",
	"1-82-41" => "\xe9\xaf\xa2",
	"1-82-42" => "\xe9\xaf\xa4",
	"1-82-43" => "\xe9\xaf\x94",
	"1-82-44" => "\xe9\xaf\xa1",
	"1-82-45" => "\xe9\xb0\xba",
	"1-82-46" => "\xe9\xaf\xb2",
	"1-82-47" => "\xe9\xaf\xb1",
	"1-82-48" => "\xe9\xaf\xb0",
	"1-82-49" => "\xe9\xb0\x95",
	"1-82-50" => "\xe9\xb0\x94",
	"1-82-51" => "\xe9\xb0\x89",
	"1-82-52" => "\xe9\xb0\x93",
	"1-82-53" => "\xe9\xb0\x8c",
	"1-82-54" => "\xe9\xb0\x86",
	"1-82-55" => "\xe9\xb0\x88",
	"1-82-56" => "\xe9\xb0\x92",
	"1-82-57" => "\xe9\xb0\x8a",
	"1-82-58" => "\xe9\xb0\x84",
	"1-82-59" => "\xe9\xb0\xae",
	"1-82-60" => "\xe9\xb0\x9b",
	"1-82-61" => "\xe9\xb0\xa5",
	"1-82-62" => "\xe9\xb0\xa4",
	"1-82-63" => "\xe9\xb0\xa1",
	"1-82-64" => "\xe9\xb0\xb0",
	"1-82-65" => "\xe9\xb1\x87",
	"1-82-66" => "\xe9\xb0\xb2",
	"1-82-67" => "\xe9\xb1\x86",
	"1-82-68" => "\xe9\xb0\xbe",
	"1-82-69" => "\xe9\xb1\x9a",
	"1-82-70" => "\xe9\xb1\xa0",
	"1-82-71" => "\xe9\xb1\xa7",
	"1-82-72" => "\xe9\xb1\xb6",
	"1-82-73" => "\xe9\xb1\xb8",
	"1-82-74" => "\xe9\xb3\xa7",
	"1-82-75" => "\xe9\xb3\xac",
	"1-82-76" => "\xe9\xb3\xb0",
	"1-82-77" => "\xe9\xb4\x89",
	"1-82-78" => "\xe9\xb4\x88",
	"1-82-79" => "\xe9\xb3\xab",
	"1-82-80" => "\xe9\xb4\x83",
	"1-82-81" => "\xe9\xb4\x86",
	"1-82-82" => "\xe9\xb4\xaa",
	"1-82-83" => "\xe9\xb4\xa6",
	"1-82-84" => "\xe9\xb6\xaf",
	"1-82-85" => "\xe9\xb4\xa3",
	"1-82-86" => "\xe9\xb4\x9f",
	"1-82-87" => "\xe9\xb5\x84",
	"1-82-88" => "\xe9\xb4\x95",
	"1-82-89" => "\xe9\xb4\x92",
	"1-82-90" => "\xe9\xb5\x81",
	"1-82-91" => "\xe9\xb4\xbf",
	"1-82-92" => "\xe9\xb4\xbe",
	"1-82-93" => "\xe9\xb5\x86",
	"1-82-94" => "\xe9\xb5\x88",
	"1-83-1" => "\xe9\xb5\x9d",
	"1-83-2" => "\xe9\xb5\x9e",
	"1-83-3" => "\xe9\xb5\xa4",
	"1-83-4" => "\xe9\xb5\x91",
	"1-83-5" => "\xe9\xb5\x90",
	"1-83-6" => "\xe9\xb5\x99",
	"1-83-7" => "\xe9\xb5\xb2",
	"1-83-8" => "\xe9\xb6\x89",
	"1-83-9" => "\xe9\xb6\x87",
	"1-83-10" => "\xe9\xb6\xab",
	"1-83-11" => "\xe9\xb5\xaf",
	"1-83-12" => "\xe9\xb5\xba",
	"1-83-13" => "\xe9\xb6\x9a",
	"1-83-14" => "\xe9\xb6\xa4",
	"1-83-15" => "\xe9\xb6\xa9",
	"1-83-16" => "\xe9\xb6\xb2",
	"1-83-17" => "\xe9\xb7\x84",
	"1-83-18" => "\xe9\xb7\x81",
	"1-83-19" => "\xe9\xb6\xbb",
	"1-83-20" => "\xe9\xb6\xb8",
	"1-83-21" => "\xe9\xb6\xba",
	"1-83-22" => "\xe9\xb7\x86",
	"1-83-23" => "\xe9\xb7\x8f",
	"1-83-24" => "\xe9\xb7\x82",
	"1-83-25" => "\xe9\xb7\x99",
	"1-83-26" => "\xe9\xb7\x93",
	"1-83-27" => "\xe9\xb7\xb8",
	"1-83-28" => "\xe9\xb7\xa6",
	"1-83-29" => "\xe9\xb7\xad",
	"1-83-30" => "\xe9\xb7\xaf",
	"1-83-31" => "\xe9\xb7\xbd",
	"1-83-32" => "\xe9\xb8\x9a",
	"1-83-33" => "\xe9\xb8\x9b",
	"1-83-34" => "\xe9\xb8\x9e",
	"1-83-35" => "\xe9\xb9\xb5",
	"1-83-36" => "\xe9\xb9\xb9",
	"1-83-37" => "\xe9\xb9\xbd",
	"1-83-38" => "\xe9\xba\x81",
	"1-83-39" => "\xe9\xba\x88",
	"1-83-40" => "\xe9\xba\x8b",
	"1-83-41" => "\xe9\xba\x8c",
	"1-83-42" => "\xe9\xba\x92",
	"1-83-43" => "\xe9\xba\x95",
	"1-83-44" => "\xe9\xba\x91",
	"1-83-45" => "\xe9\xba\x9d",
	"1-83-46" => "\xe9\xba\xa5",
	"1-83-47" => "\xe9\xba\xa9",
	"1-83-48" => "\xe9\xba\xb8",
	"1-83-49" => "\xe9\xba\xaa",
	"1-83-50" => "\xe9\xba\xad",
	"1-83-51" => "\xe9\x9d\xa1",
	"1-83-52" => "\xe9\xbb\x8c",
	"1-83-53" => "\xe9\xbb\x8e",
	"1-83-54" => "\xe9\xbb\x8f",
	"1-83-55" => "\xe9\xbb\x90",
	"1-83-56" => "\xe9\xbb\x94",
	"1-83-57" => "\xe9\xbb\x9c",
	"1-83-58" => "\xe9\xbb\x9e",
	"1-83-59" => "\xe9\xbb\x9d",
	"1-83-60" => "\xe9\xbb\xa0",
	"1-83-61" => "\xe9\xbb\xa5",
	"1-83-62" => "\xe9\xbb\xa8",
	"1-83-63" => "\xe9\xbb\xaf",
	"1-83-64" => "\xe9\xbb\xb4",
	"1-83-65" => "\xe9\xbb\xb6",
	"1-83-66" => "\xe9\xbb\xb7",
	"1-83-67" => "\xe9\xbb\xb9",
	"1-83-68" => "\xe9\xbb\xbb",
	"1-83-69" => "\xe9\xbb\xbc",
	"1-83-70" => "\xe9\xbb\xbd",
	"1-83-71" => "\xe9\xbc\x87",
	"1-83-72" => "\xe9\xbc\x88",
	"1-83-73" => "\xe7\x9a\xb7",
	"1-83-74" => "\xe9\xbc\x95",
	"1-83-75" => "\xe9\xbc\xa1",
	"1-83-76" => "\xe9\xbc\xac",
	"1-83-77" => "\xe9\xbc\xbe",
	"1-83-78" => "\xe9\xbd\x8a",
	"1-83-79" => "\xe9\xbd\x92",
	"1-83-80" => "\xe9\xbd\x94",
	"1-83-81" => "\xe9\xbd\xa3",
	"1-83-82" => "\xe9\xbd\x9f",
	"1-83-83" => "\xe9\xbd\xa0",
	"1-83-84" => "\xe9\xbd\xa1",
	"1-83-85" => "\xe9\xbd\xa6",
	"1-83-86" => "\xe9\xbd\xa7",
	"1-83-87" => "\xe9\xbd\xac",
	"1-83-88" => "\xe9\xbd\xaa",
	"1-83-89" => "\xe9\xbd\xb7",
	"1-83-90" => "\xe9\xbd\xb2",
	"1-83-91" => "\xe9\xbd\xb6",
	"1-83-92" => "\xe9\xbe\x95",
	"1-83-93" => "\xe9\xbe\x9c",
	"1-83-94" => "\xe9\xbe\xa0",
	"1-84-1" => "\xe5\xa0\xaf",
	"1-84-2" => "\xe6\xa7\x87",
	"1-84-3" => "\xe9\x81\x99",
	"1-84-4" => "\xe7\x91\xa4",
	"1-84-5" => "\xe5\x87\x9c",
	"1-84-6" => "\xe7\x86\x99",
	"1-84-7" => "\xe5\x99\x93",		# 07/07/01 fix
	"1-84-8" => "\xe5\xb7\xa2",
	"1-84-9" => "\xe5\xb8\x94",
	"1-84-10" => "\xe5\xb8\x98",
	"1-84-11" => "\xe5\xb9\x98",
	"1-84-12" => "\xe5\xb9\x9e",
	"1-84-13" => "\xe5\xba\xbe",
	"1-84-14" => "\xef\xa4\xa8",
	"1-84-15" => "\xe5\xbb\x8b",
	"1-84-16" => "\xe5\xbb\xb9",
	"1-84-17" => "\xe5\xbc\x80",
	"1-84-18" => "\xe5\xbc\x82",
	"1-84-19" => "\xe5\xbc\x87",
	"1-84-20" => "\xe5\xbc\x9d",
	"1-84-21" => "\xe5\xbc\xa3",
	"1-84-22" => "\xe5\xbc\xb4",
	"1-84-23" => "\xe5\xbc\xb6",
	"1-84-24" => "\xe5\xbc\xbd",
	"1-84-25" => "\xe5\xbd\x80",
	"1-84-26" => "\xe5\xbd\x85",
	"1-84-27" => "\xe5\xbd\x94",
	"1-84-28" => "\xe5\xbd\x98",
	"1-84-29" => "\xe5\xbd\xa4",
	"1-84-30" => "\xe5\xbd\xa7",
	"1-84-31" => "\xe5\xbd\xbd",
	"1-84-32" => "\xe5\xbe\x89",
	"1-84-33" => "\xe5\xbe\x9c",
	"1-84-34" => "\xe5\xbe\xa7",
	"1-84-35" => "\xe5\xbe\xaf",
	"1-84-36" => "\xe5\xbe\xb5",
	"1-84-37" => "\xe5\xbe\xb7",
	"1-84-38" => "\xe5\xbf\x89",
	"1-84-39" => "\xe5\xbf\x9e",
	"1-84-40" => "\xe5\xbf\xa1",
	"1-84-41" => "\xe5\xbf\xa9",
	"1-84-42" => "\xe6\x80\x8d",
	"1-84-43" => "\xe6\x80\x94",
	"1-84-44" => "\xe6\x80\x98",
	"1-84-45" => "\xe6\x80\xb3",
	"1-84-46" => "\xe6\x80\xb5",
	"1-84-47" => "\xe6\x81\x87",
	"1-84-48" => "\xe6\x82\x94",	
	"1-84-49" => "\xe6\x82\x9d",
	"1-84-50" => "\xe6\x82\x9e",
	"1-84-51" => "\xe6\x83\x8b",
	"1-84-52" => "\xe6\x83\x94",
	"1-84-53" => "\xe6\x83\x95",
	"1-84-54" => "\xe6\x83\x9d",
	"1-84-55" => "\xe6\x83\xb8",
	"1-84-56" => "\xe6\x84\x9c",
	"1-84-57" => "\xe6\x84\xab",
	"1-84-58" => "\xe6\x84\xb0",
	"1-84-59" => "\xe6\x84\xb7",
	"1-84-60" => "\xe6\x85\xa8",	
	"1-84-61" => "\xe6\x86\x8d",
	"1-84-62" => "\xe6\x86\x8e",	
	"1-84-63" => "\xe6\x86\xbc",
	"1-84-64" => "\xe6\x86\xb9",
	"1-84-65" => "\xe6\x87\xb2",	
	"1-84-66" => "\xe6\x88\xa2",
	"1-84-67" => "\xe6\x88\xbe",
	"1-84-68" => "\xe6\x89\x83",
	"1-84-69" => "\xe6\x89\x96",
	"1-84-70" => "\xe6\x89\x9a",
	"1-84-71" => "\xe6\x89\xaf",
	"1-84-72" => "\xe6\x8a\x85",
	"1-84-73" => "\xe6\x8b\x84",
	"1-84-74" => "\xe6\x8b\x96",
	"1-84-75" => "\xe6\x8b\xbc",
	"1-84-76" => "\xe6\x8c\x8a",
	"1-84-77" => "\xe6\x8c\x98",
	"1-84-78" => "\xe6\x8c\xb9",
	"1-84-79" => "\xe6\x8d\x83",
	"1-84-80" => "\xe6\x8d\xa5",
	"1-84-81" => "\xe6\x8d\xbc",
	"1-84-82" => "\xe6\x8f\xa5",
	"1-84-83" => "\xe6\x8f\xad",
	"1-84-84" => "\xe6\x8f\xb5",
	"1-84-85" => "\xe6\x90\x90",
	"1-84-86" => "\xe6\x90\x94",
	"1-84-87" => "\xe6\x90\xa2",
	"1-84-88" => "\xe6\x91\xb9",
	"1-84-89" => "\xe6\x91\x91",
	"1-84-90" => "\xe6\x91\xa0",
	"1-84-91" => "\xe6\x91\xad",
	"1-84-92" => "\xe6\x93\x8e",
	"1-84-93" => "\xe6\x92\xbe",
	"1-84-94" => "\xe6\x92\xbf",
	"1-85-1" => "\xe6\x93\x84",
	"1-85-2" => "\xe6\x93\x8a",
	"1-85-3" => "\xe6\x93\x90",
	"1-85-4" => "\xe6\x93\xb7",
	"1-85-5" => "\xe6\x93\xbb",
	"1-85-6" => "\xe6\x94\xa2",
	"1-85-7" => "\xe6\x94\xa9",
	"1-85-8" => "\xe6\x95\x8f",	
	"1-85-9" => "\xe6\x95\xa7",
	"1-85-10" => "\xe6\x96\x9d",
	"1-85-11" => "\xe6\x97\xa2",	
	"1-85-12" => "\xe6\x98\x80",
	"1-85-13" => "\xe6\x98\x89",
	"1-85-14" => "\xe6\x98\x95",
	"1-85-15" => "\xe6\x98\x9e",
	"1-85-16" => "\xe6\x98\xba",
	"1-85-17" => "\xe6\x98\xa2",
	"1-85-18" => "\xe6\x98\xa4",
	"1-85-19" => "\xe6\x98\xab",
	"1-85-20" => "\xe6\x98\xb0",
	"1-85-21" => "\xe6\x98\xb1",
	"1-85-22" => "\xe6\x98\xb3",
	"1-85-23" => "\xe6\x9b\xbb",
	"1-85-24" => "\xe6\x99\x88",
	"1-85-25" => "\xe6\x99\x8c",
	"1-85-26" => "\xf0\xa3\x87\x84",	
	"1-85-27" => "\xe6\x99\x99",
	"1-85-28" => "\xe6\x99\x9a",
	"1-85-29" => "\xe6\x99\xa1",
	"1-85-30" => "\xe6\x99\xa5",
	"1-85-31" => "\xe6\x99\xb3",
	"1-85-32" => "\xe6\x99\xb7",
	"1-85-33" => "\xe6\x99\xb8",
	"1-85-34" => "\xe6\x9a\x8d",
	"1-85-35" => "\xe6\x9a\x91",	
	"1-85-36" => "\xe6\x9a\xa0",
	"1-85-37" => "\xe6\x9a\xb2",
	"1-85-38" => "\xe6\x9a\xbb",
	"1-85-39" => "\xe6\x9b\x86",
	"1-85-40" => "\xe6\x9b\x88",
	"1-85-41" => "\xe3\xac\xa2",
	"1-85-42" => "\xe6\x9b\x9b",
	"1-85-43" => "\xe6\x9b\xa8",
	"1-85-44" => "\xe6\x9b\xba",
	"1-85-45" => "\xe6\x9c\x93",
	"1-85-46" => "\xef\xa4\xa9",
	"1-85-47" => "\xe6\x9c\xb3",
	"1-85-48" => "\xe6\x9d\xa6",
	"1-85-49" => "\xe6\x9d\x87",
	"1-85-50" => "\xe6\x9d\x88",
	"1-85-51" => "\xe6\x9d\xbb",
	"1-85-52" => "\xe6\x9e\x81",
	"1-85-53" => "\xe6\x9e\x93",
	"1-85-54" => "\xe6\x9e\x98",
	"1-85-55" => "\xe6\x9e\x9b",
	"1-85-56" => "\xe6\x9e\xbb",
	"1-85-57" => "\xe6\x9f\xb9",
	"1-85-58" => "\xe6\x9f\x80",
	"1-85-59" => "\xe6\x9f\x97",
	"1-85-60" => "\xe6\x9f\xbc",
	"1-85-61" => "\xe6\xa0\x81",
	"1-85-62" => "\xe6\xa1\x92",
	"1-85-63" => "\xe6\xa0\x9d",
	"1-85-64" => "\xe6\xa0\xac",
	"1-85-65" => "\xe6\xa0\xb1",
	"1-85-66" => "\xe6\xa1\x9b",
	"1-85-67" => "\xe6\xa1\xb2",
	"1-85-68" => "\xe6\xa1\xb5",
	"1-85-69" => "\xe6\xa2\x85",	
	"1-85-70" => "\xe6\xa2\xa3",
	"1-85-71" => "\xe6\xa2\xa5",
	"1-85-72" => "\xe6\xa2\xb2",
	"1-85-73" => "\xe6\xa3\x88",
	"1-85-74" => "\xe6\xa3\x90",
	"1-85-75" => "\xe6\xa3\xa8",
	"1-85-76" => "\xe6\xa3\xad",
	"1-85-77" => "\xe6\xa3\xb0",
	"1-85-78" => "\xe6\xa3\xb1",
	"1-85-79" => "\xe6\xa3\xbc",
	"1-85-80" => "\xe6\xa4\x8a",
	"1-85-81" => "\xe6\xa5\x89",
	"1-85-82" => "\xf0\xa3\x97\x84",	
	"1-85-83" => "\xe6\xa4\xb5",
	"1-85-84" => "\xe6\xa5\x82",
	"1-85-85" => "\xe6\xa5\x97",
	"1-85-86" => "\xe6\xa5\xa3",
	"1-85-87" => "\xe6\xa5\xa4",
	"1-85-88" => "\xe6\xa5\xa8",
	"1-85-89" => "\xe6\xa6\x80",
	"1-85-90" => "\xef\xa8\x94",
	"1-85-91" => "\xe6\xa6\xa5",
	"1-85-92" => "\xe6\xa6\xad",
	"1-85-93" => "\xe6\xa7\x8f",
	"1-85-94" => "\xe3\xae\xb6",
	"1-86-1" => "\xe3\xaf\x83",
	"1-86-2" => "\xe6\xa7\xa2",
	"1-86-3" => "\xe6\xa7\xa9",
	"1-86-4" => "\xe6\xa7\xaa",	
	"1-86-5" => "\xe6\xa7\xb5",
	"1-86-6" => "\xe6\xa7\xb6",
	"1-86-7" => "\xe6\xa8\x8f",
	"1-86-8" => "\xe6\xa8\x95",
	"1-86-9" => "\xf0\xa3\x9c\xbf",	
	"1-86-10" => "\xe6\xa8\xbb",
	"1-86-11" => "\xe6\xa8\xbe",
	"1-86-12" => "\xe6\xa9\x85",
	"1-86-13" => "\xe6\xa9\x90",
	"1-86-14" => "\xe6\xa9\x96",
	"1-86-15" => "\xe6\xa9\x9b",
	"1-86-16" => "\xe6\xa9\xab",
	"1-86-17" => "\xe6\xa9\xb3",
	"1-86-18" => "\xf0\xa3\x9d\xa3",	
	"1-86-19" => "\xe6\xaa\x89",
	"1-86-20" => "\xe6\xaa\x94",
	"1-86-21" => "\xe6\xaa\x9d",
	"1-86-22" => "\xe6\xaa\x9e",
	"1-86-23" => "\xe6\xaa\xa5",
	"1-86-24" => "\xe6\xab\xa4",
	"1-86-25" => "\xe6\xab\xa7",
	"1-86-26" => "\xe3\xb0\x8f",
	"1-86-27" => "\xef\xa4\x9d",
	"1-86-28" => "\xe6\xac\x9b",
	"1-86-29" => "\xe6\xac\x9e",
	"1-86-30" => "\xe6\xac\xac",
	"1-86-31" => "\xe6\xac\xb5",
	"1-86-32" => "\xe6\xad\x86",
	"1-86-33" => "\xe6\xad\x96",
	"1-86-34" => "\xe6\xad\xa0",
	"1-86-35" => "\xe6\xad\xa5",
	"1-86-36" => "\xe6\xad\xa7",
	"1-86-37" => "\xe6\xad\xb7",
	"1-86-38" => "\xe6\xae\x82",
	"1-86-39" => "\xe6\xae\xa9",
	"1-86-40" => "\xe6\xae\xad",
	"1-86-41" => "\xef\xa5\xb0",
	"1-86-42" => "\xe6\xaf\x8f",
	"1-86-43" => "\xe6\xaf\x96",
	"1-86-44" => "\xe6\xaf\x97",
	"1-86-45" => "\xe6\xaf\xbf",
	"1-86-46" => "\xe6\xb0\x85",
	"1-86-47" => "\xe6\xb0\x90",
	"1-86-48" => "\xe6\xb0\xb3",
	"1-86-49" => "\xe6\xb1\x99",
	"1-86-50" => "\xe6\xb1\x9c",
	"1-86-51" => "\xe6\xb2\xaa",
	"1-86-52" => "\xe6\xb1\xb4",
	"1-86-53" => "\xe6\xb1\xb6",
	"1-86-54" => "\xe6\xb2\x85",
	"1-86-55" => "\xe6\xb2\x86",
	"1-86-56" => "\xe6\xb2\x98",
	"1-86-57" => "\xe6\xb2\x9c",
	"1-86-58" => "\xe6\xb3\xbb",
	"1-86-59" => "\xe6\xb3\x86",
	"1-86-60" => "\xe6\xb3\x94",
	"1-86-61" => "\xe6\xb3\xa0",
	"1-86-62" => "\xe6\xb3\xab",
	"1-86-63" => "\xe6\xb3\xae",
	"1-86-64" => "\xf0\xa3\xb3\xbe",	
	"1-86-65" => "\xe6\xb4\x84",
	"1-86-66" => "\xe6\xb4\x8e",
	"1-86-67" => "\xe6\xb4\xae",
	"1-86-68" => "\xe6\xb4\xb1",
	"1-86-69" => "\xe6\xb4\xb9",
	"1-86-70" => "\xe6\xb4\xbf",
	"1-86-71" => "\xe6\xb5\x98",
	"1-86-72" => "\xe6\xb5\xa5",
	"1-86-73" => "\xe6\xb5\xb7",	
	"1-86-74" => "\xe6\xb6\x82",
	"1-86-75" => "\xe6\xb6\x87",
	"1-86-76" => "\xe6\xb6\x89",
	"1-86-77" => "\xe6\xb6\x94",
	"1-86-78" => "\xe6\xb6\xaa",
	"1-86-79" => "\xe6\xb6\xac",
	"1-86-80" => "\xe6\xb6\xbf",
	"1-86-81" => "\xe6\xb7\x84",
	"1-86-82" => "\xe6\xb7\x96",
	"1-86-83" => "\xe6\xb7\x9a",
	"1-86-84" => "\xe6\xb7\x9b",
	"1-86-85" => "\xe6\xb7\x9d",
	"1-86-86" => "\xe6\xb7\xbc",
	"1-86-87" => "\xe6\xb8\x9a",	
	"1-86-88" => "\xe6\xb8\xb4",
	"1-86-89" => "\xe6\xb9\x84",
	"1-86-90" => "\xe6\xb9\x9c",
	"1-86-91" => "\xe6\xb9\x9e",
	"1-86-92" => "\xe6\xba\xab",
	"1-86-93" => "\xe6\xba\xb1",
	"1-86-94" => "\xe6\xbb\x81",
	"1-87-1" => "\xe6\xbb\x87",
	"1-87-2" => "\xe6\xbb\x8e",
	"1-87-3" => "\xe6\xbc\x90",
	"1-87-4" => "\xe6\xbc\x9a",
	"1-87-5" => "\xe6\xbc\xa2",	
	"1-87-6" => "\xe6\xbc\xaa",
	"1-87-7" => "\xe6\xbc\xaf",
	"1-87-8" => "\xe6\xbc\xb3",
	"1-87-9" => "\xe6\xbd\x91",
	"1-87-10" => "\xe6\xbd\x99",
	"1-87-11" => "\xe6\xbd\x9e",
	"1-87-12" => "\xe6\xbd\xa1",
	"1-87-13" => "\xe6\xbd\xa2",
	"1-87-14" => "\xe6\xbd\xbe",
	"1-87-15" => "\xe6\xbe\x88",
	"1-87-16" => "\xe6\xbe\x8c",
	"1-87-17" => "\xe6\xbe\x8d",
	"1-87-18" => "\xe6\xbe\x94",
	"1-87-19" => "\xe6\xbe\xa0",
	"1-87-20" => "\xe6\xbe\xa7",
	"1-87-21" => "\xe6\xbe\xb6",
	"1-87-22" => "\xe6\xbe\xbc",
	"1-87-23" => "\xe6\xbf\x87",
	"1-87-24" => "\xe6\xbf\x8a",
	"1-87-25" => "\xe6\xbf\xb9",
	"1-87-26" => "\xe6\xbf\xb0",
	"1-87-27" => "\xe6\xbf\xb5",
	"1-87-28" => "\xe7\x80\x85",
	"1-87-29" => "\xe7\x80\x86",
	"1-87-30" => "\xe7\x80\xa8",
	"1-87-31" => "\xe7\x81\x8a",
	"1-87-32" => "\xe7\x81\x9d",
	"1-87-33" => "\xe7\x81\x9e",
	"1-87-34" => "\xe7\x81\x8e",
	"1-87-35" => "\xe7\x81\xa4",
	"1-87-36" => "\xe7\x81\xb5",
	"1-87-37" => "\xe7\x82\x85",
	"1-87-38" => "\xe7\x82\xa4",
	"1-87-39" => "\xe7\x82\xab",
	"1-87-40" => "\xe7\x82\xb7",
	"1-87-41" => "\xe7\x83\x94",
	"1-87-42" => "\xe7\x83\x98",
	"1-87-43" => "\xe7\x83\xa4",
	"1-87-44" => "\xe7\x84\x8f",
	"1-87-45" => "\xe7\x84\xab",
	"1-87-46" => "\xe7\x84\x9e",
	"1-87-47" => "\xe7\x84\xa0",
	"1-87-48" => "\xe7\x84\xae",
	"1-87-49" => "\xe7\x84\xb0",
	"1-87-50" => "\xe7\x85\x86",
	"1-87-51" => "\xe7\x85\x87",
	"1-87-52" => "\xe7\x85\x91",
	"1-87-53" => "\xe7\x85\xae",	
	"1-87-54" => "\xe7\x85\x92",
	"1-87-55" => "\xe7\x85\x9c",
	"1-87-56" => "\xe7\x85\xa0",
	"1-87-57" => "\xe7\x85\xa8",
	"1-87-58" => "\xef\xa8\x95",
	"1-87-59" => "\xe7\x86\x85",
	"1-87-60" => "\xe7\x86\x87",
	"1-87-61" => "\xe7\x86\x92",
	"1-87-62" => "\xe7\x87\x81",
	"1-87-63" => "\xe7\x86\xba",
	"1-87-64" => "\xe7\x87\x84",
	"1-87-65" => "\xe7\x87\xbe",
	"1-87-66" => "\xe7\x88\x80",
	"1-87-67" => "\xe7\x88\x95",
	"1-87-68" => "\xe7\x89\x95",
	"1-87-69" => "\xe7\x89\x96",
	"1-87-70" => "\xe3\xb8\xbf",
	"1-87-71" => "\xe7\x8a\x8d",
	"1-87-72" => "\xe7\x8a\x9b",
	"1-87-73" => "\xe7\x8a\xbe",
	"1-87-74" => "\xe7\x8b\x80",
	"1-87-75" => "\xe7\x8b\xbb",
	"1-87-76" => "\xf0\xa4\x9f\xb1",	
	"1-87-77" => "\xe7\x8c\xa7",
	"1-87-78" => "\xe7\x8c\xa8",
	"1-87-79" => "\xef\xa8\x96",
	"1-87-80" => "\xe7\x8d\x90",
	"1-87-81" => "\xe7\x8d\xa6",
	"1-87-82" => "\xe7\x8d\xbc",
	"1-87-83" => "\xe7\x8e\x95",
	"1-87-84" => "\xe7\x8e\x9f",
	"1-87-85" => "\xe7\x8e\xa0",
	"1-87-86" => "\xe7\x8e\xa2",
	"1-87-87" => "\xe7\x8e\xa6",
	"1-87-88" => "\xe7\x8e\xab",
	"1-87-89" => "\xe7\x8f\x89",
	"1-87-90" => "\xe7\x8f\x8f",
	"1-87-91" => "\xe7\x8f\x96",
	"1-87-92" => "\xe7\x8f\x99",
	"1-87-93" => "\xe7\x8f\xa3",
	"1-87-94" => "\xe7\x8f\xa9",
	"1-88-1" => "\xe7\x90\x87",
	"1-88-2" => "\xe7\x90\x8a",
	"1-88-3" => "\xe7\x90\x9a",
	"1-88-4" => "\xe7\x90\x9b",
	"1-88-5" => "\xe7\x90\xa2",	
	"1-88-6" => "\xe7\x90\xa6",
	"1-88-7" => "\xe7\x90\xa8",
	"1-88-8" => "\xe7\x90\xaa",
	"1-88-9" => "\xe7\x90\xab",
	"1-88-10" => "\xe7\x90\xac",
	"1-88-11" => "\xe7\x90\xae",
	"1-88-12" => "\xe7\x90\xaf",
	"1-88-13" => "\xe7\x90\xb0",
	"1-88-14" => "\xe7\x91\x84",
	"1-88-15" => "\xe7\x91\x86",
	"1-88-16" => "\xe7\x91\x87",
	"1-88-17" => "\xe7\x91\x8b",
	"1-88-18" => "\xe7\x91\x97",
	"1-88-19" => "\xe7\x91\xa2",
	"1-88-20" => "\xe7\x91\xab",
	"1-88-21" => "\xe7\x91\xad",
	"1-88-22" => "\xe7\x92\x86",
	"1-88-23" => "\xe7\x92\x87",
	"1-88-24" => "\xe7\x92\x89",
	"1-88-25" => "\xe7\x92\x98",
	"1-88-26" => "\xe7\x92\x9c",
	"1-88-27" => "\xe7\x92\x9f",
	"1-88-28" => "\xe7\x92\xa3",
	"1-88-29" => "\xe7\x92\x90",
	"1-88-30" => "\xe7\x92\xa6",
	"1-88-31" => "\xe7\x92\xa8",
	"1-88-32" => "\xe7\x92\xa9",
	"1-88-33" => "\xe7\x92\xb5",
	"1-88-34" => "\xe7\x92\xbf",
	"1-88-35" => "\xe7\x93\x88",
	"1-88-36" => "\xe7\x93\x89",
	"1-88-37" => "\xe7\x93\x9a",
	"1-88-38" => "\xe7\x93\xbf",
	"1-88-39" => "\xe7\x94\x81",
	"1-88-40" => "\xe7\x94\x97",
	"1-88-41" => "\xe7\x94\xaf",
	"1-88-42" => "\xe7\x95\xaf",
	"1-88-43" => "\xe7\x95\xb9",
	"1-88-44" => "\xe7\x96\x92",
	"1-88-45" => "\xe3\xbd\xb2",
	"1-88-46" => "\xe7\x97\x8e",
	"1-88-47" => "\xe7\x97\xa4",
	"1-88-48" => "\xe7\x98\x80",
	"1-88-49" => "\xe7\x98\x82",
	"1-88-50" => "\xe7\x98\x88",
	"1-88-51" => "\xe7\x98\x95",
	"1-88-52" => "\xe7\x98\x96",
	"1-88-53" => "\xe7\x98\x99",
	"1-88-54" => "\xe7\x98\x9e",
	"1-88-55" => "\xe7\x98\xad",
	"1-88-56" => "\xe7\x98\xb5",
	"1-88-57" => "\xe7\x99\x83",
	"1-88-58" => "\xe7\x99\x8b",
	"1-88-59" => "\xe7\x99\xa4",
	"1-88-60" => "\xe7\x99\xa5",
	"1-88-61" => "\xe7\x99\xad",
	"1-88-62" => "\xe7\x99\xaf",
	"1-88-63" => "\xe7\x99\xb1",
	"1-88-64" => "\xe7\x9a\x81",
	"1-88-65" => "\xe7\x9a\x9b",
	"1-88-66" => "\xe7\x9a\x9d",
	"1-88-67" => "\xe7\x9a\x9e",
	"1-88-68" => "\xe7\x9a\xa6",
	"1-88-69" => "\xe7\x9a\xaa",
	"1-88-70" => "\xe7\x9a\xb6",
	"1-88-71" => "\xe7\x9b\x85",
	"1-88-72" => "\xe7\x9b\x8c",
	"1-88-73" => "\xe7\x9b\x8e",
	"1-88-74" => "\xe7\x9b\x94",
	"1-88-75" => "\xe7\x9b\xa6",
	"1-88-76" => "\xe7\x9b\xb1",
	"1-88-77" => "\xe7\x9b\xbc",
	"1-88-78" => "\xe7\x9c\x8a",
	"1-88-79" => "\xe7\x9c\x99",
	"1-88-80" => "\xe7\x9c\xb4",
	"1-88-81" => "\xe7\x9c\xb6",
	"1-88-82" => "\xe7\x9d\x86",
	"1-88-83" => "\xe7\x9d\x8d",
	"1-88-84" => "\xe7\x9d\x8e",
	"1-88-85" => "\xe7\x9d\x9c",
	"1-88-86" => "\xe7\x9d\x9f",
	"1-88-87" => "\xe7\x9d\xa2",
	"1-88-88" => "\xe7\x9d\xba",
	"1-88-89" => "\xe7\x9e\x80",
	"1-88-90" => "\xe7\x9e\x94",
	"1-88-91" => "\xe7\x9e\xaa",
	"1-88-92" => "\xe7\x9f\xa0",
	"1-88-93" => "\xe7\xa0\xad",
	"1-88-94" => "\xf0\xa5\x92\x8e",	
	"1-89-1" => "\xe7\xa1\x83",
	"1-89-2" => "\xe7\xa1\x8e",
	"1-89-3" => "\xe7\xa1\x8f",
	"1-89-4" => "\xe7\xa1\x91",
	"1-89-5" => "\xe7\xa1\xa8",
	"1-89-6" => "\xe7\xa1\xae",
	"1-89-7" => "\xe7\xa2\x91",	
	"1-89-8" => "\xe7\xa2\xb0",
	"1-89-9" => "\xf0\xa5\x94\x8e",	
	"1-89-10" => "\xe7\xa2\xad",
	"1-89-11" => "\xe7\xa3\xa4",
	"1-89-12" => "\xe7\xa3\xb2",
	"1-89-13" => "\xe7\xa4\x80",
	"1-89-14" => "\xe7\xa3\xb7",
	"1-89-15" => "\xe7\xa4\x9c",
	"1-89-16" => "\xe7\xa4\xae",
	"1-89-17" => "\xe7\xa4\xb1",
	"1-89-18" => "\xe7\xa4\xb4",
	"1-89-19" => "\xe7\xa4\xbe",	
	"1-89-20" => "\xe7\xa5\x89",	
	"1-89-21" => "\xe7\xa5\x85",
	"1-89-22" => "\xe7\xa5\x86",
	"1-89-23" => "\xe7\xa5\x88",	
	"1-89-24" => "\xe7\xa5\x90",	
	"1-89-25" => "\xe7\xa5\x96",	
	"1-89-26" => "\xe7\xa5\x9c",
	"1-89-27" => "\xe7\xa5\x9d",	
	"1-89-28" => "\xef\xa8\x99",
	"1-89-29" => "\xef\xa8\x9a",
	"1-89-30" => "\xe7\xa5\xb9",
	"1-89-31" => "\xe7\xa6\x8d",	
	"1-89-32" => "\xe7\xa6\x8e",	
	"1-89-33" => "\xef\xa8\x9b",
	"1-89-34" => "\xe7\xa6\x98",
	"1-89-35" => "\xe7\xa6\xb1",
	"1-89-36" => "\xe7\xa6\xb8",
	"1-89-37" => "\xe7\xa7\x88",
	"1-89-38" => "\xe7\xa7\x8a",
	"1-89-39" => "\xf0\xa5\x9d\xb1",	
	"1-89-40" => "\xe7\xa7\x94",
	"1-89-41" => "\xe7\xa7\x9e",
	"1-89-42" => "\xe7\xa7\xab",
	"1-89-43" => "\xe7\xa7\xad",
	"1-89-44" => "\xe7\xa8\x83",
	"1-89-45" => "\xe7\xa9\x80",	
	"1-89-46" => "\xe7\xa8\xb9",
	"1-89-47" => "\xe7\xa9\x9d",
	"1-89-48" => "\xe7\xa9\xad",
	"1-89-49" => "\xe7\xaa\x81",	
	"1-89-50" => "\xe7\xaa\x85",
	"1-89-51" => "\xe7\xaa\xa0",
	"1-89-52" => "\xf0\xa5\xa7\x84",	
	"1-89-53" => "\xe7\xaa\xb3",
	"1-89-54" => "\xe7\xaa\xbb",
	"1-89-55" => "\xe7\xab\x8e",
	"1-89-56" => "\xe7\xab\xab",
	"1-89-57" => "\xe7\xab\xbd",
	"1-89-58" => "\xe7\xac\x92",
	"1-89-59" => "\xe7\xac\xad",
	"1-89-60" => "\xe7\xac\xbb",
	"1-89-61" => "\xe7\xad\x87",
	"1-89-62" => "\xe7\xad\x8e",
	"1-89-63" => "\xe7\xad\xa0",
	"1-89-64" => "\xe7\xad\xad",
	"1-89-65" => "\xe7\xad\xaf",
	"1-89-66" => "\xe7\xad\xb2",
	"1-89-67" => "\xe7\xae\x9e",
	"1-89-68" => "\xe7\xaf\x80",	
	"1-89-69" => "\xe7\xaf\x97",
	"1-89-70" => "\xe7\xaf\x99",
	"1-89-71" => "\xe7\xb0\x81",
	"1-89-72" => "\xe7\xb0\xb1",
	"1-89-73" => "\xe7\xb0\x9e",
	"1-89-74" => "\xe7\xb0\xa0",
	"1-89-75" => "\xe7\xb0\xb3",
	"1-89-76" => "\xe7\xb0\xb6",
	"1-89-77" => "\xe4\x89\xa4",
	"1-89-78" => "\xf0\xa5\xb6\xa1",	
	"1-89-79" => "\xe7\xb1\x99",
	"1-89-80" => "\xe7\xb1\xad",
	"1-89-81" => "\xe7\xb1\xb9",
	"1-89-82" => "\xe7\xb2\x8f",
	"1-89-83" => "\xe7\xb2\x94",
	"1-89-84" => "\xe7\xb2\xa0",
	"1-89-85" => "\xe7\xb2\xbc",
	"1-89-86" => "\xe7\xb3\x95",
	"1-89-87" => "\xe7\xb3\x99",
	"1-89-88" => "\xe7\xb3\x9d",
	"1-89-89" => "\xe7\xb4\x87",
	"1-89-90" => "\xe7\xb4\x88",
	"1-89-91" => "\xe7\xb4\x93",
	"1-89-92" => "\xe7\xb4\x9d",
	"1-89-93" => "\xe7\xb4\xa3",
	"1-89-94" => "\xe7\xb4\xb1",
	"1-90-1" => "\xe7\xb5\x81",
	"1-90-2" => "\xe7\xb5\x88",
	"1-90-3" => "\xe7\xb5\x93",
	"1-90-4" => "\xe7\xb5\x9c",
	"1-90-5" => "\xe7\xb5\xba",
	"1-90-6" => "\xe7\xb6\x83",
	"1-90-7" => "\xe7\xb6\x8b",
	"1-90-8" => "\xe7\xb6\xa0",
	"1-90-9" => "\xe7\xb6\xa6",
	"1-90-10" => "\xe7\xb7\x82",
	"1-90-11" => "\xe7\xb7\x8c",
	"1-90-12" => "\xe7\xb7\x96",
	"1-90-13" => "\xe7\xb7\xa3",
	"1-90-14" => "\xe7\xb7\xb4",	
	"1-90-15" => "\xe7\xb8\xa8",
	"1-90-16" => "\xe7\xb8\x88",
	"1-90-17" => "\xe7\xb8\x91",
	"1-90-18" => "\xe7\xb8\x95",
	"1-90-19" => "\xe7\xb9\x81",	
	"1-90-20" => "\xe7\xb9\x87",
	"1-90-21" => "\xe7\xb9\x92",
	"1-90-22" => "\xe7\xb9\xa1",
	"1-90-23" => "\xe7\xba\x8a",
	"1-90-24" => "\xe7\xba\x8d",
	"1-90-25" => "\xe7\xbd\x87",
	"1-90-26" => "\xe7\xbd\xb2",	
	"1-90-27" => "\xe7\xbe\x91",
	"1-90-28" => "\xe7\xbe\x97",
	"1-90-29" => "\xe7\xbe\xbf",
	"1-90-30" => "\xe7\xbf\x8e",
	"1-90-31" => "\xe7\xbf\x9b",
	"1-90-32" => "\xe7\xbf\x9f",
	"1-90-33" => "\xe7\xbf\xac",
	"1-90-34" => "\xe7\xbf\xae",
	"1-90-35" => "\xe7\xbf\xba",
	"1-90-36" => "\xe8\x80\x85",	
	"1-90-37" => "\xe8\x80\x94",
	"1-90-38" => "\xe8\x80\xa6",
	"1-90-39" => "\xe8\x80\xb5",
	"1-90-40" => "\xe8\x80\xb7",
	"1-90-41" => "\xe8\x80\xbc",
	"1-90-42" => "\xe8\x83\x8a",
	"1-90-43" => "\xe8\x83\x97",
	"1-90-44" => "\xe8\x83\xa0",
	"1-90-45" => "\xe8\x83\xb3",
	"1-90-46" => "\xe8\x84\x98",
	"1-90-47" => "\xe8\x85\x8a",
	"1-90-48" => "\xe8\x85\xa0",
	"1-90-49" => "\xe8\x85\xa7",
	"1-90-50" => "\xe8\x85\xa8",
	"1-90-51" => "\xe8\x85\xad",
	"1-90-52" => "\xe8\x86\xbb",
	"1-90-53" => "\xe8\x87\x8a",
	"1-90-54" => "\xe8\x87\x8f",
	"1-90-55" => "\xe8\x87\x97",
	"1-90-56" => "\xe8\x87\xad",	
	"1-90-57" => "\xe4\x91\x93",
	"1-90-58" => "\xe4\x91\x9b",
	"1-90-59" => "\xe8\x89\xa0",
	"1-90-60" => "\xe8\x89\xb4",
	"1-90-61" => "\xf0\xa6\xab\xbf",	
	"1-90-62" => "\xe8\x8a\x8e",
	"1-90-63" => "\xe8\x8a\xa1",
	"1-90-64" => "\xe8\x8a\xa3",
	"1-90-65" => "\xe8\x8a\xa4",
	"1-90-66" => "\xe8\x8a\xa9",
	"1-90-67" => "\xe8\x8a\xae",
	"1-90-68" => "\xe8\x8a\xb7",
	"1-90-69" => "\xe8\x8a\xbe",
	"1-90-70" => "\xe8\x8a\xbf",
	"1-90-71" => "\xe8\x8b\x86",
	"1-90-72" => "\xe8\x8b\x95",
	"1-90-73" => "\xe8\x8b\xbd",
	"1-90-74" => "\xe8\x8b\xbe",
	"1-90-75" => "\xe8\x8c\x80",
	"1-90-76" => "\xe8\x8c\x81",
	"1-90-77" => "\xe8\x8d\xa2",
	"1-90-78" => "\xe8\x8c\xa2",
	"1-90-79" => "\xe8\x8c\xad",
	"1-90-80" => "\xe8\x8c\xba",
	"1-90-81" => "\xe8\x8d\x83",
	"1-90-82" => "\xe8\x8d\x87",
	"1-90-83" => "\xe8\x8d\x91",
	"1-90-84" => "\xe8\x8d\x95",
	"1-90-85" => "\xe8\x8d\xbd",
	"1-90-86" => "\xe8\x8e\x86",
	"1-90-87" => "\xe8\x8e\x92",
	"1-90-88" => "\xe8\x8e\x98",
	"1-90-89" => "\xe8\x8e\xa7",
	"1-90-90" => "\xe8\x8e\xa9",
	"1-90-91" => "\xe8\x8e\xbf",
	"1-90-92" => "\xe8\x8f\x80",
	"1-90-93" => "\xe8\x8f\x87",
	"1-90-94" => "\xe8\x8f\x8f",
	"1-91-1" => "\xe8\x8f\x91",
	"1-91-2" => "\xe8\x8f\xa1",
	"1-91-3" => "\xe8\x8f\xaa",
	"1-91-4" => "\xe8\x90\x81",
	"1-91-5" => "\xe8\x90\x86",
	"1-91-6" => "\xe8\x90\x8a",
	"1-91-7" => "\xe8\x91\x97",	
	"1-91-8" => "\xe8\x91\x88",
	"1-91-9" => "\xe8\x91\x9f",
	"1-91-10" => "\xe8\x91\xb0",
	"1-91-11" => "\xe8\x91\xb3",
	"1-91-12" => "\xe8\x92\x85",
	"1-91-13" => "\xe8\x92\x9e",
	"1-91-14" => "\xe8\x92\xaf",
	"1-91-15" => "\xe8\x92\xb4",
	"1-91-16" => "\xe8\x92\xba",
	"1-91-17" => "\xe8\x93\x80",
	"1-91-18" => "\xe8\x93\x82",
	"1-91-19" => "\xf0\xa6\xb9\x80",	
	"1-91-20" => "\xe8\x94\xb2",
	"1-91-21" => "\xe8\x94\x9e",
	"1-91-22" => "\xe8\x94\xa3",
	"1-91-23" => "\xe8\x94\xaf",
	"1-91-24" => "\xe8\x95\x99",
	"1-91-25" => "\xe8\x95\xa4",
	"1-91-26" => "\xef\xa8\x9f",
	"1-91-27" => "\xe8\x96\xad",
	"1-91-28" => "\xe8\x95\xba",
	"1-91-29" => "\xe8\x96\x8c",
	"1-91-30" => "\xe8\x96\x8f",
	"1-91-31" => "\xe8\x96\xa2",
	"1-91-32" => "\xe8\x96\xb0",
	"1-91-33" => "\xe8\x97\x8b",
	"1-91-34" => "\xe8\x97\x8e",
	"1-91-35" => "\xe8\x97\xad",
	"1-91-36" => "\xe8\x98\x92",
	"1-91-37" => "\xe8\x97\xbf",
	"1-91-38" => "\xe8\x98\x84",
	"1-91-39" => "\xe8\x98\x85",
	"1-91-40" => "\xe8\x98\x90",
	"1-91-41" => "\xf0\xa7\x83\xb4",	
	"1-91-42" => "\xe8\x98\x98",
	"1-91-43" => "\xe8\x98\xa9",
	"1-91-44" => "\xe8\x98\xb8",
	"1-91-45" => "\xe8\x99\x97",
	"1-91-46" => "\xe8\x99\x9b",
	"1-91-47" => "\xef\xa4\xb6",
	"1-91-48" => "\xe8\x99\xa2",
	"1-91-49" => "\xe4\x96\x9d",
	"1-91-50" => "\xe8\x99\xac",
	"1-91-51" => "\xe8\x99\xb5",
	"1-91-52" => "\xe8\x9a\x98",
	"1-91-53" => "\xe8\x9a\xb8",
	"1-91-54" => "\xe8\x9b\xba",
	"1-91-55" => "\xe8\x9b\xbc",
	"1-91-56" => "\xe8\x9b\xbd",
	"1-91-57" => "\xe8\x9c\x8b",
	"1-91-58" => "\xe8\x9d\xb1",
	"1-91-59" => "\xe8\x9e\x87",
	"1-91-60" => "\xe8\x9e\x88",
	"1-91-61" => "\xe8\x9e\xac",
	"1-91-62" => "\xe8\x9e\xad",
	"1-91-63" => "\xe8\x9e\xb5",
	"1-91-64" => "\xe4\x97\xaa",
	"1-91-65" => "\xe8\x9f\x96",
	"1-91-66" => "\xe8\x9f\xac",
	"1-91-67" => "\xe8\xa0\x86",
	"1-91-68" => "\xe8\xa0\x8a",
	"1-91-69" => "\xe8\xa0\x90",
	"1-91-70" => "\xe8\xa0\x94",
	"1-91-71" => "\xe8\xa0\x9f",
	"1-91-72" => "\xe8\xa2\x98",
	"1-91-73" => "\xe8\xa2\xaa",
	"1-91-74" => "\xe8\xa3\x8a",
	"1-91-75" => "\xe8\xa3\x8e",
	"1-91-76" => "\xf0\xa7\x9a\x84",	
	"1-91-77" => "\xe8\xa3\xb5",
	"1-91-78" => "\xe8\xa4\x9c",
	"1-91-79" => "\xe8\xa4\x90",	
	"1-91-80" => "\xe8\xa4\x98",
	"1-91-81" => "\xe8\xa4\x99",
	"1-91-82" => "\xe8\xa4\x9a",
	"1-91-83" => "\xe8\xa4\xa7",
	"1-91-84" => "\xe8\xa4\xb0",
	"1-91-85" => "\xe8\xa4\xb2",
	"1-91-86" => "\xe8\xa4\xb9",
	"1-91-87" => "\xe8\xa5\x80",
	"1-91-88" => "\xe8\xa6\x94",
	"1-91-89" => "\xe8\xa6\x96",	
	"1-91-90" => "\xe8\xa7\x94",
	"1-91-91" => "\xe8\xa7\xa5",
	"1-91-92" => "\xe8\xa7\xb6",
	"1-91-93" => "\xe8\xa8\x92",
	"1-91-94" => "\xe8\xa8\x95",
	"1-92-1" => "\xe8\xa8\xa2",
	"1-92-2" => "\xe8\xa8\xb7",
	"1-92-3" => "\xe8\xa9\x87",
	"1-92-4" => "\xe8\xa9\x8e",
	"1-92-5" => "\xe8\xa9\x9d",
	"1-92-6" => "\xe8\xa9\xa1",
	"1-92-7" => "\xe8\xa9\xb5",
	"1-92-8" => "\xe8\xa9\xb9",
	"1-92-9" => "\xe8\xaa\xa7",
	"1-92-10" => "\xe8\xab\x90",
	"1-92-11" => "\xe8\xab\x9f",
	"1-92-12" => "\xe8\xab\xb4",
	"1-92-13" => "\xe8\xab\xb6",
	"1-92-14" => "\xef\xa8\xa2",
	"1-92-15" => "\xe8\xac\x81",	
	"1-92-16" => "\xe8\xac\xb9",	
	"1-92-17" => "\xe8\xad\x86",
	"1-92-18" => "\xe8\xad\x94",
	"1-92-19" => "\xe8\xad\x99",
	"1-92-20" => "\xe8\xad\xa9",
	"1-92-21" => "\xe8\xae\x9d",
	"1-92-22" => "\xe8\xb1\x89",
	"1-92-23" => "\xe8\xb1\xa8",
	"1-92-24" => "\xe8\xb3\x93",	
	"1-92-25" => "\xe8\xb3\xa1",
	"1-92-26" => "\xe8\xb3\xb4",
	"1-92-27" => "\xe8\xb3\xb8",
	"1-92-28" => "\xe8\xb3\xbe",
	"1-92-29" => "\xe8\xb4\x88",	
	"1-92-30" => "\xe8\xb4\x92",
	"1-92-31" => "\xe8\xb4\x9b",
	"1-92-32" => "\xe8\xb6\xaf",
	"1-92-33" => "\xe8\xb7\x8e",
	"1-92-34" => "\xe8\xb7\x91",
	"1-92-35" => "\xe8\xb7\x97",
	"1-92-36" => "\xe8\xb8\xa0",
	"1-92-37" => "\xe8\xb8\xa3",
	"1-92-38" => "\xe8\xb8\xbd",
	"1-92-39" => "\xe8\xb9\xb0",
	"1-92-40" => "\xe8\xb9\xbb",
	"1-92-41" => "\xf0\xa8\x89\xb7",	
	"1-92-42" => "\xe8\xbb\x80",
	"1-92-43" => "\xe4\xa1\x84",
	"1-92-44" => "\xe8\xbb\xba",
	"1-92-45" => "\xe8\xbc\x9e",
	"1-92-46" => "\xe8\xbc\xad",
	"1-92-47" => "\xe8\xbc\xb6",
	"1-92-48" => "\xe8\xbd\x94",
	"1-92-49" => "\xf0\xa8\x8f\x8d",	
	"1-92-50" => "\xe8\xbe\xa6",
	"1-92-51" => "\xe8\xbe\xb5",
	"1-92-52" => "\xe8\xbf\xa4",
	"1-92-53" => "\xe8\xbf\xa8",
	"1-92-54" => "\xe8\xbf\xae",
	"1-92-55" => "\xe9\x80\x88",
	"1-92-56" => "\xe9\x80\xad",
	"1-92-57" => "\xe9\x80\xb8",	
	"1-92-58" => "\xe9\x82\x88",
	"1-92-59" => "\xe9\x82\x95",
	"1-92-60" => "\xe9\x82\x97",
	"1-92-61" => "\xe9\x82\x99",
	"1-92-62" => "\xe9\x82\x9b",
	"1-92-63" => "\xe9\x82\xa2",
	"1-92-64" => "\xe9\x82\xb3",
	"1-92-65" => "\xe9\x82\xbe",
	"1-92-66" => "\xe9\x83\x84",
	"1-92-67" => "\xe9\x83\x85",
	"1-92-68" => "\xe9\x83\x87",
	"1-92-69" => "\xe9\x83\x97",
	"1-92-70" => "\xe9\x83\x9d",
	"1-92-71" => "\xe9\x83\x9e",
	"1-92-72" => "\xe9\x83\xaf",
	"1-92-73" => "\xe9\x83\xb4",
	"1-92-74" => "\xef\xa8\xa6",
	"1-92-75" => "\xe9\x84\x94",
	"1-92-76" => "\xe9\x84\x95",
	"1-92-77" => "\xe9\x84\x96",
	"1-92-78" => "\xe9\x84\xa2",
	"1-92-79" => "\xe9\x84\xa3",
	"1-92-80" => "\xe9\x84\xa7",
	"1-92-81" => "\xe9\x84\xaf",
	"1-92-82" => "\xe9\x84\xb1",
	"1-92-83" => "\xe9\x84\xb4",
	"1-92-84" => "\xe9\x84\xbd",
	"1-92-85" => "\xe9\x85\x88",
	"1-92-86" => "\xe9\x85\x9b",
	"1-92-87" => "\xe9\x86\x83",
	"1-92-88" => "\xe9\x86\x9e",
	"1-92-89" => "\xe9\x86\xac",
	"1-92-90" => "\xe9\x86\xb1",
	"1-92-91" => "\xe9\x86\xbc",
	"1-92-92" => "\xe9\x87\x97",
	"1-92-93" => "\xe9\x87\xbb",
	"1-92-94" => "\xe9\x87\xa4",
	"1-93-1" => "\xe9\x87\xa5",
	"1-93-2" => "\xe9\x87\xad",
	"1-93-3" => "\xe9\x87\xb1",
	"1-93-4" => "\xe9\x88\x87",
	"1-93-5" => "\xe9\x88\x90",
	"1-93-6" => "\xe9\x88\xb8",
	"1-93-7" => "\xe9\x88\xb9",
	"1-93-8" => "\xe9\x88\xba",
	"1-93-9" => "\xe9\x88\xbc",
	"1-93-10" => "\xe9\x89\x80",
	"1-93-11" => "\xe9\x89\x83",
	"1-93-12" => "\xe9\x89\x8f",
	"1-93-13" => "\xe9\x89\xb8",
	"1-93-14" => "\xe9\x8a\x88",
	"1-93-15" => "\xe9\x8b\x82",
	"1-93-16" => "\xe9\x8b\x8b",
	"1-93-17" => "\xe9\x8b\x8c",
	"1-93-18" => "\xe9\x8b\x93",
	"1-93-19" => "\xe9\x8b\xa0",
	"1-93-20" => "\xe9\x8b\xbf",
	"1-93-21" => "\xe9\x8c\x84",
	"1-93-22" => "\xe9\x8c\x9f",
	"1-93-23" => "\xe9\x8c\xa1",
	"1-93-24" => "\xe9\x8c\xa5",
	"1-93-25" => "\xe9\x8d\x88",
	"1-93-26" => "\xe9\x8d\x89",
	"1-93-27" => "\xe9\x8d\x8a",
	"1-93-28" => "\xe9\x8d\xa4",
	"1-93-29" => "\xe9\x8d\xa5",
	"1-93-30" => "\xe9\x8d\xaa",
	"1-93-31" => "\xe9\x8d\xb0",
	"1-93-32" => "\xe9\x8e\x9b",
	"1-93-33" => "\xe9\x8e\xa3",
	"1-93-34" => "\xe9\x8e\xba",
	"1-93-35" => "\xe9\x8f\x86",
	"1-93-36" => "\xe9\x8f\x9e",
	"1-93-37" => "\xe9\x8f\x9f",
	"1-93-38" => "\xe9\x90\x84",
	"1-93-39" => "\xe9\x8f\xbd",
	"1-93-40" => "\xe9\x90\xb3",
	"1-93-41" => "\xe9\x91\x8a",
	"1-93-42" => "\xe9\x91\xa3",
	"1-93-43" => "\xe9\x91\xab",
	"1-93-44" => "\xe9\x91\xb1",
	"1-93-45" => "\xe9\x91\xb2",
	"1-93-46" => "\xe9\x96\x8e",
	"1-93-47" => "\xe9\x96\x9f",
	"1-93-48" => "\xe9\x96\xa6",
	"1-93-49" => "\xe9\x96\xa9",
	"1-93-50" => "\xe9\x96\xac",
	"1-93-51" => "\xe9\x96\xb6",
	"1-93-52" => "\xe9\x96\xbd",
	"1-93-53" => "\xe9\x97\x8b",
	"1-93-54" => "\xe9\x97\x90",
	"1-93-55" => "\xe9\x97\x93",
	"1-93-56" => "\xe4\xa6\xb0",
	"1-93-57" => "\xe9\x97\x9a",
	"1-93-58" => "\xe9\x97\x9e",
	"1-93-59" => "\xe9\x99\x98",
	"1-93-60" => "\xe9\x9a\x84",
	"1-93-61" => "\xef\xa7\x9c",
	"1-93-62" => "\xe9\x9a\x9d",
	"1-93-63" => "\xe9\x9a\xa4",
	"1-93-64" => "\xe9\x9a\xa5",
	"1-93-65" => "\xe9\x9b\x92",
	"1-93-66" => "\xe9\x9b\x9e",
	"1-93-67" => "\xe9\x9b\xa3",	
	"1-93-68" => "\xe9\x9b\xa9",
	"1-93-69" => "\xe9\x9b\xaf",
	"1-93-70" => "\xe9\x9c\xb3",
	"1-93-71" => "\xe9\x9c\xbb",
	"1-93-72" => "\xe9\x9d\x8d",
	"1-93-73" => "\xe9\x9d\x8e",
	"1-93-74" => "\xe9\x9d\x8f",
	"1-93-75" => "\xe9\x9d\x9a",
	"1-93-76" => "\xe9\x9d\xae",
	"1-93-77" => "\xe9\x9d\xb3",
	"1-93-78" => "\xe9\x9e\x95",
	"1-93-79" => "\xe9\x9e\xae",
	"1-93-80" => "\xe9\x9e\xba",
	"1-93-81" => "\xe9\x9f\x81",
	"1-93-82" => "\xe9\x9f\x89",
	"1-93-83" => "\xe9\x9f\x9e",
	"1-93-84" => "\xe9\x9f\x9b",
	"1-93-85" => "\xe9\x9f\xb4",
	"1-93-86" => "\xe9\x9f\xbf",	
	"1-93-87" => "\xe9\xa0\x8a",
	"1-93-88" => "\xe9\xa0\x9e",
	"1-93-89" => "\xe9\xa0\xab",
	"1-93-90" => "\xe9\xa0\xb0",
	"1-93-91" => "\xe9\xa0\xbb",	
	"1-93-92" => "\xe9\xa1\x92",
	"1-93-93" => "\xe9\xa1\x93",
	"1-93-94" => "\xe9\xa1\x96",
	"1-94-1" => "\xe9\xa1\x97",
	"1-94-2" => "\xe9\xa1\x99",
	"1-94-3" => "\xe9\xa1\x9a",
	"1-94-4" => "\xef\xa7\x90",
	"1-94-5" => "\xe9\xa1\xa5",
	"1-94-6" => "\xe9\xa1\xac",
	"1-94-7" => "\xe9\xa2\xba",
	"1-94-8" => "\xe9\xa3\x88",
	"1-94-9" => "\xe9\xa3\xa7",
	"1-94-10" => "\xe9\xa5\x98",
	"1-94-11" => "\xe9\xa6\x9e",
	"1-94-12" => "\xe9\xa8\x82",
	"1-94-13" => "\xe9\xa8\x83",
	"1-94-14" => "\xe9\xa8\xa4",
	"1-94-15" => "\xe9\xa8\xad",
	"1-94-16" => "\xe9\xa8\xae",
	"1-94-17" => "\xe9\xa8\xb8",
	"1-94-18" => "\xe9\xa9\x8a",
	"1-94-19" => "\xe9\xa9\x8e",
	"1-94-20" => "\xe9\xa9\x92",
	"1-94-21" => "\xe9\xaa\xb6",
	"1-94-22" => "\xe9\xab\x81",
	"1-94-23" => "\xe9\xab\x83",
	"1-94-24" => "\xe9\xab\x8e",
	"1-94-25" => "\xe9\xab\x96",
	"1-94-26" => "\xe9\xab\xb9",
	"1-94-27" => "\xe9\xac\x82",
	"1-94-28" => "\xe9\xac\x88",
	"1-94-29" => "\xe9\xac\xa0",
	"1-94-30" => "\xe4\xb0\x97",
	"1-94-31" => "\xe9\xac\xad",	
	"1-94-32" => "\xe9\xad\x9e",
	"1-94-33" => "\xe9\xad\xb9",
	"1-94-34" => "\xe9\xad\xa6",
	"1-94-35" => "\xe9\xad\xb2",
	"1-94-36" => "\xe9\xad\xb5",
	"1-94-37" => "\xe9\xae\x84",
	"1-94-38" => "\xe9\xae\x8a",
	"1-94-39" => "\xe9\xae\x8f",
	"1-94-40" => "\xe9\xae\x9e",
	"1-94-41" => "\xe9\xae\xa7",
	"1-94-42" => "\xe9\xaf\x81",
	"1-94-43" => "\xe9\xaf\x8e",
	"1-94-44" => "\xe9\xaf\xa5",
	"1-94-45" => "\xe9\xaf\xb8",
	"1-94-46" => "\xe9\xaf\xbd",
	"1-94-47" => "\xe9\xb0\x80",
	"1-94-48" => "\xe9\xb0\xa3",
	"1-94-49" => "\xe9\xb1\x81",
	"1-94-50" => "\xe9\xb1\x8f",
	"1-94-51" => "\xe9\xb1\x90",
	"1-94-52" => "\xe9\xb1\x93",
	"1-94-53" => "\xe9\xb1\xa3",
	"1-94-54" => "\xe9\xb1\xa5",
	"1-94-55" => "\xe9\xb1\xb7",
	"1-94-56" => "\xe9\xb4\x9d",
	"1-94-57" => "\xe9\xb4\x9e",
	"1-94-58" => "\xe9\xb5\x83",
	"1-94-59" => "\xe9\xb5\x87",
	"1-94-60" => "\xe9\xb5\x92",
	"1-94-61" => "\xe9\xb5\xa3",
	"1-94-62" => "\xe9\xb5\xb0",
	"1-94-63" => "\xe9\xb5\xbc",
	"1-94-64" => "\xe9\xb6\x8a",
	"1-94-65" => "\xe9\xb6\x96",
	"1-94-66" => "\xe9\xb7\x80",
	"1-94-67" => "\xe9\xb6\xac",
	"1-94-68" => "\xe9\xb6\xbc",
	"1-94-69" => "\xe9\xb7\x97",
	"1-94-70" => "\xf0\xaa\x86\x90",	
	"1-94-71" => "\xe9\xb7\xa7",
	"1-94-72" => "\xe9\xb8\x87",
	"1-94-73" => "\xe9\xb8\x95",
	"1-94-74" => "\xe9\xb9\xbc",
	"1-94-75" => "\xe9\xba\x9e",
	"1-94-76" => "\xe9\xba\xa4",
	"1-94-77" => "\xe9\xba\xac",
	"1-94-78" => "\xe9\xba\xaf",
	"1-94-79" => "\xe9\xba\xb4",
	"1-94-80" => "\xe9\xba\xb5",
	"1-94-81" => "\xe9\xbb\x83",
	"1-94-82" => "\xe9\xbb\x91",
	"1-94-83" => "\xe9\xbc\x90",
	"1-94-84" => "\xe9\xbc\xb9",
	"1-94-85" => "\xe9\xbd\x97",
	"1-94-86" => "\xe9\xbe\x90",
	"1-94-87" => "\xe9\xbe\x94",
	"1-94-88" => "\xe9\xbe\x97",
	"1-94-89" => "\xe9\xbe\xa2",
	"1-94-90" => "\xe5\xa7\xb8",	# 07/07/01 fix
	"1-94-91" => "\xe5\xb1\x9b",	# 07/07/01 fix
	"1-94-92" => "\xe5\xb9\xb7",	# 07/07/01 fix
	"1-94-93" => "\xe7\x98\xa6",	# 07/07/01 fix
	"1-94-94" => "\xe7\xb9\xab",	# 07/07/01 fix
	"2-1-1" => "\xf0\xa0\x82\x89",	
	"2-1-2" => "\xe4\xb8\x82",
	"2-1-3" => "\xe4\xb8\x8f",
	"2-1-4" => "\xe4\xb8\x92",
	"2-1-5" => "\xe4\xb8\xa9",
	"2-1-6" => "\xe4\xb8\xab",
	"2-1-7" => "\xe4\xb8\xae",
	"2-1-8" => "\xe4\xb9\x80",
	"2-1-9" => "\xe4\xb9\x87",
	"2-1-10" => "\xe4\xb9\x88",
	"2-1-11" => "\xf0\xa0\x82\xa2",	
	"2-1-12" => "\xe4\xb9\x91",
	"2-1-13" => "\xe3\x90\x86",
	"2-1-14" => "\xf0\xa0\x82\xa4",	
	"2-1-15" => "\xe4\xb9\x9a",
	"2-1-16" => "\xe4\xb9\xa9",
	"2-1-17" => "\xe4\xba\x9d",
	"2-1-18" => "\xe3\x90\xac",
	"2-1-19" => "\xe3\x90\xae",
	"2-1-20" => "\xe4\xba\xb9",
	"2-1-21" => "\xe4\xba\xbb",
	"2-1-22" => "\xf0\xa0\x86\xa2",	
	"2-1-23" => "\xe4\xba\xbc",
	"2-1-24" => "\xe4\xbb\x83",
	"2-1-25" => "\xe4\xbb\x88",
	"2-1-26" => "\xe4\xbb\x90",
	"2-1-27" => "\xe4\xbb\xab",
	"2-1-28" => "\xe4\xbb\x9a",
	"2-1-29" => "\xe4\xbb\xb1",
	"2-1-30" => "\xe4\xbb\xb5",
	"2-1-31" => "\xe4\xbc\x80",
	"2-1-32" => "\xe4\xbc\x96",
	"2-1-33" => "\xe4\xbd\xa4",
	"2-1-34" => "\xe4\xbc\xb7",
	"2-1-35" => "\xe4\xbc\xbe",
	"2-1-36" => "\xe4\xbd\x94",
	"2-1-37" => "\xe4\xbd\x98",
	"2-1-38" => "\xf0\xa0\x88\x93",	
	"2-1-39" => "\xe4\xbd\xb7",
	"2-1-40" => "\xe4\xbd\xb8",
	"2-1-41" => "\xe4\xbd\xba",
	"2-1-42" => "\xe4\xbd\xbd",
	"2-1-43" => "\xe4\xbe\x82",
	"2-1-44" => "\xe4\xbe\x85",
	"2-1-45" => "\xe4\xbe\x92",
	"2-1-46" => "\xe4\xbe\x9a",
	"2-1-47" => "\xe4\xbf\xa6",
	"2-1-48" => "\xe4\xbe\xb2",
	"2-1-49" => "\xe4\xbe\xbe",
	"2-1-50" => "\xe4\xbf\x85",
	"2-1-51" => "\xe4\xbf\x8b",
	"2-1-52" => "\xe4\xbf\x8f",
	"2-1-53" => "\xe4\xbf\x92",
	"2-1-54" => "\xe3\x91\xaa",
	"2-1-55" => "\xe4\xbf\xb2",
	"2-1-56" => "\xe5\x80\x80",
	"2-1-57" => "\xe5\x80\x90",
	"2-1-58" => "\xe5\x80\x93",
	"2-1-59" => "\xe5\x80\x9c",
	"2-1-60" => "\xe5\x80\x9e",
	"2-1-61" => "\xe5\x80\xa2",
	"2-1-62" => "\xe3\x91\xa8",
	"2-1-63" => "\xe5\x81\x82",
	"2-1-64" => "\xe5\x81\x86",
	"2-1-65" => "\xe5\x81\x8e",
	"2-1-66" => "\xe5\x81\x93",
	"2-1-67" => "\xe5\x81\x97",
	"2-1-68" => "\xe5\x81\xa3",
	"2-1-69" => "\xe5\x81\xa6",
	"2-1-70" => "\xe5\x81\xaa",
	"2-1-71" => "\xe5\x81\xb0",
	"2-1-72" => "\xe5\x82\xa3",
	"2-1-73" => "\xe5\x82\x88",
	"2-1-74" => "\xe5\x82\x92",
	"2-1-75" => "\xe5\x82\x93",
	"2-1-76" => "\xe5\x82\x95",
	"2-1-77" => "\xe5\x82\x96",
	"2-1-78" => "\xe5\x82\x9c",
	"2-1-79" => "\xe5\x82\xaa",
	"2-1-80" => "\xf0\xa0\x8c\xab",	
	"2-1-81" => "\xe5\x82\xb1",
	"2-1-82" => "\xe5\x82\xba",
	"2-1-83" => "\xe5\x82\xbb",
	"2-1-84" => "\xe5\x83\x84",
	"2-1-85" => "\xe5\x83\x87",
	"2-1-86" => "\xe5\x83\xb3",
	"2-1-87" => "\xf0\xa0\x8e\x81",	
	"2-1-88" => "\xe5\x83\x8e",
	"2-1-89" => "\xf0\xa0\x8d\xb1",	
	"2-1-90" => "\xe5\x83\x94",
	"2-1-91" => "\xe5\x83\x99",
	"2-1-92" => "\xe5\x83\xa1",
	"2-1-93" => "\xe5\x83\xa9",
	"2-1-94" => "\xe3\x92\x92",
	"2-3-1" => "\xe5\x84\x88",
	"2-3-2" => "\xf0\xa0\x8f\xb9",	
	"2-3-3" => "\xe5\x84\x97",
	"2-3-4" => "\xe5\x84\x9b",
	"2-3-5" => "\xf0\xa0\x91\x8a",	
	"2-3-6" => "\xe5\x85\xa0",
	"2-3-7" => "\xf0\xa0\x94\x89",	
	"2-3-8" => "\xe5\x85\xb3",
	"2-3-9" => "\xe5\x86\x83",
	"2-3-10" => "\xe5\x86\x8b",
	"2-3-11" => "\xe3\x92\xbc",
	"2-3-12" => "\xe5\x86\x98",
	"2-3-13" => "\xe5\x86\xa3",
	"2-3-14" => "\xe5\x86\xad",
	"2-3-15" => "\xe3\x93\x87",
	"2-3-16" => "\xe5\x86\xbc",
	"2-3-17" => "\xf0\xa0\x97\x96",	
	"2-3-18" => "\xf0\xa0\x98\xa8",	
	"2-3-19" => "\xe5\x87\xb3",
	"2-3-20" => "\xe5\x87\xb4",
	"2-3-21" => "\xe5\x88\x82",
	"2-3-22" => "\xe5\x88\x92",
	"2-3-23" => "\xe5\x88\x96",
	"2-3-24" => "\xf0\xa0\x9d\x8f",	
	"2-3-25" => "\xe5\x89\x95",
	"2-3-26" => "\xe5\x89\x9c",
	"2-3-27" => "\xe5\x89\xac",
	"2-3-28" => "\xe5\x89\xb7",
	"2-3-29" => "\xe5\x8a\x84",
	"2-3-30" => "\xe5\x8a\x82",
	"2-3-31" => "\xf0\xa0\xa0\x87",	
	"2-3-32" => "\xe5\x8a\x98",
	"2-3-33" => "\xf0\xa0\xa0\xba",	
	"2-3-34" => "\xe5\x8a\xa4",
	"2-3-35" => "\xe5\x8a\xa6",
	"2-3-36" => "\xe5\x8a\xaf",
	"2-3-37" => "\xe5\x8a\xba",
	"2-3-38" => "\xe5\x8a\xbb",
	"2-3-39" => "\xe5\x8b\x8a",
	"2-3-40" => "\xe3\x94\x9f",
	"2-3-41" => "\xe5\x8b\x91",
	"2-3-42" => "\xf0\xa0\xa2\xb9",	
	"2-3-43" => "\xe5\x8b\xb7",
	"2-3-44" => "\xe5\x8c\x8a",
	"2-3-45" => "\xe5\x8c\x8b",
	"2-3-46" => "\xe5\x8c\xa4",
	"2-3-47" => "\xe5\x8c\xb5",
	"2-3-48" => "\xe5\x8c\xbe",
	"2-3-49" => "\xe5\x8d\x82",
	"2-3-50" => "\xf0\xa0\xa5\xbc",	
	"2-3-51" => "\xf0\xa0\xa6\x9d",	
	"2-3-52" => "\xe5\x8d\xa7",
	"2-3-53" => "\xe5\x8d\xac",
	"2-3-54" => "\xe5\x8d\xba",
	"2-3-55" => "\xe5\x8e\xa4",
	"2-3-56" => "\xe5\x8e\xb4",
	"2-3-57" => "\xf0\xa0\xab\x93",	
	"2-3-58" => "\xe5\x8e\xb7",
	"2-3-59" => "\xe5\x8f\x80",
	"2-3-60" => "\xf0\xa0\xac\x9d",	
	"2-3-61" => "\xe3\x95\x9d",
	"2-3-62" => "\xe3\x95\x9e",
	"2-3-63" => "\xe5\x8f\x95",
	"2-3-64" => "\xe5\x8f\x9a",
	"2-3-65" => "\xe3\x95\xa3",
	"2-3-66" => "\xe5\x8f\xb4",
	"2-3-67" => "\xe5\x8f\xb5",
	"2-3-68" => "\xe5\x91\x95",
	"2-3-69" => "\xe5\x90\xa4",
	"2-3-70" => "\xe5\x90\xa8",
	"2-3-71" => "\xe3\x95\xae",
	"2-3-72" => "\xe5\x91\x83",
	"2-3-73" => "\xe5\x91\xa2",
	"2-3-74" => "\xe5\x91\xa6",
	"2-3-75" => "\xe5\x91\xac",
	"2-3-76" => "\xe5\x92\x8a",
	"2-3-77" => "\xe5\x92\x8d",
	"2-3-78" => "\xe5\x92\x95",
	"2-3-79" => "\xe5\x92\xa0",
	"2-3-80" => "\xe5\x92\xa6",
	"2-3-81" => "\xe5\x92\xad",
	"2-3-82" => "\xe5\x92\xae",
	"2-3-83" => "\xe5\x92\xb7",
	"2-3-84" => "\xe5\x92\xba",
	"2-3-85" => "\xe5\x92\xbf",
	"2-3-86" => "\xe5\x93\x83",
	"2-3-87" => "\xf0\xa0\xb5\x85",	
	"2-3-88" => "\xe5\x93\xac",
	"2-3-89" => "\xe5\x93\xaf",
	"2-3-90" => "\xe5\x93\xb1",
	"2-3-91" => "\xe5\x93\xb3",
	"2-3-92" => "\xe5\x94\x80",
	"2-3-93" => "\xe5\x94\x81",
	"2-3-94" => "\xe5\x94\x89",
	"2-4-1" => "\xe5\x94\xbc",
	"2-4-2" => "\xe5\x95\x81",
	"2-4-3" => "\xe3\x96\xa6",
	"2-4-4" => "\xe5\x95\x87",
	"2-4-5" => "\xe5\x95\x8a",
	"2-4-6" => "\xe3\x96\xa8",
	"2-4-7" => "\xe5\x95\xa0",
	"2-4-8" => "\xe5\x95\xa1",
	"2-4-9" => "\xe5\x95\xa4",
	"2-4-10" => "\xf0\xa0\xb7\xa1",	
	"2-4-11" => "\xe5\x95\xbd",
	"2-4-12" => "\xe5\x96\x82",
	"2-4-13" => "\xe5\x96\x88",
	"2-4-14" => "\xe5\x96\x91",
	"2-4-15" => "\xe3\x97\x85",
	"2-4-16" => "\xe5\x97\x92",
	"2-4-17" => "\xf0\xa0\xba\x95",	
	"2-4-18" => "\xf0\xa0\xb9\xad",	
	"2-4-19" => "\xe5\x96\xbf",
	"2-4-20" => "\xe5\x97\x89",
	"2-4-21" => "\xe5\x97\x8c",
	"2-4-22" => "\xe5\x97\x91",
	"2-4-23" => "\xe5\x97\x9d",
	"2-4-24" => "\xe3\x97\x9a",
	"2-4-25" => "\xe5\x97\xa2",
	"2-4-26" => "\xf0\xa0\xb9\xa4",	
	"2-4-27" => "\xe5\x97\xa9",
	"2-4-28" => "\xe5\x98\xa8",
	"2-4-29" => "\xf0\xa0\xbd\x9f",	
	"2-4-30" => "\xe5\x98\x87",
	"2-4-31" => "\xe5\x98\x90",
	"2-4-32" => "\xe5\x98\xb0",
	"2-4-33" => "\xe5\x98\xb7",
	"2-4-34" => "\xe3\x97\xb4",
	"2-4-35" => "\xe5\x98\xbd",
	"2-4-36" => "\xe5\x98\xbf",
	"2-4-37" => "\xe5\x99\x80",
	"2-4-38" => "\xe5\x99\x87",
	"2-4-39" => "\xe5\x99\x9e",
	"2-4-40" => "\xe5\x99\xa0",
	"2-4-41" => "\xe5\x99\xad",
	"2-4-42" => "\xe3\x98\x85",
	"2-4-43" => "\xe5\x9a\x88",
	"2-4-44" => "\xe5\x9a\x8c",
	"2-4-45" => "\xe5\x9a\x95",
	"2-4-46" => "\xe5\x9a\x9a",
	"2-4-47" => "\xe5\x9a\x9d",
	"2-4-48" => "\xe5\x9a\xa8",
	"2-4-49" => "\xe5\x9a\xad",
	"2-4-50" => "\xe5\x9a\xb2",
	"2-4-51" => "\xe5\x9b\x85",
	"2-4-52" => "\xe5\x9b\x8d",
	"2-4-53" => "\xe5\x9b\x9f",
	"2-4-54" => "\xe5\x9b\xa8",
	"2-4-55" => "\xe5\x9b\xb6",
	"2-4-56" => "\xe5\x9b\xb7",
	"2-4-57" => "\xf0\xa1\x88\x81",	
	"2-4-58" => "\xe5\x9c\x95",
	"2-4-59" => "\xe5\x9c\xa3",
	"2-4-60" => "\xf0\xa1\x89\x95",	
	"2-4-61" => "\xe5\x9c\xa9",
	"2-4-62" => "\xf0\xa1\x89\xbb",	
	"2-4-63" => "\xe5\x9d\x85",
	"2-4-64" => "\xe5\x9d\x86",
	"2-4-65" => "\xe5\x9d\x8c",
	"2-4-66" => "\xe5\x9d\x8d",
	"2-4-67" => "\xf0\xa1\x89\xb4",	
	"2-4-68" => "\xe5\x9d\xa8",
	"2-4-69" => "\xe5\x9d\xaf",
	"2-4-70" => "\xe5\x9d\xb3",
	"2-4-71" => "\xe5\x9d\xb4",
	"2-4-72" => "\xe5\x9d\xb5",
	"2-4-73" => "\xe5\x9d\xbb",
	"2-4-74" => "\xf0\xa1\x8b\xa4",	
	"2-4-75" => "\xf0\xa1\x8b\x97",	
	"2-4-76" => "\xe5\x9e\xac",
	"2-4-77" => "\xe5\x9e\x9a",
	"2-4-78" => "\xe5\x9e\x9d",
	"2-4-79" => "\xe5\x9e\x9e",
	"2-4-80" => "\xe5\x9e\xa8",
	"2-4-81" => "\xe5\x9f\x97",
	"2-4-82" => "\xf0\xa1\x8b\xbd",	
	"2-4-83" => "\xe5\x9f\x8c",
	"2-4-84" => "\xf0\xa1\x8c\xb6",	
	"2-4-85" => "\xf0\xa1\x8d\x84",	
	"2-4-86" => "\xe5\x9f\x9e",
	"2-4-87" => "\xe5\x9f\xa6",
	"2-4-88" => "\xe5\x9f\xb0",
	"2-4-89" => "\xe3\x99\x8a",
	"2-4-90" => "\xe5\x9f\xb8",
	"2-4-91" => "\xe5\x9f\xbb",
	"2-4-92" => "\xe5\x9f\xbd",
	"2-4-93" => "\xe5\xa0\x84",
	"2-4-94" => "\xe5\xa0\x9e",
	"2-5-1" => "\xe5\xa0\xa0",
	"2-5-2" => "\xe5\xa0\xa7",
	"2-5-3" => "\xe5\xa0\xb2",
	"2-5-4" => "\xe5\xa0\xb9",
	"2-5-5" => "\xf0\xa1\x8f\x84",	
	"2-5-6" => "\xe5\xa1\x89",
	"2-5-7" => "\xe5\xa1\x8c",
	"2-5-8" => "\xe5\xa1\xa7",
	"2-5-9" => "\xe5\xa2\x8a",
	"2-5-10" => "\xe5\xa2\x8b",
	"2-5-11" => "\xe5\xa2\x8d",
	"2-5-12" => "\xe5\xa2\x8f",
	"2-5-13" => "\xe5\xa2\x90",
	"2-5-14" => "\xe5\xa2\x94",
	"2-5-15" => "\xe5\xa2\x9d",
	"2-5-16" => "\xe5\xa2\xaa",
	"2-5-17" => "\xe5\xa2\xb1",
	"2-5-18" => "\xf0\xa1\x91\xad",	
	"2-5-19" => "\xe5\xa3\x83",
	"2-5-20" => "\xe5\xa3\x8d",
	"2-5-21" => "\xe5\xa3\xa2",
	"2-5-22" => "\xe5\xa3\xb3",
	"2-5-23" => "\xe5\xa3\xb4",
	"2-5-24" => "\xe5\xa4\x85",
	"2-5-25" => "\xe5\xa4\x86",
	"2-5-26" => "\xe5\xa4\x8b",
	"2-5-27" => "\xe5\xa4\x8d",
	"2-5-28" => "\xe5\xa4\x94",
	"2-5-29" => "\xe5\xa4\xa4",
	"2-5-30" => "\xf0\xa1\x97\x97",	
	"2-5-31" => "\xe3\x9a\x91",
	"2-5-32" => "\xe5\xa4\xbd",
	"2-5-33" => "\xe3\x9a\x99",
	"2-5-34" => "\xe5\xa5\x86",
	"2-5-35" => "\xe3\x9a\x96",
	"2-5-36" => "\xf0\xa6\xb0\xa9",	
	"2-5-37" => "\xe5\xa5\x9b",
	"2-5-38" => "\xe5\xa5\x9f",
	"2-5-39" => "\xf0\xa1\x99\x87",	
	"2-5-40" => "\xe5\xa5\xb5",
	"2-5-41" => "\xe5\xa5\xb6",
	"2-5-42" => "\xe5\xa5\xbc",
	"2-5-43" => "\xe5\xa6\x9f",
	"2-5-44" => "\xe5\xa6\xae",
	"2-5-45" => "\xe5\xa6\xbc",
	"2-5-46" => "\xe5\xa7\x88",
	"2-5-47" => "\xe5\xa7\x8d",
	"2-5-48" => "\xe5\xa7\x9e",
	"2-5-49" => "\xe5\xa7\xa3",
	"2-5-50" => "\xe5\xa7\xa4",
	"2-5-51" => "\xe5\xa7\xa7",
	"2-5-52" => "\xe5\xa7\xae",
	"2-5-53" => "\xf0\xa1\x9c\x86",	
	"2-5-54" => "\xf0\xa1\x9d\x82",	
	"2-5-55" => "\xe3\x9b\x8f",
	"2-5-56" => "\xe5\xa8\x8c",
	"2-5-57" => "\xe5\xa8\x8d",
	"2-5-58" => "\xe5\xa8\x97",
	"2-5-59" => "\xe5\xa8\xa7",
	"2-5-60" => "\xe5\xa8\xad",
	"2-5-61" => "\xe5\xa9\x95",
	"2-5-62" => "\xe5\xa9\xa5",
	"2-5-63" => "\xe5\xa9\xba",
	"2-5-64" => "\xe5\xaa\x8b",
	"2-5-65" => "\xe5\xaa\x9c",
	"2-5-66" => "\xe5\xaa\x9f",
	"2-5-67" => "\xe5\xaa\xa0",
	"2-5-68" => "\xe5\xaa\xa2",
	"2-5-69" => "\xe5\xaa\xb1",
	"2-5-70" => "\xe5\xaa\xb3",
	"2-5-71" => "\xe5\xaa\xb5",
	"2-5-72" => "\xe5\xaa\xba",
	"2-5-73" => "\xe5\xaa\xbf",
	"2-5-74" => "\xe5\xab\x9a",
	"2-5-75" => "\xe5\xab\x9c",
	"2-5-76" => "\xe5\xab\xa0",
	"2-5-77" => "\xe5\xab\xa5",
	"2-5-78" => "\xe5\xab\xb0",
	"2-5-79" => "\xe5\xab\xae",
	"2-5-80" => "\xe5\xab\xb5",
	"2-5-81" => "\xe5\xac\x80",
	"2-5-82" => "\xe5\xac\x88",
	"2-5-83" => "\xe5\xac\x97",
	"2-5-84" => "\xe5\xac\xb4",
	"2-5-85" => "\xe5\xac\xad",
	"2-5-86" => "\xe5\xad\x8c",
	"2-5-87" => "\xe5\xad\x92",
	"2-5-88" => "\xe5\xad\xa8",
	"2-5-89" => "\xe5\xad\xaf",
	"2-5-90" => "\xe5\xad\xbc",
	"2-5-91" => "\xe5\xad\xbf",
	"2-5-92" => "\xe5\xae\x81",
	"2-5-93" => "\xe5\xae\x84",
	"2-5-94" => "\xf0\xa1\xa7\x83",	
	"2-8-1" => "\xe5\xae\x96",
	"2-8-2" => "\xe5\xae\xac",
	"2-8-3" => "\xe3\x9d\xa1",
	"2-8-4" => "\xe5\xaf\x80",
	"2-8-5" => "\xe3\x9d\xa2",
	"2-8-6" => "\xe5\xaf\x8e",
	"2-8-7" => "\xe5\xaf\x96",
	"2-8-8" => "\xe3\x9d\xac",
	"2-8-9" => "\xe3\x9d\xab",
	"2-8-10" => "\xe5\xaf\xb1",
	"2-8-11" => "\xe5\xaf\xbd",
	"2-8-12" => "\xe3\x9d\xb5",
	"2-8-13" => "\xe5\xb0\x83",
	"2-8-14" => "\xe5\xb0\xa9",
	"2-8-15" => "\xe5\xb0\xb0",
	"2-8-16" => "\xf0\xa1\xb1\x96",	
	"2-8-17" => "\xe5\xb1\x9f",
	"2-8-18" => "\xe5\xb1\xa3",
	"2-8-19" => "\xe5\xb1\xa7",
	"2-8-20" => "\xe5\xb1\xa8",
	"2-8-21" => "\xe5\xb1\xa9",
	"2-8-22" => "\xe5\xb1\xb0",
	"2-8-23" => "\xf0\xa1\xb4\xad",	
	"2-8-24" => "\xf0\xa1\xb5\x85",	
	"2-8-25" => "\xe5\xb1\xbc",
	"2-8-26" => "\xf0\xa1\xb5\xb8",	
	"2-8-27" => "\xf0\xa1\xb5\xa2",	
	"2-8-28" => "\xe5\xb2\x88",
	"2-8-29" => "\xe5\xb2\x8a",
	"2-8-30" => "\xe3\x9f\x81",
	"2-8-31" => "\xf0\xa1\xb6\xa1",	
	"2-8-32" => "\xf0\xa1\xb6\x9c",	
	"2-8-33" => "\xe5\xb2\xa0",
	"2-8-34" => "\xe5\xb2\xa2",
	"2-8-35" => "\xe5\xb2\xa6",
	"2-8-36" => "\xe5\xb2\xa7",
	"2-8-37" => "\xf0\xa1\xb6\x92",	
	"2-8-38" => "\xe5\xb2\xad",
	"2-8-39" => "\xe5\xb2\xb5",
	"2-8-40" => "\xf0\xa1\xb6\xb7",	
	"2-8-41" => "\xe5\xb3\x89",
	"2-8-42" => "\xf0\xa1\xb7\xa0",	
	"2-8-43" => "\xf0\xa1\xb8\xb3",	
	"2-8-44" => "\xe5\xb4\x86",
	"2-8-45" => "\xe5\xb4\x90",
	"2-8-46" => "\xe5\xb4\xab",
	"2-8-47" => "\xe5\xb4\x9d",
	"2-8-48" => "\xe5\xb4\xa0",
	"2-8-49" => "\xe5\xb4\xa4",
	"2-8-50" => "\xe5\xb4\xa6",
	"2-8-51" => "\xe5\xb4\xb1",
	"2-8-52" => "\xe5\xb4\xb9",
	"2-8-53" => "\xe5\xb5\x82",
	"2-8-54" => "\xe3\x9f\xa8",
	"2-8-55" => "\xe5\xb5\xa1",
	"2-8-56" => "\xe5\xb5\xaa",
	"2-8-57" => "\xe3\x9f\xb4",
	"2-8-58" => "\xe5\xb5\xb0",
	"2-8-59" => "\xf0\xa1\xbc\x9e",	
	"2-8-60" => "\xe3\x9f\xbd",
	"2-8-61" => "\xe5\xb6\x88",
	"2-8-62" => "\xe3\xa0\x80",
	"2-8-63" => "\xe5\xb6\x92",
	"2-8-64" => "\xe5\xb6\x94",
	"2-8-65" => "\xe5\xb6\x97",
	"2-8-66" => "\xe5\xb6\x99",
	"2-8-67" => "\xe5\xb6\xb0",
	"2-8-68" => "\xe5\xb6\xb2",
	"2-8-69" => "\xe5\xb6\xb4",
	"2-8-70" => "\xf0\xa1\xbd\xb6",	
	"2-8-71" => "\xe5\xb6\xb9",
	"2-8-72" => "\xe5\xb7\x91",
	"2-8-73" => "\xe5\xb7\x97",
	"2-8-74" => "\xe5\xb7\x98",
	"2-8-75" => "\xe5\xb7\xa0",
	"2-8-76" => "\xf0\xa1\xbf\xba",	
	"2-8-77" => "\xe5\xb7\xa4",
	"2-8-78" => "\xe5\xb7\xa9",
	"2-8-79" => "\xe3\xa0\xaf",
	"2-8-80" => "\xe5\xb8\x80",
	"2-8-81" => "\xe3\xa0\xb6",
	"2-8-82" => "\xe5\xb8\x92",
	"2-8-83" => "\xe5\xb8\x95",
	"2-8-84" => "\xe3\xa1\x80",
	"2-8-85" => "\xe5\xb8\x9f",
	"2-8-86" => "\xe5\xb8\xae",
	"2-8-87" => "\xe5\xb8\xbe",
	"2-8-88" => "\xe5\xb9\x89",
	"2-8-89" => "\xe3\xa1\x9c",
	"2-8-90" => "\xe5\xb9\x96",
	"2-8-91" => "\xe3\xa1\xa1",
	"2-8-92" => "\xe5\xb9\xab",
	"2-8-93" => "\xe5\xb9\xac",
	"2-8-94" => "\xe5\xb9\xad",
	"2-12-1" => "\xe5\xb9\xae",
	"2-12-2" => "\xf0\xa2\x85\xbb",	
	"2-12-3" => "\xe5\xba\xa5",
	"2-12-4" => "\xe5\xba\xaa",
	"2-12-5" => "\xe5\xba\xac",
	"2-12-6" => "\xe5\xba\xb9",
	"2-12-7" => "\xe5\xba\xbf",
	"2-12-8" => "\xe5\xbb\x86",
	"2-12-9" => "\xe5\xbb\x92",
	"2-12-10" => "\xe5\xbb\x99",
	"2-12-11" => "\xf0\xa2\x8c\x9e",	
	"2-12-12" => "\xe5\xbb\xbd",
	"2-12-13" => "\xe5\xbc\x88",
	"2-12-14" => "\xe5\xbc\x8e",
	"2-12-15" => "\xe5\xbc\x9c",
	"2-12-16" => "\xf0\xa2\x8e\xad",	
	"2-12-17" => "\xe5\xbc\x9e",
	"2-12-18" => "\xe5\xbd\x87",
	"2-12-19" => "\xe5\xbd\xa3",
	"2-12-20" => "\xe5\xbd\xb2",
	"2-12-21" => "\xe5\xbd\xbe",
	"2-12-22" => "\xe5\xbe\x8f",
	"2-12-23" => "\xe5\xbe\xa2",
	"2-12-24" => "\xe5\xbe\xa4",
	"2-12-25" => "\xe5\xbe\xb8",
	"2-12-26" => "\xe5\xbf\x84",
	"2-12-27" => "\xe3\xa3\xba",
	"2-12-28" => "\xe5\xbf\x87",
	"2-12-29" => "\xe5\xbf\x8b",
	"2-12-30" => "\xe5\xbf\x92",
	"2-12-31" => "\xe5\xbf\x93",
	"2-12-32" => "\xe5\xbf\x94",
	"2-12-33" => "\xe5\xbf\xa2",
	"2-12-34" => "\xe5\xbf\xae",
	"2-12-35" => "\xe5\xbf\xaf",
	"2-12-36" => "\xe5\xbf\xb3",
	"2-12-37" => "\xe5\xbf\xbc",
	"2-12-38" => "\xe3\xa4\x97",
	"2-12-39" => "\xe6\x80\x97",
	"2-12-40" => "\xe6\x80\xa2",
	"2-12-41" => "\xe6\x80\xa4",
	"2-12-42" => "\xe3\xa4\x9a",
	"2-12-43" => "\xe6\x81\x8c",
	"2-12-44" => "\xe6\x81\xbf",
	"2-12-45" => "\xe6\x82\x8a",
	"2-12-46" => "\xe6\x82\x95",
	"2-12-47" => "\xe6\x82\xa8",
	"2-12-48" => "\xf0\xa2\x9b\xb3",	
	"2-12-49" => "\xe6\x82\xb0",
	"2-12-50" => "\xe6\x82\xb1",
	"2-12-51" => "\xe6\x82\xbe",
	"2-12-52" => "\xe6\x83\x88",
	"2-12-53" => "\xe6\x83\x99",
	"2-12-54" => "\xe6\x83\x9b",
	"2-12-55" => "\xe6\x83\xae",
	"2-12-56" => "\xe6\x83\xb2",
	"2-12-57" => "\xe6\x83\xb5",
	"2-12-58" => "\xe6\x84\x90",
	"2-12-59" => "\xe6\x84\x92",
	"2-12-60" => "\xe6\x84\x93",
	"2-12-61" => "\xe6\x84\x99",
	"2-12-62" => "\xe6\x84\x9e",
	"2-12-63" => "\xe6\x84\xba",
	"2-12-64" => "\xe3\xa5\xaf",
	"2-12-65" => "\xe6\x85\x81",
	"2-12-66" => "\xe6\x85\x86",
	"2-12-67" => "\xe6\x85\xa0",
	"2-12-68" => "\xe6\x85\xbc",
	"2-12-69" => "\xf0\xa2\xa1\x9b",	
	"2-12-70" => "\xe6\x86\x92",
	"2-12-71" => "\xe6\x86\x93",
	"2-12-72" => "\xe6\x86\x97",
	"2-12-73" => "\xe6\x86\x98",
	"2-12-74" => "\xe6\x86\xa5",
	"2-12-75" => "\xe6\x86\xa8",
	"2-12-76" => "\xe6\x86\xad",
	"2-12-77" => "\xf0\xa2\xa2\xab",	
	"2-12-78" => "\xe6\x87\x95",
	"2-12-79" => "\xe6\x87\x9d",
	"2-12-80" => "\xe6\x87\x9f",
	"2-12-81" => "\xe6\x87\xb5",
	"2-12-82" => "\xf0\xa2\xa6\x8f",	
	"2-12-83" => "\xe6\x88\x95",
	"2-12-84" => "\xe6\x88\xa3",
	"2-12-85" => "\xe6\x88\xa9",
	"2-12-86" => "\xe6\x89\x86",
	"2-12-87" => "\xe6\x89\x8c",
	"2-12-88" => "\xe6\x89\x91",
	"2-12-89" => "\xe6\x89\x92",
	"2-12-90" => "\xe6\x89\xa1",
	"2-12-91" => "\xe6\x89\xa4",
	"2-12-92" => "\xe6\x89\xbb",
	"2-12-93" => "\xe6\x89\xad",
	"2-12-94" => "\xe6\x89\xb3",
	"2-13-1" => "\xe6\x8a\x99",
	"2-13-2" => "\xe6\x8a\xa6",
	"2-13-3" => "\xe6\x8b\x95",
	"2-13-4" => "\xf0\xa2\xaa\xb8",	
	"2-13-5" => "\xe6\x8b\xbd",
	"2-13-6" => "\xe6\x8c\x83",
	"2-13-7" => "\xe6\x8c\x8d",
	"2-13-8" => "\xe6\x8c\x90",
	"2-13-9" => "\xf0\xa2\xad\x8f",	
	"2-13-10" => "\xf0\xa2\xad\x90",	
	"2-13-11" => "\xe6\x8c\xb2",
	"2-13-12" => "\xe6\x8c\xb5",
	"2-13-13" => "\xe6\x8c\xbb",
	"2-13-14" => "\xe6\x8c\xbc",
	"2-13-15" => "\xe6\x8d\x81",
	"2-13-16" => "\xe6\x8d\x84",
	"2-13-17" => "\xe6\x8d\x8e",
	"2-13-18" => "\xf0\xa2\xad\x86",	
	"2-13-19" => "\xe6\x8d\x99",
	"2-13-20" => "\xf0\xa2\xb0\x9d",	
	"2-13-21" => "\xf0\xa2\xae\xa6",	
	"2-13-22" => "\xe6\x8d\xac",
	"2-13-23" => "\xe6\x8e\x84",
	"2-13-24" => "\xe6\x8e\x99",
	"2-13-25" => "\xf0\xa2\xb0\xa4",	
	"2-13-26" => "\xe6\x8e\x94",
	"2-13-27" => "\xe6\x8e\xbd",
	"2-13-28" => "\xe6\x8f\xb7",
	"2-13-29" => "\xe6\x8f\x94",
	"2-13-30" => "\xe6\x8f\x95",
	"2-13-31" => "\xe6\x8f\x9c",
	"2-13-32" => "\xe6\x8f\xa0",
	"2-13-33" => "\xe6\x8f\xab",
	"2-13-34" => "\xe6\x8f\xac",
	"2-13-35" => "\xe6\x8f\xb2",
	"2-13-36" => "\xe6\x90\x89",
	"2-13-37" => "\xe6\x90\x9e",
	"2-13-38" => "\xe6\x90\xa5",
	"2-13-39" => "\xe6\x90\xa9",
	"2-13-40" => "\xe6\x90\xaf",
	"2-13-41" => "\xe6\x91\x9a",
	"2-13-42" => "\xe6\x91\x9b",
	"2-13-43" => "\xe6\x91\x9d",
	"2-13-44" => "\xe6\x91\xb3",
	"2-13-45" => "\xe6\x91\xbd",
	"2-13-46" => "\xe6\x92\x87",
	"2-13-47" => "\xe6\x92\x91",
	"2-13-48" => "\xe6\x92\x9d",
	"2-13-49" => "\xe6\x92\x9f",
	"2-13-50" => "\xe6\x93\x8b",
	"2-13-51" => "\xe6\x93\x8c",
	"2-13-52" => "\xe6\x93\x95",
	"2-13-53" => "\xe6\x93\x97",
	"2-13-54" => "\xf0\xa2\xb7\xa1",	
	"2-13-55" => "\xe6\x93\xa4",
	"2-13-56" => "\xe6\x93\xa5",
	"2-13-57" => "\xe6\x93\xbf",
	"2-13-58" => "\xe6\x94\x84",
	"2-13-59" => "\xe3\xa9\xae",
	"2-13-60" => "\xe6\x94\x8f",
	"2-13-61" => "\xe6\x94\x94",
	"2-13-62" => "\xe6\x94\x96",
	"2-13-63" => "\xe3\xa9\xb3",
	"2-13-64" => "\xe6\x94\x9e",
	"2-13-65" => "\xe6\x94\xb2",
	"2-13-66" => "\xe6\x95\x84",
	"2-13-67" => "\xe6\x95\x94",
	"2-13-68" => "\xe6\x95\xab",
	"2-13-69" => "\xe6\x95\xba",
	"2-13-70" => "\xe6\x96\x81",
	"2-13-71" => "\xe6\x96\x84",
	"2-13-72" => "\xe6\x96\x85",
	"2-13-73" => "\xe6\x96\x8a",
	"2-13-74" => "\xe6\x96\xb2",
	"2-13-75" => "\xe6\x96\xb5",
	"2-13-76" => "\xe6\x96\xb8",
	"2-13-77" => "\xe6\x96\xbf",
	"2-13-78" => "\xe6\x97\x82",
	"2-13-79" => "\xe6\x97\x89",
	"2-13-80" => "\xe6\x97\x94",
	"2-13-81" => "\xe3\xab\x96",
	"2-13-82" => "\xe6\x97\xb2",
	"2-13-83" => "\xe6\x97\xb9",
	"2-13-84" => "\xe6\x97\xbc",
	"2-13-85" => "\xe6\x98\x84",
	"2-13-86" => "\xe6\x98\x88",
	"2-13-87" => "\xe6\x98\xa1",
	"2-13-88" => "\xe6\x98\xaa",
	"2-13-89" => "\xe6\x99\x85",
	"2-13-90" => "\xe6\x99\x91",
	"2-13-91" => "\xe6\x99\x8e",
	"2-13-92" => "\xe3\xab\xaa",
	"2-13-93" => "\xf0\xa3\x87\x83",	
	"2-13-94" => "\xe6\x99\x97",
	"2-14-1" => "\xe6\x99\x9b",
	"2-14-2" => "\xe6\x99\xa3",
	"2-14-3" => "\xf0\xa3\x87\xb5",	
	"2-14-4" => "\xf0\xa3\x86\xb6",	
	"2-14-5" => "\xe6\x99\xaa",
	"2-14-6" => "\xe6\x99\xab",
	"2-14-7" => "\xe6\x99\xac",
	"2-14-8" => "\xe6\x99\xad",
	"2-14-9" => "\xe6\x99\xbb",
	"2-14-10" => "\xe6\x9a\x80",
	"2-14-11" => "\xe6\x9a\x90",
	"2-14-12" => "\xe6\x9a\x92",
	"2-14-13" => "\xe6\x9a\x99",
	"2-14-14" => "\xe3\xac\x8e",
	"2-14-15" => "\xe6\x9a\xad",
	"2-14-16" => "\xe6\x9a\xb1",
	"2-14-17" => "\xe6\x9a\xb5",
	"2-14-18" => "\xe3\xac\x9a",
	"2-14-19" => "\xe6\x9a\xbf",
	"2-14-20" => "\xe3\xac\x9c",
	"2-14-21" => "\xe6\x9b\xac",
	"2-14-22" => "\xe3\xab\x97",
	"2-14-23" => "\xe6\x9c\x81",
	"2-14-24" => "\xe6\x9c\x85",
	"2-14-25" => "\xe6\x9c\x92",
	"2-14-26" => "\xf0\xa3\x8d\xb2",	
	"2-14-27" => "\xe6\x9c\x99",
	"2-14-28" => "\xf0\xa3\x8f\x93",	
	"2-14-29" => "\xf0\xa3\x8f\x92",	
	"2-14-30" => "\xe6\x9d\x8c",
	"2-14-31" => "\xe6\x9d\x8d",
	"2-14-32" => "\xe6\x9d\x94",
	"2-14-33" => "\xe6\x9d\x9d",
	"2-14-34" => "\xf0\xa3\x8f\x90",	
	"2-14-35" => "\xf0\xa3\x8f\xa4",	
	"2-14-36" => "\xf0\xa3\x8f\x95",	
	"2-14-37" => "\xe6\x9d\xb4",
	"2-14-38" => "\xe6\x9d\xb6",
	"2-14-39" => "\xf0\xa3\x8f\x9a",	
	"2-14-40" => "\xe6\x9e\x92",
	"2-14-41" => "\xf0\xa3\x8f\x9f",	
	"2-14-42" => "\xe8\x8d\xa3",
	"2-14-43" => "\xe6\xa0\x90",
	"2-14-44" => "\xe6\x9e\xb0",
	"2-14-45" => "\xe6\x9e\xb2",
	"2-14-46" => "\xe6\x9f\x83",
	"2-14-47" => "\xe6\x9f\x88",
	"2-14-48" => "\xe6\x9f\x92",
	"2-14-49" => "\xe6\x9f\x99",
	"2-14-50" => "\xe6\x9f\x9b",
	"2-14-51" => "\xe6\x9f\xb0",
	"2-14-52" => "\xe6\x9f\xb7",
	"2-14-53" => "\xf0\xa3\x91\x8a",	
	"2-14-54" => "\xf0\xa3\x91\x91",	
	"2-14-55" => "\xf0\xa3\x91\x8b",	
	"2-14-56" => "\xe6\xa0\x98",
	"2-14-57" => "\xe6\xa0\x9f",
	"2-14-58" => "\xe6\xa0\xad",
	"2-14-59" => "\xf0\xa3\x91\xa5",	
	"2-14-60" => "\xe6\xa0\xb3",
	"2-14-61" => "\xe6\xa0\xbb",
	"2-14-62" => "\xe6\xa0\xbe",
	"2-14-63" => "\xe6\xa1\x84",
	"2-14-64" => "\xe6\xa1\x85",
	"2-14-65" => "\xe6\xa1\x89",
	"2-14-66" => "\xe6\xa1\x8c",
	"2-14-67" => "\xe6\xa1\x95",
	"2-14-68" => "\xe6\xa1\x97",
	"2-14-69" => "\xe3\xad\xb7",
	"2-14-70" => "\xe6\xa1\xab",
	"2-14-71" => "\xe6\xa1\xae",
	"2-14-72" => "\xe6\xa1\xba",
	"2-14-73" => "\xe6\xa1\xbc",
	"2-14-74" => "\xe6\xa2\x82",
	"2-14-75" => "\xe6\xa2\x90",
	"2-14-76" => "\xe6\xa2\x96",
	"2-14-77" => "\xe3\xad\xad",
	"2-14-78" => "\xe6\xa2\x98",
	"2-14-79" => "\xe6\xa2\x99",
	"2-14-80" => "\xe6\xa2\x9a",
	"2-14-81" => "\xe6\xa2\x9c",
	"2-14-82" => "\xe6\xa2\xaa",
	"2-14-83" => "\xe6\xa2\xab",
	"2-14-84" => "\xe6\xa2\xb4",
	"2-14-85" => "\xe6\xa2\xbb",
	"2-14-86" => "\xe6\xa3\xbb",
	"2-14-87" => "\xf0\xa3\x93\xa4",	
	"2-14-88" => "\xf0\xa3\x95\x9a",	
	"2-14-89" => "\xef\xa8\x93",
	"2-14-90" => "\xe6\xa3\x83",
	"2-14-91" => "\xe6\xa3\x85",
	"2-14-92" => "\xe6\xa3\x8c",
	"2-14-93" => "\xe6\xa3\x8f",
	"2-14-94" => "\xe6\xa3\x96",
	"2-15-1" => "\xe6\xa3\x99",
	"2-15-2" => "\xe6\xa3\xa4",
	"2-15-3" => "\xe6\xa3\xa5",
	"2-15-4" => "\xe6\xa3\xac",
	"2-15-5" => "\xe6\xa3\xb7",
	"2-15-6" => "\xe6\xa4\x83",
	"2-15-7" => "\xe6\xa4\x87",
	"2-15-8" => "\xe3\xae\x87",
	"2-15-9" => "\xe3\xae\x88",
	"2-15-10" => "\xf0\xa3\x96\x94",	
	"2-15-11" => "\xe6\xa4\xbb",
	"2-15-12" => "\xe3\xae\x8d",
	"2-15-13" => "\xe6\xa5\x86",
	"2-15-14" => "\xe6\xa5\xa9",
	"2-15-15" => "\xe6\xa5\xac",
	"2-15-16" => "\xe6\xa5\xb2",
	"2-15-17" => "\xe6\xa5\xba",
	"2-15-18" => "\xe6\xa5\xbf",
	"2-15-19" => "\xe6\xa6\x92",
	"2-15-20" => "\xe3\xae\xa4",
	"2-15-21" => "\xe6\xa6\x96",
	"2-15-22" => "\xe6\xa6\x98",
	"2-15-23" => "\xe6\xa6\xa6",
	"2-15-24" => "\xe6\xa6\xb0",
	"2-15-25" => "\xe6\xa6\xb7",
	"2-15-26" => "\xe6\xa6\xba",
	"2-15-27" => "\xe6\xa6\xbc",
	"2-15-28" => "\xe6\xa7\x80",
	"2-15-29" => "\xe6\xa7\x91",
	"2-15-30" => "\xe6\xa7\x96",
	"2-15-31" => "\xf0\xa3\x98\xb9",	
	"2-15-32" => "\xf0\xa3\x99\x87",	
	"2-15-33" => "\xe6\xa8\xb0",
	"2-15-34" => "\xf0\xa3\x98\xb8",	
	"2-15-35" => "\xf0\xa3\x98\xba",	
	"2-15-36" => "\xe6\xa7\xa3",
	"2-15-37" => "\xe6\xa7\xae",
	"2-15-38" => "\xe6\xa7\xaf",
	"2-15-39" => "\xe6\xa7\xb3",
	"2-15-40" => "\xe3\xaf\x8d",
	"2-15-41" => "\xe6\xa7\xb4",
	"2-15-42" => "\xe6\xa7\xbe",
	"2-15-43" => "\xe6\xa8\x91",
	"2-15-44" => "\xe6\xa8\x9a",
	"2-15-45" => "\xe6\xa8\x9d",
	"2-15-46" => "\xf0\xa3\x9c\x9c",	
	"2-15-47" => "\xe6\xa8\xb2",
	"2-15-48" => "\xe6\xa8\xb3",
	"2-15-49" => "\xe6\xa8\xb4",
	"2-15-50" => "\xe6\xa8\xbf",
	"2-15-51" => "\xe6\xa9\x86",
	"2-15-52" => "\xe6\xa9\x89",
	"2-15-53" => "\xe6\xa9\xba",
	"2-15-54" => "\xe6\xa9\x8e",
	"2-15-55" => "\xe6\xa9\x92",
	"2-15-56" => "\xe6\xa9\xa4",
	"2-15-57" => "\xf0\xa3\x9c\x8c",	
	"2-15-58" => "\xe6\xa9\xbe",
	"2-15-59" => "\xe6\xaa\x83",
	"2-15-60" => "\xe6\xaa\x8b",
	"2-15-61" => "\xe3\xaf\xb0",
	"2-15-62" => "\xe6\xaa\x91",
	"2-15-63" => "\xe6\xaa\x9f",
	"2-15-64" => "\xe6\xaa\xa1",
	"2-15-65" => "\xf0\xa3\x9d\xa4",	
	"2-15-66" => "\xe6\xaa\xab",
	"2-15-67" => "\xe6\xaa\xbd",
	"2-15-68" => "\xe6\xab\x86",
	"2-15-69" => "\xe6\xab\x94",
	"2-15-70" => "\xe6\xab\x90",
	"2-15-71" => "\xe6\xab\x9c",
	"2-15-72" => "\xe6\xab\x9d",
	"2-15-73" => "\xf0\xa3\x9f\xbf",	
	"2-15-74" => "\xf0\xa3\x9f\xa7",	
	"2-15-75" => "\xe6\xab\xac",
	"2-15-76" => "\xe6\xab\xb1",
	"2-15-77" => "\xe6\xab\xb2",
	"2-15-78" => "\xe6\xab\xb3",
	"2-15-79" => "\xe6\xab\xbd",
	"2-15-80" => "\xf0\xa3\xa0\xa4",	
	"2-15-81" => "\xe6\xac\x8b",
	"2-15-82" => "\xe6\xac\x8f",
	"2-15-83" => "\xe6\xac\x90",
	"2-15-84" => "\xe6\xac\x91",
	"2-15-85" => "\xf0\xa3\xa0\xbd",	
	"2-15-86" => "\xe6\xac\x97",
	"2-15-87" => "\xe3\xb0\xa6",
	"2-15-88" => "\xe6\xac\xaf",
	"2-15-89" => "\xe6\xad\x8a",
	"2-15-90" => "\xe6\xad\x98",
	"2-15-91" => "\xe6\xad\xac",
	"2-15-92" => "\xe6\xad\xb5",
	"2-15-93" => "\xe6\xad\xba",
	"2-15-94" => "\xe6\xae\x81",
	"2-78-1" => "\xe6\xae\x9b",
	"2-78-2" => "\xe6\xae\xae",
	"2-78-3" => "\xf0\xa3\xaa\x98",	
	"2-78-4" => "\xe6\xae\xbd",
	"2-78-5" => "\xe6\xae\xbe",
	"2-78-6" => "\xe6\xaf\x87",
	"2-78-7" => "\xe6\xaf\x88",
	"2-78-8" => "\xe6\xaf\x89",
	"2-78-9" => "\xe6\xaf\x9a",
	"2-78-10" => "\xe6\xaf\xa6",
	"2-78-11" => "\xe6\xaf\xa7",
	"2-78-12" => "\xe6\xaf\xae",
	"2-78-13" => "\xe6\xaf\xb1",
	"2-78-14" => "\xe6\xb0\x82",
	"2-78-15" => "\xe6\xb0\x8a",
	"2-78-16" => "\xe6\xb0\x8e",
	"2-78-17" => "\xe6\xb0\xb5",
	"2-78-18" => "\xe6\xb0\xb6",
	"2-78-19" => "\xe6\xb0\xba",
	"2-78-20" => "\xf0\xa3\xb1\xbf",	
	"2-78-21" => "\xe6\xb0\xbf",
	"2-78-22" => "\xe6\xb1\x8d",
	"2-78-23" => "\xe6\xb1\x9b",
	"2-78-24" => "\xe6\xb1\xad",
	"2-78-25" => "\xe6\xb2\x84",
	"2-78-26" => "\xe6\xb2\x89",
	"2-78-27" => "\xe3\xb3\x83",
	"2-78-28" => "\xe6\xb2\x94",
	"2-78-29" => "\xe6\xb2\x95",
	"2-78-30" => "\xe6\xb2\x97",
	"2-78-31" => "\xe6\xb2\xad",
	"2-78-32" => "\xe6\xb3\x82",
	"2-78-33" => "\xe6\xb3\x90",
	"2-78-34" => "\xe3\xb3\x92",
	"2-78-35" => "\xe6\xb3\x96",
	"2-78-36" => "\xe6\xb3\x9a",
	"2-78-37" => "\xe6\xb3\x9c",
	"2-78-38" => "\xe6\xb3\xa9",
	"2-78-39" => "\xe6\xb3\xac",
	"2-78-40" => "\xe6\xb3\xad",
	"2-78-41" => "\xf0\xa3\xb4\x80",	
	"2-78-42" => "\xe6\xb4\x80",
	"2-78-43" => "\xe6\xb4\x8a",
	"2-78-44" => "\xe6\xb4\xa4",
	"2-78-45" => "\xe6\xb4\xa6",
	"2-78-46" => "\xe6\xb4\xa7",
	"2-78-47" => "\xe6\xb1\xa7",
	"2-78-48" => "\xe6\xb4\xaf",
	"2-78-49" => "\xe6\xb4\xbc",
	"2-78-50" => "\xe6\xb5\x9b",
	"2-78-51" => "\xe6\xb5\x9e",
	"2-78-52" => "\xe6\xb5\xa0",
	"2-78-53" => "\xe6\xb5\xb0",
	"2-78-54" => "\xe6\xb6\x80",
	"2-78-55" => "\xe6\xb6\x81",
	"2-78-56" => "\xe6\xb6\x8a",
	"2-78-57" => "\xe6\xb6\x8d",
	"2-78-58" => "\xe6\xb6\x91",
	"2-78-59" => "\xe6\xb6\x98",
	"2-78-60" => "\xf0\xa3\xb5\x80",	
	"2-78-61" => "\xe6\xb8\x97",
	"2-78-62" => "\xf0\xa3\xb7\xba",	
	"2-78-63" => "\xf0\xa3\xb7\xb9",	
	"2-78-64" => "\xf0\xa3\xb7\x93",	
	"2-78-65" => "\xe6\xb6\xab",
	"2-78-66" => "\xe6\xb6\xae",
	"2-78-67" => "\xe6\xb6\xb4",
	"2-78-68" => "\xe6\xb7\x82",
	"2-78-69" => "\xe6\xb4\xb4",
	"2-78-70" => "\xe6\xb7\x88",
	"2-78-71" => "\xe6\xb7\x8e",
	"2-78-72" => "\xe6\xb7\x8f",
	"2-78-73" => "\xe6\xb7\x90",
	"2-78-74" => "\xe6\xb7\x9f",
	"2-78-75" => "\xe6\xb7\xa9",
	"2-78-76" => "\xe6\xb7\xb6",
	"2-78-77" => "\xe6\xb8\xb6",
	"2-78-78" => "\xe6\xb8\x9e",
	"2-78-79" => "\xe6\xb8\xa2",
	"2-78-80" => "\xe6\xb8\xa7",
	"2-78-81" => "\xe3\xb4\x91",
	"2-78-82" => "\xe6\xb8\xb2",
	"2-78-83" => "\xe6\xb8\xbc",
	"2-78-84" => "\xe6\xb9\x88",
	"2-78-85" => "\xe6\xb9\x89",
	"2-78-86" => "\xe6\xb9\x8b",
	"2-78-87" => "\xe6\xb9\x8c",
	"2-78-88" => "\xe6\xb9\x8f",
	"2-78-89" => "\xe6\xb9\x91",
	"2-78-90" => "\xe6\xb9\x93",
	"2-78-91" => "\xe6\xb9\x94",
	"2-78-92" => "\xe6\xb9\x97",
	"2-78-93" => "\xe6\xb9\xa3",
	"2-78-94" => "\xe3\xb4\x9e",
	"2-79-1" => "\xe6\xba\x93",
	"2-79-2" => "\xe6\xba\xa7",
	"2-79-3" => "\xe6\xba\xb4",
	"2-79-4" => "\xe6\xba\xbf",
	"2-79-5" => "\xe6\xbb\x83",
	"2-79-6" => "\xe6\xbb\x8a",
	"2-79-7" => "\xe6\xbb\x99",
	"2-79-8" => "\xe6\xbc\xb5",
	"2-79-9" => "\xe6\xbb\xab",
	"2-79-10" => "\xe6\xbb\xb9",
	"2-79-11" => "\xe6\xbb\xbb",
	"2-79-12" => "\xe6\xbc\x8a",
	"2-79-13" => "\xe6\xbc\x8c",
	"2-79-14" => "\xe6\xbc\x98",
	"2-79-15" => "\xe6\xbc\xa5",
	"2-79-16" => "\xe6\xbc\xb6",
	"2-79-17" => "\xe6\xbc\xbc",
	"2-79-18" => "\xf0\xa3\xbd\xbe",	
	"2-79-19" => "\xe6\xbd\x92",
	"2-79-20" => "\xe6\xbd\x97",
	"2-79-21" => "\xe6\xbd\x9a",
	"2-79-22" => "\xe6\xbd\xa0",
	"2-79-23" => "\xe6\xbd\xa8",
	"2-79-24" => "\xe6\xbe\x98",
	"2-79-25" => "\xe6\xbd\xbd",
	"2-79-26" => "\xe6\xbe\x90",
	"2-79-27" => "\xe6\xbe\x96",
	"2-79-28" => "\xe6\xbe\xbe",
	"2-79-29" => "\xe6\xbe\x9f",
	"2-79-30" => "\xe6\xbe\xa5",
	"2-79-31" => "\xe6\xbe\xaf",
	"2-79-32" => "\xe3\xb5\xa4",
	"2-79-33" => "\xe6\xbe\xb5",
	"2-79-34" => "\xe6\xbf\x88",
	"2-79-35" => "\xe6\xbf\x89",
	"2-79-36" => "\xe6\xbf\x9a",
	"2-79-37" => "\xe6\xbf\x9e",
	"2-79-38" => "\xe6\xbf\xa9",
	"2-79-39" => "\xf0\xa4\x82\x96",	
	"2-79-40" => "\xe6\xbf\xbc",
	"2-79-41" => "\xe7\x80\x80",
	"2-79-42" => "\xe7\x80\x87",
	"2-79-43" => "\xe7\x80\x8a",
	"2-79-44" => "\xe7\x80\xa3",
	"2-79-45" => "\xf0\xa4\x84\x83",	
	"2-79-46" => "\xe7\x80\xb9",
	"2-79-47" => "\xe7\x80\xba",
	"2-79-48" => "\xe7\x80\xbc",
	"2-79-49" => "\xe7\x81\x83",
	"2-79-50" => "\xe7\x81\x87",
	"2-79-51" => "\xe7\x81\x8b",
	"2-79-52" => "\xe3\xb6\x9a",
	"2-79-53" => "\xe7\x81\x94",
	"2-79-54" => "\xe7\x81\xa5",
	"2-79-55" => "\xe7\x81\xa9",
	"2-79-56" => "\xe7\x81\xac",
	"2-79-57" => "\xe7\x81\xae",
	"2-79-58" => "\xe7\x81\xb6",
	"2-79-59" => "\xe7\x81\xbe",
	"2-79-60" => "\xe7\x82\x81",
	"2-79-61" => "\xe7\x82\x86",
	"2-79-62" => "\xe7\x82\x95",
	"2-79-63" => "\xe7\x82\x97",
	"2-79-64" => "\xe7\x82\xbb",
	"2-79-65" => "\xf0\xa4\x87\x86",	
	"2-79-66" => "\xe7\x82\x9f",
	"2-79-67" => "\xe7\x82\xb1",
	"2-79-68" => "\xf0\xa4\x87\xbe",	
	"2-79-69" => "\xe7\x83\xac",
	"2-79-70" => "\xe7\x83\x8a",
	"2-79-71" => "\xe7\x83\x91",
	"2-79-72" => "\xe7\x83\x93",
	"2-79-73" => "\xe7\x83\x9c",
	"2-79-74" => "\xe7\x84\x83",
	"2-79-75" => "\xe7\x84\x84",
	"2-79-76" => "\xe7\x84\x86",
	"2-79-77" => "\xe7\x84\x87",
	"2-79-78" => "\xe7\x84\x88",
	"2-79-79" => "\xe7\x84\x8c",
	"2-79-80" => "\xe3\xb7\x80",
	"2-79-81" => "\xe7\x84\xaf",
	"2-79-82" => "\xe7\x84\xb1",
	"2-79-83" => "\xe7\x85\x90",
	"2-79-84" => "\xe7\x85\x8a",
	"2-79-85" => "\xe7\x85\x93",
	"2-79-86" => "\xe7\x85\x9e",
	"2-79-87" => "\xe3\xb7\x94",
	"2-79-88" => "\xe7\x86\x96",
	"2-79-89" => "\xe7\x86\x80",
	"2-79-90" => "\xe7\x86\x9b",
	"2-79-91" => "\xe7\x86\xa0",
	"2-79-92" => "\xe7\x86\xa2",
	"2-79-93" => "\xe7\x86\xae",
	"2-79-94" => "\xe7\x86\xaf",
	"2-80-1" => "\xe7\x86\xb3",
	"2-80-2" => "\xf0\xa4\x8e\xbc",	
	"2-80-3" => "\xe7\x87\x8b",
	"2-80-4" => "\xe7\x87\x93",
	"2-80-5" => "\xe7\x87\x99",
	"2-80-6" => "\xe7\x87\x9c",
	"2-80-7" => "\xe7\x88\x87",
	"2-80-8" => "\xe3\xb8\x85",
	"2-80-9" => "\xe7\x88\xab",	
	"2-80-10" => "\xe7\x88\xab",
	"2-80-11" => "\xe7\x88\xb4",
	"2-80-12" => "\xe7\x88\xb8",
	"2-80-13" => "\xe7\x88\xb9",
	"2-80-14" => "\xe4\xb8\xac",
	"2-80-15" => "\xe7\x89\x82",
	"2-80-16" => "\xe7\x89\x93",
	"2-80-17" => "\xe7\x89\x97",
	"2-80-18" => "\xe7\x89\xa3",
	"2-80-19" => "\xf0\xa4\x98\xa9",	
	"2-80-20" => "\xe7\x89\xae",
	"2-80-21" => "\xe7\x89\xaf",
	"2-80-22" => "\xe7\x89\xb8",
	"2-80-23" => "\xe7\x89\xbf",
	"2-80-24" => "\xe7\x8a\x8e",
	"2-80-25" => "\xf0\xa4\x9a\xa5",	
	"2-80-26" => "\xe7\x8a\xad",
	"2-80-27" => "\xe7\x8a\xae",
	"2-80-28" => "\xe7\x8a\xb0",
	"2-80-29" => "\xe7\x8a\xb1",
	"2-80-30" => "\xe7\x8b\x81",
	"2-80-31" => "\xe3\xb9\xa0",
	"2-80-32" => "\xe7\x8b\x8c",
	"2-80-33" => "\xe3\xb9\xa6",
	"2-80-34" => "\xe3\xb9\xa8",
	"2-80-35" => "\xe7\x8b\xb3",
	"2-80-36" => "\xe7\x8b\xba",
	"2-80-37" => "\xe7\x8c\x87",
	"2-80-38" => "\xe7\x8c\x92",
	"2-80-39" => "\xe7\x8c\x98",
	"2-80-40" => "\xe7\x8c\x99",
	"2-80-41" => "\xe3\xba\x83",
	"2-80-42" => "\xe7\x8c\xb9",
	"2-80-43" => "\xe7\x8c\xac",
	"2-80-44" => "\xe7\x8c\xb1",
	"2-80-45" => "\xe7\x8c\xb3",
	"2-80-46" => "\xe7\x8c\xbd",
	"2-80-47" => "\xe7\x8d\x92",
	"2-80-48" => "\xe3\xba\x94",
	"2-80-49" => "\xe7\x8d\xab",
	"2-80-50" => "\xe7\x8d\xac",
	"2-80-51" => "\xf0\xa4\xa2\x96",	
	"2-80-52" => "\xe7\x8d\xae",
	"2-80-53" => "\xe7\x8d\xaf",
	"2-80-54" => "\xe7\x8d\xb1",
	"2-80-55" => "\xe7\x8d\xb7",
	"2-80-56" => "\xe7\x8e\x81",
	"2-80-57" => "\xe7\x8e\x85",
	"2-80-58" => "\xe7\x8e\x8a",
	"2-80-59" => "\xe7\x8e\x94",
	"2-80-60" => "\xe7\x8e\x98",
	"2-80-61" => "\xe7\x8e\x9c",
	"2-80-62" => "\xe7\x8e\x9e",
	"2-80-63" => "\xe7\x8e\xa5",
	"2-80-64" => "\xe7\x8e\xa8",
	"2-80-65" => "\xe7\x8e\xb5",
	"2-80-66" => "\xe7\x8e\xb7",
	"2-80-67" => "\xe7\x8e\xb9",
	"2-80-68" => "\xe7\x8e\xbc",
	"2-80-69" => "\xe7\x8e\xbf",
	"2-80-70" => "\xe7\x8f\x85",
	"2-80-71" => "\xe7\x8f\x8b",
	"2-80-72" => "\xe7\x8f\xa1",
	"2-80-73" => "\xe7\x8f\xa7",
	"2-80-74" => "\xe7\x8f\xb9",
	"2-80-75" => "\xe7\x90\x93",
	"2-80-76" => "\xe7\x8f\xba",
	"2-80-77" => "\xe7\x90\x81",
	"2-80-78" => "\xe7\x90\xa4",
	"2-80-79" => "\xe7\x90\xb1",
	"2-80-80" => "\xe7\x90\xb9",
	"2-80-81" => "\xe7\x91\x93",
	"2-80-82" => "\xe7\x91\x80",
	"2-80-83" => "\xe7\x91\x83",
	"2-80-84" => "\xe7\x91\x8d",
	"2-80-85" => "\xe7\x91\x92",
	"2-80-86" => "\xe7\x91\x9d",
	"2-80-87" => "\xe7\x91\xb1",
	"2-80-88" => "\xe7\x92\x81",
	"2-80-89" => "\xe7\x92\x85",
	"2-80-90" => "\xe7\x92\x88",
	"2-80-91" => "\xf0\xa4\xa9\x8d",	
	"2-80-92" => "\xe7\x92\x92",
	"2-80-93" => "\xe7\x92\x97",
	"2-80-94" => "\xe7\x92\x99",
	"2-81-1" => "\xe7\x92\xa0",
	"2-81-2" => "\xe7\x92\xa1",
	"2-81-3" => "\xe7\x92\xa5",
	"2-81-4" => "\xe7\x92\xaa",
	"2-81-5" => "\xe7\x92\xab",
	"2-81-6" => "\xe7\x92\xb9",
	"2-81-7" => "\xe7\x92\xbb",
	"2-81-8" => "\xe7\x92\xba",
	"2-81-9" => "\xe7\x93\x96",
	"2-81-10" => "\xe7\x93\x98",
	"2-81-11" => "\xe7\x93\x9e",
	"2-81-12" => "\xe7\x93\xaf",
	"2-81-13" => "\xe7\x93\xab",
	"2-81-14" => "\xf0\xa4\xad\x96",	
	"2-81-15" => "\xe7\x93\xba",
	"2-81-16" => "\xf0\xa4\xad\xaf",	
	"2-81-17" => "\xe7\x94\xa0",
	"2-81-18" => "\xe7\x94\xa4",
	"2-81-19" => "\xe7\x94\xaa",
	"2-81-20" => "\xe3\xbd\x97",
	"2-81-21" => "\xf0\xa4\xb0\x96",	
	"2-81-22" => "\xe7\x94\xbd",
	"2-81-23" => "\xe7\x94\xbe",
	"2-81-24" => "\xe7\x95\x80",
	"2-81-25" => "\xe7\x95\x88",
	"2-81-26" => "\xe7\x95\x8e",
	"2-81-27" => "\xe7\x95\x90",
	"2-81-28" => "\xe7\x95\x92",
	"2-81-29" => "\xe7\x95\xac",
	"2-81-30" => "\xe7\x95\xb2",
	"2-81-31" => "\xe7\x95\xb1",
	"2-81-32" => "\xe7\x95\xba",
	"2-81-33" => "\xe7\x95\xbd",
	"2-81-34" => "\xe7\x95\xbe",
	"2-81-35" => "\xe7\x96\x81",
	"2-81-36" => "\xf0\xa4\xb4\x94",	
	"2-81-37" => "\xe7\x96\x8c",
	"2-81-38" => "\xe3\xbd\xb5",
	"2-81-39" => "\xe7\x96\xa2",
	"2-81-40" => "\xe3\xbd\xb7",
	"2-81-41" => "\xe7\x96\xb0",
	"2-81-42" => "\xe7\x96\xb7",
	"2-81-43" => "\xe7\x96\xbf",
	"2-81-44" => "\xe7\x97\x80",
	"2-81-45" => "\xe7\x97\x86",
	"2-81-46" => "\xe7\x97\x8f",
	"2-81-47" => "\xe7\x97\x93",
	"2-81-48" => "\xe7\x97\x9d",
	"2-81-49" => "\xe7\x97\x9f",
	"2-81-50" => "\xe7\x97\xa0",
	"2-81-51" => "\xe7\x97\xa7",
	"2-81-52" => "\xe7\x97\xac",
	"2-81-53" => "\xe7\x97\xae",
	"2-81-54" => "\xe7\x97\xb1",
	"2-81-55" => "\xe7\x97\xb9",
	"2-81-56" => "\xe7\x98\x83",
	"2-81-57" => "\xe7\x98\x98",
	"2-81-58" => "\xe7\x98\x87",
	"2-81-59" => "\xe7\x98\x8f",
	"2-81-60" => "\xe3\xbe\xae",
	"2-81-61" => "\xf0\xa4\xb8\x8e",	
	"2-81-62" => "\xe7\x98\x93",
	"2-81-63" => "\xe7\x98\x9b",
	"2-81-64" => "\xe7\x98\x9c",
	"2-81-65" => "\xf0\xa4\xb8\xb7",	
	"2-81-66" => "\xe7\x98\xa5",
	"2-81-67" => "\xe7\x98\xa8",
	"2-81-68" => "\xe7\x98\xbc",
	"2-81-69" => "\xe7\x98\xb3",
	"2-81-70" => "\xf0\xa4\xb9\xaa",	
	"2-81-71" => "\xe3\xbf\x89",
	"2-81-72" => "\xe7\x99\x81",
	"2-81-73" => "\xf0\xa4\xba\x8b",	
	"2-81-74" => "\xe7\x99\x89",
	"2-81-75" => "\xe7\x99\x95",
	"2-81-76" => "\xe3\xbf\x97",
	"2-81-77" => "\xe7\x99\xae",
	"2-81-78" => "\xe7\x9a\x95",
	"2-81-79" => "\xe7\x9a\x9c",
	"2-81-80" => "\xe7\x9a\xa1",
	"2-81-81" => "\xe7\x9a\xa0",
	"2-81-82" => "\xe7\x9a\xa7",
	"2-81-83" => "\xe7\x9a\xa8",
	"2-81-84" => "\xe7\x9a\xaf",
	"2-81-85" => "\xf0\xa5\x81\x8a",	
	"2-81-86" => "\xe7\x9b\x89",
	"2-81-87" => "\xf0\xa5\x81\x95",	
	"2-81-88" => "\xe7\x9b\xa8",
	"2-81-89" => "\xe7\x9b\xac",
	"2-81-90" => "\xf0\xa5\x84\xa2",	
	"2-81-91" => "\xe7\x9c\x97",
	"2-81-92" => "\xe7\x9c\x9a",
	"2-81-93" => "\xe7\x9c\xad",
	"2-81-94" => "\xe7\x9c\xb5",
	"2-82-1" => "\xf0\xa5\x86\xa9",	
	"2-82-2" => "\xe4\x80\xb9",
	"2-82-3" => "\xf0\xa5\x87\xa5",	
	"2-82-4" => "\xf0\xa5\x87\x8d",	
	"2-82-5" => "\xe7\x9d\x98",
	"2-82-6" => "\xe7\x9d\xa0",
	"2-82-7" => "\xe7\x9d\xaa",
	"2-82-8" => "\xf0\xa5\x88\x9e",	
	"2-82-9" => "\xe7\x9d\xb2",
	"2-82-10" => "\xe7\x9d\xbc",
	"2-82-11" => "\xe7\x9d\xbd",
	"2-82-12" => "\xf0\xa5\x89\x8c",	
	"2-82-13" => "\xe4\x81\x98",
	"2-82-14" => "\xe7\x9e\x9a",
	"2-82-15" => "\xe7\x9e\x9f",
	"2-82-16" => "\xe7\x9e\xa2",
	"2-82-17" => "\xe7\x9e\xa4",
	"2-82-18" => "\xe7\x9e\xa9",
	"2-82-19" => "\xe7\x9f\x9e",
	"2-82-20" => "\xe7\x9f\x9f",
	"2-82-21" => "\xe7\x9f\xa4",
	"2-82-22" => "\xe7\x9f\xa6",
	"2-82-23" => "\xe7\x9f\xaa",
	"2-82-24" => "\xe7\x9f\xac",
	"2-82-25" => "\xe4\x82\x93",
	"2-82-26" => "\xe7\x9f\xb0",
	"2-82-27" => "\xe7\x9f\xb4",
	"2-82-28" => "\xe7\x9f\xbb",
	"2-82-29" => "\xf0\xa5\x90\xae",	
	"2-82-30" => "\xe7\xa0\x85",
	"2-82-31" => "\xe7\xa0\x86",
	"2-82-32" => "\xe7\xa0\x89",
	"2-82-33" => "\xe7\xa0\x8d",
	"2-82-34" => "\xe7\xa0\x99",
	"2-82-35" => "\xe7\xa0\xa1",
	"2-82-36" => "\xe7\xa0\xac",
	"2-82-37" => "\xe7\xa1\x87",
	"2-82-38" => "\xe7\xa1\xa4",
	"2-82-39" => "\xe7\xa1\xaa",
	"2-82-40" => "\xf0\xa5\x93\x99",	
	"2-82-41" => "\xe7\xa2\x8a",
	"2-82-42" => "\xe7\xa2\x94",
	"2-82-43" => "\xe7\xa2\xa4",
	"2-82-44" => "\xe7\xa2\x9d",
	"2-82-45" => "\xe7\xa2\x9e",
	"2-82-46" => "\xe7\xa2\x9f",
	"2-82-47" => "\xe7\xa2\xbb",
	"2-82-48" => "\xe7\xa3\x88",
	"2-82-49" => "\xe7\xa3\x8c",
	"2-82-50" => "\xe7\xa3\x8e",
	"2-82-51" => "\xe7\xa3\x95",
	"2-82-52" => "\xe7\xa3\xa0",
	"2-82-53" => "\xe7\xa3\xa1",
	"2-82-54" => "\xe7\xa3\xa6",
	"2-82-55" => "\xe7\xa3\xb9",
	"2-82-56" => "\xe7\xa3\xba",
	"2-82-57" => "\xe7\xa3\xbb",
	"2-82-58" => "\xe7\xa3\xbe",
	"2-82-59" => "\xf0\xa5\x96\xa7",	
	"2-82-60" => "\xe7\xa4\x90",
	"2-82-61" => "\xe7\xa4\x9b",
	"2-82-62" => "\xe7\xa4\xb0",
	"2-82-63" => "\xe7\xa4\xa5",
	"2-82-64" => "\xe7\xa4\xbb",
	"2-82-65" => "\xe7\xa5\x8a",
	"2-82-66" => "\xe7\xa5\x98",
	"2-82-67" => "\xe7\xa5\x9b",
	"2-82-68" => "\xe4\x84\x85",
	"2-82-69" => "\xe7\xa5\xa7",
	"2-82-70" => "\xe7\xa5\xb2",
	"2-82-71" => "\xe7\xa6\x94",
	"2-82-72" => "\xe7\xa6\x95",
	"2-82-73" => "\xe7\xa6\x96",
	"2-82-74" => "\xe7\xa6\x9b",
	"2-82-75" => "\xe7\xa6\xa1",
	"2-82-76" => "\xe7\xa6\xa9",
	"2-82-77" => "\xe7\xa6\xb4",
	"2-82-78" => "\xe7\xa6\xbb",
	"2-82-79" => "\xe7\xa7\x82",
	"2-82-80" => "\xe7\xa7\x87",
	"2-82-81" => "\xe7\xa7\x8c",
	"2-82-82" => "\xe7\xa7\x8d",
	"2-82-83" => "\xe7\xa7\x96",
	"2-82-84" => "\xe4\x85\x88",
	"2-82-85" => "\xf0\xa5\x9e\xa9",	
	"2-82-86" => "\xf0\xa5\x9e\xb4",	
	"2-82-87" => "\xe4\x85\x8f",
	"2-82-88" => "\xe7\xa8\x8a",
	"2-82-89" => "\xe7\xa8\x91",
	"2-82-90" => "\xe7\xa8\x95",
	"2-82-91" => "\xe7\xa8\x9b",
	"2-82-92" => "\xe7\xa8\x9e",
	"2-82-93" => "\xe4\x85\xa3",
	"2-82-94" => "\xe7\xa8\xad",
	"2-83-1" => "\xe7\xa8\xb8",
	"2-83-2" => "\xe7\xa9\x87",
	"2-83-3" => "\xe7\xa9\x8c",
	"2-83-4" => "\xe7\xa9\x96",
	"2-83-5" => "\xe7\xa9\x99",
	"2-83-6" => "\xe7\xa9\x9c",
	"2-83-7" => "\xe7\xa9\x9f",
	"2-83-8" => "\xe7\xa9\xa0",
	"2-83-9" => "\xe7\xa9\xa7",
	"2-83-10" => "\xe7\xa9\xaa",
	"2-83-11" => "\xe7\xa9\xb5",
	"2-83-12" => "\xe7\xa9\xb8",
	"2-83-13" => "\xe7\xaa\x82",
	"2-83-14" => "\xe7\xaa\x8a",
	"2-83-15" => "\xe7\xaa\x90",
	"2-83-16" => "\xe7\xaa\xa3",
	"2-83-17" => "\xe7\xaa\xac",
	"2-83-18" => "\xf0\xa5\xa7\x94",	
	"2-83-19" => "\xe4\x86\xb4",
	"2-83-20" => "\xe7\xaa\xb9",
	"2-83-21" => "\xe7\xaa\xbc",
	"2-83-22" => "\xe7\xaa\xbe",
	"2-83-23" => "\xe4\x86\xbf",
	"2-83-24" => "\xe7\xab\x8c",
	"2-83-25" => "\xe7\xab\x91",
	"2-83-26" => "\xe7\xab\xa7",
	"2-83-27" => "\xe7\xab\xa8",
	"2-83-28" => "\xe7\xab\xb4",
	"2-83-29" => "\xf0\xa5\xab\xa4",	
	"2-83-30" => "\xf0\xa5\xab\xa3",	
	"2-83-31" => "\xe7\xac\x87",
	"2-83-32" => "\xf0\xa5\xab\xb1",	
	"2-83-33" => "\xe7\xac\xbd",
	"2-83-34" => "\xe7\xac\xa7",
	"2-83-35" => "\xe7\xac\xaa",
	"2-83-36" => "\xe7\xac\xae",
	"2-83-37" => "\xe7\xac\xaf",
	"2-83-38" => "\xe7\xac\xb1",
	"2-83-39" => "\xe4\x87\xa6",
	"2-83-40" => "\xe4\x87\xb3",
	"2-83-41" => "\xe7\xad\xbf",
	"2-83-42" => "\xe7\xad\x81",
	"2-83-43" => "\xe4\x87\xae",
	"2-83-44" => "\xe7\xad\x95",
	"2-83-45" => "\xe7\xad\xb9",
	"2-83-46" => "\xe7\xad\xa4",
	"2-83-47" => "\xe7\xad\xa6",
	"2-83-48" => "\xe7\xad\xa9",
	"2-83-49" => "\xe7\xad\xb3",
	"2-83-50" => "\xf0\xa5\xae\xb2",	
	"2-83-51" => "\xe4\x88\x87",
	"2-83-52" => "\xe7\xae\x90",
	"2-83-53" => "\xe7\xae\x91",
	"2-83-54" => "\xe7\xae\x9b",
	"2-83-55" => "\xe4\x88\x8e",
	"2-83-56" => "\xe7\xae\xaf",
	"2-83-57" => "\xe7\xae\xb5",
	"2-83-58" => "\xe7\xae\xbc",
	"2-83-59" => "\xe7\xaf\x85",
	"2-83-60" => "\xe7\xaf\x8a",
	"2-83-61" => "\xf0\xa5\xb1\x8b",	
	"2-83-62" => "\xf0\xa5\xb1\xa4",	
	"2-83-63" => "\xe7\xaf\x94",
	"2-83-64" => "\xe7\xaf\x96",
	"2-83-65" => "\xe7\xaf\x9a",
	"2-83-66" => "\xe7\xaf\xaa",
	"2-83-67" => "\xe7\xaf\xb0",
	"2-83-68" => "\xe7\xb0\x83",
	"2-83-69" => "\xe7\xb0\x8b",
	"2-83-70" => "\xe7\xb0\x8e",
	"2-83-71" => "\xe7\xb0\x8f",
	"2-83-72" => "\xe7\xb0\xa6",
	"2-83-73" => "\xe7\xb1\x85",
	"2-83-74" => "\xe7\xb1\x8a",
	"2-83-75" => "\xe7\xb1\x91",
	"2-83-76" => "\xe7\xb1\x97",
	"2-83-77" => "\xe7\xb1\x9e",
	"2-83-78" => "\xe7\xb1\xa1",
	"2-83-79" => "\xe7\xb1\xa9",
	"2-83-80" => "\xe7\xb1\xae",
	"2-83-81" => "\xe7\xb1\xaf",
	"2-83-82" => "\xe7\xb1\xb0",
	"2-83-83" => "\xf0\xa5\xb8\xae",	
	"2-83-84" => "\xf0\xa5\xb9\x96",	
	"2-83-85" => "\xf0\xa5\xb9\xa5",	
	"2-83-86" => "\xe7\xb2\xa6",
	"2-83-87" => "\xf0\xa5\xb9\xa2",	
	"2-83-88" => "\xe7\xb2\xb6",
	"2-83-89" => "\xe7\xb2\xb7",
	"2-83-90" => "\xe7\xb2\xbf",
	"2-83-91" => "\xf0\xa5\xbb\x98",	
	"2-83-92" => "\xe7\xb3\x84",
	"2-83-93" => "\xf0\xa5\xbb\x82",	
	"2-83-94" => "\xe7\xb3\x88",
	"2-84-1" => "\xe7\xb3\x8d",
	"2-84-2" => "\xf0\xa5\xbb\xa8",	
	"2-84-3" => "\xe7\xb3\x97",
	"2-84-4" => "\xf0\xa5\xbc\xa3",	
	"2-84-5" => "\xe7\xb3\xa6",
	"2-84-6" => "\xe7\xb3\xab",
	"2-84-7" => "\xf0\xa5\xbd\x9c",	
	"2-84-8" => "\xe7\xb3\xb5",
	"2-84-9" => "\xe7\xb4\x83",
	"2-84-10" => "\xe7\xb4\x89",
	"2-84-11" => "\xe4\x8b\x86",
	"2-84-12" => "\xe7\xb4\x92",
	"2-84-13" => "\xe7\xb4\x9e",
	"2-84-14" => "\xf0\xa5\xbf\xa0",	
	"2-84-15" => "\xf0\xa5\xbf\x94",	
	"2-84-16" => "\xe7\xb4\xbd",
	"2-84-17" => "\xe7\xb4\xbe",
	"2-84-18" => "\xe7\xb5\x80",
	"2-84-19" => "\xe7\xb5\x87",
	"2-84-20" => "\xf0\xa6\x80\x8c",	
	"2-84-21" => "\xf0\xa5\xbf\xbb",	
	"2-84-22" => "\xe4\x8b\x96",
	"2-84-23" => "\xe7\xb5\x99",
	"2-84-24" => "\xe7\xb5\x9a",
	"2-84-25" => "\xe7\xb5\xaa",
	"2-84-26" => "\xe7\xb5\xb0",
	"2-84-27" => "\xe4\x8b\x9d",
	"2-84-28" => "\xe7\xb5\xbf",
	"2-84-29" => "\xf0\xa6\x80\x97",	
	"2-84-30" => "\xe7\xb6\x86",
	"2-84-31" => "\xe7\xb6\x88",
	"2-84-32" => "\xe7\xb6\x8c",
	"2-84-33" => "\xe7\xb6\x97",
	"2-84-34" => "\xf0\xa6\x81\xa0",	
	"2-84-35" => "\xe7\xb6\x9d",
	"2-84-36" => "\xe7\xb6\xa7",
	"2-84-37" => "\xe7\xb6\xaa",
	"2-84-38" => "\xe7\xb6\xb6",
	"2-84-39" => "\xe7\xb6\xb7",
	"2-84-40" => "\xe7\xb7\x80",
	"2-84-41" => "\xe7\xb7\x97",
	"2-84-42" => "\xe7\xb7\x99",
	"2-84-43" => "\xe7\xb7\xa6",
	"2-84-44" => "\xe7\xb7\xb1",
	"2-84-45" => "\xe7\xb7\xb9",
	"2-84-46" => "\xe4\x8c\x82",
	"2-84-47" => "\xf0\xa6\x83\xad",	
	"2-84-48" => "\xe7\xb8\x89",	
	"2-84-49" => "\xe7\xb8\x90",
	"2-84-50" => "\xe7\xb8\x97",
	"2-84-51" => "\xe7\xb8\x9d",
	"2-84-52" => "\xe7\xb8\xa0",
	"2-84-53" => "\xe7\xb8\xa7",
	"2-84-54" => "\xe7\xb8\xac",
	"2-84-55" => "\xe7\xb9\x85",
	"2-84-56" => "\xe7\xb9\xb3",
	"2-84-57" => "\xe7\xb9\xb5",
	"2-84-58" => "\xe7\xb9\xbe",
	"2-84-59" => "\xe7\xba\x86",
	"2-84-60" => "\xe7\xba\x87",
	"2-84-61" => "\xe4\x8c\xab",
	"2-84-62" => "\xe7\xba\x91",
	"2-84-63" => "\xe7\xba\x98",
	"2-84-64" => "\xe7\xba\x9a",
	"2-84-65" => "\xe4\x8d\x83",
	"2-84-66" => "\xe7\xbc\xbc",
	"2-84-67" => "\xe7\xbc\xbb",
	"2-84-68" => "\xe7\xbc\xbe",
	"2-84-69" => "\xe7\xbd\x83",
	"2-84-70" => "\xe7\xbd\x84",
	"2-84-71" => "\xe7\xbd\x8f",
	"2-84-72" => "\xe3\x93\x81",
	"2-84-73" => "\xf0\xa6\x89\xb0",	
	"2-84-74" => "\xe7\xbd\x92",
	"2-84-75" => "\xf0\xa6\x8a\x86",	
	"2-84-76" => "\xe7\xbd\xa1",
	"2-84-77" => "\xe7\xbd\xa3",
	"2-84-78" => "\xe7\xbd\xa4",
	"2-84-79" => "\xe7\xbd\xad",
	"2-84-80" => "\xe7\xbd\xbd",
	"2-84-81" => "\xe7\xbd\xbe",
	"2-84-82" => "\xf0\xa6\x8d\x8c",	
	"2-84-83" => "\xe7\xbe\x90",
	"2-84-84" => "\xe5\x85\xbb",
	"2-84-85" => "\xf0\xa3\xb4\x8e",	
	"2-84-86" => "\xe7\xbe\x96",
	"2-84-87" => "\xe7\xbe\x9c",
	"2-84-88" => "\xe7\xbe\xad",
	"2-84-89" => "\xf0\xa6\x90\x82",	
	"2-84-90" => "\xe7\xbf\x83",
	"2-84-91" => "\xe7\xbf\x8f",
	"2-84-92" => "\xe7\xbf\xa3",
	"2-84-93" => "\xe7\xbf\xa5",
	"2-84-94" => "\xe7\xbf\xaf",
	"2-85-1" => "\xe7\xbf\xb2",
	"2-85-2" => "\xe8\x80\x82",
	"2-85-3" => "\xe8\x80\x8a",
	"2-85-4" => "\xe8\x80\x88",
	"2-85-5" => "\xe8\x80\x8e",
	"2-85-6" => "\xe8\x80\x91",
	"2-85-7" => "\xe8\x80\x96",
	"2-85-8" => "\xe8\x80\xa4",
	"2-85-9" => "\xe8\x80\xac",
	"2-85-10" => "\xe8\x80\xb0",
	"2-85-11" => "\xe8\x81\x83",
	"2-85-12" => "\xe8\x81\xa6",
	"2-85-13" => "\xe8\x81\xb1",
	"2-85-14" => "\xe8\x81\xb5",
	"2-85-15" => "\xe8\x81\xbb",
	"2-85-16" => "\xe8\x82\x99",
	"2-85-17" => "\xe8\x82\x9c",
	"2-85-18" => "\xe8\x82\xa4",
	"2-85-19" => "\xe8\x82\xa7",
	"2-85-20" => "\xe8\x82\xb8",
	"2-85-21" => "\xf0\xa6\x99\xbe",	
	"2-85-22" => "\xe8\x83\x85",
	"2-85-23" => "\xe8\x83\x95",
	"2-85-24" => "\xe8\x83\x98",
	"2-85-25" => "\xe8\x83\xa6",
	"2-85-26" => "\xf0\xa6\x9a\xb0",	
	"2-85-27" => "\xe8\x84\x8d",
	"2-85-28" => "\xe8\x83\xb5",
	"2-85-29" => "\xe8\x83\xbb",
	"2-85-30" => "\xe4\x8f\xae",
	"2-85-31" => "\xe8\x84\xb5",
	"2-85-32" => "\xe8\x84\x96",
	"2-85-33" => "\xe8\x84\x9e",
	"2-85-34" => "\xe4\x8f\xb0",
	"2-85-35" => "\xe8\x84\xa4",
	"2-85-36" => "\xe8\x84\xa7",
	"2-85-37" => "\xe8\x84\xac",
	"2-85-38" => "\xf0\xa6\x9c\x9d",	
	"2-85-39" => "\xe8\x84\xbd",
	"2-85-40" => "\xe4\x90\x88",
	"2-85-41" => "\xe8\x85\xa9",
	"2-85-42" => "\xe4\x90\x97",
	"2-85-43" => "\xe8\x86\x81",
	"2-85-44" => "\xe4\x90\x9c",
	"2-85-45" => "\xe8\x86\x84",
	"2-85-46" => "\xe8\x86\x85",
	"2-85-47" => "\xe4\x90\xa2",
	"2-85-48" => "\xe8\x86\x98",
	"2-85-49" => "\xe8\x86\xb2",
	"2-85-50" => "\xe8\x87\x81",
	"2-85-51" => "\xe8\x87\x83",
	"2-85-52" => "\xe8\x87\x96",
	"2-85-53" => "\xe8\x87\x9b",
	"2-85-54" => "\xf0\xa6\xa3\x9d",	
	"2-85-55" => "\xe8\x87\xa4",
	"2-85-56" => "\xf0\xa6\xa3\xaa",	
	"2-85-57" => "\xe8\x87\xac",
	"2-85-58" => "\xf0\xa6\xa5\x91",	
	"2-85-59" => "\xe8\x87\xbd",
	"2-85-60" => "\xe8\x87\xbf",
	"2-85-61" => "\xf0\xa6\xa5\xaf",	
	"2-85-62" => "\xe8\x88\x84",
	"2-85-63" => "\xf0\xa6\xa7\x9d",	
	"2-85-64" => "\xe8\x88\x99",
	"2-85-65" => "\xe8\x88\xa1",
	"2-85-66" => "\xe8\x88\xa2",
	"2-85-67" => "\xf0\xa6\xa8\x9e",	
	"2-85-68" => "\xe8\x88\xb2",
	"2-85-69" => "\xe8\x88\xb4",
	"2-85-70" => "\xe8\x88\xbc",
	"2-85-71" => "\xe8\x89\x86",
	"2-85-72" => "\xe8\x89\x89",
	"2-85-73" => "\xe8\x89\x85",
	"2-85-74" => "\xf0\xa6\xa9\x98",	
	"2-85-75" => "\xe8\x89\x8b",
	"2-85-76" => "\xe4\x91\xb6",
	"2-85-77" => "\xe8\x89\x8f",
	"2-85-78" => "\xe4\x91\xba",
	"2-85-79" => "\xe8\x89\x97",
	"2-85-80" => "\xf0\xa6\xaa\x8c",	
	"2-85-81" => "\xe8\x89\x9c",
	"2-85-82" => "\xe8\x89\xa3",
	"2-85-83" => "\xf0\xa6\xaa\xb7",	
	"2-85-84" => "\xe8\x89\xb9",	
	"2-85-85" => "\xe8\x89\xb9",	
	"2-85-86" => "\xe8\x89\xb9",
	"2-85-87" => "\xe4\x92\x91",
	"2-85-88" => "\xe8\x89\xbd",
	"2-85-89" => "\xe8\x89\xbf",
	"2-85-90" => "\xe8\x8a\x83",
	"2-85-91" => "\xe8\x8a\x8a",
	"2-85-92" => "\xe8\x8a\x93",
	"2-85-93" => "\xe8\x8a\xa7",
	"2-85-94" => "\xe8\x8a\xa8",
	"2-86-1" => "\xe8\x8a\xb2",
	"2-86-2" => "\xe8\x8a\xb4",
	"2-86-3" => "\xe8\x8a\xba",
	"2-86-4" => "\xe8\x8a\xbc",
	"2-86-5" => "\xe8\x8b\xa2",
	"2-86-6" => "\xe8\x8b\xa8",
	"2-86-7" => "\xe8\x8b\xb7",
	"2-86-8" => "\xe8\x8c\x87",
	"2-86-9" => "\xe8\x8c\x88",
	"2-86-10" => "\xe8\x8c\x8c",
	"2-86-11" => "\xe8\x8d\x94",
	"2-86-12" => "\xe8\x8c\x9b",
	"2-86-13" => "\xe8\x8c\x9d",
	"2-86-14" => "\xe8\x8c\xb0",
	"2-86-15" => "\xe8\x8c\xbc",
	"2-86-16" => "\xe8\x8d\x84",
	"2-86-17" => "\xe8\x8d\x97",
	"2-86-18" => "\xe4\x92\xbe",
	"2-86-19" => "\xe8\x8d\xbf",
	"2-86-20" => "\xe4\x93\x94",
	"2-86-21" => "\xe4\x92\xb3",
	"2-86-22" => "\xe8\x8e\x8d",
	"2-86-23" => "\xe8\x8e\x94",
	"2-86-24" => "\xe8\x8e\x95",
	"2-86-25" => "\xe8\x8e\x9b",
	"2-86-26" => "\xe8\x8e\x9d",
	"2-86-27" => "\xe8\x8f\x89",
	"2-86-28" => "\xe8\x8f\x90",
	"2-86-29" => "\xe8\x8f\x94",
	"2-86-30" => "\xe8\x8f\x9d",
	"2-86-31" => "\xe8\x8f\xa5",
	"2-86-32" => "\xe8\x8f\xb9",
	"2-86-33" => "\xe8\x90\x8f",
	"2-86-34" => "\xe8\x90\x91",
	"2-86-35" => "\xe8\x90\x95",
	"2-86-36" => "\xf0\xa6\xb1\xb3",	
	"2-86-37" => "\xe8\x90\x97",
	"2-86-38" => "\xe8\x90\xb9",
	"2-86-39" => "\xe8\x91\x8a",
	"2-86-40" => "\xe8\x91\x8f",
	"2-86-41" => "\xe8\x91\x91",
	"2-86-42" => "\xe8\x91\x92",
	"2-86-43" => "\xe8\x91\x99",
	"2-86-44" => "\xe8\x91\x9a",
	"2-86-45" => "\xe8\x91\x9c",
	"2-86-46" => "\xf0\xa6\xb3\x9d",	
	"2-86-47" => "\xe8\x91\xa5",
	"2-86-48" => "\xe8\x91\xb6",
	"2-86-49" => "\xe8\x91\xb8",
	"2-86-50" => "\xe8\x91\xbc",
	"2-86-51" => "\xe8\x92\x81",
	"2-86-52" => "\xe4\x94\x8d",
	"2-86-53" => "\xe8\x93\x9c",
	"2-86-54" => "\xe8\x92\x97",
	"2-86-55" => "\xe8\x92\xa6",
	"2-86-56" => "\xe8\x92\xbe",
	"2-86-57" => "\xe4\x94\x88",
	"2-86-58" => "\xe8\x93\x8e",
	"2-86-59" => "\xe8\x93\x8f",
	"2-86-60" => "\xe8\x93\x93",
	"2-86-61" => "\xf0\xa6\xb9\xa5",	
	"2-86-62" => "\xe8\x93\xa7",
	"2-86-63" => "\xe8\x93\xaa",
	"2-86-64" => "\xe8\x93\xaf",
	"2-86-65" => "\xe8\x93\xb0",
	"2-86-66" => "\xe8\x93\xb1",
	"2-86-67" => "\xe8\x93\xba",
	"2-86-68" => "\xe8\x93\xbd",
	"2-86-69" => "\xe8\x94\x8c",
	"2-86-70" => "\xe8\x94\x9b",
	"2-86-71" => "\xe8\x94\xa4",
	"2-86-72" => "\xe8\x94\xa5",
	"2-86-73" => "\xe8\x94\xab",
	"2-86-74" => "\xe8\x94\xb4",
	"2-86-75" => "\xe8\x95\x8f",
	"2-86-76" => "\xe8\x95\xaf",
	"2-86-77" => "\xe4\x94\xa5",
	"2-86-78" => "\xe4\x95\x83",
	"2-86-79" => "\xe8\x94\xbe",
	"2-86-80" => "\xe8\x95\x91",
	"2-86-81" => "\xe8\x95\x93",
	"2-86-82" => "\xe8\x95\x9e",
	"2-86-83" => "\xe8\x95\xa1",
	"2-86-84" => "\xe8\x95\xa2",
	"2-86-85" => "\xf0\xa6\xbe\x94",	
	"2-86-86" => "\xe8\x95\xbb",
	"2-86-87" => "\xe8\x95\xbd",
	"2-86-88" => "\xe8\x95\xbf",
	"2-86-89" => "\xe8\x96\x81",
	"2-86-90" => "\xe8\x96\x86",
	"2-86-91" => "\xe8\x96\x93",
	"2-86-92" => "\xe8\x96\x9d",
	"2-86-93" => "\xe8\x96\x9f",
	"2-86-94" => "\xf0\xa6\xbf\xb8",	
	"2-87-1" => "\xf0\xa6\xbf\xb6",	
	"2-87-2" => "\xf0\xa6\xbf\xb7",	
	"2-87-3" => "\xe8\x96\xb7",
	"2-87-4" => "\xe8\x96\xbc",
	"2-87-5" => "\xe8\x97\x87",
	"2-87-6" => "\xe8\x97\x8a",
	"2-87-7" => "\xe8\x97\x98",
	"2-87-8" => "\xe8\x97\x99",
	"2-87-9" => "\xe8\x97\x9f",
	"2-87-10" => "\xe8\x97\xa1",
	"2-87-11" => "\xe8\x97\xa6",
	"2-87-12" => "\xe8\x97\xb6",
	"2-87-13" => "\xe8\x98\x80",
	"2-87-14" => "\xe8\x98\x91",
	"2-87-15" => "\xe8\x98\x9e",
	"2-87-16" => "\xe8\x98\xa1",
	"2-87-17" => "\xe8\x98\xa4",
	"2-87-18" => "\xe8\x98\xa7",
	"2-87-19" => "\xf0\xa7\x84\x8d",	
	"2-87-20" => "\xe8\x98\xb9",
	"2-87-21" => "\xe8\x98\xbc",
	"2-87-22" => "\xf0\xa7\x84\xb9",	
	"2-87-23" => "\xe8\x99\x80",
	"2-87-24" => "\xef\xa8\xa0",
	"2-87-25" => "\xe8\x99\x93",
	"2-87-26" => "\xe8\x99\x96",
	"2-87-27" => "\xe8\x99\xaf",
	"2-87-28" => "\xe8\x99\xb7",
	"2-87-29" => "\xe8\x99\xba",
	"2-87-30" => "\xe8\x9a\x87",
	"2-87-31" => "\xe8\x9a\x89",
	"2-87-32" => "\xe8\x9a\x8d",
	"2-87-33" => "\xe8\x9a\x91",
	"2-87-34" => "\xe8\x9a\x9c",
	"2-87-35" => "\xe8\x9a\x9d",
	"2-87-36" => "\xe8\x9a\xa8",
	"2-87-37" => "\xef\xa8\xa1",
	"2-87-38" => "\xe8\x9a\xb1",
	"2-87-39" => "\xe8\x9a\xb3",
	"2-87-40" => "\xe8\x9b\x81",
	"2-87-41" => "\xe8\x9b\x83",
	"2-87-42" => "\xe8\x9b\x91",
	"2-87-43" => "\xe8\x9b\x95",
	"2-87-44" => "\xe8\x9b\x97",
	"2-87-45" => "\xe8\x9b\xa3",
	"2-87-46" => "\xe8\x9b\xa6",
	"2-87-47" => "\xe4\x96\xb8",
	"2-87-48" => "\xe8\x9c\x85",
	"2-87-49" => "\xe8\x9c\x87",
	"2-87-50" => "\xe8\x9c\x8e",
	"2-87-51" => "\xe8\x9c\x90",
	"2-87-52" => "\xe8\x9c\x93",
	"2-87-53" => "\xe8\x9c\x99",
	"2-87-54" => "\xe8\x9c\x9f",
	"2-87-55" => "\xe8\x9c\xa1",
	"2-87-56" => "\xe8\x9c\xa3",
	"2-87-57" => "\xe8\x9c\xb1",
	"2-87-58" => "\xe8\x9c\xba",
	"2-87-59" => "\xe8\x9c\xbe",
	"2-87-60" => "\xe8\x9d\x80",
	"2-87-61" => "\xe8\x9d\x83",
	"2-87-62" => "\xe8\x9d\x91",
	"2-87-63" => "\xe8\x9d\x98",
	"2-87-64" => "\xe8\x9d\xa4",
	"2-87-65" => "\xe8\x9d\xa5",
	"2-87-66" => "\xe8\x9d\xb2",
	"2-87-67" => "\xe8\x9d\xbc",
	"2-87-68" => "\xf0\xa7\x8f\x9b",	
	"2-87-69" => "\xf0\xa7\x8f\x9a",	
	"2-87-70" => "\xe8\x9e\xa7",
	"2-87-71" => "\xe8\x9e\x89",
	"2-87-72" => "\xe8\x9e\x8b",
	"2-87-73" => "\xe8\x9e\x93",
	"2-87-74" => "\xe8\x9e\xa0",
	"2-87-75" => "\xf0\xa7\x8f\xbe",	
	"2-87-76" => "\xe4\x97\xa5",
	"2-87-77" => "\xe8\x9e\xbe",
	"2-87-78" => "\xf0\xa7\x90\x90",	
	"2-87-79" => "\xe8\x9f\x81",
	"2-87-80" => "\xe8\x9f\x8e",
	"2-87-81" => "\xe8\x9f\xb5",
	"2-87-82" => "\xe8\x9f\x9f",
	"2-87-83" => "\xf0\xa7\x91\x89",	
	"2-87-84" => "\xe8\x9f\xa3",
	"2-87-85" => "\xe8\x9f\xa5",
	"2-87-86" => "\xe8\x9f\xa6",
	"2-87-87" => "\xe8\x9f\xaa",
	"2-87-88" => "\xe8\x9f\xab",
	"2-87-89" => "\xe8\x9f\xad",
	"2-87-90" => "\xe8\xa0\x81",
	"2-87-91" => "\xe8\xa0\x83",
	"2-87-92" => "\xe8\xa0\x8b",
	"2-87-93" => "\xe8\xa0\x93",
	"2-87-94" => "\xe8\xa0\xa8",
	"2-88-1" => "\xe8\xa0\xae",
	"2-88-2" => "\xe8\xa0\xb2",
	"2-88-3" => "\xe8\xa0\xbc",
	"2-88-4" => "\xe4\x98\x8f",
	"2-88-5" => "\xe8\xa1\x8a",
	"2-88-6" => "\xe8\xa1\x98",
	"2-88-7" => "\xe8\xa1\x9f",
	"2-88-8" => "\xe8\xa1\xa4",
	"2-88-9" => "\xf0\xa7\x98\x95",	
	"2-88-10" => "\xf0\xa7\x98\x94",	
	"2-88-11" => "\xe8\xa1\xa9",
	"2-88-12" => "\xf0\xa7\x98\xb1",	
	"2-88-13" => "\xe8\xa1\xaf",
	"2-88-14" => "\xe8\xa2\xa0",
	"2-88-15" => "\xe8\xa2\xbc",
	"2-88-16" => "\xe8\xa2\xbd",
	"2-88-17" => "\xe8\xa2\xbe",
	"2-88-18" => "\xe8\xa3\x80",
	"2-88-19" => "\xe8\xa3\x92",
	"2-88-20" => "\xf0\xa7\x9a\x93",	
	"2-88-21" => "\xe8\xa3\x91",
	"2-88-22" => "\xe8\xa3\x93",
	"2-88-23" => "\xe8\xa3\x9b",
	"2-88-24" => "\xe8\xa3\xb0",
	"2-88-25" => "\xe8\xa3\xb1",
	"2-88-26" => "\xe4\x99\x81",
	"2-88-27" => "\xe8\xa4\x81",
	"2-88-28" => "\xf0\xa7\x9c\x8e",	
	"2-88-29" => "\xe8\xa4\xb7",
	"2-88-30" => "\xf0\xa7\x9c\xa3",	
	"2-88-31" => "\xe8\xa5\x82",
	"2-88-32" => "\xe8\xa5\x85",
	"2-88-33" => "\xe8\xa5\x89",
	"2-88-34" => "\xf0\xa7\x9d\x92",	
	"2-88-35" => "\xe4\x99\xa5",
	"2-88-36" => "\xe8\xa5\xa2",
	"2-88-37" => "\xe8\xa6\x80",
	"2-88-38" => "\xe8\xa6\x89",
	"2-88-39" => "\xe8\xa6\x90",
	"2-88-40" => "\xe8\xa6\x9f",
	"2-88-41" => "\xe8\xa6\xb0",
	"2-88-42" => "\xe8\xa6\xb7",
	"2-88-43" => "\xe8\xa7\x96",
	"2-88-44" => "\xe8\xa7\x98",
	"2-88-45" => "\xe8\xa7\xab",
	"2-88-46" => "\xe4\x9a\xa1",
	"2-88-47" => "\xe8\xa7\xb1",
	"2-88-48" => "\xe8\xa7\xb3",
	"2-88-49" => "\xe8\xa7\xbd",
	"2-88-50" => "\xe8\xa7\xbf",
	"2-88-51" => "\xe4\x9a\xaf",
	"2-88-52" => "\xe8\xa8\x91",
	"2-88-53" => "\xe8\xa8\x94",
	"2-88-54" => "\xf0\xa7\xa6\x85",	
	"2-88-55" => "\xe8\xa8\xa1",
	"2-88-56" => "\xe8\xa8\xb5",
	"2-88-57" => "\xe8\xa8\xbe",
	"2-88-58" => "\xe8\xa9\x85",
	"2-88-59" => "\xe8\xa9\x8d",
	"2-88-60" => "\xe8\xa9\x98",
	"2-88-61" => "\xe8\xaa\xae",
	"2-88-62" => "\xe8\xaa\x90",
	"2-88-63" => "\xe8\xaa\xb7",
	"2-88-64" => "\xe8\xaa\xbe",
	"2-88-65" => "\xe8\xab\x97",
	"2-88-66" => "\xe8\xab\xbc",
	"2-88-67" => "\xf0\xa7\xaa\x84",	
	"2-88-68" => "\xe8\xac\x8a",
	"2-88-69" => "\xe8\xac\x85",
	"2-88-70" => "\xe8\xac\x8d",
	"2-88-71" => "\xe8\xac\x9c",
	"2-88-72" => "\xe8\xac\x9f",
	"2-88-73" => "\xe8\xac\xad",
	"2-88-74" => "\xe8\xad\x83",
	"2-88-75" => "\xe4\x9c\x8c",
	"2-88-76" => "\xe8\xad\x91",
	"2-88-77" => "\xe8\xad\x9e",
	"2-88-78" => "\xe8\xad\xb6",
	"2-88-79" => "\xe8\xad\xbf",
	"2-88-80" => "\xe8\xae\x81",
	"2-88-81" => "\xe8\xae\x8b",
	"2-88-82" => "\xe8\xae\x94",
	"2-88-83" => "\xe8\xae\x95",
	"2-88-84" => "\xe8\xae\x9c",
	"2-88-85" => "\xe8\xae\x9e",
	"2-88-86" => "\xe8\xb0\xb9",
	"2-88-87" => "\xf0\xa7\xae\xb3",	
	"2-88-88" => "\xe8\xb0\xbd",
	"2-88-89" => "\xf0\xa7\xae\xbe",	
	"2-88-90" => "\xf0\xa7\xaf\x87",	
	"2-88-91" => "\xe8\xb1\x85",
	"2-88-92" => "\xe8\xb1\x87",
	"2-88-93" => "\xe8\xb1\x8f",
	"2-88-94" => "\xe8\xb1\x94",
	"2-89-1" => "\xe8\xb1\x97",
	"2-89-2" => "\xe8\xb1\xa9",
	"2-89-3" => "\xe8\xb1\xad",
	"2-89-4" => "\xe8\xb1\xb3",
	"2-89-5" => "\xf0\xa7\xb2\xb8",	
	"2-89-6" => "\xe8\xb2\x93",
	"2-89-7" => "\xe8\xb2\x92",
	"2-89-8" => "\xe8\xb2\x99",
	"2-89-9" => "\xe4\x9d\xa4",
	"2-89-10" => "\xe8\xb2\x9b",
	"2-89-11" => "\xe8\xb2\xa4",
	"2-89-12" => "\xe8\xb3\x96",
	"2-89-13" => "\xe8\xb3\x95",
	"2-89-14" => "\xe8\xb3\x99",
	"2-89-15" => "\xf0\xa7\xb6\xa0",	
	"2-89-16" => "\xe8\xb3\xb0",
	"2-89-17" => "\xe8\xb3\xb1",
	"2-89-18" => "\xf0\xa7\xb8\x90",	
	"2-89-19" => "\xe8\xb4\x89",
	"2-89-20" => "\xe8\xb4\x8e",
	"2-89-21" => "\xe8\xb5\xac",
	"2-89-22" => "\xe8\xb6\x84",
	"2-89-23" => "\xe8\xb6\x95",
	"2-89-24" => "\xe8\xb6\xa6",
	"2-89-25" => "\xf0\xa7\xbe\xb7",	
	"2-89-26" => "\xe8\xb7\x86",
	"2-89-27" => "\xe8\xb7\x88",
	"2-89-28" => "\xe8\xb7\x99",
	"2-89-29" => "\xe8\xb7\xac",
	"2-89-30" => "\xe8\xb8\x8c",
	"2-89-31" => "\xe4\x9f\xbd",
	"2-89-32" => "\xe8\xb7\xbd",
	"2-89-33" => "\xe8\xb8\x86",
	"2-89-34" => "\xf0\xa8\x82\x8a",	
	"2-89-35" => "\xe8\xb8\x94",
	"2-89-36" => "\xe8\xb8\x96",
	"2-89-37" => "\xe8\xb8\xa1",
	"2-89-38" => "\xe8\xb8\xa2",
	"2-89-39" => "\xe8\xb8\xa7",
	"2-89-40" => "\xf0\xa8\x82\xbb",	
	"2-89-41" => "\xe4\xa0\x96",
	"2-89-42" => "\xe8\xb8\xb6",
	"2-89-43" => "\xe8\xb8\xb9",
	"2-89-44" => "\xe8\xb9\x8b",
	"2-89-45" => "\xe8\xb9\x94",
	"2-89-46" => "\xe8\xb9\xa2",
	"2-89-47" => "\xe8\xb9\xac",
	"2-89-48" => "\xe8\xb9\xad",
	"2-89-49" => "\xe8\xb9\xaf",
	"2-89-50" => "\xe8\xba\x98",
	"2-89-51" => "\xe8\xba\x9e",
	"2-89-52" => "\xe8\xba\xae",
	"2-89-53" => "\xe8\xba\xb3",
	"2-89-54" => "\xe8\xba\xb5",
	"2-89-55" => "\xe8\xba\xb6",
	"2-89-56" => "\xe8\xba\xbb",
	"2-89-57" => "\xf0\xa8\x8a\x82",	
	"2-89-58" => "\xe8\xbb\x91",
	"2-89-59" => "\xe8\xbb\x94",
	"2-89-60" => "\xe4\xa1\x8e",
	"2-89-61" => "\xe8\xbb\xb9",
	"2-89-62" => "\xf0\xa8\x8b\xb3",	
	"2-89-63" => "\xe8\xbc\x80",
	"2-89-64" => "\xe8\xbc\x88",
	"2-89-65" => "\xe8\xbc\x97",
	"2-89-66" => "\xe8\xbc\xab",
	"2-89-67" => "\xe8\xbd\x80",
	"2-89-68" => "\xe8\xbd\x8a",
	"2-89-69" => "\xe8\xbd\x98",
	"2-89-70" => "\xf0\xa8\x90\x8c",	
	"2-89-71" => "\xe8\xbe\xa4",
	"2-89-72" => "\xe8\xbe\xb4",
	"2-89-73" => "\xe8\xbe\xb6",	
	"2-89-74" => "\xe8\xbe\xb6",
	"2-89-75" => "\xf0\xa8\x91\x95",	
	"2-89-76" => "\xe8\xbf\x81",
	"2-89-77" => "\xe8\xbf\x86",
	"2-89-78" => "\xef\xa8\xa4",
	"2-89-79" => "\xe8\xbf\x8a",
	"2-89-80" => "\xe8\xbf\x8d",
	"2-89-81" => "\xe8\xbf\x93",
	"2-89-82" => "\xe8\xbf\x95",
	"2-89-83" => "\xe8\xbf\xa0",
	"2-89-84" => "\xe8\xbf\xb1",
	"2-89-85" => "\xe8\xbf\xb5",
	"2-89-86" => "\xe8\xbf\xbb",
	"2-89-87" => "\xe9\x80\x82",
	"2-89-88" => "\xe9\x80\x8c",
	"2-89-89" => "\xe9\x80\xb7",
	"2-89-90" => "\xf0\xa8\x95\xab",	
	"2-89-91" => "\xe9\x81\x83",
	"2-89-92" => "\xe9\x81\x84",
	"2-89-93" => "\xe9\x81\x9d",
	"2-89-94" => "\xf0\xa8\x97\x88",	
	"2-90-1" => "\xf0\xa8\x97\x89",	
	"2-90-2" => "\xe9\x82\x85",
	"2-90-3" => "\xe9\x82\x8c",
	"2-90-4" => "\xe9\x82\x90",
	"2-90-5" => "\xe9\x98\x9d",
	"2-90-6" => "\xe9\x82\xa1",
	"2-90-7" => "\xe4\xa2\xb5",
	"2-90-8" => "\xe9\x82\xb0",
	"2-90-9" => "\xe9\x82\xb6",
	"2-90-10" => "\xe9\x83\x83",
	"2-90-11" => "\xe9\x83\x88",
	"2-90-12" => "\xf0\xa8\x9b\x97",	
	"2-90-13" => "\xe9\x83\x9c",
	"2-90-14" => "\xe9\x83\x9f",
	"2-90-15" => "\xf0\xa8\x9b\xba",	
	"2-90-16" => "\xe9\x83\xb6",
	"2-90-17" => "\xe9\x83\xb2",
	"2-90-18" => "\xe9\x84\x80",
	"2-90-19" => "\xe9\x83\xab",
	"2-90-20" => "\xe9\x83\xbe",
	"2-90-21" => "\xe9\x83\xbf",
	"2-90-22" => "\xe9\x84\x84",
	"2-90-23" => "\xe9\x84\x86",
	"2-90-24" => "\xe9\x84\x98",
	"2-90-25" => "\xe9\x84\x9c",
	"2-90-26" => "\xe9\x84\x9e",
	"2-90-27" => "\xe9\x84\xb7",
	"2-90-28" => "\xe9\x84\xb9",
	"2-90-29" => "\xe9\x84\xba",
	"2-90-30" => "\xe9\x85\x86",
	"2-90-31" => "\xe9\x85\x87",
	"2-90-32" => "\xe9\x85\x97",
	"2-90-33" => "\xe9\x85\x99",
	"2-90-34" => "\xe9\x85\xa1",
	"2-90-35" => "\xe9\x85\xa4",
	"2-90-36" => "\xe9\x85\xb4",
	"2-90-37" => "\xe9\x85\xb9",
	"2-90-38" => "\xe9\x86\x85",
	"2-90-39" => "\xe9\x86\x8e",
	"2-90-40" => "\xe9\x86\xa8",
	"2-90-41" => "\xe9\x86\xae",
	"2-90-42" => "\xe9\x86\xb3",
	"2-90-43" => "\xe9\x86\xb6",
	"2-90-44" => "\xe9\x87\x83",
	"2-90-45" => "\xe9\x87\x84",
	"2-90-46" => "\xe9\x87\x9a",
	"2-90-47" => "\xf0\xa8\xa5\x89",	
	"2-90-48" => "\xf0\xa8\xa5\x86",	
	"2-90-49" => "\xe9\x87\xac",
	"2-90-50" => "\xe9\x87\xae",
	"2-90-51" => "\xe9\x88\x81",
	"2-90-52" => "\xe9\x88\x8a",
	"2-90-53" => "\xe9\x88\x96",
	"2-90-54" => "\xe9\x88\x97",
	"2-90-55" => "\xf0\xa8\xa5\xab",	
	"2-90-56" => "\xe9\x88\xb3",
	"2-90-57" => "\xe9\x89\x82",
	"2-90-58" => "\xe9\x89\x87",
	"2-90-59" => "\xe9\x89\x8a",
	"2-90-60" => "\xe9\x89\x8e",
	"2-90-61" => "\xe9\x89\x91",
	"2-90-62" => "\xe9\x89\x96",
	"2-90-63" => "\xe9\x89\x99",
	"2-90-64" => "\xe9\x89\xa0",
	"2-90-65" => "\xe9\x89\xa1",
	"2-90-66" => "\xe9\x89\xa5",
	"2-90-67" => "\xe9\x89\xa7",
	"2-90-68" => "\xe9\x89\xa8",
	"2-90-69" => "\xf0\xa8\xa6\x87",	
	"2-90-70" => "\xf0\xa8\xa6\x88",	
	"2-90-71" => "\xe9\x89\xbc",
	"2-90-72" => "\xe9\x89\xbd",
	"2-90-73" => "\xe9\x89\xbf",
	"2-90-74" => "\xe9\x8a\x89",
	"2-90-75" => "\xe9\x8a\x8d",
	"2-90-76" => "\xe9\x8a\x97",
	"2-90-77" => "\xe9\x8a\x99",
	"2-90-78" => "\xe9\x8a\x9f",
	"2-90-79" => "\xe9\x8a\xa7",
	"2-90-80" => "\xe9\x8a\xab",
	"2-90-81" => "\xf0\xa8\xa6\xba",	
	"2-90-82" => "\xf0\xa8\xa6\xbb",	
	"2-90-83" => "\xe9\x8a\xb2",
	"2-90-84" => "\xe9\x8a\xbf",
	"2-90-85" => "\xe9\x8b\x80",
	"2-90-86" => "\xe9\x8b\x86",
	"2-90-87" => "\xe9\x8b\x8e",
	"2-90-88" => "\xe9\x8b\x90",
	"2-90-89" => "\xe9\x8b\x97",
	"2-90-90" => "\xe9\x8b\x99",
	"2-90-91" => "\xe9\x8b\xa5",
	"2-90-92" => "\xe9\x8b\xa7",
	"2-90-93" => "\xe9\x8c\x91",
	"2-90-94" => "\xf0\xa8\xa8\x9e",	
	"2-91-1" => "\xf0\xa8\xa8\xa9",	
	"2-91-2" => "\xe9\x8b\xb7",
	"2-91-3" => "\xe9\x8b\xb9",
	"2-91-4" => "\xe9\x8b\xbb",
	"2-91-5" => "\xe9\x8c\x82",
	"2-91-6" => "\xe9\x8c\x8d",
	"2-91-7" => "\xe9\x8c\x95",
	"2-91-8" => "\xe9\x8c\x9d",
	"2-91-9" => "\xe9\x8c\x9e",
	"2-91-10" => "\xe9\x8c\xa7",
	"2-91-11" => "\xe9\x8c\xa9",
	"2-91-12" => "\xf0\xa8\xa9\xb1",	
	"2-91-13" => "\xf0\xa8\xa9\x83",	
	"2-91-14" => "\xe9\x8d\x87",
	"2-91-15" => "\xe9\x8d\x91",
	"2-91-16" => "\xe9\x8d\x97",
	"2-91-17" => "\xe9\x8d\x9a",
	"2-91-18" => "\xe9\x8d\xab",
	"2-91-19" => "\xe9\x8d\xb1",
	"2-91-20" => "\xe9\x8d\xb3",
	"2-91-21" => "\xe9\x8e\xa1",
	"2-91-22" => "\xf0\xa8\xaa\x99",	
	"2-91-23" => "\xf0\xa8\xab\x8d",	
	"2-91-24" => "\xe9\x8e\x88",
	"2-91-25" => "\xe9\x8e\x8b",
	"2-91-26" => "\xe9\x8e\x8f",
	"2-91-27" => "\xe9\x8e\x9e",
	"2-91-28" => "\xe9\x8f\xb5",
	"2-91-29" => "\xf0\xa8\xab\xa4",	
	"2-91-30" => "\xf0\xa8\xab\x9d",	
	"2-91-31" => "\xe9\x8f\xb1",
	"2-91-32" => "\xe9\x8f\x81",
	"2-91-33" => "\xe9\x8f\x87",
	"2-91-34" => "\xe9\x8f\x9c",
	"2-91-35" => "\xe9\x8f\xa2",
	"2-91-36" => "\xe9\x8f\xa7",
	"2-91-37" => "\xe9\x90\x89",
	"2-91-38" => "\xe9\x90\x8f",
	"2-91-39" => "\xe9\x90\x96",
	"2-91-40" => "\xe9\x90\x97",
	"2-91-41" => "\xe9\x8f\xbb",
	"2-91-42" => "\xe9\x90\xb2",
	"2-91-43" => "\xe9\x90\xb4",
	"2-91-44" => "\xe9\x90\xbb",
	"2-91-45" => "\xe9\x91\x85",
	"2-91-46" => "\xf0\xa8\xaf\x81",	
	"2-91-47" => "\xf0\xa8\xaf\xaf",	
	"2-91-48" => "\xe9\x91\xad",
	"2-91-49" => "\xe9\x91\xaf",
	"2-91-50" => "\xe9\x95\xb8",
	"2-91-51" => "\xe9\x95\xb9",
	"2-91-52" => "\xe9\x96\x86",
	"2-91-53" => "\xe9\x96\x8c",
	"2-91-54" => "\xe9\x96\x8d",
	"2-91-55" => "\xf0\xa8\xb4\x90",	
	"2-91-56" => "\xe9\x96\xab",
	"2-91-57" => "\xe9\x96\xb4",
	"2-91-58" => "\xf0\xa8\xb5\xb1",	
	"2-91-59" => "\xe9\x97\x88",
	"2-91-60" => "\xf0\xa8\xb7\xbb",	
	"2-91-61" => "\xf0\xa8\xb8\x9f",	
	"2-91-62" => "\xe9\x98\xac",
	"2-91-63" => "\xe9\x98\xb3",
	"2-91-64" => "\xe9\x98\xb4",
	"2-91-65" => "\xf0\xa8\xb8\xb6",	
	"2-91-66" => "\xe9\x98\xbc",
	"2-91-67" => "\xe9\x99\x81",
	"2-91-68" => "\xe9\x99\xa1",
	"2-91-69" => "\xf0\xa8\xba\x89",	
	"2-91-70" => "\xe9\x9a\x82",
	"2-91-71" => "\xf0\xa8\xbb\xab",	
	"2-91-72" => "\xe9\x9a\x9a",
	"2-91-73" => "\xf0\xa8\xbc\xb2",	
	"2-91-74" => "\xe4\xa7\xa7",
	"2-91-75" => "\xe9\x9a\xa9",
	"2-91-76" => "\xe9\x9a\xaf",
	"2-91-77" => "\xe9\x9a\xb3",
	"2-91-78" => "\xe9\x9a\xba",
	"2-91-79" => "\xe9\x9a\xbd",
	"2-91-80" => "\xe4\xa7\xba",
	"2-91-81" => "\xf0\xa8\xbf\xb8",	
	"2-91-82" => "\xe9\x9b\x98",
	"2-91-83" => "\xe9\x9b\x9a",
	"2-91-84" => "\xe9\x9b\x9d",
	"2-91-85" => "\xe4\xa8\x84",
	"2-91-86" => "\xe9\x9c\x94",
	"2-91-87" => "\xe9\x9c\xa3",
	"2-91-88" => "\xe4\xa8\xa9",
	"2-91-89" => "\xe9\x9c\xb6",
	"2-91-90" => "\xe9\x9d\x81",
	"2-91-91" => "\xe9\x9d\x87",
	"2-91-92" => "\xe9\x9d\x95",
	"2-91-93" => "\xe9\x9d\x97",
	"2-91-94" => "\xe9\x9d\x9b",
	"2-92-1" => "\xe9\x9d\xaa",
	"2-92-2" => "\xf0\xa9\x8a\xa0",	
	"2-92-3" => "\xf0\xa9\x8a\xb1",	
	"2-92-4" => "\xe9\x9e\x96",
	"2-92-5" => "\xe9\x9e\x9a",
	"2-92-6" => "\xe9\x9e\x9e",
	"2-92-7" => "\xe9\x9e\xa2",
	"2-92-8" => "\xe9\x9e\xb1",
	"2-92-9" => "\xe9\x9e\xb2",
	"2-92-10" => "\xe9\x9e\xbe",
	"2-92-11" => "\xe9\x9f\x8c",
	"2-92-12" => "\xe9\x9f\x91",
	"2-92-13" => "\xe9\x9f\x94",
	"2-92-14" => "\xe9\x9f\x98",
	"2-92-15" => "\xe9\x9f\x99",
	"2-92-16" => "\xe9\x9f\xa1",
	"2-92-17" => "\xe9\x9f\xb1",
	"2-92-18" => "\xe9\xa0\x84",
	"2-92-19" => "\xe9\xa0\x8d",
	"2-92-20" => "\xe9\xa0\x8e",
	"2-92-21" => "\xe9\xa0\x94",
	"2-92-22" => "\xe9\xa0\x96",
	"2-92-23" => "\xe4\xaa\xbc",
	"2-92-24" => "\xf0\xa9\x92\x90",	
	"2-92-25" => "\xe9\xa0\xa3",
	"2-92-26" => "\xe9\xa0\xb2",
	"2-92-27" => "\xe9\xa0\xb3",
	"2-92-28" => "\xe9\xa0\xa5",
	"2-92-29" => "\xe9\xa1\x87",
	"2-92-30" => "\xe9\xa1\xa6",
	"2-92-31" => "\xe9\xa2\xab",
	"2-92-32" => "\xe9\xa2\xad",
	"2-92-33" => "\xe9\xa2\xb0",
	"2-92-34" => "\xf0\xa9\x97\x8f",	
	"2-92-35" => "\xe9\xa2\xb7",
	"2-92-36" => "\xe9\xa2\xb8",
	"2-92-37" => "\xe9\xa2\xbb",
	"2-92-38" => "\xe9\xa2\xbc",
	"2-92-39" => "\xe9\xa2\xbf",
	"2-92-40" => "\xe9\xa3\x82",
	"2-92-41" => "\xe9\xa3\x87",
	"2-92-42" => "\xe9\xa3\x8b",
	"2-92-43" => "\xe9\xa3\xa0",
	"2-92-44" => "\xf0\xa9\x99\xbf",	
	"2-92-45" => "\xe9\xa3\xa1",
	"2-92-46" => "\xe9\xa3\xa3",
	"2-92-47" => "\xe9\xa3\xa5",
	"2-92-48" => "\xe9\xa3\xaa",
	"2-92-49" => "\xe9\xa3\xb0",
	"2-92-50" => "\xe9\xa3\xb1",
	"2-92-51" => "\xe9\xa3\xb3",
	"2-92-52" => "\xe9\xa4\x88",
	"2-92-53" => "\xe4\xac\xbb",
	"2-92-54" => "\xf0\xa9\x9b\xb0",	
	"2-92-55" => "\xe9\xa4\x96",
	"2-92-56" => "\xe9\xa4\x97",
	"2-92-57" => "\xf0\xa9\x9c\x99",	
	"2-92-58" => "\xe9\xa4\x9a",
	"2-92-59" => "\xe9\xa4\x9b",
	"2-92-60" => "\xe9\xa4\x9c",
	"2-92-61" => "\xf0\xa9\x9d\x90",	
	"2-92-62" => "\xe9\xa4\xb1",
	"2-92-63" => "\xe9\xa4\xb2",
	"2-92-64" => "\xe9\xa4\xb3",
	"2-92-65" => "\xe9\xa4\xba",
	"2-92-66" => "\xe9\xa4\xbb",
	"2-92-67" => "\xe9\xa4\xbc",
	"2-92-68" => "\xe9\xa5\x80",
	"2-92-69" => "\xe9\xa5\x81",
	"2-92-70" => "\xe9\xa5\x86",
	"2-92-71" => "\xe9\xa5\x8d",
	"2-92-72" => "\xe9\xa5\x8e",
	"2-92-73" => "\xe9\xa5\x9c",
	"2-92-74" => "\xe9\xa5\x9f",
	"2-92-75" => "\xe9\xa5\xa0",
	"2-92-76" => "\xe9\xa6\xa3",
	"2-92-77" => "\xe9\xa6\xa6",
	"2-92-78" => "\xe9\xa6\xb9",
	"2-92-79" => "\xe9\xa6\xbd",
	"2-92-80" => "\xe9\xa6\xbf",
	"2-92-81" => "\xe9\xa7\x83",
	"2-92-82" => "\xe9\xa7\x89",
	"2-92-83" => "\xe9\xa7\x94",
	"2-92-84" => "\xe9\xa7\x99",
	"2-92-85" => "\xe9\xa7\x9e",
	"2-92-86" => "\xf0\xa9\xa3\x86",	
	"2-92-86" => "\xf0\xa9\xa3\x86",	
	"2-92-87" => "\xe9\xa7\xb0",
	"2-92-88" => "\xe9\xa7\xb9",
	"2-92-89" => "\xe9\xa7\xbc",
	"2-92-90" => "\xe9\xa8\x8a",
	"2-92-91" => "\xe9\xa8\x91",
	"2-92-92" => "\xe9\xa8\x96",
	"2-92-93" => "\xe9\xa8\x9a",
	"2-92-94" => "\xe9\xa8\xa0",
	"2-93-1" => "\xe9\xa8\xb1",
	"2-93-2" => "\xe9\xa8\xb6",
	"2-93-3" => "\xe9\xa9\x84",
	"2-93-4" => "\xe9\xa9\x8c",
	"2-93-5" => "\xe9\xa9\x98",
	"2-93-6" => "\xe4\xaf\x82",
	"2-93-7" => "\xe9\xaa\xaf",
	"2-93-8" => "\xe4\xaf\x8a",
	"2-93-9" => "\xe9\xaa\xb7",
	"2-93-10" => "\xe4\xaf\x92",
	"2-93-11" => "\xe9\xaa\xb9",
	"2-93-12" => "\xf0\xa9\xa9\xb2",	
	"2-93-12" => "\xf0\xa9\xa9\xb2",	
	"2-93-13" => "\xe9\xab\x86",
	"2-93-14" => "\xe9\xab\x90",
	"2-93-15" => "\xe9\xab\x92",
	"2-93-16" => "\xe9\xab\x95",
	"2-93-17" => "\xe4\xaf\xa8",
	"2-93-18" => "\xe9\xab\x9c",
	"2-93-19" => "\xe9\xab\xa0",
	"2-93-20" => "\xe9\xab\xa5",
	"2-93-21" => "\xe9\xab\xa9",
	"2-93-22" => "\xe9\xac\x83",
	"2-93-23" => "\xe9\xac\x8c",
	"2-93-24" => "\xe9\xac\x90",
	"2-93-25" => "\xe9\xac\x92",
	"2-93-26" => "\xe9\xac\x96",
	"2-93-27" => "\xe9\xac\x9d",
	"2-93-28" => "\xe9\xac\xab",
	"2-93-29" => "\xe9\xac\xb3",
	"2-93-30" => "\xe9\xac\xbd",
	"2-93-31" => "\xe4\xb0\xa0",
	"2-93-32" => "\xe9\xad\x8b",
	"2-93-33" => "\xe9\xad\xa3",
	"2-93-34" => "\xe9\xad\xa5",
	"2-93-35" => "\xe9\xad\xab",
	"2-93-36" => "\xe9\xad\xac",
	"2-93-37" => "\xe9\xad\xb3",
	"2-93-38" => "\xe9\xad\xb6",
	"2-93-39" => "\xe9\xad\xb7",
	"2-93-40" => "\xe9\xae\xa6",
	"2-93-41" => "\xe9\xae\xac",
	"2-93-42" => "\xe9\xae\xb1",
	"2-93-43" => "\xf0\xa9\xb7\x9b",	
	"2-93-43" => "\xf0\xa9\xb7\x9b",	
	"2-93-44" => "\xf0\xa9\xb8\xbd",	
	"2-93-44" => "\xf0\xa9\xb8\xbd",	
	"2-93-45" => "\xe9\xae\xb2",
	"2-93-46" => "\xe9\xae\xb8",
	"2-93-47" => "\xe9\xae\xbe",
	"2-93-48" => "\xe9\xaf\x87",
	"2-93-49" => "\xe9\xaf\xb3",
	"2-93-50" => "\xe9\xaf\x98",
	"2-93-51" => "\xe9\xaf\x9d",
	"2-93-52" => "\xe9\xaf\xa7",
	"2-93-53" => "\xe9\xaf\xaa",
	"2-93-54" => "\xe9\xaf\xab",
	"2-93-55" => "\xe9\xaf\xaf",
	"2-93-56" => "\xe9\xaf\xae",
	"2-93-57" => "\xf0\xa9\xb8\x95",	
	"2-93-57" => "\xf0\xa9\xb8\x95",	
	"2-93-58" => "\xe9\xaf\xba",
	"2-93-59" => "\xf0\xa9\xba\x8a",	
	"2-93-59" => "\xf0\xa9\xba\x8a",	
	"2-93-60" => "\xe9\xaf\xb7",
	"2-93-61" => "\xf0\xa9\xb9\x89",	
	"2-93-61" => "\xf0\xa9\xb9\x89",	
	"2-93-62" => "\xe9\xb0\x96",
	"2-93-63" => "\xe9\xb0\x98",
	"2-93-64" => "\xe9\xb0\x99",
	"2-93-65" => "\xe9\xb0\x9a",
	"2-93-66" => "\xe9\xb0\x9d",
	"2-93-67" => "\xe9\xb0\xa2",
	"2-93-68" => "\xe9\xb0\xa7",
	"2-93-69" => "\xe9\xb0\xa9",
	"2-93-70" => "\xe9\xb0\xaa",
	"2-93-71" => "\xf0\xa9\xbb\x84",	
	"2-93-71" => "\xf0\xa9\xbb\x84",	
	"2-93-72" => "\xe9\xb0\xb1",
	"2-93-73" => "\xe9\xb0\xb6",
	"2-93-74" => "\xe9\xb0\xb7",
	"2-93-75" => "\xe9\xb1\x85",
	"2-93-76" => "\xe9\xb1\x9c",
	"2-93-77" => "\xf0\xa9\xbb\xa9",	
	"2-93-77" => "\xf0\xa9\xbb\xa9",	
	"2-93-78" => "\xe9\xb1\x89",
	"2-93-79" => "\xe9\xb1\x8a",
	"2-93-80" => "\xf0\xa9\xbb\x9b",	
	"2-93-80" => "\xf0\xa9\xbb\x9b",	
	"2-93-81" => "\xe9\xb1\x94",
	"2-93-82" => "\xe9\xb1\x98",
	"2-93-83" => "\xe9\xb1\x9b",
	"2-93-84" => "\xe9\xb1\x9d",
	"2-93-85" => "\xe9\xb1\x9f",
	"2-93-86" => "\xe9\xb1\xa9",
	"2-93-87" => "\xe9\xb1\xaa",
	"2-93-88" => "\xe9\xb1\xab",
	"2-93-89" => "\xe9\xb1\xad",
	"2-93-90" => "\xe9\xb1\xae",
	"2-93-91" => "\xe9\xb1\xb0",
	"2-93-92" => "\xe9\xb1\xb2",
	"2-93-93" => "\xe9\xb1\xb5",
	"2-93-94" => "\xe9\xb1\xba",
	"2-94-1" => "\xe9\xb3\xa6",
	"2-94-2" => "\xe9\xb3\xb2",
	"2-94-3" => "\xe9\xb4\x8b",
	"2-94-4" => "\xe9\xb4\x82",
	"2-94-5" => "\xf0\xa9\xbf\x97",	
	"2-94-5" => "\xf0\xa9\xbf\x97",	
	"2-94-6" => "\xe9\xb4\x91",
	"2-94-7" => "\xe9\xb4\x97",
	"2-94-8" => "\xe9\xb4\x98",
	"2-94-9" => "\xf0\xaa\x80\xaf",	
	"2-94-9" => "\xf0\xaa\x80\xaf",	
	"2-94-10" => "\xe4\xb3\x84",
	"2-94-11" => "\xf0\xaa\x80\x9a",	
	"2-94-11" => "\xf0\xaa\x80\x9a",	
	"2-94-12" => "\xe9\xb4\xb2",
	"2-94-13" => "\xe4\xb3\x91",
	"2-94-14" => "\xe9\xb5\x82",
	"2-94-15" => "\xe9\xb5\x8a",
	"2-94-16" => "\xe9\xb5\x9f",
	"2-94-17" => "\xe9\xb5\xa2",
	"2-94-18" => "\xf0\xaa\x83\xb9",	
	"2-94-18" => "\xf0\xaa\x83\xb9",	
	"2-94-19" => "\xe9\xb5\xa9",
	"2-94-20" => "\xe9\xb5\xab",
	"2-94-21" => "\xf0\xaa\x82\x82",	
	"2-94-21" => "\xf0\xaa\x82\x82",	
	"2-94-22" => "\xe9\xb5\xb3",
	"2-94-23" => "\xe9\xb5\xb6",
	"2-94-24" => "\xe9\xb5\xb7",
	"2-94-25" => "\xe9\xb5\xbe",
	"2-94-26" => "\xe9\xb6\x84",
	"2-94-27" => "\xe9\xb6\x8d",
	"2-94-28" => "\xe9\xb6\x99",
	"2-94-29" => "\xe9\xb6\xa1",
	"2-94-30" => "\xe9\xb6\xbf",
	"2-94-31" => "\xe9\xb6\xb5",
	"2-94-32" => "\xe9\xb6\xb9",
	"2-94-33" => "\xe9\xb6\xbd",
	"2-94-34" => "\xe9\xb7\x83",
	"2-94-35" => "\xe9\xb7\x87",
	"2-94-36" => "\xe9\xb7\x89",
	"2-94-37" => "\xe9\xb7\x96",
	"2-94-38" => "\xe9\xb7\x9a",
	"2-94-39" => "\xe9\xb7\x9f",
	"2-94-40" => "\xe9\xb7\xa0",
	"2-94-41" => "\xe9\xb7\xa3",
	"2-94-42" => "\xe9\xb7\xb4",
	"2-94-43" => "\xe4\xb4\x87",
	"2-94-44" => "\xe9\xb8\x8a",
	"2-94-45" => "\xe9\xb8\x82",
	"2-94-46" => "\xe9\xb8\x8d",
	"2-94-47" => "\xe9\xb8\x99",
	"2-94-48" => "\xe9\xb8\x9c",
	"2-94-49" => "\xe9\xb8\x9d",
	"2-94-50" => "\xe9\xb9\xbb",
	"2-94-51" => "\xf0\xa2\x88\x98",	
	"2-94-51" => "\xf0\xa2\x88\x98",	
	"2-94-52" => "\xe9\xba\x80",
	"2-94-53" => "\xe9\xba\x85",
	"2-94-54" => "\xe9\xba\x9b",
	"2-94-55" => "\xe9\xba\xa8",
	"2-94-56" => "\xf0\xaa\x8e\x8c",	
	"2-94-56" => "\xf0\xaa\x8e\x8c",	
	"2-94-57" => "\xe9\xba\xbd",
	"2-94-58" => "\xf0\xaa\x90\xb7",	
	"2-94-58" => "\xf0\xaa\x90\xb7",	
	"2-94-59" => "\xe9\xbb\x9f",
	"2-94-60" => "\xe9\xbb\xa7",
	"2-94-61" => "\xe9\xbb\xae",
	"2-94-62" => "\xe9\xbb\xbf",
	"2-94-63" => "\xe9\xbc\x82",
	"2-94-64" => "\xe4\xb5\xb7",
	"2-94-65" => "\xe9\xbc\x83",
	"2-94-66" => "\xe9\xbc\x97",
	"2-94-67" => "\xe9\xbc\x99",
	"2-94-68" => "\xe9\xbc\xaf",
	"2-94-69" => "\xe9\xbc\xb7",
	"2-94-70" => "\xe9\xbc\xba",
	"2-94-71" => "\xe9\xbc\xbd",
	"2-94-72" => "\xe9\xbd\x81",
	"2-94-73" => "\xe9\xbd\x85",
	"2-94-74" => "\xe9\xbd\x86",
	"2-94-75" => "\xe9\xbd\x93",
	"2-94-76" => "\xe9\xbd\x95",
	"2-94-77" => "\xe9\xbd\x98",
	"2-94-78" => "\xf0\xaa\x97\xb1",	
	"2-94-78" => "\xf0\xaa\x97\xb1",	
	"2-94-79" => "\xe9\xbd\x9d",
	"2-94-80" => "\xf0\xaa\x98\x82",	
	"2-94-80" => "\xf0\xaa\x98\x82",	
	"2-94-81" => "\xe9\xbd\xa9",
	"2-94-82" => "\xf0\xaa\x98\x9a",	
	"2-94-82" => "\xf0\xaa\x98\x9a",	
	"2-94-83" => "\xe9\xbd\xad",
	"2-94-84" => "\xe9\xbd\xb0",
	"2-94-85" => "\xe9\xbd\xb5",
	"2-94-86" => "\xf0\xaa\x9a\xb2",	
	"2-94-86" => "\xf0\xaa\x9a\xb2",	
	"2-94-87" => "\xef\xbf\xbf",
	"2-94-88" => "\xef\xbf\xbf",
	"2-94-89" => "\xef\xbf\xbf",
	"2-94-90" => "\xef\xbf\xbf",
	"2-94-91" => "\xef\xbf\xbf",
	"2-94-92" => "\xef\xbf\xbf",
	"2-94-93" => "\xef\xbf\xbf",
	"2-94-94" => "\xef\xbf\xbf",
}