/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.osdn.pdf_brewer.Context;
import net.osdn.pdf_brewer.Horizontal;
import net.osdn.pdf_brewer.Overflow;
import net.osdn.pdf_brewer.PdfBrewer;
import net.osdn.pdf_brewer.Vertical;
import net.osdn.pdf_brewer.instruction.Instruction;
import net.osdn.pdf_brewer.instruction.text.Font;
import net.osdn.pdf_brewer.instruction.text.LineHeight;
import net.osdn.pdf_brewer.instruction.text.Text;
import net.osdn.pdf_brewer.instruction.text.TextAlign;
import net.osdn.pdf_brewer.instruction.text.TextBufferingInstruction;
import net.osdn.pdf_brewer.instruction.text.TextOverflow;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class TextBuffer {
    private List<Op> ops = new ArrayList<Op>();

    public void add(TextBufferingInstruction instruction) throws IOException {
        TextOverflow textOverflowInstruction;
        if (instruction instanceof Text) {
            Text textInstruction = (Text)instruction;
            List<Op> list = TextBuffer.split(textInstruction.getText());
            if (list.get(0) instanceof TextOp) {
                Object last = null;
                if (this.ops.size() > 0) {
                    last = this.ops.get(this.ops.size() - 1);
                }
                if (last instanceof TextOp) {
                    Op op = (TextOp)list.remove(0);
                    ((TextOp)last).text = ((TextOp)last).text + ((TextOp)op).text;
                }
            }
            for (Op op : list) {
                this.ops.add(op);
            }
        } else if (instruction instanceof Font) {
            Font fontInstruction = (Font)instruction;
            String fontName = fontInstruction.getFontName();
            float fontSize = fontInstruction.getFontSize();
            this.ops.add(new FontOp(fontName, fontSize));
        } else if (instruction instanceof LineHeight) {
            LineHeight lineHeightInstruction = (LineHeight)instruction;
            if (lineHeightInstruction.getLineHeight() != Float.NaN && (double)lineHeightInstruction.getLineHeight() >= 0.0) {
                this.ops.add(new LineHeightOp(lineHeightInstruction.getLineHeight()));
            }
        } else if (instruction instanceof TextAlign) {
            TextAlign textAlignInstruction = (TextAlign)instruction;
            if (textAlignInstruction.getTextAlignment() != null) {
                this.ops.add(new TextAlignOp(textAlignInstruction.getTextAlignment()));
            }
        } else if (instruction instanceof TextOverflow && (textOverflowInstruction = (TextOverflow)instruction).getTextOverflow() != null) {
            this.ops.add(new TextOverflowOp(textOverflowInstruction.getTextOverflow()));
        }
    }

    public boolean isEmpty() {
        return this.ops.isEmpty();
    }

    public void clear() {
        this.ops.clear();
    }

    public void process(PdfBrewer brewer, Context context) throws IOException {
        float maxWidth;
        Overflow textOverflow;
        PDFont font = brewer.loadFont(context.getFontName());
        if (font == null) {
            throw new NullPointerException("Font not found: " + context.getFontName());
        }
        Horizontal textAlign = context.getTextAlignment();
        if (textAlign == null) {
            textAlign = Horizontal.Left;
        }
        if ((textOverflow = context.getTextOverflow()) == null) {
            textOverflow = Overflow.Wrap;
        }
        float fontSize = context.getFontSize();
        float lineHeight = context.getLineHeight();
        boolean isHeightChanged = true;
        float rest = maxWidth = Instruction.mm2pt(context.getRight() - context.getLeft());
        int lineNumber = 0;
        float[] lineWidth = new float[1024];
        float[] fontHeight = new float[1024];
        float[] leading = new float[1024];
        ArrayList<Op> ops2 = new ArrayList<Op>();
        for (int i = 0; i < this.ops.size(); ++i) {
            Op op = this.ops.get(i);
            if (op instanceof TextOp) {
                TextOp textOp = (TextOp)op;
                String text = TextBuffer.sanitize(font, textOp.text, "?");
                while (text != null) {
                    float h;
                    DivideResult result = TextBuffer.divide(rest, font, fontSize, text);
                    if (result.text1 == null) {
                        float w = lineWidth[lineNumber];
                        h = lineNumber == 0 ? fontHeight[0] : leading[lineNumber];
                        ops2.add(new NewLineOp(w, h));
                        ++lineNumber;
                        isHeightChanged = true;
                        rest = maxWidth;
                        continue;
                    }
                    if (isHeightChanged) {
                        float l;
                        float fh = TextBuffer.getFontHeight(font, fontSize);
                        if (fh > fontHeight[lineNumber]) {
                            fontHeight[lineNumber] = fh;
                        }
                        if ((l = fh * lineHeight) > leading[lineNumber]) {
                            leading[lineNumber] = l;
                        }
                    }
                    if (result.text2 == null) {
                        ops2.add(new TextOp(result.text1));
                        int n = lineNumber;
                        lineWidth[n] = lineWidth[n] + result.width;
                        rest -= result.width;
                        text = null;
                        continue;
                    }
                    if (textOverflow == Overflow.Truncate) {
                        ops2.add(new TextOp(result.text1));
                        int n = lineNumber;
                        lineWidth[n] = lineWidth[n] + result.width;
                        rest -= result.width;
                        text = null;
                        continue;
                    }
                    if (textOverflow == Overflow.Ellipsis) {
                        String ellipsisChar = TextBuffer.sanitize(font, "\u2026", "...");
                        float ellipsisWidth = TextBuffer.getStringWidth(font, fontSize, ellipsisChar);
                        while (result.text1.length() >= 1 && rest - result.width - ellipsisWidth < 0.0f) {
                            result.text1 = result.text1.substring(0, result.text1.length() - 1);
                            result.width = TextBuffer.getStringWidth(font, fontSize, result.text1);
                        }
                        if (rest - result.width - ellipsisWidth >= 0.0f) {
                            result.text1 = result.text1 + ellipsisChar;
                            result.width = TextBuffer.getStringWidth(font, fontSize, result.text1);
                        }
                        ops2.add(new TextOp(result.text1));
                        int n = lineNumber;
                        lineWidth[n] = lineWidth[n] + result.width;
                        rest -= result.width;
                        text = null;
                        continue;
                    }
                    ops2.add(new TextOp(result.text1));
                    int n = lineNumber;
                    lineWidth[n] = lineWidth[n] + result.width;
                    rest -= result.width;
                    float w = lineWidth[lineNumber];
                    h = lineNumber == 0 ? fontHeight[0] : leading[lineNumber];
                    ops2.add(new NewLineOp(w, h));
                    ++lineNumber;
                    isHeightChanged = true;
                    rest = maxWidth;
                    text = result.text2;
                }
                continue;
            }
            if (op instanceof NewLineOp) {
                float w = lineWidth[lineNumber];
                float h = lineNumber == 0 ? fontHeight[0] : leading[lineNumber];
                ops2.add(new NewLineOp(w, h));
                ++lineNumber;
                isHeightChanged = true;
                rest = maxWidth;
                continue;
            }
            if (op instanceof FontOp) {
                FontOp fontOp = (FontOp)op;
                if (fontOp.fontName != null) {
                    fontOp.font = brewer.loadFont(fontOp.fontName);
                    if (fontOp.font != null) {
                        font = fontOp.font;
                    }
                }
                if ((double)fontOp.fontSize > 0.0) {
                    fontSize = fontOp.fontSize;
                }
                ops2.add(fontOp);
                isHeightChanged = true;
                continue;
            }
            if (op instanceof TextAlignOp) {
                TextAlignOp textAlignOp = (TextAlignOp)op;
                if (textAlignOp.textAlign == null) continue;
                if (textAlign != textAlignOp.textAlign) {
                    textAlign = textAlignOp.textAlign;
                    if (lineWidth[lineNumber] > 0.0f) {
                        float w = lineWidth[lineNumber];
                        float h = lineNumber == 0 ? fontHeight[0] : leading[lineNumber];
                        ops2.add(new NewLineOp(w, h));
                        ++lineNumber;
                        isHeightChanged = true;
                        rest = maxWidth;
                    }
                }
                ops2.add(textAlignOp);
                continue;
            }
            if (op instanceof TextOverflowOp) {
                TextOverflowOp textOverflowOp = (TextOverflowOp)op;
                if (textOverflowOp.textOverflow == null) continue;
                textOverflow = textOverflowOp.textOverflow;
                context.setTextOverflow(textOverflow);
                continue;
            }
            if (!(op instanceof LineHeightOp)) continue;
            LineHeightOp lineHeightOp = (LineHeightOp)op;
            if (lineHeightOp.lineHeight == Float.NaN || !((double)lineHeightOp.lineHeight >= 0.0)) continue;
            lineHeight = lineHeightOp.lineHeight;
            float fh = TextBuffer.getFontHeight(font, fontSize);
            leading[lineNumber] = fh * lineHeight;
            context.setLineHeight(lineHeight);
        }
        if (lineWidth[lineNumber] > 0.0f) {
            float w = lineWidth[lineNumber];
            float h = lineNumber == 0 ? fontHeight[0] : leading[lineNumber];
            ops2.add(new NewLineOp(w, h));
        }
        if ((textAlign = context.getTextAlignment()) == null) {
            textAlign = Horizontal.Left;
        }
        float width = 0.0f;
        float height = 0.0f;
        NewLineOp prev = new NewLineOp(0.0f, 0.0f);
        ops2.add(0, prev);
        for (Op op : ops2) {
            if (op instanceof NewLineOp) {
                NewLineOp n = (NewLineOp)op;
                if (prev != n) {
                    if (n.width > width) {
                        width = n.width;
                    }
                    height += n.height;
                    prev.width = n.width;
                    prev.height = n.height;
                    n.width = 0.0f;
                    n.height = 0.0f;
                }
                n.textAlign = textAlign;
                prev = n;
                continue;
            }
            if (!(op instanceof TextAlignOp)) continue;
            prev.textAlign = textAlign = ((TextAlignOp)op).textAlign;
        }
        float pageHeight = brewer.getPage().getMediaBox().getHeight();
        Horizontal hAlign = context.getHorizontalAlignment();
        float ptX = hAlign == Horizontal.Right ? Instruction.mm2pt(context.getRight()) - width : (hAlign == Horizontal.Center ? Instruction.mm2pt(context.getLeft()) + (Instruction.mm2pt(context.getRight() - context.getLeft()) - width) / 2.0f : Instruction.mm2pt(context.getLeft()));
        Vertical vAlign = context.getVerticalAlignment();
        float ptY = vAlign == Vertical.Bottom ? pageHeight - Instruction.mm2pt(context.getBottom()) + height : (vAlign == Vertical.Center ? pageHeight - Instruction.mm2pt(context.getTop()) - (Instruction.mm2pt(context.getBottom() - context.getTop()) - height) / 2.0f : pageHeight - Instruction.mm2pt(context.getTop()));
        float prevNewLineX = 0.0f;
        PDPageContentStream stream = brewer.getContentStream();
        stream.beginText();
        stream.newLineAtOffset(ptX, ptY);
        font = brewer.loadFont(context.getFontName());
        fontSize = context.getFontSize();
        if (font != null && fontSize != Float.NaN && (double)fontSize > 0.0) {
            stream.setFont(font, fontSize);
        }
        for (Op op : ops2) {
            if (op instanceof NewLineOp) {
                NewLineOp newLineOp = (NewLineOp)op;
                stream.newLineAtOffset(-prevNewLineX, -newLineOp.height);
                float x = newLineOp.textAlign == Horizontal.Right ? maxWidth - newLineOp.width : (newLineOp.textAlign == Horizontal.Center ? (maxWidth - newLineOp.width) / 2.0f : 0.0f);
                stream.newLineAtOffset(x, 0.0f);
                prevNewLineX = x;
                continue;
            }
            if (op instanceof TextOp) {
                TextOp textOp = (TextOp)op;
                stream.showText(textOp.text);
                continue;
            }
            if (op instanceof FontOp) {
                FontOp fontOp = (FontOp)op;
                if (fontOp.font != null) {
                    font = fontOp.font;
                }
                if (fontOp.fontSize != Float.NaN && (double)fontOp.fontSize > 0.0) {
                    fontSize = fontOp.fontSize;
                }
                if (font == null || fontSize == Float.NaN || !((double)fontSize > 0.0)) continue;
                stream.setFont(font, fontOp.fontSize);
                context.setFont(fontOp.fontName, fontOp.fontSize);
                continue;
            }
            if (!(op instanceof TextAlignOp)) continue;
            TextAlignOp textAlignOp = (TextAlignOp)op;
            context.setTextAlignment(textAlignOp.textAlign);
        }
        stream.endText();
    }

    public static List<Op> split(String text) {
        ArrayList<Op> ops = new ArrayList<Op>();
        int from = 0;
        int to = 0;
        while ((to = text.indexOf(10, from)) >= 0) {
            if (to > from) {
                ops.add(new TextOp(text.substring(from, to)));
            }
            ops.add(new NewLineOp(0.0f, 0.0f));
            from = to + 1;
        }
        if (from < text.length()) {
            ops.add(new TextOp(text.substring(from)));
        }
        return ops;
    }

    public static DivideResult divide(float maxWidth, PDFont font, float fontSize, String text) throws IOException {
        float width = TextBuffer.getStringWidth(font, fontSize, text);
        if (width <= maxWidth) {
            return new DivideResult(width, text, null);
        }
        int s = 0;
        int p = text.length() / 2;
        int e = text.length();
        while ((width = TextBuffer.getStringWidth(font, fontSize, text.substring(0, p))) != maxWidth) {
            if (width < maxWidth) {
                s = p;
            } else {
                e = p;
            }
            if (p == (e + s) / 2) break;
            p = (e + s) / 2;
        }
        String text1 = text.substring(0, p);
        String text2 = text.substring(p);
        if (text1 != null && text1.length() == 0) {
            text1 = null;
        }
        if (text2 != null && text2.length() == 0) {
            text2 = null;
        }
        return new DivideResult(width, text1, text2);
    }

    public static float getStringWidth(PDFont font, float fontSize, String text) throws IOException {
        return font.getStringWidth(text) * fontSize / 1000.0f;
    }

    public static float getFontHeight(PDFont font, float fontSize) {
        return font.getFontDescriptor().getCapHeight() * fontSize / 1000.0f;
    }

    public static String sanitize(PDFont font, String text, String replaceChar) throws IOException {
        if (text == null) {
            return null;
        }
        try {
            font.encode(text);
        }
        catch (IllegalArgumentException e1) {
            StringBuilder sb = new StringBuilder();
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                String ch = text.substring(i, i + 1);
                try {
                    font.encode(ch);
                    sb.append(ch);
                    continue;
                }
                catch (IllegalArgumentException e2) {
                    if (replaceChar == null) continue;
                    sb.append(replaceChar);
                }
            }
            text = sb.toString();
        }
        return text;
    }

    private static class LineHeightOp
    extends Op {
        public float lineHeight;

        public LineHeightOp(float lineHeight) {
            this.lineHeight = lineHeight;
        }
    }

    private static class TextOverflowOp
    extends Op {
        public Overflow textOverflow;

        public TextOverflowOp(Overflow textOverflow) {
            this.textOverflow = textOverflow;
        }
    }

    private static class TextAlignOp
    extends Op {
        public Horizontal textAlign;

        public TextAlignOp(Horizontal textAlign) {
            this.textAlign = textAlign;
        }
    }

    private static class FontOp
    extends Op {
        public String fontName;
        public float fontSize;
        public PDFont font;

        public FontOp(String fontName, float fontSize) {
            this.fontName = fontName;
            this.fontSize = fontSize;
        }
    }

    private static class TextOp
    extends Op {
        public String text;

        public TextOp(String text) {
            this.text = text;
        }
    }

    private static class NewLineOp
    extends Op {
        public float width;
        public float height;
        public Horizontal textAlign;

        public NewLineOp(float width, float height) {
            this.width = width;
            this.height = height;
        }
    }

    private static class Op {
        private Op() {
        }
    }

    private static class DivideResult {
        public float width;
        public String text1;
        public String text2;

        public DivideResult(float width, String text1, String text2) {
            this.width = width;
            this.text1 = text1;
            this.text2 = text2;
        }
    }
}

