/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.model;

import net.osdn.aoiro.model.Account;
import net.osdn.aoiro.model.Creditor;
import net.osdn.aoiro.model.Debtor;

public class Amount
implements Cloneable {
    private Class<? extends Account> normalBalance;
    private long value;

    public Amount(Class<? extends Account> normalBalance, long value) {
        this.normalBalance = normalBalance;
        this.value = value;
    }

    public Class<? extends Account> getNormalBalance() {
        return this.normalBalance;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public void increase(Amount amount) {
        if (amount != null) {
            this.value = amount.getNormalBalance() == this.normalBalance ? (this.value += amount.getValue()) : (this.value -= amount.getValue());
        }
    }

    public void increase(long amount) {
        this.value += amount;
    }

    public void decrease(Amount amount) {
        if (amount != null) {
            this.value = amount.getNormalBalance() == this.normalBalance ? (this.value -= amount.getValue()) : (this.value += amount.getValue());
        }
    }

    public void decrease(long amount) {
        this.value -= amount;
    }

    public Amount clone() {
        return new Amount(this.normalBalance, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.normalBalance == Debtor.class) {
            sb.append("\u501f\u65b9 ");
        } else if (this.normalBalance == Creditor.class) {
            sb.append("\u8cb8\u65b9 ");
        }
        sb.append(this.value);
        return sb.toString();
    }
}

