/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.model;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.osdn.aoiro.model.AccountType;

public class AccountTitle {
    public static AccountTitle SUNDRIES = new AccountTitle(null, "\u8af8\u53e3", false);
    public static AccountTitle INCOME_SUMMARY = new AccountTitle(AccountType.Revenue, "\u640d\u76ca", true);
    public static AccountTitle BALANCE = new AccountTitle(AccountType.Assets, "\u6b8b\u9ad8", true);
    public static AccountTitle RETAINED_EARNINGS = new AccountTitle(AccountType.Equity, "\u7e70\u8d8a\u5229\u76ca\u5270\u4f59\u91d1", false);
    public static AccountTitle PRETAX_INCOME = new AccountTitle(AccountType.Equity, "\u63a7\u9664\u524d\u306e\u6240\u5f97\u91d1\u984d", false);
    private AccountType type;
    private String displayName;
    private boolean isClosing;

    public AccountTitle(AccountType type, String displayName) {
        this(type, displayName, false);
    }

    public AccountTitle(AccountType type, String displayName, boolean isClosing) {
        this.type = type;
        this.displayName = displayName;
        this.isClosing = isClosing;
    }

    public AccountType getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isClosing() {
        return this.isClosing;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.displayName);
        sb.append(" (");
        sb.append((Object)this.type);
        sb.append(")");
        return sb.toString();
    }

    public static AccountTitle getByDisplayName(Set<AccountTitle> accountTitles, String displayName) {
        if (displayName != null) {
            for (AccountTitle accountTitle : accountTitles) {
                if (!displayName.equalsIgnoreCase(accountTitle.getDisplayName())) continue;
                return accountTitle;
            }
        }
        return null;
    }

    public static boolean contains(List<AccountTitle> accountTitles, String displayName) {
        if (displayName != null) {
            for (AccountTitle accountTitle : accountTitles) {
                if (!displayName.equalsIgnoreCase(accountTitle.getDisplayName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountTitle that = (AccountTitle)o;
        return this.type == that.type && Objects.equals(this.displayName, that.displayName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.displayName});
    }
}

