/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.loader.yaml;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YamlBeansUtil {
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("Line (\\d+), column (\\d+): (.*)", 32);

    public static Position getPosition(YamlReader reader) {
        Position pos = new Position();
        YamlReader yamlReader = reader;
        Objects.requireNonNull(yamlReader);
        YamlReader.YamlReaderException e = new YamlReader.YamlReaderException(yamlReader, "");
        Matcher m = MESSAGE_PATTERN.matcher(e.getMessage());
        if (m.matches()) {
            try {
                pos.line = Integer.parseInt(m.group(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                pos.column = Integer.parseInt(m.group(2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pos;
    }

    public static Message getMessage(YamlException exception) {
        Throwable e;
        for (e = exception; e != null; e = e.getCause()) {
            Matcher m;
            String message = e.getMessage();
            if (message == null || !(m = MESSAGE_PATTERN.matcher(message)).matches()) continue;
            return new Message(m.group(1), m.group(2), m.group(3));
        }
        for (e = exception; e != null; e = e.getCause()) {
            if (e.getCause() != null || e.getMessage() == null || e.getMessage().isBlank()) continue;
            return new Message("0", "0", e.getMessage());
        }
        return new Message("0", "0", exception.getMessage());
    }

    public static String escape(String s) {
        return s.replace("\\", "_BACKSLASH_").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replace("\"", "\\\"").replace("_BACKSLASH_", "\\\\");
    }

    public static class Message {
        private int line;
        private int column;
        private String message;

        private Message(String line, String column, String message) {
            try {
                this.line = Integer.parseInt(line);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.column = Integer.parseInt(column);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.message = message;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class Position {
        public int line;
        public int column;
    }
}

