/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro;

import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;

public class Util {
    private static Path appDir;
    private static String pdfCreatorName;
    private static String pdfCreatorVersion;

    public static Path getApplicationDirectory() {
        if (appDir == null) {
            appDir = Util.getApplicationDirectory(Util.class);
        }
        return appDir;
    }

    public static Path getApplicationDirectory(Class<?> cls) {
        try {
            ProtectionDomain pd = cls.getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            URL location = cs.getLocation();
            URI uri = location.toURI();
            Path path = Path.of(uri);
            Path parent = path.getParent();
            return parent.toAbsolutePath().normalize();
        }
        catch (Exception e) {
            return Path.of(".", new String[0]).toAbsolutePath().normalize();
        }
    }

    public static int[] getApplicationVersion() {
        Object s = System.getProperty("java.application.version");
        if (s == null || ((String)s).trim().length() == 0) {
            return null;
        }
        s = ((String)s).trim() + ".0.0.0.0";
        String[] array = ((String)s).split("\\.", 5);
        int[] version = new int[4];
        for (int i = 0; i < 4; ++i) {
            try {
                version[i] = Integer.parseInt(array[i]);
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (version[0] == 0 && version[1] == 0 && version[2] == 0 && version[3] == 0) {
            return null;
        }
        return version;
    }

    public static void setPdfCreator(String name, String version) {
        pdfCreatorName = name;
        pdfCreatorVersion = version;
    }

    public static String getPdfCreator() {
        int[] v;
        String version;
        String name = pdfCreatorName;
        if (name == null) {
            name = "aoiro";
        }
        if ((version = pdfCreatorVersion) == null && (v = Util.getApplicationVersion()) != null) {
            version = v[2] == 0 && v[3] == 0 ? String.format("%d.%d", v[0], v[1]) : (v[3] == 0 ? String.format("%d.%d.%d", v[0], v[1], v[2]) : String.format("%d.%d.%d.%d", v[0], v[1], v[2], v[3]));
        }
        if (version == null || version.isBlank()) {
            return name;
        }
        return name + " " + version;
    }
}

