/*** I_INTDBL.C ***/					#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_ceil(ctree *ctr){				/*** TT-Lang: A = CEIL(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do CEIL()!! - 切り上げによる整数化{常に正方向} */
	a->type='D'; a->dval=ceil(cdbl(x)); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_floor(ctree *ctr){				/*** TT-Lang: A = FLOOR(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do FLOOR()!! - 切り下げによる整数化{常に負方向} */
	a->type='D'; a->dval=floor(cdbl(x)); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_trunc(ctree *ctr){				/*** TT-Lang: A = TRUNC(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do TRUNC()!! - 切り捨てによる整数化{常に０方向} */
	a->type='D'; a->dval=trunc(cdbl(x)); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_rint(ctree *ctr){				/*** TT-Lang: A = RINT(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do RINT()!! - 現在の丸め方向に整数化{方向可変} */
	a->type='D'; a->dval=rint(cdbl(x)); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_round(ctree *ctr){				/*** TT-Lang: A = ROUND(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do ROUND()!! - 四捨五入による整数化{切り上げ=常に非０方向/切り下げ=常に０方向} */
	a->type='D'; a->dval=round(cdbl(x)); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_abs(ctree *ctr){				/*** TT-Lang: A = ABS(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do ABS()!! - 絶対値 */
	a->type='D'; a->dval=fabs(cdbl(x)); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_modf(ctree *ctr){				/*** TT-Lang: (A,B) = MODF(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
tdbl	dint,dfra;						/* 整数部分と少数部分									*/

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtabmult(ctr,2) );

/* Do MODF()!! - 浮動小数値を整数部分と少数部分に分解 */
	dfra = modf(cdbl(x),&dint);
	a=ctr2p_dtab(lptr(ans,0)); a->type='D'; a->dval=dint;
	a=ctr2p_dtab(lptr(ans,1)); a->type='D'; a->dval=dfra;
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_frexp(ctree *ctr){				/*** TT-Lang: (A,B) = FREXP(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
tdbl	man;							/* 正規化小数値: X = MAN * 2**EXP						*/
int		exp;							/* 指   数   値: X = MAN * 2**EXP ( It's INT. )			*/

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtabmult(ctr,2) );

/* Do FREXP()!! - 浮動小数値を正規化小数値と指数値に分解 */
	man = frexp(cdbl(x),&exp);
	a=ctr2p_dtab(lptr(ans,0)); a->type='D'; a->dval=man;
	a=ctr2p_dtab(lptr(ans,1)); a->type='I'; a->ival=exp;
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_ldexp(ctree *ctr){				/*** TT-Lang: A = LDEXP(X,Y) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"ID",1);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do LDEXP()!! - 正規化小数値と指数値を浮動小数値に合成 */
	a->type='D'; a->dval=ldexp(cdbl(x),cint(y)); return ans;
}
