/*** I_HOSTS.C ***/						#include	"main.h"

/************************************************************************************************/
// STR_IPHN2TINT() convert {IP-Address|Host-Name}[S] into Host-Integer[I].  ERROR = INVA
// [ {"127.0.0.1"|"localhost"} -> 0x7F000001 ]
/************************************************************************************************/
tint str_iphn2tint(char *p2str){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
struct hostent *p2ent;					// For Host Name & IP Address
struct in_addr **addv;					// For             IP Address
char	buf[BUFSIZ],*s,*d;
tint	t_ip=INVA;

/* Pack IP-Address [ "127. 0. 0. 1" -> [ "127.0.0.1" ] */
	s=p2str;
	d=&buf[0];
	while( *s!='\0' ){
		if( isspace(*s) ){ s++; continue; }		/* Skip Space & Tab								*/
		*d = *s;								/* Copy Char									*/
		s++;
		d++;
	}
	*d = '\0';

/* Convert {IP-Address|Host-Name} into Host-Integer */
// (1) 127.0.0.1 以外で最初に見つかったIPアドレスを戻します。
// (2) ただし、127.0.0.1 しか存在しない場合は、127.0.0.1 を戻します。
	p2ent = gethostbyname(buf);
	if( p2ent==NULL || p2ent->h_addrtype!=AF_INET )
		return INVA;
	addv = (struct in_addr **)p2ent->h_addr_list;
	for( int i=0 ; addv!=NULL && addv[i]!=NULL ; i++ ){
		t_ip = ntohl(addv[i]->s_addr);
		if( t_ip!=0x7F000001 ) break;			// 0x7F000001 = 127.0.0.1
	}
	return t_ip;
}

/************************************************************************************************/
// STR_POSN2TINT() convert {Port-Number|Service-Name}[S] into Host-Integer[I].  ERROR = INVA
// [ {"7"|"echo"} -> 7 ]
/************************************************************************************************/
tint str_posn2tint(int ip_proto,char *p2str){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
struct servent *p_dbase;				// For Service Name & Port Number
char	*p;
tint	t_port=INVA;
int		flag_number=TRUE;				// TRUE = Port-Number[S] / FALS = Service-Name[S]

/* Check String Type {Port-Number|Service-Name} */
	for( p=p2str ; *p!='\0' ; p++ ){	// Service-Name contain at least 1 Alphabet!!
		if( isalpha(*p) ){ flag_number=FALS; break; }
	}

/* Convert {Port-Number|Service-Name} into Host-Integer */
	if( flag_number ){
		t_port = atoi2(p2str);
		if( t_port<0 || 65535<t_port ) t_port = INVA;
	}
	else{
		p_dbase = getservbyname( p2str , ip_proto=='U'?"udp":"tcp" );
		t_port = (p_dbase==NULL)?INVA:ntohs(p_dbase->s_port);
	}
	return t_port;
}

/************************************************************************************************/
// DTAB_IPHN2TINT() - DTAB Version of STR_IPHN2TINT(S) + Integer(I)
// DTAB_POSN2TINT() - DTAB Version of STR_POSN2TINT(S) + Integer(I)
/************************************************************************************************/
tint dtab_iphn2tint(             dtab *d){ return (d->type=='S') ? str_iphn2tint(         cstr(d)) : cint(d) ; }
tint dtab_posn2tint(int ip_proto,dtab *d){ return (d->type=='S') ? str_posn2tint(ip_proto,cstr(d)) : cint(d) ; }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_ip2str(ctree *ctr){			/*** TT-Lang: A = IP2STR(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
struct in_addr in_addr;					// For             IP Address
tint	t_ip;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do IP2STR()!! - Convert {IP-Address|Host-Name} into IP-Address[S] */
	if( isstr(x) )						// "127.0.0.1"|"localhost"
		t_ip = str_iphn2tint(cstr(x));
	else								// 0x7F000001
		t_ip =               cint(x) ;
	if( t_ip==INVA ){ null_dtab(a); return ans; }
	in_addr.s_addr = htonl(t_ip);
	a->type='S'; a->str=X_SDUP(inet_ntoa(in_addr)); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_ip2int(ctree *ctr){			/*** TT-Lang: A = IP2INT(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
tint	t_ip;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do IP2INT()!! - Convert {IP-Address|Host-Name} into Host-Integer[I] */
	if( isstr(x) )						// "127.0.0.1"|"localhost"
		t_ip = str_iphn2tint(cstr(x));
	else								// 0x7F000001
		t_ip =               cint(x) ;
	if( t_ip==INVA ){ null_dtab(a); return ans; }
	a->type='I'; a->ival=t_ip; return ans;
}
