/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.updater;

import java.sql.Connection;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import jp.sf.amateras.mirage.SqlManagerImpl;
import jp.sf.amateras.mirage.session.Session;
import jp.sf.amateras.mirage.session.SessionFactory;
import jp.sf.amateras.mirage.updater.SchemaUpdater;
import jp.sf.amateras.mirage.util.ExceptionUtil;
import jp.sf.amateras.mirage.util.StringUtil;

public class SchemaUpdateListener
implements ServletContextListener {
    private static final Logger logger = Logger.getLogger(SchemaUpdateListener.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        SchemaUpdater updater = new SchemaUpdater();
        Session session = SessionFactory.getSession();
        updater.setSqlManager(session.getSqlManager());
        String packageName = sce.getServletContext().getInitParameter("SCHEMA_UPDATE_SQL_PACKAGE");
        if (StringUtil.isNotEmpty(packageName)) {
            updater.setPackageName(packageName);
        }
        try {
            session.begin();
            Connection conn = ((SqlManagerImpl)session.getSqlManager()).getConnectionProvider().getConnection();
            try {
                conn.setAutoCommit(true);
            }
            catch (Exception ex) {
                logger.severe("Failed to update schema.");
                logger.severe(ExceptionUtil.toString(ex));
            }
            finally {
                try {
                    conn.setAutoCommit(false);
                }
                catch (Exception ex) {
                    logger.severe(ExceptionUtil.toString(ex));
                }
            }
        }
        finally {
            session.release();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

