/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sf.amateras.mirage.naming.DefaultNameConverter;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.test.ExecutedSQLInfo;
import jp.sf.amateras.mirage.util.MirageUtil;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MirageTestContext {
    private static NameConverter nameConverter = new DefaultNameConverter();
    private static List<Object> resultList = new ArrayList<Object>();
    private static List<ExecutedSQLInfo> executedSqlList = new ArrayList<ExecutedSQLInfo>();
    private static Map<String, Long> sequenceMap = new HashMap<String, Long>();

    public static void initMirageTestContext() {
        resultList.clear();
        executedSqlList.clear();
        sequenceMap.clear();
    }

    public static void setNameConverter(NameConverter nameConverter) {
        MirageTestContext.nameConverter = nameConverter;
    }

    public static void addResult(Object result) {
        resultList.add(result);
    }

    static boolean hasNextResult() {
        return !resultList.isEmpty();
    }

    static Object getNextResult() {
        return resultList.remove(0);
    }

    static void addExecutedSql(ExecutedSQLInfo executedSql) {
        System.out.println(String.format("[SQL] %s", MirageTestContext.normalizeSql(executedSql.getSql())));
        Object[] params = executedSql.getParams();
        for (int i = 0; i < params.length; ++i) {
            System.out.println(String.format("[SQL] params[%d]: %s", i, params[i]));
        }
        executedSqlList.add(executedSql);
    }

    static long getNextVal(Class<?> entity, String propertyName) {
        String key = entity.getClass().getName() + "#" + propertyName;
        Long value = sequenceMap.get(key);
        if (value == null) {
            value = -1L;
        }
        value = value + 1L;
        sequenceMap.put(key, value);
        return value;
    }

    public static ExecutedSQLInfo getExecutedSQLInfo(int index) {
        return executedSqlList.get(index);
    }

    public static void verifySqlNumber(int expected) {
        Assert.assertEquals((int)expected, (int)executedSqlList.size());
    }

    public static void verifySql(int indexOfSql, String sql) {
        ExecutedSQLInfo executedSql = executedSqlList.get(indexOfSql);
        String result = executedSql.getSql();
        Assert.assertEquals((String)MirageTestContext.normalizeSql(sql), (String)MirageTestContext.normalizeSql(result));
    }

    public static void verifySql(int indexOfSql, String sql, Object ... values) {
        MirageTestContext.verifySql(indexOfSql, sql);
        MirageTestContext.verifyParameters(indexOfSql, values);
    }

    public static void verifySqlByRegExp(int indexOfSql, String regexp) {
        ExecutedSQLInfo executedSql = executedSqlList.get(indexOfSql);
        String result = MirageTestContext.normalizeSql(executedSql.getSql());
        Assert.assertTrue((boolean)result.matches(regexp));
    }

    public static void verifySqlByRegExp(int indexOfSql, String regexp, Object ... values) {
        MirageTestContext.verifySqlByRegExp(indexOfSql, regexp);
        MirageTestContext.verifyParameters(indexOfSql, values);
    }

    public static void verifyFindSql(int indexOfSql, Class<?> entityClass, Object ... id) {
        MirageTestContext.verifySql(indexOfSql, MirageUtil.buildSelectSQL(entityClass, nameConverter));
        MirageTestContext.verifyParameters(indexOfSql, id);
    }

    public static void verifyInsertSql(int indexOfSql, Object entity) {
        ArrayList<Object> values = new ArrayList<Object>();
        MirageTestContext.verifySql(indexOfSql, MirageUtil.buildInsertSql(entity, nameConverter, values));
        MirageTestContext.verifyParameters(indexOfSql, values.toArray());
    }

    public static void verifyUpdatetSql(int indexOfSql, Object entity) {
        ArrayList<Object> values = new ArrayList<Object>();
        MirageTestContext.verifySql(indexOfSql, MirageUtil.buildUpdateSql(entity, nameConverter, values));
        MirageTestContext.verifyParameters(indexOfSql, values.toArray());
    }

    public static void verifyDeleteSql(int indexOfSql, Object entity) {
        ArrayList<Object> values = new ArrayList<Object>();
        MirageTestContext.verifySql(indexOfSql, MirageUtil.buildDeleteSql(entity, nameConverter, values));
        MirageTestContext.verifyParameters(indexOfSql, values.toArray());
    }

    private static void verifyParameters(int indexOfSql, Object ... values) {
        ExecutedSQLInfo executedSql = executedSqlList.get(indexOfSql);
        Object[] params = executedSql.getParams();
        Assert.assertEquals((int)values.length, (int)params.length);
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((Object)values[i], (Object)params[i]);
        }
    }

    private static String normalizeSql(String sql) {
        sql = sql.replaceAll("--.*", " ");
        sql = sql.replaceAll("\r\n", "\n");
        sql = sql.replaceAll("\r", "\n");
        sql = sql.replaceAll("\n", " ");
        sql = sql.replaceAll("/\\*.*\\*/", " ");
        sql = sql.replaceAll("[ \t]+", " ");
        sql = sql.toUpperCase().trim();
        return sql;
    }
}

