/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage;

import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.amateras.mirage.ResultEntityCreator;
import jp.sf.amateras.mirage.annotation.InOut;
import jp.sf.amateras.mirage.annotation.Out;
import jp.sf.amateras.mirage.annotation.ResultSet;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.BeanDescFactory;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.dialect.Dialect;
import jp.sf.amateras.mirage.exception.SQLRuntimeException;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.provider.ConnectionProvider;
import jp.sf.amateras.mirage.type.ValueType;
import jp.sf.amateras.mirage.util.JdbcUtil;
import jp.sf.amateras.mirage.util.ModifierUtil;
import jp.sf.amateras.mirage.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallExecutor {
    private static final Logger logger = Logger.getLogger(CallExecutor.class.getName());
    private NameConverter nameConverter;
    private ConnectionProvider connectionProvider;
    private List<ValueType> valueTypes = new ArrayList<ValueType>();
    private Dialect dialect;
    private ResultEntityCreator entityCreator;

    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public void setNameConverter(NameConverter nameConverter) {
        this.nameConverter = nameConverter;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public void addValueType(ValueType valueType) {
        this.valueTypes.add(valueType);
    }

    public void setEntityCreator(ResultEntityCreator entityCreator) {
        this.entityCreator = entityCreator;
    }

    public void call(String sql) {
        this.call(sql, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void call(String sql, Object parameter) {
        CallableStatement stmt = null;
        boolean functionCall = false;
        try {
            ArrayList<Param> paramList = new ArrayList<Param>();
            ArrayList<Param> nonParamList = new ArrayList<Param>();
            stmt = this.connectionProvider.getConnection().prepareCall(sql);
            this.prepareParameters(paramList, nonParamList, stmt, parameter);
            this.setParameter(paramList, stmt);
            boolean resultSetGettable = this.execute(stmt, sql, paramList);
            this.handleNonParamResultSets(nonParamList, stmt, parameter, resultSetGettable);
            this.handleOutParams(paramList, stmt, parameter, functionCall);
        }
        catch (SQLRuntimeException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    throw new SQLRuntimeException(e2);
                }
                catch (Exception e3) {
                    throw new RuntimeException(e3);
                }
            }
            catch (Throwable throwable) {
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(stmt);
    }

    public <T> T call(Class<T> resultClass, String sql) {
        return this.call(resultClass, sql, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T call(Class<T> resultClass, String sql, Object parameter) {
        T t;
        CallableStatement stmt = null;
        boolean functionCall = true;
        try {
            ArrayList<Param> paramList = new ArrayList<Param>();
            ArrayList<Param> nonParamList = new ArrayList<Param>();
            stmt = this.connectionProvider.getConnection().prepareCall(sql);
            this.prepareReturnParameter(paramList, false, resultClass);
            this.prepareParameters(paramList, nonParamList, stmt, parameter);
            this.setParameter(paramList, stmt);
            boolean resultSetGettable = this.execute(stmt, sql, paramList);
            this.handleNonParamResultSets(nonParamList, stmt, parameter, resultSetGettable);
            T result = this.handleSingleResult(stmt, paramList);
            this.handleOutParams(paramList, stmt, parameter, functionCall);
            t = result;
        }
        catch (SQLRuntimeException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    throw new SQLRuntimeException(e2);
                }
                catch (Exception e3) {
                    throw new RuntimeException(e3);
                }
            }
            catch (Throwable throwable) {
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(stmt);
        return t;
    }

    public <T> List<T> callForList(Class<T> resultClass, String sql) {
        return this.callForList(resultClass, sql, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> callForList(Class<T> resultClass, String sql, Object parameter) {
        List<T> list;
        CallableStatement stmt = null;
        boolean functionCall = true;
        try {
            ArrayList<Param> paramList = new ArrayList<Param>();
            ArrayList<Param> nonParamList = new ArrayList<Param>();
            stmt = this.connectionProvider.getConnection().prepareCall(sql);
            this.prepareReturnParameter(paramList, true, resultClass);
            this.prepareParameters(paramList, nonParamList, stmt, parameter);
            this.setParameter(paramList, stmt);
            boolean resultSetGettable = this.execute(stmt, sql, paramList);
            this.handleNonParamResultSets(nonParamList, stmt, parameter, resultSetGettable);
            List<T> result = this.handleResultList(paramList, resultClass, stmt);
            this.handleOutParams(paramList, stmt, parameter, functionCall);
            list = result;
        }
        catch (SQLRuntimeException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    throw new SQLRuntimeException(e2);
                }
                catch (Exception e3) {
                    throw new RuntimeException(e3);
                }
            }
            catch (Throwable throwable) {
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(stmt);
        return list;
    }

    protected void prepareParameters(List<Param> paramList, List<Param> nonParamList, CallableStatement stmt, Object parameter) throws SQLException {
        if (parameter == null) {
            return;
        }
        Class<?> paramClass = parameter.getClass();
        for (ParamDesc paramDesc : this.getParamDescs(paramClass)) {
            Class<?> clazz = paramDesc.paramClass;
            ValueType valueType = paramDesc.valueType;
            switch (paramDesc.paramType) {
                case RESULT_SET: {
                    if (this.dialect.needsParameterForResultSet()) {
                        this.addParam(paramList, paramDesc.propertyDesc, null, clazz, valueType, ParameterType.OUT);
                        break;
                    }
                    this.addNonParam(nonParamList, paramDesc.propertyDesc);
                    break;
                }
                case IN: {
                    Object inValue = paramDesc.propertyDesc.getValue(parameter);
                    this.addParam(paramList, paramDesc.propertyDesc, inValue, clazz, valueType, ParameterType.IN);
                    break;
                }
                case OUT: {
                    this.addParam(paramList, paramDesc.propertyDesc, null, clazz, valueType, ParameterType.OUT);
                    break;
                }
                case IN_OUT: {
                    Object inOutValue = paramDesc.propertyDesc.getValue(parameter);
                    this.addParam(paramList, paramDesc.propertyDesc, inOutValue, clazz, valueType, ParameterType.IN_OUT);
                }
            }
        }
    }

    protected void prepareReturnParameter(List<Param> paramList, boolean resultList, Class<?> resultClass) {
        ValueType valueType = this.getValueType(resultList ? List.class : resultClass);
        Param p = this.addParam(paramList, null, resultClass, valueType);
        p.paramType = ParameterType.OUT;
    }

    protected void setParameter(List<Param> paramList, CallableStatement cs) {
        int size = paramList.size();
        try {
            block7: for (int i = 0; i < size; ++i) {
                Param param = paramList.get(i);
                switch (param.paramType) {
                    case IN: {
                        param.valueType.set(param.paramClass, cs, param.value, i + 1);
                        continue block7;
                    }
                    case OUT: {
                        param.valueType.registerOutParameter(param.paramClass, cs, i + 1);
                        continue block7;
                    }
                    case IN_OUT: {
                        param.valueType.set(param.paramClass, cs, param.value, i + 1);
                        param.valueType.registerOutParameter(param.paramClass, cs, i + 1);
                        continue block7;
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    protected boolean execute(CallableStatement stmt, String sql, List<Param> paramList) throws SQLException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(sql);
            this.printParameters(paramList);
        }
        return stmt.execute();
    }

    private void printParameters(List<Param> paramList) {
        if (paramList == null) {
            return;
        }
        for (Param param : paramList) {
            if (param.paramType != ParameterType.IN && param.paramType != ParameterType.IN_OUT) continue;
            PropertyDesc pd = param.propertyDesc;
            if (pd != null) {
                logger.info(String.format("paramName=%s, value=%s", pd.getPropertyName(), param.value));
                continue;
            }
            logger.info(String.format("paramClass=%s, value=%s", param.paramClass, param.value));
        }
    }

    protected void handleNonParamResultSets(List<Param> nonParamList, CallableStatement cs, Object parameter, boolean resultSetGettable) throws Exception {
        if (parameter == null) {
            return;
        }
        try {
            java.sql.ResultSet rs;
            if (!resultSetGettable) {
                cs.getMoreResults();
            }
            for (int i = 0; i < nonParamList.size() && (rs = this.getResultSet(cs)) != null; ++i) {
                Param param = nonParamList.get(i);
                PropertyDesc pd = param.propertyDesc;
                Object value = this.handleResultSet(pd, cs.getResultSet());
                pd.setValue(parameter, value);
                cs.getMoreResults();
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    protected Object handleResultSet(PropertyDesc pd, java.sql.ResultSet rs) throws Exception {
        if (!List.class.isAssignableFrom(pd.getField().getType())) {
            return this.handleSingleResult(pd.getField().getType(), rs);
        }
        Class<?> elementClass = ReflectionUtil.getElementTypeOfListFromFieldType(pd.getField());
        if (elementClass == null) {
            throw new RuntimeException("field has not generics: " + pd.getField().getName());
        }
        return this.handleResultList(elementClass, rs);
    }

    protected <T> T handleSingleResult(Class<T> resultClass, java.sql.ResultSet rs) throws Exception {
        ResultSetMetaData meta = rs.getMetaData();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(resultClass);
        return this.entityCreator.createEntity(resultClass, rs, meta, meta.getColumnCount(), beanDesc, this.dialect, this.valueTypes, this.nameConverter);
    }

    protected <T> T handleSingleResult(CallableStatement cs, List<Param> paramList) {
        try {
            Param param = paramList.get(0);
            return (T)param.valueType.get(param.paramClass, cs, 1);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    protected <T> List<T> handleResultList(List<Param> paramList, Class<?> resultClass, CallableStatement cs) {
        try {
            Field field;
            Param param = paramList.get(0);
            java.sql.ResultSet rs = (java.sql.ResultSet)java.sql.ResultSet.class.cast(param.valueType.get(param.paramClass, cs, 1));
            Class<?> elementClass = null;
            PropertyDesc pd = param.propertyDesc;
            elementClass = pd == null ? resultClass : ((field = pd.getField()) == null ? resultClass : ReflectionUtil.getElementTypeOfListFromFieldType(field));
            return this.handleResultList(elementClass, rs);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> List<T> handleResultList(Class<T> elementClass, java.sql.ResultSet rs) throws Exception {
        ArrayList<T> list = new ArrayList<T>();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(elementClass);
        while (rs.next()) {
            T entity = this.entityCreator.createEntity(elementClass, rs, meta, columnCount, beanDesc, this.dialect, this.valueTypes, this.nameConverter);
            list.add(entity);
        }
        return list;
    }

    protected void handleOutParams(List<Param> paramList, CallableStatement cs, Object parameter, boolean functionCall) throws Exception {
        if (parameter == null) {
            return;
        }
        try {
            int start;
            for (int i = start = functionCall ? 1 : 0; i < paramList.size(); ++i) {
                Param param = paramList.get(i);
                if (param.paramType == ParameterType.IN) continue;
                PropertyDesc pd = param.propertyDesc;
                Object value = param.valueType.get(param.paramClass, cs, i + 1);
                if (value instanceof java.sql.ResultSet) {
                    value = this.handleResultSet(pd, (java.sql.ResultSet)value);
                }
                pd.setValue(parameter, value);
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    protected java.sql.ResultSet getResultSet(CallableStatement cs) {
        try {
            while (true) {
                java.sql.ResultSet rs;
                if ((rs = cs.getResultSet()) != null) {
                    return rs;
                }
                if (cs.getUpdateCount() == -1) {
                    return null;
                }
                cs.getMoreResults();
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    protected ValueType getValueType(Class<?> type) {
        ValueType valueType;
        if (this.dialect.getValueType() != null && (valueType = this.dialect.getValueType()).isSupport(type)) {
            return valueType;
        }
        for (ValueType valueType2 : this.valueTypes) {
            if (!valueType2.isSupport(type)) continue;
            return valueType2;
        }
        return null;
    }

    protected void addParam(List<Param> paramList, PropertyDesc pd, Object value, Class<?> paramClass, ValueType valueType, ParameterType paramType) {
        Param p = this.addParam(paramList, value, paramClass, valueType);
        p.paramType = paramType;
        p.propertyDesc = pd;
    }

    protected Param addParam(List<Param> paramList, Object value, Class<?> paramClass) {
        if (paramClass == null) {
            throw new NullPointerException("paramClass");
        }
        ValueType valueType = this.getValueType(paramClass);
        return this.addParam(paramList, value, paramClass, valueType);
    }

    protected Param addParam(List<Param> paramList, Object value, Class<?> paramClass, ValueType valueType) {
        Param param = new Param(value, paramClass);
        param.valueType = valueType;
        paramList.add(param);
        return param;
    }

    protected Param addNonParam(List<Param> nonParamList, PropertyDesc pd) {
        Param param = new Param();
        param.propertyDesc = pd;
        param.paramType = ParameterType.OUT;
        nonParamList.add(param);
        return param;
    }

    protected List<ParamDesc> getParamDescs(Class<?> clazz) {
        return this.createParamDesc(clazz);
    }

    protected List<ParamDesc> createParamDesc(Class<?> clazz) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(clazz);
        ArrayList<ParamDesc> paramDescList = new ArrayList<ParamDesc>();
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            Field field = pd.getField();
            if (!ModifierUtil.isInstanceField(field)) continue;
            field.setAccessible(true);
            ParamDesc paramDesc = new ParamDesc();
            paramDesc.propertyDesc = pd;
            paramDesc.name = field.getName();
            paramDesc.paramClass = field.getType();
            paramDesc.valueType = this.getValueType(paramDesc.paramClass);
            paramDesc.paramType = pd.getAnnotation(ResultSet.class) != null ? ParameterType.RESULT_SET : (pd.getAnnotation(Out.class) != null ? ParameterType.OUT : (pd.getAnnotation(InOut.class) != null ? ParameterType.IN_OUT : ParameterType.IN));
            if (paramDesc.paramType == null) continue;
            paramDescList.add(paramDesc);
        }
        return paramDescList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Param {
        public Object value;
        public Class<?> paramClass;
        public ParameterType paramType = ParameterType.IN;
        public ValueType valueType;
        public PropertyDesc propertyDesc;

        public Param() {
        }

        public Param(Object value, Class<?> paramClass) {
            this.value = value;
            this.paramClass = paramClass;
        }
    }

    protected static class ParamDesc {
        public PropertyDesc propertyDesc;
        public String name;
        public Class<?> paramClass;
        public ParameterType paramType;
        public ValueType valueType;

        protected ParamDesc() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ParameterType {
        IN,
        IN_OUT,
        OUT,
        RESULT_SET;

    }
}

